#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C expr-flat:op8
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L op8.old <(echo \
'$ shopt -s expand_aliases
$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc flat; }
$ alias test-expr='\''test-expr -b alpha -C'\''
$ diff-expr() { diff -u100 -L "$1" <(test-expr "$1") -L "$2" <(test-expr "$2") && echo OK; }
$ test-expr '\''(((a >= b) != c) && d) || e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 cmp_op(ge)
 3 call_builtin(c)
 4 cmp_op(ne)
 5 jump_false*(9)
 6 call_builtin(d)
 7 make_bool()
 8 jump_true(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''(((a >= b) != c) && d) || e'\'' '\''((a >= b) != c) && d || e'\''
OK
$ diff-expr '\''(((a >= b) != c) && d) || e'\'' '\''(a >= b) != c && d || e'\''
OK
$ diff-expr '\''(((a >= b) != c) && d) || e'\'' '\''a >= b != c && d || e'\''
OK
$ diff-expr '\''(((a >= b) != c) && d) || e'\'' '\''(a >= b != c) && d || e'\''
OK
$ diff-expr '\''(((a >= b) != c) && d) || e'\'' '\''((a >= b) != c && d) || e'\''
OK
$ diff-expr '\''(((a >= b) != c) && d) || e'\'' '\''(a >= b != c && d) || e'\''
OK
$ diff-expr '\''(((a >= b) != c) && d) || e'\'' '\''((a >= b != c) && d) || e'\''
OK
$ test-expr '\''a >= (((b != c) && d) || e)'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 call_builtin(c)
 3 cmp_op(ne)
 4 jump_false*(8)
 5 call_builtin(d)
 6 make_bool()
 7 jump_true(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ge)
$ diff-expr '\''a >= (((b != c) && d) || e)'\'' '\''a >= ((b != c) && d || e)'\''
OK
$ diff-expr '\''a >= (((b != c) && d) || e)'\'' '\''a >= (b != c && d || e)'\''
OK
$ diff-expr '\''a >= (((b != c) && d) || e)'\'' '\''a >= ((b != c && d) || e)'\''
OK
$ test-expr '\''(a >= ((b != c) && d)) || e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 call_builtin(c)
 3 cmp_op(ne)
 4 jump_false(7)
 5 call_builtin(d)
 6 make_bool()
 7 cmp_op(ge)
 8 jump_true(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''(a >= ((b != c) && d)) || e'\'' '\''a >= ((b != c) && d) || e'\''
OK
$ diff-expr '\''(a >= ((b != c) && d)) || e'\'' '\''a >= (b != c && d) || e'\''
OK
$ diff-expr '\''(a >= ((b != c) && d)) || e'\'' '\''(a >= (b != c && d)) || e'\''
OK
$ test-expr '\''(a >= b) != ((c && d) || e)'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 cmp_op(ge)
 3 call_builtin(c)
 4 jump_false*(8)
 5 call_builtin(d)
 6 make_bool()
 7 jump_true(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ne)
$ diff-expr '\''(a >= b) != ((c && d) || e)'\'' '\''a >= b != ((c && d) || e)'\''
OK
$ diff-expr '\''(a >= b) != ((c && d) || e)'\'' '\''a >= b != (c && d || e)'\''
OK
$ diff-expr '\''(a >= b) != ((c && d) || e)'\'' '\''(a >= b) != (c && d || e)'\''
OK
$ test-expr '\''a >= (b != ((c && d) || e))'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 call_builtin(c)
 3 jump_false*(7)
 4 call_builtin(d)
 5 make_bool()
 6 jump_true(9)
 7 call_builtin(e)
 8 make_bool()
 9 cmp_op(ne)
10 cmp_op(ge)
$ diff-expr '\''a >= (b != ((c && d) || e))'\'' '\''a >= (b != (c && d || e))'\''
OK
$ test-expr '\''((a >= (b != c)) && d) || e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 call_builtin(c)
 3 cmp_op(ne)
 4 cmp_op(ge)
 5 jump_false*(9)
 6 call_builtin(d)
 7 make_bool()
 8 jump_true(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''((a >= (b != c)) && d) || e'\'' '\''(a >= (b != c)) && d || e'\''
OK
$ diff-expr '\''((a >= (b != c)) && d) || e'\'' '\''a >= (b != c) && d || e'\''
OK
$ diff-expr '\''((a >= (b != c)) && d) || e'\'' '\''(a >= (b != c) && d) || e'\''
OK
$ test-expr '\''a >= ((b != (c && d)) || e)'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 call_builtin(c)
 3 jump_false(6)
 4 call_builtin(d)
 5 make_bool()
 6 cmp_op(ne)
 7 jump_true(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ge)
$ diff-expr '\''a >= ((b != (c && d)) || e)'\'' '\''a >= (b != (c && d) || e)'\''
OK
$ test-expr '\''((a >= b) != (c && d)) || e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 cmp_op(ge)
 3 call_builtin(c)
 4 jump_false(7)
 5 call_builtin(d)
 6 make_bool()
 7 cmp_op(ne)
 8 jump_true(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''((a >= b) != (c && d)) || e'\'' '\''(a >= b) != (c && d) || e'\''
OK
$ diff-expr '\''((a >= b) != (c && d)) || e'\'' '\''a >= b != (c && d) || e'\''
OK
$ diff-expr '\''((a >= b) != (c && d)) || e'\'' '\''(a >= b != (c && d)) || e'\''
OK
$ test-expr '\''((a >= b) != c) && (d || e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 jump_true(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''((a >= b) != c) && (d || e)'\'' '\''(a >= b) != c && (d || e)'\''
OK
$ diff-expr '\''((a >= b) != c) && (d || e)'\'' '\''a >= b != c && (d || e)'\''
OK
$ diff-expr '\''((a >= b) != c) && (d || e)'\'' '\''(a >= b != c) && (d || e)'\''
OK
$ test-expr '\''a >= ((b != c) && (d || e))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_false(9)
5 call_builtin(d)
6 jump_true(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ge)
$ diff-expr '\''a >= ((b != c) && (d || e))'\'' '\''a >= (b != c && (d || e))'\''
OK
$ test-expr '\''(a >= (b != (c && d))) || e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 call_builtin(c)
 3 jump_false(6)
 4 call_builtin(d)
 5 make_bool()
 6 cmp_op(ne)
 7 cmp_op(ge)
 8 jump_true(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''(a >= (b != (c && d))) || e'\'' '\''a >= (b != (c && d)) || e'\''
OK
$ test-expr '\''(a >= (b != c)) && (d || e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 jump_true(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''(a >= (b != c)) && (d || e)'\'' '\''a >= (b != c) && (d || e)'\''
OK
$ test-expr '\''(a >= b) != (c && (d || e))'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(c)
4 jump_false(9)
5 call_builtin(d)
6 jump_true(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ne)
$ diff-expr '\''(a >= b) != (c && (d || e))'\'' '\''a >= b != (c && (d || e))'\''
OK
$ test-expr '\''a >= (b != (c && (d || e)))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 jump_false(8)
4 call_builtin(d)
5 jump_true(8)
6 call_builtin(e)
7 make_bool()
8 cmp_op(ne)
9 cmp_op(ge)
$ test-expr '\''(((a >= b) != c) || d) && e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 cmp_op(ge)
 3 call_builtin(c)
 4 cmp_op(ne)
 5 jump_true*(9)
 6 call_builtin(d)
 7 make_bool()
 8 jump_false(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''(((a >= b) != c) || d) && e'\'' '\''((a >= b) != c || d) && e'\''
OK
$ diff-expr '\''(((a >= b) != c) || d) && e'\'' '\''(a >= b != c || d) && e'\''
OK
$ diff-expr '\''(((a >= b) != c) || d) && e'\'' '\''((a >= b != c) || d) && e'\''
OK
$ test-expr '\''a >= (((b != c) || d) && e)'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 call_builtin(c)
 3 cmp_op(ne)
 4 jump_true*(8)
 5 call_builtin(d)
 6 make_bool()
 7 jump_false(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ge)
$ diff-expr '\''a >= (((b != c) || d) && e)'\'' '\''a >= ((b != c || d) && e)'\''
OK
$ test-expr '\''(a >= ((b != c) || d)) && e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 call_builtin(c)
 3 cmp_op(ne)
 4 jump_true(7)
 5 call_builtin(d)
 6 make_bool()
 7 cmp_op(ge)
 8 jump_false(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''(a >= ((b != c) || d)) && e'\'' '\''a >= ((b != c) || d) && e'\''
OK
$ diff-expr '\''(a >= ((b != c) || d)) && e'\'' '\''a >= (b != c || d) && e'\''
OK
$ diff-expr '\''(a >= ((b != c) || d)) && e'\'' '\''(a >= (b != c || d)) && e'\''
OK
$ test-expr '\''(a >= b) != ((c || d) && e)'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 cmp_op(ge)
 3 call_builtin(c)
 4 jump_true*(8)
 5 call_builtin(d)
 6 make_bool()
 7 jump_false(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ne)
$ diff-expr '\''(a >= b) != ((c || d) && e)'\'' '\''a >= b != ((c || d) && e)'\''
OK
$ test-expr '\''a >= (b != ((c || d) && e))'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 call_builtin(c)
 3 jump_true*(7)
 4 call_builtin(d)
 5 make_bool()
 6 jump_false(9)
 7 call_builtin(e)
 8 make_bool()
 9 cmp_op(ne)
10 cmp_op(ge)
$ test-expr '\''((a >= (b != c)) || d) && e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 call_builtin(c)
 3 cmp_op(ne)
 4 cmp_op(ge)
 5 jump_true*(9)
 6 call_builtin(d)
 7 make_bool()
 8 jump_false(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''((a >= (b != c)) || d) && e'\'' '\''(a >= (b != c) || d) && e'\''
OK
$ test-expr '\''a >= ((b != (c || d)) && e)'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 call_builtin(c)
 3 jump_true(6)
 4 call_builtin(d)
 5 make_bool()
 6 cmp_op(ne)
 7 jump_false(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ge)
$ diff-expr '\''a >= ((b != (c || d)) && e)'\'' '\''a >= (b != (c || d) && e)'\''
OK
$ test-expr '\''((a >= b) != (c || d)) && e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 cmp_op(ge)
 3 call_builtin(c)
 4 jump_true(7)
 5 call_builtin(d)
 6 make_bool()
 7 cmp_op(ne)
 8 jump_false(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''((a >= b) != (c || d)) && e'\'' '\''(a >= b) != (c || d) && e'\''
OK
$ diff-expr '\''((a >= b) != (c || d)) && e'\'' '\''a >= b != (c || d) && e'\''
OK
$ diff-expr '\''((a >= b) != (c || d)) && e'\'' '\''(a >= b != (c || d)) && e'\''
OK
$ test-expr '\''((a >= b) != c) || (d && e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 jump_false(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''((a >= b) != c) || (d && e)'\'' '\''(a >= b) != c || (d && e)'\''
OK
$ diff-expr '\''((a >= b) != c) || (d && e)'\'' '\''a >= b != c || (d && e)'\''
OK
$ diff-expr '\''((a >= b) != c) || (d && e)'\'' '\''a >= b != c || d && e'\''
OK
$ diff-expr '\''((a >= b) != c) || (d && e)'\'' '\''(a >= b) != c || d && e'\''
OK
$ diff-expr '\''((a >= b) != c) || (d && e)'\'' '\''(a >= b != c) || (d && e)'\''
OK
$ diff-expr '\''((a >= b) != c) || (d && e)'\'' '\''(a >= b != c) || d && e'\''
OK
$ diff-expr '\''((a >= b) != c) || (d && e)'\'' '\''((a >= b) != c) || d && e'\''
OK
$ test-expr '\''a >= ((b != c) || (d && e))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 jump_true(9)
5 call_builtin(d)
6 jump_false(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ge)
$ diff-expr '\''a >= ((b != c) || (d && e))'\'' '\''a >= (b != c || (d && e))'\''
OK
$ diff-expr '\''a >= ((b != c) || (d && e))'\'' '\''a >= (b != c || d && e)'\''
OK
$ diff-expr '\''a >= ((b != c) || (d && e))'\'' '\''a >= ((b != c) || d && e)'\''
OK
$ test-expr '\''(a >= (b != (c || d))) && e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 call_builtin(c)
 3 jump_true(6)
 4 call_builtin(d)
 5 make_bool()
 6 cmp_op(ne)
 7 cmp_op(ge)
 8 jump_false(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''(a >= (b != (c || d))) && e'\'' '\''a >= (b != (c || d)) && e'\''
OK
$ test-expr '\''(a >= (b != c)) || (d && e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ne)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 jump_false(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''(a >= (b != c)) || (d && e)'\'' '\''a >= (b != c) || (d && e)'\''
OK
$ diff-expr '\''(a >= (b != c)) || (d && e)'\'' '\''a >= (b != c) || d && e'\''
OK
$ diff-expr '\''(a >= (b != c)) || (d && e)'\'' '\''(a >= (b != c)) || d && e'\''
OK
$ test-expr '\''(a >= b) != (c || (d && e))'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 call_builtin(c)
4 jump_true(9)
5 call_builtin(d)
6 jump_false(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ne)
$ diff-expr '\''(a >= b) != (c || (d && e))'\'' '\''a >= b != (c || (d && e))'\''
OK
$ diff-expr '\''(a >= b) != (c || (d && e))'\'' '\''a >= b != (c || d && e)'\''
OK
$ diff-expr '\''(a >= b) != (c || (d && e))'\'' '\''(a >= b) != (c || d && e)'\''
OK
$ test-expr '\''a >= (b != (c || (d && e)))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 jump_true(8)
4 call_builtin(d)
5 jump_false(8)
6 call_builtin(e)
7 make_bool()
8 cmp_op(ne)
9 cmp_op(ge)
$ diff-expr '\''a >= (b != (c || (d && e)))'\'' '\''a >= (b != (c || d && e))'\''
OK
$ test-expr '\''(((a >= b) && c) != d) || e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 cmp_op(ge)
 3 jump_false(6)
 4 call_builtin(c)
 5 make_bool()
 6 call_builtin(d)
 7 cmp_op(ne)
 8 jump_true(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''(((a >= b) && c) != d) || e'\'' '\''((a >= b) && c) != d || e'\''
OK
$ diff-expr '\''(((a >= b) && c) != d) || e'\'' '\''(a >= b && c) != d || e'\''
OK
$ diff-expr '\''(((a >= b) && c) != d) || e'\'' '\''((a >= b && c) != d) || e'\''
OK
$ test-expr '\''a >= (((b && c) != d) || e)'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_false(5)
 3 call_builtin(c)
 4 make_bool()
 5 call_builtin(d)
 6 cmp_op(ne)
 7 jump_true(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ge)
$ diff-expr '\''a >= (((b && c) != d) || e)'\'' '\''a >= ((b && c) != d || e)'\''
OK
$ test-expr '\''(a >= ((b && c) != d)) || e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_false(5)
 3 call_builtin(c)
 4 make_bool()
 5 call_builtin(d)
 6 cmp_op(ne)
 7 cmp_op(ge)
 8 jump_true(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''(a >= ((b && c) != d)) || e'\'' '\''a >= ((b && c) != d) || e'\''
OK
$ test-expr '\''(a >= b) && ((c != d) || e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
7 jump_true(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''(a >= b) && ((c != d) || e)'\'' '\''a >= b && ((c != d) || e)'\''
OK
$ diff-expr '\''(a >= b) && ((c != d) || e)'\'' '\''a >= b && (c != d || e)'\''
OK
$ diff-expr '\''(a >= b) && ((c != d) || e)'\'' '\''(a >= b) && (c != d || e)'\''
OK
$ test-expr '\''a >= (b && ((c != d) || e))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(9)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 jump_true(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ge)
$ diff-expr '\''a >= (b && ((c != d) || e))'\'' '\''a >= (b && (c != d || e))'\''
OK
$ test-expr '\''((a >= (b && c)) != d) || e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_false(5)
 3 call_builtin(c)
 4 make_bool()
 5 cmp_op(ge)
 6 call_builtin(d)
 7 cmp_op(ne)
 8 jump_true(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''((a >= (b && c)) != d) || e'\'' '\''(a >= (b && c)) != d || e'\''
OK
$ diff-expr '\''((a >= (b && c)) != d) || e'\'' '\''a >= (b && c) != d || e'\''
OK
$ diff-expr '\''((a >= (b && c)) != d) || e'\'' '\''(a >= (b && c) != d) || e'\''
OK
$ test-expr '\''a >= ((b && (c != d)) || e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false*(7)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 jump_true(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ge)
$ diff-expr '\''a >= ((b && (c != d)) || e)'\'' '\''a >= (b && (c != d) || e)'\''
OK
$ diff-expr '\''a >= ((b && (c != d)) || e)'\'' '\''a >= (b && c != d || e)'\''
OK
$ diff-expr '\''a >= ((b && (c != d)) || e)'\'' '\''a >= ((b && c != d) || e)'\''
OK
$ test-expr '\''((a >= b) && (c != d)) || e'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false*(8)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
7 jump_true(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''((a >= b) && (c != d)) || e'\'' '\''(a >= b) && (c != d) || e'\''
OK
$ diff-expr '\''((a >= b) && (c != d)) || e'\'' '\''a >= b && (c != d) || e'\''
OK
$ diff-expr '\''((a >= b) && (c != d)) || e'\'' '\''a >= b && c != d || e'\''
OK
$ diff-expr '\''((a >= b) && (c != d)) || e'\'' '\''(a >= b) && c != d || e'\''
OK
$ diff-expr '\''((a >= b) && (c != d)) || e'\'' '\''(a >= b && (c != d)) || e'\''
OK
$ diff-expr '\''((a >= b) && (c != d)) || e'\'' '\''(a >= b && c != d) || e'\''
OK
$ diff-expr '\''((a >= b) && (c != d)) || e'\'' '\''((a >= b) && c != d) || e'\''
OK
$ test-expr '\''((a >= b) && c) != (d || e)'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 cmp_op(ge)
 3 jump_false(6)
 4 call_builtin(c)
 5 make_bool()
 6 call_builtin(d)
 7 jump_true(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ne)
$ diff-expr '\''((a >= b) && c) != (d || e)'\'' '\''(a >= b && c) != (d || e)'\''
OK
$ test-expr '\''a >= ((b && c) != (d || e))'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_false(5)
 3 call_builtin(c)
 4 make_bool()
 5 call_builtin(d)
 6 jump_true(9)
 7 call_builtin(e)
 8 make_bool()
 9 cmp_op(ne)
10 cmp_op(ge)
$ test-expr '\''(a >= (b && (c != d))) || e'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
7 jump_true(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''(a >= (b && (c != d))) || e'\'' '\''a >= (b && (c != d)) || e'\''
OK
$ diff-expr '\''(a >= (b && (c != d))) || e'\'' '\''a >= (b && c != d) || e'\''
OK
$ diff-expr '\''(a >= (b && (c != d))) || e'\'' '\''(a >= (b && c != d)) || e'\''
OK
$ test-expr '\''(a >= (b && c)) != (d || e)'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_false(5)
 3 call_builtin(c)
 4 make_bool()
 5 cmp_op(ge)
 6 call_builtin(d)
 7 jump_true(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ne)
$ diff-expr '\''(a >= (b && c)) != (d || e)'\'' '\''a >= (b && c) != (d || e)'\''
OK
$ test-expr '\''(a >= b) && (c != (d || e))'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(d)
6 jump_true(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ne)
$ diff-expr '\''(a >= b) && (c != (d || e))'\'' '\''a >= b && (c != (d || e))'\''
OK
$ diff-expr '\''(a >= b) && (c != (d || e))'\'' '\''a >= b && c != (d || e)'\''
OK
$ diff-expr '\''(a >= b) && (c != (d || e))'\'' '\''(a >= b) && c != (d || e)'\''
OK
$ test-expr '\''a >= (b && (c != (d || e)))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(9)
3 call_builtin(c)
4 call_builtin(d)
5 jump_true(8)
6 call_builtin(e)
7 make_bool()
8 cmp_op(ne)
9 cmp_op(ge)
$ diff-expr '\''a >= (b && (c != (d || e)))'\'' '\''a >= (b && c != (d || e))'\''
OK
$ test-expr '\''(((a >= b) && c) || d) != e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 cmp_op(ge)
 3 jump_false*(7)
 4 call_builtin(c)
 5 make_bool()
 6 jump_true(9)
 7 call_builtin(d)
 8 make_bool()
 9 call_builtin(e)
10 cmp_op(ne)
$ diff-expr '\''(((a >= b) && c) || d) != e'\'' '\''((a >= b) && c || d) != e'\''
OK
$ diff-expr '\''(((a >= b) && c) || d) != e'\'' '\''(a >= b && c || d) != e'\''
OK
$ diff-expr '\''(((a >= b) && c) || d) != e'\'' '\''((a >= b && c) || d) != e'\''
OK
$ test-expr '\''a >= (((b && c) || d) != e)'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_false*(6)
 3 call_builtin(c)
 4 make_bool()
 5 jump_true(8)
 6 call_builtin(d)
 7 make_bool()
 8 call_builtin(e)
 9 cmp_op(ne)
10 cmp_op(ge)
$ diff-expr '\''a >= (((b && c) || d) != e)'\'' '\''a >= ((b && c || d) != e)'\''
OK
$ test-expr '\''(a >= ((b && c) || d)) != e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_false*(6)
 3 call_builtin(c)
 4 make_bool()
 5 jump_true(8)
 6 call_builtin(d)
 7 make_bool()
 8 cmp_op(ge)
 9 call_builtin(e)
10 cmp_op(ne)
$ diff-expr '\''(a >= ((b && c) || d)) != e'\'' '\''a >= ((b && c) || d) != e'\''
OK
$ diff-expr '\''(a >= ((b && c) || d)) != e'\'' '\''a >= (b && c || d) != e'\''
OK
$ diff-expr '\''(a >= ((b && c) || d)) != e'\'' '\''(a >= (b && c || d)) != e'\''
OK
$ test-expr '\''(a >= b) && ((c || d) != e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(c)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''(a >= b) && ((c || d) != e)'\'' '\''a >= b && ((c || d) != e)'\''
OK
$ diff-expr '\''(a >= b) && ((c || d) != e)'\'' '\''a >= b && (c || d) != e'\''
OK
$ diff-expr '\''(a >= b) && ((c || d) != e)'\'' '\''(a >= b) && (c || d) != e'\''
OK
$ test-expr '\''a >= (b && ((c || d) != e))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(9)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 call_builtin(e)
8 cmp_op(ne)
9 cmp_op(ge)
$ diff-expr '\''a >= (b && ((c || d) != e))'\'' '\''a >= (b && (c || d) != e)'\''
OK
$ test-expr '\''((a >= (b && c)) || d) != e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_false(5)
 3 call_builtin(c)
 4 make_bool()
 5 cmp_op(ge)
 6 jump_true(9)
 7 call_builtin(d)
 8 make_bool()
 9 call_builtin(e)
10 cmp_op(ne)
$ diff-expr '\''((a >= (b && c)) || d) != e'\'' '\''(a >= (b && c) || d) != e'\''
OK
$ test-expr '\''a >= ((b && (c || d)) != e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(7)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 call_builtin(e)
8 cmp_op(ne)
9 cmp_op(ge)
$ test-expr '\''((a >= b) && (c || d)) != e'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(8)
4 call_builtin(c)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''((a >= b) && (c || d)) != e'\'' '\''(a >= b && (c || d)) != e'\''
OK
$ test-expr '\''((a >= b) && c) || (d != e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false*(7)
4 call_builtin(c)
5 make_bool()
6 jump_true(eos)
7 call_builtin(d)
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''((a >= b) && c) || (d != e)'\'' '\''(a >= b) && c || (d != e)'\''
OK
$ diff-expr '\''((a >= b) && c) || (d != e)'\'' '\''a >= b && c || (d != e)'\''
OK
$ diff-expr '\''((a >= b) && c) || (d != e)'\'' '\''a >= b && c || d != e'\''
OK
$ diff-expr '\''((a >= b) && c) || (d != e)'\'' '\''(a >= b) && c || d != e'\''
OK
$ diff-expr '\''((a >= b) && c) || (d != e)'\'' '\''(a >= b && c) || (d != e)'\''
OK
$ diff-expr '\''((a >= b) && c) || (d != e)'\'' '\''(a >= b && c) || d != e'\''
OK
$ diff-expr '\''((a >= b) && c) || (d != e)'\'' '\''((a >= b) && c) || d != e'\''
OK
$ test-expr '\''a >= ((b && c) || (d != e))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(9)
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ne)
9 cmp_op(ge)
$ diff-expr '\''a >= ((b && c) || (d != e))'\'' '\''a >= (b && c || (d != e))'\''
OK
$ diff-expr '\''a >= ((b && c) || (d != e))'\'' '\''a >= (b && c || d != e)'\''
OK
$ diff-expr '\''a >= ((b && c) || (d != e))'\'' '\''a >= ((b && c) || d != e)'\''
OK
$ test-expr '\''(a >= (b && (c || d))) != e'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(7)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''(a >= (b && (c || d))) != e'\'' '\''a >= (b && (c || d)) != e'\''
OK
$ test-expr '\''(a >= (b && c)) || (d != e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 jump_true(eos)
7 call_builtin(d)
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''(a >= (b && c)) || (d != e)'\'' '\''a >= (b && c) || (d != e)'\''
OK
$ diff-expr '\''(a >= (b && c)) || (d != e)'\'' '\''a >= (b && c) || d != e'\''
OK
$ diff-expr '\''(a >= (b && c)) || (d != e)'\'' '\''(a >= (b && c)) || d != e'\''
OK
$ test-expr '\''(a >= b) && (c || (d != e))'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_false(eos)
4 call_builtin(c)
5 jump_true(eos)
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ne)
$ diff-expr '\''(a >= b) && (c || (d != e))'\'' '\''a >= b && (c || (d != e))'\''
OK
$ diff-expr '\''(a >= b) && (c || (d != e))'\'' '\''a >= b && (c || d != e)'\''
OK
$ diff-expr '\''(a >= b) && (c || (d != e))'\'' '\''(a >= b) && (c || d != e)'\''
OK
$ test-expr '\''a >= (b && (c || (d != e)))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(8)
3 call_builtin(c)
4 jump_true(8)
5 call_builtin(d)
6 call_builtin(e)
7 cmp_op(ne)
8 cmp_op(ge)
$ diff-expr '\''a >= (b && (c || (d != e)))'\'' '\''a >= (b && (c || d != e))'\''
OK
$ test-expr '\''(((a >= b) || c) != d) && e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 cmp_op(ge)
 3 jump_true(6)
 4 call_builtin(c)
 5 make_bool()
 6 call_builtin(d)
 7 cmp_op(ne)
 8 jump_false(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''(((a >= b) || c) != d) && e'\'' '\''((a >= b) || c) != d && e'\''
OK
$ diff-expr '\''(((a >= b) || c) != d) && e'\'' '\''(a >= b || c) != d && e'\''
OK
$ diff-expr '\''(((a >= b) || c) != d) && e'\'' '\''((a >= b || c) != d) && e'\''
OK
$ test-expr '\''a >= (((b || c) != d) && e)'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_true(5)
 3 call_builtin(c)
 4 make_bool()
 5 call_builtin(d)
 6 cmp_op(ne)
 7 jump_false(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ge)
$ diff-expr '\''a >= (((b || c) != d) && e)'\'' '\''a >= ((b || c) != d && e)'\''
OK
$ test-expr '\''(a >= ((b || c) != d)) && e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_true(5)
 3 call_builtin(c)
 4 make_bool()
 5 call_builtin(d)
 6 cmp_op(ne)
 7 cmp_op(ge)
 8 jump_false(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''(a >= ((b || c) != d)) && e'\'' '\''a >= ((b || c) != d) && e'\''
OK
$ test-expr '\''(a >= b) || ((c != d) && e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
7 jump_false(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''(a >= b) || ((c != d) && e)'\'' '\''a >= b || ((c != d) && e)'\''
OK
$ diff-expr '\''(a >= b) || ((c != d) && e)'\'' '\''a >= b || (c != d) && e'\''
OK
$ diff-expr '\''(a >= b) || ((c != d) && e)'\'' '\''a >= b || c != d && e'\''
OK
$ diff-expr '\''(a >= b) || ((c != d) && e)'\'' '\''a >= b || (c != d && e)'\''
OK
$ diff-expr '\''(a >= b) || ((c != d) && e)'\'' '\''(a >= b) || (c != d) && e'\''
OK
$ diff-expr '\''(a >= b) || ((c != d) && e)'\'' '\''(a >= b) || c != d && e'\''
OK
$ diff-expr '\''(a >= b) || ((c != d) && e)'\'' '\''(a >= b) || (c != d && e)'\''
OK
$ test-expr '\''a >= (b || ((c != d) && e))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(9)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 jump_false(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ge)
$ diff-expr '\''a >= (b || ((c != d) && e))'\'' '\''a >= (b || (c != d) && e)'\''
OK
$ diff-expr '\''a >= (b || ((c != d) && e))'\'' '\''a >= (b || c != d && e)'\''
OK
$ diff-expr '\''a >= (b || ((c != d) && e))'\'' '\''a >= (b || (c != d && e))'\''
OK
$ test-expr '\''((a >= (b || c)) != d) && e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_true(5)
 3 call_builtin(c)
 4 make_bool()
 5 cmp_op(ge)
 6 call_builtin(d)
 7 cmp_op(ne)
 8 jump_false(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''((a >= (b || c)) != d) && e'\'' '\''(a >= (b || c)) != d && e'\''
OK
$ diff-expr '\''((a >= (b || c)) != d) && e'\'' '\''a >= (b || c) != d && e'\''
OK
$ diff-expr '\''((a >= (b || c)) != d) && e'\'' '\''(a >= (b || c) != d) && e'\''
OK
$ test-expr '\''a >= ((b || (c != d)) && e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true*(7)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 jump_false(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ge)
$ diff-expr '\''a >= ((b || (c != d)) && e)'\'' '\''a >= ((b || c != d) && e)'\''
OK
$ test-expr '\''((a >= b) || (c != d)) && e'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true*(8)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
7 jump_false(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''((a >= b) || (c != d)) && e'\'' '\''(a >= b || (c != d)) && e'\''
OK
$ diff-expr '\''((a >= b) || (c != d)) && e'\'' '\''(a >= b || c != d) && e'\''
OK
$ diff-expr '\''((a >= b) || (c != d)) && e'\'' '\''((a >= b) || c != d) && e'\''
OK
$ test-expr '\''((a >= b) || c) != (d && e)'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 cmp_op(ge)
 3 jump_true(6)
 4 call_builtin(c)
 5 make_bool()
 6 call_builtin(d)
 7 jump_false(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ne)
$ diff-expr '\''((a >= b) || c) != (d && e)'\'' '\''(a >= b || c) != (d && e)'\''
OK
$ test-expr '\''a >= ((b || c) != (d && e))'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_true(5)
 3 call_builtin(c)
 4 make_bool()
 5 call_builtin(d)
 6 jump_false(9)
 7 call_builtin(e)
 8 make_bool()
 9 cmp_op(ne)
10 cmp_op(ge)
$ test-expr '\''(a >= (b || (c != d))) && e'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
7 jump_false(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''(a >= (b || (c != d))) && e'\'' '\''a >= (b || (c != d)) && e'\''
OK
$ diff-expr '\''(a >= (b || (c != d))) && e'\'' '\''a >= (b || c != d) && e'\''
OK
$ diff-expr '\''(a >= (b || (c != d))) && e'\'' '\''(a >= (b || c != d)) && e'\''
OK
$ test-expr '\''(a >= (b || c)) != (d && e)'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_true(5)
 3 call_builtin(c)
 4 make_bool()
 5 cmp_op(ge)
 6 call_builtin(d)
 7 jump_false(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ne)
$ diff-expr '\''(a >= (b || c)) != (d && e)'\'' '\''a >= (b || c) != (d && e)'\''
OK
$ test-expr '\''(a >= b) || (c != (d && e))'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(d)
6 jump_false(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ne)
$ diff-expr '\''(a >= b) || (c != (d && e))'\'' '\''a >= b || (c != (d && e))'\''
OK
$ diff-expr '\''(a >= b) || (c != (d && e))'\'' '\''a >= b || c != (d && e)'\''
OK
$ diff-expr '\''(a >= b) || (c != (d && e))'\'' '\''(a >= b) || c != (d && e)'\''
OK
$ test-expr '\''a >= (b || (c != (d && e)))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(9)
3 call_builtin(c)
4 call_builtin(d)
5 jump_false(8)
6 call_builtin(e)
7 make_bool()
8 cmp_op(ne)
9 cmp_op(ge)
$ diff-expr '\''a >= (b || (c != (d && e)))'\'' '\''a >= (b || c != (d && e))'\''
OK
$ test-expr '\''(((a >= b) || c) && d) != e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 cmp_op(ge)
 3 jump_true*(7)
 4 call_builtin(c)
 5 make_bool()
 6 jump_false(9)
 7 call_builtin(d)
 8 make_bool()
 9 call_builtin(e)
10 cmp_op(ne)
$ diff-expr '\''(((a >= b) || c) && d) != e'\'' '\''((a >= b || c) && d) != e'\''
OK
$ test-expr '\''a >= (((b || c) && d) != e)'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_true*(6)
 3 call_builtin(c)
 4 make_bool()
 5 jump_false(8)
 6 call_builtin(d)
 7 make_bool()
 8 call_builtin(e)
 9 cmp_op(ne)
10 cmp_op(ge)
$ test-expr '\''(a >= ((b || c) && d)) != e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_true*(6)
 3 call_builtin(c)
 4 make_bool()
 5 jump_false(8)
 6 call_builtin(d)
 7 make_bool()
 8 cmp_op(ge)
 9 call_builtin(e)
10 cmp_op(ne)
$ diff-expr '\''(a >= ((b || c) && d)) != e'\'' '\''a >= ((b || c) && d) != e'\''
OK
$ test-expr '\''(a >= b) || ((c && d) != e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(c)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''(a >= b) || ((c && d) != e)'\'' '\''a >= b || ((c && d) != e)'\''
OK
$ diff-expr '\''(a >= b) || ((c && d) != e)'\'' '\''a >= b || (c && d) != e'\''
OK
$ diff-expr '\''(a >= b) || ((c && d) != e)'\'' '\''(a >= b) || (c && d) != e'\''
OK
$ test-expr '\''a >= (b || ((c && d) != e))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(9)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 call_builtin(e)
8 cmp_op(ne)
9 cmp_op(ge)
$ diff-expr '\''a >= (b || ((c && d) != e))'\'' '\''a >= (b || (c && d) != e)'\''
OK
$ test-expr '\''((a >= (b || c)) && d) != e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_true(5)
 3 call_builtin(c)
 4 make_bool()
 5 cmp_op(ge)
 6 jump_false(9)
 7 call_builtin(d)
 8 make_bool()
 9 call_builtin(e)
10 cmp_op(ne)
$ diff-expr '\''((a >= (b || c)) && d) != e'\'' '\''(a >= (b || c) && d) != e'\''
OK
$ test-expr '\''a >= ((b || (c && d)) != e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(7)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 call_builtin(e)
8 cmp_op(ne)
9 cmp_op(ge)
$ diff-expr '\''a >= ((b || (c && d)) != e)'\'' '\''a >= ((b || c && d) != e)'\''
OK
$ test-expr '\''((a >= b) || (c && d)) != e'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(8)
4 call_builtin(c)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''((a >= b) || (c && d)) != e'\'' '\''(a >= b || (c && d)) != e'\''
OK
$ diff-expr '\''((a >= b) || (c && d)) != e'\'' '\''(a >= b || c && d) != e'\''
OK
$ diff-expr '\''((a >= b) || (c && d)) != e'\'' '\''((a >= b) || c && d) != e'\''
OK
$ test-expr '\''((a >= b) || c) && (d != e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true*(7)
4 call_builtin(c)
5 make_bool()
6 jump_false(eos)
7 call_builtin(d)
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''((a >= b) || c) && (d != e)'\'' '\''(a >= b || c) && (d != e)'\''
OK
$ diff-expr '\''((a >= b) || c) && (d != e)'\'' '\''(a >= b || c) && d != e'\''
OK
$ diff-expr '\''((a >= b) || c) && (d != e)'\'' '\''((a >= b) || c) && d != e'\''
OK
$ test-expr '\''a >= ((b || c) && (d != e))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(9)
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ne)
9 cmp_op(ge)
$ diff-expr '\''a >= ((b || c) && (d != e))'\'' '\''a >= ((b || c) && d != e)'\''
OK
$ test-expr '\''(a >= (b || (c && d))) != e'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(7)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''(a >= (b || (c && d))) != e'\'' '\''a >= (b || (c && d)) != e'\''
OK
$ diff-expr '\''(a >= (b || (c && d))) != e'\'' '\''a >= (b || c && d) != e'\''
OK
$ diff-expr '\''(a >= (b || (c && d))) != e'\'' '\''(a >= (b || c && d)) != e'\''
OK
$ test-expr '\''(a >= (b || c)) && (d != e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ge)
6 jump_false(eos)
7 call_builtin(d)
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''(a >= (b || c)) && (d != e)'\'' '\''a >= (b || c) && (d != e)'\''
OK
$ diff-expr '\''(a >= (b || c)) && (d != e)'\'' '\''a >= (b || c) && d != e'\''
OK
$ diff-expr '\''(a >= (b || c)) && (d != e)'\'' '\''(a >= (b || c)) && d != e'\''
OK
$ test-expr '\''(a >= b) || (c && (d != e))'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ge)
3 jump_true(eos)
4 call_builtin(c)
5 jump_false(eos)
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ne)
$ diff-expr '\''(a >= b) || (c && (d != e))'\'' '\''a >= b || (c && (d != e))'\''
OK
$ diff-expr '\''(a >= b) || (c && (d != e))'\'' '\''a >= b || c && (d != e)'\''
OK
$ diff-expr '\''(a >= b) || (c && (d != e))'\'' '\''a >= b || c && d != e'\''
OK
$ diff-expr '\''(a >= b) || (c && (d != e))'\'' '\''a >= b || (c && d != e)'\''
OK
$ diff-expr '\''(a >= b) || (c && (d != e))'\'' '\''(a >= b) || c && (d != e)'\''
OK
$ diff-expr '\''(a >= b) || (c && (d != e))'\'' '\''(a >= b) || c && d != e'\''
OK
$ diff-expr '\''(a >= b) || (c && (d != e))'\'' '\''(a >= b) || (c && d != e)'\''
OK
$ test-expr '\''a >= (b || (c && (d != e)))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(8)
3 call_builtin(c)
4 jump_false(8)
5 call_builtin(d)
6 call_builtin(e)
7 cmp_op(ne)
8 cmp_op(ge)
$ diff-expr '\''a >= (b || (c && (d != e)))'\'' '\''a >= (b || c && (d != e))'\''
OK
$ diff-expr '\''a >= (b || (c && (d != e)))'\'' '\''a >= (b || c && d != e)'\''
OK
$ diff-expr '\''a >= (b || (c && (d != e)))'\'' '\''a >= (b || (c && d != e))'\''
OK
$ test-expr '\''(((a != b) >= c) && d) || e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 cmp_op(ne)
 3 call_builtin(c)
 4 cmp_op(ge)
 5 jump_false*(9)
 6 call_builtin(d)
 7 make_bool()
 8 jump_true(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''(((a != b) >= c) && d) || e'\'' '\''((a != b) >= c) && d || e'\''
OK
$ diff-expr '\''(((a != b) >= c) && d) || e'\'' '\''(a != b) >= c && d || e'\''
OK
$ diff-expr '\''(((a != b) >= c) && d) || e'\'' '\''((a != b) >= c && d) || e'\''
OK
$ test-expr '\''a != (((b >= c) && d) || e)'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 call_builtin(c)
 3 cmp_op(ge)
 4 jump_false*(8)
 5 call_builtin(d)
 6 make_bool()
 7 jump_true(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ne)
$ diff-expr '\''a != (((b >= c) && d) || e)'\'' '\''a != ((b >= c) && d || e)'\''
OK
$ diff-expr '\''a != (((b >= c) && d) || e)'\'' '\''a != (b >= c && d || e)'\''
OK
$ diff-expr '\''a != (((b >= c) && d) || e)'\'' '\''a != ((b >= c && d) || e)'\''
OK
$ test-expr '\''(a != ((b >= c) && d)) || e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 call_builtin(c)
 3 cmp_op(ge)
 4 jump_false(7)
 5 call_builtin(d)
 6 make_bool()
 7 cmp_op(ne)
 8 jump_true(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''(a != ((b >= c) && d)) || e'\'' '\''a != ((b >= c) && d) || e'\''
OK
$ diff-expr '\''(a != ((b >= c) && d)) || e'\'' '\''a != (b >= c && d) || e'\''
OK
$ diff-expr '\''(a != ((b >= c) && d)) || e'\'' '\''(a != (b >= c && d)) || e'\''
OK
$ test-expr '\''(a != b) >= ((c && d) || e)'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 cmp_op(ne)
 3 call_builtin(c)
 4 jump_false*(8)
 5 call_builtin(d)
 6 make_bool()
 7 jump_true(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ge)
$ diff-expr '\''(a != b) >= ((c && d) || e)'\'' '\''(a != b) >= (c && d || e)'\''
OK
$ test-expr '\''a != (b >= ((c && d) || e))'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 call_builtin(c)
 3 jump_false*(7)
 4 call_builtin(d)
 5 make_bool()
 6 jump_true(9)
 7 call_builtin(e)
 8 make_bool()
 9 cmp_op(ge)
10 cmp_op(ne)
$ diff-expr '\''a != (b >= ((c && d) || e))'\'' '\''a != b >= ((c && d) || e)'\''
OK
$ diff-expr '\''a != (b >= ((c && d) || e))'\'' '\''a != b >= (c && d || e)'\''
OK
$ diff-expr '\''a != (b >= ((c && d) || e))'\'' '\''a != (b >= (c && d || e))'\''
OK
$ test-expr '\''((a != (b >= c)) && d) || e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 call_builtin(c)
 3 cmp_op(ge)
 4 cmp_op(ne)
 5 jump_false*(9)
 6 call_builtin(d)
 7 make_bool()
 8 jump_true(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''((a != (b >= c)) && d) || e'\'' '\''(a != (b >= c)) && d || e'\''
OK
$ diff-expr '\''((a != (b >= c)) && d) || e'\'' '\''a != (b >= c) && d || e'\''
OK
$ diff-expr '\''((a != (b >= c)) && d) || e'\'' '\''a != b >= c && d || e'\''
OK
$ diff-expr '\''((a != (b >= c)) && d) || e'\'' '\''(a != b >= c) && d || e'\''
OK
$ diff-expr '\''((a != (b >= c)) && d) || e'\'' '\''(a != (b >= c) && d) || e'\''
OK
$ diff-expr '\''((a != (b >= c)) && d) || e'\'' '\''(a != b >= c && d) || e'\''
OK
$ diff-expr '\''((a != (b >= c)) && d) || e'\'' '\''((a != b >= c) && d) || e'\''
OK
$ test-expr '\''a != ((b >= (c && d)) || e)'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 call_builtin(c)
 3 jump_false(6)
 4 call_builtin(d)
 5 make_bool()
 6 cmp_op(ge)
 7 jump_true(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ne)
$ diff-expr '\''a != ((b >= (c && d)) || e)'\'' '\''a != (b >= (c && d) || e)'\''
OK
$ test-expr '\''((a != b) >= (c && d)) || e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 cmp_op(ne)
 3 call_builtin(c)
 4 jump_false(7)
 5 call_builtin(d)
 6 make_bool()
 7 cmp_op(ge)
 8 jump_true(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''((a != b) >= (c && d)) || e'\'' '\''(a != b) >= (c && d) || e'\''
OK
$ test-expr '\''((a != b) >= c) && (d || e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 jump_true(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''((a != b) >= c) && (d || e)'\'' '\''(a != b) >= c && (d || e)'\''
OK
$ test-expr '\''a != ((b >= c) && (d || e))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_false(9)
5 call_builtin(d)
6 jump_true(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ne)
$ diff-expr '\''a != ((b >= c) && (d || e))'\'' '\''a != (b >= c && (d || e))'\''
OK
$ test-expr '\''(a != (b >= (c && d))) || e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 call_builtin(c)
 3 jump_false(6)
 4 call_builtin(d)
 5 make_bool()
 6 cmp_op(ge)
 7 cmp_op(ne)
 8 jump_true(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''(a != (b >= (c && d))) || e'\'' '\''a != (b >= (c && d)) || e'\''
OK
$ diff-expr '\''(a != (b >= (c && d))) || e'\'' '\''a != b >= (c && d) || e'\''
OK
$ diff-expr '\''(a != (b >= (c && d))) || e'\'' '\''(a != b >= (c && d)) || e'\''
OK
$ test-expr '\''(a != (b >= c)) && (d || e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 jump_true(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''(a != (b >= c)) && (d || e)'\'' '\''a != (b >= c) && (d || e)'\''
OK
$ diff-expr '\''(a != (b >= c)) && (d || e)'\'' '\''a != b >= c && (d || e)'\''
OK
$ diff-expr '\''(a != (b >= c)) && (d || e)'\'' '\''(a != b >= c) && (d || e)'\''
OK
$ test-expr '\''(a != b) >= (c && (d || e))'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(c)
4 jump_false(9)
5 call_builtin(d)
6 jump_true(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ge)
$ test-expr '\''a != (b >= (c && (d || e)))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 jump_false(8)
4 call_builtin(d)
5 jump_true(8)
6 call_builtin(e)
7 make_bool()
8 cmp_op(ge)
9 cmp_op(ne)
$ diff-expr '\''a != (b >= (c && (d || e)))'\'' '\''a != b >= (c && (d || e))'\''
OK
$ test-expr '\''(((a != b) >= c) || d) && e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 cmp_op(ne)
 3 call_builtin(c)
 4 cmp_op(ge)
 5 jump_true*(9)
 6 call_builtin(d)
 7 make_bool()
 8 jump_false(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''(((a != b) >= c) || d) && e'\'' '\''((a != b) >= c || d) && e'\''
OK
$ test-expr '\''a != (((b >= c) || d) && e)'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 call_builtin(c)
 3 cmp_op(ge)
 4 jump_true*(8)
 5 call_builtin(d)
 6 make_bool()
 7 jump_false(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ne)
$ diff-expr '\''a != (((b >= c) || d) && e)'\'' '\''a != ((b >= c || d) && e)'\''
OK
$ test-expr '\''(a != ((b >= c) || d)) && e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 call_builtin(c)
 3 cmp_op(ge)
 4 jump_true(7)
 5 call_builtin(d)
 6 make_bool()
 7 cmp_op(ne)
 8 jump_false(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''(a != ((b >= c) || d)) && e'\'' '\''a != ((b >= c) || d) && e'\''
OK
$ diff-expr '\''(a != ((b >= c) || d)) && e'\'' '\''a != (b >= c || d) && e'\''
OK
$ diff-expr '\''(a != ((b >= c) || d)) && e'\'' '\''(a != (b >= c || d)) && e'\''
OK
$ test-expr '\''(a != b) >= ((c || d) && e)'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 cmp_op(ne)
 3 call_builtin(c)
 4 jump_true*(8)
 5 call_builtin(d)
 6 make_bool()
 7 jump_false(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ge)
$ test-expr '\''a != (b >= ((c || d) && e))'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 call_builtin(c)
 3 jump_true*(7)
 4 call_builtin(d)
 5 make_bool()
 6 jump_false(9)
 7 call_builtin(e)
 8 make_bool()
 9 cmp_op(ge)
10 cmp_op(ne)
$ diff-expr '\''a != (b >= ((c || d) && e))'\'' '\''a != b >= ((c || d) && e)'\''
OK
$ test-expr '\''((a != (b >= c)) || d) && e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 call_builtin(c)
 3 cmp_op(ge)
 4 cmp_op(ne)
 5 jump_true*(9)
 6 call_builtin(d)
 7 make_bool()
 8 jump_false(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''((a != (b >= c)) || d) && e'\'' '\''(a != (b >= c) || d) && e'\''
OK
$ diff-expr '\''((a != (b >= c)) || d) && e'\'' '\''(a != b >= c || d) && e'\''
OK
$ diff-expr '\''((a != (b >= c)) || d) && e'\'' '\''((a != b >= c) || d) && e'\''
OK
$ test-expr '\''a != ((b >= (c || d)) && e)'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 call_builtin(c)
 3 jump_true(6)
 4 call_builtin(d)
 5 make_bool()
 6 cmp_op(ge)
 7 jump_false(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ne)
$ diff-expr '\''a != ((b >= (c || d)) && e)'\'' '\''a != (b >= (c || d) && e)'\''
OK
$ test-expr '\''((a != b) >= (c || d)) && e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 cmp_op(ne)
 3 call_builtin(c)
 4 jump_true(7)
 5 call_builtin(d)
 6 make_bool()
 7 cmp_op(ge)
 8 jump_false(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''((a != b) >= (c || d)) && e'\'' '\''(a != b) >= (c || d) && e'\''
OK
$ test-expr '\''((a != b) >= c) || (d && e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 jump_false(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''((a != b) >= c) || (d && e)'\'' '\''(a != b) >= c || (d && e)'\''
OK
$ diff-expr '\''((a != b) >= c) || (d && e)'\'' '\''(a != b) >= c || d && e'\''
OK
$ diff-expr '\''((a != b) >= c) || (d && e)'\'' '\''((a != b) >= c) || d && e'\''
OK
$ test-expr '\''a != ((b >= c) || (d && e))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 jump_true(9)
5 call_builtin(d)
6 jump_false(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ne)
$ diff-expr '\''a != ((b >= c) || (d && e))'\'' '\''a != (b >= c || (d && e))'\''
OK
$ diff-expr '\''a != ((b >= c) || (d && e))'\'' '\''a != (b >= c || d && e)'\''
OK
$ diff-expr '\''a != ((b >= c) || (d && e))'\'' '\''a != ((b >= c) || d && e)'\''
OK
$ test-expr '\''(a != (b >= (c || d))) && e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 call_builtin(c)
 3 jump_true(6)
 4 call_builtin(d)
 5 make_bool()
 6 cmp_op(ge)
 7 cmp_op(ne)
 8 jump_false(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''(a != (b >= (c || d))) && e'\'' '\''a != (b >= (c || d)) && e'\''
OK
$ diff-expr '\''(a != (b >= (c || d))) && e'\'' '\''a != b >= (c || d) && e'\''
OK
$ diff-expr '\''(a != (b >= (c || d))) && e'\'' '\''(a != b >= (c || d)) && e'\''
OK
$ test-expr '\''(a != (b >= c)) || (d && e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 cmp_op(ge)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 jump_false(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''(a != (b >= c)) || (d && e)'\'' '\''a != (b >= c) || (d && e)'\''
OK
$ diff-expr '\''(a != (b >= c)) || (d && e)'\'' '\''a != b >= c || (d && e)'\''
OK
$ diff-expr '\''(a != (b >= c)) || (d && e)'\'' '\''a != b >= c || d && e'\''
OK
$ diff-expr '\''(a != (b >= c)) || (d && e)'\'' '\''a != (b >= c) || d && e'\''
OK
$ diff-expr '\''(a != (b >= c)) || (d && e)'\'' '\''(a != b >= c) || (d && e)'\''
OK
$ diff-expr '\''(a != (b >= c)) || (d && e)'\'' '\''(a != b >= c) || d && e'\''
OK
$ diff-expr '\''(a != (b >= c)) || (d && e)'\'' '\''(a != (b >= c)) || d && e'\''
OK
$ test-expr '\''(a != b) >= (c || (d && e))'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 call_builtin(c)
4 jump_true(9)
5 call_builtin(d)
6 jump_false(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ge)
$ diff-expr '\''(a != b) >= (c || (d && e))'\'' '\''(a != b) >= (c || d && e)'\''
OK
$ test-expr '\''a != (b >= (c || (d && e)))'\''
0 call_builtin(a)
1 call_builtin(b)
2 call_builtin(c)
3 jump_true(8)
4 call_builtin(d)
5 jump_false(8)
6 call_builtin(e)
7 make_bool()
8 cmp_op(ge)
9 cmp_op(ne)
$ diff-expr '\''a != (b >= (c || (d && e)))'\'' '\''a != b >= (c || (d && e))'\''
OK
$ diff-expr '\''a != (b >= (c || (d && e)))'\'' '\''a != b >= (c || d && e)'\''
OK
$ diff-expr '\''a != (b >= (c || (d && e)))'\'' '\''a != (b >= (c || d && e))'\''
OK
$ test-expr '\''(((a != b) && c) >= d) || e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 cmp_op(ne)
 3 jump_false(6)
 4 call_builtin(c)
 5 make_bool()
 6 call_builtin(d)
 7 cmp_op(ge)
 8 jump_true(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''(((a != b) && c) >= d) || e'\'' '\''((a != b) && c) >= d || e'\''
OK
$ diff-expr '\''(((a != b) && c) >= d) || e'\'' '\''(a != b && c) >= d || e'\''
OK
$ diff-expr '\''(((a != b) && c) >= d) || e'\'' '\''((a != b && c) >= d) || e'\''
OK
$ test-expr '\''a != (((b && c) >= d) || e)'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_false(5)
 3 call_builtin(c)
 4 make_bool()
 5 call_builtin(d)
 6 cmp_op(ge)
 7 jump_true(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ne)
$ diff-expr '\''a != (((b && c) >= d) || e)'\'' '\''a != ((b && c) >= d || e)'\''
OK
$ test-expr '\''(a != ((b && c) >= d)) || e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_false(5)
 3 call_builtin(c)
 4 make_bool()
 5 call_builtin(d)
 6 cmp_op(ge)
 7 cmp_op(ne)
 8 jump_true(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''(a != ((b && c) >= d)) || e'\'' '\''a != ((b && c) >= d) || e'\''
OK
$ diff-expr '\''(a != ((b && c) >= d)) || e'\'' '\''a != (b && c) >= d || e'\''
OK
$ diff-expr '\''(a != ((b && c) >= d)) || e'\'' '\''(a != (b && c) >= d) || e'\''
OK
$ test-expr '\''(a != b) && ((c >= d) || e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
7 jump_true(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''(a != b) && ((c >= d) || e)'\'' '\''a != b && ((c >= d) || e)'\''
OK
$ diff-expr '\''(a != b) && ((c >= d) || e)'\'' '\''a != b && (c >= d || e)'\''
OK
$ diff-expr '\''(a != b) && ((c >= d) || e)'\'' '\''(a != b) && (c >= d || e)'\''
OK
$ test-expr '\''a != (b && ((c >= d) || e))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(9)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 jump_true(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ne)
$ diff-expr '\''a != (b && ((c >= d) || e))'\'' '\''a != (b && (c >= d || e))'\''
OK
$ test-expr '\''((a != (b && c)) >= d) || e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_false(5)
 3 call_builtin(c)
 4 make_bool()
 5 cmp_op(ne)
 6 call_builtin(d)
 7 cmp_op(ge)
 8 jump_true(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''((a != (b && c)) >= d) || e'\'' '\''(a != (b && c)) >= d || e'\''
OK
$ test-expr '\''a != ((b && (c >= d)) || e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false*(7)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 jump_true(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ne)
$ diff-expr '\''a != ((b && (c >= d)) || e)'\'' '\''a != (b && (c >= d) || e)'\''
OK
$ diff-expr '\''a != ((b && (c >= d)) || e)'\'' '\''a != (b && c >= d || e)'\''
OK
$ diff-expr '\''a != ((b && (c >= d)) || e)'\'' '\''a != ((b && c >= d) || e)'\''
OK
$ test-expr '\''((a != b) && (c >= d)) || e'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false*(8)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
7 jump_true(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''((a != b) && (c >= d)) || e'\'' '\''(a != b) && (c >= d) || e'\''
OK
$ diff-expr '\''((a != b) && (c >= d)) || e'\'' '\''a != b && (c >= d) || e'\''
OK
$ diff-expr '\''((a != b) && (c >= d)) || e'\'' '\''a != b && c >= d || e'\''
OK
$ diff-expr '\''((a != b) && (c >= d)) || e'\'' '\''(a != b) && c >= d || e'\''
OK
$ diff-expr '\''((a != b) && (c >= d)) || e'\'' '\''(a != b && (c >= d)) || e'\''
OK
$ diff-expr '\''((a != b) && (c >= d)) || e'\'' '\''(a != b && c >= d) || e'\''
OK
$ diff-expr '\''((a != b) && (c >= d)) || e'\'' '\''((a != b) && c >= d) || e'\''
OK
$ test-expr '\''((a != b) && c) >= (d || e)'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 cmp_op(ne)
 3 jump_false(6)
 4 call_builtin(c)
 5 make_bool()
 6 call_builtin(d)
 7 jump_true(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ge)
$ diff-expr '\''((a != b) && c) >= (d || e)'\'' '\''(a != b && c) >= (d || e)'\''
OK
$ test-expr '\''a != ((b && c) >= (d || e))'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_false(5)
 3 call_builtin(c)
 4 make_bool()
 5 call_builtin(d)
 6 jump_true(9)
 7 call_builtin(e)
 8 make_bool()
 9 cmp_op(ge)
10 cmp_op(ne)
$ diff-expr '\''a != ((b && c) >= (d || e))'\'' '\''a != (b && c) >= (d || e)'\''
OK
$ test-expr '\''(a != (b && (c >= d))) || e'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
7 jump_true(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''(a != (b && (c >= d))) || e'\'' '\''a != (b && (c >= d)) || e'\''
OK
$ diff-expr '\''(a != (b && (c >= d))) || e'\'' '\''a != (b && c >= d) || e'\''
OK
$ diff-expr '\''(a != (b && (c >= d))) || e'\'' '\''(a != (b && c >= d)) || e'\''
OK
$ test-expr '\''(a != (b && c)) >= (d || e)'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_false(5)
 3 call_builtin(c)
 4 make_bool()
 5 cmp_op(ne)
 6 call_builtin(d)
 7 jump_true(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ge)
$ test-expr '\''(a != b) && (c >= (d || e))'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(d)
6 jump_true(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ge)
$ diff-expr '\''(a != b) && (c >= (d || e))'\'' '\''a != b && (c >= (d || e))'\''
OK
$ diff-expr '\''(a != b) && (c >= (d || e))'\'' '\''a != b && c >= (d || e)'\''
OK
$ diff-expr '\''(a != b) && (c >= (d || e))'\'' '\''(a != b) && c >= (d || e)'\''
OK
$ test-expr '\''a != (b && (c >= (d || e)))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(9)
3 call_builtin(c)
4 call_builtin(d)
5 jump_true(8)
6 call_builtin(e)
7 make_bool()
8 cmp_op(ge)
9 cmp_op(ne)
$ diff-expr '\''a != (b && (c >= (d || e)))'\'' '\''a != (b && c >= (d || e))'\''
OK
$ test-expr '\''(((a != b) && c) || d) >= e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 cmp_op(ne)
 3 jump_false*(7)
 4 call_builtin(c)
 5 make_bool()
 6 jump_true(9)
 7 call_builtin(d)
 8 make_bool()
 9 call_builtin(e)
10 cmp_op(ge)
$ diff-expr '\''(((a != b) && c) || d) >= e'\'' '\''((a != b) && c || d) >= e'\''
OK
$ diff-expr '\''(((a != b) && c) || d) >= e'\'' '\''(a != b && c || d) >= e'\''
OK
$ diff-expr '\''(((a != b) && c) || d) >= e'\'' '\''((a != b && c) || d) >= e'\''
OK
$ test-expr '\''a != (((b && c) || d) >= e)'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_false*(6)
 3 call_builtin(c)
 4 make_bool()
 5 jump_true(8)
 6 call_builtin(d)
 7 make_bool()
 8 call_builtin(e)
 9 cmp_op(ge)
10 cmp_op(ne)
$ diff-expr '\''a != (((b && c) || d) >= e)'\'' '\''a != ((b && c) || d) >= e'\''
OK
$ diff-expr '\''a != (((b && c) || d) >= e)'\'' '\''a != (b && c || d) >= e'\''
OK
$ diff-expr '\''a != (((b && c) || d) >= e)'\'' '\''a != ((b && c || d) >= e)'\''
OK
$ test-expr '\''(a != ((b && c) || d)) >= e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_false*(6)
 3 call_builtin(c)
 4 make_bool()
 5 jump_true(8)
 6 call_builtin(d)
 7 make_bool()
 8 cmp_op(ne)
 9 call_builtin(e)
10 cmp_op(ge)
$ diff-expr '\''(a != ((b && c) || d)) >= e'\'' '\''(a != (b && c || d)) >= e'\''
OK
$ test-expr '\''(a != b) && ((c || d) >= e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(c)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 call_builtin(e)
9 cmp_op(ge)
$ diff-expr '\''(a != b) && ((c || d) >= e)'\'' '\''a != b && ((c || d) >= e)'\''
OK
$ diff-expr '\''(a != b) && ((c || d) >= e)'\'' '\''a != b && (c || d) >= e'\''
OK
$ diff-expr '\''(a != b) && ((c || d) >= e)'\'' '\''(a != b) && (c || d) >= e'\''
OK
$ test-expr '\''a != (b && ((c || d) >= e))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(9)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 call_builtin(e)
8 cmp_op(ge)
9 cmp_op(ne)
$ diff-expr '\''a != (b && ((c || d) >= e))'\'' '\''a != (b && (c || d) >= e)'\''
OK
$ test-expr '\''((a != (b && c)) || d) >= e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_false(5)
 3 call_builtin(c)
 4 make_bool()
 5 cmp_op(ne)
 6 jump_true(9)
 7 call_builtin(d)
 8 make_bool()
 9 call_builtin(e)
10 cmp_op(ge)
$ diff-expr '\''((a != (b && c)) || d) >= e'\'' '\''(a != (b && c) || d) >= e'\''
OK
$ test-expr '\''a != ((b && (c || d)) >= e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(7)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 call_builtin(e)
8 cmp_op(ge)
9 cmp_op(ne)
$ diff-expr '\''a != ((b && (c || d)) >= e)'\'' '\''a != (b && (c || d)) >= e'\''
OK
$ test-expr '\''((a != b) && (c || d)) >= e'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(8)
4 call_builtin(c)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 call_builtin(e)
9 cmp_op(ge)
$ diff-expr '\''((a != b) && (c || d)) >= e'\'' '\''(a != b && (c || d)) >= e'\''
OK
$ test-expr '\''((a != b) && c) || (d >= e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false*(7)
4 call_builtin(c)
5 make_bool()
6 jump_true(eos)
7 call_builtin(d)
8 call_builtin(e)
9 cmp_op(ge)
$ diff-expr '\''((a != b) && c) || (d >= e)'\'' '\''(a != b) && c || (d >= e)'\''
OK
$ diff-expr '\''((a != b) && c) || (d >= e)'\'' '\''a != b && c || (d >= e)'\''
OK
$ diff-expr '\''((a != b) && c) || (d >= e)'\'' '\''a != b && c || d >= e'\''
OK
$ diff-expr '\''((a != b) && c) || (d >= e)'\'' '\''(a != b) && c || d >= e'\''
OK
$ diff-expr '\''((a != b) && c) || (d >= e)'\'' '\''(a != b && c) || (d >= e)'\''
OK
$ diff-expr '\''((a != b) && c) || (d >= e)'\'' '\''(a != b && c) || d >= e'\''
OK
$ diff-expr '\''((a != b) && c) || (d >= e)'\'' '\''((a != b) && c) || d >= e'\''
OK
$ test-expr '\''a != ((b && c) || (d >= e))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false*(6)
3 call_builtin(c)
4 make_bool()
5 jump_true(9)
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ge)
9 cmp_op(ne)
$ diff-expr '\''a != ((b && c) || (d >= e))'\'' '\''a != (b && c || (d >= e))'\''
OK
$ diff-expr '\''a != ((b && c) || (d >= e))'\'' '\''a != (b && c || d >= e)'\''
OK
$ diff-expr '\''a != ((b && c) || (d >= e))'\'' '\''a != ((b && c) || d >= e)'\''
OK
$ test-expr '\''(a != (b && (c || d))) >= e'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(7)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
8 call_builtin(e)
9 cmp_op(ge)
$ test-expr '\''(a != (b && c)) || (d >= e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 jump_true(eos)
7 call_builtin(d)
8 call_builtin(e)
9 cmp_op(ge)
$ diff-expr '\''(a != (b && c)) || (d >= e)'\'' '\''a != (b && c) || (d >= e)'\''
OK
$ diff-expr '\''(a != (b && c)) || (d >= e)'\'' '\''a != (b && c) || d >= e'\''
OK
$ diff-expr '\''(a != (b && c)) || (d >= e)'\'' '\''(a != (b && c)) || d >= e'\''
OK
$ test-expr '\''(a != b) && (c || (d >= e))'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_false(eos)
4 call_builtin(c)
5 jump_true(eos)
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ge)
$ diff-expr '\''(a != b) && (c || (d >= e))'\'' '\''a != b && (c || (d >= e))'\''
OK
$ diff-expr '\''(a != b) && (c || (d >= e))'\'' '\''a != b && (c || d >= e)'\''
OK
$ diff-expr '\''(a != b) && (c || (d >= e))'\'' '\''(a != b) && (c || d >= e)'\''
OK
$ test-expr '\''a != (b && (c || (d >= e)))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_false(8)
3 call_builtin(c)
4 jump_true(8)
5 call_builtin(d)
6 call_builtin(e)
7 cmp_op(ge)
8 cmp_op(ne)
$ diff-expr '\''a != (b && (c || (d >= e)))'\'' '\''a != (b && (c || d >= e))'\''
OK
$ test-expr '\''(((a != b) || c) >= d) && e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 cmp_op(ne)
 3 jump_true(6)
 4 call_builtin(c)
 5 make_bool()
 6 call_builtin(d)
 7 cmp_op(ge)
 8 jump_false(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''(((a != b) || c) >= d) && e'\'' '\''((a != b) || c) >= d && e'\''
OK
$ diff-expr '\''(((a != b) || c) >= d) && e'\'' '\''(a != b || c) >= d && e'\''
OK
$ diff-expr '\''(((a != b) || c) >= d) && e'\'' '\''((a != b || c) >= d) && e'\''
OK
$ test-expr '\''a != (((b || c) >= d) && e)'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_true(5)
 3 call_builtin(c)
 4 make_bool()
 5 call_builtin(d)
 6 cmp_op(ge)
 7 jump_false(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ne)
$ diff-expr '\''a != (((b || c) >= d) && e)'\'' '\''a != ((b || c) >= d && e)'\''
OK
$ test-expr '\''(a != ((b || c) >= d)) && e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_true(5)
 3 call_builtin(c)
 4 make_bool()
 5 call_builtin(d)
 6 cmp_op(ge)
 7 cmp_op(ne)
 8 jump_false(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''(a != ((b || c) >= d)) && e'\'' '\''a != ((b || c) >= d) && e'\''
OK
$ diff-expr '\''(a != ((b || c) >= d)) && e'\'' '\''a != (b || c) >= d && e'\''
OK
$ diff-expr '\''(a != ((b || c) >= d)) && e'\'' '\''(a != (b || c) >= d) && e'\''
OK
$ test-expr '\''(a != b) || ((c >= d) && e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
7 jump_false(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''(a != b) || ((c >= d) && e)'\'' '\''a != b || ((c >= d) && e)'\''
OK
$ diff-expr '\''(a != b) || ((c >= d) && e)'\'' '\''a != b || (c >= d) && e'\''
OK
$ diff-expr '\''(a != b) || ((c >= d) && e)'\'' '\''a != b || c >= d && e'\''
OK
$ diff-expr '\''(a != b) || ((c >= d) && e)'\'' '\''a != b || (c >= d && e)'\''
OK
$ diff-expr '\''(a != b) || ((c >= d) && e)'\'' '\''(a != b) || (c >= d) && e'\''
OK
$ diff-expr '\''(a != b) || ((c >= d) && e)'\'' '\''(a != b) || c >= d && e'\''
OK
$ diff-expr '\''(a != b) || ((c >= d) && e)'\'' '\''(a != b) || (c >= d && e)'\''
OK
$ test-expr '\''a != (b || ((c >= d) && e))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(9)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 jump_false(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ne)
$ diff-expr '\''a != (b || ((c >= d) && e))'\'' '\''a != (b || (c >= d) && e)'\''
OK
$ diff-expr '\''a != (b || ((c >= d) && e))'\'' '\''a != (b || c >= d && e)'\''
OK
$ diff-expr '\''a != (b || ((c >= d) && e))'\'' '\''a != (b || (c >= d && e))'\''
OK
$ test-expr '\''((a != (b || c)) >= d) && e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_true(5)
 3 call_builtin(c)
 4 make_bool()
 5 cmp_op(ne)
 6 call_builtin(d)
 7 cmp_op(ge)
 8 jump_false(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''((a != (b || c)) >= d) && e'\'' '\''(a != (b || c)) >= d && e'\''
OK
$ test-expr '\''a != ((b || (c >= d)) && e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true*(7)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 jump_false(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ne)
$ diff-expr '\''a != ((b || (c >= d)) && e)'\'' '\''a != ((b || c >= d) && e)'\''
OK
$ test-expr '\''((a != b) || (c >= d)) && e'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true*(8)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
7 jump_false(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''((a != b) || (c >= d)) && e'\'' '\''(a != b || (c >= d)) && e'\''
OK
$ diff-expr '\''((a != b) || (c >= d)) && e'\'' '\''(a != b || c >= d) && e'\''
OK
$ diff-expr '\''((a != b) || (c >= d)) && e'\'' '\''((a != b) || c >= d) && e'\''
OK
$ test-expr '\''((a != b) || c) >= (d && e)'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 cmp_op(ne)
 3 jump_true(6)
 4 call_builtin(c)
 5 make_bool()
 6 call_builtin(d)
 7 jump_false(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ge)
$ diff-expr '\''((a != b) || c) >= (d && e)'\'' '\''(a != b || c) >= (d && e)'\''
OK
$ test-expr '\''a != ((b || c) >= (d && e))'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_true(5)
 3 call_builtin(c)
 4 make_bool()
 5 call_builtin(d)
 6 jump_false(9)
 7 call_builtin(e)
 8 make_bool()
 9 cmp_op(ge)
10 cmp_op(ne)
$ diff-expr '\''a != ((b || c) >= (d && e))'\'' '\''a != (b || c) >= (d && e)'\''
OK
$ test-expr '\''(a != (b || (c >= d))) && e'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(6)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
7 jump_false(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''(a != (b || (c >= d))) && e'\'' '\''a != (b || (c >= d)) && e'\''
OK
$ diff-expr '\''(a != (b || (c >= d))) && e'\'' '\''a != (b || c >= d) && e'\''
OK
$ diff-expr '\''(a != (b || (c >= d))) && e'\'' '\''(a != (b || c >= d)) && e'\''
OK
$ test-expr '\''(a != (b || c)) >= (d && e)'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_true(5)
 3 call_builtin(c)
 4 make_bool()
 5 cmp_op(ne)
 6 call_builtin(d)
 7 jump_false(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ge)
$ test-expr '\''(a != b) || (c >= (d && e))'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(d)
6 jump_false(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ge)
$ diff-expr '\''(a != b) || (c >= (d && e))'\'' '\''a != b || (c >= (d && e))'\''
OK
$ diff-expr '\''(a != b) || (c >= (d && e))'\'' '\''a != b || c >= (d && e)'\''
OK
$ diff-expr '\''(a != b) || (c >= (d && e))'\'' '\''(a != b) || c >= (d && e)'\''
OK
$ test-expr '\''a != (b || (c >= (d && e)))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(9)
3 call_builtin(c)
4 call_builtin(d)
5 jump_false(8)
6 call_builtin(e)
7 make_bool()
8 cmp_op(ge)
9 cmp_op(ne)
$ diff-expr '\''a != (b || (c >= (d && e)))'\'' '\''a != (b || c >= (d && e))'\''
OK
$ test-expr '\''(((a != b) || c) && d) >= e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 cmp_op(ne)
 3 jump_true*(7)
 4 call_builtin(c)
 5 make_bool()
 6 jump_false(9)
 7 call_builtin(d)
 8 make_bool()
 9 call_builtin(e)
10 cmp_op(ge)
$ diff-expr '\''(((a != b) || c) && d) >= e'\'' '\''((a != b || c) && d) >= e'\''
OK
$ test-expr '\''a != (((b || c) && d) >= e)'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_true*(6)
 3 call_builtin(c)
 4 make_bool()
 5 jump_false(8)
 6 call_builtin(d)
 7 make_bool()
 8 call_builtin(e)
 9 cmp_op(ge)
10 cmp_op(ne)
$ diff-expr '\''a != (((b || c) && d) >= e)'\'' '\''a != ((b || c) && d) >= e'\''
OK
$ test-expr '\''(a != ((b || c) && d)) >= e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_true*(6)
 3 call_builtin(c)
 4 make_bool()
 5 jump_false(8)
 6 call_builtin(d)
 7 make_bool()
 8 cmp_op(ne)
 9 call_builtin(e)
10 cmp_op(ge)
$ test-expr '\''(a != b) || ((c && d) >= e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(c)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 call_builtin(e)
9 cmp_op(ge)
$ diff-expr '\''(a != b) || ((c && d) >= e)'\'' '\''a != b || ((c && d) >= e)'\''
OK
$ diff-expr '\''(a != b) || ((c && d) >= e)'\'' '\''a != b || (c && d) >= e'\''
OK
$ diff-expr '\''(a != b) || ((c && d) >= e)'\'' '\''(a != b) || (c && d) >= e'\''
OK
$ test-expr '\''a != (b || ((c && d) >= e))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(9)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 call_builtin(e)
8 cmp_op(ge)
9 cmp_op(ne)
$ diff-expr '\''a != (b || ((c && d) >= e))'\'' '\''a != (b || (c && d) >= e)'\''
OK
$ test-expr '\''((a != (b || c)) && d) >= e'\''
 0 call_builtin(a)
 1 call_builtin(b)
 2 jump_true(5)
 3 call_builtin(c)
 4 make_bool()
 5 cmp_op(ne)
 6 jump_false(9)
 7 call_builtin(d)
 8 make_bool()
 9 call_builtin(e)
10 cmp_op(ge)
$ diff-expr '\''((a != (b || c)) && d) >= e'\'' '\''(a != (b || c) && d) >= e'\''
OK
$ test-expr '\''a != ((b || (c && d)) >= e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(7)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 call_builtin(e)
8 cmp_op(ge)
9 cmp_op(ne)
$ diff-expr '\''a != ((b || (c && d)) >= e)'\'' '\''a != (b || (c && d)) >= e'\''
OK
$ diff-expr '\''a != ((b || (c && d)) >= e)'\'' '\''a != (b || c && d) >= e'\''
OK
$ diff-expr '\''a != ((b || (c && d)) >= e)'\'' '\''a != ((b || c && d) >= e)'\''
OK
$ test-expr '\''((a != b) || (c && d)) >= e'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(8)
4 call_builtin(c)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 call_builtin(e)
9 cmp_op(ge)
$ diff-expr '\''((a != b) || (c && d)) >= e'\'' '\''(a != b || (c && d)) >= e'\''
OK
$ diff-expr '\''((a != b) || (c && d)) >= e'\'' '\''(a != b || c && d) >= e'\''
OK
$ diff-expr '\''((a != b) || (c && d)) >= e'\'' '\''((a != b) || c && d) >= e'\''
OK
$ test-expr '\''((a != b) || c) && (d >= e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true*(7)
4 call_builtin(c)
5 make_bool()
6 jump_false(eos)
7 call_builtin(d)
8 call_builtin(e)
9 cmp_op(ge)
$ diff-expr '\''((a != b) || c) && (d >= e)'\'' '\''(a != b || c) && (d >= e)'\''
OK
$ diff-expr '\''((a != b) || c) && (d >= e)'\'' '\''(a != b || c) && d >= e'\''
OK
$ diff-expr '\''((a != b) || c) && (d >= e)'\'' '\''((a != b) || c) && d >= e'\''
OK
$ test-expr '\''a != ((b || c) && (d >= e))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true*(6)
3 call_builtin(c)
4 make_bool()
5 jump_false(9)
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ge)
9 cmp_op(ne)
$ diff-expr '\''a != ((b || c) && (d >= e))'\'' '\''a != ((b || c) && d >= e)'\''
OK
$ test-expr '\''(a != (b || (c && d))) >= e'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(7)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
8 call_builtin(e)
9 cmp_op(ge)
$ diff-expr '\''(a != (b || (c && d))) >= e'\'' '\''(a != (b || c && d)) >= e'\''
OK
$ test-expr '\''(a != (b || c)) && (d >= e)'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(5)
3 call_builtin(c)
4 make_bool()
5 cmp_op(ne)
6 jump_false(eos)
7 call_builtin(d)
8 call_builtin(e)
9 cmp_op(ge)
$ diff-expr '\''(a != (b || c)) && (d >= e)'\'' '\''a != (b || c) && (d >= e)'\''
OK
$ diff-expr '\''(a != (b || c)) && (d >= e)'\'' '\''a != (b || c) && d >= e'\''
OK
$ diff-expr '\''(a != (b || c)) && (d >= e)'\'' '\''(a != (b || c)) && d >= e'\''
OK
$ test-expr '\''(a != b) || (c && (d >= e))'\''
0 call_builtin(a)
1 call_builtin(b)
2 cmp_op(ne)
3 jump_true(eos)
4 call_builtin(c)
5 jump_false(eos)
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ge)
$ diff-expr '\''(a != b) || (c && (d >= e))'\'' '\''a != b || (c && (d >= e))'\''
OK
$ diff-expr '\''(a != b) || (c && (d >= e))'\'' '\''a != b || c && (d >= e)'\''
OK
$ diff-expr '\''(a != b) || (c && (d >= e))'\'' '\''a != b || c && d >= e'\''
OK
$ diff-expr '\''(a != b) || (c && (d >= e))'\'' '\''a != b || (c && d >= e)'\''
OK
$ diff-expr '\''(a != b) || (c && (d >= e))'\'' '\''(a != b) || c && (d >= e)'\''
OK
$ diff-expr '\''(a != b) || (c && (d >= e))'\'' '\''(a != b) || c && d >= e'\''
OK
$ diff-expr '\''(a != b) || (c && (d >= e))'\'' '\''(a != b) || (c && d >= e)'\''
OK
$ test-expr '\''a != (b || (c && (d >= e)))'\''
0 call_builtin(a)
1 call_builtin(b)
2 jump_true(8)
3 call_builtin(c)
4 jump_false(8)
5 call_builtin(d)
6 call_builtin(e)
7 cmp_op(ge)
8 cmp_op(ne)
$ diff-expr '\''a != (b || (c && (d >= e)))'\'' '\''a != (b || c && (d >= e))'\''
OK
$ diff-expr '\''a != (b || (c && (d >= e)))'\'' '\''a != (b || c && d >= e)'\''
OK
$ diff-expr '\''a != (b || (c && (d >= e)))'\'' '\''a != (b || (c && d >= e))'\''
OK
$ test-expr '\''(((a && b) >= c) != d) || e'\''
 0 call_builtin(a)
 1 jump_false(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 cmp_op(ge)
 6 call_builtin(d)
 7 cmp_op(ne)
 8 jump_true(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''(((a && b) >= c) != d) || e'\'' '\''((a && b) >= c) != d || e'\''
OK
$ diff-expr '\''(((a && b) >= c) != d) || e'\'' '\''(a && b) >= c != d || e'\''
OK
$ diff-expr '\''(((a && b) >= c) != d) || e'\'' '\''((a && b) >= c != d) || e'\''
OK
$ test-expr '\''a && (((b >= c) != d) || e)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
7 jump_true(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''a && (((b >= c) != d) || e)'\'' '\''a && ((b >= c) != d || e)'\''
OK
$ diff-expr '\''a && (((b >= c) != d) || e)'\'' '\''a && (b >= c != d || e)'\''
OK
$ diff-expr '\''a && (((b >= c) != d) || e)'\'' '\''a && ((b >= c != d) || e)'\''
OK
$ test-expr '\''(a && ((b >= c) != d)) || e'\''
0 call_builtin(a)
1 jump_false*(8)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
7 jump_true(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''(a && ((b >= c) != d)) || e'\'' '\''a && ((b >= c) != d) || e'\''
OK
$ diff-expr '\''(a && ((b >= c) != d)) || e'\'' '\''a && (b >= c) != d || e'\''
OK
$ diff-expr '\''(a && ((b >= c) != d)) || e'\'' '\''a && b >= c != d || e'\''
OK
$ diff-expr '\''(a && ((b >= c) != d)) || e'\'' '\''a && (b >= c != d) || e'\''
OK
$ diff-expr '\''(a && ((b >= c) != d)) || e'\'' '\''(a && (b >= c) != d) || e'\''
OK
$ diff-expr '\''(a && ((b >= c) != d)) || e'\'' '\''(a && b >= c != d) || e'\''
OK
$ diff-expr '\''(a && ((b >= c) != d)) || e'\'' '\''(a && (b >= c != d)) || e'\''
OK
$ test-expr '\''(a && b) >= ((c != d) || e)'\''
 0 call_builtin(a)
 1 jump_false(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 call_builtin(d)
 6 cmp_op(ne)
 7 jump_true(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ge)
$ diff-expr '\''(a && b) >= ((c != d) || e)'\'' '\''(a && b) >= (c != d || e)'\''
OK
$ test-expr '\''a && (b >= ((c != d) || e))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 jump_true(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ge)
$ diff-expr '\''a && (b >= ((c != d) || e))'\'' '\''a && b >= ((c != d) || e)'\''
OK
$ diff-expr '\''a && (b >= ((c != d) || e))'\'' '\''a && b >= (c != d || e)'\''
OK
$ diff-expr '\''a && (b >= ((c != d) || e))'\'' '\''a && (b >= (c != d || e))'\''
OK
$ test-expr '\''((a && (b >= c)) != d) || e'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
7 jump_true(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''((a && (b >= c)) != d) || e'\'' '\''(a && (b >= c)) != d || e'\''
OK
$ diff-expr '\''((a && (b >= c)) != d) || e'\'' '\''(a && b >= c) != d || e'\''
OK
$ diff-expr '\''((a && (b >= c)) != d) || e'\'' '\''((a && b >= c) != d) || e'\''
OK
$ test-expr '\''a && ((b >= (c != d)) || e)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
7 jump_true(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''a && ((b >= (c != d)) || e)'\'' '\''a && (b >= (c != d) || e)'\''
OK
$ test-expr '\''((a && b) >= (c != d)) || e'\''
 0 call_builtin(a)
 1 jump_false(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 call_builtin(d)
 6 cmp_op(ne)
 7 cmp_op(ge)
 8 jump_true(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''((a && b) >= (c != d)) || e'\'' '\''(a && b) >= (c != d) || e'\''
OK
$ test-expr '\''((a && b) >= c) != (d || e)'\''
 0 call_builtin(a)
 1 jump_false(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 cmp_op(ge)
 6 call_builtin(d)
 7 jump_true(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ne)
$ diff-expr '\''((a && b) >= c) != (d || e)'\'' '\''(a && b) >= c != (d || e)'\''
OK
$ test-expr '\''a && ((b >= c) != (d || e))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 jump_true(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ne)
$ diff-expr '\''a && ((b >= c) != (d || e))'\'' '\''a && (b >= c) != (d || e)'\''
OK
$ diff-expr '\''a && ((b >= c) != (d || e))'\'' '\''a && b >= c != (d || e)'\''
OK
$ diff-expr '\''a && ((b >= c) != (d || e))'\'' '\''a && (b >= c != (d || e))'\''
OK
$ test-expr '\''(a && (b >= (c != d))) || e'\''
0 call_builtin(a)
1 jump_false*(8)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
7 jump_true(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''(a && (b >= (c != d))) || e'\'' '\''a && (b >= (c != d)) || e'\''
OK
$ diff-expr '\''(a && (b >= (c != d))) || e'\'' '\''a && b >= (c != d) || e'\''
OK
$ diff-expr '\''(a && (b >= (c != d))) || e'\'' '\''(a && b >= (c != d)) || e'\''
OK
$ test-expr '\''(a && (b >= c)) != (d || e)'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 jump_true(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ne)
$ diff-expr '\''(a && (b >= c)) != (d || e)'\'' '\''(a && b >= c) != (d || e)'\''
OK
$ test-expr '\''(a && b) >= (c != (d || e))'\''
 0 call_builtin(a)
 1 jump_false(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 call_builtin(d)
 6 jump_true(9)
 7 call_builtin(e)
 8 make_bool()
 9 cmp_op(ne)
10 cmp_op(ge)
$ test-expr '\''a && (b >= (c != (d || e)))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 jump_true(8)
6 call_builtin(e)
7 make_bool()
8 cmp_op(ne)
9 cmp_op(ge)
$ diff-expr '\''a && (b >= (c != (d || e)))'\'' '\''a && b >= (c != (d || e))'\''
OK
$ test-expr '\''(((a && b) >= c) || d) != e'\''
 0 call_builtin(a)
 1 jump_false(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 cmp_op(ge)
 6 jump_true(9)
 7 call_builtin(d)
 8 make_bool()
 9 call_builtin(e)
10 cmp_op(ne)
$ diff-expr '\''(((a && b) >= c) || d) != e'\'' '\''((a && b) >= c || d) != e'\''
OK
$ test-expr '\''a && (((b >= c) || d) != e)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''a && (((b >= c) || d) != e)'\'' '\''a && ((b >= c) || d) != e'\''
OK
$ diff-expr '\''a && (((b >= c) || d) != e)'\'' '\''a && (b >= c || d) != e'\''
OK
$ diff-expr '\''a && (((b >= c) || d) != e)'\'' '\''a && ((b >= c || d) != e)'\''
OK
$ test-expr '\''(a && ((b >= c) || d)) != e'\''
0 call_builtin(a)
1 jump_false(8)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''(a && ((b >= c) || d)) != e'\'' '\''(a && (b >= c || d)) != e'\''
OK
$ test-expr '\''(a && b) >= ((c || d) != e)'\''
 0 call_builtin(a)
 1 jump_false(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 jump_true(8)
 6 call_builtin(d)
 7 make_bool()
 8 call_builtin(e)
 9 cmp_op(ne)
10 cmp_op(ge)
$ test-expr '\''a && (b >= ((c || d) != e))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 call_builtin(e)
8 cmp_op(ne)
9 cmp_op(ge)
$ diff-expr '\''a && (b >= ((c || d) != e))'\'' '\''a && b >= ((c || d) != e)'\''
OK
$ test-expr '\''((a && (b >= c)) || d) != e'\''
0 call_builtin(a)
1 jump_false*(6)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''((a && (b >= c)) || d) != e'\'' '\''(a && (b >= c) || d) != e'\''
OK
$ diff-expr '\''((a && (b >= c)) || d) != e'\'' '\''(a && b >= c || d) != e'\''
OK
$ diff-expr '\''((a && (b >= c)) || d) != e'\'' '\''((a && b >= c) || d) != e'\''
OK
$ test-expr '\''a && ((b >= (c || d)) != e)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''a && ((b >= (c || d)) != e)'\'' '\''a && (b >= (c || d)) != e'\''
OK
$ diff-expr '\''a && ((b >= (c || d)) != e)'\'' '\''a && b >= (c || d) != e'\''
OK
$ diff-expr '\''a && ((b >= (c || d)) != e)'\'' '\''a && (b >= (c || d) != e)'\''
OK
$ test-expr '\''((a && b) >= (c || d)) != e'\''
 0 call_builtin(a)
 1 jump_false(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 jump_true(8)
 6 call_builtin(d)
 7 make_bool()
 8 cmp_op(ge)
 9 call_builtin(e)
10 cmp_op(ne)
$ diff-expr '\''((a && b) >= (c || d)) != e'\'' '\''(a && b) >= (c || d) != e'\''
OK
$ test-expr '\''((a && b) >= c) || (d != e)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 jump_true(eos)
7 call_builtin(d)
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''((a && b) >= c) || (d != e)'\'' '\''(a && b) >= c || (d != e)'\''
OK
$ diff-expr '\''((a && b) >= c) || (d != e)'\'' '\''(a && b) >= c || d != e'\''
OK
$ diff-expr '\''((a && b) >= c) || (d != e)'\'' '\''((a && b) >= c) || d != e'\''
OK
$ test-expr '\''a && ((b >= c) || (d != e))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ne)
$ diff-expr '\''a && ((b >= c) || (d != e))'\'' '\''a && (b >= c || (d != e))'\''
OK
$ diff-expr '\''a && ((b >= c) || (d != e))'\'' '\''a && (b >= c || d != e)'\''
OK
$ diff-expr '\''a && ((b >= c) || (d != e))'\'' '\''a && ((b >= c) || d != e)'\''
OK
$ test-expr '\''(a && (b >= (c || d))) != e'\''
0 call_builtin(a)
1 jump_false(8)
2 call_builtin(b)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''(a && (b >= (c || d))) != e'\'' '\''(a && b >= (c || d)) != e'\''
OK
$ test-expr '\''(a && (b >= c)) || (d != e)'\''
0 call_builtin(a)
1 jump_false*(6)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_true(eos)
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ne)
$ diff-expr '\''(a && (b >= c)) || (d != e)'\'' '\''a && (b >= c) || (d != e)'\''
OK
$ diff-expr '\''(a && (b >= c)) || (d != e)'\'' '\''a && b >= c || (d != e)'\''
OK
$ diff-expr '\''(a && (b >= c)) || (d != e)'\'' '\''a && b >= c || d != e'\''
OK
$ diff-expr '\''(a && (b >= c)) || (d != e)'\'' '\''a && (b >= c) || d != e'\''
OK
$ diff-expr '\''(a && (b >= c)) || (d != e)'\'' '\''(a && b >= c) || (d != e)'\''
OK
$ diff-expr '\''(a && (b >= c)) || (d != e)'\'' '\''(a && b >= c) || d != e'\''
OK
$ diff-expr '\''(a && (b >= c)) || (d != e)'\'' '\''(a && (b >= c)) || d != e'\''
OK
$ test-expr '\''(a && b) >= (c || (d != e))'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 jump_true(9)
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ne)
9 cmp_op(ge)
$ diff-expr '\''(a && b) >= (c || (d != e))'\'' '\''(a && b) >= (c || d != e)'\''
OK
$ test-expr '\''a && (b >= (c || (d != e)))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_true(8)
5 call_builtin(d)
6 call_builtin(e)
7 cmp_op(ne)
8 cmp_op(ge)
$ diff-expr '\''a && (b >= (c || (d != e)))'\'' '\''a && b >= (c || (d != e))'\''
OK
$ diff-expr '\''a && (b >= (c || (d != e)))'\'' '\''a && b >= (c || d != e)'\''
OK
$ diff-expr '\''a && (b >= (c || (d != e)))'\'' '\''a && (b >= (c || d != e))'\''
OK
$ test-expr '\''(((a && b) != c) >= d) || e'\''
 0 call_builtin(a)
 1 jump_false(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 cmp_op(ne)
 6 call_builtin(d)
 7 cmp_op(ge)
 8 jump_true(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''(((a && b) != c) >= d) || e'\'' '\''((a && b) != c) >= d || e'\''
OK
$ test-expr '\''a && (((b != c) >= d) || e)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
7 jump_true(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''a && (((b != c) >= d) || e)'\'' '\''a && ((b != c) >= d || e)'\''
OK
$ test-expr '\''(a && ((b != c) >= d)) || e'\''
0 call_builtin(a)
1 jump_false*(8)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
7 jump_true(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''(a && ((b != c) >= d)) || e'\'' '\''a && ((b != c) >= d) || e'\''
OK
$ diff-expr '\''(a && ((b != c) >= d)) || e'\'' '\''a && (b != c) >= d || e'\''
OK
$ diff-expr '\''(a && ((b != c) >= d)) || e'\'' '\''(a && (b != c) >= d) || e'\''
OK
$ test-expr '\''(a && b) != ((c >= d) || e)'\''
 0 call_builtin(a)
 1 jump_false(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 call_builtin(d)
 6 cmp_op(ge)
 7 jump_true(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ne)
$ diff-expr '\''(a && b) != ((c >= d) || e)'\'' '\''(a && b) != (c >= d || e)'\''
OK
$ test-expr '\''a && (b != ((c >= d) || e))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 jump_true(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ne)
$ diff-expr '\''a && (b != ((c >= d) || e))'\'' '\''a && b != ((c >= d) || e)'\''
OK
$ diff-expr '\''a && (b != ((c >= d) || e))'\'' '\''a && b != (c >= d || e)'\''
OK
$ diff-expr '\''a && (b != ((c >= d) || e))'\'' '\''a && (b != (c >= d || e))'\''
OK
$ test-expr '\''((a && (b != c)) >= d) || e'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
7 jump_true(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''((a && (b != c)) >= d) || e'\'' '\''(a && (b != c)) >= d || e'\''
OK
$ diff-expr '\''((a && (b != c)) >= d) || e'\'' '\''(a && b != c) >= d || e'\''
OK
$ diff-expr '\''((a && (b != c)) >= d) || e'\'' '\''((a && b != c) >= d) || e'\''
OK
$ test-expr '\''a && ((b != (c >= d)) || e)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
7 jump_true(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''a && ((b != (c >= d)) || e)'\'' '\''a && (b != (c >= d) || e)'\''
OK
$ diff-expr '\''a && ((b != (c >= d)) || e)'\'' '\''a && (b != c >= d || e)'\''
OK
$ diff-expr '\''a && ((b != (c >= d)) || e)'\'' '\''a && ((b != c >= d) || e)'\''
OK
$ test-expr '\''((a && b) != (c >= d)) || e'\''
 0 call_builtin(a)
 1 jump_false(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 call_builtin(d)
 6 cmp_op(ge)
 7 cmp_op(ne)
 8 jump_true(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''((a && b) != (c >= d)) || e'\'' '\''(a && b) != (c >= d) || e'\''
OK
$ diff-expr '\''((a && b) != (c >= d)) || e'\'' '\''(a && b) != c >= d || e'\''
OK
$ diff-expr '\''((a && b) != (c >= d)) || e'\'' '\''((a && b) != c >= d) || e'\''
OK
$ test-expr '\''((a && b) != c) >= (d || e)'\''
 0 call_builtin(a)
 1 jump_false(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 cmp_op(ne)
 6 call_builtin(d)
 7 jump_true(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ge)
$ test-expr '\''a && ((b != c) >= (d || e))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 jump_true(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ge)
$ diff-expr '\''a && ((b != c) >= (d || e))'\'' '\''a && (b != c) >= (d || e)'\''
OK
$ test-expr '\''(a && (b != (c >= d))) || e'\''
0 call_builtin(a)
1 jump_false*(8)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
7 jump_true(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''(a && (b != (c >= d))) || e'\'' '\''a && (b != (c >= d)) || e'\''
OK
$ diff-expr '\''(a && (b != (c >= d))) || e'\'' '\''a && b != (c >= d) || e'\''
OK
$ diff-expr '\''(a && (b != (c >= d))) || e'\'' '\''a && b != c >= d || e'\''
OK
$ diff-expr '\''(a && (b != (c >= d))) || e'\'' '\''a && (b != c >= d) || e'\''
OK
$ diff-expr '\''(a && (b != (c >= d))) || e'\'' '\''(a && b != (c >= d)) || e'\''
OK
$ diff-expr '\''(a && (b != (c >= d))) || e'\'' '\''(a && b != c >= d) || e'\''
OK
$ diff-expr '\''(a && (b != (c >= d))) || e'\'' '\''(a && (b != c >= d)) || e'\''
OK
$ test-expr '\''(a && (b != c)) >= (d || e)'\''
0 call_builtin(a)
1 jump_false(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 jump_true(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ge)
$ diff-expr '\''(a && (b != c)) >= (d || e)'\'' '\''(a && b != c) >= (d || e)'\''
OK
$ test-expr '\''(a && b) != (c >= (d || e))'\''
 0 call_builtin(a)
 1 jump_false(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 call_builtin(d)
 6 jump_true(9)
 7 call_builtin(e)
 8 make_bool()
 9 cmp_op(ge)
10 cmp_op(ne)
$ diff-expr '\''(a && b) != (c >= (d || e))'\'' '\''(a && b) != c >= (d || e)'\''
OK
$ test-expr '\''a && (b != (c >= (d || e)))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 jump_true(8)
6 call_builtin(e)
7 make_bool()
8 cmp_op(ge)
9 cmp_op(ne)
$ diff-expr '\''a && (b != (c >= (d || e)))'\'' '\''a && b != (c >= (d || e))'\''
OK
$ diff-expr '\''a && (b != (c >= (d || e)))'\'' '\''a && b != c >= (d || e)'\''
OK
$ diff-expr '\''a && (b != (c >= (d || e)))'\'' '\''a && (b != c >= (d || e))'\''
OK
$ test-expr '\''(((a && b) != c) || d) >= e'\''
 0 call_builtin(a)
 1 jump_false(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 cmp_op(ne)
 6 jump_true(9)
 7 call_builtin(d)
 8 make_bool()
 9 call_builtin(e)
10 cmp_op(ge)
$ diff-expr '\''(((a && b) != c) || d) >= e'\'' '\''((a && b) != c || d) >= e'\''
OK
$ test-expr '\''a && (((b != c) || d) >= e)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 call_builtin(e)
9 cmp_op(ge)
$ diff-expr '\''a && (((b != c) || d) >= e)'\'' '\''a && ((b != c) || d) >= e'\''
OK
$ diff-expr '\''a && (((b != c) || d) >= e)'\'' '\''a && (b != c || d) >= e'\''
OK
$ diff-expr '\''a && (((b != c) || d) >= e)'\'' '\''a && ((b != c || d) >= e)'\''
OK
$ test-expr '\''(a && ((b != c) || d)) >= e'\''
0 call_builtin(a)
1 jump_false(8)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 call_builtin(e)
9 cmp_op(ge)
$ diff-expr '\''(a && ((b != c) || d)) >= e'\'' '\''(a && (b != c || d)) >= e'\''
OK
$ test-expr '\''(a && b) != ((c || d) >= e)'\''
 0 call_builtin(a)
 1 jump_false(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 jump_true(8)
 6 call_builtin(d)
 7 make_bool()
 8 call_builtin(e)
 9 cmp_op(ge)
10 cmp_op(ne)
$ diff-expr '\''(a && b) != ((c || d) >= e)'\'' '\''(a && b) != (c || d) >= e'\''
OK
$ test-expr '\''a && (b != ((c || d) >= e))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 call_builtin(e)
8 cmp_op(ge)
9 cmp_op(ne)
$ diff-expr '\''a && (b != ((c || d) >= e))'\'' '\''a && b != ((c || d) >= e)'\''
OK
$ diff-expr '\''a && (b != ((c || d) >= e))'\'' '\''a && b != (c || d) >= e'\''
OK
$ diff-expr '\''a && (b != ((c || d) >= e))'\'' '\''a && (b != (c || d) >= e)'\''
OK
$ test-expr '\''((a && (b != c)) || d) >= e'\''
0 call_builtin(a)
1 jump_false*(6)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(8)
6 call_builtin(d)
7 make_bool()
8 call_builtin(e)
9 cmp_op(ge)
$ diff-expr '\''((a && (b != c)) || d) >= e'\'' '\''(a && (b != c) || d) >= e'\''
OK
$ diff-expr '\''((a && (b != c)) || d) >= e'\'' '\''(a && b != c || d) >= e'\''
OK
$ diff-expr '\''((a && (b != c)) || d) >= e'\'' '\''((a && b != c) || d) >= e'\''
OK
$ test-expr '\''a && ((b != (c || d)) >= e)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
8 call_builtin(e)
9 cmp_op(ge)
$ diff-expr '\''a && ((b != (c || d)) >= e)'\'' '\''a && (b != (c || d)) >= e'\''
OK
$ test-expr '\''((a && b) != (c || d)) >= e'\''
 0 call_builtin(a)
 1 jump_false(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 jump_true(8)
 6 call_builtin(d)
 7 make_bool()
 8 cmp_op(ne)
 9 call_builtin(e)
10 cmp_op(ge)
$ test-expr '\''((a && b) != c) || (d >= e)'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 jump_true(eos)
7 call_builtin(d)
8 call_builtin(e)
9 cmp_op(ge)
$ diff-expr '\''((a && b) != c) || (d >= e)'\'' '\''(a && b) != c || (d >= e)'\''
OK
$ diff-expr '\''((a && b) != c) || (d >= e)'\'' '\''(a && b) != c || d >= e'\''
OK
$ diff-expr '\''((a && b) != c) || (d >= e)'\'' '\''((a && b) != c) || d >= e'\''
OK
$ test-expr '\''a && ((b != c) || (d >= e))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ge)
$ diff-expr '\''a && ((b != c) || (d >= e))'\'' '\''a && (b != c || (d >= e))'\''
OK
$ diff-expr '\''a && ((b != c) || (d >= e))'\'' '\''a && (b != c || d >= e)'\''
OK
$ diff-expr '\''a && ((b != c) || (d >= e))'\'' '\''a && ((b != c) || d >= e)'\''
OK
$ test-expr '\''(a && (b != (c || d))) >= e'\''
0 call_builtin(a)
1 jump_false(8)
2 call_builtin(b)
3 call_builtin(c)
4 jump_true(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
8 call_builtin(e)
9 cmp_op(ge)
$ diff-expr '\''(a && (b != (c || d))) >= e'\'' '\''(a && b != (c || d)) >= e'\''
OK
$ test-expr '\''(a && (b != c)) || (d >= e)'\''
0 call_builtin(a)
1 jump_false*(6)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_true(eos)
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ge)
$ diff-expr '\''(a && (b != c)) || (d >= e)'\'' '\''a && (b != c) || (d >= e)'\''
OK
$ diff-expr '\''(a && (b != c)) || (d >= e)'\'' '\''a && b != c || (d >= e)'\''
OK
$ diff-expr '\''(a && (b != c)) || (d >= e)'\'' '\''a && b != c || d >= e'\''
OK
$ diff-expr '\''(a && (b != c)) || (d >= e)'\'' '\''a && (b != c) || d >= e'\''
OK
$ diff-expr '\''(a && (b != c)) || (d >= e)'\'' '\''(a && b != c) || (d >= e)'\''
OK
$ diff-expr '\''(a && (b != c)) || (d >= e)'\'' '\''(a && b != c) || d >= e'\''
OK
$ diff-expr '\''(a && (b != c)) || (d >= e)'\'' '\''(a && (b != c)) || d >= e'\''
OK
$ test-expr '\''(a && b) != (c || (d >= e))'\''
0 call_builtin(a)
1 jump_false(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 jump_true(9)
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ge)
9 cmp_op(ne)
$ diff-expr '\''(a && b) != (c || (d >= e))'\'' '\''(a && b) != (c || d >= e)'\''
OK
$ test-expr '\''a && (b != (c || (d >= e)))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_true(8)
5 call_builtin(d)
6 call_builtin(e)
7 cmp_op(ge)
8 cmp_op(ne)
$ diff-expr '\''a && (b != (c || (d >= e)))'\'' '\''a && b != (c || (d >= e))'\''
OK
$ diff-expr '\''a && (b != (c || (d >= e)))'\'' '\''a && b != (c || d >= e)'\''
OK
$ diff-expr '\''a && (b != (c || (d >= e)))'\'' '\''a && (b != (c || d >= e))'\''
OK
$ test-expr '\''(((a && b) || c) >= d) != e'\''
 0 call_builtin(a)
 1 jump_false*(5)
 2 call_builtin(b)
 3 make_bool()
 4 jump_true(7)
 5 call_builtin(c)
 6 make_bool()
 7 call_builtin(d)
 8 cmp_op(ge)
 9 call_builtin(e)
10 cmp_op(ne)
$ diff-expr '\''(((a && b) || c) >= d) != e'\'' '\''((a && b) || c) >= d != e'\''
OK
$ diff-expr '\''(((a && b) || c) >= d) != e'\'' '\''(a && b || c) >= d != e'\''
OK
$ diff-expr '\''(((a && b) || c) >= d) != e'\'' '\''((a && b || c) >= d) != e'\''
OK
$ test-expr '\''a && (((b || c) >= d) != e)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''a && (((b || c) >= d) != e)'\'' '\''a && ((b || c) >= d) != e'\''
OK
$ diff-expr '\''a && (((b || c) >= d) != e)'\'' '\''a && (b || c) >= d != e'\''
OK
$ diff-expr '\''a && (((b || c) >= d) != e)'\'' '\''a && ((b || c) >= d != e)'\''
OK
$ test-expr '\''(a && ((b || c) >= d)) != e'\''
0 call_builtin(a)
1 jump_false(8)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''(a && ((b || c) >= d)) != e'\'' '\''(a && (b || c) >= d) != e'\''
OK
$ test-expr '\''(a && b) || ((c >= d) != e)'\''
0 call_builtin(a)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ge)
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''(a && b) || ((c >= d) != e)'\'' '\''a && b || ((c >= d) != e)'\''
OK
$ diff-expr '\''(a && b) || ((c >= d) != e)'\'' '\''a && b || (c >= d) != e'\''
OK
$ diff-expr '\''(a && b) || ((c >= d) != e)'\'' '\''a && b || c >= d != e'\''
OK
$ diff-expr '\''(a && b) || ((c >= d) != e)'\'' '\''a && b || (c >= d != e)'\''
OK
$ diff-expr '\''(a && b) || ((c >= d) != e)'\'' '\''(a && b) || (c >= d) != e'\''
OK
$ diff-expr '\''(a && b) || ((c >= d) != e)'\'' '\''(a && b) || c >= d != e'\''
OK
$ diff-expr '\''(a && b) || ((c >= d) != e)'\'' '\''(a && b) || (c >= d != e)'\''
OK
$ test-expr '\''a && (b || ((c >= d) != e))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
7 call_builtin(e)
8 cmp_op(ne)
$ diff-expr '\''a && (b || ((c >= d) != e))'\'' '\''a && (b || (c >= d) != e)'\''
OK
$ diff-expr '\''a && (b || ((c >= d) != e))'\'' '\''a && (b || c >= d != e)'\''
OK
$ diff-expr '\''a && (b || ((c >= d) != e))'\'' '\''a && (b || (c >= d != e))'\''
OK
$ test-expr '\''((a && (b || c)) >= d) != e'\''
0 call_builtin(a)
1 jump_false(6)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''((a && (b || c)) >= d) != e'\'' '\''(a && (b || c)) >= d != e'\''
OK
$ test-expr '\''a && ((b || (c >= d)) != e)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(7)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
7 call_builtin(e)
8 cmp_op(ne)
$ diff-expr '\''a && ((b || (c >= d)) != e)'\'' '\''a && (b || (c >= d)) != e'\''
OK
$ diff-expr '\''a && ((b || (c >= d)) != e)'\'' '\''a && (b || c >= d) != e'\''
OK
$ diff-expr '\''a && ((b || (c >= d)) != e)'\'' '\''a && ((b || c >= d) != e)'\''
OK
$ test-expr '\''((a && b) || (c >= d)) != e'\''
0 call_builtin(a)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(8)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ge)
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''((a && b) || (c >= d)) != e'\'' '\''(a && b || (c >= d)) != e'\''
OK
$ diff-expr '\''((a && b) || (c >= d)) != e'\'' '\''(a && b || c >= d) != e'\''
OK
$ diff-expr '\''((a && b) || (c >= d)) != e'\'' '\''((a && b) || c >= d) != e'\''
OK
$ test-expr '\''((a && b) || c) >= (d != e)'\''
 0 call_builtin(a)
 1 jump_false*(5)
 2 call_builtin(b)
 3 make_bool()
 4 jump_true(7)
 5 call_builtin(c)
 6 make_bool()
 7 call_builtin(d)
 8 call_builtin(e)
 9 cmp_op(ne)
10 cmp_op(ge)
$ diff-expr '\''((a && b) || c) >= (d != e)'\'' '\''(a && b || c) >= (d != e)'\''
OK
$ test-expr '\''a && ((b || c) >= (d != e))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ne)
9 cmp_op(ge)
$ diff-expr '\''a && ((b || c) >= (d != e))'\'' '\''a && (b || c) >= (d != e)'\''
OK
$ test-expr '\''(a && (b || (c >= d))) != e'\''
0 call_builtin(a)
1 jump_false(7)
2 call_builtin(b)
3 jump_true(7)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
7 call_builtin(e)
8 cmp_op(ne)
$ diff-expr '\''(a && (b || (c >= d))) != e'\'' '\''(a && (b || c >= d)) != e'\''
OK
$ test-expr '\''(a && (b || c)) >= (d != e)'\''
0 call_builtin(a)
1 jump_false(6)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ne)
9 cmp_op(ge)
$ test-expr '\''(a && b) || (c >= (d != e))'\''
0 call_builtin(a)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ne)
9 cmp_op(ge)
$ diff-expr '\''(a && b) || (c >= (d != e))'\'' '\''a && b || (c >= (d != e))'\''
OK
$ diff-expr '\''(a && b) || (c >= (d != e))'\'' '\''a && b || c >= (d != e)'\''
OK
$ diff-expr '\''(a && b) || (c >= (d != e))'\'' '\''(a && b) || c >= (d != e)'\''
OK
$ test-expr '\''a && (b || (c >= (d != e)))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(d)
6 call_builtin(e)
7 cmp_op(ne)
8 cmp_op(ge)
$ diff-expr '\''a && (b || (c >= (d != e)))'\'' '\''a && (b || c >= (d != e))'\''
OK
$ test-expr '\''(((a && b) || c) != d) >= e'\''
 0 call_builtin(a)
 1 jump_false*(5)
 2 call_builtin(b)
 3 make_bool()
 4 jump_true(7)
 5 call_builtin(c)
 6 make_bool()
 7 call_builtin(d)
 8 cmp_op(ne)
 9 call_builtin(e)
10 cmp_op(ge)
$ diff-expr '\''(((a && b) || c) != d) >= e'\'' '\''((a && b || c) != d) >= e'\''
OK
$ test-expr '\''a && (((b || c) != d) >= e)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
8 call_builtin(e)
9 cmp_op(ge)
$ diff-expr '\''a && (((b || c) != d) >= e)'\'' '\''a && ((b || c) != d) >= e'\''
OK
$ test-expr '\''(a && ((b || c) != d)) >= e'\''
0 call_builtin(a)
1 jump_false(8)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
8 call_builtin(e)
9 cmp_op(ge)
$ diff-expr '\''(a && ((b || c) != d)) >= e'\'' '\''(a && (b || c) != d) >= e'\''
OK
$ test-expr '\''(a && b) || ((c != d) >= e)'\''
0 call_builtin(a)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ne)
8 call_builtin(e)
9 cmp_op(ge)
$ diff-expr '\''(a && b) || ((c != d) >= e)'\'' '\''a && b || ((c != d) >= e)'\''
OK
$ diff-expr '\''(a && b) || ((c != d) >= e)'\'' '\''a && b || (c != d) >= e'\''
OK
$ diff-expr '\''(a && b) || ((c != d) >= e)'\'' '\''(a && b) || (c != d) >= e'\''
OK
$ test-expr '\''a && (b || ((c != d) >= e))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
7 call_builtin(e)
8 cmp_op(ge)
$ diff-expr '\''a && (b || ((c != d) >= e))'\'' '\''a && (b || (c != d) >= e)'\''
OK
$ test-expr '\''((a && (b || c)) != d) >= e'\''
0 call_builtin(a)
1 jump_false(6)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
8 call_builtin(e)
9 cmp_op(ge)
$ test-expr '\''a && ((b || (c != d)) >= e)'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(7)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
7 call_builtin(e)
8 cmp_op(ge)
$ diff-expr '\''a && ((b || (c != d)) >= e)'\'' '\''a && (b || (c != d)) >= e'\''
OK
$ diff-expr '\''a && ((b || (c != d)) >= e)'\'' '\''a && (b || c != d) >= e'\''
OK
$ diff-expr '\''a && ((b || (c != d)) >= e)'\'' '\''a && ((b || c != d) >= e)'\''
OK
$ test-expr '\''((a && b) || (c != d)) >= e'\''
0 call_builtin(a)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(8)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ne)
8 call_builtin(e)
9 cmp_op(ge)
$ diff-expr '\''((a && b) || (c != d)) >= e'\'' '\''(a && b || (c != d)) >= e'\''
OK
$ diff-expr '\''((a && b) || (c != d)) >= e'\'' '\''(a && b || c != d) >= e'\''
OK
$ diff-expr '\''((a && b) || (c != d)) >= e'\'' '\''((a && b) || c != d) >= e'\''
OK
$ test-expr '\''((a && b) || c) != (d >= e)'\''
 0 call_builtin(a)
 1 jump_false*(5)
 2 call_builtin(b)
 3 make_bool()
 4 jump_true(7)
 5 call_builtin(c)
 6 make_bool()
 7 call_builtin(d)
 8 call_builtin(e)
 9 cmp_op(ge)
10 cmp_op(ne)
$ diff-expr '\''((a && b) || c) != (d >= e)'\'' '\''(a && b || c) != (d >= e)'\''
OK
$ diff-expr '\''((a && b) || c) != (d >= e)'\'' '\''(a && b || c) != d >= e'\''
OK
$ diff-expr '\''((a && b) || c) != (d >= e)'\'' '\''((a && b) || c) != d >= e'\''
OK
$ test-expr '\''a && ((b || c) != (d >= e))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ge)
9 cmp_op(ne)
$ diff-expr '\''a && ((b || c) != (d >= e))'\'' '\''a && (b || c) != (d >= e)'\''
OK
$ diff-expr '\''a && ((b || c) != (d >= e))'\'' '\''a && (b || c) != d >= e'\''
OK
$ diff-expr '\''a && ((b || c) != (d >= e))'\'' '\''a && ((b || c) != d >= e)'\''
OK
$ test-expr '\''(a && (b || (c != d))) >= e'\''
0 call_builtin(a)
1 jump_false(7)
2 call_builtin(b)
3 jump_true(7)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
7 call_builtin(e)
8 cmp_op(ge)
$ diff-expr '\''(a && (b || (c != d))) >= e'\'' '\''(a && (b || c != d)) >= e'\''
OK
$ test-expr '\''(a && (b || c)) != (d >= e)'\''
0 call_builtin(a)
1 jump_false(6)
2 call_builtin(b)
3 jump_true(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ge)
9 cmp_op(ne)
$ diff-expr '\''(a && (b || c)) != (d >= e)'\'' '\''(a && (b || c)) != d >= e'\''
OK
$ test-expr '\''(a && b) || (c != (d >= e))'\''
0 call_builtin(a)
1 jump_false*(5)
2 call_builtin(b)
3 make_bool()
4 jump_true(eos)
5 call_builtin(c)
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ge)
9 cmp_op(ne)
$ diff-expr '\''(a && b) || (c != (d >= e))'\'' '\''a && b || (c != (d >= e))'\''
OK
$ diff-expr '\''(a && b) || (c != (d >= e))'\'' '\''a && b || c != (d >= e)'\''
OK
$ diff-expr '\''(a && b) || (c != (d >= e))'\'' '\''a && b || c != d >= e'\''
OK
$ diff-expr '\''(a && b) || (c != (d >= e))'\'' '\''a && b || (c != d >= e)'\''
OK
$ diff-expr '\''(a && b) || (c != (d >= e))'\'' '\''(a && b) || c != (d >= e)'\''
OK
$ diff-expr '\''(a && b) || (c != (d >= e))'\'' '\''(a && b) || c != d >= e'\''
OK
$ diff-expr '\''(a && b) || (c != (d >= e))'\'' '\''(a && b) || (c != d >= e)'\''
OK
$ test-expr '\''a && (b || (c != (d >= e)))'\''
0 call_builtin(a)
1 jump_false(eos)
2 call_builtin(b)
3 jump_true(eos)
4 call_builtin(c)
5 call_builtin(d)
6 call_builtin(e)
7 cmp_op(ge)
8 cmp_op(ne)
$ diff-expr '\''a && (b || (c != (d >= e)))'\'' '\''a && (b || c != (d >= e))'\''
OK
$ diff-expr '\''a && (b || (c != (d >= e)))'\'' '\''a && (b || c != d >= e)'\''
OK
$ diff-expr '\''a && (b || (c != (d >= e)))'\'' '\''a && (b || (c != d >= e))'\''
OK
$ test-expr '\''(((a || b) >= c) != d) && e'\''
 0 call_builtin(a)
 1 jump_true(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 cmp_op(ge)
 6 call_builtin(d)
 7 cmp_op(ne)
 8 jump_false(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''(((a || b) >= c) != d) && e'\'' '\''((a || b) >= c) != d && e'\''
OK
$ diff-expr '\''(((a || b) >= c) != d) && e'\'' '\''(a || b) >= c != d && e'\''
OK
$ diff-expr '\''(((a || b) >= c) != d) && e'\'' '\''((a || b) >= c != d) && e'\''
OK
$ test-expr '\''a || (((b >= c) != d) && e)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
7 jump_false(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''a || (((b >= c) != d) && e)'\'' '\''a || ((b >= c) != d) && e'\''
OK
$ diff-expr '\''a || (((b >= c) != d) && e)'\'' '\''a || (b >= c) != d && e'\''
OK
$ diff-expr '\''a || (((b >= c) != d) && e)'\'' '\''a || b >= c != d && e'\''
OK
$ diff-expr '\''a || (((b >= c) != d) && e)'\'' '\''a || (b >= c != d) && e'\''
OK
$ diff-expr '\''a || (((b >= c) != d) && e)'\'' '\''a || ((b >= c) != d && e)'\''
OK
$ diff-expr '\''a || (((b >= c) != d) && e)'\'' '\''a || (b >= c != d && e)'\''
OK
$ diff-expr '\''a || (((b >= c) != d) && e)'\'' '\''a || ((b >= c != d) && e)'\''
OK
$ test-expr '\''(a || ((b >= c) != d)) && e'\''
0 call_builtin(a)
1 jump_true*(8)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
7 jump_false(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''(a || ((b >= c) != d)) && e'\'' '\''(a || (b >= c) != d) && e'\''
OK
$ diff-expr '\''(a || ((b >= c) != d)) && e'\'' '\''(a || b >= c != d) && e'\''
OK
$ diff-expr '\''(a || ((b >= c) != d)) && e'\'' '\''(a || (b >= c != d)) && e'\''
OK
$ test-expr '\''(a || b) >= ((c != d) && e)'\''
 0 call_builtin(a)
 1 jump_true(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 call_builtin(d)
 6 cmp_op(ne)
 7 jump_false(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ge)
$ diff-expr '\''(a || b) >= ((c != d) && e)'\'' '\''(a || b) >= (c != d && e)'\''
OK
$ test-expr '\''a || (b >= ((c != d) && e))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 jump_false(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ge)
$ diff-expr '\''a || (b >= ((c != d) && e))'\'' '\''a || b >= ((c != d) && e)'\''
OK
$ diff-expr '\''a || (b >= ((c != d) && e))'\'' '\''a || b >= (c != d && e)'\''
OK
$ diff-expr '\''a || (b >= ((c != d) && e))'\'' '\''a || (b >= (c != d && e))'\''
OK
$ test-expr '\''((a || (b >= c)) != d) && e'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 cmp_op(ne)
7 jump_false(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''((a || (b >= c)) != d) && e'\'' '\''(a || (b >= c)) != d && e'\''
OK
$ diff-expr '\''((a || (b >= c)) != d) && e'\'' '\''(a || b >= c) != d && e'\''
OK
$ diff-expr '\''((a || (b >= c)) != d) && e'\'' '\''((a || b >= c) != d) && e'\''
OK
$ test-expr '\''a || ((b >= (c != d)) && e)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
7 jump_false(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''a || ((b >= (c != d)) && e)'\'' '\''a || (b >= (c != d)) && e'\''
OK
$ diff-expr '\''a || ((b >= (c != d)) && e)'\'' '\''a || b >= (c != d) && e'\''
OK
$ diff-expr '\''a || ((b >= (c != d)) && e)'\'' '\''a || (b >= (c != d) && e)'\''
OK
$ test-expr '\''((a || b) >= (c != d)) && e'\''
 0 call_builtin(a)
 1 jump_true(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 call_builtin(d)
 6 cmp_op(ne)
 7 cmp_op(ge)
 8 jump_false(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''((a || b) >= (c != d)) && e'\'' '\''(a || b) >= (c != d) && e'\''
OK
$ test-expr '\''((a || b) >= c) != (d && e)'\''
 0 call_builtin(a)
 1 jump_true(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 cmp_op(ge)
 6 call_builtin(d)
 7 jump_false(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ne)
$ diff-expr '\''((a || b) >= c) != (d && e)'\'' '\''(a || b) >= c != (d && e)'\''
OK
$ test-expr '\''a || ((b >= c) != (d && e))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 jump_false(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ne)
$ diff-expr '\''a || ((b >= c) != (d && e))'\'' '\''a || (b >= c) != (d && e)'\''
OK
$ diff-expr '\''a || ((b >= c) != (d && e))'\'' '\''a || b >= c != (d && e)'\''
OK
$ diff-expr '\''a || ((b >= c) != (d && e))'\'' '\''a || (b >= c != (d && e))'\''
OK
$ test-expr '\''(a || (b >= (c != d))) && e'\''
0 call_builtin(a)
1 jump_true*(8)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ne)
6 cmp_op(ge)
7 jump_false(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''(a || (b >= (c != d))) && e'\'' '\''(a || b >= (c != d)) && e'\''
OK
$ test-expr '\''(a || (b >= c)) != (d && e)'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 call_builtin(d)
6 jump_false(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ne)
$ diff-expr '\''(a || (b >= c)) != (d && e)'\'' '\''(a || b >= c) != (d && e)'\''
OK
$ test-expr '\''(a || b) >= (c != (d && e))'\''
 0 call_builtin(a)
 1 jump_true(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 call_builtin(d)
 6 jump_false(9)
 7 call_builtin(e)
 8 make_bool()
 9 cmp_op(ne)
10 cmp_op(ge)
$ test-expr '\''a || (b >= (c != (d && e)))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 jump_false(8)
6 call_builtin(e)
7 make_bool()
8 cmp_op(ne)
9 cmp_op(ge)
$ diff-expr '\''a || (b >= (c != (d && e)))'\'' '\''a || b >= (c != (d && e))'\''
OK
$ test-expr '\''(((a || b) >= c) && d) != e'\''
 0 call_builtin(a)
 1 jump_true(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 cmp_op(ge)
 6 jump_false(9)
 7 call_builtin(d)
 8 make_bool()
 9 call_builtin(e)
10 cmp_op(ne)
$ diff-expr '\''(((a || b) >= c) && d) != e'\'' '\''((a || b) >= c && d) != e'\''
OK
$ test-expr '\''a || (((b >= c) && d) != e)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''a || (((b >= c) && d) != e)'\'' '\''a || ((b >= c) && d) != e'\''
OK
$ diff-expr '\''a || (((b >= c) && d) != e)'\'' '\''a || (b >= c && d) != e'\''
OK
$ diff-expr '\''a || (((b >= c) && d) != e)'\'' '\''a || ((b >= c && d) != e)'\''
OK
$ test-expr '\''(a || ((b >= c) && d)) != e'\''
0 call_builtin(a)
1 jump_true(8)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''(a || ((b >= c) && d)) != e'\'' '\''(a || (b >= c) && d) != e'\''
OK
$ diff-expr '\''(a || ((b >= c) && d)) != e'\'' '\''(a || b >= c && d) != e'\''
OK
$ diff-expr '\''(a || ((b >= c) && d)) != e'\'' '\''(a || (b >= c && d)) != e'\''
OK
$ test-expr '\''(a || b) >= ((c && d) != e)'\''
 0 call_builtin(a)
 1 jump_true(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 jump_false(8)
 6 call_builtin(d)
 7 make_bool()
 8 call_builtin(e)
 9 cmp_op(ne)
10 cmp_op(ge)
$ test-expr '\''a || (b >= ((c && d) != e))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 call_builtin(e)
8 cmp_op(ne)
9 cmp_op(ge)
$ diff-expr '\''a || (b >= ((c && d) != e))'\'' '\''a || b >= ((c && d) != e)'\''
OK
$ test-expr '\''((a || (b >= c)) && d) != e'\''
0 call_builtin(a)
1 jump_true*(6)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''((a || (b >= c)) && d) != e'\'' '\''((a || b >= c) && d) != e'\''
OK
$ test-expr '\''a || ((b >= (c && d)) != e)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''a || ((b >= (c && d)) != e)'\'' '\''a || (b >= (c && d)) != e'\''
OK
$ diff-expr '\''a || ((b >= (c && d)) != e)'\'' '\''a || b >= (c && d) != e'\''
OK
$ diff-expr '\''a || ((b >= (c && d)) != e)'\'' '\''a || (b >= (c && d) != e)'\''
OK
$ test-expr '\''((a || b) >= (c && d)) != e'\''
 0 call_builtin(a)
 1 jump_true(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 jump_false(8)
 6 call_builtin(d)
 7 make_bool()
 8 cmp_op(ge)
 9 call_builtin(e)
10 cmp_op(ne)
$ diff-expr '\''((a || b) >= (c && d)) != e'\'' '\''(a || b) >= (c && d) != e'\''
OK
$ test-expr '\''((a || b) >= c) && (d != e)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ge)
6 jump_false(eos)
7 call_builtin(d)
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''((a || b) >= c) && (d != e)'\'' '\''(a || b) >= c && (d != e)'\''
OK
$ diff-expr '\''((a || b) >= c) && (d != e)'\'' '\''(a || b) >= c && d != e'\''
OK
$ diff-expr '\''((a || b) >= c) && (d != e)'\'' '\''((a || b) >= c) && d != e'\''
OK
$ test-expr '\''a || ((b >= c) && (d != e))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ne)
$ diff-expr '\''a || ((b >= c) && (d != e))'\'' '\''a || (b >= c) && (d != e)'\''
OK
$ diff-expr '\''a || ((b >= c) && (d != e))'\'' '\''a || b >= c && (d != e)'\''
OK
$ diff-expr '\''a || ((b >= c) && (d != e))'\'' '\''a || b >= c && d != e'\''
OK
$ diff-expr '\''a || ((b >= c) && (d != e))'\'' '\''a || (b >= c) && d != e'\''
OK
$ diff-expr '\''a || ((b >= c) && (d != e))'\'' '\''a || (b >= c && (d != e))'\''
OK
$ diff-expr '\''a || ((b >= c) && (d != e))'\'' '\''a || (b >= c && d != e)'\''
OK
$ diff-expr '\''a || ((b >= c) && (d != e))'\'' '\''a || ((b >= c) && d != e)'\''
OK
$ test-expr '\''(a || (b >= (c && d))) != e'\''
0 call_builtin(a)
1 jump_true(8)
2 call_builtin(b)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ge)
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''(a || (b >= (c && d))) != e'\'' '\''(a || b >= (c && d)) != e'\''
OK
$ test-expr '\''(a || (b >= c)) && (d != e)'\''
0 call_builtin(a)
1 jump_true*(6)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ge)
5 jump_false(eos)
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ne)
$ diff-expr '\''(a || (b >= c)) && (d != e)'\'' '\''(a || b >= c) && (d != e)'\''
OK
$ diff-expr '\''(a || (b >= c)) && (d != e)'\'' '\''(a || b >= c) && d != e'\''
OK
$ diff-expr '\''(a || (b >= c)) && (d != e)'\'' '\''(a || (b >= c)) && d != e'\''
OK
$ test-expr '\''(a || b) >= (c && (d != e))'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 jump_false(9)
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ne)
9 cmp_op(ge)
$ diff-expr '\''(a || b) >= (c && (d != e))'\'' '\''(a || b) >= (c && d != e)'\''
OK
$ test-expr '\''a || (b >= (c && (d != e)))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_false(8)
5 call_builtin(d)
6 call_builtin(e)
7 cmp_op(ne)
8 cmp_op(ge)
$ diff-expr '\''a || (b >= (c && (d != e)))'\'' '\''a || b >= (c && (d != e))'\''
OK
$ diff-expr '\''a || (b >= (c && (d != e)))'\'' '\''a || b >= (c && d != e)'\''
OK
$ diff-expr '\''a || (b >= (c && (d != e)))'\'' '\''a || (b >= (c && d != e))'\''
OK
$ test-expr '\''(((a || b) != c) >= d) && e'\''
 0 call_builtin(a)
 1 jump_true(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 cmp_op(ne)
 6 call_builtin(d)
 7 cmp_op(ge)
 8 jump_false(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''(((a || b) != c) >= d) && e'\'' '\''((a || b) != c) >= d && e'\''
OK
$ test-expr '\''a || (((b != c) >= d) && e)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
7 jump_false(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''a || (((b != c) >= d) && e)'\'' '\''a || ((b != c) >= d) && e'\''
OK
$ diff-expr '\''a || (((b != c) >= d) && e)'\'' '\''a || (b != c) >= d && e'\''
OK
$ diff-expr '\''a || (((b != c) >= d) && e)'\'' '\''a || ((b != c) >= d && e)'\''
OK
$ test-expr '\''(a || ((b != c) >= d)) && e'\''
0 call_builtin(a)
1 jump_true*(8)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
7 jump_false(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''(a || ((b != c) >= d)) && e'\'' '\''(a || (b != c) >= d) && e'\''
OK
$ test-expr '\''(a || b) != ((c >= d) && e)'\''
 0 call_builtin(a)
 1 jump_true(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 call_builtin(d)
 6 cmp_op(ge)
 7 jump_false(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ne)
$ diff-expr '\''(a || b) != ((c >= d) && e)'\'' '\''(a || b) != (c >= d && e)'\''
OK
$ test-expr '\''a || (b != ((c >= d) && e))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 jump_false(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ne)
$ diff-expr '\''a || (b != ((c >= d) && e))'\'' '\''a || b != ((c >= d) && e)'\''
OK
$ diff-expr '\''a || (b != ((c >= d) && e))'\'' '\''a || b != (c >= d && e)'\''
OK
$ diff-expr '\''a || (b != ((c >= d) && e))'\'' '\''a || (b != (c >= d && e))'\''
OK
$ test-expr '\''((a || (b != c)) >= d) && e'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 cmp_op(ge)
7 jump_false(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''((a || (b != c)) >= d) && e'\'' '\''(a || (b != c)) >= d && e'\''
OK
$ diff-expr '\''((a || (b != c)) >= d) && e'\'' '\''(a || b != c) >= d && e'\''
OK
$ diff-expr '\''((a || (b != c)) >= d) && e'\'' '\''((a || b != c) >= d) && e'\''
OK
$ test-expr '\''a || ((b != (c >= d)) && e)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
7 jump_false(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''a || ((b != (c >= d)) && e)'\'' '\''a || (b != (c >= d)) && e'\''
OK
$ diff-expr '\''a || ((b != (c >= d)) && e)'\'' '\''a || b != (c >= d) && e'\''
OK
$ diff-expr '\''a || ((b != (c >= d)) && e)'\'' '\''a || b != c >= d && e'\''
OK
$ diff-expr '\''a || ((b != (c >= d)) && e)'\'' '\''a || (b != c >= d) && e'\''
OK
$ diff-expr '\''a || ((b != (c >= d)) && e)'\'' '\''a || (b != (c >= d) && e)'\''
OK
$ diff-expr '\''a || ((b != (c >= d)) && e)'\'' '\''a || (b != c >= d && e)'\''
OK
$ diff-expr '\''a || ((b != (c >= d)) && e)'\'' '\''a || ((b != c >= d) && e)'\''
OK
$ test-expr '\''((a || b) != (c >= d)) && e'\''
 0 call_builtin(a)
 1 jump_true(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 call_builtin(d)
 6 cmp_op(ge)
 7 cmp_op(ne)
 8 jump_false(eos)
 9 call_builtin(e)
10 make_bool()
$ diff-expr '\''((a || b) != (c >= d)) && e'\'' '\''(a || b) != (c >= d) && e'\''
OK
$ diff-expr '\''((a || b) != (c >= d)) && e'\'' '\''(a || b) != c >= d && e'\''
OK
$ diff-expr '\''((a || b) != (c >= d)) && e'\'' '\''((a || b) != c >= d) && e'\''
OK
$ test-expr '\''((a || b) != c) >= (d && e)'\''
 0 call_builtin(a)
 1 jump_true(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 cmp_op(ne)
 6 call_builtin(d)
 7 jump_false(10)
 8 call_builtin(e)
 9 make_bool()
10 cmp_op(ge)
$ test-expr '\''a || ((b != c) >= (d && e))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 jump_false(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ge)
$ diff-expr '\''a || ((b != c) >= (d && e))'\'' '\''a || (b != c) >= (d && e)'\''
OK
$ test-expr '\''(a || (b != (c >= d))) && e'\''
0 call_builtin(a)
1 jump_true*(8)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 cmp_op(ge)
6 cmp_op(ne)
7 jump_false(eos)
8 call_builtin(e)
9 make_bool()
$ diff-expr '\''(a || (b != (c >= d))) && e'\'' '\''(a || b != (c >= d)) && e'\''
OK
$ diff-expr '\''(a || (b != (c >= d))) && e'\'' '\''(a || b != c >= d) && e'\''
OK
$ diff-expr '\''(a || (b != (c >= d))) && e'\'' '\''(a || (b != c >= d)) && e'\''
OK
$ test-expr '\''(a || (b != c)) >= (d && e)'\''
0 call_builtin(a)
1 jump_true(5)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 call_builtin(d)
6 jump_false(9)
7 call_builtin(e)
8 make_bool()
9 cmp_op(ge)
$ diff-expr '\''(a || (b != c)) >= (d && e)'\'' '\''(a || b != c) >= (d && e)'\''
OK
$ test-expr '\''(a || b) != (c >= (d && e))'\''
 0 call_builtin(a)
 1 jump_true(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 call_builtin(d)
 6 jump_false(9)
 7 call_builtin(e)
 8 make_bool()
 9 cmp_op(ge)
10 cmp_op(ne)
$ diff-expr '\''(a || b) != (c >= (d && e))'\'' '\''(a || b) != c >= (d && e)'\''
OK
$ test-expr '\''a || (b != (c >= (d && e)))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 call_builtin(d)
5 jump_false(8)
6 call_builtin(e)
7 make_bool()
8 cmp_op(ge)
9 cmp_op(ne)
$ diff-expr '\''a || (b != (c >= (d && e)))'\'' '\''a || b != (c >= (d && e))'\''
OK
$ diff-expr '\''a || (b != (c >= (d && e)))'\'' '\''a || b != c >= (d && e)'\''
OK
$ diff-expr '\''a || (b != (c >= (d && e)))'\'' '\''a || (b != c >= (d && e))'\''
OK
$ test-expr '\''(((a || b) != c) && d) >= e'\''
 0 call_builtin(a)
 1 jump_true(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 cmp_op(ne)
 6 jump_false(9)
 7 call_builtin(d)
 8 make_bool()
 9 call_builtin(e)
10 cmp_op(ge)
$ diff-expr '\''(((a || b) != c) && d) >= e'\'' '\''((a || b) != c && d) >= e'\''
OK
$ test-expr '\''a || (((b != c) && d) >= e)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 call_builtin(e)
9 cmp_op(ge)
$ diff-expr '\''a || (((b != c) && d) >= e)'\'' '\''a || ((b != c) && d) >= e'\''
OK
$ diff-expr '\''a || (((b != c) && d) >= e)'\'' '\''a || (b != c && d) >= e'\''
OK
$ diff-expr '\''a || (((b != c) && d) >= e)'\'' '\''a || ((b != c && d) >= e)'\''
OK
$ test-expr '\''(a || ((b != c) && d)) >= e'\''
0 call_builtin(a)
1 jump_true(8)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 call_builtin(e)
9 cmp_op(ge)
$ diff-expr '\''(a || ((b != c) && d)) >= e'\'' '\''(a || (b != c) && d) >= e'\''
OK
$ diff-expr '\''(a || ((b != c) && d)) >= e'\'' '\''(a || b != c && d) >= e'\''
OK
$ diff-expr '\''(a || ((b != c) && d)) >= e'\'' '\''(a || (b != c && d)) >= e'\''
OK
$ test-expr '\''(a || b) != ((c && d) >= e)'\''
 0 call_builtin(a)
 1 jump_true(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 jump_false(8)
 6 call_builtin(d)
 7 make_bool()
 8 call_builtin(e)
 9 cmp_op(ge)
10 cmp_op(ne)
$ diff-expr '\''(a || b) != ((c && d) >= e)'\'' '\''(a || b) != (c && d) >= e'\''
OK
$ test-expr '\''a || (b != ((c && d) >= e))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 call_builtin(e)
8 cmp_op(ge)
9 cmp_op(ne)
$ diff-expr '\''a || (b != ((c && d) >= e))'\'' '\''a || b != ((c && d) >= e)'\''
OK
$ diff-expr '\''a || (b != ((c && d) >= e))'\'' '\''a || b != (c && d) >= e'\''
OK
$ diff-expr '\''a || (b != ((c && d) >= e))'\'' '\''a || (b != (c && d) >= e)'\''
OK
$ test-expr '\''((a || (b != c)) && d) >= e'\''
0 call_builtin(a)
1 jump_true*(6)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(8)
6 call_builtin(d)
7 make_bool()
8 call_builtin(e)
9 cmp_op(ge)
$ diff-expr '\''((a || (b != c)) && d) >= e'\'' '\''((a || b != c) && d) >= e'\''
OK
$ test-expr '\''a || ((b != (c && d)) >= e)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
8 call_builtin(e)
9 cmp_op(ge)
$ diff-expr '\''a || ((b != (c && d)) >= e)'\'' '\''a || (b != (c && d)) >= e'\''
OK
$ test-expr '\''((a || b) != (c && d)) >= e'\''
 0 call_builtin(a)
 1 jump_true(4)
 2 call_builtin(b)
 3 make_bool()
 4 call_builtin(c)
 5 jump_false(8)
 6 call_builtin(d)
 7 make_bool()
 8 cmp_op(ne)
 9 call_builtin(e)
10 cmp_op(ge)
$ test-expr '\''((a || b) != c) && (d >= e)'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 cmp_op(ne)
6 jump_false(eos)
7 call_builtin(d)
8 call_builtin(e)
9 cmp_op(ge)
$ diff-expr '\''((a || b) != c) && (d >= e)'\'' '\''(a || b) != c && (d >= e)'\''
OK
$ diff-expr '\''((a || b) != c) && (d >= e)'\'' '\''(a || b) != c && d >= e'\''
OK
$ diff-expr '\''((a || b) != c) && (d >= e)'\'' '\''((a || b) != c) && d >= e'\''
OK
$ test-expr '\''a || ((b != c) && (d >= e))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ge)
$ diff-expr '\''a || ((b != c) && (d >= e))'\'' '\''a || (b != c) && (d >= e)'\''
OK
$ diff-expr '\''a || ((b != c) && (d >= e))'\'' '\''a || b != c && (d >= e)'\''
OK
$ diff-expr '\''a || ((b != c) && (d >= e))'\'' '\''a || b != c && d >= e'\''
OK
$ diff-expr '\''a || ((b != c) && (d >= e))'\'' '\''a || (b != c) && d >= e'\''
OK
$ diff-expr '\''a || ((b != c) && (d >= e))'\'' '\''a || (b != c && (d >= e))'\''
OK
$ diff-expr '\''a || ((b != c) && (d >= e))'\'' '\''a || (b != c && d >= e)'\''
OK
$ diff-expr '\''a || ((b != c) && (d >= e))'\'' '\''a || ((b != c) && d >= e)'\''
OK
$ test-expr '\''(a || (b != (c && d))) >= e'\''
0 call_builtin(a)
1 jump_true(8)
2 call_builtin(b)
3 call_builtin(c)
4 jump_false(7)
5 call_builtin(d)
6 make_bool()
7 cmp_op(ne)
8 call_builtin(e)
9 cmp_op(ge)
$ diff-expr '\''(a || (b != (c && d))) >= e'\'' '\''(a || b != (c && d)) >= e'\''
OK
$ test-expr '\''(a || (b != c)) && (d >= e)'\''
0 call_builtin(a)
1 jump_true*(6)
2 call_builtin(b)
3 call_builtin(c)
4 cmp_op(ne)
5 jump_false(eos)
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ge)
$ diff-expr '\''(a || (b != c)) && (d >= e)'\'' '\''(a || b != c) && (d >= e)'\''
OK
$ diff-expr '\''(a || (b != c)) && (d >= e)'\'' '\''(a || b != c) && d >= e'\''
OK
$ diff-expr '\''(a || (b != c)) && (d >= e)'\'' '\''(a || (b != c)) && d >= e'\''
OK
$ test-expr '\''(a || b) != (c && (d >= e))'\''
0 call_builtin(a)
1 jump_true(4)
2 call_builtin(b)
3 make_bool()
4 call_builtin(c)
5 jump_false(9)
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ge)
9 cmp_op(ne)
$ diff-expr '\''(a || b) != (c && (d >= e))'\'' '\''(a || b) != (c && d >= e)'\''
OK
$ test-expr '\''a || (b != (c && (d >= e)))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 call_builtin(c)
4 jump_false(8)
5 call_builtin(d)
6 call_builtin(e)
7 cmp_op(ge)
8 cmp_op(ne)
$ diff-expr '\''a || (b != (c && (d >= e)))'\'' '\''a || b != (c && (d >= e))'\''
OK
$ diff-expr '\''a || (b != (c && (d >= e)))'\'' '\''a || b != (c && d >= e)'\''
OK
$ diff-expr '\''a || (b != (c && (d >= e)))'\'' '\''a || (b != (c && d >= e))'\''
OK
$ test-expr '\''(((a || b) && c) >= d) != e'\''
 0 call_builtin(a)
 1 jump_true*(5)
 2 call_builtin(b)
 3 make_bool()
 4 jump_false(7)
 5 call_builtin(c)
 6 make_bool()
 7 call_builtin(d)
 8 cmp_op(ge)
 9 call_builtin(e)
10 cmp_op(ne)
$ diff-expr '\''(((a || b) && c) >= d) != e'\'' '\''((a || b) && c) >= d != e'\''
OK
$ test-expr '\''a || (((b && c) >= d) != e)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''a || (((b && c) >= d) != e)'\'' '\''a || ((b && c) >= d) != e'\''
OK
$ diff-expr '\''a || (((b && c) >= d) != e)'\'' '\''a || (b && c) >= d != e'\''
OK
$ diff-expr '\''a || (((b && c) >= d) != e)'\'' '\''a || ((b && c) >= d != e)'\''
OK
$ test-expr '\''(a || ((b && c) >= d)) != e'\''
0 call_builtin(a)
1 jump_true(8)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''(a || ((b && c) >= d)) != e'\'' '\''(a || (b && c) >= d) != e'\''
OK
$ test-expr '\''(a || b) && ((c >= d) != e)'\''
0 call_builtin(a)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ge)
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''(a || b) && ((c >= d) != e)'\'' '\''(a || b) && (c >= d) != e'\''
OK
$ diff-expr '\''(a || b) && ((c >= d) != e)'\'' '\''(a || b) && c >= d != e'\''
OK
$ diff-expr '\''(a || b) && ((c >= d) != e)'\'' '\''(a || b) && (c >= d != e)'\''
OK
$ test-expr '\''a || (b && ((c >= d) != e))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
7 call_builtin(e)
8 cmp_op(ne)
$ diff-expr '\''a || (b && ((c >= d) != e))'\'' '\''a || b && ((c >= d) != e)'\''
OK
$ diff-expr '\''a || (b && ((c >= d) != e))'\'' '\''a || b && (c >= d) != e'\''
OK
$ diff-expr '\''a || (b && ((c >= d) != e))'\'' '\''a || b && c >= d != e'\''
OK
$ diff-expr '\''a || (b && ((c >= d) != e))'\'' '\''a || b && (c >= d != e)'\''
OK
$ diff-expr '\''a || (b && ((c >= d) != e))'\'' '\''a || (b && (c >= d) != e)'\''
OK
$ diff-expr '\''a || (b && ((c >= d) != e))'\'' '\''a || (b && c >= d != e)'\''
OK
$ diff-expr '\''a || (b && ((c >= d) != e))'\'' '\''a || (b && (c >= d != e))'\''
OK
$ test-expr '\''((a || (b && c)) >= d) != e'\''
0 call_builtin(a)
1 jump_true(6)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ge)
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''((a || (b && c)) >= d) != e'\'' '\''(a || (b && c)) >= d != e'\''
OK
$ diff-expr '\''((a || (b && c)) >= d) != e'\'' '\''(a || b && c) >= d != e'\''
OK
$ diff-expr '\''((a || (b && c)) >= d) != e'\'' '\''((a || b && c) >= d) != e'\''
OK
$ test-expr '\''a || ((b && (c >= d)) != e)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(7)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
7 call_builtin(e)
8 cmp_op(ne)
$ diff-expr '\''a || ((b && (c >= d)) != e)'\'' '\''a || (b && (c >= d)) != e'\''
OK
$ diff-expr '\''a || ((b && (c >= d)) != e)'\'' '\''a || (b && c >= d) != e'\''
OK
$ diff-expr '\''a || ((b && (c >= d)) != e)'\'' '\''a || ((b && c >= d) != e)'\''
OK
$ test-expr '\''((a || b) && (c >= d)) != e'\''
0 call_builtin(a)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(8)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ge)
8 call_builtin(e)
9 cmp_op(ne)
$ diff-expr '\''((a || b) && (c >= d)) != e'\'' '\''((a || b) && c >= d) != e'\''
OK
$ test-expr '\''((a || b) && c) >= (d != e)'\''
 0 call_builtin(a)
 1 jump_true*(5)
 2 call_builtin(b)
 3 make_bool()
 4 jump_false(7)
 5 call_builtin(c)
 6 make_bool()
 7 call_builtin(d)
 8 call_builtin(e)
 9 cmp_op(ne)
10 cmp_op(ge)
$ test-expr '\''a || ((b && c) >= (d != e))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ne)
9 cmp_op(ge)
$ diff-expr '\''a || ((b && c) >= (d != e))'\'' '\''a || (b && c) >= (d != e)'\''
OK
$ test-expr '\''(a || (b && (c >= d))) != e'\''
0 call_builtin(a)
1 jump_true(7)
2 call_builtin(b)
3 jump_false(7)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ge)
7 call_builtin(e)
8 cmp_op(ne)
$ diff-expr '\''(a || (b && (c >= d))) != e'\'' '\''(a || b && (c >= d)) != e'\''
OK
$ diff-expr '\''(a || (b && (c >= d))) != e'\'' '\''(a || b && c >= d) != e'\''
OK
$ diff-expr '\''(a || (b && (c >= d))) != e'\'' '\''(a || (b && c >= d)) != e'\''
OK
$ test-expr '\''(a || (b && c)) >= (d != e)'\''
0 call_builtin(a)
1 jump_true(6)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ne)
9 cmp_op(ge)
$ diff-expr '\''(a || (b && c)) >= (d != e)'\'' '\''(a || b && c) >= (d != e)'\''
OK
$ test-expr '\''(a || b) && (c >= (d != e))'\''
0 call_builtin(a)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ne)
9 cmp_op(ge)
$ diff-expr '\''(a || b) && (c >= (d != e))'\'' '\''(a || b) && c >= (d != e)'\''
OK
$ test-expr '\''a || (b && (c >= (d != e)))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(d)
6 call_builtin(e)
7 cmp_op(ne)
8 cmp_op(ge)
$ diff-expr '\''a || (b && (c >= (d != e)))'\'' '\''a || b && (c >= (d != e))'\''
OK
$ diff-expr '\''a || (b && (c >= (d != e)))'\'' '\''a || b && c >= (d != e)'\''
OK
$ diff-expr '\''a || (b && (c >= (d != e)))'\'' '\''a || (b && c >= (d != e))'\''
OK
$ test-expr '\''(((a || b) && c) != d) >= e'\''
 0 call_builtin(a)
 1 jump_true*(5)
 2 call_builtin(b)
 3 make_bool()
 4 jump_false(7)
 5 call_builtin(c)
 6 make_bool()
 7 call_builtin(d)
 8 cmp_op(ne)
 9 call_builtin(e)
10 cmp_op(ge)
$ test-expr '\''a || (((b && c) != d) >= e)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
8 call_builtin(e)
9 cmp_op(ge)
$ diff-expr '\''a || (((b && c) != d) >= e)'\'' '\''a || ((b && c) != d) >= e'\''
OK
$ test-expr '\''(a || ((b && c) != d)) >= e'\''
0 call_builtin(a)
1 jump_true(8)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
8 call_builtin(e)
9 cmp_op(ge)
$ diff-expr '\''(a || ((b && c) != d)) >= e'\'' '\''(a || (b && c) != d) >= e'\''
OK
$ test-expr '\''(a || b) && ((c != d) >= e)'\''
0 call_builtin(a)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ne)
8 call_builtin(e)
9 cmp_op(ge)
$ diff-expr '\''(a || b) && ((c != d) >= e)'\'' '\''(a || b) && (c != d) >= e'\''
OK
$ test-expr '\''a || (b && ((c != d) >= e))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
7 call_builtin(e)
8 cmp_op(ge)
$ diff-expr '\''a || (b && ((c != d) >= e))'\'' '\''a || b && ((c != d) >= e)'\''
OK
$ diff-expr '\''a || (b && ((c != d) >= e))'\'' '\''a || b && (c != d) >= e'\''
OK
$ diff-expr '\''a || (b && ((c != d) >= e))'\'' '\''a || (b && (c != d) >= e)'\''
OK
$ test-expr '\''((a || (b && c)) != d) >= e'\''
0 call_builtin(a)
1 jump_true(6)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 cmp_op(ne)
8 call_builtin(e)
9 cmp_op(ge)
$ diff-expr '\''((a || (b && c)) != d) >= e'\'' '\''((a || b && c) != d) >= e'\''
OK
$ test-expr '\''a || ((b && (c != d)) >= e)'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(7)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
7 call_builtin(e)
8 cmp_op(ge)
$ diff-expr '\''a || ((b && (c != d)) >= e)'\'' '\''a || (b && (c != d)) >= e'\''
OK
$ diff-expr '\''a || ((b && (c != d)) >= e)'\'' '\''a || (b && c != d) >= e'\''
OK
$ diff-expr '\''a || ((b && (c != d)) >= e)'\'' '\''a || ((b && c != d) >= e)'\''
OK
$ test-expr '\''((a || b) && (c != d)) >= e'\''
0 call_builtin(a)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(8)
5 call_builtin(c)
6 call_builtin(d)
7 cmp_op(ne)
8 call_builtin(e)
9 cmp_op(ge)
$ diff-expr '\''((a || b) && (c != d)) >= e'\'' '\''((a || b) && c != d) >= e'\''
OK
$ test-expr '\''((a || b) && c) != (d >= e)'\''
 0 call_builtin(a)
 1 jump_true*(5)
 2 call_builtin(b)
 3 make_bool()
 4 jump_false(7)
 5 call_builtin(c)
 6 make_bool()
 7 call_builtin(d)
 8 call_builtin(e)
 9 cmp_op(ge)
10 cmp_op(ne)
$ diff-expr '\''((a || b) && c) != (d >= e)'\'' '\''((a || b) && c) != d >= e'\''
OK
$ test-expr '\''a || ((b && c) != (d >= e))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ge)
9 cmp_op(ne)
$ diff-expr '\''a || ((b && c) != (d >= e))'\'' '\''a || (b && c) != (d >= e)'\''
OK
$ diff-expr '\''a || ((b && c) != (d >= e))'\'' '\''a || (b && c) != d >= e'\''
OK
$ diff-expr '\''a || ((b && c) != (d >= e))'\'' '\''a || ((b && c) != d >= e)'\''
OK
$ test-expr '\''(a || (b && (c != d))) >= e'\''
0 call_builtin(a)
1 jump_true(7)
2 call_builtin(b)
3 jump_false(7)
4 call_builtin(c)
5 call_builtin(d)
6 cmp_op(ne)
7 call_builtin(e)
8 cmp_op(ge)
$ diff-expr '\''(a || (b && (c != d))) >= e'\'' '\''(a || b && (c != d)) >= e'\''
OK
$ diff-expr '\''(a || (b && (c != d))) >= e'\'' '\''(a || b && c != d) >= e'\''
OK
$ diff-expr '\''(a || (b && (c != d))) >= e'\'' '\''(a || (b && c != d)) >= e'\''
OK
$ test-expr '\''(a || (b && c)) != (d >= e)'\''
0 call_builtin(a)
1 jump_true(6)
2 call_builtin(b)
3 jump_false(6)
4 call_builtin(c)
5 make_bool()
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ge)
9 cmp_op(ne)
$ diff-expr '\''(a || (b && c)) != (d >= e)'\'' '\''(a || b && c) != (d >= e)'\''
OK
$ diff-expr '\''(a || (b && c)) != (d >= e)'\'' '\''(a || b && c) != d >= e'\''
OK
$ diff-expr '\''(a || (b && c)) != (d >= e)'\'' '\''(a || (b && c)) != d >= e'\''
OK
$ test-expr '\''(a || b) && (c != (d >= e))'\''
0 call_builtin(a)
1 jump_true*(5)
2 call_builtin(b)
3 make_bool()
4 jump_false(eos)
5 call_builtin(c)
6 call_builtin(d)
7 call_builtin(e)
8 cmp_op(ge)
9 cmp_op(ne)
$ diff-expr '\''(a || b) && (c != (d >= e))'\'' '\''(a || b) && c != (d >= e)'\''
OK
$ diff-expr '\''(a || b) && (c != (d >= e))'\'' '\''(a || b) && c != d >= e'\''
OK
$ diff-expr '\''(a || b) && (c != (d >= e))'\'' '\''(a || b) && (c != d >= e)'\''
OK
$ test-expr '\''a || (b && (c != (d >= e)))'\''
0 call_builtin(a)
1 jump_true(eos)
2 call_builtin(b)
3 jump_false(eos)
4 call_builtin(c)
5 call_builtin(d)
6 call_builtin(e)
7 cmp_op(ge)
8 cmp_op(ne)
$ diff-expr '\''a || (b && (c != (d >= e)))'\'' '\''a || b && (c != (d >= e))'\''
OK
$ diff-expr '\''a || (b && (c != (d >= e)))'\'' '\''a || b && c != (d >= e)'\''
OK
$ diff-expr '\''a || (b && (c != (d >= e)))'\'' '\''a || b && c != d >= e'\''
OK
$ diff-expr '\''a || (b && (c != (d >= e)))'\'' '\''a || b && (c != d >= e)'\''
OK
$ diff-expr '\''a || (b && (c != (d >= e)))'\'' '\''a || (b && c != (d >= e))'\''
OK
$ diff-expr '\''a || (b && (c != (d >= e)))'\'' '\''a || (b && c != d >= e)'\''
OK
$ diff-expr '\''a || (b && (c != (d >= e)))'\'' '\''a || (b && (c != d >= e))'\''
OK'
) -L op8.new <(
echo '$ shopt -s expand_aliases'
shopt -s expand_aliases 2>&1 ||
echo 'command failed: shopt -s expand_aliases'

echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc flat; }'
test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc flat; } 2>&1 ||
echo 'command failed: test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc flat; }'

echo '$ alias test-expr='\''test-expr -b alpha -C'\'''
alias test-expr='test-expr -b alpha -C' 2>&1 ||
echo 'command failed: alias test-expr='\''test-expr -b alpha -C'\'''

echo '$ diff-expr() { diff -u100 -L "$1" <(test-expr "$1") -L "$2" <(test-expr "$2") && echo OK; }'
diff-expr() { diff -u100 -L "$1" <(test-expr "$1") -L "$2" <(test-expr "$2") && echo OK; } 2>&1 ||
echo 'command failed: diff-expr() { diff -u100 -L "$1" <(test-expr "$1") -L "$2" <(test-expr "$2") && echo OK; }'

echo '$ test-expr '\''(((a >= b) != c) && d) || e'\'''
test-expr '(((a >= b) != c) && d) || e' 2>&1 ||
echo 'command failed: test-expr '\''(((a >= b) != c) && d) || e'\'''

echo '$ diff-expr '\''(((a >= b) != c) && d) || e'\'' '\''((a >= b) != c) && d || e'\'''
diff-expr '(((a >= b) != c) && d) || e' '((a >= b) != c) && d || e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a >= b) != c) && d) || e'\'' '\''((a >= b) != c) && d || e'\'''

echo '$ diff-expr '\''(((a >= b) != c) && d) || e'\'' '\''(a >= b) != c && d || e'\'''
diff-expr '(((a >= b) != c) && d) || e' '(a >= b) != c && d || e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a >= b) != c) && d) || e'\'' '\''(a >= b) != c && d || e'\'''

echo '$ diff-expr '\''(((a >= b) != c) && d) || e'\'' '\''a >= b != c && d || e'\'''
diff-expr '(((a >= b) != c) && d) || e' 'a >= b != c && d || e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a >= b) != c) && d) || e'\'' '\''a >= b != c && d || e'\'''

echo '$ diff-expr '\''(((a >= b) != c) && d) || e'\'' '\''(a >= b != c) && d || e'\'''
diff-expr '(((a >= b) != c) && d) || e' '(a >= b != c) && d || e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a >= b) != c) && d) || e'\'' '\''(a >= b != c) && d || e'\'''

echo '$ diff-expr '\''(((a >= b) != c) && d) || e'\'' '\''((a >= b) != c && d) || e'\'''
diff-expr '(((a >= b) != c) && d) || e' '((a >= b) != c && d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a >= b) != c) && d) || e'\'' '\''((a >= b) != c && d) || e'\'''

echo '$ diff-expr '\''(((a >= b) != c) && d) || e'\'' '\''(a >= b != c && d) || e'\'''
diff-expr '(((a >= b) != c) && d) || e' '(a >= b != c && d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a >= b) != c) && d) || e'\'' '\''(a >= b != c && d) || e'\'''

echo '$ diff-expr '\''(((a >= b) != c) && d) || e'\'' '\''((a >= b != c) && d) || e'\'''
diff-expr '(((a >= b) != c) && d) || e' '((a >= b != c) && d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a >= b) != c) && d) || e'\'' '\''((a >= b != c) && d) || e'\'''

echo '$ test-expr '\''a >= (((b != c) && d) || e)'\'''
test-expr 'a >= (((b != c) && d) || e)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (((b != c) && d) || e)'\'''

echo '$ diff-expr '\''a >= (((b != c) && d) || e)'\'' '\''a >= ((b != c) && d || e)'\'''
diff-expr 'a >= (((b != c) && d) || e)' 'a >= ((b != c) && d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (((b != c) && d) || e)'\'' '\''a >= ((b != c) && d || e)'\'''

echo '$ diff-expr '\''a >= (((b != c) && d) || e)'\'' '\''a >= (b != c && d || e)'\'''
diff-expr 'a >= (((b != c) && d) || e)' 'a >= (b != c && d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (((b != c) && d) || e)'\'' '\''a >= (b != c && d || e)'\'''

echo '$ diff-expr '\''a >= (((b != c) && d) || e)'\'' '\''a >= ((b != c && d) || e)'\'''
diff-expr 'a >= (((b != c) && d) || e)' 'a >= ((b != c && d) || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (((b != c) && d) || e)'\'' '\''a >= ((b != c && d) || e)'\'''

echo '$ test-expr '\''(a >= ((b != c) && d)) || e'\'''
test-expr '(a >= ((b != c) && d)) || e' 2>&1 ||
echo 'command failed: test-expr '\''(a >= ((b != c) && d)) || e'\'''

echo '$ diff-expr '\''(a >= ((b != c) && d)) || e'\'' '\''a >= ((b != c) && d) || e'\'''
diff-expr '(a >= ((b != c) && d)) || e' 'a >= ((b != c) && d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= ((b != c) && d)) || e'\'' '\''a >= ((b != c) && d) || e'\'''

echo '$ diff-expr '\''(a >= ((b != c) && d)) || e'\'' '\''a >= (b != c && d) || e'\'''
diff-expr '(a >= ((b != c) && d)) || e' 'a >= (b != c && d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= ((b != c) && d)) || e'\'' '\''a >= (b != c && d) || e'\'''

echo '$ diff-expr '\''(a >= ((b != c) && d)) || e'\'' '\''(a >= (b != c && d)) || e'\'''
diff-expr '(a >= ((b != c) && d)) || e' '(a >= (b != c && d)) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= ((b != c) && d)) || e'\'' '\''(a >= (b != c && d)) || e'\'''

echo '$ test-expr '\''(a >= b) != ((c && d) || e)'\'''
test-expr '(a >= b) != ((c && d) || e)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) != ((c && d) || e)'\'''

echo '$ diff-expr '\''(a >= b) != ((c && d) || e)'\'' '\''a >= b != ((c && d) || e)'\'''
diff-expr '(a >= b) != ((c && d) || e)' 'a >= b != ((c && d) || e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) != ((c && d) || e)'\'' '\''a >= b != ((c && d) || e)'\'''

echo '$ diff-expr '\''(a >= b) != ((c && d) || e)'\'' '\''a >= b != (c && d || e)'\'''
diff-expr '(a >= b) != ((c && d) || e)' 'a >= b != (c && d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) != ((c && d) || e)'\'' '\''a >= b != (c && d || e)'\'''

echo '$ diff-expr '\''(a >= b) != ((c && d) || e)'\'' '\''(a >= b) != (c && d || e)'\'''
diff-expr '(a >= b) != ((c && d) || e)' '(a >= b) != (c && d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) != ((c && d) || e)'\'' '\''(a >= b) != (c && d || e)'\'''

echo '$ test-expr '\''a >= (b != ((c && d) || e))'\'''
test-expr 'a >= (b != ((c && d) || e))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c && d) || e))'\'''

echo '$ diff-expr '\''a >= (b != ((c && d) || e))'\'' '\''a >= (b != (c && d || e))'\'''
diff-expr 'a >= (b != ((c && d) || e))' 'a >= (b != (c && d || e))' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (b != ((c && d) || e))'\'' '\''a >= (b != (c && d || e))'\'''

echo '$ test-expr '\''((a >= (b != c)) && d) || e'\'''
test-expr '((a >= (b != c)) && d) || e' 2>&1 ||
echo 'command failed: test-expr '\''((a >= (b != c)) && d) || e'\'''

echo '$ diff-expr '\''((a >= (b != c)) && d) || e'\'' '\''(a >= (b != c)) && d || e'\'''
diff-expr '((a >= (b != c)) && d) || e' '(a >= (b != c)) && d || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= (b != c)) && d) || e'\'' '\''(a >= (b != c)) && d || e'\'''

echo '$ diff-expr '\''((a >= (b != c)) && d) || e'\'' '\''a >= (b != c) && d || e'\'''
diff-expr '((a >= (b != c)) && d) || e' 'a >= (b != c) && d || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= (b != c)) && d) || e'\'' '\''a >= (b != c) && d || e'\'''

echo '$ diff-expr '\''((a >= (b != c)) && d) || e'\'' '\''(a >= (b != c) && d) || e'\'''
diff-expr '((a >= (b != c)) && d) || e' '(a >= (b != c) && d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= (b != c)) && d) || e'\'' '\''(a >= (b != c) && d) || e'\'''

echo '$ test-expr '\''a >= ((b != (c && d)) || e)'\'''
test-expr 'a >= ((b != (c && d)) || e)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b != (c && d)) || e)'\'''

echo '$ diff-expr '\''a >= ((b != (c && d)) || e)'\'' '\''a >= (b != (c && d) || e)'\'''
diff-expr 'a >= ((b != (c && d)) || e)' 'a >= (b != (c && d) || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((b != (c && d)) || e)'\'' '\''a >= (b != (c && d) || e)'\'''

echo '$ test-expr '\''((a >= b) != (c && d)) || e'\'''
test-expr '((a >= b) != (c && d)) || e' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) != (c && d)) || e'\'''

echo '$ diff-expr '\''((a >= b) != (c && d)) || e'\'' '\''(a >= b) != (c && d) || e'\'''
diff-expr '((a >= b) != (c && d)) || e' '(a >= b) != (c && d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != (c && d)) || e'\'' '\''(a >= b) != (c && d) || e'\'''

echo '$ diff-expr '\''((a >= b) != (c && d)) || e'\'' '\''a >= b != (c && d) || e'\'''
diff-expr '((a >= b) != (c && d)) || e' 'a >= b != (c && d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != (c && d)) || e'\'' '\''a >= b != (c && d) || e'\'''

echo '$ diff-expr '\''((a >= b) != (c && d)) || e'\'' '\''(a >= b != (c && d)) || e'\'''
diff-expr '((a >= b) != (c && d)) || e' '(a >= b != (c && d)) || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != (c && d)) || e'\'' '\''(a >= b != (c && d)) || e'\'''

echo '$ test-expr '\''((a >= b) != c) && (d || e)'\'''
test-expr '((a >= b) != c) && (d || e)' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) != c) && (d || e)'\'''

echo '$ diff-expr '\''((a >= b) != c) && (d || e)'\'' '\''(a >= b) != c && (d || e)'\'''
diff-expr '((a >= b) != c) && (d || e)' '(a >= b) != c && (d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != c) && (d || e)'\'' '\''(a >= b) != c && (d || e)'\'''

echo '$ diff-expr '\''((a >= b) != c) && (d || e)'\'' '\''a >= b != c && (d || e)'\'''
diff-expr '((a >= b) != c) && (d || e)' 'a >= b != c && (d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != c) && (d || e)'\'' '\''a >= b != c && (d || e)'\'''

echo '$ diff-expr '\''((a >= b) != c) && (d || e)'\'' '\''(a >= b != c) && (d || e)'\'''
diff-expr '((a >= b) != c) && (d || e)' '(a >= b != c) && (d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != c) && (d || e)'\'' '\''(a >= b != c) && (d || e)'\'''

echo '$ test-expr '\''a >= ((b != c) && (d || e))'\'''
test-expr 'a >= ((b != c) && (d || e))' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b != c) && (d || e))'\'''

echo '$ diff-expr '\''a >= ((b != c) && (d || e))'\'' '\''a >= (b != c && (d || e))'\'''
diff-expr 'a >= ((b != c) && (d || e))' 'a >= (b != c && (d || e))' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((b != c) && (d || e))'\'' '\''a >= (b != c && (d || e))'\'''

echo '$ test-expr '\''(a >= (b != (c && d))) || e'\'''
test-expr '(a >= (b != (c && d))) || e' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b != (c && d))) || e'\'''

echo '$ diff-expr '\''(a >= (b != (c && d))) || e'\'' '\''a >= (b != (c && d)) || e'\'''
diff-expr '(a >= (b != (c && d))) || e' 'a >= (b != (c && d)) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b != (c && d))) || e'\'' '\''a >= (b != (c && d)) || e'\'''

echo '$ test-expr '\''(a >= (b != c)) && (d || e)'\'''
test-expr '(a >= (b != c)) && (d || e)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b != c)) && (d || e)'\'''

echo '$ diff-expr '\''(a >= (b != c)) && (d || e)'\'' '\''a >= (b != c) && (d || e)'\'''
diff-expr '(a >= (b != c)) && (d || e)' 'a >= (b != c) && (d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b != c)) && (d || e)'\'' '\''a >= (b != c) && (d || e)'\'''

echo '$ test-expr '\''(a >= b) != (c && (d || e))'\'''
test-expr '(a >= b) != (c && (d || e))' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) != (c && (d || e))'\'''

echo '$ diff-expr '\''(a >= b) != (c && (d || e))'\'' '\''a >= b != (c && (d || e))'\'''
diff-expr '(a >= b) != (c && (d || e))' 'a >= b != (c && (d || e))' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) != (c && (d || e))'\'' '\''a >= b != (c && (d || e))'\'''

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'''
test-expr 'a >= (b != (c && (d || e)))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'''

echo '$ test-expr '\''(((a >= b) != c) || d) && e'\'''
test-expr '(((a >= b) != c) || d) && e' 2>&1 ||
echo 'command failed: test-expr '\''(((a >= b) != c) || d) && e'\'''

echo '$ diff-expr '\''(((a >= b) != c) || d) && e'\'' '\''((a >= b) != c || d) && e'\'''
diff-expr '(((a >= b) != c) || d) && e' '((a >= b) != c || d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a >= b) != c) || d) && e'\'' '\''((a >= b) != c || d) && e'\'''

echo '$ diff-expr '\''(((a >= b) != c) || d) && e'\'' '\''(a >= b != c || d) && e'\'''
diff-expr '(((a >= b) != c) || d) && e' '(a >= b != c || d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a >= b) != c) || d) && e'\'' '\''(a >= b != c || d) && e'\'''

echo '$ diff-expr '\''(((a >= b) != c) || d) && e'\'' '\''((a >= b != c) || d) && e'\'''
diff-expr '(((a >= b) != c) || d) && e' '((a >= b != c) || d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a >= b) != c) || d) && e'\'' '\''((a >= b != c) || d) && e'\'''

echo '$ test-expr '\''a >= (((b != c) || d) && e)'\'''
test-expr 'a >= (((b != c) || d) && e)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (((b != c) || d) && e)'\'''

echo '$ diff-expr '\''a >= (((b != c) || d) && e)'\'' '\''a >= ((b != c || d) && e)'\'''
diff-expr 'a >= (((b != c) || d) && e)' 'a >= ((b != c || d) && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (((b != c) || d) && e)'\'' '\''a >= ((b != c || d) && e)'\'''

echo '$ test-expr '\''(a >= ((b != c) || d)) && e'\'''
test-expr '(a >= ((b != c) || d)) && e' 2>&1 ||
echo 'command failed: test-expr '\''(a >= ((b != c) || d)) && e'\'''

echo '$ diff-expr '\''(a >= ((b != c) || d)) && e'\'' '\''a >= ((b != c) || d) && e'\'''
diff-expr '(a >= ((b != c) || d)) && e' 'a >= ((b != c) || d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= ((b != c) || d)) && e'\'' '\''a >= ((b != c) || d) && e'\'''

echo '$ diff-expr '\''(a >= ((b != c) || d)) && e'\'' '\''a >= (b != c || d) && e'\'''
diff-expr '(a >= ((b != c) || d)) && e' 'a >= (b != c || d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= ((b != c) || d)) && e'\'' '\''a >= (b != c || d) && e'\'''

echo '$ diff-expr '\''(a >= ((b != c) || d)) && e'\'' '\''(a >= (b != c || d)) && e'\'''
diff-expr '(a >= ((b != c) || d)) && e' '(a >= (b != c || d)) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= ((b != c) || d)) && e'\'' '\''(a >= (b != c || d)) && e'\'''

echo '$ test-expr '\''(a >= b) != ((c || d) && e)'\'''
test-expr '(a >= b) != ((c || d) && e)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) != ((c || d) && e)'\'''

echo '$ diff-expr '\''(a >= b) != ((c || d) && e)'\'' '\''a >= b != ((c || d) && e)'\'''
diff-expr '(a >= b) != ((c || d) && e)' 'a >= b != ((c || d) && e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) != ((c || d) && e)'\'' '\''a >= b != ((c || d) && e)'\'''

echo '$ test-expr '\''a >= (b != ((c || d) && e))'\'''
test-expr 'a >= (b != ((c || d) && e))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c || d) && e))'\'''

echo '$ test-expr '\''((a >= (b != c)) || d) && e'\'''
test-expr '((a >= (b != c)) || d) && e' 2>&1 ||
echo 'command failed: test-expr '\''((a >= (b != c)) || d) && e'\'''

echo '$ diff-expr '\''((a >= (b != c)) || d) && e'\'' '\''(a >= (b != c) || d) && e'\'''
diff-expr '((a >= (b != c)) || d) && e' '(a >= (b != c) || d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= (b != c)) || d) && e'\'' '\''(a >= (b != c) || d) && e'\'''

echo '$ test-expr '\''a >= ((b != (c || d)) && e)'\'''
test-expr 'a >= ((b != (c || d)) && e)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b != (c || d)) && e)'\'''

echo '$ diff-expr '\''a >= ((b != (c || d)) && e)'\'' '\''a >= (b != (c || d) && e)'\'''
diff-expr 'a >= ((b != (c || d)) && e)' 'a >= (b != (c || d) && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((b != (c || d)) && e)'\'' '\''a >= (b != (c || d) && e)'\'''

echo '$ test-expr '\''((a >= b) != (c || d)) && e'\'''
test-expr '((a >= b) != (c || d)) && e' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) != (c || d)) && e'\'''

echo '$ diff-expr '\''((a >= b) != (c || d)) && e'\'' '\''(a >= b) != (c || d) && e'\'''
diff-expr '((a >= b) != (c || d)) && e' '(a >= b) != (c || d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != (c || d)) && e'\'' '\''(a >= b) != (c || d) && e'\'''

echo '$ diff-expr '\''((a >= b) != (c || d)) && e'\'' '\''a >= b != (c || d) && e'\'''
diff-expr '((a >= b) != (c || d)) && e' 'a >= b != (c || d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != (c || d)) && e'\'' '\''a >= b != (c || d) && e'\'''

echo '$ diff-expr '\''((a >= b) != (c || d)) && e'\'' '\''(a >= b != (c || d)) && e'\'''
diff-expr '((a >= b) != (c || d)) && e' '(a >= b != (c || d)) && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != (c || d)) && e'\'' '\''(a >= b != (c || d)) && e'\'''

echo '$ test-expr '\''((a >= b) != c) || (d && e)'\'''
test-expr '((a >= b) != c) || (d && e)' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) != c) || (d && e)'\'''

echo '$ diff-expr '\''((a >= b) != c) || (d && e)'\'' '\''(a >= b) != c || (d && e)'\'''
diff-expr '((a >= b) != c) || (d && e)' '(a >= b) != c || (d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != c) || (d && e)'\'' '\''(a >= b) != c || (d && e)'\'''

echo '$ diff-expr '\''((a >= b) != c) || (d && e)'\'' '\''a >= b != c || (d && e)'\'''
diff-expr '((a >= b) != c) || (d && e)' 'a >= b != c || (d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != c) || (d && e)'\'' '\''a >= b != c || (d && e)'\'''

echo '$ diff-expr '\''((a >= b) != c) || (d && e)'\'' '\''a >= b != c || d && e'\'''
diff-expr '((a >= b) != c) || (d && e)' 'a >= b != c || d && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != c) || (d && e)'\'' '\''a >= b != c || d && e'\'''

echo '$ diff-expr '\''((a >= b) != c) || (d && e)'\'' '\''(a >= b) != c || d && e'\'''
diff-expr '((a >= b) != c) || (d && e)' '(a >= b) != c || d && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != c) || (d && e)'\'' '\''(a >= b) != c || d && e'\'''

echo '$ diff-expr '\''((a >= b) != c) || (d && e)'\'' '\''(a >= b != c) || (d && e)'\'''
diff-expr '((a >= b) != c) || (d && e)' '(a >= b != c) || (d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != c) || (d && e)'\'' '\''(a >= b != c) || (d && e)'\'''

echo '$ diff-expr '\''((a >= b) != c) || (d && e)'\'' '\''(a >= b != c) || d && e'\'''
diff-expr '((a >= b) != c) || (d && e)' '(a >= b != c) || d && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != c) || (d && e)'\'' '\''(a >= b != c) || d && e'\'''

echo '$ diff-expr '\''((a >= b) != c) || (d && e)'\'' '\''((a >= b) != c) || d && e'\'''
diff-expr '((a >= b) != c) || (d && e)' '((a >= b) != c) || d && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) != c) || (d && e)'\'' '\''((a >= b) != c) || d && e'\'''

echo '$ test-expr '\''a >= ((b != c) || (d && e))'\'''
test-expr 'a >= ((b != c) || (d && e))' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b != c) || (d && e))'\'''

echo '$ diff-expr '\''a >= ((b != c) || (d && e))'\'' '\''a >= (b != c || (d && e))'\'''
diff-expr 'a >= ((b != c) || (d && e))' 'a >= (b != c || (d && e))' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((b != c) || (d && e))'\'' '\''a >= (b != c || (d && e))'\'''

echo '$ diff-expr '\''a >= ((b != c) || (d && e))'\'' '\''a >= (b != c || d && e)'\'''
diff-expr 'a >= ((b != c) || (d && e))' 'a >= (b != c || d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((b != c) || (d && e))'\'' '\''a >= (b != c || d && e)'\'''

echo '$ diff-expr '\''a >= ((b != c) || (d && e))'\'' '\''a >= ((b != c) || d && e)'\'''
diff-expr 'a >= ((b != c) || (d && e))' 'a >= ((b != c) || d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((b != c) || (d && e))'\'' '\''a >= ((b != c) || d && e)'\'''

echo '$ test-expr '\''(a >= (b != (c || d))) && e'\'''
test-expr '(a >= (b != (c || d))) && e' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b != (c || d))) && e'\'''

echo '$ diff-expr '\''(a >= (b != (c || d))) && e'\'' '\''a >= (b != (c || d)) && e'\'''
diff-expr '(a >= (b != (c || d))) && e' 'a >= (b != (c || d)) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b != (c || d))) && e'\'' '\''a >= (b != (c || d)) && e'\'''

echo '$ test-expr '\''(a >= (b != c)) || (d && e)'\'''
test-expr '(a >= (b != c)) || (d && e)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b != c)) || (d && e)'\'''

echo '$ diff-expr '\''(a >= (b != c)) || (d && e)'\'' '\''a >= (b != c) || (d && e)'\'''
diff-expr '(a >= (b != c)) || (d && e)' 'a >= (b != c) || (d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b != c)) || (d && e)'\'' '\''a >= (b != c) || (d && e)'\'''

echo '$ diff-expr '\''(a >= (b != c)) || (d && e)'\'' '\''a >= (b != c) || d && e'\'''
diff-expr '(a >= (b != c)) || (d && e)' 'a >= (b != c) || d && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b != c)) || (d && e)'\'' '\''a >= (b != c) || d && e'\'''

echo '$ diff-expr '\''(a >= (b != c)) || (d && e)'\'' '\''(a >= (b != c)) || d && e'\'''
diff-expr '(a >= (b != c)) || (d && e)' '(a >= (b != c)) || d && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b != c)) || (d && e)'\'' '\''(a >= (b != c)) || d && e'\'''

echo '$ test-expr '\''(a >= b) != (c || (d && e))'\'''
test-expr '(a >= b) != (c || (d && e))' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) != (c || (d && e))'\'''

echo '$ diff-expr '\''(a >= b) != (c || (d && e))'\'' '\''a >= b != (c || (d && e))'\'''
diff-expr '(a >= b) != (c || (d && e))' 'a >= b != (c || (d && e))' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) != (c || (d && e))'\'' '\''a >= b != (c || (d && e))'\'''

echo '$ diff-expr '\''(a >= b) != (c || (d && e))'\'' '\''a >= b != (c || d && e)'\'''
diff-expr '(a >= b) != (c || (d && e))' 'a >= b != (c || d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) != (c || (d && e))'\'' '\''a >= b != (c || d && e)'\'''

echo '$ diff-expr '\''(a >= b) != (c || (d && e))'\'' '\''(a >= b) != (c || d && e)'\'''
diff-expr '(a >= b) != (c || (d && e))' '(a >= b) != (c || d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) != (c || (d && e))'\'' '\''(a >= b) != (c || d && e)'\'''

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'''
test-expr 'a >= (b != (c || (d && e)))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'''

echo '$ diff-expr '\''a >= (b != (c || (d && e)))'\'' '\''a >= (b != (c || d && e))'\'''
diff-expr 'a >= (b != (c || (d && e)))' 'a >= (b != (c || d && e))' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (b != (c || (d && e)))'\'' '\''a >= (b != (c || d && e))'\'''

echo '$ test-expr '\''(((a >= b) && c) != d) || e'\'''
test-expr '(((a >= b) && c) != d) || e' 2>&1 ||
echo 'command failed: test-expr '\''(((a >= b) && c) != d) || e'\'''

echo '$ diff-expr '\''(((a >= b) && c) != d) || e'\'' '\''((a >= b) && c) != d || e'\'''
diff-expr '(((a >= b) && c) != d) || e' '((a >= b) && c) != d || e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a >= b) && c) != d) || e'\'' '\''((a >= b) && c) != d || e'\'''

echo '$ diff-expr '\''(((a >= b) && c) != d) || e'\'' '\''(a >= b && c) != d || e'\'''
diff-expr '(((a >= b) && c) != d) || e' '(a >= b && c) != d || e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a >= b) && c) != d) || e'\'' '\''(a >= b && c) != d || e'\'''

echo '$ diff-expr '\''(((a >= b) && c) != d) || e'\'' '\''((a >= b && c) != d) || e'\'''
diff-expr '(((a >= b) && c) != d) || e' '((a >= b && c) != d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a >= b) && c) != d) || e'\'' '\''((a >= b && c) != d) || e'\'''

echo '$ test-expr '\''a >= (((b && c) != d) || e)'\'''
test-expr 'a >= (((b && c) != d) || e)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (((b && c) != d) || e)'\'''

echo '$ diff-expr '\''a >= (((b && c) != d) || e)'\'' '\''a >= ((b && c) != d || e)'\'''
diff-expr 'a >= (((b && c) != d) || e)' 'a >= ((b && c) != d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (((b && c) != d) || e)'\'' '\''a >= ((b && c) != d || e)'\'''

echo '$ test-expr '\''(a >= ((b && c) != d)) || e'\'''
test-expr '(a >= ((b && c) != d)) || e' 2>&1 ||
echo 'command failed: test-expr '\''(a >= ((b && c) != d)) || e'\'''

echo '$ diff-expr '\''(a >= ((b && c) != d)) || e'\'' '\''a >= ((b && c) != d) || e'\'''
diff-expr '(a >= ((b && c) != d)) || e' 'a >= ((b && c) != d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= ((b && c) != d)) || e'\'' '\''a >= ((b && c) != d) || e'\'''

echo '$ test-expr '\''(a >= b) && ((c != d) || e)'\'''
test-expr '(a >= b) && ((c != d) || e)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) && ((c != d) || e)'\'''

echo '$ diff-expr '\''(a >= b) && ((c != d) || e)'\'' '\''a >= b && ((c != d) || e)'\'''
diff-expr '(a >= b) && ((c != d) || e)' 'a >= b && ((c != d) || e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) && ((c != d) || e)'\'' '\''a >= b && ((c != d) || e)'\'''

echo '$ diff-expr '\''(a >= b) && ((c != d) || e)'\'' '\''a >= b && (c != d || e)'\'''
diff-expr '(a >= b) && ((c != d) || e)' 'a >= b && (c != d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) && ((c != d) || e)'\'' '\''a >= b && (c != d || e)'\'''

echo '$ diff-expr '\''(a >= b) && ((c != d) || e)'\'' '\''(a >= b) && (c != d || e)'\'''
diff-expr '(a >= b) && ((c != d) || e)' '(a >= b) && (c != d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) && ((c != d) || e)'\'' '\''(a >= b) && (c != d || e)'\'''

echo '$ test-expr '\''a >= (b && ((c != d) || e))'\'''
test-expr 'a >= (b && ((c != d) || e))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && ((c != d) || e))'\'''

echo '$ diff-expr '\''a >= (b && ((c != d) || e))'\'' '\''a >= (b && (c != d || e))'\'''
diff-expr 'a >= (b && ((c != d) || e))' 'a >= (b && (c != d || e))' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (b && ((c != d) || e))'\'' '\''a >= (b && (c != d || e))'\'''

echo '$ test-expr '\''((a >= (b && c)) != d) || e'\'''
test-expr '((a >= (b && c)) != d) || e' 2>&1 ||
echo 'command failed: test-expr '\''((a >= (b && c)) != d) || e'\'''

echo '$ diff-expr '\''((a >= (b && c)) != d) || e'\'' '\''(a >= (b && c)) != d || e'\'''
diff-expr '((a >= (b && c)) != d) || e' '(a >= (b && c)) != d || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= (b && c)) != d) || e'\'' '\''(a >= (b && c)) != d || e'\'''

echo '$ diff-expr '\''((a >= (b && c)) != d) || e'\'' '\''a >= (b && c) != d || e'\'''
diff-expr '((a >= (b && c)) != d) || e' 'a >= (b && c) != d || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= (b && c)) != d) || e'\'' '\''a >= (b && c) != d || e'\'''

echo '$ diff-expr '\''((a >= (b && c)) != d) || e'\'' '\''(a >= (b && c) != d) || e'\'''
diff-expr '((a >= (b && c)) != d) || e' '(a >= (b && c) != d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= (b && c)) != d) || e'\'' '\''(a >= (b && c) != d) || e'\'''

echo '$ test-expr '\''a >= ((b && (c != d)) || e)'\'''
test-expr 'a >= ((b && (c != d)) || e)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b && (c != d)) || e)'\'''

echo '$ diff-expr '\''a >= ((b && (c != d)) || e)'\'' '\''a >= (b && (c != d) || e)'\'''
diff-expr 'a >= ((b && (c != d)) || e)' 'a >= (b && (c != d) || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((b && (c != d)) || e)'\'' '\''a >= (b && (c != d) || e)'\'''

echo '$ diff-expr '\''a >= ((b && (c != d)) || e)'\'' '\''a >= (b && c != d || e)'\'''
diff-expr 'a >= ((b && (c != d)) || e)' 'a >= (b && c != d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((b && (c != d)) || e)'\'' '\''a >= (b && c != d || e)'\'''

echo '$ diff-expr '\''a >= ((b && (c != d)) || e)'\'' '\''a >= ((b && c != d) || e)'\'''
diff-expr 'a >= ((b && (c != d)) || e)' 'a >= ((b && c != d) || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((b && (c != d)) || e)'\'' '\''a >= ((b && c != d) || e)'\'''

echo '$ test-expr '\''((a >= b) && (c != d)) || e'\'''
test-expr '((a >= b) && (c != d)) || e' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) && (c != d)) || e'\'''

echo '$ diff-expr '\''((a >= b) && (c != d)) || e'\'' '\''(a >= b) && (c != d) || e'\'''
diff-expr '((a >= b) && (c != d)) || e' '(a >= b) && (c != d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && (c != d)) || e'\'' '\''(a >= b) && (c != d) || e'\'''

echo '$ diff-expr '\''((a >= b) && (c != d)) || e'\'' '\''a >= b && (c != d) || e'\'''
diff-expr '((a >= b) && (c != d)) || e' 'a >= b && (c != d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && (c != d)) || e'\'' '\''a >= b && (c != d) || e'\'''

echo '$ diff-expr '\''((a >= b) && (c != d)) || e'\'' '\''a >= b && c != d || e'\'''
diff-expr '((a >= b) && (c != d)) || e' 'a >= b && c != d || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && (c != d)) || e'\'' '\''a >= b && c != d || e'\'''

echo '$ diff-expr '\''((a >= b) && (c != d)) || e'\'' '\''(a >= b) && c != d || e'\'''
diff-expr '((a >= b) && (c != d)) || e' '(a >= b) && c != d || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && (c != d)) || e'\'' '\''(a >= b) && c != d || e'\'''

echo '$ diff-expr '\''((a >= b) && (c != d)) || e'\'' '\''(a >= b && (c != d)) || e'\'''
diff-expr '((a >= b) && (c != d)) || e' '(a >= b && (c != d)) || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && (c != d)) || e'\'' '\''(a >= b && (c != d)) || e'\'''

echo '$ diff-expr '\''((a >= b) && (c != d)) || e'\'' '\''(a >= b && c != d) || e'\'''
diff-expr '((a >= b) && (c != d)) || e' '(a >= b && c != d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && (c != d)) || e'\'' '\''(a >= b && c != d) || e'\'''

echo '$ diff-expr '\''((a >= b) && (c != d)) || e'\'' '\''((a >= b) && c != d) || e'\'''
diff-expr '((a >= b) && (c != d)) || e' '((a >= b) && c != d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && (c != d)) || e'\'' '\''((a >= b) && c != d) || e'\'''

echo '$ test-expr '\''((a >= b) && c) != (d || e)'\'''
test-expr '((a >= b) && c) != (d || e)' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) && c) != (d || e)'\'''

echo '$ diff-expr '\''((a >= b) && c) != (d || e)'\'' '\''(a >= b && c) != (d || e)'\'''
diff-expr '((a >= b) && c) != (d || e)' '(a >= b && c) != (d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && c) != (d || e)'\'' '\''(a >= b && c) != (d || e)'\'''

echo '$ test-expr '\''a >= ((b && c) != (d || e))'\'''
test-expr 'a >= ((b && c) != (d || e))' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b && c) != (d || e))'\'''

echo '$ test-expr '\''(a >= (b && (c != d))) || e'\'''
test-expr '(a >= (b && (c != d))) || e' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b && (c != d))) || e'\'''

echo '$ diff-expr '\''(a >= (b && (c != d))) || e'\'' '\''a >= (b && (c != d)) || e'\'''
diff-expr '(a >= (b && (c != d))) || e' 'a >= (b && (c != d)) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b && (c != d))) || e'\'' '\''a >= (b && (c != d)) || e'\'''

echo '$ diff-expr '\''(a >= (b && (c != d))) || e'\'' '\''a >= (b && c != d) || e'\'''
diff-expr '(a >= (b && (c != d))) || e' 'a >= (b && c != d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b && (c != d))) || e'\'' '\''a >= (b && c != d) || e'\'''

echo '$ diff-expr '\''(a >= (b && (c != d))) || e'\'' '\''(a >= (b && c != d)) || e'\'''
diff-expr '(a >= (b && (c != d))) || e' '(a >= (b && c != d)) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b && (c != d))) || e'\'' '\''(a >= (b && c != d)) || e'\'''

echo '$ test-expr '\''(a >= (b && c)) != (d || e)'\'''
test-expr '(a >= (b && c)) != (d || e)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b && c)) != (d || e)'\'''

echo '$ diff-expr '\''(a >= (b && c)) != (d || e)'\'' '\''a >= (b && c) != (d || e)'\'''
diff-expr '(a >= (b && c)) != (d || e)' 'a >= (b && c) != (d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b && c)) != (d || e)'\'' '\''a >= (b && c) != (d || e)'\'''

echo '$ test-expr '\''(a >= b) && (c != (d || e))'\'''
test-expr '(a >= b) && (c != (d || e))' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) && (c != (d || e))'\'''

echo '$ diff-expr '\''(a >= b) && (c != (d || e))'\'' '\''a >= b && (c != (d || e))'\'''
diff-expr '(a >= b) && (c != (d || e))' 'a >= b && (c != (d || e))' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) && (c != (d || e))'\'' '\''a >= b && (c != (d || e))'\'''

echo '$ diff-expr '\''(a >= b) && (c != (d || e))'\'' '\''a >= b && c != (d || e)'\'''
diff-expr '(a >= b) && (c != (d || e))' 'a >= b && c != (d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) && (c != (d || e))'\'' '\''a >= b && c != (d || e)'\'''

echo '$ diff-expr '\''(a >= b) && (c != (d || e))'\'' '\''(a >= b) && c != (d || e)'\'''
diff-expr '(a >= b) && (c != (d || e))' '(a >= b) && c != (d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) && (c != (d || e))'\'' '\''(a >= b) && c != (d || e)'\'''

echo '$ test-expr '\''a >= (b && (c != (d || e)))'\'''
test-expr 'a >= (b && (c != (d || e)))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (c != (d || e)))'\'''

echo '$ diff-expr '\''a >= (b && (c != (d || e)))'\'' '\''a >= (b && c != (d || e))'\'''
diff-expr 'a >= (b && (c != (d || e)))' 'a >= (b && c != (d || e))' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (b && (c != (d || e)))'\'' '\''a >= (b && c != (d || e))'\'''

echo '$ test-expr '\''(((a >= b) && c) || d) != e'\'''
test-expr '(((a >= b) && c) || d) != e' 2>&1 ||
echo 'command failed: test-expr '\''(((a >= b) && c) || d) != e'\'''

echo '$ diff-expr '\''(((a >= b) && c) || d) != e'\'' '\''((a >= b) && c || d) != e'\'''
diff-expr '(((a >= b) && c) || d) != e' '((a >= b) && c || d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a >= b) && c) || d) != e'\'' '\''((a >= b) && c || d) != e'\'''

echo '$ diff-expr '\''(((a >= b) && c) || d) != e'\'' '\''(a >= b && c || d) != e'\'''
diff-expr '(((a >= b) && c) || d) != e' '(a >= b && c || d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a >= b) && c) || d) != e'\'' '\''(a >= b && c || d) != e'\'''

echo '$ diff-expr '\''(((a >= b) && c) || d) != e'\'' '\''((a >= b && c) || d) != e'\'''
diff-expr '(((a >= b) && c) || d) != e' '((a >= b && c) || d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a >= b) && c) || d) != e'\'' '\''((a >= b && c) || d) != e'\'''

echo '$ test-expr '\''a >= (((b && c) || d) != e)'\'''
test-expr 'a >= (((b && c) || d) != e)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (((b && c) || d) != e)'\'''

echo '$ diff-expr '\''a >= (((b && c) || d) != e)'\'' '\''a >= ((b && c || d) != e)'\'''
diff-expr 'a >= (((b && c) || d) != e)' 'a >= ((b && c || d) != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (((b && c) || d) != e)'\'' '\''a >= ((b && c || d) != e)'\'''

echo '$ test-expr '\''(a >= ((b && c) || d)) != e'\'''
test-expr '(a >= ((b && c) || d)) != e' 2>&1 ||
echo 'command failed: test-expr '\''(a >= ((b && c) || d)) != e'\'''

echo '$ diff-expr '\''(a >= ((b && c) || d)) != e'\'' '\''a >= ((b && c) || d) != e'\'''
diff-expr '(a >= ((b && c) || d)) != e' 'a >= ((b && c) || d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= ((b && c) || d)) != e'\'' '\''a >= ((b && c) || d) != e'\'''

echo '$ diff-expr '\''(a >= ((b && c) || d)) != e'\'' '\''a >= (b && c || d) != e'\'''
diff-expr '(a >= ((b && c) || d)) != e' 'a >= (b && c || d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= ((b && c) || d)) != e'\'' '\''a >= (b && c || d) != e'\'''

echo '$ diff-expr '\''(a >= ((b && c) || d)) != e'\'' '\''(a >= (b && c || d)) != e'\'''
diff-expr '(a >= ((b && c) || d)) != e' '(a >= (b && c || d)) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= ((b && c) || d)) != e'\'' '\''(a >= (b && c || d)) != e'\'''

echo '$ test-expr '\''(a >= b) && ((c || d) != e)'\'''
test-expr '(a >= b) && ((c || d) != e)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) && ((c || d) != e)'\'''

echo '$ diff-expr '\''(a >= b) && ((c || d) != e)'\'' '\''a >= b && ((c || d) != e)'\'''
diff-expr '(a >= b) && ((c || d) != e)' 'a >= b && ((c || d) != e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) && ((c || d) != e)'\'' '\''a >= b && ((c || d) != e)'\'''

echo '$ diff-expr '\''(a >= b) && ((c || d) != e)'\'' '\''a >= b && (c || d) != e'\'''
diff-expr '(a >= b) && ((c || d) != e)' 'a >= b && (c || d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) && ((c || d) != e)'\'' '\''a >= b && (c || d) != e'\'''

echo '$ diff-expr '\''(a >= b) && ((c || d) != e)'\'' '\''(a >= b) && (c || d) != e'\'''
diff-expr '(a >= b) && ((c || d) != e)' '(a >= b) && (c || d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) && ((c || d) != e)'\'' '\''(a >= b) && (c || d) != e'\'''

echo '$ test-expr '\''a >= (b && ((c || d) != e))'\'''
test-expr 'a >= (b && ((c || d) != e))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && ((c || d) != e))'\'''

echo '$ diff-expr '\''a >= (b && ((c || d) != e))'\'' '\''a >= (b && (c || d) != e)'\'''
diff-expr 'a >= (b && ((c || d) != e))' 'a >= (b && (c || d) != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (b && ((c || d) != e))'\'' '\''a >= (b && (c || d) != e)'\'''

echo '$ test-expr '\''((a >= (b && c)) || d) != e'\'''
test-expr '((a >= (b && c)) || d) != e' 2>&1 ||
echo 'command failed: test-expr '\''((a >= (b && c)) || d) != e'\'''

echo '$ diff-expr '\''((a >= (b && c)) || d) != e'\'' '\''(a >= (b && c) || d) != e'\'''
diff-expr '((a >= (b && c)) || d) != e' '(a >= (b && c) || d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= (b && c)) || d) != e'\'' '\''(a >= (b && c) || d) != e'\'''

echo '$ test-expr '\''a >= ((b && (c || d)) != e)'\'''
test-expr 'a >= ((b && (c || d)) != e)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b && (c || d)) != e)'\'''

echo '$ test-expr '\''((a >= b) && (c || d)) != e'\'''
test-expr '((a >= b) && (c || d)) != e' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) && (c || d)) != e'\'''

echo '$ diff-expr '\''((a >= b) && (c || d)) != e'\'' '\''(a >= b && (c || d)) != e'\'''
diff-expr '((a >= b) && (c || d)) != e' '(a >= b && (c || d)) != e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && (c || d)) != e'\'' '\''(a >= b && (c || d)) != e'\'''

echo '$ test-expr '\''((a >= b) && c) || (d != e)'\'''
test-expr '((a >= b) && c) || (d != e)' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) && c) || (d != e)'\'''

echo '$ diff-expr '\''((a >= b) && c) || (d != e)'\'' '\''(a >= b) && c || (d != e)'\'''
diff-expr '((a >= b) && c) || (d != e)' '(a >= b) && c || (d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && c) || (d != e)'\'' '\''(a >= b) && c || (d != e)'\'''

echo '$ diff-expr '\''((a >= b) && c) || (d != e)'\'' '\''a >= b && c || (d != e)'\'''
diff-expr '((a >= b) && c) || (d != e)' 'a >= b && c || (d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && c) || (d != e)'\'' '\''a >= b && c || (d != e)'\'''

echo '$ diff-expr '\''((a >= b) && c) || (d != e)'\'' '\''a >= b && c || d != e'\'''
diff-expr '((a >= b) && c) || (d != e)' 'a >= b && c || d != e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && c) || (d != e)'\'' '\''a >= b && c || d != e'\'''

echo '$ diff-expr '\''((a >= b) && c) || (d != e)'\'' '\''(a >= b) && c || d != e'\'''
diff-expr '((a >= b) && c) || (d != e)' '(a >= b) && c || d != e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && c) || (d != e)'\'' '\''(a >= b) && c || d != e'\'''

echo '$ diff-expr '\''((a >= b) && c) || (d != e)'\'' '\''(a >= b && c) || (d != e)'\'''
diff-expr '((a >= b) && c) || (d != e)' '(a >= b && c) || (d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && c) || (d != e)'\'' '\''(a >= b && c) || (d != e)'\'''

echo '$ diff-expr '\''((a >= b) && c) || (d != e)'\'' '\''(a >= b && c) || d != e'\'''
diff-expr '((a >= b) && c) || (d != e)' '(a >= b && c) || d != e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && c) || (d != e)'\'' '\''(a >= b && c) || d != e'\'''

echo '$ diff-expr '\''((a >= b) && c) || (d != e)'\'' '\''((a >= b) && c) || d != e'\'''
diff-expr '((a >= b) && c) || (d != e)' '((a >= b) && c) || d != e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) && c) || (d != e)'\'' '\''((a >= b) && c) || d != e'\'''

echo '$ test-expr '\''a >= ((b && c) || (d != e))'\'''
test-expr 'a >= ((b && c) || (d != e))' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b && c) || (d != e))'\'''

echo '$ diff-expr '\''a >= ((b && c) || (d != e))'\'' '\''a >= (b && c || (d != e))'\'''
diff-expr 'a >= ((b && c) || (d != e))' 'a >= (b && c || (d != e))' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((b && c) || (d != e))'\'' '\''a >= (b && c || (d != e))'\'''

echo '$ diff-expr '\''a >= ((b && c) || (d != e))'\'' '\''a >= (b && c || d != e)'\'''
diff-expr 'a >= ((b && c) || (d != e))' 'a >= (b && c || d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((b && c) || (d != e))'\'' '\''a >= (b && c || d != e)'\'''

echo '$ diff-expr '\''a >= ((b && c) || (d != e))'\'' '\''a >= ((b && c) || d != e)'\'''
diff-expr 'a >= ((b && c) || (d != e))' 'a >= ((b && c) || d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((b && c) || (d != e))'\'' '\''a >= ((b && c) || d != e)'\'''

echo '$ test-expr '\''(a >= (b && (c || d))) != e'\'''
test-expr '(a >= (b && (c || d))) != e' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b && (c || d))) != e'\'''

echo '$ diff-expr '\''(a >= (b && (c || d))) != e'\'' '\''a >= (b && (c || d)) != e'\'''
diff-expr '(a >= (b && (c || d))) != e' 'a >= (b && (c || d)) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b && (c || d))) != e'\'' '\''a >= (b && (c || d)) != e'\'''

echo '$ test-expr '\''(a >= (b && c)) || (d != e)'\'''
test-expr '(a >= (b && c)) || (d != e)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b && c)) || (d != e)'\'''

echo '$ diff-expr '\''(a >= (b && c)) || (d != e)'\'' '\''a >= (b && c) || (d != e)'\'''
diff-expr '(a >= (b && c)) || (d != e)' 'a >= (b && c) || (d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b && c)) || (d != e)'\'' '\''a >= (b && c) || (d != e)'\'''

echo '$ diff-expr '\''(a >= (b && c)) || (d != e)'\'' '\''a >= (b && c) || d != e'\'''
diff-expr '(a >= (b && c)) || (d != e)' 'a >= (b && c) || d != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b && c)) || (d != e)'\'' '\''a >= (b && c) || d != e'\'''

echo '$ diff-expr '\''(a >= (b && c)) || (d != e)'\'' '\''(a >= (b && c)) || d != e'\'''
diff-expr '(a >= (b && c)) || (d != e)' '(a >= (b && c)) || d != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b && c)) || (d != e)'\'' '\''(a >= (b && c)) || d != e'\'''

echo '$ test-expr '\''(a >= b) && (c || (d != e))'\'''
test-expr '(a >= b) && (c || (d != e))' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) && (c || (d != e))'\'''

echo '$ diff-expr '\''(a >= b) && (c || (d != e))'\'' '\''a >= b && (c || (d != e))'\'''
diff-expr '(a >= b) && (c || (d != e))' 'a >= b && (c || (d != e))' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) && (c || (d != e))'\'' '\''a >= b && (c || (d != e))'\'''

echo '$ diff-expr '\''(a >= b) && (c || (d != e))'\'' '\''a >= b && (c || d != e)'\'''
diff-expr '(a >= b) && (c || (d != e))' 'a >= b && (c || d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) && (c || (d != e))'\'' '\''a >= b && (c || d != e)'\'''

echo '$ diff-expr '\''(a >= b) && (c || (d != e))'\'' '\''(a >= b) && (c || d != e)'\'''
diff-expr '(a >= b) && (c || (d != e))' '(a >= b) && (c || d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) && (c || (d != e))'\'' '\''(a >= b) && (c || d != e)'\'''

echo '$ test-expr '\''a >= (b && (c || (d != e)))'\'''
test-expr 'a >= (b && (c || (d != e)))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (c || (d != e)))'\'''

echo '$ diff-expr '\''a >= (b && (c || (d != e)))'\'' '\''a >= (b && (c || d != e))'\'''
diff-expr 'a >= (b && (c || (d != e)))' 'a >= (b && (c || d != e))' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (b && (c || (d != e)))'\'' '\''a >= (b && (c || d != e))'\'''

echo '$ test-expr '\''(((a >= b) || c) != d) && e'\'''
test-expr '(((a >= b) || c) != d) && e' 2>&1 ||
echo 'command failed: test-expr '\''(((a >= b) || c) != d) && e'\'''

echo '$ diff-expr '\''(((a >= b) || c) != d) && e'\'' '\''((a >= b) || c) != d && e'\'''
diff-expr '(((a >= b) || c) != d) && e' '((a >= b) || c) != d && e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a >= b) || c) != d) && e'\'' '\''((a >= b) || c) != d && e'\'''

echo '$ diff-expr '\''(((a >= b) || c) != d) && e'\'' '\''(a >= b || c) != d && e'\'''
diff-expr '(((a >= b) || c) != d) && e' '(a >= b || c) != d && e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a >= b) || c) != d) && e'\'' '\''(a >= b || c) != d && e'\'''

echo '$ diff-expr '\''(((a >= b) || c) != d) && e'\'' '\''((a >= b || c) != d) && e'\'''
diff-expr '(((a >= b) || c) != d) && e' '((a >= b || c) != d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a >= b) || c) != d) && e'\'' '\''((a >= b || c) != d) && e'\'''

echo '$ test-expr '\''a >= (((b || c) != d) && e)'\'''
test-expr 'a >= (((b || c) != d) && e)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (((b || c) != d) && e)'\'''

echo '$ diff-expr '\''a >= (((b || c) != d) && e)'\'' '\''a >= ((b || c) != d && e)'\'''
diff-expr 'a >= (((b || c) != d) && e)' 'a >= ((b || c) != d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (((b || c) != d) && e)'\'' '\''a >= ((b || c) != d && e)'\'''

echo '$ test-expr '\''(a >= ((b || c) != d)) && e'\'''
test-expr '(a >= ((b || c) != d)) && e' 2>&1 ||
echo 'command failed: test-expr '\''(a >= ((b || c) != d)) && e'\'''

echo '$ diff-expr '\''(a >= ((b || c) != d)) && e'\'' '\''a >= ((b || c) != d) && e'\'''
diff-expr '(a >= ((b || c) != d)) && e' 'a >= ((b || c) != d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= ((b || c) != d)) && e'\'' '\''a >= ((b || c) != d) && e'\'''

echo '$ test-expr '\''(a >= b) || ((c != d) && e)'\'''
test-expr '(a >= b) || ((c != d) && e)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) || ((c != d) && e)'\'''

echo '$ diff-expr '\''(a >= b) || ((c != d) && e)'\'' '\''a >= b || ((c != d) && e)'\'''
diff-expr '(a >= b) || ((c != d) && e)' 'a >= b || ((c != d) && e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || ((c != d) && e)'\'' '\''a >= b || ((c != d) && e)'\'''

echo '$ diff-expr '\''(a >= b) || ((c != d) && e)'\'' '\''a >= b || (c != d) && e'\'''
diff-expr '(a >= b) || ((c != d) && e)' 'a >= b || (c != d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || ((c != d) && e)'\'' '\''a >= b || (c != d) && e'\'''

echo '$ diff-expr '\''(a >= b) || ((c != d) && e)'\'' '\''a >= b || c != d && e'\'''
diff-expr '(a >= b) || ((c != d) && e)' 'a >= b || c != d && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || ((c != d) && e)'\'' '\''a >= b || c != d && e'\'''

echo '$ diff-expr '\''(a >= b) || ((c != d) && e)'\'' '\''a >= b || (c != d && e)'\'''
diff-expr '(a >= b) || ((c != d) && e)' 'a >= b || (c != d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || ((c != d) && e)'\'' '\''a >= b || (c != d && e)'\'''

echo '$ diff-expr '\''(a >= b) || ((c != d) && e)'\'' '\''(a >= b) || (c != d) && e'\'''
diff-expr '(a >= b) || ((c != d) && e)' '(a >= b) || (c != d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || ((c != d) && e)'\'' '\''(a >= b) || (c != d) && e'\'''

echo '$ diff-expr '\''(a >= b) || ((c != d) && e)'\'' '\''(a >= b) || c != d && e'\'''
diff-expr '(a >= b) || ((c != d) && e)' '(a >= b) || c != d && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || ((c != d) && e)'\'' '\''(a >= b) || c != d && e'\'''

echo '$ diff-expr '\''(a >= b) || ((c != d) && e)'\'' '\''(a >= b) || (c != d && e)'\'''
diff-expr '(a >= b) || ((c != d) && e)' '(a >= b) || (c != d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || ((c != d) && e)'\'' '\''(a >= b) || (c != d && e)'\'''

echo '$ test-expr '\''a >= (b || ((c != d) && e))'\'''
test-expr 'a >= (b || ((c != d) && e))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b || ((c != d) && e))'\'''

echo '$ diff-expr '\''a >= (b || ((c != d) && e))'\'' '\''a >= (b || (c != d) && e)'\'''
diff-expr 'a >= (b || ((c != d) && e))' 'a >= (b || (c != d) && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (b || ((c != d) && e))'\'' '\''a >= (b || (c != d) && e)'\'''

echo '$ diff-expr '\''a >= (b || ((c != d) && e))'\'' '\''a >= (b || c != d && e)'\'''
diff-expr 'a >= (b || ((c != d) && e))' 'a >= (b || c != d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (b || ((c != d) && e))'\'' '\''a >= (b || c != d && e)'\'''

echo '$ diff-expr '\''a >= (b || ((c != d) && e))'\'' '\''a >= (b || (c != d && e))'\'''
diff-expr 'a >= (b || ((c != d) && e))' 'a >= (b || (c != d && e))' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (b || ((c != d) && e))'\'' '\''a >= (b || (c != d && e))'\'''

echo '$ test-expr '\''((a >= (b || c)) != d) && e'\'''
test-expr '((a >= (b || c)) != d) && e' 2>&1 ||
echo 'command failed: test-expr '\''((a >= (b || c)) != d) && e'\'''

echo '$ diff-expr '\''((a >= (b || c)) != d) && e'\'' '\''(a >= (b || c)) != d && e'\'''
diff-expr '((a >= (b || c)) != d) && e' '(a >= (b || c)) != d && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= (b || c)) != d) && e'\'' '\''(a >= (b || c)) != d && e'\'''

echo '$ diff-expr '\''((a >= (b || c)) != d) && e'\'' '\''a >= (b || c) != d && e'\'''
diff-expr '((a >= (b || c)) != d) && e' 'a >= (b || c) != d && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= (b || c)) != d) && e'\'' '\''a >= (b || c) != d && e'\'''

echo '$ diff-expr '\''((a >= (b || c)) != d) && e'\'' '\''(a >= (b || c) != d) && e'\'''
diff-expr '((a >= (b || c)) != d) && e' '(a >= (b || c) != d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= (b || c)) != d) && e'\'' '\''(a >= (b || c) != d) && e'\'''

echo '$ test-expr '\''a >= ((b || (c != d)) && e)'\'''
test-expr 'a >= ((b || (c != d)) && e)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b || (c != d)) && e)'\'''

echo '$ diff-expr '\''a >= ((b || (c != d)) && e)'\'' '\''a >= ((b || c != d) && e)'\'''
diff-expr 'a >= ((b || (c != d)) && e)' 'a >= ((b || c != d) && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((b || (c != d)) && e)'\'' '\''a >= ((b || c != d) && e)'\'''

echo '$ test-expr '\''((a >= b) || (c != d)) && e'\'''
test-expr '((a >= b) || (c != d)) && e' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) || (c != d)) && e'\'''

echo '$ diff-expr '\''((a >= b) || (c != d)) && e'\'' '\''(a >= b || (c != d)) && e'\'''
diff-expr '((a >= b) || (c != d)) && e' '(a >= b || (c != d)) && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) || (c != d)) && e'\'' '\''(a >= b || (c != d)) && e'\'''

echo '$ diff-expr '\''((a >= b) || (c != d)) && e'\'' '\''(a >= b || c != d) && e'\'''
diff-expr '((a >= b) || (c != d)) && e' '(a >= b || c != d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) || (c != d)) && e'\'' '\''(a >= b || c != d) && e'\'''

echo '$ diff-expr '\''((a >= b) || (c != d)) && e'\'' '\''((a >= b) || c != d) && e'\'''
diff-expr '((a >= b) || (c != d)) && e' '((a >= b) || c != d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) || (c != d)) && e'\'' '\''((a >= b) || c != d) && e'\'''

echo '$ test-expr '\''((a >= b) || c) != (d && e)'\'''
test-expr '((a >= b) || c) != (d && e)' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) || c) != (d && e)'\'''

echo '$ diff-expr '\''((a >= b) || c) != (d && e)'\'' '\''(a >= b || c) != (d && e)'\'''
diff-expr '((a >= b) || c) != (d && e)' '(a >= b || c) != (d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) || c) != (d && e)'\'' '\''(a >= b || c) != (d && e)'\'''

echo '$ test-expr '\''a >= ((b || c) != (d && e))'\'''
test-expr 'a >= ((b || c) != (d && e))' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b || c) != (d && e))'\'''

echo '$ test-expr '\''(a >= (b || (c != d))) && e'\'''
test-expr '(a >= (b || (c != d))) && e' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b || (c != d))) && e'\'''

echo '$ diff-expr '\''(a >= (b || (c != d))) && e'\'' '\''a >= (b || (c != d)) && e'\'''
diff-expr '(a >= (b || (c != d))) && e' 'a >= (b || (c != d)) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b || (c != d))) && e'\'' '\''a >= (b || (c != d)) && e'\'''

echo '$ diff-expr '\''(a >= (b || (c != d))) && e'\'' '\''a >= (b || c != d) && e'\'''
diff-expr '(a >= (b || (c != d))) && e' 'a >= (b || c != d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b || (c != d))) && e'\'' '\''a >= (b || c != d) && e'\'''

echo '$ diff-expr '\''(a >= (b || (c != d))) && e'\'' '\''(a >= (b || c != d)) && e'\'''
diff-expr '(a >= (b || (c != d))) && e' '(a >= (b || c != d)) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b || (c != d))) && e'\'' '\''(a >= (b || c != d)) && e'\'''

echo '$ test-expr '\''(a >= (b || c)) != (d && e)'\'''
test-expr '(a >= (b || c)) != (d && e)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b || c)) != (d && e)'\'''

echo '$ diff-expr '\''(a >= (b || c)) != (d && e)'\'' '\''a >= (b || c) != (d && e)'\'''
diff-expr '(a >= (b || c)) != (d && e)' 'a >= (b || c) != (d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b || c)) != (d && e)'\'' '\''a >= (b || c) != (d && e)'\'''

echo '$ test-expr '\''(a >= b) || (c != (d && e))'\'''
test-expr '(a >= b) || (c != (d && e))' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) || (c != (d && e))'\'''

echo '$ diff-expr '\''(a >= b) || (c != (d && e))'\'' '\''a >= b || (c != (d && e))'\'''
diff-expr '(a >= b) || (c != (d && e))' 'a >= b || (c != (d && e))' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (c != (d && e))'\'' '\''a >= b || (c != (d && e))'\'''

echo '$ diff-expr '\''(a >= b) || (c != (d && e))'\'' '\''a >= b || c != (d && e)'\'''
diff-expr '(a >= b) || (c != (d && e))' 'a >= b || c != (d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (c != (d && e))'\'' '\''a >= b || c != (d && e)'\'''

echo '$ diff-expr '\''(a >= b) || (c != (d && e))'\'' '\''(a >= b) || c != (d && e)'\'''
diff-expr '(a >= b) || (c != (d && e))' '(a >= b) || c != (d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (c != (d && e))'\'' '\''(a >= b) || c != (d && e)'\'''

echo '$ test-expr '\''a >= (b || (c != (d && e)))'\'''
test-expr 'a >= (b || (c != (d && e)))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b || (c != (d && e)))'\'''

echo '$ diff-expr '\''a >= (b || (c != (d && e)))'\'' '\''a >= (b || c != (d && e))'\'''
diff-expr 'a >= (b || (c != (d && e)))' 'a >= (b || c != (d && e))' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (b || (c != (d && e)))'\'' '\''a >= (b || c != (d && e))'\'''

echo '$ test-expr '\''(((a >= b) || c) && d) != e'\'''
test-expr '(((a >= b) || c) && d) != e' 2>&1 ||
echo 'command failed: test-expr '\''(((a >= b) || c) && d) != e'\'''

echo '$ diff-expr '\''(((a >= b) || c) && d) != e'\'' '\''((a >= b || c) && d) != e'\'''
diff-expr '(((a >= b) || c) && d) != e' '((a >= b || c) && d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a >= b) || c) && d) != e'\'' '\''((a >= b || c) && d) != e'\'''

echo '$ test-expr '\''a >= (((b || c) && d) != e)'\'''
test-expr 'a >= (((b || c) && d) != e)' 2>&1 ||
echo 'command failed: test-expr '\''a >= (((b || c) && d) != e)'\'''

echo '$ test-expr '\''(a >= ((b || c) && d)) != e'\'''
test-expr '(a >= ((b || c) && d)) != e' 2>&1 ||
echo 'command failed: test-expr '\''(a >= ((b || c) && d)) != e'\'''

echo '$ diff-expr '\''(a >= ((b || c) && d)) != e'\'' '\''a >= ((b || c) && d) != e'\'''
diff-expr '(a >= ((b || c) && d)) != e' 'a >= ((b || c) && d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= ((b || c) && d)) != e'\'' '\''a >= ((b || c) && d) != e'\'''

echo '$ test-expr '\''(a >= b) || ((c && d) != e)'\'''
test-expr '(a >= b) || ((c && d) != e)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) || ((c && d) != e)'\'''

echo '$ diff-expr '\''(a >= b) || ((c && d) != e)'\'' '\''a >= b || ((c && d) != e)'\'''
diff-expr '(a >= b) || ((c && d) != e)' 'a >= b || ((c && d) != e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || ((c && d) != e)'\'' '\''a >= b || ((c && d) != e)'\'''

echo '$ diff-expr '\''(a >= b) || ((c && d) != e)'\'' '\''a >= b || (c && d) != e'\'''
diff-expr '(a >= b) || ((c && d) != e)' 'a >= b || (c && d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || ((c && d) != e)'\'' '\''a >= b || (c && d) != e'\'''

echo '$ diff-expr '\''(a >= b) || ((c && d) != e)'\'' '\''(a >= b) || (c && d) != e'\'''
diff-expr '(a >= b) || ((c && d) != e)' '(a >= b) || (c && d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || ((c && d) != e)'\'' '\''(a >= b) || (c && d) != e'\'''

echo '$ test-expr '\''a >= (b || ((c && d) != e))'\'''
test-expr 'a >= (b || ((c && d) != e))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b || ((c && d) != e))'\'''

echo '$ diff-expr '\''a >= (b || ((c && d) != e))'\'' '\''a >= (b || (c && d) != e)'\'''
diff-expr 'a >= (b || ((c && d) != e))' 'a >= (b || (c && d) != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (b || ((c && d) != e))'\'' '\''a >= (b || (c && d) != e)'\'''

echo '$ test-expr '\''((a >= (b || c)) && d) != e'\'''
test-expr '((a >= (b || c)) && d) != e' 2>&1 ||
echo 'command failed: test-expr '\''((a >= (b || c)) && d) != e'\'''

echo '$ diff-expr '\''((a >= (b || c)) && d) != e'\'' '\''(a >= (b || c) && d) != e'\'''
diff-expr '((a >= (b || c)) && d) != e' '(a >= (b || c) && d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= (b || c)) && d) != e'\'' '\''(a >= (b || c) && d) != e'\'''

echo '$ test-expr '\''a >= ((b || (c && d)) != e)'\'''
test-expr 'a >= ((b || (c && d)) != e)' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b || (c && d)) != e)'\'''

echo '$ diff-expr '\''a >= ((b || (c && d)) != e)'\'' '\''a >= ((b || c && d) != e)'\'''
diff-expr 'a >= ((b || (c && d)) != e)' 'a >= ((b || c && d) != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((b || (c && d)) != e)'\'' '\''a >= ((b || c && d) != e)'\'''

echo '$ test-expr '\''((a >= b) || (c && d)) != e'\'''
test-expr '((a >= b) || (c && d)) != e' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) || (c && d)) != e'\'''

echo '$ diff-expr '\''((a >= b) || (c && d)) != e'\'' '\''(a >= b || (c && d)) != e'\'''
diff-expr '((a >= b) || (c && d)) != e' '(a >= b || (c && d)) != e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) || (c && d)) != e'\'' '\''(a >= b || (c && d)) != e'\'''

echo '$ diff-expr '\''((a >= b) || (c && d)) != e'\'' '\''(a >= b || c && d) != e'\'''
diff-expr '((a >= b) || (c && d)) != e' '(a >= b || c && d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) || (c && d)) != e'\'' '\''(a >= b || c && d) != e'\'''

echo '$ diff-expr '\''((a >= b) || (c && d)) != e'\'' '\''((a >= b) || c && d) != e'\'''
diff-expr '((a >= b) || (c && d)) != e' '((a >= b) || c && d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) || (c && d)) != e'\'' '\''((a >= b) || c && d) != e'\'''

echo '$ test-expr '\''((a >= b) || c) && (d != e)'\'''
test-expr '((a >= b) || c) && (d != e)' 2>&1 ||
echo 'command failed: test-expr '\''((a >= b) || c) && (d != e)'\'''

echo '$ diff-expr '\''((a >= b) || c) && (d != e)'\'' '\''(a >= b || c) && (d != e)'\'''
diff-expr '((a >= b) || c) && (d != e)' '(a >= b || c) && (d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) || c) && (d != e)'\'' '\''(a >= b || c) && (d != e)'\'''

echo '$ diff-expr '\''((a >= b) || c) && (d != e)'\'' '\''(a >= b || c) && d != e'\'''
diff-expr '((a >= b) || c) && (d != e)' '(a >= b || c) && d != e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) || c) && (d != e)'\'' '\''(a >= b || c) && d != e'\'''

echo '$ diff-expr '\''((a >= b) || c) && (d != e)'\'' '\''((a >= b) || c) && d != e'\'''
diff-expr '((a >= b) || c) && (d != e)' '((a >= b) || c) && d != e' 2>&1 ||
echo 'command failed: diff-expr '\''((a >= b) || c) && (d != e)'\'' '\''((a >= b) || c) && d != e'\'''

echo '$ test-expr '\''a >= ((b || c) && (d != e))'\'''
test-expr 'a >= ((b || c) && (d != e))' 2>&1 ||
echo 'command failed: test-expr '\''a >= ((b || c) && (d != e))'\'''

echo '$ diff-expr '\''a >= ((b || c) && (d != e))'\'' '\''a >= ((b || c) && d != e)'\'''
diff-expr 'a >= ((b || c) && (d != e))' 'a >= ((b || c) && d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= ((b || c) && (d != e))'\'' '\''a >= ((b || c) && d != e)'\'''

echo '$ test-expr '\''(a >= (b || (c && d))) != e'\'''
test-expr '(a >= (b || (c && d))) != e' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b || (c && d))) != e'\'''

echo '$ diff-expr '\''(a >= (b || (c && d))) != e'\'' '\''a >= (b || (c && d)) != e'\'''
diff-expr '(a >= (b || (c && d))) != e' 'a >= (b || (c && d)) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b || (c && d))) != e'\'' '\''a >= (b || (c && d)) != e'\'''

echo '$ diff-expr '\''(a >= (b || (c && d))) != e'\'' '\''a >= (b || c && d) != e'\'''
diff-expr '(a >= (b || (c && d))) != e' 'a >= (b || c && d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b || (c && d))) != e'\'' '\''a >= (b || c && d) != e'\'''

echo '$ diff-expr '\''(a >= (b || (c && d))) != e'\'' '\''(a >= (b || c && d)) != e'\'''
diff-expr '(a >= (b || (c && d))) != e' '(a >= (b || c && d)) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b || (c && d))) != e'\'' '\''(a >= (b || c && d)) != e'\'''

echo '$ test-expr '\''(a >= (b || c)) && (d != e)'\'''
test-expr '(a >= (b || c)) && (d != e)' 2>&1 ||
echo 'command failed: test-expr '\''(a >= (b || c)) && (d != e)'\'''

echo '$ diff-expr '\''(a >= (b || c)) && (d != e)'\'' '\''a >= (b || c) && (d != e)'\'''
diff-expr '(a >= (b || c)) && (d != e)' 'a >= (b || c) && (d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b || c)) && (d != e)'\'' '\''a >= (b || c) && (d != e)'\'''

echo '$ diff-expr '\''(a >= (b || c)) && (d != e)'\'' '\''a >= (b || c) && d != e'\'''
diff-expr '(a >= (b || c)) && (d != e)' 'a >= (b || c) && d != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b || c)) && (d != e)'\'' '\''a >= (b || c) && d != e'\'''

echo '$ diff-expr '\''(a >= (b || c)) && (d != e)'\'' '\''(a >= (b || c)) && d != e'\'''
diff-expr '(a >= (b || c)) && (d != e)' '(a >= (b || c)) && d != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= (b || c)) && (d != e)'\'' '\''(a >= (b || c)) && d != e'\'''

echo '$ test-expr '\''(a >= b) || (c && (d != e))'\'''
test-expr '(a >= b) || (c && (d != e))' 2>&1 ||
echo 'command failed: test-expr '\''(a >= b) || (c && (d != e))'\'''

echo '$ diff-expr '\''(a >= b) || (c && (d != e))'\'' '\''a >= b || (c && (d != e))'\'''
diff-expr '(a >= b) || (c && (d != e))' 'a >= b || (c && (d != e))' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (c && (d != e))'\'' '\''a >= b || (c && (d != e))'\'''

echo '$ diff-expr '\''(a >= b) || (c && (d != e))'\'' '\''a >= b || c && (d != e)'\'''
diff-expr '(a >= b) || (c && (d != e))' 'a >= b || c && (d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (c && (d != e))'\'' '\''a >= b || c && (d != e)'\'''

echo '$ diff-expr '\''(a >= b) || (c && (d != e))'\'' '\''a >= b || c && d != e'\'''
diff-expr '(a >= b) || (c && (d != e))' 'a >= b || c && d != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (c && (d != e))'\'' '\''a >= b || c && d != e'\'''

echo '$ diff-expr '\''(a >= b) || (c && (d != e))'\'' '\''a >= b || (c && d != e)'\'''
diff-expr '(a >= b) || (c && (d != e))' 'a >= b || (c && d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (c && (d != e))'\'' '\''a >= b || (c && d != e)'\'''

echo '$ diff-expr '\''(a >= b) || (c && (d != e))'\'' '\''(a >= b) || c && (d != e)'\'''
diff-expr '(a >= b) || (c && (d != e))' '(a >= b) || c && (d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (c && (d != e))'\'' '\''(a >= b) || c && (d != e)'\'''

echo '$ diff-expr '\''(a >= b) || (c && (d != e))'\'' '\''(a >= b) || c && d != e'\'''
diff-expr '(a >= b) || (c && (d != e))' '(a >= b) || c && d != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (c && (d != e))'\'' '\''(a >= b) || c && d != e'\'''

echo '$ diff-expr '\''(a >= b) || (c && (d != e))'\'' '\''(a >= b) || (c && d != e)'\'''
diff-expr '(a >= b) || (c && (d != e))' '(a >= b) || (c && d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a >= b) || (c && (d != e))'\'' '\''(a >= b) || (c && d != e)'\'''

echo '$ test-expr '\''a >= (b || (c && (d != e)))'\'''
test-expr 'a >= (b || (c && (d != e)))' 2>&1 ||
echo 'command failed: test-expr '\''a >= (b || (c && (d != e)))'\'''

echo '$ diff-expr '\''a >= (b || (c && (d != e)))'\'' '\''a >= (b || c && (d != e))'\'''
diff-expr 'a >= (b || (c && (d != e)))' 'a >= (b || c && (d != e))' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (b || (c && (d != e)))'\'' '\''a >= (b || c && (d != e))'\'''

echo '$ diff-expr '\''a >= (b || (c && (d != e)))'\'' '\''a >= (b || c && d != e)'\'''
diff-expr 'a >= (b || (c && (d != e)))' 'a >= (b || c && d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (b || (c && (d != e)))'\'' '\''a >= (b || c && d != e)'\'''

echo '$ diff-expr '\''a >= (b || (c && (d != e)))'\'' '\''a >= (b || (c && d != e))'\'''
diff-expr 'a >= (b || (c && (d != e)))' 'a >= (b || (c && d != e))' 2>&1 ||
echo 'command failed: diff-expr '\''a >= (b || (c && (d != e)))'\'' '\''a >= (b || (c && d != e))'\'''

echo '$ test-expr '\''(((a != b) >= c) && d) || e'\'''
test-expr '(((a != b) >= c) && d) || e' 2>&1 ||
echo 'command failed: test-expr '\''(((a != b) >= c) && d) || e'\'''

echo '$ diff-expr '\''(((a != b) >= c) && d) || e'\'' '\''((a != b) >= c) && d || e'\'''
diff-expr '(((a != b) >= c) && d) || e' '((a != b) >= c) && d || e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a != b) >= c) && d) || e'\'' '\''((a != b) >= c) && d || e'\'''

echo '$ diff-expr '\''(((a != b) >= c) && d) || e'\'' '\''(a != b) >= c && d || e'\'''
diff-expr '(((a != b) >= c) && d) || e' '(a != b) >= c && d || e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a != b) >= c) && d) || e'\'' '\''(a != b) >= c && d || e'\'''

echo '$ diff-expr '\''(((a != b) >= c) && d) || e'\'' '\''((a != b) >= c && d) || e'\'''
diff-expr '(((a != b) >= c) && d) || e' '((a != b) >= c && d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a != b) >= c) && d) || e'\'' '\''((a != b) >= c && d) || e'\'''

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'''
test-expr 'a != (((b >= c) && d) || e)' 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'''

echo '$ diff-expr '\''a != (((b >= c) && d) || e)'\'' '\''a != ((b >= c) && d || e)'\'''
diff-expr 'a != (((b >= c) && d) || e)' 'a != ((b >= c) && d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (((b >= c) && d) || e)'\'' '\''a != ((b >= c) && d || e)'\'''

echo '$ diff-expr '\''a != (((b >= c) && d) || e)'\'' '\''a != (b >= c && d || e)'\'''
diff-expr 'a != (((b >= c) && d) || e)' 'a != (b >= c && d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (((b >= c) && d) || e)'\'' '\''a != (b >= c && d || e)'\'''

echo '$ diff-expr '\''a != (((b >= c) && d) || e)'\'' '\''a != ((b >= c && d) || e)'\'''
diff-expr 'a != (((b >= c) && d) || e)' 'a != ((b >= c && d) || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (((b >= c) && d) || e)'\'' '\''a != ((b >= c && d) || e)'\'''

echo '$ test-expr '\''(a != ((b >= c) && d)) || e'\'''
test-expr '(a != ((b >= c) && d)) || e' 2>&1 ||
echo 'command failed: test-expr '\''(a != ((b >= c) && d)) || e'\'''

echo '$ diff-expr '\''(a != ((b >= c) && d)) || e'\'' '\''a != ((b >= c) && d) || e'\'''
diff-expr '(a != ((b >= c) && d)) || e' 'a != ((b >= c) && d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != ((b >= c) && d)) || e'\'' '\''a != ((b >= c) && d) || e'\'''

echo '$ diff-expr '\''(a != ((b >= c) && d)) || e'\'' '\''a != (b >= c && d) || e'\'''
diff-expr '(a != ((b >= c) && d)) || e' 'a != (b >= c && d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != ((b >= c) && d)) || e'\'' '\''a != (b >= c && d) || e'\'''

echo '$ diff-expr '\''(a != ((b >= c) && d)) || e'\'' '\''(a != (b >= c && d)) || e'\'''
diff-expr '(a != ((b >= c) && d)) || e' '(a != (b >= c && d)) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != ((b >= c) && d)) || e'\'' '\''(a != (b >= c && d)) || e'\'''

echo '$ test-expr '\''(a != b) >= ((c && d) || e)'\'''
test-expr '(a != b) >= ((c && d) || e)' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) >= ((c && d) || e)'\'''

echo '$ diff-expr '\''(a != b) >= ((c && d) || e)'\'' '\''(a != b) >= (c && d || e)'\'''
diff-expr '(a != b) >= ((c && d) || e)' '(a != b) >= (c && d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) >= ((c && d) || e)'\'' '\''(a != b) >= (c && d || e)'\'''

echo '$ test-expr '\''a != (b >= ((c && d) || e))'\'''
test-expr 'a != (b >= ((c && d) || e))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c && d) || e))'\'''

echo '$ diff-expr '\''a != (b >= ((c && d) || e))'\'' '\''a != b >= ((c && d) || e)'\'''
diff-expr 'a != (b >= ((c && d) || e))' 'a != b >= ((c && d) || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b >= ((c && d) || e))'\'' '\''a != b >= ((c && d) || e)'\'''

echo '$ diff-expr '\''a != (b >= ((c && d) || e))'\'' '\''a != b >= (c && d || e)'\'''
diff-expr 'a != (b >= ((c && d) || e))' 'a != b >= (c && d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b >= ((c && d) || e))'\'' '\''a != b >= (c && d || e)'\'''

echo '$ diff-expr '\''a != (b >= ((c && d) || e))'\'' '\''a != (b >= (c && d || e))'\'''
diff-expr 'a != (b >= ((c && d) || e))' 'a != (b >= (c && d || e))' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b >= ((c && d) || e))'\'' '\''a != (b >= (c && d || e))'\'''

echo '$ test-expr '\''((a != (b >= c)) && d) || e'\'''
test-expr '((a != (b >= c)) && d) || e' 2>&1 ||
echo 'command failed: test-expr '\''((a != (b >= c)) && d) || e'\'''

echo '$ diff-expr '\''((a != (b >= c)) && d) || e'\'' '\''(a != (b >= c)) && d || e'\'''
diff-expr '((a != (b >= c)) && d) || e' '(a != (b >= c)) && d || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != (b >= c)) && d) || e'\'' '\''(a != (b >= c)) && d || e'\'''

echo '$ diff-expr '\''((a != (b >= c)) && d) || e'\'' '\''a != (b >= c) && d || e'\'''
diff-expr '((a != (b >= c)) && d) || e' 'a != (b >= c) && d || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != (b >= c)) && d) || e'\'' '\''a != (b >= c) && d || e'\'''

echo '$ diff-expr '\''((a != (b >= c)) && d) || e'\'' '\''a != b >= c && d || e'\'''
diff-expr '((a != (b >= c)) && d) || e' 'a != b >= c && d || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != (b >= c)) && d) || e'\'' '\''a != b >= c && d || e'\'''

echo '$ diff-expr '\''((a != (b >= c)) && d) || e'\'' '\''(a != b >= c) && d || e'\'''
diff-expr '((a != (b >= c)) && d) || e' '(a != b >= c) && d || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != (b >= c)) && d) || e'\'' '\''(a != b >= c) && d || e'\'''

echo '$ diff-expr '\''((a != (b >= c)) && d) || e'\'' '\''(a != (b >= c) && d) || e'\'''
diff-expr '((a != (b >= c)) && d) || e' '(a != (b >= c) && d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != (b >= c)) && d) || e'\'' '\''(a != (b >= c) && d) || e'\'''

echo '$ diff-expr '\''((a != (b >= c)) && d) || e'\'' '\''(a != b >= c && d) || e'\'''
diff-expr '((a != (b >= c)) && d) || e' '(a != b >= c && d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != (b >= c)) && d) || e'\'' '\''(a != b >= c && d) || e'\'''

echo '$ diff-expr '\''((a != (b >= c)) && d) || e'\'' '\''((a != b >= c) && d) || e'\'''
diff-expr '((a != (b >= c)) && d) || e' '((a != b >= c) && d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != (b >= c)) && d) || e'\'' '\''((a != b >= c) && d) || e'\'''

echo '$ test-expr '\''a != ((b >= (c && d)) || e)'\'''
test-expr 'a != ((b >= (c && d)) || e)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c && d)) || e)'\'''

echo '$ diff-expr '\''a != ((b >= (c && d)) || e)'\'' '\''a != (b >= (c && d) || e)'\'''
diff-expr 'a != ((b >= (c && d)) || e)' 'a != (b >= (c && d) || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b >= (c && d)) || e)'\'' '\''a != (b >= (c && d) || e)'\'''

echo '$ test-expr '\''((a != b) >= (c && d)) || e'\'''
test-expr '((a != b) >= (c && d)) || e' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) >= (c && d)) || e'\'''

echo '$ diff-expr '\''((a != b) >= (c && d)) || e'\'' '\''(a != b) >= (c && d) || e'\'''
diff-expr '((a != b) >= (c && d)) || e' '(a != b) >= (c && d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) >= (c && d)) || e'\'' '\''(a != b) >= (c && d) || e'\'''

echo '$ test-expr '\''((a != b) >= c) && (d || e)'\'''
test-expr '((a != b) >= c) && (d || e)' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) >= c) && (d || e)'\'''

echo '$ diff-expr '\''((a != b) >= c) && (d || e)'\'' '\''(a != b) >= c && (d || e)'\'''
diff-expr '((a != b) >= c) && (d || e)' '(a != b) >= c && (d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) >= c) && (d || e)'\'' '\''(a != b) >= c && (d || e)'\'''

echo '$ test-expr '\''a != ((b >= c) && (d || e))'\'''
test-expr 'a != ((b >= c) && (d || e))' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) && (d || e))'\'''

echo '$ diff-expr '\''a != ((b >= c) && (d || e))'\'' '\''a != (b >= c && (d || e))'\'''
diff-expr 'a != ((b >= c) && (d || e))' 'a != (b >= c && (d || e))' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b >= c) && (d || e))'\'' '\''a != (b >= c && (d || e))'\'''

echo '$ test-expr '\''(a != (b >= (c && d))) || e'\'''
test-expr '(a != (b >= (c && d))) || e' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b >= (c && d))) || e'\'''

echo '$ diff-expr '\''(a != (b >= (c && d))) || e'\'' '\''a != (b >= (c && d)) || e'\'''
diff-expr '(a != (b >= (c && d))) || e' 'a != (b >= (c && d)) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= (c && d))) || e'\'' '\''a != (b >= (c && d)) || e'\'''

echo '$ diff-expr '\''(a != (b >= (c && d))) || e'\'' '\''a != b >= (c && d) || e'\'''
diff-expr '(a != (b >= (c && d))) || e' 'a != b >= (c && d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= (c && d))) || e'\'' '\''a != b >= (c && d) || e'\'''

echo '$ diff-expr '\''(a != (b >= (c && d))) || e'\'' '\''(a != b >= (c && d)) || e'\'''
diff-expr '(a != (b >= (c && d))) || e' '(a != b >= (c && d)) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= (c && d))) || e'\'' '\''(a != b >= (c && d)) || e'\'''

echo '$ test-expr '\''(a != (b >= c)) && (d || e)'\'''
test-expr '(a != (b >= c)) && (d || e)' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b >= c)) && (d || e)'\'''

echo '$ diff-expr '\''(a != (b >= c)) && (d || e)'\'' '\''a != (b >= c) && (d || e)'\'''
diff-expr '(a != (b >= c)) && (d || e)' 'a != (b >= c) && (d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= c)) && (d || e)'\'' '\''a != (b >= c) && (d || e)'\'''

echo '$ diff-expr '\''(a != (b >= c)) && (d || e)'\'' '\''a != b >= c && (d || e)'\'''
diff-expr '(a != (b >= c)) && (d || e)' 'a != b >= c && (d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= c)) && (d || e)'\'' '\''a != b >= c && (d || e)'\'''

echo '$ diff-expr '\''(a != (b >= c)) && (d || e)'\'' '\''(a != b >= c) && (d || e)'\'''
diff-expr '(a != (b >= c)) && (d || e)' '(a != b >= c) && (d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= c)) && (d || e)'\'' '\''(a != b >= c) && (d || e)'\'''

echo '$ test-expr '\''(a != b) >= (c && (d || e))'\'''
test-expr '(a != b) >= (c && (d || e))' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) >= (c && (d || e))'\'''

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'''
test-expr 'a != (b >= (c && (d || e)))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'''

echo '$ diff-expr '\''a != (b >= (c && (d || e)))'\'' '\''a != b >= (c && (d || e))'\'''
diff-expr 'a != (b >= (c && (d || e)))' 'a != b >= (c && (d || e))' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b >= (c && (d || e)))'\'' '\''a != b >= (c && (d || e))'\'''

echo '$ test-expr '\''(((a != b) >= c) || d) && e'\'''
test-expr '(((a != b) >= c) || d) && e' 2>&1 ||
echo 'command failed: test-expr '\''(((a != b) >= c) || d) && e'\'''

echo '$ diff-expr '\''(((a != b) >= c) || d) && e'\'' '\''((a != b) >= c || d) && e'\'''
diff-expr '(((a != b) >= c) || d) && e' '((a != b) >= c || d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a != b) >= c) || d) && e'\'' '\''((a != b) >= c || d) && e'\'''

echo '$ test-expr '\''a != (((b >= c) || d) && e)'\'''
test-expr 'a != (((b >= c) || d) && e)' 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) || d) && e)'\'''

echo '$ diff-expr '\''a != (((b >= c) || d) && e)'\'' '\''a != ((b >= c || d) && e)'\'''
diff-expr 'a != (((b >= c) || d) && e)' 'a != ((b >= c || d) && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (((b >= c) || d) && e)'\'' '\''a != ((b >= c || d) && e)'\'''

echo '$ test-expr '\''(a != ((b >= c) || d)) && e'\'''
test-expr '(a != ((b >= c) || d)) && e' 2>&1 ||
echo 'command failed: test-expr '\''(a != ((b >= c) || d)) && e'\'''

echo '$ diff-expr '\''(a != ((b >= c) || d)) && e'\'' '\''a != ((b >= c) || d) && e'\'''
diff-expr '(a != ((b >= c) || d)) && e' 'a != ((b >= c) || d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != ((b >= c) || d)) && e'\'' '\''a != ((b >= c) || d) && e'\'''

echo '$ diff-expr '\''(a != ((b >= c) || d)) && e'\'' '\''a != (b >= c || d) && e'\'''
diff-expr '(a != ((b >= c) || d)) && e' 'a != (b >= c || d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != ((b >= c) || d)) && e'\'' '\''a != (b >= c || d) && e'\'''

echo '$ diff-expr '\''(a != ((b >= c) || d)) && e'\'' '\''(a != (b >= c || d)) && e'\'''
diff-expr '(a != ((b >= c) || d)) && e' '(a != (b >= c || d)) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != ((b >= c) || d)) && e'\'' '\''(a != (b >= c || d)) && e'\'''

echo '$ test-expr '\''(a != b) >= ((c || d) && e)'\'''
test-expr '(a != b) >= ((c || d) && e)' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) >= ((c || d) && e)'\'''

echo '$ test-expr '\''a != (b >= ((c || d) && e))'\'''
test-expr 'a != (b >= ((c || d) && e))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c || d) && e))'\'''

echo '$ diff-expr '\''a != (b >= ((c || d) && e))'\'' '\''a != b >= ((c || d) && e)'\'''
diff-expr 'a != (b >= ((c || d) && e))' 'a != b >= ((c || d) && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b >= ((c || d) && e))'\'' '\''a != b >= ((c || d) && e)'\'''

echo '$ test-expr '\''((a != (b >= c)) || d) && e'\'''
test-expr '((a != (b >= c)) || d) && e' 2>&1 ||
echo 'command failed: test-expr '\''((a != (b >= c)) || d) && e'\'''

echo '$ diff-expr '\''((a != (b >= c)) || d) && e'\'' '\''(a != (b >= c) || d) && e'\'''
diff-expr '((a != (b >= c)) || d) && e' '(a != (b >= c) || d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != (b >= c)) || d) && e'\'' '\''(a != (b >= c) || d) && e'\'''

echo '$ diff-expr '\''((a != (b >= c)) || d) && e'\'' '\''(a != b >= c || d) && e'\'''
diff-expr '((a != (b >= c)) || d) && e' '(a != b >= c || d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != (b >= c)) || d) && e'\'' '\''(a != b >= c || d) && e'\'''

echo '$ diff-expr '\''((a != (b >= c)) || d) && e'\'' '\''((a != b >= c) || d) && e'\'''
diff-expr '((a != (b >= c)) || d) && e' '((a != b >= c) || d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != (b >= c)) || d) && e'\'' '\''((a != b >= c) || d) && e'\'''

echo '$ test-expr '\''a != ((b >= (c || d)) && e)'\'''
test-expr 'a != ((b >= (c || d)) && e)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c || d)) && e)'\'''

echo '$ diff-expr '\''a != ((b >= (c || d)) && e)'\'' '\''a != (b >= (c || d) && e)'\'''
diff-expr 'a != ((b >= (c || d)) && e)' 'a != (b >= (c || d) && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b >= (c || d)) && e)'\'' '\''a != (b >= (c || d) && e)'\'''

echo '$ test-expr '\''((a != b) >= (c || d)) && e'\'''
test-expr '((a != b) >= (c || d)) && e' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) >= (c || d)) && e'\'''

echo '$ diff-expr '\''((a != b) >= (c || d)) && e'\'' '\''(a != b) >= (c || d) && e'\'''
diff-expr '((a != b) >= (c || d)) && e' '(a != b) >= (c || d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) >= (c || d)) && e'\'' '\''(a != b) >= (c || d) && e'\'''

echo '$ test-expr '\''((a != b) >= c) || (d && e)'\'''
test-expr '((a != b) >= c) || (d && e)' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) >= c) || (d && e)'\'''

echo '$ diff-expr '\''((a != b) >= c) || (d && e)'\'' '\''(a != b) >= c || (d && e)'\'''
diff-expr '((a != b) >= c) || (d && e)' '(a != b) >= c || (d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) >= c) || (d && e)'\'' '\''(a != b) >= c || (d && e)'\'''

echo '$ diff-expr '\''((a != b) >= c) || (d && e)'\'' '\''(a != b) >= c || d && e'\'''
diff-expr '((a != b) >= c) || (d && e)' '(a != b) >= c || d && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) >= c) || (d && e)'\'' '\''(a != b) >= c || d && e'\'''

echo '$ diff-expr '\''((a != b) >= c) || (d && e)'\'' '\''((a != b) >= c) || d && e'\'''
diff-expr '((a != b) >= c) || (d && e)' '((a != b) >= c) || d && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) >= c) || (d && e)'\'' '\''((a != b) >= c) || d && e'\'''

echo '$ test-expr '\''a != ((b >= c) || (d && e))'\'''
test-expr 'a != ((b >= c) || (d && e))' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || (d && e))'\'''

echo '$ diff-expr '\''a != ((b >= c) || (d && e))'\'' '\''a != (b >= c || (d && e))'\'''
diff-expr 'a != ((b >= c) || (d && e))' 'a != (b >= c || (d && e))' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b >= c) || (d && e))'\'' '\''a != (b >= c || (d && e))'\'''

echo '$ diff-expr '\''a != ((b >= c) || (d && e))'\'' '\''a != (b >= c || d && e)'\'''
diff-expr 'a != ((b >= c) || (d && e))' 'a != (b >= c || d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b >= c) || (d && e))'\'' '\''a != (b >= c || d && e)'\'''

echo '$ diff-expr '\''a != ((b >= c) || (d && e))'\'' '\''a != ((b >= c) || d && e)'\'''
diff-expr 'a != ((b >= c) || (d && e))' 'a != ((b >= c) || d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b >= c) || (d && e))'\'' '\''a != ((b >= c) || d && e)'\'''

echo '$ test-expr '\''(a != (b >= (c || d))) && e'\'''
test-expr '(a != (b >= (c || d))) && e' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b >= (c || d))) && e'\'''

echo '$ diff-expr '\''(a != (b >= (c || d))) && e'\'' '\''a != (b >= (c || d)) && e'\'''
diff-expr '(a != (b >= (c || d))) && e' 'a != (b >= (c || d)) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= (c || d))) && e'\'' '\''a != (b >= (c || d)) && e'\'''

echo '$ diff-expr '\''(a != (b >= (c || d))) && e'\'' '\''a != b >= (c || d) && e'\'''
diff-expr '(a != (b >= (c || d))) && e' 'a != b >= (c || d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= (c || d))) && e'\'' '\''a != b >= (c || d) && e'\'''

echo '$ diff-expr '\''(a != (b >= (c || d))) && e'\'' '\''(a != b >= (c || d)) && e'\'''
diff-expr '(a != (b >= (c || d))) && e' '(a != b >= (c || d)) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= (c || d))) && e'\'' '\''(a != b >= (c || d)) && e'\'''

echo '$ test-expr '\''(a != (b >= c)) || (d && e)'\'''
test-expr '(a != (b >= c)) || (d && e)' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b >= c)) || (d && e)'\'''

echo '$ diff-expr '\''(a != (b >= c)) || (d && e)'\'' '\''a != (b >= c) || (d && e)'\'''
diff-expr '(a != (b >= c)) || (d && e)' 'a != (b >= c) || (d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= c)) || (d && e)'\'' '\''a != (b >= c) || (d && e)'\'''

echo '$ diff-expr '\''(a != (b >= c)) || (d && e)'\'' '\''a != b >= c || (d && e)'\'''
diff-expr '(a != (b >= c)) || (d && e)' 'a != b >= c || (d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= c)) || (d && e)'\'' '\''a != b >= c || (d && e)'\'''

echo '$ diff-expr '\''(a != (b >= c)) || (d && e)'\'' '\''a != b >= c || d && e'\'''
diff-expr '(a != (b >= c)) || (d && e)' 'a != b >= c || d && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= c)) || (d && e)'\'' '\''a != b >= c || d && e'\'''

echo '$ diff-expr '\''(a != (b >= c)) || (d && e)'\'' '\''a != (b >= c) || d && e'\'''
diff-expr '(a != (b >= c)) || (d && e)' 'a != (b >= c) || d && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= c)) || (d && e)'\'' '\''a != (b >= c) || d && e'\'''

echo '$ diff-expr '\''(a != (b >= c)) || (d && e)'\'' '\''(a != b >= c) || (d && e)'\'''
diff-expr '(a != (b >= c)) || (d && e)' '(a != b >= c) || (d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= c)) || (d && e)'\'' '\''(a != b >= c) || (d && e)'\'''

echo '$ diff-expr '\''(a != (b >= c)) || (d && e)'\'' '\''(a != b >= c) || d && e'\'''
diff-expr '(a != (b >= c)) || (d && e)' '(a != b >= c) || d && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= c)) || (d && e)'\'' '\''(a != b >= c) || d && e'\'''

echo '$ diff-expr '\''(a != (b >= c)) || (d && e)'\'' '\''(a != (b >= c)) || d && e'\'''
diff-expr '(a != (b >= c)) || (d && e)' '(a != (b >= c)) || d && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b >= c)) || (d && e)'\'' '\''(a != (b >= c)) || d && e'\'''

echo '$ test-expr '\''(a != b) >= (c || (d && e))'\'''
test-expr '(a != b) >= (c || (d && e))' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) >= (c || (d && e))'\'''

echo '$ diff-expr '\''(a != b) >= (c || (d && e))'\'' '\''(a != b) >= (c || d && e)'\'''
diff-expr '(a != b) >= (c || (d && e))' '(a != b) >= (c || d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) >= (c || (d && e))'\'' '\''(a != b) >= (c || d && e)'\'''

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'''
test-expr 'a != (b >= (c || (d && e)))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'''

echo '$ diff-expr '\''a != (b >= (c || (d && e)))'\'' '\''a != b >= (c || (d && e))'\'''
diff-expr 'a != (b >= (c || (d && e)))' 'a != b >= (c || (d && e))' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b >= (c || (d && e)))'\'' '\''a != b >= (c || (d && e))'\'''

echo '$ diff-expr '\''a != (b >= (c || (d && e)))'\'' '\''a != b >= (c || d && e)'\'''
diff-expr 'a != (b >= (c || (d && e)))' 'a != b >= (c || d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b >= (c || (d && e)))'\'' '\''a != b >= (c || d && e)'\'''

echo '$ diff-expr '\''a != (b >= (c || (d && e)))'\'' '\''a != (b >= (c || d && e))'\'''
diff-expr 'a != (b >= (c || (d && e)))' 'a != (b >= (c || d && e))' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b >= (c || (d && e)))'\'' '\''a != (b >= (c || d && e))'\'''

echo '$ test-expr '\''(((a != b) && c) >= d) || e'\'''
test-expr '(((a != b) && c) >= d) || e' 2>&1 ||
echo 'command failed: test-expr '\''(((a != b) && c) >= d) || e'\'''

echo '$ diff-expr '\''(((a != b) && c) >= d) || e'\'' '\''((a != b) && c) >= d || e'\'''
diff-expr '(((a != b) && c) >= d) || e' '((a != b) && c) >= d || e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a != b) && c) >= d) || e'\'' '\''((a != b) && c) >= d || e'\'''

echo '$ diff-expr '\''(((a != b) && c) >= d) || e'\'' '\''(a != b && c) >= d || e'\'''
diff-expr '(((a != b) && c) >= d) || e' '(a != b && c) >= d || e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a != b) && c) >= d) || e'\'' '\''(a != b && c) >= d || e'\'''

echo '$ diff-expr '\''(((a != b) && c) >= d) || e'\'' '\''((a != b && c) >= d) || e'\'''
diff-expr '(((a != b) && c) >= d) || e' '((a != b && c) >= d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a != b) && c) >= d) || e'\'' '\''((a != b && c) >= d) || e'\'''

echo '$ test-expr '\''a != (((b && c) >= d) || e)'\'''
test-expr 'a != (((b && c) >= d) || e)' 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) >= d) || e)'\'''

echo '$ diff-expr '\''a != (((b && c) >= d) || e)'\'' '\''a != ((b && c) >= d || e)'\'''
diff-expr 'a != (((b && c) >= d) || e)' 'a != ((b && c) >= d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (((b && c) >= d) || e)'\'' '\''a != ((b && c) >= d || e)'\'''

echo '$ test-expr '\''(a != ((b && c) >= d)) || e'\'''
test-expr '(a != ((b && c) >= d)) || e' 2>&1 ||
echo 'command failed: test-expr '\''(a != ((b && c) >= d)) || e'\'''

echo '$ diff-expr '\''(a != ((b && c) >= d)) || e'\'' '\''a != ((b && c) >= d) || e'\'''
diff-expr '(a != ((b && c) >= d)) || e' 'a != ((b && c) >= d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != ((b && c) >= d)) || e'\'' '\''a != ((b && c) >= d) || e'\'''

echo '$ diff-expr '\''(a != ((b && c) >= d)) || e'\'' '\''a != (b && c) >= d || e'\'''
diff-expr '(a != ((b && c) >= d)) || e' 'a != (b && c) >= d || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != ((b && c) >= d)) || e'\'' '\''a != (b && c) >= d || e'\'''

echo '$ diff-expr '\''(a != ((b && c) >= d)) || e'\'' '\''(a != (b && c) >= d) || e'\'''
diff-expr '(a != ((b && c) >= d)) || e' '(a != (b && c) >= d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != ((b && c) >= d)) || e'\'' '\''(a != (b && c) >= d) || e'\'''

echo '$ test-expr '\''(a != b) && ((c >= d) || e)'\'''
test-expr '(a != b) && ((c >= d) || e)' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) && ((c >= d) || e)'\'''

echo '$ diff-expr '\''(a != b) && ((c >= d) || e)'\'' '\''a != b && ((c >= d) || e)'\'''
diff-expr '(a != b) && ((c >= d) || e)' 'a != b && ((c >= d) || e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) && ((c >= d) || e)'\'' '\''a != b && ((c >= d) || e)'\'''

echo '$ diff-expr '\''(a != b) && ((c >= d) || e)'\'' '\''a != b && (c >= d || e)'\'''
diff-expr '(a != b) && ((c >= d) || e)' 'a != b && (c >= d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) && ((c >= d) || e)'\'' '\''a != b && (c >= d || e)'\'''

echo '$ diff-expr '\''(a != b) && ((c >= d) || e)'\'' '\''(a != b) && (c >= d || e)'\'''
diff-expr '(a != b) && ((c >= d) || e)' '(a != b) && (c >= d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) && ((c >= d) || e)'\'' '\''(a != b) && (c >= d || e)'\'''

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'''
test-expr 'a != (b && ((c >= d) || e))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'''

echo '$ diff-expr '\''a != (b && ((c >= d) || e))'\'' '\''a != (b && (c >= d || e))'\'''
diff-expr 'a != (b && ((c >= d) || e))' 'a != (b && (c >= d || e))' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b && ((c >= d) || e))'\'' '\''a != (b && (c >= d || e))'\'''

echo '$ test-expr '\''((a != (b && c)) >= d) || e'\'''
test-expr '((a != (b && c)) >= d) || e' 2>&1 ||
echo 'command failed: test-expr '\''((a != (b && c)) >= d) || e'\'''

echo '$ diff-expr '\''((a != (b && c)) >= d) || e'\'' '\''(a != (b && c)) >= d || e'\'''
diff-expr '((a != (b && c)) >= d) || e' '(a != (b && c)) >= d || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != (b && c)) >= d) || e'\'' '\''(a != (b && c)) >= d || e'\'''

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'''
test-expr 'a != ((b && (c >= d)) || e)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'''

echo '$ diff-expr '\''a != ((b && (c >= d)) || e)'\'' '\''a != (b && (c >= d) || e)'\'''
diff-expr 'a != ((b && (c >= d)) || e)' 'a != (b && (c >= d) || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b && (c >= d)) || e)'\'' '\''a != (b && (c >= d) || e)'\'''

echo '$ diff-expr '\''a != ((b && (c >= d)) || e)'\'' '\''a != (b && c >= d || e)'\'''
diff-expr 'a != ((b && (c >= d)) || e)' 'a != (b && c >= d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b && (c >= d)) || e)'\'' '\''a != (b && c >= d || e)'\'''

echo '$ diff-expr '\''a != ((b && (c >= d)) || e)'\'' '\''a != ((b && c >= d) || e)'\'''
diff-expr 'a != ((b && (c >= d)) || e)' 'a != ((b && c >= d) || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b && (c >= d)) || e)'\'' '\''a != ((b && c >= d) || e)'\'''

echo '$ test-expr '\''((a != b) && (c >= d)) || e'\'''
test-expr '((a != b) && (c >= d)) || e' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) && (c >= d)) || e'\'''

echo '$ diff-expr '\''((a != b) && (c >= d)) || e'\'' '\''(a != b) && (c >= d) || e'\'''
diff-expr '((a != b) && (c >= d)) || e' '(a != b) && (c >= d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && (c >= d)) || e'\'' '\''(a != b) && (c >= d) || e'\'''

echo '$ diff-expr '\''((a != b) && (c >= d)) || e'\'' '\''a != b && (c >= d) || e'\'''
diff-expr '((a != b) && (c >= d)) || e' 'a != b && (c >= d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && (c >= d)) || e'\'' '\''a != b && (c >= d) || e'\'''

echo '$ diff-expr '\''((a != b) && (c >= d)) || e'\'' '\''a != b && c >= d || e'\'''
diff-expr '((a != b) && (c >= d)) || e' 'a != b && c >= d || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && (c >= d)) || e'\'' '\''a != b && c >= d || e'\'''

echo '$ diff-expr '\''((a != b) && (c >= d)) || e'\'' '\''(a != b) && c >= d || e'\'''
diff-expr '((a != b) && (c >= d)) || e' '(a != b) && c >= d || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && (c >= d)) || e'\'' '\''(a != b) && c >= d || e'\'''

echo '$ diff-expr '\''((a != b) && (c >= d)) || e'\'' '\''(a != b && (c >= d)) || e'\'''
diff-expr '((a != b) && (c >= d)) || e' '(a != b && (c >= d)) || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && (c >= d)) || e'\'' '\''(a != b && (c >= d)) || e'\'''

echo '$ diff-expr '\''((a != b) && (c >= d)) || e'\'' '\''(a != b && c >= d) || e'\'''
diff-expr '((a != b) && (c >= d)) || e' '(a != b && c >= d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && (c >= d)) || e'\'' '\''(a != b && c >= d) || e'\'''

echo '$ diff-expr '\''((a != b) && (c >= d)) || e'\'' '\''((a != b) && c >= d) || e'\'''
diff-expr '((a != b) && (c >= d)) || e' '((a != b) && c >= d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && (c >= d)) || e'\'' '\''((a != b) && c >= d) || e'\'''

echo '$ test-expr '\''((a != b) && c) >= (d || e)'\'''
test-expr '((a != b) && c) >= (d || e)' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) && c) >= (d || e)'\'''

echo '$ diff-expr '\''((a != b) && c) >= (d || e)'\'' '\''(a != b && c) >= (d || e)'\'''
diff-expr '((a != b) && c) >= (d || e)' '(a != b && c) >= (d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && c) >= (d || e)'\'' '\''(a != b && c) >= (d || e)'\'''

echo '$ test-expr '\''a != ((b && c) >= (d || e))'\'''
test-expr 'a != ((b && c) >= (d || e))' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) >= (d || e))'\'''

echo '$ diff-expr '\''a != ((b && c) >= (d || e))'\'' '\''a != (b && c) >= (d || e)'\'''
diff-expr 'a != ((b && c) >= (d || e))' 'a != (b && c) >= (d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b && c) >= (d || e))'\'' '\''a != (b && c) >= (d || e)'\'''

echo '$ test-expr '\''(a != (b && (c >= d))) || e'\'''
test-expr '(a != (b && (c >= d))) || e' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b && (c >= d))) || e'\'''

echo '$ diff-expr '\''(a != (b && (c >= d))) || e'\'' '\''a != (b && (c >= d)) || e'\'''
diff-expr '(a != (b && (c >= d))) || e' 'a != (b && (c >= d)) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b && (c >= d))) || e'\'' '\''a != (b && (c >= d)) || e'\'''

echo '$ diff-expr '\''(a != (b && (c >= d))) || e'\'' '\''a != (b && c >= d) || e'\'''
diff-expr '(a != (b && (c >= d))) || e' 'a != (b && c >= d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b && (c >= d))) || e'\'' '\''a != (b && c >= d) || e'\'''

echo '$ diff-expr '\''(a != (b && (c >= d))) || e'\'' '\''(a != (b && c >= d)) || e'\'''
diff-expr '(a != (b && (c >= d))) || e' '(a != (b && c >= d)) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b && (c >= d))) || e'\'' '\''(a != (b && c >= d)) || e'\'''

echo '$ test-expr '\''(a != (b && c)) >= (d || e)'\'''
test-expr '(a != (b && c)) >= (d || e)' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b && c)) >= (d || e)'\'''

echo '$ test-expr '\''(a != b) && (c >= (d || e))'\'''
test-expr '(a != b) && (c >= (d || e))' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) && (c >= (d || e))'\'''

echo '$ diff-expr '\''(a != b) && (c >= (d || e))'\'' '\''a != b && (c >= (d || e))'\'''
diff-expr '(a != b) && (c >= (d || e))' 'a != b && (c >= (d || e))' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) && (c >= (d || e))'\'' '\''a != b && (c >= (d || e))'\'''

echo '$ diff-expr '\''(a != b) && (c >= (d || e))'\'' '\''a != b && c >= (d || e)'\'''
diff-expr '(a != b) && (c >= (d || e))' 'a != b && c >= (d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) && (c >= (d || e))'\'' '\''a != b && c >= (d || e)'\'''

echo '$ diff-expr '\''(a != b) && (c >= (d || e))'\'' '\''(a != b) && c >= (d || e)'\'''
diff-expr '(a != b) && (c >= (d || e))' '(a != b) && c >= (d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) && (c >= (d || e))'\'' '\''(a != b) && c >= (d || e)'\'''

echo '$ test-expr '\''a != (b && (c >= (d || e)))'\'''
test-expr 'a != (b && (c >= (d || e)))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c >= (d || e)))'\'''

echo '$ diff-expr '\''a != (b && (c >= (d || e)))'\'' '\''a != (b && c >= (d || e))'\'''
diff-expr 'a != (b && (c >= (d || e)))' 'a != (b && c >= (d || e))' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b && (c >= (d || e)))'\'' '\''a != (b && c >= (d || e))'\'''

echo '$ test-expr '\''(((a != b) && c) || d) >= e'\'''
test-expr '(((a != b) && c) || d) >= e' 2>&1 ||
echo 'command failed: test-expr '\''(((a != b) && c) || d) >= e'\'''

echo '$ diff-expr '\''(((a != b) && c) || d) >= e'\'' '\''((a != b) && c || d) >= e'\'''
diff-expr '(((a != b) && c) || d) >= e' '((a != b) && c || d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a != b) && c) || d) >= e'\'' '\''((a != b) && c || d) >= e'\'''

echo '$ diff-expr '\''(((a != b) && c) || d) >= e'\'' '\''(a != b && c || d) >= e'\'''
diff-expr '(((a != b) && c) || d) >= e' '(a != b && c || d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a != b) && c) || d) >= e'\'' '\''(a != b && c || d) >= e'\'''

echo '$ diff-expr '\''(((a != b) && c) || d) >= e'\'' '\''((a != b && c) || d) >= e'\'''
diff-expr '(((a != b) && c) || d) >= e' '((a != b && c) || d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a != b) && c) || d) >= e'\'' '\''((a != b && c) || d) >= e'\'''

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'''
test-expr 'a != (((b && c) || d) >= e)' 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'''

echo '$ diff-expr '\''a != (((b && c) || d) >= e)'\'' '\''a != ((b && c) || d) >= e'\'''
diff-expr 'a != (((b && c) || d) >= e)' 'a != ((b && c) || d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''a != (((b && c) || d) >= e)'\'' '\''a != ((b && c) || d) >= e'\'''

echo '$ diff-expr '\''a != (((b && c) || d) >= e)'\'' '\''a != (b && c || d) >= e'\'''
diff-expr 'a != (((b && c) || d) >= e)' 'a != (b && c || d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''a != (((b && c) || d) >= e)'\'' '\''a != (b && c || d) >= e'\'''

echo '$ diff-expr '\''a != (((b && c) || d) >= e)'\'' '\''a != ((b && c || d) >= e)'\'''
diff-expr 'a != (((b && c) || d) >= e)' 'a != ((b && c || d) >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (((b && c) || d) >= e)'\'' '\''a != ((b && c || d) >= e)'\'''

echo '$ test-expr '\''(a != ((b && c) || d)) >= e'\'''
test-expr '(a != ((b && c) || d)) >= e' 2>&1 ||
echo 'command failed: test-expr '\''(a != ((b && c) || d)) >= e'\'''

echo '$ diff-expr '\''(a != ((b && c) || d)) >= e'\'' '\''(a != (b && c || d)) >= e'\'''
diff-expr '(a != ((b && c) || d)) >= e' '(a != (b && c || d)) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != ((b && c) || d)) >= e'\'' '\''(a != (b && c || d)) >= e'\'''

echo '$ test-expr '\''(a != b) && ((c || d) >= e)'\'''
test-expr '(a != b) && ((c || d) >= e)' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) && ((c || d) >= e)'\'''

echo '$ diff-expr '\''(a != b) && ((c || d) >= e)'\'' '\''a != b && ((c || d) >= e)'\'''
diff-expr '(a != b) && ((c || d) >= e)' 'a != b && ((c || d) >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) && ((c || d) >= e)'\'' '\''a != b && ((c || d) >= e)'\'''

echo '$ diff-expr '\''(a != b) && ((c || d) >= e)'\'' '\''a != b && (c || d) >= e'\'''
diff-expr '(a != b) && ((c || d) >= e)' 'a != b && (c || d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) && ((c || d) >= e)'\'' '\''a != b && (c || d) >= e'\'''

echo '$ diff-expr '\''(a != b) && ((c || d) >= e)'\'' '\''(a != b) && (c || d) >= e'\'''
diff-expr '(a != b) && ((c || d) >= e)' '(a != b) && (c || d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) && ((c || d) >= e)'\'' '\''(a != b) && (c || d) >= e'\'''

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'''
test-expr 'a != (b && ((c || d) >= e))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'''

echo '$ diff-expr '\''a != (b && ((c || d) >= e))'\'' '\''a != (b && (c || d) >= e)'\'''
diff-expr 'a != (b && ((c || d) >= e))' 'a != (b && (c || d) >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b && ((c || d) >= e))'\'' '\''a != (b && (c || d) >= e)'\'''

echo '$ test-expr '\''((a != (b && c)) || d) >= e'\'''
test-expr '((a != (b && c)) || d) >= e' 2>&1 ||
echo 'command failed: test-expr '\''((a != (b && c)) || d) >= e'\'''

echo '$ diff-expr '\''((a != (b && c)) || d) >= e'\'' '\''(a != (b && c) || d) >= e'\'''
diff-expr '((a != (b && c)) || d) >= e' '(a != (b && c) || d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != (b && c)) || d) >= e'\'' '\''(a != (b && c) || d) >= e'\'''

echo '$ test-expr '\''a != ((b && (c || d)) >= e)'\'''
test-expr 'a != ((b && (c || d)) >= e)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c || d)) >= e)'\'''

echo '$ diff-expr '\''a != ((b && (c || d)) >= e)'\'' '\''a != (b && (c || d)) >= e'\'''
diff-expr 'a != ((b && (c || d)) >= e)' 'a != (b && (c || d)) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b && (c || d)) >= e)'\'' '\''a != (b && (c || d)) >= e'\'''

echo '$ test-expr '\''((a != b) && (c || d)) >= e'\'''
test-expr '((a != b) && (c || d)) >= e' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) && (c || d)) >= e'\'''

echo '$ diff-expr '\''((a != b) && (c || d)) >= e'\'' '\''(a != b && (c || d)) >= e'\'''
diff-expr '((a != b) && (c || d)) >= e' '(a != b && (c || d)) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && (c || d)) >= e'\'' '\''(a != b && (c || d)) >= e'\'''

echo '$ test-expr '\''((a != b) && c) || (d >= e)'\'''
test-expr '((a != b) && c) || (d >= e)' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) && c) || (d >= e)'\'''

echo '$ diff-expr '\''((a != b) && c) || (d >= e)'\'' '\''(a != b) && c || (d >= e)'\'''
diff-expr '((a != b) && c) || (d >= e)' '(a != b) && c || (d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && c) || (d >= e)'\'' '\''(a != b) && c || (d >= e)'\'''

echo '$ diff-expr '\''((a != b) && c) || (d >= e)'\'' '\''a != b && c || (d >= e)'\'''
diff-expr '((a != b) && c) || (d >= e)' 'a != b && c || (d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && c) || (d >= e)'\'' '\''a != b && c || (d >= e)'\'''

echo '$ diff-expr '\''((a != b) && c) || (d >= e)'\'' '\''a != b && c || d >= e'\'''
diff-expr '((a != b) && c) || (d >= e)' 'a != b && c || d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && c) || (d >= e)'\'' '\''a != b && c || d >= e'\'''

echo '$ diff-expr '\''((a != b) && c) || (d >= e)'\'' '\''(a != b) && c || d >= e'\'''
diff-expr '((a != b) && c) || (d >= e)' '(a != b) && c || d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && c) || (d >= e)'\'' '\''(a != b) && c || d >= e'\'''

echo '$ diff-expr '\''((a != b) && c) || (d >= e)'\'' '\''(a != b && c) || (d >= e)'\'''
diff-expr '((a != b) && c) || (d >= e)' '(a != b && c) || (d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && c) || (d >= e)'\'' '\''(a != b && c) || (d >= e)'\'''

echo '$ diff-expr '\''((a != b) && c) || (d >= e)'\'' '\''(a != b && c) || d >= e'\'''
diff-expr '((a != b) && c) || (d >= e)' '(a != b && c) || d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && c) || (d >= e)'\'' '\''(a != b && c) || d >= e'\'''

echo '$ diff-expr '\''((a != b) && c) || (d >= e)'\'' '\''((a != b) && c) || d >= e'\'''
diff-expr '((a != b) && c) || (d >= e)' '((a != b) && c) || d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) && c) || (d >= e)'\'' '\''((a != b) && c) || d >= e'\'''

echo '$ test-expr '\''a != ((b && c) || (d >= e))'\'''
test-expr 'a != ((b && c) || (d >= e))' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) || (d >= e))'\'''

echo '$ diff-expr '\''a != ((b && c) || (d >= e))'\'' '\''a != (b && c || (d >= e))'\'''
diff-expr 'a != ((b && c) || (d >= e))' 'a != (b && c || (d >= e))' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b && c) || (d >= e))'\'' '\''a != (b && c || (d >= e))'\'''

echo '$ diff-expr '\''a != ((b && c) || (d >= e))'\'' '\''a != (b && c || d >= e)'\'''
diff-expr 'a != ((b && c) || (d >= e))' 'a != (b && c || d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b && c) || (d >= e))'\'' '\''a != (b && c || d >= e)'\'''

echo '$ diff-expr '\''a != ((b && c) || (d >= e))'\'' '\''a != ((b && c) || d >= e)'\'''
diff-expr 'a != ((b && c) || (d >= e))' 'a != ((b && c) || d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b && c) || (d >= e))'\'' '\''a != ((b && c) || d >= e)'\'''

echo '$ test-expr '\''(a != (b && (c || d))) >= e'\'''
test-expr '(a != (b && (c || d))) >= e' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b && (c || d))) >= e'\'''

echo '$ test-expr '\''(a != (b && c)) || (d >= e)'\'''
test-expr '(a != (b && c)) || (d >= e)' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b && c)) || (d >= e)'\'''

echo '$ diff-expr '\''(a != (b && c)) || (d >= e)'\'' '\''a != (b && c) || (d >= e)'\'''
diff-expr '(a != (b && c)) || (d >= e)' 'a != (b && c) || (d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b && c)) || (d >= e)'\'' '\''a != (b && c) || (d >= e)'\'''

echo '$ diff-expr '\''(a != (b && c)) || (d >= e)'\'' '\''a != (b && c) || d >= e'\'''
diff-expr '(a != (b && c)) || (d >= e)' 'a != (b && c) || d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b && c)) || (d >= e)'\'' '\''a != (b && c) || d >= e'\'''

echo '$ diff-expr '\''(a != (b && c)) || (d >= e)'\'' '\''(a != (b && c)) || d >= e'\'''
diff-expr '(a != (b && c)) || (d >= e)' '(a != (b && c)) || d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b && c)) || (d >= e)'\'' '\''(a != (b && c)) || d >= e'\'''

echo '$ test-expr '\''(a != b) && (c || (d >= e))'\'''
test-expr '(a != b) && (c || (d >= e))' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) && (c || (d >= e))'\'''

echo '$ diff-expr '\''(a != b) && (c || (d >= e))'\'' '\''a != b && (c || (d >= e))'\'''
diff-expr '(a != b) && (c || (d >= e))' 'a != b && (c || (d >= e))' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) && (c || (d >= e))'\'' '\''a != b && (c || (d >= e))'\'''

echo '$ diff-expr '\''(a != b) && (c || (d >= e))'\'' '\''a != b && (c || d >= e)'\'''
diff-expr '(a != b) && (c || (d >= e))' 'a != b && (c || d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) && (c || (d >= e))'\'' '\''a != b && (c || d >= e)'\'''

echo '$ diff-expr '\''(a != b) && (c || (d >= e))'\'' '\''(a != b) && (c || d >= e)'\'''
diff-expr '(a != b) && (c || (d >= e))' '(a != b) && (c || d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) && (c || (d >= e))'\'' '\''(a != b) && (c || d >= e)'\'''

echo '$ test-expr '\''a != (b && (c || (d >= e)))'\'''
test-expr 'a != (b && (c || (d >= e)))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c || (d >= e)))'\'''

echo '$ diff-expr '\''a != (b && (c || (d >= e)))'\'' '\''a != (b && (c || d >= e))'\'''
diff-expr 'a != (b && (c || (d >= e)))' 'a != (b && (c || d >= e))' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b && (c || (d >= e)))'\'' '\''a != (b && (c || d >= e))'\'''

echo '$ test-expr '\''(((a != b) || c) >= d) && e'\'''
test-expr '(((a != b) || c) >= d) && e' 2>&1 ||
echo 'command failed: test-expr '\''(((a != b) || c) >= d) && e'\'''

echo '$ diff-expr '\''(((a != b) || c) >= d) && e'\'' '\''((a != b) || c) >= d && e'\'''
diff-expr '(((a != b) || c) >= d) && e' '((a != b) || c) >= d && e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a != b) || c) >= d) && e'\'' '\''((a != b) || c) >= d && e'\'''

echo '$ diff-expr '\''(((a != b) || c) >= d) && e'\'' '\''(a != b || c) >= d && e'\'''
diff-expr '(((a != b) || c) >= d) && e' '(a != b || c) >= d && e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a != b) || c) >= d) && e'\'' '\''(a != b || c) >= d && e'\'''

echo '$ diff-expr '\''(((a != b) || c) >= d) && e'\'' '\''((a != b || c) >= d) && e'\'''
diff-expr '(((a != b) || c) >= d) && e' '((a != b || c) >= d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a != b) || c) >= d) && e'\'' '\''((a != b || c) >= d) && e'\'''

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'''
test-expr 'a != (((b || c) >= d) && e)' 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'''

echo '$ diff-expr '\''a != (((b || c) >= d) && e)'\'' '\''a != ((b || c) >= d && e)'\'''
diff-expr 'a != (((b || c) >= d) && e)' 'a != ((b || c) >= d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (((b || c) >= d) && e)'\'' '\''a != ((b || c) >= d && e)'\'''

echo '$ test-expr '\''(a != ((b || c) >= d)) && e'\'''
test-expr '(a != ((b || c) >= d)) && e' 2>&1 ||
echo 'command failed: test-expr '\''(a != ((b || c) >= d)) && e'\'''

echo '$ diff-expr '\''(a != ((b || c) >= d)) && e'\'' '\''a != ((b || c) >= d) && e'\'''
diff-expr '(a != ((b || c) >= d)) && e' 'a != ((b || c) >= d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != ((b || c) >= d)) && e'\'' '\''a != ((b || c) >= d) && e'\'''

echo '$ diff-expr '\''(a != ((b || c) >= d)) && e'\'' '\''a != (b || c) >= d && e'\'''
diff-expr '(a != ((b || c) >= d)) && e' 'a != (b || c) >= d && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != ((b || c) >= d)) && e'\'' '\''a != (b || c) >= d && e'\'''

echo '$ diff-expr '\''(a != ((b || c) >= d)) && e'\'' '\''(a != (b || c) >= d) && e'\'''
diff-expr '(a != ((b || c) >= d)) && e' '(a != (b || c) >= d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != ((b || c) >= d)) && e'\'' '\''(a != (b || c) >= d) && e'\'''

echo '$ test-expr '\''(a != b) || ((c >= d) && e)'\'''
test-expr '(a != b) || ((c >= d) && e)' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) || ((c >= d) && e)'\'''

echo '$ diff-expr '\''(a != b) || ((c >= d) && e)'\'' '\''a != b || ((c >= d) && e)'\'''
diff-expr '(a != b) || ((c >= d) && e)' 'a != b || ((c >= d) && e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || ((c >= d) && e)'\'' '\''a != b || ((c >= d) && e)'\'''

echo '$ diff-expr '\''(a != b) || ((c >= d) && e)'\'' '\''a != b || (c >= d) && e'\'''
diff-expr '(a != b) || ((c >= d) && e)' 'a != b || (c >= d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || ((c >= d) && e)'\'' '\''a != b || (c >= d) && e'\'''

echo '$ diff-expr '\''(a != b) || ((c >= d) && e)'\'' '\''a != b || c >= d && e'\'''
diff-expr '(a != b) || ((c >= d) && e)' 'a != b || c >= d && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || ((c >= d) && e)'\'' '\''a != b || c >= d && e'\'''

echo '$ diff-expr '\''(a != b) || ((c >= d) && e)'\'' '\''a != b || (c >= d && e)'\'''
diff-expr '(a != b) || ((c >= d) && e)' 'a != b || (c >= d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || ((c >= d) && e)'\'' '\''a != b || (c >= d && e)'\'''

echo '$ diff-expr '\''(a != b) || ((c >= d) && e)'\'' '\''(a != b) || (c >= d) && e'\'''
diff-expr '(a != b) || ((c >= d) && e)' '(a != b) || (c >= d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || ((c >= d) && e)'\'' '\''(a != b) || (c >= d) && e'\'''

echo '$ diff-expr '\''(a != b) || ((c >= d) && e)'\'' '\''(a != b) || c >= d && e'\'''
diff-expr '(a != b) || ((c >= d) && e)' '(a != b) || c >= d && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || ((c >= d) && e)'\'' '\''(a != b) || c >= d && e'\'''

echo '$ diff-expr '\''(a != b) || ((c >= d) && e)'\'' '\''(a != b) || (c >= d && e)'\'''
diff-expr '(a != b) || ((c >= d) && e)' '(a != b) || (c >= d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || ((c >= d) && e)'\'' '\''(a != b) || (c >= d && e)'\'''

echo '$ test-expr '\''a != (b || ((c >= d) && e))'\'''
test-expr 'a != (b || ((c >= d) && e))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c >= d) && e))'\'''

echo '$ diff-expr '\''a != (b || ((c >= d) && e))'\'' '\''a != (b || (c >= d) && e)'\'''
diff-expr 'a != (b || ((c >= d) && e))' 'a != (b || (c >= d) && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b || ((c >= d) && e))'\'' '\''a != (b || (c >= d) && e)'\'''

echo '$ diff-expr '\''a != (b || ((c >= d) && e))'\'' '\''a != (b || c >= d && e)'\'''
diff-expr 'a != (b || ((c >= d) && e))' 'a != (b || c >= d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b || ((c >= d) && e))'\'' '\''a != (b || c >= d && e)'\'''

echo '$ diff-expr '\''a != (b || ((c >= d) && e))'\'' '\''a != (b || (c >= d && e))'\'''
diff-expr 'a != (b || ((c >= d) && e))' 'a != (b || (c >= d && e))' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b || ((c >= d) && e))'\'' '\''a != (b || (c >= d && e))'\'''

echo '$ test-expr '\''((a != (b || c)) >= d) && e'\'''
test-expr '((a != (b || c)) >= d) && e' 2>&1 ||
echo 'command failed: test-expr '\''((a != (b || c)) >= d) && e'\'''

echo '$ diff-expr '\''((a != (b || c)) >= d) && e'\'' '\''(a != (b || c)) >= d && e'\'''
diff-expr '((a != (b || c)) >= d) && e' '(a != (b || c)) >= d && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != (b || c)) >= d) && e'\'' '\''(a != (b || c)) >= d && e'\'''

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'''
test-expr 'a != ((b || (c >= d)) && e)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'''

echo '$ diff-expr '\''a != ((b || (c >= d)) && e)'\'' '\''a != ((b || c >= d) && e)'\'''
diff-expr 'a != ((b || (c >= d)) && e)' 'a != ((b || c >= d) && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b || (c >= d)) && e)'\'' '\''a != ((b || c >= d) && e)'\'''

echo '$ test-expr '\''((a != b) || (c >= d)) && e'\'''
test-expr '((a != b) || (c >= d)) && e' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) || (c >= d)) && e'\'''

echo '$ diff-expr '\''((a != b) || (c >= d)) && e'\'' '\''(a != b || (c >= d)) && e'\'''
diff-expr '((a != b) || (c >= d)) && e' '(a != b || (c >= d)) && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) || (c >= d)) && e'\'' '\''(a != b || (c >= d)) && e'\'''

echo '$ diff-expr '\''((a != b) || (c >= d)) && e'\'' '\''(a != b || c >= d) && e'\'''
diff-expr '((a != b) || (c >= d)) && e' '(a != b || c >= d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) || (c >= d)) && e'\'' '\''(a != b || c >= d) && e'\'''

echo '$ diff-expr '\''((a != b) || (c >= d)) && e'\'' '\''((a != b) || c >= d) && e'\'''
diff-expr '((a != b) || (c >= d)) && e' '((a != b) || c >= d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) || (c >= d)) && e'\'' '\''((a != b) || c >= d) && e'\'''

echo '$ test-expr '\''((a != b) || c) >= (d && e)'\'''
test-expr '((a != b) || c) >= (d && e)' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) || c) >= (d && e)'\'''

echo '$ diff-expr '\''((a != b) || c) >= (d && e)'\'' '\''(a != b || c) >= (d && e)'\'''
diff-expr '((a != b) || c) >= (d && e)' '(a != b || c) >= (d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) || c) >= (d && e)'\'' '\''(a != b || c) >= (d && e)'\'''

echo '$ test-expr '\''a != ((b || c) >= (d && e))'\'''
test-expr 'a != ((b || c) >= (d && e))' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= (d && e))'\'''

echo '$ diff-expr '\''a != ((b || c) >= (d && e))'\'' '\''a != (b || c) >= (d && e)'\'''
diff-expr 'a != ((b || c) >= (d && e))' 'a != (b || c) >= (d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b || c) >= (d && e))'\'' '\''a != (b || c) >= (d && e)'\'''

echo '$ test-expr '\''(a != (b || (c >= d))) && e'\'''
test-expr '(a != (b || (c >= d))) && e' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b || (c >= d))) && e'\'''

echo '$ diff-expr '\''(a != (b || (c >= d))) && e'\'' '\''a != (b || (c >= d)) && e'\'''
diff-expr '(a != (b || (c >= d))) && e' 'a != (b || (c >= d)) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b || (c >= d))) && e'\'' '\''a != (b || (c >= d)) && e'\'''

echo '$ diff-expr '\''(a != (b || (c >= d))) && e'\'' '\''a != (b || c >= d) && e'\'''
diff-expr '(a != (b || (c >= d))) && e' 'a != (b || c >= d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b || (c >= d))) && e'\'' '\''a != (b || c >= d) && e'\'''

echo '$ diff-expr '\''(a != (b || (c >= d))) && e'\'' '\''(a != (b || c >= d)) && e'\'''
diff-expr '(a != (b || (c >= d))) && e' '(a != (b || c >= d)) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b || (c >= d))) && e'\'' '\''(a != (b || c >= d)) && e'\'''

echo '$ test-expr '\''(a != (b || c)) >= (d && e)'\'''
test-expr '(a != (b || c)) >= (d && e)' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b || c)) >= (d && e)'\'''

echo '$ test-expr '\''(a != b) || (c >= (d && e))'\'''
test-expr '(a != b) || (c >= (d && e))' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) || (c >= (d && e))'\'''

echo '$ diff-expr '\''(a != b) || (c >= (d && e))'\'' '\''a != b || (c >= (d && e))'\'''
diff-expr '(a != b) || (c >= (d && e))' 'a != b || (c >= (d && e))' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (c >= (d && e))'\'' '\''a != b || (c >= (d && e))'\'''

echo '$ diff-expr '\''(a != b) || (c >= (d && e))'\'' '\''a != b || c >= (d && e)'\'''
diff-expr '(a != b) || (c >= (d && e))' 'a != b || c >= (d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (c >= (d && e))'\'' '\''a != b || c >= (d && e)'\'''

echo '$ diff-expr '\''(a != b) || (c >= (d && e))'\'' '\''(a != b) || c >= (d && e)'\'''
diff-expr '(a != b) || (c >= (d && e))' '(a != b) || c >= (d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (c >= (d && e))'\'' '\''(a != b) || c >= (d && e)'\'''

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'''
test-expr 'a != (b || (c >= (d && e)))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'''

echo '$ diff-expr '\''a != (b || (c >= (d && e)))'\'' '\''a != (b || c >= (d && e))'\'''
diff-expr 'a != (b || (c >= (d && e)))' 'a != (b || c >= (d && e))' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b || (c >= (d && e)))'\'' '\''a != (b || c >= (d && e))'\'''

echo '$ test-expr '\''(((a != b) || c) && d) >= e'\'''
test-expr '(((a != b) || c) && d) >= e' 2>&1 ||
echo 'command failed: test-expr '\''(((a != b) || c) && d) >= e'\'''

echo '$ diff-expr '\''(((a != b) || c) && d) >= e'\'' '\''((a != b || c) && d) >= e'\'''
diff-expr '(((a != b) || c) && d) >= e' '((a != b || c) && d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a != b) || c) && d) >= e'\'' '\''((a != b || c) && d) >= e'\'''

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'''
test-expr 'a != (((b || c) && d) >= e)' 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'''

echo '$ diff-expr '\''a != (((b || c) && d) >= e)'\'' '\''a != ((b || c) && d) >= e'\'''
diff-expr 'a != (((b || c) && d) >= e)' 'a != ((b || c) && d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''a != (((b || c) && d) >= e)'\'' '\''a != ((b || c) && d) >= e'\'''

echo '$ test-expr '\''(a != ((b || c) && d)) >= e'\'''
test-expr '(a != ((b || c) && d)) >= e' 2>&1 ||
echo 'command failed: test-expr '\''(a != ((b || c) && d)) >= e'\'''

echo '$ test-expr '\''(a != b) || ((c && d) >= e)'\'''
test-expr '(a != b) || ((c && d) >= e)' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) || ((c && d) >= e)'\'''

echo '$ diff-expr '\''(a != b) || ((c && d) >= e)'\'' '\''a != b || ((c && d) >= e)'\'''
diff-expr '(a != b) || ((c && d) >= e)' 'a != b || ((c && d) >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || ((c && d) >= e)'\'' '\''a != b || ((c && d) >= e)'\'''

echo '$ diff-expr '\''(a != b) || ((c && d) >= e)'\'' '\''a != b || (c && d) >= e'\'''
diff-expr '(a != b) || ((c && d) >= e)' 'a != b || (c && d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || ((c && d) >= e)'\'' '\''a != b || (c && d) >= e'\'''

echo '$ diff-expr '\''(a != b) || ((c && d) >= e)'\'' '\''(a != b) || (c && d) >= e'\'''
diff-expr '(a != b) || ((c && d) >= e)' '(a != b) || (c && d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || ((c && d) >= e)'\'' '\''(a != b) || (c && d) >= e'\'''

echo '$ test-expr '\''a != (b || ((c && d) >= e))'\'''
test-expr 'a != (b || ((c && d) >= e))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c && d) >= e))'\'''

echo '$ diff-expr '\''a != (b || ((c && d) >= e))'\'' '\''a != (b || (c && d) >= e)'\'''
diff-expr 'a != (b || ((c && d) >= e))' 'a != (b || (c && d) >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b || ((c && d) >= e))'\'' '\''a != (b || (c && d) >= e)'\'''

echo '$ test-expr '\''((a != (b || c)) && d) >= e'\'''
test-expr '((a != (b || c)) && d) >= e' 2>&1 ||
echo 'command failed: test-expr '\''((a != (b || c)) && d) >= e'\'''

echo '$ diff-expr '\''((a != (b || c)) && d) >= e'\'' '\''(a != (b || c) && d) >= e'\'''
diff-expr '((a != (b || c)) && d) >= e' '(a != (b || c) && d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != (b || c)) && d) >= e'\'' '\''(a != (b || c) && d) >= e'\'''

echo '$ test-expr '\''a != ((b || (c && d)) >= e)'\'''
test-expr 'a != ((b || (c && d)) >= e)' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c && d)) >= e)'\'''

echo '$ diff-expr '\''a != ((b || (c && d)) >= e)'\'' '\''a != (b || (c && d)) >= e'\'''
diff-expr 'a != ((b || (c && d)) >= e)' 'a != (b || (c && d)) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b || (c && d)) >= e)'\'' '\''a != (b || (c && d)) >= e'\'''

echo '$ diff-expr '\''a != ((b || (c && d)) >= e)'\'' '\''a != (b || c && d) >= e'\'''
diff-expr 'a != ((b || (c && d)) >= e)' 'a != (b || c && d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b || (c && d)) >= e)'\'' '\''a != (b || c && d) >= e'\'''

echo '$ diff-expr '\''a != ((b || (c && d)) >= e)'\'' '\''a != ((b || c && d) >= e)'\'''
diff-expr 'a != ((b || (c && d)) >= e)' 'a != ((b || c && d) >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b || (c && d)) >= e)'\'' '\''a != ((b || c && d) >= e)'\'''

echo '$ test-expr '\''((a != b) || (c && d)) >= e'\'''
test-expr '((a != b) || (c && d)) >= e' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) || (c && d)) >= e'\'''

echo '$ diff-expr '\''((a != b) || (c && d)) >= e'\'' '\''(a != b || (c && d)) >= e'\'''
diff-expr '((a != b) || (c && d)) >= e' '(a != b || (c && d)) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) || (c && d)) >= e'\'' '\''(a != b || (c && d)) >= e'\'''

echo '$ diff-expr '\''((a != b) || (c && d)) >= e'\'' '\''(a != b || c && d) >= e'\'''
diff-expr '((a != b) || (c && d)) >= e' '(a != b || c && d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) || (c && d)) >= e'\'' '\''(a != b || c && d) >= e'\'''

echo '$ diff-expr '\''((a != b) || (c && d)) >= e'\'' '\''((a != b) || c && d) >= e'\'''
diff-expr '((a != b) || (c && d)) >= e' '((a != b) || c && d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) || (c && d)) >= e'\'' '\''((a != b) || c && d) >= e'\'''

echo '$ test-expr '\''((a != b) || c) && (d >= e)'\'''
test-expr '((a != b) || c) && (d >= e)' 2>&1 ||
echo 'command failed: test-expr '\''((a != b) || c) && (d >= e)'\'''

echo '$ diff-expr '\''((a != b) || c) && (d >= e)'\'' '\''(a != b || c) && (d >= e)'\'''
diff-expr '((a != b) || c) && (d >= e)' '(a != b || c) && (d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) || c) && (d >= e)'\'' '\''(a != b || c) && (d >= e)'\'''

echo '$ diff-expr '\''((a != b) || c) && (d >= e)'\'' '\''(a != b || c) && d >= e'\'''
diff-expr '((a != b) || c) && (d >= e)' '(a != b || c) && d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) || c) && (d >= e)'\'' '\''(a != b || c) && d >= e'\'''

echo '$ diff-expr '\''((a != b) || c) && (d >= e)'\'' '\''((a != b) || c) && d >= e'\'''
diff-expr '((a != b) || c) && (d >= e)' '((a != b) || c) && d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''((a != b) || c) && (d >= e)'\'' '\''((a != b) || c) && d >= e'\'''

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'''
test-expr 'a != ((b || c) && (d >= e))' 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'''

echo '$ diff-expr '\''a != ((b || c) && (d >= e))'\'' '\''a != ((b || c) && d >= e)'\'''
diff-expr 'a != ((b || c) && (d >= e))' 'a != ((b || c) && d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a != ((b || c) && (d >= e))'\'' '\''a != ((b || c) && d >= e)'\'''

echo '$ test-expr '\''(a != (b || (c && d))) >= e'\'''
test-expr '(a != (b || (c && d))) >= e' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b || (c && d))) >= e'\'''

echo '$ diff-expr '\''(a != (b || (c && d))) >= e'\'' '\''(a != (b || c && d)) >= e'\'''
diff-expr '(a != (b || (c && d))) >= e' '(a != (b || c && d)) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b || (c && d))) >= e'\'' '\''(a != (b || c && d)) >= e'\'''

echo '$ test-expr '\''(a != (b || c)) && (d >= e)'\'''
test-expr '(a != (b || c)) && (d >= e)' 2>&1 ||
echo 'command failed: test-expr '\''(a != (b || c)) && (d >= e)'\'''

echo '$ diff-expr '\''(a != (b || c)) && (d >= e)'\'' '\''a != (b || c) && (d >= e)'\'''
diff-expr '(a != (b || c)) && (d >= e)' 'a != (b || c) && (d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b || c)) && (d >= e)'\'' '\''a != (b || c) && (d >= e)'\'''

echo '$ diff-expr '\''(a != (b || c)) && (d >= e)'\'' '\''a != (b || c) && d >= e'\'''
diff-expr '(a != (b || c)) && (d >= e)' 'a != (b || c) && d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b || c)) && (d >= e)'\'' '\''a != (b || c) && d >= e'\'''

echo '$ diff-expr '\''(a != (b || c)) && (d >= e)'\'' '\''(a != (b || c)) && d >= e'\'''
diff-expr '(a != (b || c)) && (d >= e)' '(a != (b || c)) && d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != (b || c)) && (d >= e)'\'' '\''(a != (b || c)) && d >= e'\'''

echo '$ test-expr '\''(a != b) || (c && (d >= e))'\'''
test-expr '(a != b) || (c && (d >= e))' 2>&1 ||
echo 'command failed: test-expr '\''(a != b) || (c && (d >= e))'\'''

echo '$ diff-expr '\''(a != b) || (c && (d >= e))'\'' '\''a != b || (c && (d >= e))'\'''
diff-expr '(a != b) || (c && (d >= e))' 'a != b || (c && (d >= e))' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (c && (d >= e))'\'' '\''a != b || (c && (d >= e))'\'''

echo '$ diff-expr '\''(a != b) || (c && (d >= e))'\'' '\''a != b || c && (d >= e)'\'''
diff-expr '(a != b) || (c && (d >= e))' 'a != b || c && (d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (c && (d >= e))'\'' '\''a != b || c && (d >= e)'\'''

echo '$ diff-expr '\''(a != b) || (c && (d >= e))'\'' '\''a != b || c && d >= e'\'''
diff-expr '(a != b) || (c && (d >= e))' 'a != b || c && d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (c && (d >= e))'\'' '\''a != b || c && d >= e'\'''

echo '$ diff-expr '\''(a != b) || (c && (d >= e))'\'' '\''a != b || (c && d >= e)'\'''
diff-expr '(a != b) || (c && (d >= e))' 'a != b || (c && d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (c && (d >= e))'\'' '\''a != b || (c && d >= e)'\'''

echo '$ diff-expr '\''(a != b) || (c && (d >= e))'\'' '\''(a != b) || c && (d >= e)'\'''
diff-expr '(a != b) || (c && (d >= e))' '(a != b) || c && (d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (c && (d >= e))'\'' '\''(a != b) || c && (d >= e)'\'''

echo '$ diff-expr '\''(a != b) || (c && (d >= e))'\'' '\''(a != b) || c && d >= e'\'''
diff-expr '(a != b) || (c && (d >= e))' '(a != b) || c && d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (c && (d >= e))'\'' '\''(a != b) || c && d >= e'\'''

echo '$ diff-expr '\''(a != b) || (c && (d >= e))'\'' '\''(a != b) || (c && d >= e)'\'''
diff-expr '(a != b) || (c && (d >= e))' '(a != b) || (c && d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a != b) || (c && (d >= e))'\'' '\''(a != b) || (c && d >= e)'\'''

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'''
test-expr 'a != (b || (c && (d >= e)))' 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'''

echo '$ diff-expr '\''a != (b || (c && (d >= e)))'\'' '\''a != (b || c && (d >= e))'\'''
diff-expr 'a != (b || (c && (d >= e)))' 'a != (b || c && (d >= e))' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b || (c && (d >= e)))'\'' '\''a != (b || c && (d >= e))'\'''

echo '$ diff-expr '\''a != (b || (c && (d >= e)))'\'' '\''a != (b || c && d >= e)'\'''
diff-expr 'a != (b || (c && (d >= e)))' 'a != (b || c && d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b || (c && (d >= e)))'\'' '\''a != (b || c && d >= e)'\'''

echo '$ diff-expr '\''a != (b || (c && (d >= e)))'\'' '\''a != (b || (c && d >= e))'\'''
diff-expr 'a != (b || (c && (d >= e)))' 'a != (b || (c && d >= e))' 2>&1 ||
echo 'command failed: diff-expr '\''a != (b || (c && (d >= e)))'\'' '\''a != (b || (c && d >= e))'\'''

echo '$ test-expr '\''(((a && b) >= c) != d) || e'\'''
test-expr '(((a && b) >= c) != d) || e' 2>&1 ||
echo 'command failed: test-expr '\''(((a && b) >= c) != d) || e'\'''

echo '$ diff-expr '\''(((a && b) >= c) != d) || e'\'' '\''((a && b) >= c) != d || e'\'''
diff-expr '(((a && b) >= c) != d) || e' '((a && b) >= c) != d || e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a && b) >= c) != d) || e'\'' '\''((a && b) >= c) != d || e'\'''

echo '$ diff-expr '\''(((a && b) >= c) != d) || e'\'' '\''(a && b) >= c != d || e'\'''
diff-expr '(((a && b) >= c) != d) || e' '(a && b) >= c != d || e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a && b) >= c) != d) || e'\'' '\''(a && b) >= c != d || e'\'''

echo '$ diff-expr '\''(((a && b) >= c) != d) || e'\'' '\''((a && b) >= c != d) || e'\'''
diff-expr '(((a && b) >= c) != d) || e' '((a && b) >= c != d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a && b) >= c) != d) || e'\'' '\''((a && b) >= c != d) || e'\'''

echo '$ test-expr '\''a && (((b >= c) != d) || e)'\'''
test-expr 'a && (((b >= c) != d) || e)' 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) != d) || e)'\'''

echo '$ diff-expr '\''a && (((b >= c) != d) || e)'\'' '\''a && ((b >= c) != d || e)'\'''
diff-expr 'a && (((b >= c) != d) || e)' 'a && ((b >= c) != d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (((b >= c) != d) || e)'\'' '\''a && ((b >= c) != d || e)'\'''

echo '$ diff-expr '\''a && (((b >= c) != d) || e)'\'' '\''a && (b >= c != d || e)'\'''
diff-expr 'a && (((b >= c) != d) || e)' 'a && (b >= c != d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (((b >= c) != d) || e)'\'' '\''a && (b >= c != d || e)'\'''

echo '$ diff-expr '\''a && (((b >= c) != d) || e)'\'' '\''a && ((b >= c != d) || e)'\'''
diff-expr 'a && (((b >= c) != d) || e)' 'a && ((b >= c != d) || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (((b >= c) != d) || e)'\'' '\''a && ((b >= c != d) || e)'\'''

echo '$ test-expr '\''(a && ((b >= c) != d)) || e'\'''
test-expr '(a && ((b >= c) != d)) || e' 2>&1 ||
echo 'command failed: test-expr '\''(a && ((b >= c) != d)) || e'\'''

echo '$ diff-expr '\''(a && ((b >= c) != d)) || e'\'' '\''a && ((b >= c) != d) || e'\'''
diff-expr '(a && ((b >= c) != d)) || e' 'a && ((b >= c) != d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && ((b >= c) != d)) || e'\'' '\''a && ((b >= c) != d) || e'\'''

echo '$ diff-expr '\''(a && ((b >= c) != d)) || e'\'' '\''a && (b >= c) != d || e'\'''
diff-expr '(a && ((b >= c) != d)) || e' 'a && (b >= c) != d || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && ((b >= c) != d)) || e'\'' '\''a && (b >= c) != d || e'\'''

echo '$ diff-expr '\''(a && ((b >= c) != d)) || e'\'' '\''a && b >= c != d || e'\'''
diff-expr '(a && ((b >= c) != d)) || e' 'a && b >= c != d || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && ((b >= c) != d)) || e'\'' '\''a && b >= c != d || e'\'''

echo '$ diff-expr '\''(a && ((b >= c) != d)) || e'\'' '\''a && (b >= c != d) || e'\'''
diff-expr '(a && ((b >= c) != d)) || e' 'a && (b >= c != d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && ((b >= c) != d)) || e'\'' '\''a && (b >= c != d) || e'\'''

echo '$ diff-expr '\''(a && ((b >= c) != d)) || e'\'' '\''(a && (b >= c) != d) || e'\'''
diff-expr '(a && ((b >= c) != d)) || e' '(a && (b >= c) != d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && ((b >= c) != d)) || e'\'' '\''(a && (b >= c) != d) || e'\'''

echo '$ diff-expr '\''(a && ((b >= c) != d)) || e'\'' '\''(a && b >= c != d) || e'\'''
diff-expr '(a && ((b >= c) != d)) || e' '(a && b >= c != d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && ((b >= c) != d)) || e'\'' '\''(a && b >= c != d) || e'\'''

echo '$ diff-expr '\''(a && ((b >= c) != d)) || e'\'' '\''(a && (b >= c != d)) || e'\'''
diff-expr '(a && ((b >= c) != d)) || e' '(a && (b >= c != d)) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && ((b >= c) != d)) || e'\'' '\''(a && (b >= c != d)) || e'\'''

echo '$ test-expr '\''(a && b) >= ((c != d) || e)'\'''
test-expr '(a && b) >= ((c != d) || e)' 2>&1 ||
echo 'command failed: test-expr '\''(a && b) >= ((c != d) || e)'\'''

echo '$ diff-expr '\''(a && b) >= ((c != d) || e)'\'' '\''(a && b) >= (c != d || e)'\'''
diff-expr '(a && b) >= ((c != d) || e)' '(a && b) >= (c != d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) >= ((c != d) || e)'\'' '\''(a && b) >= (c != d || e)'\'''

echo '$ test-expr '\''a && (b >= ((c != d) || e))'\'''
test-expr 'a && (b >= ((c != d) || e))' 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c != d) || e))'\'''

echo '$ diff-expr '\''a && (b >= ((c != d) || e))'\'' '\''a && b >= ((c != d) || e)'\'''
diff-expr 'a && (b >= ((c != d) || e))' 'a && b >= ((c != d) || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b >= ((c != d) || e))'\'' '\''a && b >= ((c != d) || e)'\'''

echo '$ diff-expr '\''a && (b >= ((c != d) || e))'\'' '\''a && b >= (c != d || e)'\'''
diff-expr 'a && (b >= ((c != d) || e))' 'a && b >= (c != d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b >= ((c != d) || e))'\'' '\''a && b >= (c != d || e)'\'''

echo '$ diff-expr '\''a && (b >= ((c != d) || e))'\'' '\''a && (b >= (c != d || e))'\'''
diff-expr 'a && (b >= ((c != d) || e))' 'a && (b >= (c != d || e))' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b >= ((c != d) || e))'\'' '\''a && (b >= (c != d || e))'\'''

echo '$ test-expr '\''((a && (b >= c)) != d) || e'\'''
test-expr '((a && (b >= c)) != d) || e' 2>&1 ||
echo 'command failed: test-expr '\''((a && (b >= c)) != d) || e'\'''

echo '$ diff-expr '\''((a && (b >= c)) != d) || e'\'' '\''(a && (b >= c)) != d || e'\'''
diff-expr '((a && (b >= c)) != d) || e' '(a && (b >= c)) != d || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a && (b >= c)) != d) || e'\'' '\''(a && (b >= c)) != d || e'\'''

echo '$ diff-expr '\''((a && (b >= c)) != d) || e'\'' '\''(a && b >= c) != d || e'\'''
diff-expr '((a && (b >= c)) != d) || e' '(a && b >= c) != d || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a && (b >= c)) != d) || e'\'' '\''(a && b >= c) != d || e'\'''

echo '$ diff-expr '\''((a && (b >= c)) != d) || e'\'' '\''((a && b >= c) != d) || e'\'''
diff-expr '((a && (b >= c)) != d) || e' '((a && b >= c) != d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a && (b >= c)) != d) || e'\'' '\''((a && b >= c) != d) || e'\'''

echo '$ test-expr '\''a && ((b >= (c != d)) || e)'\'''
test-expr 'a && ((b >= (c != d)) || e)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c != d)) || e)'\'''

echo '$ diff-expr '\''a && ((b >= (c != d)) || e)'\'' '\''a && (b >= (c != d) || e)'\'''
diff-expr 'a && ((b >= (c != d)) || e)' 'a && (b >= (c != d) || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b >= (c != d)) || e)'\'' '\''a && (b >= (c != d) || e)'\'''

echo '$ test-expr '\''((a && b) >= (c != d)) || e'\'''
test-expr '((a && b) >= (c != d)) || e' 2>&1 ||
echo 'command failed: test-expr '\''((a && b) >= (c != d)) || e'\'''

echo '$ diff-expr '\''((a && b) >= (c != d)) || e'\'' '\''(a && b) >= (c != d) || e'\'''
diff-expr '((a && b) >= (c != d)) || e' '(a && b) >= (c != d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) >= (c != d)) || e'\'' '\''(a && b) >= (c != d) || e'\'''

echo '$ test-expr '\''((a && b) >= c) != (d || e)'\'''
test-expr '((a && b) >= c) != (d || e)' 2>&1 ||
echo 'command failed: test-expr '\''((a && b) >= c) != (d || e)'\'''

echo '$ diff-expr '\''((a && b) >= c) != (d || e)'\'' '\''(a && b) >= c != (d || e)'\'''
diff-expr '((a && b) >= c) != (d || e)' '(a && b) >= c != (d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) >= c) != (d || e)'\'' '\''(a && b) >= c != (d || e)'\'''

echo '$ test-expr '\''a && ((b >= c) != (d || e))'\'''
test-expr 'a && ((b >= c) != (d || e))' 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) != (d || e))'\'''

echo '$ diff-expr '\''a && ((b >= c) != (d || e))'\'' '\''a && (b >= c) != (d || e)'\'''
diff-expr 'a && ((b >= c) != (d || e))' 'a && (b >= c) != (d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b >= c) != (d || e))'\'' '\''a && (b >= c) != (d || e)'\'''

echo '$ diff-expr '\''a && ((b >= c) != (d || e))'\'' '\''a && b >= c != (d || e)'\'''
diff-expr 'a && ((b >= c) != (d || e))' 'a && b >= c != (d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b >= c) != (d || e))'\'' '\''a && b >= c != (d || e)'\'''

echo '$ diff-expr '\''a && ((b >= c) != (d || e))'\'' '\''a && (b >= c != (d || e))'\'''
diff-expr 'a && ((b >= c) != (d || e))' 'a && (b >= c != (d || e))' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b >= c) != (d || e))'\'' '\''a && (b >= c != (d || e))'\'''

echo '$ test-expr '\''(a && (b >= (c != d))) || e'\'''
test-expr '(a && (b >= (c != d))) || e' 2>&1 ||
echo 'command failed: test-expr '\''(a && (b >= (c != d))) || e'\'''

echo '$ diff-expr '\''(a && (b >= (c != d))) || e'\'' '\''a && (b >= (c != d)) || e'\'''
diff-expr '(a && (b >= (c != d))) || e' 'a && (b >= (c != d)) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b >= (c != d))) || e'\'' '\''a && (b >= (c != d)) || e'\'''

echo '$ diff-expr '\''(a && (b >= (c != d))) || e'\'' '\''a && b >= (c != d) || e'\'''
diff-expr '(a && (b >= (c != d))) || e' 'a && b >= (c != d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b >= (c != d))) || e'\'' '\''a && b >= (c != d) || e'\'''

echo '$ diff-expr '\''(a && (b >= (c != d))) || e'\'' '\''(a && b >= (c != d)) || e'\'''
diff-expr '(a && (b >= (c != d))) || e' '(a && b >= (c != d)) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b >= (c != d))) || e'\'' '\''(a && b >= (c != d)) || e'\'''

echo '$ test-expr '\''(a && (b >= c)) != (d || e)'\'''
test-expr '(a && (b >= c)) != (d || e)' 2>&1 ||
echo 'command failed: test-expr '\''(a && (b >= c)) != (d || e)'\'''

echo '$ diff-expr '\''(a && (b >= c)) != (d || e)'\'' '\''(a && b >= c) != (d || e)'\'''
diff-expr '(a && (b >= c)) != (d || e)' '(a && b >= c) != (d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b >= c)) != (d || e)'\'' '\''(a && b >= c) != (d || e)'\'''

echo '$ test-expr '\''(a && b) >= (c != (d || e))'\'''
test-expr '(a && b) >= (c != (d || e))' 2>&1 ||
echo 'command failed: test-expr '\''(a && b) >= (c != (d || e))'\'''

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'''
test-expr 'a && (b >= (c != (d || e)))' 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'''

echo '$ diff-expr '\''a && (b >= (c != (d || e)))'\'' '\''a && b >= (c != (d || e))'\'''
diff-expr 'a && (b >= (c != (d || e)))' 'a && b >= (c != (d || e))' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b >= (c != (d || e)))'\'' '\''a && b >= (c != (d || e))'\'''

echo '$ test-expr '\''(((a && b) >= c) || d) != e'\'''
test-expr '(((a && b) >= c) || d) != e' 2>&1 ||
echo 'command failed: test-expr '\''(((a && b) >= c) || d) != e'\'''

echo '$ diff-expr '\''(((a && b) >= c) || d) != e'\'' '\''((a && b) >= c || d) != e'\'''
diff-expr '(((a && b) >= c) || d) != e' '((a && b) >= c || d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a && b) >= c) || d) != e'\'' '\''((a && b) >= c || d) != e'\'''

echo '$ test-expr '\''a && (((b >= c) || d) != e)'\'''
test-expr 'a && (((b >= c) || d) != e)' 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) || d) != e)'\'''

echo '$ diff-expr '\''a && (((b >= c) || d) != e)'\'' '\''a && ((b >= c) || d) != e'\'''
diff-expr 'a && (((b >= c) || d) != e)' 'a && ((b >= c) || d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''a && (((b >= c) || d) != e)'\'' '\''a && ((b >= c) || d) != e'\'''

echo '$ diff-expr '\''a && (((b >= c) || d) != e)'\'' '\''a && (b >= c || d) != e'\'''
diff-expr 'a && (((b >= c) || d) != e)' 'a && (b >= c || d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''a && (((b >= c) || d) != e)'\'' '\''a && (b >= c || d) != e'\'''

echo '$ diff-expr '\''a && (((b >= c) || d) != e)'\'' '\''a && ((b >= c || d) != e)'\'''
diff-expr 'a && (((b >= c) || d) != e)' 'a && ((b >= c || d) != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (((b >= c) || d) != e)'\'' '\''a && ((b >= c || d) != e)'\'''

echo '$ test-expr '\''(a && ((b >= c) || d)) != e'\'''
test-expr '(a && ((b >= c) || d)) != e' 2>&1 ||
echo 'command failed: test-expr '\''(a && ((b >= c) || d)) != e'\'''

echo '$ diff-expr '\''(a && ((b >= c) || d)) != e'\'' '\''(a && (b >= c || d)) != e'\'''
diff-expr '(a && ((b >= c) || d)) != e' '(a && (b >= c || d)) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && ((b >= c) || d)) != e'\'' '\''(a && (b >= c || d)) != e'\'''

echo '$ test-expr '\''(a && b) >= ((c || d) != e)'\'''
test-expr '(a && b) >= ((c || d) != e)' 2>&1 ||
echo 'command failed: test-expr '\''(a && b) >= ((c || d) != e)'\'''

echo '$ test-expr '\''a && (b >= ((c || d) != e))'\'''
test-expr 'a && (b >= ((c || d) != e))' 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c || d) != e))'\'''

echo '$ diff-expr '\''a && (b >= ((c || d) != e))'\'' '\''a && b >= ((c || d) != e)'\'''
diff-expr 'a && (b >= ((c || d) != e))' 'a && b >= ((c || d) != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b >= ((c || d) != e))'\'' '\''a && b >= ((c || d) != e)'\'''

echo '$ test-expr '\''((a && (b >= c)) || d) != e'\'''
test-expr '((a && (b >= c)) || d) != e' 2>&1 ||
echo 'command failed: test-expr '\''((a && (b >= c)) || d) != e'\'''

echo '$ diff-expr '\''((a && (b >= c)) || d) != e'\'' '\''(a && (b >= c) || d) != e'\'''
diff-expr '((a && (b >= c)) || d) != e' '(a && (b >= c) || d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''((a && (b >= c)) || d) != e'\'' '\''(a && (b >= c) || d) != e'\'''

echo '$ diff-expr '\''((a && (b >= c)) || d) != e'\'' '\''(a && b >= c || d) != e'\'''
diff-expr '((a && (b >= c)) || d) != e' '(a && b >= c || d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''((a && (b >= c)) || d) != e'\'' '\''(a && b >= c || d) != e'\'''

echo '$ diff-expr '\''((a && (b >= c)) || d) != e'\'' '\''((a && b >= c) || d) != e'\'''
diff-expr '((a && (b >= c)) || d) != e' '((a && b >= c) || d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''((a && (b >= c)) || d) != e'\'' '\''((a && b >= c) || d) != e'\'''

echo '$ test-expr '\''a && ((b >= (c || d)) != e)'\'''
test-expr 'a && ((b >= (c || d)) != e)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c || d)) != e)'\'''

echo '$ diff-expr '\''a && ((b >= (c || d)) != e)'\'' '\''a && (b >= (c || d)) != e'\'''
diff-expr 'a && ((b >= (c || d)) != e)' 'a && (b >= (c || d)) != e' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b >= (c || d)) != e)'\'' '\''a && (b >= (c || d)) != e'\'''

echo '$ diff-expr '\''a && ((b >= (c || d)) != e)'\'' '\''a && b >= (c || d) != e'\'''
diff-expr 'a && ((b >= (c || d)) != e)' 'a && b >= (c || d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b >= (c || d)) != e)'\'' '\''a && b >= (c || d) != e'\'''

echo '$ diff-expr '\''a && ((b >= (c || d)) != e)'\'' '\''a && (b >= (c || d) != e)'\'''
diff-expr 'a && ((b >= (c || d)) != e)' 'a && (b >= (c || d) != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b >= (c || d)) != e)'\'' '\''a && (b >= (c || d) != e)'\'''

echo '$ test-expr '\''((a && b) >= (c || d)) != e'\'''
test-expr '((a && b) >= (c || d)) != e' 2>&1 ||
echo 'command failed: test-expr '\''((a && b) >= (c || d)) != e'\'''

echo '$ diff-expr '\''((a && b) >= (c || d)) != e'\'' '\''(a && b) >= (c || d) != e'\'''
diff-expr '((a && b) >= (c || d)) != e' '(a && b) >= (c || d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) >= (c || d)) != e'\'' '\''(a && b) >= (c || d) != e'\'''

echo '$ test-expr '\''((a && b) >= c) || (d != e)'\'''
test-expr '((a && b) >= c) || (d != e)' 2>&1 ||
echo 'command failed: test-expr '\''((a && b) >= c) || (d != e)'\'''

echo '$ diff-expr '\''((a && b) >= c) || (d != e)'\'' '\''(a && b) >= c || (d != e)'\'''
diff-expr '((a && b) >= c) || (d != e)' '(a && b) >= c || (d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) >= c) || (d != e)'\'' '\''(a && b) >= c || (d != e)'\'''

echo '$ diff-expr '\''((a && b) >= c) || (d != e)'\'' '\''(a && b) >= c || d != e'\'''
diff-expr '((a && b) >= c) || (d != e)' '(a && b) >= c || d != e' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) >= c) || (d != e)'\'' '\''(a && b) >= c || d != e'\'''

echo '$ diff-expr '\''((a && b) >= c) || (d != e)'\'' '\''((a && b) >= c) || d != e'\'''
diff-expr '((a && b) >= c) || (d != e)' '((a && b) >= c) || d != e' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) >= c) || (d != e)'\'' '\''((a && b) >= c) || d != e'\'''

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'''
test-expr 'a && ((b >= c) || (d != e))' 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'''

echo '$ diff-expr '\''a && ((b >= c) || (d != e))'\'' '\''a && (b >= c || (d != e))'\'''
diff-expr 'a && ((b >= c) || (d != e))' 'a && (b >= c || (d != e))' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b >= c) || (d != e))'\'' '\''a && (b >= c || (d != e))'\'''

echo '$ diff-expr '\''a && ((b >= c) || (d != e))'\'' '\''a && (b >= c || d != e)'\'''
diff-expr 'a && ((b >= c) || (d != e))' 'a && (b >= c || d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b >= c) || (d != e))'\'' '\''a && (b >= c || d != e)'\'''

echo '$ diff-expr '\''a && ((b >= c) || (d != e))'\'' '\''a && ((b >= c) || d != e)'\'''
diff-expr 'a && ((b >= c) || (d != e))' 'a && ((b >= c) || d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b >= c) || (d != e))'\'' '\''a && ((b >= c) || d != e)'\'''

echo '$ test-expr '\''(a && (b >= (c || d))) != e'\'''
test-expr '(a && (b >= (c || d))) != e' 2>&1 ||
echo 'command failed: test-expr '\''(a && (b >= (c || d))) != e'\'''

echo '$ diff-expr '\''(a && (b >= (c || d))) != e'\'' '\''(a && b >= (c || d)) != e'\'''
diff-expr '(a && (b >= (c || d))) != e' '(a && b >= (c || d)) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b >= (c || d))) != e'\'' '\''(a && b >= (c || d)) != e'\'''

echo '$ test-expr '\''(a && (b >= c)) || (d != e)'\'''
test-expr '(a && (b >= c)) || (d != e)' 2>&1 ||
echo 'command failed: test-expr '\''(a && (b >= c)) || (d != e)'\'''

echo '$ diff-expr '\''(a && (b >= c)) || (d != e)'\'' '\''a && (b >= c) || (d != e)'\'''
diff-expr '(a && (b >= c)) || (d != e)' 'a && (b >= c) || (d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b >= c)) || (d != e)'\'' '\''a && (b >= c) || (d != e)'\'''

echo '$ diff-expr '\''(a && (b >= c)) || (d != e)'\'' '\''a && b >= c || (d != e)'\'''
diff-expr '(a && (b >= c)) || (d != e)' 'a && b >= c || (d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b >= c)) || (d != e)'\'' '\''a && b >= c || (d != e)'\'''

echo '$ diff-expr '\''(a && (b >= c)) || (d != e)'\'' '\''a && b >= c || d != e'\'''
diff-expr '(a && (b >= c)) || (d != e)' 'a && b >= c || d != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b >= c)) || (d != e)'\'' '\''a && b >= c || d != e'\'''

echo '$ diff-expr '\''(a && (b >= c)) || (d != e)'\'' '\''a && (b >= c) || d != e'\'''
diff-expr '(a && (b >= c)) || (d != e)' 'a && (b >= c) || d != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b >= c)) || (d != e)'\'' '\''a && (b >= c) || d != e'\'''

echo '$ diff-expr '\''(a && (b >= c)) || (d != e)'\'' '\''(a && b >= c) || (d != e)'\'''
diff-expr '(a && (b >= c)) || (d != e)' '(a && b >= c) || (d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b >= c)) || (d != e)'\'' '\''(a && b >= c) || (d != e)'\'''

echo '$ diff-expr '\''(a && (b >= c)) || (d != e)'\'' '\''(a && b >= c) || d != e'\'''
diff-expr '(a && (b >= c)) || (d != e)' '(a && b >= c) || d != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b >= c)) || (d != e)'\'' '\''(a && b >= c) || d != e'\'''

echo '$ diff-expr '\''(a && (b >= c)) || (d != e)'\'' '\''(a && (b >= c)) || d != e'\'''
diff-expr '(a && (b >= c)) || (d != e)' '(a && (b >= c)) || d != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b >= c)) || (d != e)'\'' '\''(a && (b >= c)) || d != e'\'''

echo '$ test-expr '\''(a && b) >= (c || (d != e))'\'''
test-expr '(a && b) >= (c || (d != e))' 2>&1 ||
echo 'command failed: test-expr '\''(a && b) >= (c || (d != e))'\'''

echo '$ diff-expr '\''(a && b) >= (c || (d != e))'\'' '\''(a && b) >= (c || d != e)'\'''
diff-expr '(a && b) >= (c || (d != e))' '(a && b) >= (c || d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) >= (c || (d != e))'\'' '\''(a && b) >= (c || d != e)'\'''

echo '$ test-expr '\''a && (b >= (c || (d != e)))'\'''
test-expr 'a && (b >= (c || (d != e)))' 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c || (d != e)))'\'''

echo '$ diff-expr '\''a && (b >= (c || (d != e)))'\'' '\''a && b >= (c || (d != e))'\'''
diff-expr 'a && (b >= (c || (d != e)))' 'a && b >= (c || (d != e))' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b >= (c || (d != e)))'\'' '\''a && b >= (c || (d != e))'\'''

echo '$ diff-expr '\''a && (b >= (c || (d != e)))'\'' '\''a && b >= (c || d != e)'\'''
diff-expr 'a && (b >= (c || (d != e)))' 'a && b >= (c || d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b >= (c || (d != e)))'\'' '\''a && b >= (c || d != e)'\'''

echo '$ diff-expr '\''a && (b >= (c || (d != e)))'\'' '\''a && (b >= (c || d != e))'\'''
diff-expr 'a && (b >= (c || (d != e)))' 'a && (b >= (c || d != e))' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b >= (c || (d != e)))'\'' '\''a && (b >= (c || d != e))'\'''

echo '$ test-expr '\''(((a && b) != c) >= d) || e'\'''
test-expr '(((a && b) != c) >= d) || e' 2>&1 ||
echo 'command failed: test-expr '\''(((a && b) != c) >= d) || e'\'''

echo '$ diff-expr '\''(((a && b) != c) >= d) || e'\'' '\''((a && b) != c) >= d || e'\'''
diff-expr '(((a && b) != c) >= d) || e' '((a && b) != c) >= d || e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a && b) != c) >= d) || e'\'' '\''((a && b) != c) >= d || e'\'''

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'''
test-expr 'a && (((b != c) >= d) || e)' 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'''

echo '$ diff-expr '\''a && (((b != c) >= d) || e)'\'' '\''a && ((b != c) >= d || e)'\'''
diff-expr 'a && (((b != c) >= d) || e)' 'a && ((b != c) >= d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (((b != c) >= d) || e)'\'' '\''a && ((b != c) >= d || e)'\'''

echo '$ test-expr '\''(a && ((b != c) >= d)) || e'\'''
test-expr '(a && ((b != c) >= d)) || e' 2>&1 ||
echo 'command failed: test-expr '\''(a && ((b != c) >= d)) || e'\'''

echo '$ diff-expr '\''(a && ((b != c) >= d)) || e'\'' '\''a && ((b != c) >= d) || e'\'''
diff-expr '(a && ((b != c) >= d)) || e' 'a && ((b != c) >= d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && ((b != c) >= d)) || e'\'' '\''a && ((b != c) >= d) || e'\'''

echo '$ diff-expr '\''(a && ((b != c) >= d)) || e'\'' '\''a && (b != c) >= d || e'\'''
diff-expr '(a && ((b != c) >= d)) || e' 'a && (b != c) >= d || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && ((b != c) >= d)) || e'\'' '\''a && (b != c) >= d || e'\'''

echo '$ diff-expr '\''(a && ((b != c) >= d)) || e'\'' '\''(a && (b != c) >= d) || e'\'''
diff-expr '(a && ((b != c) >= d)) || e' '(a && (b != c) >= d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && ((b != c) >= d)) || e'\'' '\''(a && (b != c) >= d) || e'\'''

echo '$ test-expr '\''(a && b) != ((c >= d) || e)'\'''
test-expr '(a && b) != ((c >= d) || e)' 2>&1 ||
echo 'command failed: test-expr '\''(a && b) != ((c >= d) || e)'\'''

echo '$ diff-expr '\''(a && b) != ((c >= d) || e)'\'' '\''(a && b) != (c >= d || e)'\'''
diff-expr '(a && b) != ((c >= d) || e)' '(a && b) != (c >= d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) != ((c >= d) || e)'\'' '\''(a && b) != (c >= d || e)'\'''

echo '$ test-expr '\''a && (b != ((c >= d) || e))'\'''
test-expr 'a && (b != ((c >= d) || e))' 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c >= d) || e))'\'''

echo '$ diff-expr '\''a && (b != ((c >= d) || e))'\'' '\''a && b != ((c >= d) || e)'\'''
diff-expr 'a && (b != ((c >= d) || e))' 'a && b != ((c >= d) || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b != ((c >= d) || e))'\'' '\''a && b != ((c >= d) || e)'\'''

echo '$ diff-expr '\''a && (b != ((c >= d) || e))'\'' '\''a && b != (c >= d || e)'\'''
diff-expr 'a && (b != ((c >= d) || e))' 'a && b != (c >= d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b != ((c >= d) || e))'\'' '\''a && b != (c >= d || e)'\'''

echo '$ diff-expr '\''a && (b != ((c >= d) || e))'\'' '\''a && (b != (c >= d || e))'\'''
diff-expr 'a && (b != ((c >= d) || e))' 'a && (b != (c >= d || e))' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b != ((c >= d) || e))'\'' '\''a && (b != (c >= d || e))'\'''

echo '$ test-expr '\''((a && (b != c)) >= d) || e'\'''
test-expr '((a && (b != c)) >= d) || e' 2>&1 ||
echo 'command failed: test-expr '\''((a && (b != c)) >= d) || e'\'''

echo '$ diff-expr '\''((a && (b != c)) >= d) || e'\'' '\''(a && (b != c)) >= d || e'\'''
diff-expr '((a && (b != c)) >= d) || e' '(a && (b != c)) >= d || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a && (b != c)) >= d) || e'\'' '\''(a && (b != c)) >= d || e'\'''

echo '$ diff-expr '\''((a && (b != c)) >= d) || e'\'' '\''(a && b != c) >= d || e'\'''
diff-expr '((a && (b != c)) >= d) || e' '(a && b != c) >= d || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a && (b != c)) >= d) || e'\'' '\''(a && b != c) >= d || e'\'''

echo '$ diff-expr '\''((a && (b != c)) >= d) || e'\'' '\''((a && b != c) >= d) || e'\'''
diff-expr '((a && (b != c)) >= d) || e' '((a && b != c) >= d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a && (b != c)) >= d) || e'\'' '\''((a && b != c) >= d) || e'\'''

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'''
test-expr 'a && ((b != (c >= d)) || e)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'''

echo '$ diff-expr '\''a && ((b != (c >= d)) || e)'\'' '\''a && (b != (c >= d) || e)'\'''
diff-expr 'a && ((b != (c >= d)) || e)' 'a && (b != (c >= d) || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b != (c >= d)) || e)'\'' '\''a && (b != (c >= d) || e)'\'''

echo '$ diff-expr '\''a && ((b != (c >= d)) || e)'\'' '\''a && (b != c >= d || e)'\'''
diff-expr 'a && ((b != (c >= d)) || e)' 'a && (b != c >= d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b != (c >= d)) || e)'\'' '\''a && (b != c >= d || e)'\'''

echo '$ diff-expr '\''a && ((b != (c >= d)) || e)'\'' '\''a && ((b != c >= d) || e)'\'''
diff-expr 'a && ((b != (c >= d)) || e)' 'a && ((b != c >= d) || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b != (c >= d)) || e)'\'' '\''a && ((b != c >= d) || e)'\'''

echo '$ test-expr '\''((a && b) != (c >= d)) || e'\'''
test-expr '((a && b) != (c >= d)) || e' 2>&1 ||
echo 'command failed: test-expr '\''((a && b) != (c >= d)) || e'\'''

echo '$ diff-expr '\''((a && b) != (c >= d)) || e'\'' '\''(a && b) != (c >= d) || e'\'''
diff-expr '((a && b) != (c >= d)) || e' '(a && b) != (c >= d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) != (c >= d)) || e'\'' '\''(a && b) != (c >= d) || e'\'''

echo '$ diff-expr '\''((a && b) != (c >= d)) || e'\'' '\''(a && b) != c >= d || e'\'''
diff-expr '((a && b) != (c >= d)) || e' '(a && b) != c >= d || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) != (c >= d)) || e'\'' '\''(a && b) != c >= d || e'\'''

echo '$ diff-expr '\''((a && b) != (c >= d)) || e'\'' '\''((a && b) != c >= d) || e'\'''
diff-expr '((a && b) != (c >= d)) || e' '((a && b) != c >= d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) != (c >= d)) || e'\'' '\''((a && b) != c >= d) || e'\'''

echo '$ test-expr '\''((a && b) != c) >= (d || e)'\'''
test-expr '((a && b) != c) >= (d || e)' 2>&1 ||
echo 'command failed: test-expr '\''((a && b) != c) >= (d || e)'\'''

echo '$ test-expr '\''a && ((b != c) >= (d || e))'\'''
test-expr 'a && ((b != c) >= (d || e))' 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) >= (d || e))'\'''

echo '$ diff-expr '\''a && ((b != c) >= (d || e))'\'' '\''a && (b != c) >= (d || e)'\'''
diff-expr 'a && ((b != c) >= (d || e))' 'a && (b != c) >= (d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b != c) >= (d || e))'\'' '\''a && (b != c) >= (d || e)'\'''

echo '$ test-expr '\''(a && (b != (c >= d))) || e'\'''
test-expr '(a && (b != (c >= d))) || e' 2>&1 ||
echo 'command failed: test-expr '\''(a && (b != (c >= d))) || e'\'''

echo '$ diff-expr '\''(a && (b != (c >= d))) || e'\'' '\''a && (b != (c >= d)) || e'\'''
diff-expr '(a && (b != (c >= d))) || e' 'a && (b != (c >= d)) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b != (c >= d))) || e'\'' '\''a && (b != (c >= d)) || e'\'''

echo '$ diff-expr '\''(a && (b != (c >= d))) || e'\'' '\''a && b != (c >= d) || e'\'''
diff-expr '(a && (b != (c >= d))) || e' 'a && b != (c >= d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b != (c >= d))) || e'\'' '\''a && b != (c >= d) || e'\'''

echo '$ diff-expr '\''(a && (b != (c >= d))) || e'\'' '\''a && b != c >= d || e'\'''
diff-expr '(a && (b != (c >= d))) || e' 'a && b != c >= d || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b != (c >= d))) || e'\'' '\''a && b != c >= d || e'\'''

echo '$ diff-expr '\''(a && (b != (c >= d))) || e'\'' '\''a && (b != c >= d) || e'\'''
diff-expr '(a && (b != (c >= d))) || e' 'a && (b != c >= d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b != (c >= d))) || e'\'' '\''a && (b != c >= d) || e'\'''

echo '$ diff-expr '\''(a && (b != (c >= d))) || e'\'' '\''(a && b != (c >= d)) || e'\'''
diff-expr '(a && (b != (c >= d))) || e' '(a && b != (c >= d)) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b != (c >= d))) || e'\'' '\''(a && b != (c >= d)) || e'\'''

echo '$ diff-expr '\''(a && (b != (c >= d))) || e'\'' '\''(a && b != c >= d) || e'\'''
diff-expr '(a && (b != (c >= d))) || e' '(a && b != c >= d) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b != (c >= d))) || e'\'' '\''(a && b != c >= d) || e'\'''

echo '$ diff-expr '\''(a && (b != (c >= d))) || e'\'' '\''(a && (b != c >= d)) || e'\'''
diff-expr '(a && (b != (c >= d))) || e' '(a && (b != c >= d)) || e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b != (c >= d))) || e'\'' '\''(a && (b != c >= d)) || e'\'''

echo '$ test-expr '\''(a && (b != c)) >= (d || e)'\'''
test-expr '(a && (b != c)) >= (d || e)' 2>&1 ||
echo 'command failed: test-expr '\''(a && (b != c)) >= (d || e)'\'''

echo '$ diff-expr '\''(a && (b != c)) >= (d || e)'\'' '\''(a && b != c) >= (d || e)'\'''
diff-expr '(a && (b != c)) >= (d || e)' '(a && b != c) >= (d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b != c)) >= (d || e)'\'' '\''(a && b != c) >= (d || e)'\'''

echo '$ test-expr '\''(a && b) != (c >= (d || e))'\'''
test-expr '(a && b) != (c >= (d || e))' 2>&1 ||
echo 'command failed: test-expr '\''(a && b) != (c >= (d || e))'\'''

echo '$ diff-expr '\''(a && b) != (c >= (d || e))'\'' '\''(a && b) != c >= (d || e)'\'''
diff-expr '(a && b) != (c >= (d || e))' '(a && b) != c >= (d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) != (c >= (d || e))'\'' '\''(a && b) != c >= (d || e)'\'''

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'''
test-expr 'a && (b != (c >= (d || e)))' 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'''

echo '$ diff-expr '\''a && (b != (c >= (d || e)))'\'' '\''a && b != (c >= (d || e))'\'''
diff-expr 'a && (b != (c >= (d || e)))' 'a && b != (c >= (d || e))' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b != (c >= (d || e)))'\'' '\''a && b != (c >= (d || e))'\'''

echo '$ diff-expr '\''a && (b != (c >= (d || e)))'\'' '\''a && b != c >= (d || e)'\'''
diff-expr 'a && (b != (c >= (d || e)))' 'a && b != c >= (d || e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b != (c >= (d || e)))'\'' '\''a && b != c >= (d || e)'\'''

echo '$ diff-expr '\''a && (b != (c >= (d || e)))'\'' '\''a && (b != c >= (d || e))'\'''
diff-expr 'a && (b != (c >= (d || e)))' 'a && (b != c >= (d || e))' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b != (c >= (d || e)))'\'' '\''a && (b != c >= (d || e))'\'''

echo '$ test-expr '\''(((a && b) != c) || d) >= e'\'''
test-expr '(((a && b) != c) || d) >= e' 2>&1 ||
echo 'command failed: test-expr '\''(((a && b) != c) || d) >= e'\'''

echo '$ diff-expr '\''(((a && b) != c) || d) >= e'\'' '\''((a && b) != c || d) >= e'\'''
diff-expr '(((a && b) != c) || d) >= e' '((a && b) != c || d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a && b) != c) || d) >= e'\'' '\''((a && b) != c || d) >= e'\'''

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'''
test-expr 'a && (((b != c) || d) >= e)' 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'''

echo '$ diff-expr '\''a && (((b != c) || d) >= e)'\'' '\''a && ((b != c) || d) >= e'\'''
diff-expr 'a && (((b != c) || d) >= e)' 'a && ((b != c) || d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''a && (((b != c) || d) >= e)'\'' '\''a && ((b != c) || d) >= e'\'''

echo '$ diff-expr '\''a && (((b != c) || d) >= e)'\'' '\''a && (b != c || d) >= e'\'''
diff-expr 'a && (((b != c) || d) >= e)' 'a && (b != c || d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''a && (((b != c) || d) >= e)'\'' '\''a && (b != c || d) >= e'\'''

echo '$ diff-expr '\''a && (((b != c) || d) >= e)'\'' '\''a && ((b != c || d) >= e)'\'''
diff-expr 'a && (((b != c) || d) >= e)' 'a && ((b != c || d) >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (((b != c) || d) >= e)'\'' '\''a && ((b != c || d) >= e)'\'''

echo '$ test-expr '\''(a && ((b != c) || d)) >= e'\'''
test-expr '(a && ((b != c) || d)) >= e' 2>&1 ||
echo 'command failed: test-expr '\''(a && ((b != c) || d)) >= e'\'''

echo '$ diff-expr '\''(a && ((b != c) || d)) >= e'\'' '\''(a && (b != c || d)) >= e'\'''
diff-expr '(a && ((b != c) || d)) >= e' '(a && (b != c || d)) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && ((b != c) || d)) >= e'\'' '\''(a && (b != c || d)) >= e'\'''

echo '$ test-expr '\''(a && b) != ((c || d) >= e)'\'''
test-expr '(a && b) != ((c || d) >= e)' 2>&1 ||
echo 'command failed: test-expr '\''(a && b) != ((c || d) >= e)'\'''

echo '$ diff-expr '\''(a && b) != ((c || d) >= e)'\'' '\''(a && b) != (c || d) >= e'\'''
diff-expr '(a && b) != ((c || d) >= e)' '(a && b) != (c || d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) != ((c || d) >= e)'\'' '\''(a && b) != (c || d) >= e'\'''

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'''
test-expr 'a && (b != ((c || d) >= e))' 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'''

echo '$ diff-expr '\''a && (b != ((c || d) >= e))'\'' '\''a && b != ((c || d) >= e)'\'''
diff-expr 'a && (b != ((c || d) >= e))' 'a && b != ((c || d) >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b != ((c || d) >= e))'\'' '\''a && b != ((c || d) >= e)'\'''

echo '$ diff-expr '\''a && (b != ((c || d) >= e))'\'' '\''a && b != (c || d) >= e'\'''
diff-expr 'a && (b != ((c || d) >= e))' 'a && b != (c || d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b != ((c || d) >= e))'\'' '\''a && b != (c || d) >= e'\'''

echo '$ diff-expr '\''a && (b != ((c || d) >= e))'\'' '\''a && (b != (c || d) >= e)'\'''
diff-expr 'a && (b != ((c || d) >= e))' 'a && (b != (c || d) >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b != ((c || d) >= e))'\'' '\''a && (b != (c || d) >= e)'\'''

echo '$ test-expr '\''((a && (b != c)) || d) >= e'\'''
test-expr '((a && (b != c)) || d) >= e' 2>&1 ||
echo 'command failed: test-expr '\''((a && (b != c)) || d) >= e'\'''

echo '$ diff-expr '\''((a && (b != c)) || d) >= e'\'' '\''(a && (b != c) || d) >= e'\'''
diff-expr '((a && (b != c)) || d) >= e' '(a && (b != c) || d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''((a && (b != c)) || d) >= e'\'' '\''(a && (b != c) || d) >= e'\'''

echo '$ diff-expr '\''((a && (b != c)) || d) >= e'\'' '\''(a && b != c || d) >= e'\'''
diff-expr '((a && (b != c)) || d) >= e' '(a && b != c || d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''((a && (b != c)) || d) >= e'\'' '\''(a && b != c || d) >= e'\'''

echo '$ diff-expr '\''((a && (b != c)) || d) >= e'\'' '\''((a && b != c) || d) >= e'\'''
diff-expr '((a && (b != c)) || d) >= e' '((a && b != c) || d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''((a && (b != c)) || d) >= e'\'' '\''((a && b != c) || d) >= e'\'''

echo '$ test-expr '\''a && ((b != (c || d)) >= e)'\'''
test-expr 'a && ((b != (c || d)) >= e)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c || d)) >= e)'\'''

echo '$ diff-expr '\''a && ((b != (c || d)) >= e)'\'' '\''a && (b != (c || d)) >= e'\'''
diff-expr 'a && ((b != (c || d)) >= e)' 'a && (b != (c || d)) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b != (c || d)) >= e)'\'' '\''a && (b != (c || d)) >= e'\'''

echo '$ test-expr '\''((a && b) != (c || d)) >= e'\'''
test-expr '((a && b) != (c || d)) >= e' 2>&1 ||
echo 'command failed: test-expr '\''((a && b) != (c || d)) >= e'\'''

echo '$ test-expr '\''((a && b) != c) || (d >= e)'\'''
test-expr '((a && b) != c) || (d >= e)' 2>&1 ||
echo 'command failed: test-expr '\''((a && b) != c) || (d >= e)'\'''

echo '$ diff-expr '\''((a && b) != c) || (d >= e)'\'' '\''(a && b) != c || (d >= e)'\'''
diff-expr '((a && b) != c) || (d >= e)' '(a && b) != c || (d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) != c) || (d >= e)'\'' '\''(a && b) != c || (d >= e)'\'''

echo '$ diff-expr '\''((a && b) != c) || (d >= e)'\'' '\''(a && b) != c || d >= e'\'''
diff-expr '((a && b) != c) || (d >= e)' '(a && b) != c || d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) != c) || (d >= e)'\'' '\''(a && b) != c || d >= e'\'''

echo '$ diff-expr '\''((a && b) != c) || (d >= e)'\'' '\''((a && b) != c) || d >= e'\'''
diff-expr '((a && b) != c) || (d >= e)' '((a && b) != c) || d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) != c) || (d >= e)'\'' '\''((a && b) != c) || d >= e'\'''

echo '$ test-expr '\''a && ((b != c) || (d >= e))'\'''
test-expr 'a && ((b != c) || (d >= e))' 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) || (d >= e))'\'''

echo '$ diff-expr '\''a && ((b != c) || (d >= e))'\'' '\''a && (b != c || (d >= e))'\'''
diff-expr 'a && ((b != c) || (d >= e))' 'a && (b != c || (d >= e))' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b != c) || (d >= e))'\'' '\''a && (b != c || (d >= e))'\'''

echo '$ diff-expr '\''a && ((b != c) || (d >= e))'\'' '\''a && (b != c || d >= e)'\'''
diff-expr 'a && ((b != c) || (d >= e))' 'a && (b != c || d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b != c) || (d >= e))'\'' '\''a && (b != c || d >= e)'\'''

echo '$ diff-expr '\''a && ((b != c) || (d >= e))'\'' '\''a && ((b != c) || d >= e)'\'''
diff-expr 'a && ((b != c) || (d >= e))' 'a && ((b != c) || d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b != c) || (d >= e))'\'' '\''a && ((b != c) || d >= e)'\'''

echo '$ test-expr '\''(a && (b != (c || d))) >= e'\'''
test-expr '(a && (b != (c || d))) >= e' 2>&1 ||
echo 'command failed: test-expr '\''(a && (b != (c || d))) >= e'\'''

echo '$ diff-expr '\''(a && (b != (c || d))) >= e'\'' '\''(a && b != (c || d)) >= e'\'''
diff-expr '(a && (b != (c || d))) >= e' '(a && b != (c || d)) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b != (c || d))) >= e'\'' '\''(a && b != (c || d)) >= e'\'''

echo '$ test-expr '\''(a && (b != c)) || (d >= e)'\'''
test-expr '(a && (b != c)) || (d >= e)' 2>&1 ||
echo 'command failed: test-expr '\''(a && (b != c)) || (d >= e)'\'''

echo '$ diff-expr '\''(a && (b != c)) || (d >= e)'\'' '\''a && (b != c) || (d >= e)'\'''
diff-expr '(a && (b != c)) || (d >= e)' 'a && (b != c) || (d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b != c)) || (d >= e)'\'' '\''a && (b != c) || (d >= e)'\'''

echo '$ diff-expr '\''(a && (b != c)) || (d >= e)'\'' '\''a && b != c || (d >= e)'\'''
diff-expr '(a && (b != c)) || (d >= e)' 'a && b != c || (d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b != c)) || (d >= e)'\'' '\''a && b != c || (d >= e)'\'''

echo '$ diff-expr '\''(a && (b != c)) || (d >= e)'\'' '\''a && b != c || d >= e'\'''
diff-expr '(a && (b != c)) || (d >= e)' 'a && b != c || d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b != c)) || (d >= e)'\'' '\''a && b != c || d >= e'\'''

echo '$ diff-expr '\''(a && (b != c)) || (d >= e)'\'' '\''a && (b != c) || d >= e'\'''
diff-expr '(a && (b != c)) || (d >= e)' 'a && (b != c) || d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b != c)) || (d >= e)'\'' '\''a && (b != c) || d >= e'\'''

echo '$ diff-expr '\''(a && (b != c)) || (d >= e)'\'' '\''(a && b != c) || (d >= e)'\'''
diff-expr '(a && (b != c)) || (d >= e)' '(a && b != c) || (d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b != c)) || (d >= e)'\'' '\''(a && b != c) || (d >= e)'\'''

echo '$ diff-expr '\''(a && (b != c)) || (d >= e)'\'' '\''(a && b != c) || d >= e'\'''
diff-expr '(a && (b != c)) || (d >= e)' '(a && b != c) || d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b != c)) || (d >= e)'\'' '\''(a && b != c) || d >= e'\'''

echo '$ diff-expr '\''(a && (b != c)) || (d >= e)'\'' '\''(a && (b != c)) || d >= e'\'''
diff-expr '(a && (b != c)) || (d >= e)' '(a && (b != c)) || d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b != c)) || (d >= e)'\'' '\''(a && (b != c)) || d >= e'\'''

echo '$ test-expr '\''(a && b) != (c || (d >= e))'\'''
test-expr '(a && b) != (c || (d >= e))' 2>&1 ||
echo 'command failed: test-expr '\''(a && b) != (c || (d >= e))'\'''

echo '$ diff-expr '\''(a && b) != (c || (d >= e))'\'' '\''(a && b) != (c || d >= e)'\'''
diff-expr '(a && b) != (c || (d >= e))' '(a && b) != (c || d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) != (c || (d >= e))'\'' '\''(a && b) != (c || d >= e)'\'''

echo '$ test-expr '\''a && (b != (c || (d >= e)))'\'''
test-expr 'a && (b != (c || (d >= e)))' 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c || (d >= e)))'\'''

echo '$ diff-expr '\''a && (b != (c || (d >= e)))'\'' '\''a && b != (c || (d >= e))'\'''
diff-expr 'a && (b != (c || (d >= e)))' 'a && b != (c || (d >= e))' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b != (c || (d >= e)))'\'' '\''a && b != (c || (d >= e))'\'''

echo '$ diff-expr '\''a && (b != (c || (d >= e)))'\'' '\''a && b != (c || d >= e)'\'''
diff-expr 'a && (b != (c || (d >= e)))' 'a && b != (c || d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b != (c || (d >= e)))'\'' '\''a && b != (c || d >= e)'\'''

echo '$ diff-expr '\''a && (b != (c || (d >= e)))'\'' '\''a && (b != (c || d >= e))'\'''
diff-expr 'a && (b != (c || (d >= e)))' 'a && (b != (c || d >= e))' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b != (c || (d >= e)))'\'' '\''a && (b != (c || d >= e))'\'''

echo '$ test-expr '\''(((a && b) || c) >= d) != e'\'''
test-expr '(((a && b) || c) >= d) != e' 2>&1 ||
echo 'command failed: test-expr '\''(((a && b) || c) >= d) != e'\'''

echo '$ diff-expr '\''(((a && b) || c) >= d) != e'\'' '\''((a && b) || c) >= d != e'\'''
diff-expr '(((a && b) || c) >= d) != e' '((a && b) || c) >= d != e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a && b) || c) >= d) != e'\'' '\''((a && b) || c) >= d != e'\'''

echo '$ diff-expr '\''(((a && b) || c) >= d) != e'\'' '\''(a && b || c) >= d != e'\'''
diff-expr '(((a && b) || c) >= d) != e' '(a && b || c) >= d != e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a && b) || c) >= d) != e'\'' '\''(a && b || c) >= d != e'\'''

echo '$ diff-expr '\''(((a && b) || c) >= d) != e'\'' '\''((a && b || c) >= d) != e'\'''
diff-expr '(((a && b) || c) >= d) != e' '((a && b || c) >= d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a && b) || c) >= d) != e'\'' '\''((a && b || c) >= d) != e'\'''

echo '$ test-expr '\''a && (((b || c) >= d) != e)'\'''
test-expr 'a && (((b || c) >= d) != e)' 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) >= d) != e)'\'''

echo '$ diff-expr '\''a && (((b || c) >= d) != e)'\'' '\''a && ((b || c) >= d) != e'\'''
diff-expr 'a && (((b || c) >= d) != e)' 'a && ((b || c) >= d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''a && (((b || c) >= d) != e)'\'' '\''a && ((b || c) >= d) != e'\'''

echo '$ diff-expr '\''a && (((b || c) >= d) != e)'\'' '\''a && (b || c) >= d != e'\'''
diff-expr 'a && (((b || c) >= d) != e)' 'a && (b || c) >= d != e' 2>&1 ||
echo 'command failed: diff-expr '\''a && (((b || c) >= d) != e)'\'' '\''a && (b || c) >= d != e'\'''

echo '$ diff-expr '\''a && (((b || c) >= d) != e)'\'' '\''a && ((b || c) >= d != e)'\'''
diff-expr 'a && (((b || c) >= d) != e)' 'a && ((b || c) >= d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (((b || c) >= d) != e)'\'' '\''a && ((b || c) >= d != e)'\'''

echo '$ test-expr '\''(a && ((b || c) >= d)) != e'\'''
test-expr '(a && ((b || c) >= d)) != e' 2>&1 ||
echo 'command failed: test-expr '\''(a && ((b || c) >= d)) != e'\'''

echo '$ diff-expr '\''(a && ((b || c) >= d)) != e'\'' '\''(a && (b || c) >= d) != e'\'''
diff-expr '(a && ((b || c) >= d)) != e' '(a && (b || c) >= d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && ((b || c) >= d)) != e'\'' '\''(a && (b || c) >= d) != e'\'''

echo '$ test-expr '\''(a && b) || ((c >= d) != e)'\'''
test-expr '(a && b) || ((c >= d) != e)' 2>&1 ||
echo 'command failed: test-expr '\''(a && b) || ((c >= d) != e)'\'''

echo '$ diff-expr '\''(a && b) || ((c >= d) != e)'\'' '\''a && b || ((c >= d) != e)'\'''
diff-expr '(a && b) || ((c >= d) != e)' 'a && b || ((c >= d) != e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || ((c >= d) != e)'\'' '\''a && b || ((c >= d) != e)'\'''

echo '$ diff-expr '\''(a && b) || ((c >= d) != e)'\'' '\''a && b || (c >= d) != e'\'''
diff-expr '(a && b) || ((c >= d) != e)' 'a && b || (c >= d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || ((c >= d) != e)'\'' '\''a && b || (c >= d) != e'\'''

echo '$ diff-expr '\''(a && b) || ((c >= d) != e)'\'' '\''a && b || c >= d != e'\'''
diff-expr '(a && b) || ((c >= d) != e)' 'a && b || c >= d != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || ((c >= d) != e)'\'' '\''a && b || c >= d != e'\'''

echo '$ diff-expr '\''(a && b) || ((c >= d) != e)'\'' '\''a && b || (c >= d != e)'\'''
diff-expr '(a && b) || ((c >= d) != e)' 'a && b || (c >= d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || ((c >= d) != e)'\'' '\''a && b || (c >= d != e)'\'''

echo '$ diff-expr '\''(a && b) || ((c >= d) != e)'\'' '\''(a && b) || (c >= d) != e'\'''
diff-expr '(a && b) || ((c >= d) != e)' '(a && b) || (c >= d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || ((c >= d) != e)'\'' '\''(a && b) || (c >= d) != e'\'''

echo '$ diff-expr '\''(a && b) || ((c >= d) != e)'\'' '\''(a && b) || c >= d != e'\'''
diff-expr '(a && b) || ((c >= d) != e)' '(a && b) || c >= d != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || ((c >= d) != e)'\'' '\''(a && b) || c >= d != e'\'''

echo '$ diff-expr '\''(a && b) || ((c >= d) != e)'\'' '\''(a && b) || (c >= d != e)'\'''
diff-expr '(a && b) || ((c >= d) != e)' '(a && b) || (c >= d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || ((c >= d) != e)'\'' '\''(a && b) || (c >= d != e)'\'''

echo '$ test-expr '\''a && (b || ((c >= d) != e))'\'''
test-expr 'a && (b || ((c >= d) != e))' 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c >= d) != e))'\'''

echo '$ diff-expr '\''a && (b || ((c >= d) != e))'\'' '\''a && (b || (c >= d) != e)'\'''
diff-expr 'a && (b || ((c >= d) != e))' 'a && (b || (c >= d) != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b || ((c >= d) != e))'\'' '\''a && (b || (c >= d) != e)'\'''

echo '$ diff-expr '\''a && (b || ((c >= d) != e))'\'' '\''a && (b || c >= d != e)'\'''
diff-expr 'a && (b || ((c >= d) != e))' 'a && (b || c >= d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b || ((c >= d) != e))'\'' '\''a && (b || c >= d != e)'\'''

echo '$ diff-expr '\''a && (b || ((c >= d) != e))'\'' '\''a && (b || (c >= d != e))'\'''
diff-expr 'a && (b || ((c >= d) != e))' 'a && (b || (c >= d != e))' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b || ((c >= d) != e))'\'' '\''a && (b || (c >= d != e))'\'''

echo '$ test-expr '\''((a && (b || c)) >= d) != e'\'''
test-expr '((a && (b || c)) >= d) != e' 2>&1 ||
echo 'command failed: test-expr '\''((a && (b || c)) >= d) != e'\'''

echo '$ diff-expr '\''((a && (b || c)) >= d) != e'\'' '\''(a && (b || c)) >= d != e'\'''
diff-expr '((a && (b || c)) >= d) != e' '(a && (b || c)) >= d != e' 2>&1 ||
echo 'command failed: diff-expr '\''((a && (b || c)) >= d) != e'\'' '\''(a && (b || c)) >= d != e'\'''

echo '$ test-expr '\''a && ((b || (c >= d)) != e)'\'''
test-expr 'a && ((b || (c >= d)) != e)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c >= d)) != e)'\'''

echo '$ diff-expr '\''a && ((b || (c >= d)) != e)'\'' '\''a && (b || (c >= d)) != e'\'''
diff-expr 'a && ((b || (c >= d)) != e)' 'a && (b || (c >= d)) != e' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b || (c >= d)) != e)'\'' '\''a && (b || (c >= d)) != e'\'''

echo '$ diff-expr '\''a && ((b || (c >= d)) != e)'\'' '\''a && (b || c >= d) != e'\'''
diff-expr 'a && ((b || (c >= d)) != e)' 'a && (b || c >= d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b || (c >= d)) != e)'\'' '\''a && (b || c >= d) != e'\'''

echo '$ diff-expr '\''a && ((b || (c >= d)) != e)'\'' '\''a && ((b || c >= d) != e)'\'''
diff-expr 'a && ((b || (c >= d)) != e)' 'a && ((b || c >= d) != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b || (c >= d)) != e)'\'' '\''a && ((b || c >= d) != e)'\'''

echo '$ test-expr '\''((a && b) || (c >= d)) != e'\'''
test-expr '((a && b) || (c >= d)) != e' 2>&1 ||
echo 'command failed: test-expr '\''((a && b) || (c >= d)) != e'\'''

echo '$ diff-expr '\''((a && b) || (c >= d)) != e'\'' '\''(a && b || (c >= d)) != e'\'''
diff-expr '((a && b) || (c >= d)) != e' '(a && b || (c >= d)) != e' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) || (c >= d)) != e'\'' '\''(a && b || (c >= d)) != e'\'''

echo '$ diff-expr '\''((a && b) || (c >= d)) != e'\'' '\''(a && b || c >= d) != e'\'''
diff-expr '((a && b) || (c >= d)) != e' '(a && b || c >= d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) || (c >= d)) != e'\'' '\''(a && b || c >= d) != e'\'''

echo '$ diff-expr '\''((a && b) || (c >= d)) != e'\'' '\''((a && b) || c >= d) != e'\'''
diff-expr '((a && b) || (c >= d)) != e' '((a && b) || c >= d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) || (c >= d)) != e'\'' '\''((a && b) || c >= d) != e'\'''

echo '$ test-expr '\''((a && b) || c) >= (d != e)'\'''
test-expr '((a && b) || c) >= (d != e)' 2>&1 ||
echo 'command failed: test-expr '\''((a && b) || c) >= (d != e)'\'''

echo '$ diff-expr '\''((a && b) || c) >= (d != e)'\'' '\''(a && b || c) >= (d != e)'\'''
diff-expr '((a && b) || c) >= (d != e)' '(a && b || c) >= (d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) || c) >= (d != e)'\'' '\''(a && b || c) >= (d != e)'\'''

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'''
test-expr 'a && ((b || c) >= (d != e))' 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'''

echo '$ diff-expr '\''a && ((b || c) >= (d != e))'\'' '\''a && (b || c) >= (d != e)'\'''
diff-expr 'a && ((b || c) >= (d != e))' 'a && (b || c) >= (d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b || c) >= (d != e))'\'' '\''a && (b || c) >= (d != e)'\'''

echo '$ test-expr '\''(a && (b || (c >= d))) != e'\'''
test-expr '(a && (b || (c >= d))) != e' 2>&1 ||
echo 'command failed: test-expr '\''(a && (b || (c >= d))) != e'\'''

echo '$ diff-expr '\''(a && (b || (c >= d))) != e'\'' '\''(a && (b || c >= d)) != e'\'''
diff-expr '(a && (b || (c >= d))) != e' '(a && (b || c >= d)) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b || (c >= d))) != e'\'' '\''(a && (b || c >= d)) != e'\'''

echo '$ test-expr '\''(a && (b || c)) >= (d != e)'\'''
test-expr '(a && (b || c)) >= (d != e)' 2>&1 ||
echo 'command failed: test-expr '\''(a && (b || c)) >= (d != e)'\'''

echo '$ test-expr '\''(a && b) || (c >= (d != e))'\'''
test-expr '(a && b) || (c >= (d != e))' 2>&1 ||
echo 'command failed: test-expr '\''(a && b) || (c >= (d != e))'\'''

echo '$ diff-expr '\''(a && b) || (c >= (d != e))'\'' '\''a && b || (c >= (d != e))'\'''
diff-expr '(a && b) || (c >= (d != e))' 'a && b || (c >= (d != e))' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (c >= (d != e))'\'' '\''a && b || (c >= (d != e))'\'''

echo '$ diff-expr '\''(a && b) || (c >= (d != e))'\'' '\''a && b || c >= (d != e)'\'''
diff-expr '(a && b) || (c >= (d != e))' 'a && b || c >= (d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (c >= (d != e))'\'' '\''a && b || c >= (d != e)'\'''

echo '$ diff-expr '\''(a && b) || (c >= (d != e))'\'' '\''(a && b) || c >= (d != e)'\'''
diff-expr '(a && b) || (c >= (d != e))' '(a && b) || c >= (d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (c >= (d != e))'\'' '\''(a && b) || c >= (d != e)'\'''

echo '$ test-expr '\''a && (b || (c >= (d != e)))'\'''
test-expr 'a && (b || (c >= (d != e)))' 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c >= (d != e)))'\'''

echo '$ diff-expr '\''a && (b || (c >= (d != e)))'\'' '\''a && (b || c >= (d != e))'\'''
diff-expr 'a && (b || (c >= (d != e)))' 'a && (b || c >= (d != e))' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b || (c >= (d != e)))'\'' '\''a && (b || c >= (d != e))'\'''

echo '$ test-expr '\''(((a && b) || c) != d) >= e'\'''
test-expr '(((a && b) || c) != d) >= e' 2>&1 ||
echo 'command failed: test-expr '\''(((a && b) || c) != d) >= e'\'''

echo '$ diff-expr '\''(((a && b) || c) != d) >= e'\'' '\''((a && b || c) != d) >= e'\'''
diff-expr '(((a && b) || c) != d) >= e' '((a && b || c) != d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a && b) || c) != d) >= e'\'' '\''((a && b || c) != d) >= e'\'''

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'''
test-expr 'a && (((b || c) != d) >= e)' 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'''

echo '$ diff-expr '\''a && (((b || c) != d) >= e)'\'' '\''a && ((b || c) != d) >= e'\'''
diff-expr 'a && (((b || c) != d) >= e)' 'a && ((b || c) != d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''a && (((b || c) != d) >= e)'\'' '\''a && ((b || c) != d) >= e'\'''

echo '$ test-expr '\''(a && ((b || c) != d)) >= e'\'''
test-expr '(a && ((b || c) != d)) >= e' 2>&1 ||
echo 'command failed: test-expr '\''(a && ((b || c) != d)) >= e'\'''

echo '$ diff-expr '\''(a && ((b || c) != d)) >= e'\'' '\''(a && (b || c) != d) >= e'\'''
diff-expr '(a && ((b || c) != d)) >= e' '(a && (b || c) != d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && ((b || c) != d)) >= e'\'' '\''(a && (b || c) != d) >= e'\'''

echo '$ test-expr '\''(a && b) || ((c != d) >= e)'\'''
test-expr '(a && b) || ((c != d) >= e)' 2>&1 ||
echo 'command failed: test-expr '\''(a && b) || ((c != d) >= e)'\'''

echo '$ diff-expr '\''(a && b) || ((c != d) >= e)'\'' '\''a && b || ((c != d) >= e)'\'''
diff-expr '(a && b) || ((c != d) >= e)' 'a && b || ((c != d) >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || ((c != d) >= e)'\'' '\''a && b || ((c != d) >= e)'\'''

echo '$ diff-expr '\''(a && b) || ((c != d) >= e)'\'' '\''a && b || (c != d) >= e'\'''
diff-expr '(a && b) || ((c != d) >= e)' 'a && b || (c != d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || ((c != d) >= e)'\'' '\''a && b || (c != d) >= e'\'''

echo '$ diff-expr '\''(a && b) || ((c != d) >= e)'\'' '\''(a && b) || (c != d) >= e'\'''
diff-expr '(a && b) || ((c != d) >= e)' '(a && b) || (c != d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || ((c != d) >= e)'\'' '\''(a && b) || (c != d) >= e'\'''

echo '$ test-expr '\''a && (b || ((c != d) >= e))'\'''
test-expr 'a && (b || ((c != d) >= e))' 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c != d) >= e))'\'''

echo '$ diff-expr '\''a && (b || ((c != d) >= e))'\'' '\''a && (b || (c != d) >= e)'\'''
diff-expr 'a && (b || ((c != d) >= e))' 'a && (b || (c != d) >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b || ((c != d) >= e))'\'' '\''a && (b || (c != d) >= e)'\'''

echo '$ test-expr '\''((a && (b || c)) != d) >= e'\'''
test-expr '((a && (b || c)) != d) >= e' 2>&1 ||
echo 'command failed: test-expr '\''((a && (b || c)) != d) >= e'\'''

echo '$ test-expr '\''a && ((b || (c != d)) >= e)'\'''
test-expr 'a && ((b || (c != d)) >= e)' 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c != d)) >= e)'\'''

echo '$ diff-expr '\''a && ((b || (c != d)) >= e)'\'' '\''a && (b || (c != d)) >= e'\'''
diff-expr 'a && ((b || (c != d)) >= e)' 'a && (b || (c != d)) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b || (c != d)) >= e)'\'' '\''a && (b || (c != d)) >= e'\'''

echo '$ diff-expr '\''a && ((b || (c != d)) >= e)'\'' '\''a && (b || c != d) >= e'\'''
diff-expr 'a && ((b || (c != d)) >= e)' 'a && (b || c != d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b || (c != d)) >= e)'\'' '\''a && (b || c != d) >= e'\'''

echo '$ diff-expr '\''a && ((b || (c != d)) >= e)'\'' '\''a && ((b || c != d) >= e)'\'''
diff-expr 'a && ((b || (c != d)) >= e)' 'a && ((b || c != d) >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b || (c != d)) >= e)'\'' '\''a && ((b || c != d) >= e)'\'''

echo '$ test-expr '\''((a && b) || (c != d)) >= e'\'''
test-expr '((a && b) || (c != d)) >= e' 2>&1 ||
echo 'command failed: test-expr '\''((a && b) || (c != d)) >= e'\'''

echo '$ diff-expr '\''((a && b) || (c != d)) >= e'\'' '\''(a && b || (c != d)) >= e'\'''
diff-expr '((a && b) || (c != d)) >= e' '(a && b || (c != d)) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) || (c != d)) >= e'\'' '\''(a && b || (c != d)) >= e'\'''

echo '$ diff-expr '\''((a && b) || (c != d)) >= e'\'' '\''(a && b || c != d) >= e'\'''
diff-expr '((a && b) || (c != d)) >= e' '(a && b || c != d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) || (c != d)) >= e'\'' '\''(a && b || c != d) >= e'\'''

echo '$ diff-expr '\''((a && b) || (c != d)) >= e'\'' '\''((a && b) || c != d) >= e'\'''
diff-expr '((a && b) || (c != d)) >= e' '((a && b) || c != d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) || (c != d)) >= e'\'' '\''((a && b) || c != d) >= e'\'''

echo '$ test-expr '\''((a && b) || c) != (d >= e)'\'''
test-expr '((a && b) || c) != (d >= e)' 2>&1 ||
echo 'command failed: test-expr '\''((a && b) || c) != (d >= e)'\'''

echo '$ diff-expr '\''((a && b) || c) != (d >= e)'\'' '\''(a && b || c) != (d >= e)'\'''
diff-expr '((a && b) || c) != (d >= e)' '(a && b || c) != (d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) || c) != (d >= e)'\'' '\''(a && b || c) != (d >= e)'\'''

echo '$ diff-expr '\''((a && b) || c) != (d >= e)'\'' '\''(a && b || c) != d >= e'\'''
diff-expr '((a && b) || c) != (d >= e)' '(a && b || c) != d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) || c) != (d >= e)'\'' '\''(a && b || c) != d >= e'\'''

echo '$ diff-expr '\''((a && b) || c) != (d >= e)'\'' '\''((a && b) || c) != d >= e'\'''
diff-expr '((a && b) || c) != (d >= e)' '((a && b) || c) != d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''((a && b) || c) != (d >= e)'\'' '\''((a && b) || c) != d >= e'\'''

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'''
test-expr 'a && ((b || c) != (d >= e))' 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'''

echo '$ diff-expr '\''a && ((b || c) != (d >= e))'\'' '\''a && (b || c) != (d >= e)'\'''
diff-expr 'a && ((b || c) != (d >= e))' 'a && (b || c) != (d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b || c) != (d >= e))'\'' '\''a && (b || c) != (d >= e)'\'''

echo '$ diff-expr '\''a && ((b || c) != (d >= e))'\'' '\''a && (b || c) != d >= e'\'''
diff-expr 'a && ((b || c) != (d >= e))' 'a && (b || c) != d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b || c) != (d >= e))'\'' '\''a && (b || c) != d >= e'\'''

echo '$ diff-expr '\''a && ((b || c) != (d >= e))'\'' '\''a && ((b || c) != d >= e)'\'''
diff-expr 'a && ((b || c) != (d >= e))' 'a && ((b || c) != d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && ((b || c) != (d >= e))'\'' '\''a && ((b || c) != d >= e)'\'''

echo '$ test-expr '\''(a && (b || (c != d))) >= e'\'''
test-expr '(a && (b || (c != d))) >= e' 2>&1 ||
echo 'command failed: test-expr '\''(a && (b || (c != d))) >= e'\'''

echo '$ diff-expr '\''(a && (b || (c != d))) >= e'\'' '\''(a && (b || c != d)) >= e'\'''
diff-expr '(a && (b || (c != d))) >= e' '(a && (b || c != d)) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b || (c != d))) >= e'\'' '\''(a && (b || c != d)) >= e'\'''

echo '$ test-expr '\''(a && (b || c)) != (d >= e)'\'''
test-expr '(a && (b || c)) != (d >= e)' 2>&1 ||
echo 'command failed: test-expr '\''(a && (b || c)) != (d >= e)'\'''

echo '$ diff-expr '\''(a && (b || c)) != (d >= e)'\'' '\''(a && (b || c)) != d >= e'\'''
diff-expr '(a && (b || c)) != (d >= e)' '(a && (b || c)) != d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && (b || c)) != (d >= e)'\'' '\''(a && (b || c)) != d >= e'\'''

echo '$ test-expr '\''(a && b) || (c != (d >= e))'\'''
test-expr '(a && b) || (c != (d >= e))' 2>&1 ||
echo 'command failed: test-expr '\''(a && b) || (c != (d >= e))'\'''

echo '$ diff-expr '\''(a && b) || (c != (d >= e))'\'' '\''a && b || (c != (d >= e))'\'''
diff-expr '(a && b) || (c != (d >= e))' 'a && b || (c != (d >= e))' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (c != (d >= e))'\'' '\''a && b || (c != (d >= e))'\'''

echo '$ diff-expr '\''(a && b) || (c != (d >= e))'\'' '\''a && b || c != (d >= e)'\'''
diff-expr '(a && b) || (c != (d >= e))' 'a && b || c != (d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (c != (d >= e))'\'' '\''a && b || c != (d >= e)'\'''

echo '$ diff-expr '\''(a && b) || (c != (d >= e))'\'' '\''a && b || c != d >= e'\'''
diff-expr '(a && b) || (c != (d >= e))' 'a && b || c != d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (c != (d >= e))'\'' '\''a && b || c != d >= e'\'''

echo '$ diff-expr '\''(a && b) || (c != (d >= e))'\'' '\''a && b || (c != d >= e)'\'''
diff-expr '(a && b) || (c != (d >= e))' 'a && b || (c != d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (c != (d >= e))'\'' '\''a && b || (c != d >= e)'\'''

echo '$ diff-expr '\''(a && b) || (c != (d >= e))'\'' '\''(a && b) || c != (d >= e)'\'''
diff-expr '(a && b) || (c != (d >= e))' '(a && b) || c != (d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (c != (d >= e))'\'' '\''(a && b) || c != (d >= e)'\'''

echo '$ diff-expr '\''(a && b) || (c != (d >= e))'\'' '\''(a && b) || c != d >= e'\'''
diff-expr '(a && b) || (c != (d >= e))' '(a && b) || c != d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (c != (d >= e))'\'' '\''(a && b) || c != d >= e'\'''

echo '$ diff-expr '\''(a && b) || (c != (d >= e))'\'' '\''(a && b) || (c != d >= e)'\'''
diff-expr '(a && b) || (c != (d >= e))' '(a && b) || (c != d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a && b) || (c != (d >= e))'\'' '\''(a && b) || (c != d >= e)'\'''

echo '$ test-expr '\''a && (b || (c != (d >= e)))'\'''
test-expr 'a && (b || (c != (d >= e)))' 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c != (d >= e)))'\'''

echo '$ diff-expr '\''a && (b || (c != (d >= e)))'\'' '\''a && (b || c != (d >= e))'\'''
diff-expr 'a && (b || (c != (d >= e)))' 'a && (b || c != (d >= e))' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b || (c != (d >= e)))'\'' '\''a && (b || c != (d >= e))'\'''

echo '$ diff-expr '\''a && (b || (c != (d >= e)))'\'' '\''a && (b || c != d >= e)'\'''
diff-expr 'a && (b || (c != (d >= e)))' 'a && (b || c != d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b || (c != (d >= e)))'\'' '\''a && (b || c != d >= e)'\'''

echo '$ diff-expr '\''a && (b || (c != (d >= e)))'\'' '\''a && (b || (c != d >= e))'\'''
diff-expr 'a && (b || (c != (d >= e)))' 'a && (b || (c != d >= e))' 2>&1 ||
echo 'command failed: diff-expr '\''a && (b || (c != (d >= e)))'\'' '\''a && (b || (c != d >= e))'\'''

echo '$ test-expr '\''(((a || b) >= c) != d) && e'\'''
test-expr '(((a || b) >= c) != d) && e' 2>&1 ||
echo 'command failed: test-expr '\''(((a || b) >= c) != d) && e'\'''

echo '$ diff-expr '\''(((a || b) >= c) != d) && e'\'' '\''((a || b) >= c) != d && e'\'''
diff-expr '(((a || b) >= c) != d) && e' '((a || b) >= c) != d && e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a || b) >= c) != d) && e'\'' '\''((a || b) >= c) != d && e'\'''

echo '$ diff-expr '\''(((a || b) >= c) != d) && e'\'' '\''(a || b) >= c != d && e'\'''
diff-expr '(((a || b) >= c) != d) && e' '(a || b) >= c != d && e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a || b) >= c) != d) && e'\'' '\''(a || b) >= c != d && e'\'''

echo '$ diff-expr '\''(((a || b) >= c) != d) && e'\'' '\''((a || b) >= c != d) && e'\'''
diff-expr '(((a || b) >= c) != d) && e' '((a || b) >= c != d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a || b) >= c) != d) && e'\'' '\''((a || b) >= c != d) && e'\'''

echo '$ test-expr '\''a || (((b >= c) != d) && e)'\'''
test-expr 'a || (((b >= c) != d) && e)' 2>&1 ||
echo 'command failed: test-expr '\''a || (((b >= c) != d) && e)'\'''

echo '$ diff-expr '\''a || (((b >= c) != d) && e)'\'' '\''a || ((b >= c) != d) && e'\'''
diff-expr 'a || (((b >= c) != d) && e)' 'a || ((b >= c) != d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''a || (((b >= c) != d) && e)'\'' '\''a || ((b >= c) != d) && e'\'''

echo '$ diff-expr '\''a || (((b >= c) != d) && e)'\'' '\''a || (b >= c) != d && e'\'''
diff-expr 'a || (((b >= c) != d) && e)' 'a || (b >= c) != d && e' 2>&1 ||
echo 'command failed: diff-expr '\''a || (((b >= c) != d) && e)'\'' '\''a || (b >= c) != d && e'\'''

echo '$ diff-expr '\''a || (((b >= c) != d) && e)'\'' '\''a || b >= c != d && e'\'''
diff-expr 'a || (((b >= c) != d) && e)' 'a || b >= c != d && e' 2>&1 ||
echo 'command failed: diff-expr '\''a || (((b >= c) != d) && e)'\'' '\''a || b >= c != d && e'\'''

echo '$ diff-expr '\''a || (((b >= c) != d) && e)'\'' '\''a || (b >= c != d) && e'\'''
diff-expr 'a || (((b >= c) != d) && e)' 'a || (b >= c != d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''a || (((b >= c) != d) && e)'\'' '\''a || (b >= c != d) && e'\'''

echo '$ diff-expr '\''a || (((b >= c) != d) && e)'\'' '\''a || ((b >= c) != d && e)'\'''
diff-expr 'a || (((b >= c) != d) && e)' 'a || ((b >= c) != d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || (((b >= c) != d) && e)'\'' '\''a || ((b >= c) != d && e)'\'''

echo '$ diff-expr '\''a || (((b >= c) != d) && e)'\'' '\''a || (b >= c != d && e)'\'''
diff-expr 'a || (((b >= c) != d) && e)' 'a || (b >= c != d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || (((b >= c) != d) && e)'\'' '\''a || (b >= c != d && e)'\'''

echo '$ diff-expr '\''a || (((b >= c) != d) && e)'\'' '\''a || ((b >= c != d) && e)'\'''
diff-expr 'a || (((b >= c) != d) && e)' 'a || ((b >= c != d) && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || (((b >= c) != d) && e)'\'' '\''a || ((b >= c != d) && e)'\'''

echo '$ test-expr '\''(a || ((b >= c) != d)) && e'\'''
test-expr '(a || ((b >= c) != d)) && e' 2>&1 ||
echo 'command failed: test-expr '\''(a || ((b >= c) != d)) && e'\'''

echo '$ diff-expr '\''(a || ((b >= c) != d)) && e'\'' '\''(a || (b >= c) != d) && e'\'''
diff-expr '(a || ((b >= c) != d)) && e' '(a || (b >= c) != d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || ((b >= c) != d)) && e'\'' '\''(a || (b >= c) != d) && e'\'''

echo '$ diff-expr '\''(a || ((b >= c) != d)) && e'\'' '\''(a || b >= c != d) && e'\'''
diff-expr '(a || ((b >= c) != d)) && e' '(a || b >= c != d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || ((b >= c) != d)) && e'\'' '\''(a || b >= c != d) && e'\'''

echo '$ diff-expr '\''(a || ((b >= c) != d)) && e'\'' '\''(a || (b >= c != d)) && e'\'''
diff-expr '(a || ((b >= c) != d)) && e' '(a || (b >= c != d)) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || ((b >= c) != d)) && e'\'' '\''(a || (b >= c != d)) && e'\'''

echo '$ test-expr '\''(a || b) >= ((c != d) && e)'\'''
test-expr '(a || b) >= ((c != d) && e)' 2>&1 ||
echo 'command failed: test-expr '\''(a || b) >= ((c != d) && e)'\'''

echo '$ diff-expr '\''(a || b) >= ((c != d) && e)'\'' '\''(a || b) >= (c != d && e)'\'''
diff-expr '(a || b) >= ((c != d) && e)' '(a || b) >= (c != d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a || b) >= ((c != d) && e)'\'' '\''(a || b) >= (c != d && e)'\'''

echo '$ test-expr '\''a || (b >= ((c != d) && e))'\'''
test-expr 'a || (b >= ((c != d) && e))' 2>&1 ||
echo 'command failed: test-expr '\''a || (b >= ((c != d) && e))'\'''

echo '$ diff-expr '\''a || (b >= ((c != d) && e))'\'' '\''a || b >= ((c != d) && e)'\'''
diff-expr 'a || (b >= ((c != d) && e))' 'a || b >= ((c != d) && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b >= ((c != d) && e))'\'' '\''a || b >= ((c != d) && e)'\'''

echo '$ diff-expr '\''a || (b >= ((c != d) && e))'\'' '\''a || b >= (c != d && e)'\'''
diff-expr 'a || (b >= ((c != d) && e))' 'a || b >= (c != d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b >= ((c != d) && e))'\'' '\''a || b >= (c != d && e)'\'''

echo '$ diff-expr '\''a || (b >= ((c != d) && e))'\'' '\''a || (b >= (c != d && e))'\'''
diff-expr 'a || (b >= ((c != d) && e))' 'a || (b >= (c != d && e))' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b >= ((c != d) && e))'\'' '\''a || (b >= (c != d && e))'\'''

echo '$ test-expr '\''((a || (b >= c)) != d) && e'\'''
test-expr '((a || (b >= c)) != d) && e' 2>&1 ||
echo 'command failed: test-expr '\''((a || (b >= c)) != d) && e'\'''

echo '$ diff-expr '\''((a || (b >= c)) != d) && e'\'' '\''(a || (b >= c)) != d && e'\'''
diff-expr '((a || (b >= c)) != d) && e' '(a || (b >= c)) != d && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a || (b >= c)) != d) && e'\'' '\''(a || (b >= c)) != d && e'\'''

echo '$ diff-expr '\''((a || (b >= c)) != d) && e'\'' '\''(a || b >= c) != d && e'\'''
diff-expr '((a || (b >= c)) != d) && e' '(a || b >= c) != d && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a || (b >= c)) != d) && e'\'' '\''(a || b >= c) != d && e'\'''

echo '$ diff-expr '\''((a || (b >= c)) != d) && e'\'' '\''((a || b >= c) != d) && e'\'''
diff-expr '((a || (b >= c)) != d) && e' '((a || b >= c) != d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a || (b >= c)) != d) && e'\'' '\''((a || b >= c) != d) && e'\'''

echo '$ test-expr '\''a || ((b >= (c != d)) && e)'\'''
test-expr 'a || ((b >= (c != d)) && e)' 2>&1 ||
echo 'command failed: test-expr '\''a || ((b >= (c != d)) && e)'\'''

echo '$ diff-expr '\''a || ((b >= (c != d)) && e)'\'' '\''a || (b >= (c != d)) && e'\'''
diff-expr 'a || ((b >= (c != d)) && e)' 'a || (b >= (c != d)) && e' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b >= (c != d)) && e)'\'' '\''a || (b >= (c != d)) && e'\'''

echo '$ diff-expr '\''a || ((b >= (c != d)) && e)'\'' '\''a || b >= (c != d) && e'\'''
diff-expr 'a || ((b >= (c != d)) && e)' 'a || b >= (c != d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b >= (c != d)) && e)'\'' '\''a || b >= (c != d) && e'\'''

echo '$ diff-expr '\''a || ((b >= (c != d)) && e)'\'' '\''a || (b >= (c != d) && e)'\'''
diff-expr 'a || ((b >= (c != d)) && e)' 'a || (b >= (c != d) && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b >= (c != d)) && e)'\'' '\''a || (b >= (c != d) && e)'\'''

echo '$ test-expr '\''((a || b) >= (c != d)) && e'\'''
test-expr '((a || b) >= (c != d)) && e' 2>&1 ||
echo 'command failed: test-expr '\''((a || b) >= (c != d)) && e'\'''

echo '$ diff-expr '\''((a || b) >= (c != d)) && e'\'' '\''(a || b) >= (c != d) && e'\'''
diff-expr '((a || b) >= (c != d)) && e' '(a || b) >= (c != d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a || b) >= (c != d)) && e'\'' '\''(a || b) >= (c != d) && e'\'''

echo '$ test-expr '\''((a || b) >= c) != (d && e)'\'''
test-expr '((a || b) >= c) != (d && e)' 2>&1 ||
echo 'command failed: test-expr '\''((a || b) >= c) != (d && e)'\'''

echo '$ diff-expr '\''((a || b) >= c) != (d && e)'\'' '\''(a || b) >= c != (d && e)'\'''
diff-expr '((a || b) >= c) != (d && e)' '(a || b) >= c != (d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''((a || b) >= c) != (d && e)'\'' '\''(a || b) >= c != (d && e)'\'''

echo '$ test-expr '\''a || ((b >= c) != (d && e))'\'''
test-expr 'a || ((b >= c) != (d && e))' 2>&1 ||
echo 'command failed: test-expr '\''a || ((b >= c) != (d && e))'\'''

echo '$ diff-expr '\''a || ((b >= c) != (d && e))'\'' '\''a || (b >= c) != (d && e)'\'''
diff-expr 'a || ((b >= c) != (d && e))' 'a || (b >= c) != (d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b >= c) != (d && e))'\'' '\''a || (b >= c) != (d && e)'\'''

echo '$ diff-expr '\''a || ((b >= c) != (d && e))'\'' '\''a || b >= c != (d && e)'\'''
diff-expr 'a || ((b >= c) != (d && e))' 'a || b >= c != (d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b >= c) != (d && e))'\'' '\''a || b >= c != (d && e)'\'''

echo '$ diff-expr '\''a || ((b >= c) != (d && e))'\'' '\''a || (b >= c != (d && e))'\'''
diff-expr 'a || ((b >= c) != (d && e))' 'a || (b >= c != (d && e))' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b >= c) != (d && e))'\'' '\''a || (b >= c != (d && e))'\'''

echo '$ test-expr '\''(a || (b >= (c != d))) && e'\'''
test-expr '(a || (b >= (c != d))) && e' 2>&1 ||
echo 'command failed: test-expr '\''(a || (b >= (c != d))) && e'\'''

echo '$ diff-expr '\''(a || (b >= (c != d))) && e'\'' '\''(a || b >= (c != d)) && e'\'''
diff-expr '(a || (b >= (c != d))) && e' '(a || b >= (c != d)) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || (b >= (c != d))) && e'\'' '\''(a || b >= (c != d)) && e'\'''

echo '$ test-expr '\''(a || (b >= c)) != (d && e)'\'''
test-expr '(a || (b >= c)) != (d && e)' 2>&1 ||
echo 'command failed: test-expr '\''(a || (b >= c)) != (d && e)'\'''

echo '$ diff-expr '\''(a || (b >= c)) != (d && e)'\'' '\''(a || b >= c) != (d && e)'\'''
diff-expr '(a || (b >= c)) != (d && e)' '(a || b >= c) != (d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a || (b >= c)) != (d && e)'\'' '\''(a || b >= c) != (d && e)'\'''

echo '$ test-expr '\''(a || b) >= (c != (d && e))'\'''
test-expr '(a || b) >= (c != (d && e))' 2>&1 ||
echo 'command failed: test-expr '\''(a || b) >= (c != (d && e))'\'''

echo '$ test-expr '\''a || (b >= (c != (d && e)))'\'''
test-expr 'a || (b >= (c != (d && e)))' 2>&1 ||
echo 'command failed: test-expr '\''a || (b >= (c != (d && e)))'\'''

echo '$ diff-expr '\''a || (b >= (c != (d && e)))'\'' '\''a || b >= (c != (d && e))'\'''
diff-expr 'a || (b >= (c != (d && e)))' 'a || b >= (c != (d && e))' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b >= (c != (d && e)))'\'' '\''a || b >= (c != (d && e))'\'''

echo '$ test-expr '\''(((a || b) >= c) && d) != e'\'''
test-expr '(((a || b) >= c) && d) != e' 2>&1 ||
echo 'command failed: test-expr '\''(((a || b) >= c) && d) != e'\'''

echo '$ diff-expr '\''(((a || b) >= c) && d) != e'\'' '\''((a || b) >= c && d) != e'\'''
diff-expr '(((a || b) >= c) && d) != e' '((a || b) >= c && d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a || b) >= c) && d) != e'\'' '\''((a || b) >= c && d) != e'\'''

echo '$ test-expr '\''a || (((b >= c) && d) != e)'\'''
test-expr 'a || (((b >= c) && d) != e)' 2>&1 ||
echo 'command failed: test-expr '\''a || (((b >= c) && d) != e)'\'''

echo '$ diff-expr '\''a || (((b >= c) && d) != e)'\'' '\''a || ((b >= c) && d) != e'\'''
diff-expr 'a || (((b >= c) && d) != e)' 'a || ((b >= c) && d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''a || (((b >= c) && d) != e)'\'' '\''a || ((b >= c) && d) != e'\'''

echo '$ diff-expr '\''a || (((b >= c) && d) != e)'\'' '\''a || (b >= c && d) != e'\'''
diff-expr 'a || (((b >= c) && d) != e)' 'a || (b >= c && d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''a || (((b >= c) && d) != e)'\'' '\''a || (b >= c && d) != e'\'''

echo '$ diff-expr '\''a || (((b >= c) && d) != e)'\'' '\''a || ((b >= c && d) != e)'\'''
diff-expr 'a || (((b >= c) && d) != e)' 'a || ((b >= c && d) != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || (((b >= c) && d) != e)'\'' '\''a || ((b >= c && d) != e)'\'''

echo '$ test-expr '\''(a || ((b >= c) && d)) != e'\'''
test-expr '(a || ((b >= c) && d)) != e' 2>&1 ||
echo 'command failed: test-expr '\''(a || ((b >= c) && d)) != e'\'''

echo '$ diff-expr '\''(a || ((b >= c) && d)) != e'\'' '\''(a || (b >= c) && d) != e'\'''
diff-expr '(a || ((b >= c) && d)) != e' '(a || (b >= c) && d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || ((b >= c) && d)) != e'\'' '\''(a || (b >= c) && d) != e'\'''

echo '$ diff-expr '\''(a || ((b >= c) && d)) != e'\'' '\''(a || b >= c && d) != e'\'''
diff-expr '(a || ((b >= c) && d)) != e' '(a || b >= c && d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || ((b >= c) && d)) != e'\'' '\''(a || b >= c && d) != e'\'''

echo '$ diff-expr '\''(a || ((b >= c) && d)) != e'\'' '\''(a || (b >= c && d)) != e'\'''
diff-expr '(a || ((b >= c) && d)) != e' '(a || (b >= c && d)) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || ((b >= c) && d)) != e'\'' '\''(a || (b >= c && d)) != e'\'''

echo '$ test-expr '\''(a || b) >= ((c && d) != e)'\'''
test-expr '(a || b) >= ((c && d) != e)' 2>&1 ||
echo 'command failed: test-expr '\''(a || b) >= ((c && d) != e)'\'''

echo '$ test-expr '\''a || (b >= ((c && d) != e))'\'''
test-expr 'a || (b >= ((c && d) != e))' 2>&1 ||
echo 'command failed: test-expr '\''a || (b >= ((c && d) != e))'\'''

echo '$ diff-expr '\''a || (b >= ((c && d) != e))'\'' '\''a || b >= ((c && d) != e)'\'''
diff-expr 'a || (b >= ((c && d) != e))' 'a || b >= ((c && d) != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b >= ((c && d) != e))'\'' '\''a || b >= ((c && d) != e)'\'''

echo '$ test-expr '\''((a || (b >= c)) && d) != e'\'''
test-expr '((a || (b >= c)) && d) != e' 2>&1 ||
echo 'command failed: test-expr '\''((a || (b >= c)) && d) != e'\'''

echo '$ diff-expr '\''((a || (b >= c)) && d) != e'\'' '\''((a || b >= c) && d) != e'\'''
diff-expr '((a || (b >= c)) && d) != e' '((a || b >= c) && d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''((a || (b >= c)) && d) != e'\'' '\''((a || b >= c) && d) != e'\'''

echo '$ test-expr '\''a || ((b >= (c && d)) != e)'\'''
test-expr 'a || ((b >= (c && d)) != e)' 2>&1 ||
echo 'command failed: test-expr '\''a || ((b >= (c && d)) != e)'\'''

echo '$ diff-expr '\''a || ((b >= (c && d)) != e)'\'' '\''a || (b >= (c && d)) != e'\'''
diff-expr 'a || ((b >= (c && d)) != e)' 'a || (b >= (c && d)) != e' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b >= (c && d)) != e)'\'' '\''a || (b >= (c && d)) != e'\'''

echo '$ diff-expr '\''a || ((b >= (c && d)) != e)'\'' '\''a || b >= (c && d) != e'\'''
diff-expr 'a || ((b >= (c && d)) != e)' 'a || b >= (c && d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b >= (c && d)) != e)'\'' '\''a || b >= (c && d) != e'\'''

echo '$ diff-expr '\''a || ((b >= (c && d)) != e)'\'' '\''a || (b >= (c && d) != e)'\'''
diff-expr 'a || ((b >= (c && d)) != e)' 'a || (b >= (c && d) != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b >= (c && d)) != e)'\'' '\''a || (b >= (c && d) != e)'\'''

echo '$ test-expr '\''((a || b) >= (c && d)) != e'\'''
test-expr '((a || b) >= (c && d)) != e' 2>&1 ||
echo 'command failed: test-expr '\''((a || b) >= (c && d)) != e'\'''

echo '$ diff-expr '\''((a || b) >= (c && d)) != e'\'' '\''(a || b) >= (c && d) != e'\'''
diff-expr '((a || b) >= (c && d)) != e' '(a || b) >= (c && d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''((a || b) >= (c && d)) != e'\'' '\''(a || b) >= (c && d) != e'\'''

echo '$ test-expr '\''((a || b) >= c) && (d != e)'\'''
test-expr '((a || b) >= c) && (d != e)' 2>&1 ||
echo 'command failed: test-expr '\''((a || b) >= c) && (d != e)'\'''

echo '$ diff-expr '\''((a || b) >= c) && (d != e)'\'' '\''(a || b) >= c && (d != e)'\'''
diff-expr '((a || b) >= c) && (d != e)' '(a || b) >= c && (d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''((a || b) >= c) && (d != e)'\'' '\''(a || b) >= c && (d != e)'\'''

echo '$ diff-expr '\''((a || b) >= c) && (d != e)'\'' '\''(a || b) >= c && d != e'\'''
diff-expr '((a || b) >= c) && (d != e)' '(a || b) >= c && d != e' 2>&1 ||
echo 'command failed: diff-expr '\''((a || b) >= c) && (d != e)'\'' '\''(a || b) >= c && d != e'\'''

echo '$ diff-expr '\''((a || b) >= c) && (d != e)'\'' '\''((a || b) >= c) && d != e'\'''
diff-expr '((a || b) >= c) && (d != e)' '((a || b) >= c) && d != e' 2>&1 ||
echo 'command failed: diff-expr '\''((a || b) >= c) && (d != e)'\'' '\''((a || b) >= c) && d != e'\'''

echo '$ test-expr '\''a || ((b >= c) && (d != e))'\'''
test-expr 'a || ((b >= c) && (d != e))' 2>&1 ||
echo 'command failed: test-expr '\''a || ((b >= c) && (d != e))'\'''

echo '$ diff-expr '\''a || ((b >= c) && (d != e))'\'' '\''a || (b >= c) && (d != e)'\'''
diff-expr 'a || ((b >= c) && (d != e))' 'a || (b >= c) && (d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b >= c) && (d != e))'\'' '\''a || (b >= c) && (d != e)'\'''

echo '$ diff-expr '\''a || ((b >= c) && (d != e))'\'' '\''a || b >= c && (d != e)'\'''
diff-expr 'a || ((b >= c) && (d != e))' 'a || b >= c && (d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b >= c) && (d != e))'\'' '\''a || b >= c && (d != e)'\'''

echo '$ diff-expr '\''a || ((b >= c) && (d != e))'\'' '\''a || b >= c && d != e'\'''
diff-expr 'a || ((b >= c) && (d != e))' 'a || b >= c && d != e' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b >= c) && (d != e))'\'' '\''a || b >= c && d != e'\'''

echo '$ diff-expr '\''a || ((b >= c) && (d != e))'\'' '\''a || (b >= c) && d != e'\'''
diff-expr 'a || ((b >= c) && (d != e))' 'a || (b >= c) && d != e' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b >= c) && (d != e))'\'' '\''a || (b >= c) && d != e'\'''

echo '$ diff-expr '\''a || ((b >= c) && (d != e))'\'' '\''a || (b >= c && (d != e))'\'''
diff-expr 'a || ((b >= c) && (d != e))' 'a || (b >= c && (d != e))' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b >= c) && (d != e))'\'' '\''a || (b >= c && (d != e))'\'''

echo '$ diff-expr '\''a || ((b >= c) && (d != e))'\'' '\''a || (b >= c && d != e)'\'''
diff-expr 'a || ((b >= c) && (d != e))' 'a || (b >= c && d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b >= c) && (d != e))'\'' '\''a || (b >= c && d != e)'\'''

echo '$ diff-expr '\''a || ((b >= c) && (d != e))'\'' '\''a || ((b >= c) && d != e)'\'''
diff-expr 'a || ((b >= c) && (d != e))' 'a || ((b >= c) && d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b >= c) && (d != e))'\'' '\''a || ((b >= c) && d != e)'\'''

echo '$ test-expr '\''(a || (b >= (c && d))) != e'\'''
test-expr '(a || (b >= (c && d))) != e' 2>&1 ||
echo 'command failed: test-expr '\''(a || (b >= (c && d))) != e'\'''

echo '$ diff-expr '\''(a || (b >= (c && d))) != e'\'' '\''(a || b >= (c && d)) != e'\'''
diff-expr '(a || (b >= (c && d))) != e' '(a || b >= (c && d)) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || (b >= (c && d))) != e'\'' '\''(a || b >= (c && d)) != e'\'''

echo '$ test-expr '\''(a || (b >= c)) && (d != e)'\'''
test-expr '(a || (b >= c)) && (d != e)' 2>&1 ||
echo 'command failed: test-expr '\''(a || (b >= c)) && (d != e)'\'''

echo '$ diff-expr '\''(a || (b >= c)) && (d != e)'\'' '\''(a || b >= c) && (d != e)'\'''
diff-expr '(a || (b >= c)) && (d != e)' '(a || b >= c) && (d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a || (b >= c)) && (d != e)'\'' '\''(a || b >= c) && (d != e)'\'''

echo '$ diff-expr '\''(a || (b >= c)) && (d != e)'\'' '\''(a || b >= c) && d != e'\'''
diff-expr '(a || (b >= c)) && (d != e)' '(a || b >= c) && d != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || (b >= c)) && (d != e)'\'' '\''(a || b >= c) && d != e'\'''

echo '$ diff-expr '\''(a || (b >= c)) && (d != e)'\'' '\''(a || (b >= c)) && d != e'\'''
diff-expr '(a || (b >= c)) && (d != e)' '(a || (b >= c)) && d != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || (b >= c)) && (d != e)'\'' '\''(a || (b >= c)) && d != e'\'''

echo '$ test-expr '\''(a || b) >= (c && (d != e))'\'''
test-expr '(a || b) >= (c && (d != e))' 2>&1 ||
echo 'command failed: test-expr '\''(a || b) >= (c && (d != e))'\'''

echo '$ diff-expr '\''(a || b) >= (c && (d != e))'\'' '\''(a || b) >= (c && d != e)'\'''
diff-expr '(a || b) >= (c && (d != e))' '(a || b) >= (c && d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a || b) >= (c && (d != e))'\'' '\''(a || b) >= (c && d != e)'\'''

echo '$ test-expr '\''a || (b >= (c && (d != e)))'\'''
test-expr 'a || (b >= (c && (d != e)))' 2>&1 ||
echo 'command failed: test-expr '\''a || (b >= (c && (d != e)))'\'''

echo '$ diff-expr '\''a || (b >= (c && (d != e)))'\'' '\''a || b >= (c && (d != e))'\'''
diff-expr 'a || (b >= (c && (d != e)))' 'a || b >= (c && (d != e))' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b >= (c && (d != e)))'\'' '\''a || b >= (c && (d != e))'\'''

echo '$ diff-expr '\''a || (b >= (c && (d != e)))'\'' '\''a || b >= (c && d != e)'\'''
diff-expr 'a || (b >= (c && (d != e)))' 'a || b >= (c && d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b >= (c && (d != e)))'\'' '\''a || b >= (c && d != e)'\'''

echo '$ diff-expr '\''a || (b >= (c && (d != e)))'\'' '\''a || (b >= (c && d != e))'\'''
diff-expr 'a || (b >= (c && (d != e)))' 'a || (b >= (c && d != e))' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b >= (c && (d != e)))'\'' '\''a || (b >= (c && d != e))'\'''

echo '$ test-expr '\''(((a || b) != c) >= d) && e'\'''
test-expr '(((a || b) != c) >= d) && e' 2>&1 ||
echo 'command failed: test-expr '\''(((a || b) != c) >= d) && e'\'''

echo '$ diff-expr '\''(((a || b) != c) >= d) && e'\'' '\''((a || b) != c) >= d && e'\'''
diff-expr '(((a || b) != c) >= d) && e' '((a || b) != c) >= d && e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a || b) != c) >= d) && e'\'' '\''((a || b) != c) >= d && e'\'''

echo '$ test-expr '\''a || (((b != c) >= d) && e)'\'''
test-expr 'a || (((b != c) >= d) && e)' 2>&1 ||
echo 'command failed: test-expr '\''a || (((b != c) >= d) && e)'\'''

echo '$ diff-expr '\''a || (((b != c) >= d) && e)'\'' '\''a || ((b != c) >= d) && e'\'''
diff-expr 'a || (((b != c) >= d) && e)' 'a || ((b != c) >= d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''a || (((b != c) >= d) && e)'\'' '\''a || ((b != c) >= d) && e'\'''

echo '$ diff-expr '\''a || (((b != c) >= d) && e)'\'' '\''a || (b != c) >= d && e'\'''
diff-expr 'a || (((b != c) >= d) && e)' 'a || (b != c) >= d && e' 2>&1 ||
echo 'command failed: diff-expr '\''a || (((b != c) >= d) && e)'\'' '\''a || (b != c) >= d && e'\'''

echo '$ diff-expr '\''a || (((b != c) >= d) && e)'\'' '\''a || ((b != c) >= d && e)'\'''
diff-expr 'a || (((b != c) >= d) && e)' 'a || ((b != c) >= d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || (((b != c) >= d) && e)'\'' '\''a || ((b != c) >= d && e)'\'''

echo '$ test-expr '\''(a || ((b != c) >= d)) && e'\'''
test-expr '(a || ((b != c) >= d)) && e' 2>&1 ||
echo 'command failed: test-expr '\''(a || ((b != c) >= d)) && e'\'''

echo '$ diff-expr '\''(a || ((b != c) >= d)) && e'\'' '\''(a || (b != c) >= d) && e'\'''
diff-expr '(a || ((b != c) >= d)) && e' '(a || (b != c) >= d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || ((b != c) >= d)) && e'\'' '\''(a || (b != c) >= d) && e'\'''

echo '$ test-expr '\''(a || b) != ((c >= d) && e)'\'''
test-expr '(a || b) != ((c >= d) && e)' 2>&1 ||
echo 'command failed: test-expr '\''(a || b) != ((c >= d) && e)'\'''

echo '$ diff-expr '\''(a || b) != ((c >= d) && e)'\'' '\''(a || b) != (c >= d && e)'\'''
diff-expr '(a || b) != ((c >= d) && e)' '(a || b) != (c >= d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a || b) != ((c >= d) && e)'\'' '\''(a || b) != (c >= d && e)'\'''

echo '$ test-expr '\''a || (b != ((c >= d) && e))'\'''
test-expr 'a || (b != ((c >= d) && e))' 2>&1 ||
echo 'command failed: test-expr '\''a || (b != ((c >= d) && e))'\'''

echo '$ diff-expr '\''a || (b != ((c >= d) && e))'\'' '\''a || b != ((c >= d) && e)'\'''
diff-expr 'a || (b != ((c >= d) && e))' 'a || b != ((c >= d) && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b != ((c >= d) && e))'\'' '\''a || b != ((c >= d) && e)'\'''

echo '$ diff-expr '\''a || (b != ((c >= d) && e))'\'' '\''a || b != (c >= d && e)'\'''
diff-expr 'a || (b != ((c >= d) && e))' 'a || b != (c >= d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b != ((c >= d) && e))'\'' '\''a || b != (c >= d && e)'\'''

echo '$ diff-expr '\''a || (b != ((c >= d) && e))'\'' '\''a || (b != (c >= d && e))'\'''
diff-expr 'a || (b != ((c >= d) && e))' 'a || (b != (c >= d && e))' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b != ((c >= d) && e))'\'' '\''a || (b != (c >= d && e))'\'''

echo '$ test-expr '\''((a || (b != c)) >= d) && e'\'''
test-expr '((a || (b != c)) >= d) && e' 2>&1 ||
echo 'command failed: test-expr '\''((a || (b != c)) >= d) && e'\'''

echo '$ diff-expr '\''((a || (b != c)) >= d) && e'\'' '\''(a || (b != c)) >= d && e'\'''
diff-expr '((a || (b != c)) >= d) && e' '(a || (b != c)) >= d && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a || (b != c)) >= d) && e'\'' '\''(a || (b != c)) >= d && e'\'''

echo '$ diff-expr '\''((a || (b != c)) >= d) && e'\'' '\''(a || b != c) >= d && e'\'''
diff-expr '((a || (b != c)) >= d) && e' '(a || b != c) >= d && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a || (b != c)) >= d) && e'\'' '\''(a || b != c) >= d && e'\'''

echo '$ diff-expr '\''((a || (b != c)) >= d) && e'\'' '\''((a || b != c) >= d) && e'\'''
diff-expr '((a || (b != c)) >= d) && e' '((a || b != c) >= d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a || (b != c)) >= d) && e'\'' '\''((a || b != c) >= d) && e'\'''

echo '$ test-expr '\''a || ((b != (c >= d)) && e)'\'''
test-expr 'a || ((b != (c >= d)) && e)' 2>&1 ||
echo 'command failed: test-expr '\''a || ((b != (c >= d)) && e)'\'''

echo '$ diff-expr '\''a || ((b != (c >= d)) && e)'\'' '\''a || (b != (c >= d)) && e'\'''
diff-expr 'a || ((b != (c >= d)) && e)' 'a || (b != (c >= d)) && e' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b != (c >= d)) && e)'\'' '\''a || (b != (c >= d)) && e'\'''

echo '$ diff-expr '\''a || ((b != (c >= d)) && e)'\'' '\''a || b != (c >= d) && e'\'''
diff-expr 'a || ((b != (c >= d)) && e)' 'a || b != (c >= d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b != (c >= d)) && e)'\'' '\''a || b != (c >= d) && e'\'''

echo '$ diff-expr '\''a || ((b != (c >= d)) && e)'\'' '\''a || b != c >= d && e'\'''
diff-expr 'a || ((b != (c >= d)) && e)' 'a || b != c >= d && e' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b != (c >= d)) && e)'\'' '\''a || b != c >= d && e'\'''

echo '$ diff-expr '\''a || ((b != (c >= d)) && e)'\'' '\''a || (b != c >= d) && e'\'''
diff-expr 'a || ((b != (c >= d)) && e)' 'a || (b != c >= d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b != (c >= d)) && e)'\'' '\''a || (b != c >= d) && e'\'''

echo '$ diff-expr '\''a || ((b != (c >= d)) && e)'\'' '\''a || (b != (c >= d) && e)'\'''
diff-expr 'a || ((b != (c >= d)) && e)' 'a || (b != (c >= d) && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b != (c >= d)) && e)'\'' '\''a || (b != (c >= d) && e)'\'''

echo '$ diff-expr '\''a || ((b != (c >= d)) && e)'\'' '\''a || (b != c >= d && e)'\'''
diff-expr 'a || ((b != (c >= d)) && e)' 'a || (b != c >= d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b != (c >= d)) && e)'\'' '\''a || (b != c >= d && e)'\'''

echo '$ diff-expr '\''a || ((b != (c >= d)) && e)'\'' '\''a || ((b != c >= d) && e)'\'''
diff-expr 'a || ((b != (c >= d)) && e)' 'a || ((b != c >= d) && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b != (c >= d)) && e)'\'' '\''a || ((b != c >= d) && e)'\'''

echo '$ test-expr '\''((a || b) != (c >= d)) && e'\'''
test-expr '((a || b) != (c >= d)) && e' 2>&1 ||
echo 'command failed: test-expr '\''((a || b) != (c >= d)) && e'\'''

echo '$ diff-expr '\''((a || b) != (c >= d)) && e'\'' '\''(a || b) != (c >= d) && e'\'''
diff-expr '((a || b) != (c >= d)) && e' '(a || b) != (c >= d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a || b) != (c >= d)) && e'\'' '\''(a || b) != (c >= d) && e'\'''

echo '$ diff-expr '\''((a || b) != (c >= d)) && e'\'' '\''(a || b) != c >= d && e'\'''
diff-expr '((a || b) != (c >= d)) && e' '(a || b) != c >= d && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a || b) != (c >= d)) && e'\'' '\''(a || b) != c >= d && e'\'''

echo '$ diff-expr '\''((a || b) != (c >= d)) && e'\'' '\''((a || b) != c >= d) && e'\'''
diff-expr '((a || b) != (c >= d)) && e' '((a || b) != c >= d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''((a || b) != (c >= d)) && e'\'' '\''((a || b) != c >= d) && e'\'''

echo '$ test-expr '\''((a || b) != c) >= (d && e)'\'''
test-expr '((a || b) != c) >= (d && e)' 2>&1 ||
echo 'command failed: test-expr '\''((a || b) != c) >= (d && e)'\'''

echo '$ test-expr '\''a || ((b != c) >= (d && e))'\'''
test-expr 'a || ((b != c) >= (d && e))' 2>&1 ||
echo 'command failed: test-expr '\''a || ((b != c) >= (d && e))'\'''

echo '$ diff-expr '\''a || ((b != c) >= (d && e))'\'' '\''a || (b != c) >= (d && e)'\'''
diff-expr 'a || ((b != c) >= (d && e))' 'a || (b != c) >= (d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b != c) >= (d && e))'\'' '\''a || (b != c) >= (d && e)'\'''

echo '$ test-expr '\''(a || (b != (c >= d))) && e'\'''
test-expr '(a || (b != (c >= d))) && e' 2>&1 ||
echo 'command failed: test-expr '\''(a || (b != (c >= d))) && e'\'''

echo '$ diff-expr '\''(a || (b != (c >= d))) && e'\'' '\''(a || b != (c >= d)) && e'\'''
diff-expr '(a || (b != (c >= d))) && e' '(a || b != (c >= d)) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || (b != (c >= d))) && e'\'' '\''(a || b != (c >= d)) && e'\'''

echo '$ diff-expr '\''(a || (b != (c >= d))) && e'\'' '\''(a || b != c >= d) && e'\'''
diff-expr '(a || (b != (c >= d))) && e' '(a || b != c >= d) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || (b != (c >= d))) && e'\'' '\''(a || b != c >= d) && e'\'''

echo '$ diff-expr '\''(a || (b != (c >= d))) && e'\'' '\''(a || (b != c >= d)) && e'\'''
diff-expr '(a || (b != (c >= d))) && e' '(a || (b != c >= d)) && e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || (b != (c >= d))) && e'\'' '\''(a || (b != c >= d)) && e'\'''

echo '$ test-expr '\''(a || (b != c)) >= (d && e)'\'''
test-expr '(a || (b != c)) >= (d && e)' 2>&1 ||
echo 'command failed: test-expr '\''(a || (b != c)) >= (d && e)'\'''

echo '$ diff-expr '\''(a || (b != c)) >= (d && e)'\'' '\''(a || b != c) >= (d && e)'\'''
diff-expr '(a || (b != c)) >= (d && e)' '(a || b != c) >= (d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a || (b != c)) >= (d && e)'\'' '\''(a || b != c) >= (d && e)'\'''

echo '$ test-expr '\''(a || b) != (c >= (d && e))'\'''
test-expr '(a || b) != (c >= (d && e))' 2>&1 ||
echo 'command failed: test-expr '\''(a || b) != (c >= (d && e))'\'''

echo '$ diff-expr '\''(a || b) != (c >= (d && e))'\'' '\''(a || b) != c >= (d && e)'\'''
diff-expr '(a || b) != (c >= (d && e))' '(a || b) != c >= (d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a || b) != (c >= (d && e))'\'' '\''(a || b) != c >= (d && e)'\'''

echo '$ test-expr '\''a || (b != (c >= (d && e)))'\'''
test-expr 'a || (b != (c >= (d && e)))' 2>&1 ||
echo 'command failed: test-expr '\''a || (b != (c >= (d && e)))'\'''

echo '$ diff-expr '\''a || (b != (c >= (d && e)))'\'' '\''a || b != (c >= (d && e))'\'''
diff-expr 'a || (b != (c >= (d && e)))' 'a || b != (c >= (d && e))' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b != (c >= (d && e)))'\'' '\''a || b != (c >= (d && e))'\'''

echo '$ diff-expr '\''a || (b != (c >= (d && e)))'\'' '\''a || b != c >= (d && e)'\'''
diff-expr 'a || (b != (c >= (d && e)))' 'a || b != c >= (d && e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b != (c >= (d && e)))'\'' '\''a || b != c >= (d && e)'\'''

echo '$ diff-expr '\''a || (b != (c >= (d && e)))'\'' '\''a || (b != c >= (d && e))'\'''
diff-expr 'a || (b != (c >= (d && e)))' 'a || (b != c >= (d && e))' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b != (c >= (d && e)))'\'' '\''a || (b != c >= (d && e))'\'''

echo '$ test-expr '\''(((a || b) != c) && d) >= e'\'''
test-expr '(((a || b) != c) && d) >= e' 2>&1 ||
echo 'command failed: test-expr '\''(((a || b) != c) && d) >= e'\'''

echo '$ diff-expr '\''(((a || b) != c) && d) >= e'\'' '\''((a || b) != c && d) >= e'\'''
diff-expr '(((a || b) != c) && d) >= e' '((a || b) != c && d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a || b) != c) && d) >= e'\'' '\''((a || b) != c && d) >= e'\'''

echo '$ test-expr '\''a || (((b != c) && d) >= e)'\'''
test-expr 'a || (((b != c) && d) >= e)' 2>&1 ||
echo 'command failed: test-expr '\''a || (((b != c) && d) >= e)'\'''

echo '$ diff-expr '\''a || (((b != c) && d) >= e)'\'' '\''a || ((b != c) && d) >= e'\'''
diff-expr 'a || (((b != c) && d) >= e)' 'a || ((b != c) && d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''a || (((b != c) && d) >= e)'\'' '\''a || ((b != c) && d) >= e'\'''

echo '$ diff-expr '\''a || (((b != c) && d) >= e)'\'' '\''a || (b != c && d) >= e'\'''
diff-expr 'a || (((b != c) && d) >= e)' 'a || (b != c && d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''a || (((b != c) && d) >= e)'\'' '\''a || (b != c && d) >= e'\'''

echo '$ diff-expr '\''a || (((b != c) && d) >= e)'\'' '\''a || ((b != c && d) >= e)'\'''
diff-expr 'a || (((b != c) && d) >= e)' 'a || ((b != c && d) >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || (((b != c) && d) >= e)'\'' '\''a || ((b != c && d) >= e)'\'''

echo '$ test-expr '\''(a || ((b != c) && d)) >= e'\'''
test-expr '(a || ((b != c) && d)) >= e' 2>&1 ||
echo 'command failed: test-expr '\''(a || ((b != c) && d)) >= e'\'''

echo '$ diff-expr '\''(a || ((b != c) && d)) >= e'\'' '\''(a || (b != c) && d) >= e'\'''
diff-expr '(a || ((b != c) && d)) >= e' '(a || (b != c) && d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || ((b != c) && d)) >= e'\'' '\''(a || (b != c) && d) >= e'\'''

echo '$ diff-expr '\''(a || ((b != c) && d)) >= e'\'' '\''(a || b != c && d) >= e'\'''
diff-expr '(a || ((b != c) && d)) >= e' '(a || b != c && d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || ((b != c) && d)) >= e'\'' '\''(a || b != c && d) >= e'\'''

echo '$ diff-expr '\''(a || ((b != c) && d)) >= e'\'' '\''(a || (b != c && d)) >= e'\'''
diff-expr '(a || ((b != c) && d)) >= e' '(a || (b != c && d)) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || ((b != c) && d)) >= e'\'' '\''(a || (b != c && d)) >= e'\'''

echo '$ test-expr '\''(a || b) != ((c && d) >= e)'\'''
test-expr '(a || b) != ((c && d) >= e)' 2>&1 ||
echo 'command failed: test-expr '\''(a || b) != ((c && d) >= e)'\'''

echo '$ diff-expr '\''(a || b) != ((c && d) >= e)'\'' '\''(a || b) != (c && d) >= e'\'''
diff-expr '(a || b) != ((c && d) >= e)' '(a || b) != (c && d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || b) != ((c && d) >= e)'\'' '\''(a || b) != (c && d) >= e'\'''

echo '$ test-expr '\''a || (b != ((c && d) >= e))'\'''
test-expr 'a || (b != ((c && d) >= e))' 2>&1 ||
echo 'command failed: test-expr '\''a || (b != ((c && d) >= e))'\'''

echo '$ diff-expr '\''a || (b != ((c && d) >= e))'\'' '\''a || b != ((c && d) >= e)'\'''
diff-expr 'a || (b != ((c && d) >= e))' 'a || b != ((c && d) >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b != ((c && d) >= e))'\'' '\''a || b != ((c && d) >= e)'\'''

echo '$ diff-expr '\''a || (b != ((c && d) >= e))'\'' '\''a || b != (c && d) >= e'\'''
diff-expr 'a || (b != ((c && d) >= e))' 'a || b != (c && d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b != ((c && d) >= e))'\'' '\''a || b != (c && d) >= e'\'''

echo '$ diff-expr '\''a || (b != ((c && d) >= e))'\'' '\''a || (b != (c && d) >= e)'\'''
diff-expr 'a || (b != ((c && d) >= e))' 'a || (b != (c && d) >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b != ((c && d) >= e))'\'' '\''a || (b != (c && d) >= e)'\'''

echo '$ test-expr '\''((a || (b != c)) && d) >= e'\'''
test-expr '((a || (b != c)) && d) >= e' 2>&1 ||
echo 'command failed: test-expr '\''((a || (b != c)) && d) >= e'\'''

echo '$ diff-expr '\''((a || (b != c)) && d) >= e'\'' '\''((a || b != c) && d) >= e'\'''
diff-expr '((a || (b != c)) && d) >= e' '((a || b != c) && d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''((a || (b != c)) && d) >= e'\'' '\''((a || b != c) && d) >= e'\'''

echo '$ test-expr '\''a || ((b != (c && d)) >= e)'\'''
test-expr 'a || ((b != (c && d)) >= e)' 2>&1 ||
echo 'command failed: test-expr '\''a || ((b != (c && d)) >= e)'\'''

echo '$ diff-expr '\''a || ((b != (c && d)) >= e)'\'' '\''a || (b != (c && d)) >= e'\'''
diff-expr 'a || ((b != (c && d)) >= e)' 'a || (b != (c && d)) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b != (c && d)) >= e)'\'' '\''a || (b != (c && d)) >= e'\'''

echo '$ test-expr '\''((a || b) != (c && d)) >= e'\'''
test-expr '((a || b) != (c && d)) >= e' 2>&1 ||
echo 'command failed: test-expr '\''((a || b) != (c && d)) >= e'\'''

echo '$ test-expr '\''((a || b) != c) && (d >= e)'\'''
test-expr '((a || b) != c) && (d >= e)' 2>&1 ||
echo 'command failed: test-expr '\''((a || b) != c) && (d >= e)'\'''

echo '$ diff-expr '\''((a || b) != c) && (d >= e)'\'' '\''(a || b) != c && (d >= e)'\'''
diff-expr '((a || b) != c) && (d >= e)' '(a || b) != c && (d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''((a || b) != c) && (d >= e)'\'' '\''(a || b) != c && (d >= e)'\'''

echo '$ diff-expr '\''((a || b) != c) && (d >= e)'\'' '\''(a || b) != c && d >= e'\'''
diff-expr '((a || b) != c) && (d >= e)' '(a || b) != c && d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''((a || b) != c) && (d >= e)'\'' '\''(a || b) != c && d >= e'\'''

echo '$ diff-expr '\''((a || b) != c) && (d >= e)'\'' '\''((a || b) != c) && d >= e'\'''
diff-expr '((a || b) != c) && (d >= e)' '((a || b) != c) && d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''((a || b) != c) && (d >= e)'\'' '\''((a || b) != c) && d >= e'\'''

echo '$ test-expr '\''a || ((b != c) && (d >= e))'\'''
test-expr 'a || ((b != c) && (d >= e))' 2>&1 ||
echo 'command failed: test-expr '\''a || ((b != c) && (d >= e))'\'''

echo '$ diff-expr '\''a || ((b != c) && (d >= e))'\'' '\''a || (b != c) && (d >= e)'\'''
diff-expr 'a || ((b != c) && (d >= e))' 'a || (b != c) && (d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b != c) && (d >= e))'\'' '\''a || (b != c) && (d >= e)'\'''

echo '$ diff-expr '\''a || ((b != c) && (d >= e))'\'' '\''a || b != c && (d >= e)'\'''
diff-expr 'a || ((b != c) && (d >= e))' 'a || b != c && (d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b != c) && (d >= e))'\'' '\''a || b != c && (d >= e)'\'''

echo '$ diff-expr '\''a || ((b != c) && (d >= e))'\'' '\''a || b != c && d >= e'\'''
diff-expr 'a || ((b != c) && (d >= e))' 'a || b != c && d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b != c) && (d >= e))'\'' '\''a || b != c && d >= e'\'''

echo '$ diff-expr '\''a || ((b != c) && (d >= e))'\'' '\''a || (b != c) && d >= e'\'''
diff-expr 'a || ((b != c) && (d >= e))' 'a || (b != c) && d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b != c) && (d >= e))'\'' '\''a || (b != c) && d >= e'\'''

echo '$ diff-expr '\''a || ((b != c) && (d >= e))'\'' '\''a || (b != c && (d >= e))'\'''
diff-expr 'a || ((b != c) && (d >= e))' 'a || (b != c && (d >= e))' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b != c) && (d >= e))'\'' '\''a || (b != c && (d >= e))'\'''

echo '$ diff-expr '\''a || ((b != c) && (d >= e))'\'' '\''a || (b != c && d >= e)'\'''
diff-expr 'a || ((b != c) && (d >= e))' 'a || (b != c && d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b != c) && (d >= e))'\'' '\''a || (b != c && d >= e)'\'''

echo '$ diff-expr '\''a || ((b != c) && (d >= e))'\'' '\''a || ((b != c) && d >= e)'\'''
diff-expr 'a || ((b != c) && (d >= e))' 'a || ((b != c) && d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b != c) && (d >= e))'\'' '\''a || ((b != c) && d >= e)'\'''

echo '$ test-expr '\''(a || (b != (c && d))) >= e'\'''
test-expr '(a || (b != (c && d))) >= e' 2>&1 ||
echo 'command failed: test-expr '\''(a || (b != (c && d))) >= e'\'''

echo '$ diff-expr '\''(a || (b != (c && d))) >= e'\'' '\''(a || b != (c && d)) >= e'\'''
diff-expr '(a || (b != (c && d))) >= e' '(a || b != (c && d)) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || (b != (c && d))) >= e'\'' '\''(a || b != (c && d)) >= e'\'''

echo '$ test-expr '\''(a || (b != c)) && (d >= e)'\'''
test-expr '(a || (b != c)) && (d >= e)' 2>&1 ||
echo 'command failed: test-expr '\''(a || (b != c)) && (d >= e)'\'''

echo '$ diff-expr '\''(a || (b != c)) && (d >= e)'\'' '\''(a || b != c) && (d >= e)'\'''
diff-expr '(a || (b != c)) && (d >= e)' '(a || b != c) && (d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a || (b != c)) && (d >= e)'\'' '\''(a || b != c) && (d >= e)'\'''

echo '$ diff-expr '\''(a || (b != c)) && (d >= e)'\'' '\''(a || b != c) && d >= e'\'''
diff-expr '(a || (b != c)) && (d >= e)' '(a || b != c) && d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || (b != c)) && (d >= e)'\'' '\''(a || b != c) && d >= e'\'''

echo '$ diff-expr '\''(a || (b != c)) && (d >= e)'\'' '\''(a || (b != c)) && d >= e'\'''
diff-expr '(a || (b != c)) && (d >= e)' '(a || (b != c)) && d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || (b != c)) && (d >= e)'\'' '\''(a || (b != c)) && d >= e'\'''

echo '$ test-expr '\''(a || b) != (c && (d >= e))'\'''
test-expr '(a || b) != (c && (d >= e))' 2>&1 ||
echo 'command failed: test-expr '\''(a || b) != (c && (d >= e))'\'''

echo '$ diff-expr '\''(a || b) != (c && (d >= e))'\'' '\''(a || b) != (c && d >= e)'\'''
diff-expr '(a || b) != (c && (d >= e))' '(a || b) != (c && d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a || b) != (c && (d >= e))'\'' '\''(a || b) != (c && d >= e)'\'''

echo '$ test-expr '\''a || (b != (c && (d >= e)))'\'''
test-expr 'a || (b != (c && (d >= e)))' 2>&1 ||
echo 'command failed: test-expr '\''a || (b != (c && (d >= e)))'\'''

echo '$ diff-expr '\''a || (b != (c && (d >= e)))'\'' '\''a || b != (c && (d >= e))'\'''
diff-expr 'a || (b != (c && (d >= e)))' 'a || b != (c && (d >= e))' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b != (c && (d >= e)))'\'' '\''a || b != (c && (d >= e))'\'''

echo '$ diff-expr '\''a || (b != (c && (d >= e)))'\'' '\''a || b != (c && d >= e)'\'''
diff-expr 'a || (b != (c && (d >= e)))' 'a || b != (c && d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b != (c && (d >= e)))'\'' '\''a || b != (c && d >= e)'\'''

echo '$ diff-expr '\''a || (b != (c && (d >= e)))'\'' '\''a || (b != (c && d >= e))'\'''
diff-expr 'a || (b != (c && (d >= e)))' 'a || (b != (c && d >= e))' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b != (c && (d >= e)))'\'' '\''a || (b != (c && d >= e))'\'''

echo '$ test-expr '\''(((a || b) && c) >= d) != e'\'''
test-expr '(((a || b) && c) >= d) != e' 2>&1 ||
echo 'command failed: test-expr '\''(((a || b) && c) >= d) != e'\'''

echo '$ diff-expr '\''(((a || b) && c) >= d) != e'\'' '\''((a || b) && c) >= d != e'\'''
diff-expr '(((a || b) && c) >= d) != e' '((a || b) && c) >= d != e' 2>&1 ||
echo 'command failed: diff-expr '\''(((a || b) && c) >= d) != e'\'' '\''((a || b) && c) >= d != e'\'''

echo '$ test-expr '\''a || (((b && c) >= d) != e)'\'''
test-expr 'a || (((b && c) >= d) != e)' 2>&1 ||
echo 'command failed: test-expr '\''a || (((b && c) >= d) != e)'\'''

echo '$ diff-expr '\''a || (((b && c) >= d) != e)'\'' '\''a || ((b && c) >= d) != e'\'''
diff-expr 'a || (((b && c) >= d) != e)' 'a || ((b && c) >= d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''a || (((b && c) >= d) != e)'\'' '\''a || ((b && c) >= d) != e'\'''

echo '$ diff-expr '\''a || (((b && c) >= d) != e)'\'' '\''a || (b && c) >= d != e'\'''
diff-expr 'a || (((b && c) >= d) != e)' 'a || (b && c) >= d != e' 2>&1 ||
echo 'command failed: diff-expr '\''a || (((b && c) >= d) != e)'\'' '\''a || (b && c) >= d != e'\'''

echo '$ diff-expr '\''a || (((b && c) >= d) != e)'\'' '\''a || ((b && c) >= d != e)'\'''
diff-expr 'a || (((b && c) >= d) != e)' 'a || ((b && c) >= d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || (((b && c) >= d) != e)'\'' '\''a || ((b && c) >= d != e)'\'''

echo '$ test-expr '\''(a || ((b && c) >= d)) != e'\'''
test-expr '(a || ((b && c) >= d)) != e' 2>&1 ||
echo 'command failed: test-expr '\''(a || ((b && c) >= d)) != e'\'''

echo '$ diff-expr '\''(a || ((b && c) >= d)) != e'\'' '\''(a || (b && c) >= d) != e'\'''
diff-expr '(a || ((b && c) >= d)) != e' '(a || (b && c) >= d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || ((b && c) >= d)) != e'\'' '\''(a || (b && c) >= d) != e'\'''

echo '$ test-expr '\''(a || b) && ((c >= d) != e)'\'''
test-expr '(a || b) && ((c >= d) != e)' 2>&1 ||
echo 'command failed: test-expr '\''(a || b) && ((c >= d) != e)'\'''

echo '$ diff-expr '\''(a || b) && ((c >= d) != e)'\'' '\''(a || b) && (c >= d) != e'\'''
diff-expr '(a || b) && ((c >= d) != e)' '(a || b) && (c >= d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || b) && ((c >= d) != e)'\'' '\''(a || b) && (c >= d) != e'\'''

echo '$ diff-expr '\''(a || b) && ((c >= d) != e)'\'' '\''(a || b) && c >= d != e'\'''
diff-expr '(a || b) && ((c >= d) != e)' '(a || b) && c >= d != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || b) && ((c >= d) != e)'\'' '\''(a || b) && c >= d != e'\'''

echo '$ diff-expr '\''(a || b) && ((c >= d) != e)'\'' '\''(a || b) && (c >= d != e)'\'''
diff-expr '(a || b) && ((c >= d) != e)' '(a || b) && (c >= d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a || b) && ((c >= d) != e)'\'' '\''(a || b) && (c >= d != e)'\'''

echo '$ test-expr '\''a || (b && ((c >= d) != e))'\'''
test-expr 'a || (b && ((c >= d) != e))' 2>&1 ||
echo 'command failed: test-expr '\''a || (b && ((c >= d) != e))'\'''

echo '$ diff-expr '\''a || (b && ((c >= d) != e))'\'' '\''a || b && ((c >= d) != e)'\'''
diff-expr 'a || (b && ((c >= d) != e))' 'a || b && ((c >= d) != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b && ((c >= d) != e))'\'' '\''a || b && ((c >= d) != e)'\'''

echo '$ diff-expr '\''a || (b && ((c >= d) != e))'\'' '\''a || b && (c >= d) != e'\'''
diff-expr 'a || (b && ((c >= d) != e))' 'a || b && (c >= d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b && ((c >= d) != e))'\'' '\''a || b && (c >= d) != e'\'''

echo '$ diff-expr '\''a || (b && ((c >= d) != e))'\'' '\''a || b && c >= d != e'\'''
diff-expr 'a || (b && ((c >= d) != e))' 'a || b && c >= d != e' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b && ((c >= d) != e))'\'' '\''a || b && c >= d != e'\'''

echo '$ diff-expr '\''a || (b && ((c >= d) != e))'\'' '\''a || b && (c >= d != e)'\'''
diff-expr 'a || (b && ((c >= d) != e))' 'a || b && (c >= d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b && ((c >= d) != e))'\'' '\''a || b && (c >= d != e)'\'''

echo '$ diff-expr '\''a || (b && ((c >= d) != e))'\'' '\''a || (b && (c >= d) != e)'\'''
diff-expr 'a || (b && ((c >= d) != e))' 'a || (b && (c >= d) != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b && ((c >= d) != e))'\'' '\''a || (b && (c >= d) != e)'\'''

echo '$ diff-expr '\''a || (b && ((c >= d) != e))'\'' '\''a || (b && c >= d != e)'\'''
diff-expr 'a || (b && ((c >= d) != e))' 'a || (b && c >= d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b && ((c >= d) != e))'\'' '\''a || (b && c >= d != e)'\'''

echo '$ diff-expr '\''a || (b && ((c >= d) != e))'\'' '\''a || (b && (c >= d != e))'\'''
diff-expr 'a || (b && ((c >= d) != e))' 'a || (b && (c >= d != e))' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b && ((c >= d) != e))'\'' '\''a || (b && (c >= d != e))'\'''

echo '$ test-expr '\''((a || (b && c)) >= d) != e'\'''
test-expr '((a || (b && c)) >= d) != e' 2>&1 ||
echo 'command failed: test-expr '\''((a || (b && c)) >= d) != e'\'''

echo '$ diff-expr '\''((a || (b && c)) >= d) != e'\'' '\''(a || (b && c)) >= d != e'\'''
diff-expr '((a || (b && c)) >= d) != e' '(a || (b && c)) >= d != e' 2>&1 ||
echo 'command failed: diff-expr '\''((a || (b && c)) >= d) != e'\'' '\''(a || (b && c)) >= d != e'\'''

echo '$ diff-expr '\''((a || (b && c)) >= d) != e'\'' '\''(a || b && c) >= d != e'\'''
diff-expr '((a || (b && c)) >= d) != e' '(a || b && c) >= d != e' 2>&1 ||
echo 'command failed: diff-expr '\''((a || (b && c)) >= d) != e'\'' '\''(a || b && c) >= d != e'\'''

echo '$ diff-expr '\''((a || (b && c)) >= d) != e'\'' '\''((a || b && c) >= d) != e'\'''
diff-expr '((a || (b && c)) >= d) != e' '((a || b && c) >= d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''((a || (b && c)) >= d) != e'\'' '\''((a || b && c) >= d) != e'\'''

echo '$ test-expr '\''a || ((b && (c >= d)) != e)'\'''
test-expr 'a || ((b && (c >= d)) != e)' 2>&1 ||
echo 'command failed: test-expr '\''a || ((b && (c >= d)) != e)'\'''

echo '$ diff-expr '\''a || ((b && (c >= d)) != e)'\'' '\''a || (b && (c >= d)) != e'\'''
diff-expr 'a || ((b && (c >= d)) != e)' 'a || (b && (c >= d)) != e' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b && (c >= d)) != e)'\'' '\''a || (b && (c >= d)) != e'\'''

echo '$ diff-expr '\''a || ((b && (c >= d)) != e)'\'' '\''a || (b && c >= d) != e'\'''
diff-expr 'a || ((b && (c >= d)) != e)' 'a || (b && c >= d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b && (c >= d)) != e)'\'' '\''a || (b && c >= d) != e'\'''

echo '$ diff-expr '\''a || ((b && (c >= d)) != e)'\'' '\''a || ((b && c >= d) != e)'\'''
diff-expr 'a || ((b && (c >= d)) != e)' 'a || ((b && c >= d) != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b && (c >= d)) != e)'\'' '\''a || ((b && c >= d) != e)'\'''

echo '$ test-expr '\''((a || b) && (c >= d)) != e'\'''
test-expr '((a || b) && (c >= d)) != e' 2>&1 ||
echo 'command failed: test-expr '\''((a || b) && (c >= d)) != e'\'''

echo '$ diff-expr '\''((a || b) && (c >= d)) != e'\'' '\''((a || b) && c >= d) != e'\'''
diff-expr '((a || b) && (c >= d)) != e' '((a || b) && c >= d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''((a || b) && (c >= d)) != e'\'' '\''((a || b) && c >= d) != e'\'''

echo '$ test-expr '\''((a || b) && c) >= (d != e)'\'''
test-expr '((a || b) && c) >= (d != e)' 2>&1 ||
echo 'command failed: test-expr '\''((a || b) && c) >= (d != e)'\'''

echo '$ test-expr '\''a || ((b && c) >= (d != e))'\'''
test-expr 'a || ((b && c) >= (d != e))' 2>&1 ||
echo 'command failed: test-expr '\''a || ((b && c) >= (d != e))'\'''

echo '$ diff-expr '\''a || ((b && c) >= (d != e))'\'' '\''a || (b && c) >= (d != e)'\'''
diff-expr 'a || ((b && c) >= (d != e))' 'a || (b && c) >= (d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b && c) >= (d != e))'\'' '\''a || (b && c) >= (d != e)'\'''

echo '$ test-expr '\''(a || (b && (c >= d))) != e'\'''
test-expr '(a || (b && (c >= d))) != e' 2>&1 ||
echo 'command failed: test-expr '\''(a || (b && (c >= d))) != e'\'''

echo '$ diff-expr '\''(a || (b && (c >= d))) != e'\'' '\''(a || b && (c >= d)) != e'\'''
diff-expr '(a || (b && (c >= d))) != e' '(a || b && (c >= d)) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || (b && (c >= d))) != e'\'' '\''(a || b && (c >= d)) != e'\'''

echo '$ diff-expr '\''(a || (b && (c >= d))) != e'\'' '\''(a || b && c >= d) != e'\'''
diff-expr '(a || (b && (c >= d))) != e' '(a || b && c >= d) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || (b && (c >= d))) != e'\'' '\''(a || b && c >= d) != e'\'''

echo '$ diff-expr '\''(a || (b && (c >= d))) != e'\'' '\''(a || (b && c >= d)) != e'\'''
diff-expr '(a || (b && (c >= d))) != e' '(a || (b && c >= d)) != e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || (b && (c >= d))) != e'\'' '\''(a || (b && c >= d)) != e'\'''

echo '$ test-expr '\''(a || (b && c)) >= (d != e)'\'''
test-expr '(a || (b && c)) >= (d != e)' 2>&1 ||
echo 'command failed: test-expr '\''(a || (b && c)) >= (d != e)'\'''

echo '$ diff-expr '\''(a || (b && c)) >= (d != e)'\'' '\''(a || b && c) >= (d != e)'\'''
diff-expr '(a || (b && c)) >= (d != e)' '(a || b && c) >= (d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a || (b && c)) >= (d != e)'\'' '\''(a || b && c) >= (d != e)'\'''

echo '$ test-expr '\''(a || b) && (c >= (d != e))'\'''
test-expr '(a || b) && (c >= (d != e))' 2>&1 ||
echo 'command failed: test-expr '\''(a || b) && (c >= (d != e))'\'''

echo '$ diff-expr '\''(a || b) && (c >= (d != e))'\'' '\''(a || b) && c >= (d != e)'\'''
diff-expr '(a || b) && (c >= (d != e))' '(a || b) && c >= (d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a || b) && (c >= (d != e))'\'' '\''(a || b) && c >= (d != e)'\'''

echo '$ test-expr '\''a || (b && (c >= (d != e)))'\'''
test-expr 'a || (b && (c >= (d != e)))' 2>&1 ||
echo 'command failed: test-expr '\''a || (b && (c >= (d != e)))'\'''

echo '$ diff-expr '\''a || (b && (c >= (d != e)))'\'' '\''a || b && (c >= (d != e))'\'''
diff-expr 'a || (b && (c >= (d != e)))' 'a || b && (c >= (d != e))' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b && (c >= (d != e)))'\'' '\''a || b && (c >= (d != e))'\'''

echo '$ diff-expr '\''a || (b && (c >= (d != e)))'\'' '\''a || b && c >= (d != e)'\'''
diff-expr 'a || (b && (c >= (d != e)))' 'a || b && c >= (d != e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b && (c >= (d != e)))'\'' '\''a || b && c >= (d != e)'\'''

echo '$ diff-expr '\''a || (b && (c >= (d != e)))'\'' '\''a || (b && c >= (d != e))'\'''
diff-expr 'a || (b && (c >= (d != e)))' 'a || (b && c >= (d != e))' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b && (c >= (d != e)))'\'' '\''a || (b && c >= (d != e))'\'''

echo '$ test-expr '\''(((a || b) && c) != d) >= e'\'''
test-expr '(((a || b) && c) != d) >= e' 2>&1 ||
echo 'command failed: test-expr '\''(((a || b) && c) != d) >= e'\'''

echo '$ test-expr '\''a || (((b && c) != d) >= e)'\'''
test-expr 'a || (((b && c) != d) >= e)' 2>&1 ||
echo 'command failed: test-expr '\''a || (((b && c) != d) >= e)'\'''

echo '$ diff-expr '\''a || (((b && c) != d) >= e)'\'' '\''a || ((b && c) != d) >= e'\'''
diff-expr 'a || (((b && c) != d) >= e)' 'a || ((b && c) != d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''a || (((b && c) != d) >= e)'\'' '\''a || ((b && c) != d) >= e'\'''

echo '$ test-expr '\''(a || ((b && c) != d)) >= e'\'''
test-expr '(a || ((b && c) != d)) >= e' 2>&1 ||
echo 'command failed: test-expr '\''(a || ((b && c) != d)) >= e'\'''

echo '$ diff-expr '\''(a || ((b && c) != d)) >= e'\'' '\''(a || (b && c) != d) >= e'\'''
diff-expr '(a || ((b && c) != d)) >= e' '(a || (b && c) != d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || ((b && c) != d)) >= e'\'' '\''(a || (b && c) != d) >= e'\'''

echo '$ test-expr '\''(a || b) && ((c != d) >= e)'\'''
test-expr '(a || b) && ((c != d) >= e)' 2>&1 ||
echo 'command failed: test-expr '\''(a || b) && ((c != d) >= e)'\'''

echo '$ diff-expr '\''(a || b) && ((c != d) >= e)'\'' '\''(a || b) && (c != d) >= e'\'''
diff-expr '(a || b) && ((c != d) >= e)' '(a || b) && (c != d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || b) && ((c != d) >= e)'\'' '\''(a || b) && (c != d) >= e'\'''

echo '$ test-expr '\''a || (b && ((c != d) >= e))'\'''
test-expr 'a || (b && ((c != d) >= e))' 2>&1 ||
echo 'command failed: test-expr '\''a || (b && ((c != d) >= e))'\'''

echo '$ diff-expr '\''a || (b && ((c != d) >= e))'\'' '\''a || b && ((c != d) >= e)'\'''
diff-expr 'a || (b && ((c != d) >= e))' 'a || b && ((c != d) >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b && ((c != d) >= e))'\'' '\''a || b && ((c != d) >= e)'\'''

echo '$ diff-expr '\''a || (b && ((c != d) >= e))'\'' '\''a || b && (c != d) >= e'\'''
diff-expr 'a || (b && ((c != d) >= e))' 'a || b && (c != d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b && ((c != d) >= e))'\'' '\''a || b && (c != d) >= e'\'''

echo '$ diff-expr '\''a || (b && ((c != d) >= e))'\'' '\''a || (b && (c != d) >= e)'\'''
diff-expr 'a || (b && ((c != d) >= e))' 'a || (b && (c != d) >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b && ((c != d) >= e))'\'' '\''a || (b && (c != d) >= e)'\'''

echo '$ test-expr '\''((a || (b && c)) != d) >= e'\'''
test-expr '((a || (b && c)) != d) >= e' 2>&1 ||
echo 'command failed: test-expr '\''((a || (b && c)) != d) >= e'\'''

echo '$ diff-expr '\''((a || (b && c)) != d) >= e'\'' '\''((a || b && c) != d) >= e'\'''
diff-expr '((a || (b && c)) != d) >= e' '((a || b && c) != d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''((a || (b && c)) != d) >= e'\'' '\''((a || b && c) != d) >= e'\'''

echo '$ test-expr '\''a || ((b && (c != d)) >= e)'\'''
test-expr 'a || ((b && (c != d)) >= e)' 2>&1 ||
echo 'command failed: test-expr '\''a || ((b && (c != d)) >= e)'\'''

echo '$ diff-expr '\''a || ((b && (c != d)) >= e)'\'' '\''a || (b && (c != d)) >= e'\'''
diff-expr 'a || ((b && (c != d)) >= e)' 'a || (b && (c != d)) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b && (c != d)) >= e)'\'' '\''a || (b && (c != d)) >= e'\'''

echo '$ diff-expr '\''a || ((b && (c != d)) >= e)'\'' '\''a || (b && c != d) >= e'\'''
diff-expr 'a || ((b && (c != d)) >= e)' 'a || (b && c != d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b && (c != d)) >= e)'\'' '\''a || (b && c != d) >= e'\'''

echo '$ diff-expr '\''a || ((b && (c != d)) >= e)'\'' '\''a || ((b && c != d) >= e)'\'''
diff-expr 'a || ((b && (c != d)) >= e)' 'a || ((b && c != d) >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b && (c != d)) >= e)'\'' '\''a || ((b && c != d) >= e)'\'''

echo '$ test-expr '\''((a || b) && (c != d)) >= e'\'''
test-expr '((a || b) && (c != d)) >= e' 2>&1 ||
echo 'command failed: test-expr '\''((a || b) && (c != d)) >= e'\'''

echo '$ diff-expr '\''((a || b) && (c != d)) >= e'\'' '\''((a || b) && c != d) >= e'\'''
diff-expr '((a || b) && (c != d)) >= e' '((a || b) && c != d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''((a || b) && (c != d)) >= e'\'' '\''((a || b) && c != d) >= e'\'''

echo '$ test-expr '\''((a || b) && c) != (d >= e)'\'''
test-expr '((a || b) && c) != (d >= e)' 2>&1 ||
echo 'command failed: test-expr '\''((a || b) && c) != (d >= e)'\'''

echo '$ diff-expr '\''((a || b) && c) != (d >= e)'\'' '\''((a || b) && c) != d >= e'\'''
diff-expr '((a || b) && c) != (d >= e)' '((a || b) && c) != d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''((a || b) && c) != (d >= e)'\'' '\''((a || b) && c) != d >= e'\'''

echo '$ test-expr '\''a || ((b && c) != (d >= e))'\'''
test-expr 'a || ((b && c) != (d >= e))' 2>&1 ||
echo 'command failed: test-expr '\''a || ((b && c) != (d >= e))'\'''

echo '$ diff-expr '\''a || ((b && c) != (d >= e))'\'' '\''a || (b && c) != (d >= e)'\'''
diff-expr 'a || ((b && c) != (d >= e))' 'a || (b && c) != (d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b && c) != (d >= e))'\'' '\''a || (b && c) != (d >= e)'\'''

echo '$ diff-expr '\''a || ((b && c) != (d >= e))'\'' '\''a || (b && c) != d >= e'\'''
diff-expr 'a || ((b && c) != (d >= e))' 'a || (b && c) != d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b && c) != (d >= e))'\'' '\''a || (b && c) != d >= e'\'''

echo '$ diff-expr '\''a || ((b && c) != (d >= e))'\'' '\''a || ((b && c) != d >= e)'\'''
diff-expr 'a || ((b && c) != (d >= e))' 'a || ((b && c) != d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || ((b && c) != (d >= e))'\'' '\''a || ((b && c) != d >= e)'\'''

echo '$ test-expr '\''(a || (b && (c != d))) >= e'\'''
test-expr '(a || (b && (c != d))) >= e' 2>&1 ||
echo 'command failed: test-expr '\''(a || (b && (c != d))) >= e'\'''

echo '$ diff-expr '\''(a || (b && (c != d))) >= e'\'' '\''(a || b && (c != d)) >= e'\'''
diff-expr '(a || (b && (c != d))) >= e' '(a || b && (c != d)) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || (b && (c != d))) >= e'\'' '\''(a || b && (c != d)) >= e'\'''

echo '$ diff-expr '\''(a || (b && (c != d))) >= e'\'' '\''(a || b && c != d) >= e'\'''
diff-expr '(a || (b && (c != d))) >= e' '(a || b && c != d) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || (b && (c != d))) >= e'\'' '\''(a || b && c != d) >= e'\'''

echo '$ diff-expr '\''(a || (b && (c != d))) >= e'\'' '\''(a || (b && c != d)) >= e'\'''
diff-expr '(a || (b && (c != d))) >= e' '(a || (b && c != d)) >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || (b && (c != d))) >= e'\'' '\''(a || (b && c != d)) >= e'\'''

echo '$ test-expr '\''(a || (b && c)) != (d >= e)'\'''
test-expr '(a || (b && c)) != (d >= e)' 2>&1 ||
echo 'command failed: test-expr '\''(a || (b && c)) != (d >= e)'\'''

echo '$ diff-expr '\''(a || (b && c)) != (d >= e)'\'' '\''(a || b && c) != (d >= e)'\'''
diff-expr '(a || (b && c)) != (d >= e)' '(a || b && c) != (d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a || (b && c)) != (d >= e)'\'' '\''(a || b && c) != (d >= e)'\'''

echo '$ diff-expr '\''(a || (b && c)) != (d >= e)'\'' '\''(a || b && c) != d >= e'\'''
diff-expr '(a || (b && c)) != (d >= e)' '(a || b && c) != d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || (b && c)) != (d >= e)'\'' '\''(a || b && c) != d >= e'\'''

echo '$ diff-expr '\''(a || (b && c)) != (d >= e)'\'' '\''(a || (b && c)) != d >= e'\'''
diff-expr '(a || (b && c)) != (d >= e)' '(a || (b && c)) != d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || (b && c)) != (d >= e)'\'' '\''(a || (b && c)) != d >= e'\'''

echo '$ test-expr '\''(a || b) && (c != (d >= e))'\'''
test-expr '(a || b) && (c != (d >= e))' 2>&1 ||
echo 'command failed: test-expr '\''(a || b) && (c != (d >= e))'\'''

echo '$ diff-expr '\''(a || b) && (c != (d >= e))'\'' '\''(a || b) && c != (d >= e)'\'''
diff-expr '(a || b) && (c != (d >= e))' '(a || b) && c != (d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a || b) && (c != (d >= e))'\'' '\''(a || b) && c != (d >= e)'\'''

echo '$ diff-expr '\''(a || b) && (c != (d >= e))'\'' '\''(a || b) && c != d >= e'\'''
diff-expr '(a || b) && (c != (d >= e))' '(a || b) && c != d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''(a || b) && (c != (d >= e))'\'' '\''(a || b) && c != d >= e'\'''

echo '$ diff-expr '\''(a || b) && (c != (d >= e))'\'' '\''(a || b) && (c != d >= e)'\'''
diff-expr '(a || b) && (c != (d >= e))' '(a || b) && (c != d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''(a || b) && (c != (d >= e))'\'' '\''(a || b) && (c != d >= e)'\'''

echo '$ test-expr '\''a || (b && (c != (d >= e)))'\'''
test-expr 'a || (b && (c != (d >= e)))' 2>&1 ||
echo 'command failed: test-expr '\''a || (b && (c != (d >= e)))'\'''

echo '$ diff-expr '\''a || (b && (c != (d >= e)))'\'' '\''a || b && (c != (d >= e))'\'''
diff-expr 'a || (b && (c != (d >= e)))' 'a || b && (c != (d >= e))' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b && (c != (d >= e)))'\'' '\''a || b && (c != (d >= e))'\'''

echo '$ diff-expr '\''a || (b && (c != (d >= e)))'\'' '\''a || b && c != (d >= e)'\'''
diff-expr 'a || (b && (c != (d >= e)))' 'a || b && c != (d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b && (c != (d >= e)))'\'' '\''a || b && c != (d >= e)'\'''

echo '$ diff-expr '\''a || (b && (c != (d >= e)))'\'' '\''a || b && c != d >= e'\'''
diff-expr 'a || (b && (c != (d >= e)))' 'a || b && c != d >= e' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b && (c != (d >= e)))'\'' '\''a || b && c != d >= e'\'''

echo '$ diff-expr '\''a || (b && (c != (d >= e)))'\'' '\''a || b && (c != d >= e)'\'''
diff-expr 'a || (b && (c != (d >= e)))' 'a || b && (c != d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b && (c != (d >= e)))'\'' '\''a || b && (c != d >= e)'\'''

echo '$ diff-expr '\''a || (b && (c != (d >= e)))'\'' '\''a || (b && c != (d >= e))'\'''
diff-expr 'a || (b && (c != (d >= e)))' 'a || (b && c != (d >= e))' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b && (c != (d >= e)))'\'' '\''a || (b && c != (d >= e))'\'''

echo '$ diff-expr '\''a || (b && (c != (d >= e)))'\'' '\''a || (b && c != d >= e)'\'''
diff-expr 'a || (b && (c != (d >= e)))' 'a || (b && c != d >= e)' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b && (c != (d >= e)))'\'' '\''a || (b && c != d >= e)'\'''

echo '$ diff-expr '\''a || (b && (c != (d >= e)))'\'' '\''a || (b && (c != d >= e))'\'''
diff-expr 'a || (b && (c != (d >= e)))' 'a || (b && (c != d >= e))' 2>&1 ||
echo 'command failed: diff-expr '\''a || (b && (c != (d >= e)))'\'' '\''a || (b && (c != d >= e))'\'''
)

