#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C lib:github-sobj-lib
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L github-sobj-lib.old <(echo \
'$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }
$ json() { LD_LIBRARY_PATH=../lib ../src/json --raw-strings "$@"; }
$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json -VF -- ../lib/json-litex.so "$@"; }
$ norm() { sed -r '\''/^\/\/|^\s*$|^\s+(0x[[:xdigit:]]{2},\s*)+$/d;/^#if\s+0\s*$/,/^#endif\s*$/d;s/^(\s+)0x[[:xdigit:]]{2}(,\s*0x[[:xdigit:]]{2})+$/\1. . ./;s/^#/\\\0/'\'' ${1:+"$1"}; }
$ diff -u -Ljson <(json-litex -P libs/github-litex/github-litex.json|json -P) -Llib <(json-litex -P libs/github-litex/github-litex.so|json -P)
$ json-litex -V libs/github-litex/github-litex.so
$ diff -u -Ltext <(json-litex -D libs/github-litex/github-litex.json|norm) -Lsobj <(json-litex -D libs/github-litex/github-litex.so|norm)'
) -L github-sobj-lib.new <(
echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'
json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r 's/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --raw-strings "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --raw-strings "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --raw-strings "$@"; }'

echo '$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json -VF -- ../lib/json-litex.so "$@"; }'
json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json -VF -- ../lib/json-litex.so "$@"; } 2>&1 ||
echo 'command failed: json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json -VF -- ../lib/json-litex.so "$@"; }'

echo '$ norm() { sed -r '\''/^\/\/|^\s*$|^\s+(0x[[:xdigit:]]{2},\s*)+$/d;/^#if\s+0\s*$/,/^#endif\s*$/d;s/^(\s+)0x[[:xdigit:]]{2}(,\s*0x[[:xdigit:]]{2})+$/\1. . ./;s/^#/\\\0/'\'' ${1:+"$1"}; }'
norm() { sed -r '/^\/\/|^\s*$|^\s+(0x[[:xdigit:]]{2},\s*)+$/d;/^#if\s+0\s*$/,/^#endif\s*$/d;s/^(\s+)0x[[:xdigit:]]{2}(,\s*0x[[:xdigit:]]{2})+$/\1. . ./;s/^#/\\\0/' ${1:+"$1"}; } 2>&1 ||
echo 'command failed: norm() { sed -r '\''/^\/\/|^\s*$|^\s+(0x[[:xdigit:]]{2},\s*)+$/d;/^#if\s+0\s*$/,/^#endif\s*$/d;s/^(\s+)0x[[:xdigit:]]{2}(,\s*0x[[:xdigit:]]{2})+$/\1. . ./;s/^#/\\\0/'\'' ${1:+"$1"}; }'

echo '$ diff -u -Ljson <(json-litex -P libs/github-litex/github-litex.json|json -P) -Llib <(json-litex -P libs/github-litex/github-litex.so|json -P)'
diff -u -Ljson <(json-litex -P libs/github-litex/github-litex.json|json -P) -Llib <(json-litex -P libs/github-litex/github-litex.so|json -P) 2>&1 ||
echo 'command failed: diff -u -Ljson <(json-litex -P libs/github-litex/github-litex.json|json -P) -Llib <(json-litex -P libs/github-litex/github-litex.so|json -P)'

echo '$ json-litex -V libs/github-litex/github-litex.so'
json-litex -V libs/github-litex/github-litex.so 2>&1 ||
echo 'command failed: json-litex -V libs/github-litex/github-litex.so'

echo '$ diff -u -Ltext <(json-litex -D libs/github-litex/github-litex.json|norm) -Lsobj <(json-litex -D libs/github-litex/github-litex.so|norm)'
diff -u -Ltext <(json-litex -D libs/github-litex/github-litex.json|norm) -Lsobj <(json-litex -D libs/github-litex/github-litex.so|norm) 2>&1 ||
echo 'command failed: diff -u -Ltext <(json-litex -D libs/github-litex/github-litex.json|norm) -Lsobj <(json-litex -D libs/github-litex/github-litex.so|norm)'
)

