#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C trie:gen-code-function-strcmp-base0
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L gen-code-function-strcmp-base0.old <(echo \
'$ test -x ../lib/test-trie
$ print() { printf '\''%s\n'\'' "$@"; }
$ set -o pipefail
$ test-trie() { ../lib/test-trie -G --no-expanded-path --strcmp-func; }
$ print a|test-trie
    if (*p ++ == '\''a'\'' &&
        *p == 0)
        return "a";
    return NULL;
$ print a ab|test-trie
    if (*p ++ == '\''a'\'') {
        if (*p == 0)
            return "a";
        if (*p ++ == '\''b'\'' &&
            *p == 0)
            return "ab";
    }
    return NULL;
$ print a ab abc|test-trie
    if (*p ++ == '\''a'\'') {
        if (*p == 0)
            return "a";
        if (*p ++ == '\''b'\'') {
            if (*p == 0)
                return "ab";
            if (*p ++ == '\''c'\'' &&
                *p == 0)
                return "abc";
        }
    }
    return NULL;
$ print a b|test-trie
    switch (*p ++) {
    case '\''a'\'':
        if (*p == 0)
            return "a";
        return NULL;
    case '\''b'\'':
        if (*p == 0)
            return "b";
    }
    return NULL;
$ print a b abc bac abd|test-trie
    switch (*p ++) {
    case '\''a'\'':
        if (*p == 0)
            return "a";
        if (*p ++ == '\''b'\'') {
            switch (*p ++) {
            case '\''c'\'':
                if (*p == 0)
                    return "abc";
                return NULL;
            case '\''d'\'':
                if (*p == 0)
                    return "abd";
            }
        }
        return NULL;
    case '\''b'\'':
        if (*p == 0)
            return "b";
        if (!strcmp(p, "ac"))
            return "bac";
    }
    return NULL;
$ print a bb ba c|test-trie
    switch (*p ++) {
    case '\''a'\'':
        if (*p == 0)
            return "a";
        return NULL;
    case '\''b'\'':
        switch (*p ++) {
        case '\''a'\'':
            if (*p == 0)
                return "ba";
            return NULL;
        case '\''b'\'':
            if (*p == 0)
                return "bb";
        }
        return NULL;
    case '\''c'\'':
        if (*p == 0)
            return "c";
    }
    return NULL;
$ print a bb ba cc|test-trie
    switch (*p ++) {
    case '\''a'\'':
        if (*p == 0)
            return "a";
        return NULL;
    case '\''b'\'':
        switch (*p ++) {
        case '\''a'\'':
            if (*p == 0)
                return "ba";
            return NULL;
        case '\''b'\'':
            if (*p == 0)
                return "bb";
        }
        return NULL;
    case '\''c'\'':
        if (*p ++ == '\''c'\'' &&
            *p == 0)
            return "cc";
    }
    return NULL;
$ print a bb ba ccc|test-trie
    switch (*p ++) {
    case '\''a'\'':
        if (*p == 0)
            return "a";
        return NULL;
    case '\''b'\'':
        switch (*p ++) {
        case '\''a'\'':
            if (*p == 0)
                return "ba";
            return NULL;
        case '\''b'\'':
            if (*p == 0)
                return "bb";
        }
        return NULL;
    case '\''c'\'':
        if (!strcmp(p, "cc"))
            return "ccc";
    }
    return NULL;
$ print a bb ba cde|test-trie
    switch (*p ++) {
    case '\''a'\'':
        if (*p == 0)
            return "a";
        return NULL;
    case '\''b'\'':
        switch (*p ++) {
        case '\''a'\'':
            if (*p == 0)
                return "ba";
            return NULL;
        case '\''b'\'':
            if (*p == 0)
                return "bb";
        }
        return NULL;
    case '\''c'\'':
        if (!strcmp(p, "de"))
            return "cde";
    }
    return NULL;
$ print a bb ba cdef|test-trie
    switch (*p ++) {
    case '\''a'\'':
        if (*p == 0)
            return "a";
        return NULL;
    case '\''b'\'':
        switch (*p ++) {
        case '\''a'\'':
            if (*p == 0)
                return "ba";
            return NULL;
        case '\''b'\'':
            if (*p == 0)
                return "bb";
        }
        return NULL;
    case '\''c'\'':
        if (!strcmp(p, "def"))
            return "cdef";
    }
    return NULL;
$ print a bb ba cdef cdefg|test-trie
    switch (*p ++) {
    case '\''a'\'':
        if (*p == 0)
            return "a";
        return NULL;
    case '\''b'\'':
        switch (*p ++) {
        case '\''a'\'':
            if (*p == 0)
                return "ba";
            return NULL;
        case '\''b'\'':
            if (*p == 0)
                return "bb";
        }
        return NULL;
    case '\''c'\'':
        if (prefix("def", p)) {
            p += 3;
            if (*p == 0)
                return "cdef";
            if (*p ++ == '\''g'\'' &&
                *p == 0)
                return "cdefg";
        }
    }
    return NULL;
$ print a bb bac cdef|test-trie
    switch (*p ++) {
    case '\''a'\'':
        if (*p == 0)
            return "a";
        return NULL;
    case '\''b'\'':
        switch (*p ++) {
        case '\''a'\'':
            if (*p ++ == '\''c'\'' &&
                *p == 0)
                return "bac";
            return NULL;
        case '\''b'\'':
            if (*p == 0)
                return "bb";
        }
        return NULL;
    case '\''c'\'':
        if (!strcmp(p, "def"))
            return "cdef";
    }
    return NULL;
$ print a bbx ba ccc|test-trie
    switch (*p ++) {
    case '\''a'\'':
        if (*p == 0)
            return "a";
        return NULL;
    case '\''b'\'':
        switch (*p ++) {
        case '\''a'\'':
            if (*p == 0)
                return "ba";
            return NULL;
        case '\''b'\'':
            if (*p ++ == '\''x'\'' &&
                *p == 0)
                return "bbx";
        }
        return NULL;
    case '\''c'\'':
        if (!strcmp(p, "cc"))
            return "ccc";
    }
    return NULL;
$ print a bbx bay ccc|test-trie
    switch (*p ++) {
    case '\''a'\'':
        if (*p == 0)
            return "a";
        return NULL;
    case '\''b'\'':
        switch (*p ++) {
        case '\''a'\'':
            if (*p ++ == '\''y'\'' &&
                *p == 0)
                return "bay";
            return NULL;
        case '\''b'\'':
            if (*p ++ == '\''x'\'' &&
                *p == 0)
                return "bbx";
        }
        return NULL;
    case '\''c'\'':
        if (!strcmp(p, "cc"))
            return "ccc";
    }
    return NULL;
$ print a cde cdef|test-trie
    switch (*p ++) {
    case '\''a'\'':
        if (*p == 0)
            return "a";
        return NULL;
    case '\''c'\'':
        if (prefix("de", p)) {
            p += 2;
            if (*p == 0)
                return "cde";
            if (*p ++ == '\''f'\'' &&
                *p == 0)
                return "cdef";
        }
    }
    return NULL;
$ print a cde cdef cdefg|test-trie
    switch (*p ++) {
    case '\''a'\'':
        if (*p == 0)
            return "a";
        return NULL;
    case '\''c'\'':
        if (prefix("de", p)) {
            p += 2;
            if (*p == 0)
                return "cde";
            if (*p ++ == '\''f'\'') {
                if (*p == 0)
                    return "cdef";
                if (*p ++ == '\''g'\'' &&
                    *p == 0)
                    return "cdefg";
            }
        }
    }
    return NULL;
$ print a cde cdef cdefgh|test-trie
    switch (*p ++) {
    case '\''a'\'':
        if (*p == 0)
            return "a";
        return NULL;
    case '\''c'\'':
        if (prefix("de", p)) {
            p += 2;
            if (*p == 0)
                return "cde";
            if (*p ++ == '\''f'\'') {
                if (*p == 0)
                    return "cdef";
                if (!strcmp(p, "gh"))
                    return "cdefgh";
            }
        }
    }
    return NULL;
$ print a cdef cdefg|test-trie
    switch (*p ++) {
    case '\''a'\'':
        if (*p == 0)
            return "a";
        return NULL;
    case '\''c'\'':
        if (prefix("def", p)) {
            p += 3;
            if (*p == 0)
                return "cdef";
            if (*p ++ == '\''g'\'' &&
                *p == 0)
                return "cdefg";
        }
    }
    return NULL;
$ print ab|test-trie
    if (!strcmp(p, "ab"))
        return "ab";
    return NULL;
$ print ab bb ba ccc|test-trie
    switch (*p ++) {
    case '\''a'\'':
        if (*p ++ == '\''b'\'' &&
            *p == 0)
            return "ab";
        return NULL;
    case '\''b'\'':
        switch (*p ++) {
        case '\''a'\'':
            if (*p == 0)
                return "ba";
            return NULL;
        case '\''b'\'':
            if (*p == 0)
                return "bb";
        }
        return NULL;
    case '\''c'\'':
        if (!strcmp(p, "cc"))
            return "ccc";
    }
    return NULL;
$ print ab bb ba cde|test-trie
    switch (*p ++) {
    case '\''a'\'':
        if (*p ++ == '\''b'\'' &&
            *p == 0)
            return "ab";
        return NULL;
    case '\''b'\'':
        switch (*p ++) {
        case '\''a'\'':
            if (*p == 0)
                return "ba";
            return NULL;
        case '\''b'\'':
            if (*p == 0)
                return "bb";
        }
        return NULL;
    case '\''c'\'':
        if (!strcmp(p, "de"))
            return "cde";
    }
    return NULL;
$ print ab bbx ba ccc|test-trie
    switch (*p ++) {
    case '\''a'\'':
        if (*p ++ == '\''b'\'' &&
            *p == 0)
            return "ab";
        return NULL;
    case '\''b'\'':
        switch (*p ++) {
        case '\''a'\'':
            if (*p == 0)
                return "ba";
            return NULL;
        case '\''b'\'':
            if (*p ++ == '\''x'\'' &&
                *p == 0)
                return "bbx";
        }
        return NULL;
    case '\''c'\'':
        if (!strcmp(p, "cc"))
            return "ccc";
    }
    return NULL;
$ print ab c|test-trie
    switch (*p ++) {
    case '\''a'\'':
        if (*p ++ == '\''b'\'' &&
            *p == 0)
            return "ab";
        return NULL;
    case '\''c'\'':
        if (*p == 0)
            return "c";
    }
    return NULL;
$ print abc bb ba ccc|test-trie
    switch (*p ++) {
    case '\''a'\'':
        if (!strcmp(p, "bc"))
            return "abc";
        return NULL;
    case '\''b'\'':
        switch (*p ++) {
        case '\''a'\'':
            if (*p == 0)
                return "ba";
            return NULL;
        case '\''b'\'':
            if (*p == 0)
                return "bb";
        }
        return NULL;
    case '\''c'\'':
        if (!strcmp(p, "cc"))
            return "ccc";
    }
    return NULL;
$ print abcd abde abef|test-trie
    if (prefix("ab", p)) {
        p += 2;
        switch (*p ++) {
        case '\''c'\'':
            if (*p ++ == '\''d'\'' &&
                *p == 0)
                return "abcd";
            return NULL;
        case '\''d'\'':
            if (*p ++ == '\''e'\'' &&
                *p == 0)
                return "abde";
            return NULL;
        case '\''e'\'':
            if (*p ++ == '\''f'\'' &&
                *p == 0)
                return "abef";
        }
    }
    return NULL;
$ print abg a abc ab abd|test-trie
    if (*p ++ == '\''a'\'') {
        if (*p == 0)
            return "a";
        if (*p ++ == '\''b'\'') {
            if (*p == 0)
                return "ab";
            switch (*p ++) {
            case '\''c'\'':
                if (*p == 0)
                    return "abc";
                return NULL;
            case '\''d'\'':
                if (*p == 0)
                    return "abd";
                return NULL;
            case '\''g'\'':
                if (*p == 0)
                    return "abg";
            }
        }
    }
    return NULL;
$ print ac ab|test-trie
    if (*p ++ == '\''a'\'') {
        switch (*p ++) {
        case '\''b'\'':
            if (*p == 0)
                return "ab";
            return NULL;
        case '\''c'\'':
            if (*p == 0)
                return "ac";
        }
    }
    return NULL;
$ print aef ae abg a abc ab abd|test-trie
    if (*p ++ == '\''a'\'') {
        if (*p == 0)
            return "a";
        switch (*p ++) {
        case '\''b'\'':
            if (*p == 0)
                return "ab";
            switch (*p ++) {
            case '\''c'\'':
                if (*p == 0)
                    return "abc";
                return NULL;
            case '\''d'\'':
                if (*p == 0)
                    return "abd";
                return NULL;
            case '\''g'\'':
                if (*p == 0)
                    return "abg";
            }
            return NULL;
        case '\''e'\'':
            if (*p == 0)
                return "ae";
            if (*p ++ == '\''f'\'' &&
                *p == 0)
                return "aef";
        }
    }
    return NULL;
$ print cde cdef cdefgh|test-trie
    if (prefix("cde", p)) {
        p += 3;
        if (*p == 0)
            return "cde";
        if (*p ++ == '\''f'\'') {
            if (*p == 0)
                return "cdef";
            if (!strcmp(p, "gh"))
                return "cdefgh";
        }
    }
    return NULL;
$ print cdef cdefg|test-trie
    if (prefix("cdef", p)) {
        p += 4;
        if (*p == 0)
            return "cdef";
        if (*p ++ == '\''g'\'' &&
            *p == 0)
            return "cdefg";
    }
    return NULL;
$ print cdex cdfy cdgz cdhw|test-trie
    if (prefix("cd", p)) {
        p += 2;
        switch (*p ++) {
        case '\''e'\'':
            if (*p ++ == '\''x'\'' &&
                *p == 0)
                return "cdex";
            return NULL;
        case '\''f'\'':
            if (*p ++ == '\''y'\'' &&
                *p == 0)
                return "cdfy";
            return NULL;
        case '\''g'\'':
            if (*p ++ == '\''z'\'' &&
                *p == 0)
                return "cdgz";
            return NULL;
        case '\''h'\'':
            if (*p ++ == '\''w'\'' &&
                *p == 0)
                return "cdhw";
        }
    }
    return NULL;
$ print ce cdex cdfy cdgz cdhw|test-trie
    if (*p ++ == '\''c'\'') {
        switch (*p ++) {
        case '\''d'\'':
            switch (*p ++) {
            case '\''e'\'':
                if (*p ++ == '\''x'\'' &&
                    *p == 0)
                    return "cdex";
                return NULL;
            case '\''f'\'':
                if (*p ++ == '\''y'\'' &&
                    *p == 0)
                    return "cdfy";
                return NULL;
            case '\''g'\'':
                if (*p ++ == '\''z'\'' &&
                    *p == 0)
                    return "cdgz";
                return NULL;
            case '\''h'\'':
                if (*p ++ == '\''w'\'' &&
                    *p == 0)
                    return "cdhw";
            }
            return NULL;
        case '\''e'\'':
            if (*p == 0)
                return "ce";
        }
    }
    return NULL;
$ print pot potato pottery tattoo tempo|test-trie
    switch (*p ++) {
    case '\''p'\'':
        if (prefix("ot", p)) {
            p += 2;
            if (*p == 0)
                return "pot";
            switch (*p ++) {
            case '\''a'\'':
                if (!strcmp(p, "to"))
                    return "potato";
                return NULL;
            case '\''t'\'':
                if (!strcmp(p, "ery"))
                    return "pottery";
            }
        }
        return NULL;
    case '\''t'\'':
        switch (*p ++) {
        case '\''a'\'':
            if (!strcmp(p, "ttoo"))
                return "tattoo";
            return NULL;
        case '\''e'\'':
            if (!strcmp(p, "mpo"))
                return "tempo";
        }
    }
    return NULL;'
) -L gen-code-function-strcmp-base0.new <(
echo '$ test -x ../lib/test-trie'
test -x ../lib/test-trie 2>&1 ||
echo 'command failed: test -x ../lib/test-trie'

echo '$ print() { printf '\''%s\n'\'' "$@"; }'
print() { printf '%s\n' "$@"; } 2>&1 ||
echo 'command failed: print() { printf '\''%s\n'\'' "$@"; }'

echo '$ set -o pipefail'
set -o pipefail 2>&1 ||
echo 'command failed: set -o pipefail'

echo '$ test-trie() { ../lib/test-trie -G --no-expanded-path --strcmp-func; }'
test-trie() { ../lib/test-trie -G --no-expanded-path --strcmp-func; } 2>&1 ||
echo 'command failed: test-trie() { ../lib/test-trie -G --no-expanded-path --strcmp-func; }'

echo '$ print a|test-trie'
print a|test-trie 2>&1 ||
echo 'command failed: print a|test-trie'

echo '$ print a ab|test-trie'
print a ab|test-trie 2>&1 ||
echo 'command failed: print a ab|test-trie'

echo '$ print a ab abc|test-trie'
print a ab abc|test-trie 2>&1 ||
echo 'command failed: print a ab abc|test-trie'

echo '$ print a b|test-trie'
print a b|test-trie 2>&1 ||
echo 'command failed: print a b|test-trie'

echo '$ print a b abc bac abd|test-trie'
print a b abc bac abd|test-trie 2>&1 ||
echo 'command failed: print a b abc bac abd|test-trie'

echo '$ print a bb ba c|test-trie'
print a bb ba c|test-trie 2>&1 ||
echo 'command failed: print a bb ba c|test-trie'

echo '$ print a bb ba cc|test-trie'
print a bb ba cc|test-trie 2>&1 ||
echo 'command failed: print a bb ba cc|test-trie'

echo '$ print a bb ba ccc|test-trie'
print a bb ba ccc|test-trie 2>&1 ||
echo 'command failed: print a bb ba ccc|test-trie'

echo '$ print a bb ba cde|test-trie'
print a bb ba cde|test-trie 2>&1 ||
echo 'command failed: print a bb ba cde|test-trie'

echo '$ print a bb ba cdef|test-trie'
print a bb ba cdef|test-trie 2>&1 ||
echo 'command failed: print a bb ba cdef|test-trie'

echo '$ print a bb ba cdef cdefg|test-trie'
print a bb ba cdef cdefg|test-trie 2>&1 ||
echo 'command failed: print a bb ba cdef cdefg|test-trie'

echo '$ print a bb bac cdef|test-trie'
print a bb bac cdef|test-trie 2>&1 ||
echo 'command failed: print a bb bac cdef|test-trie'

echo '$ print a bbx ba ccc|test-trie'
print a bbx ba ccc|test-trie 2>&1 ||
echo 'command failed: print a bbx ba ccc|test-trie'

echo '$ print a bbx bay ccc|test-trie'
print a bbx bay ccc|test-trie 2>&1 ||
echo 'command failed: print a bbx bay ccc|test-trie'

echo '$ print a cde cdef|test-trie'
print a cde cdef|test-trie 2>&1 ||
echo 'command failed: print a cde cdef|test-trie'

echo '$ print a cde cdef cdefg|test-trie'
print a cde cdef cdefg|test-trie 2>&1 ||
echo 'command failed: print a cde cdef cdefg|test-trie'

echo '$ print a cde cdef cdefgh|test-trie'
print a cde cdef cdefgh|test-trie 2>&1 ||
echo 'command failed: print a cde cdef cdefgh|test-trie'

echo '$ print a cdef cdefg|test-trie'
print a cdef cdefg|test-trie 2>&1 ||
echo 'command failed: print a cdef cdefg|test-trie'

echo '$ print ab|test-trie'
print ab|test-trie 2>&1 ||
echo 'command failed: print ab|test-trie'

echo '$ print ab bb ba ccc|test-trie'
print ab bb ba ccc|test-trie 2>&1 ||
echo 'command failed: print ab bb ba ccc|test-trie'

echo '$ print ab bb ba cde|test-trie'
print ab bb ba cde|test-trie 2>&1 ||
echo 'command failed: print ab bb ba cde|test-trie'

echo '$ print ab bbx ba ccc|test-trie'
print ab bbx ba ccc|test-trie 2>&1 ||
echo 'command failed: print ab bbx ba ccc|test-trie'

echo '$ print ab c|test-trie'
print ab c|test-trie 2>&1 ||
echo 'command failed: print ab c|test-trie'

echo '$ print abc bb ba ccc|test-trie'
print abc bb ba ccc|test-trie 2>&1 ||
echo 'command failed: print abc bb ba ccc|test-trie'

echo '$ print abcd abde abef|test-trie'
print abcd abde abef|test-trie 2>&1 ||
echo 'command failed: print abcd abde abef|test-trie'

echo '$ print abg a abc ab abd|test-trie'
print abg a abc ab abd|test-trie 2>&1 ||
echo 'command failed: print abg a abc ab abd|test-trie'

echo '$ print ac ab|test-trie'
print ac ab|test-trie 2>&1 ||
echo 'command failed: print ac ab|test-trie'

echo '$ print aef ae abg a abc ab abd|test-trie'
print aef ae abg a abc ab abd|test-trie 2>&1 ||
echo 'command failed: print aef ae abg a abc ab abd|test-trie'

echo '$ print cde cdef cdefgh|test-trie'
print cde cdef cdefgh|test-trie 2>&1 ||
echo 'command failed: print cde cdef cdefgh|test-trie'

echo '$ print cdef cdefg|test-trie'
print cdef cdefg|test-trie 2>&1 ||
echo 'command failed: print cdef cdefg|test-trie'

echo '$ print cdex cdfy cdgz cdhw|test-trie'
print cdex cdfy cdgz cdhw|test-trie 2>&1 ||
echo 'command failed: print cdex cdfy cdgz cdhw|test-trie'

echo '$ print ce cdex cdfy cdgz cdhw|test-trie'
print ce cdex cdfy cdgz cdhw|test-trie 2>&1 ||
echo 'command failed: print ce cdex cdfy cdgz cdhw|test-trie'

echo '$ print pot potato pottery tattoo tempo|test-trie'
print pot potato pottery tattoo tempo|test-trie 2>&1 ||
echo 'command failed: print pot potato pottery tattoo tempo|test-trie'
)

