#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-gen-def-gcc:defs
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L defs.old <(echo \
'$ set -o pipefail
$ json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r $'\''1i\\\\\\#include "json-type.h"\n'\'''\'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''|tee /dev/fd/2|sed -r '\''s/^\\//'\''|gcc -Wall -Wextra -std=gnu99 -I ../lib -xc -c - -o /dev/null; }
$ json <<< '\''[{"name":"type","type":"type"},{"name":"null","type":"null"},{"name":"boolean","type":"boolean"},{"name":"number","type":"number"},{"name":"string","type":"string"},{"name":"object","type":"object"},{"name":"array","type":"array"}]'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __2 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __5 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t __6 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_defs_arg_t __7[] = {
    {
        .name = (const uchar_t*) "type",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "null",
        .type = &__1
    },
    {
        .name = (const uchar_t*) "boolean",
        .type = &__2
    },
    {
        .name = (const uchar_t*) "number",
        .type = &__3
    },
    {
        .name = (const uchar_t*) "string",
        .type = &__4
    },
    {
        .name = (const uchar_t*) "object",
        .type = &__5
    },
    {
        .name = (const uchar_t*) "array",
        .type = &__6
    }
};
static const struct json_type_defs_t __8 = {
    .args = __7,
    .size = 7
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_defs_type,
    .val.defs = &__8
};
$ json <<< '\''[{"name":"null","type":{"plain":null}},{"name":"false","type":{"plain":false}},{"name":"true","type":{"plain":true}},{"name":"123","type":{"plain":123}},{"name":"\"foo\"","type":{"plain":"foo"}}]'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_plain_node_type,
    .node.plain = {
        .type = json_type_plain_null_type,
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_plain_node_type,
    .node.plain = {
        .type = json_type_plain_boolean_type,
        .val.boolean = false
    }
};
static const struct json_type_node_t __2 = {
    .type = json_type_plain_node_type,
    .node.plain = {
        .type = json_type_plain_boolean_type,
        .val.boolean = true
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_plain_node_type,
    .node.plain = {
        .type = json_type_plain_number_type,
        .val.number = (const uchar_t*) "123"
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_plain_node_type,
    .node.plain = {
        .type = json_type_plain_string_type,
        .val.string = (const uchar_t*) "foo"
    }
};
static const struct json_type_defs_arg_t __5[] = {
    {
        .name = (const uchar_t*) "null",
        .type = &__0
    },
    {
        .name = (const uchar_t*) "false",
        .type = &__1
    },
    {
        .name = (const uchar_t*) "true",
        .type = &__2
    },
    {
        .name = (const uchar_t*) "123",
        .type = &__3
    },
    {
        .name = (const uchar_t*) "\"foo\"",
        .type = &__4
    }
};
static const struct json_type_defs_t __6 = {
    .args = __5,
    .size = 5
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_defs_type,
    .val.defs = &__6
};
$ json <<< '\''[{"name":"object","type":{"type":"object","args":[]}},{"name":"object2","type":{"type":"object","args":[{"name":"arg","type":{"type":"object","args":[]}}]}},{"name":"object3","type":{"type":"object","args":[{"name":"name","type":{"type":"object","args":[{"name":"name","type":{"type":"object","args":[]}}]}}]}}]'\''
\#include "json-type.h"
static const struct json_type_object_node_arg_t __0[] = {
};
static const struct json_type_node_t __1 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __0,
        .size = 0
    }
};
static const struct json_type_object_node_arg_t __2[] = {
};
static const struct json_type_node_t __3 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __2,
        .size = 0
    }
};
static const struct json_type_object_node_arg_t __4[] = {
    {
        .name = (const uchar_t*) "arg",
        .type = &__3
    }
};
static const struct json_type_node_t __5 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __4,
        .size = 1
    }
};
static const struct json_type_object_node_arg_t __6[] = {
};
static const struct json_type_node_t __7 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __6,
        .size = 0
    }
};
static const struct json_type_object_node_arg_t __8[] = {
    {
        .name = (const uchar_t*) "name",
        .type = &__7
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __8,
        .size = 1
    }
};
static const struct json_type_object_node_arg_t __10[] = {
    {
        .name = (const uchar_t*) "name",
        .type = &__9
    }
};
static const struct json_type_node_t __11 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __10,
        .size = 1
    }
};
static const struct json_type_defs_arg_t __12[] = {
    {
        .name = (const uchar_t*) "object",
        .type = &__1
    },
    {
        .name = (const uchar_t*) "object2",
        .type = &__5
    },
    {
        .name = (const uchar_t*) "object3",
        .type = &__11
    }
};
static const struct json_type_defs_t __13 = {
    .args = __12,
    .size = 3
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_defs_type,
    .val.defs = &__13
};
$ json <<< '\''[{"name":"open-array","type":{"type":"array","args":"type"}},{"name":"open-array2","type":{"type":"array","args":{"type":"array","args":"type"}}},{"name":"open-array3","type":{"type":"array","args":{"type":"array","args":{"type":"array","args":"type"}}}}]'\''
\#include "json-type.h"
static const struct json_type_node_t __0 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __1 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__0
    }
};
static const struct json_type_node_t __2 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__2
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__3
    }
};
static const struct json_type_node_t __5 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __6 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__5
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__6
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__7
    }
};
static const struct json_type_defs_arg_t __9[] = {
    {
        .name = (const uchar_t*) "open-array",
        .type = &__1
    },
    {
        .name = (const uchar_t*) "open-array2",
        .type = &__4
    },
    {
        .name = (const uchar_t*) "open-array3",
        .type = &__8
    }
};
static const struct json_type_defs_t __10 = {
    .args = __9,
    .size = 3
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_defs_type,
    .val.defs = &__10
};
$ json <<< '\''[{"name":"closed-array","type":{"type":"array","args":[]}},{"name":"closed-array2","type":{"type":"array","args":[{"type":"array","args":[]}]}},{"name":"closed-array3","type":{"type":"array","args":[{"type":"array","args":[{"type":"array","args":[]}]}]}}]'\''
\#include "json-type.h"
static const struct json_type_node_t* __0[] = {
    NULL
};
static const struct json_type_node_t __1 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __0,
            .size = 0
        }
    }
};
static const struct json_type_node_t* __2[] = {
    NULL
};
static const struct json_type_node_t __3 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __2,
            .size = 0
        }
    }
};
static const struct json_type_node_t* __4[] = {
    &__3,
    NULL
};
static const struct json_type_node_t __5 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __4,
            .size = 1
        }
    }
};
static const struct json_type_node_t* __6[] = {
    NULL
};
static const struct json_type_node_t __7 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __6,
            .size = 0
        }
    }
};
static const struct json_type_node_t* __8[] = {
    &__7,
    NULL
};
static const struct json_type_node_t __9 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __8,
            .size = 1
        }
    }
};
static const struct json_type_node_t* __10[] = {
    &__9,
    NULL
};
static const struct json_type_node_t __11 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_closed_array_node_type,
        .val.closed = {
            .args = __10,
            .size = 1
        }
    }
};
static const struct json_type_defs_arg_t __12[] = {
    {
        .name = (const uchar_t*) "closed-array",
        .type = &__1
    },
    {
        .name = (const uchar_t*) "closed-array2",
        .type = &__5
    },
    {
        .name = (const uchar_t*) "closed-array3",
        .type = &__11
    }
};
static const struct json_type_defs_t __13 = {
    .args = __12,
    .size = 3
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_defs_type,
    .val.defs = &__13
};
$ json <<< '\''[{"name":"list","type":{"type":"list","args":[]}},{"name":"list2","type":{"type":"list","args":["type","null","boolean","number","string","object","array",{"plain":null},{"plain":false},{"plain":true},{"plain":123},{"plain":"foo"},{"type":"object","args":[]},{"type":"object","args":[{"name":"bar","type":"object"}]},{"type":"array","args":"array"}]}}]'\''
\#include "json-type.h"
\#define EQ  cell.eq
\#define VAL cell.val
static const struct json_type_list_attr_t __0;
static const struct json_type_node_t* __1[] = {
    NULL
};
static const struct json_type_node_t __2 = {
    .type = json_type_list_node_type,
    .attr.list = &__0,
    .node.list = {
        .args = __1,
        .size = 0
    }
};
static const struct json_type_node_t __3 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_type_type
    }
};
static const struct json_type_node_t __4 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_null_type
    }
};
static const struct json_type_node_t __5 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_boolean_type
    }
};
static const struct json_type_node_t __6 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_number_type
    }
};
static const struct json_type_node_t __7 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_string_type
    }
};
static const struct json_type_node_t __8 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_node_t __9 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t __10 = {
    .type = json_type_plain_node_type,
    .node.plain = {
        .type = json_type_plain_null_type,
    }
};
static const struct json_type_node_t __11 = {
    .type = json_type_plain_node_type,
    .node.plain = {
        .type = json_type_plain_boolean_type,
        .val.boolean = false
    }
};
static const struct json_type_node_t __12 = {
    .type = json_type_plain_node_type,
    .node.plain = {
        .type = json_type_plain_boolean_type,
        .val.boolean = true
    }
};
static const struct json_type_node_t __13 = {
    .type = json_type_plain_node_type,
    .node.plain = {
        .type = json_type_plain_number_type,
        .val.number = (const uchar_t*) "123"
    }
};
static const struct json_type_node_t __14 = {
    .type = json_type_plain_node_type,
    .node.plain = {
        .type = json_type_plain_string_type,
        .val.string = (const uchar_t*) "foo"
    }
};
static const struct json_type_object_node_arg_t __15[] = {
};
static const struct json_type_node_t __16 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __15,
        .size = 0
    }
};
static const struct json_type_node_t __17 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_object_type
    }
};
static const struct json_type_object_node_arg_t __18[] = {
    {
        .name = (const uchar_t*) "bar",
        .type = &__17
    }
};
static const struct json_type_node_t __19 = {
    .type = json_type_object_node_type,
    .node.object = {
        .args = __18,
        .size = 1
    }
};
static const struct json_type_node_t __20 = {
    .type = json_type_any_node_type,
    .node.any = {
        .type = json_type_any_array_type
    }
};
static const struct json_type_node_t __21 = {
    .type = json_type_array_node_type,
    .node.array = {
        .type = json_type_open_array_node_type,
        .val.open.arg = &__20
    }
};
static const struct json_type_trie_node_t __22 = {
    .sym = NULL,
    .VAL = &__4
};
static const struct json_type_trie_node_t __23 = {
    .sym = &__4,
    .EQ = &__22
};
static const struct json_type_trie_node_t __24 = {
    .sym = NULL,
    .VAL = &__5
};
static const struct json_type_trie_node_t __25 = {
    .sym = NULL,
    .VAL = &__6
};
static const struct json_type_trie_node_t __26 = {
    .sym = &__6,
    .EQ = &__25
};
static const struct json_type_trie_node_t __27 = {
    .sym = &__5,
    .lo = &__23,
    .EQ = &__24,
    .hi = &__26
};
static const struct json_type_trie_node_t __28 = {
    .sym = NULL,
    .VAL = &__7
};
static const struct json_type_trie_node_t __29 = {
    .sym = NULL,
    .VAL = &__8
};
static const struct json_type_trie_node_t __30 = {
    .sym = &__8,
    .EQ = &__29
};
static const struct json_type_trie_node_t __31 = {
    .sym = NULL,
    .VAL = &__9
};
static const struct json_type_trie_node_t __32 = {
    .sym = NULL,
    .VAL = &__3
};
static const struct json_type_trie_node_t __33 = {
    .sym = &__3,
    .EQ = &__32
};
static const struct json_type_trie_node_t __34 = {
    .sym = &__9,
    .lo = &__30,
    .EQ = &__31,
    .hi = &__33
};
static const struct json_type_trie_node_t __35 = {
    .sym = &__7,
    .lo = &__27,
    .EQ = &__28,
    .hi = &__34
};
static const struct json_type_trie_t __36 = {
    .root = &__35
};
static const struct json_type_trie_node_t __37 = {
    .sym = NULL,
    .VAL = &__10
};
static const struct json_type_trie_node_t __38 = {
    .sym = &__10,
    .EQ = &__37
};
static const struct json_type_trie_node_t __39 = {
    .sym = NULL,
    .VAL = &__11
};
static const struct json_type_trie_node_t __40 = {
    .sym = NULL,
    .VAL = &__12
};
static const struct json_type_trie_node_t __41 = {
    .sym = &__12,
    .EQ = &__40
};
static const struct json_type_trie_node_t __42 = {
    .sym = &__11,
    .lo = &__38,
    .EQ = &__39,
    .hi = &__41
};
static const struct json_type_trie_node_t __43 = {
    .sym = NULL,
    .VAL = &__13
};
static const struct json_type_trie_node_t __44 = {
    .sym = NULL,
    .VAL = &__14
};
static const struct json_type_trie_node_t __45 = {
    .sym = &__14,
    .EQ = &__44
};
static const struct json_type_trie_node_t __46 = {
    .sym = &__13,
    .lo = &__42,
    .EQ = &__43,
    .hi = &__45
};
static const struct json_type_trie_t __47 = {
    .root = &__46
};
static const struct json_type_object_trie_node_t __48 = {
    .sym = {
        .type = json_type_object_sym_null_type
    },
    .VAL = &__16
};
static const struct json_type_object_trie_node_t __49 = {
    .sym = {
        .type = json_type_object_sym_null_type
    },
    .VAL = &__19
};
static const struct json_type_object_trie_node_t __50 = {
    .sym = {
        .type = json_type_object_sym_node_type,
        .val.node = &__17
    },
    .EQ = &__49
};
static const struct json_type_object_trie_node_t __51 = {
    .sym = {
        .type = json_type_object_sym_name_type,
        .val.name = (const uchar_t*) "bar"
    },
    .lo = &__48,
    .EQ = &__50
};
static const struct json_type_object_trie_t __52 = {
    .root = &__51
};
static const struct json_type_trie_node_t __53 = {
    .sym = NULL,
    .VAL = &__21
};
static const struct json_type_trie_node_t __54 = {
    .sym = &__20,
    .EQ = &__53
};
static const struct json_type_trie_t __55 = {
    .root = &__54
};
static const struct json_type_list_attr_t __56 = {
    .any = &__36,
    .plain = &__47,
    .object = &__52,
    .open_array = &__55
};
static const struct json_type_node_t* __57[] = {
    &__3,
    &__4,
    &__5,
    &__6,
    &__7,
    &__8,
    &__9,
    &__10,
    &__11,
    &__12,
    &__13,
    &__14,
    &__16,
    &__19,
    &__21,
    NULL
};
static const struct json_type_node_t __58 = {
    .type = json_type_list_node_type,
    .attr.list = &__56,
    .node.list = {
        .args = __57,
        .size = 15
    }
};
static const struct json_type_defs_arg_t __59[] = {
    {
        .name = (const uchar_t*) "list",
        .type = &__2
    },
    {
        .name = (const uchar_t*) "list2",
        .type = &__58
    }
};
static const struct json_type_defs_t __60 = {
    .args = __59,
    .size = 2
};
static const struct json_type_def_t MODULE_TYPE_DEF = {
    .type = json_type_def_defs_type,
    .val.defs = &__60
};'
) -L defs.new <(
echo '$ set -o pipefail'
set -o pipefail 2>&1 ||
echo 'command failed: set -o pipefail'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r $'\''1i\\\\\\#include "json-type.h"\n'\'''\'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''|tee /dev/fd/2|sed -r '\''s/^\\//'\''|gcc -Wall -Wextra -std=gnu99 -I ../lib -xc -c - -o /dev/null; }'
json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r $'1i\\\\\\#include "json-type.h"\n'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'|tee /dev/fd/2|sed -r 's/^\\//'|gcc -Wall -Wextra -std=gnu99 -I ../lib -xc -c - -o /dev/null; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json -Td "$@"|sed -r $'\''1i\\\\\\#include "json-type.h"\n'\'''\'';s/^#/\\#/;/^\s*\/\//d;/^\s*$/d'\''|tee /dev/fd/2|sed -r '\''s/^\\//'\''|gcc -Wall -Wextra -std=gnu99 -I ../lib -xc -c - -o /dev/null; }'

echo '$ json <<< '\''[{"name":"type","type":"type"},{"name":"null","type":"null"},{"name":"boolean","type":"boolean"},{"name":"number","type":"number"},{"name":"string","type":"string"},{"name":"object","type":"object"},{"name":"array","type":"array"}]'\'''
json <<< '[{"name":"type","type":"type"},{"name":"null","type":"null"},{"name":"boolean","type":"boolean"},{"name":"number","type":"number"},{"name":"string","type":"string"},{"name":"object","type":"object"},{"name":"array","type":"array"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"type","type":"type"},{"name":"null","type":"null"},{"name":"boolean","type":"boolean"},{"name":"number","type":"number"},{"name":"string","type":"string"},{"name":"object","type":"object"},{"name":"array","type":"array"}]'\'''

echo '$ json <<< '\''[{"name":"null","type":{"plain":null}},{"name":"false","type":{"plain":false}},{"name":"true","type":{"plain":true}},{"name":"123","type":{"plain":123}},{"name":"\"foo\"","type":{"plain":"foo"}}]'\'''
json <<< '[{"name":"null","type":{"plain":null}},{"name":"false","type":{"plain":false}},{"name":"true","type":{"plain":true}},{"name":"123","type":{"plain":123}},{"name":"\"foo\"","type":{"plain":"foo"}}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"null","type":{"plain":null}},{"name":"false","type":{"plain":false}},{"name":"true","type":{"plain":true}},{"name":"123","type":{"plain":123}},{"name":"\"foo\"","type":{"plain":"foo"}}]'\'''

echo '$ json <<< '\''[{"name":"object","type":{"type":"object","args":[]}},{"name":"object2","type":{"type":"object","args":[{"name":"arg","type":{"type":"object","args":[]}}]}},{"name":"object3","type":{"type":"object","args":[{"name":"name","type":{"type":"object","args":[{"name":"name","type":{"type":"object","args":[]}}]}}]}}]'\'''
json <<< '[{"name":"object","type":{"type":"object","args":[]}},{"name":"object2","type":{"type":"object","args":[{"name":"arg","type":{"type":"object","args":[]}}]}},{"name":"object3","type":{"type":"object","args":[{"name":"name","type":{"type":"object","args":[{"name":"name","type":{"type":"object","args":[]}}]}}]}}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"object","type":{"type":"object","args":[]}},{"name":"object2","type":{"type":"object","args":[{"name":"arg","type":{"type":"object","args":[]}}]}},{"name":"object3","type":{"type":"object","args":[{"name":"name","type":{"type":"object","args":[{"name":"name","type":{"type":"object","args":[]}}]}}]}}]'\'''

echo '$ json <<< '\''[{"name":"open-array","type":{"type":"array","args":"type"}},{"name":"open-array2","type":{"type":"array","args":{"type":"array","args":"type"}}},{"name":"open-array3","type":{"type":"array","args":{"type":"array","args":{"type":"array","args":"type"}}}}]'\'''
json <<< '[{"name":"open-array","type":{"type":"array","args":"type"}},{"name":"open-array2","type":{"type":"array","args":{"type":"array","args":"type"}}},{"name":"open-array3","type":{"type":"array","args":{"type":"array","args":{"type":"array","args":"type"}}}}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"open-array","type":{"type":"array","args":"type"}},{"name":"open-array2","type":{"type":"array","args":{"type":"array","args":"type"}}},{"name":"open-array3","type":{"type":"array","args":{"type":"array","args":{"type":"array","args":"type"}}}}]'\'''

echo '$ json <<< '\''[{"name":"closed-array","type":{"type":"array","args":[]}},{"name":"closed-array2","type":{"type":"array","args":[{"type":"array","args":[]}]}},{"name":"closed-array3","type":{"type":"array","args":[{"type":"array","args":[{"type":"array","args":[]}]}]}}]'\'''
json <<< '[{"name":"closed-array","type":{"type":"array","args":[]}},{"name":"closed-array2","type":{"type":"array","args":[{"type":"array","args":[]}]}},{"name":"closed-array3","type":{"type":"array","args":[{"type":"array","args":[{"type":"array","args":[]}]}]}}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"closed-array","type":{"type":"array","args":[]}},{"name":"closed-array2","type":{"type":"array","args":[{"type":"array","args":[]}]}},{"name":"closed-array3","type":{"type":"array","args":[{"type":"array","args":[{"type":"array","args":[]}]}]}}]'\'''

echo '$ json <<< '\''[{"name":"list","type":{"type":"list","args":[]}},{"name":"list2","type":{"type":"list","args":["type","null","boolean","number","string","object","array",{"plain":null},{"plain":false},{"plain":true},{"plain":123},{"plain":"foo"},{"type":"object","args":[]},{"type":"object","args":[{"name":"bar","type":"object"}]},{"type":"array","args":"array"}]}}]'\'''
json <<< '[{"name":"list","type":{"type":"list","args":[]}},{"name":"list2","type":{"type":"list","args":["type","null","boolean","number","string","object","array",{"plain":null},{"plain":false},{"plain":true},{"plain":123},{"plain":"foo"},{"type":"object","args":[]},{"type":"object","args":[{"name":"bar","type":"object"}]},{"type":"array","args":"array"}]}}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"list","type":{"type":"list","args":[]}},{"name":"list2","type":{"type":"list","args":["type","null","boolean","number","string","object","array",{"plain":null},{"plain":false},{"plain":true},{"plain":123},{"plain":"foo"},{"type":"object","args":[]},{"type":"object","args":[{"name":"bar","type":"object"}]},{"type":"array","args":"array"}]}}]'\'''
)

