#!/bin/bash

# Copyright (C) 2016  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -w87 -G type-checker-list
#

w=87
c=""
q=""

if [[ "$1" =~ ^-w[1-9][0-9]*$ ]]; then
    w="${1:2}"
    shift
fi
if [ "$1" == "-c" ]; then
    c="c"
    shift
fi
if [ "$1" == "-q" ]; then
    q="q"
fi

p=0
f=0

for t in \
    list-object-basic-val-basic \
    list-object-basic-val-object-empty \
    list-object-basic-val-object-basic \
    list-object-basic-val-object-basic2 \
    list-object-basic-val-object-basic-basic \
    list-object-basic-val-object-basic-basic2 \
    list-object-basic-basic-val-basic \
    list-object-basic-basic-val-object-empty \
    list-object-basic-basic-val-object-basic \
    list-object-basic-basic-val-object-basic2 \
    list-object-basic-basic-val-object-basic-basic \
    list-object-basic-basic-val-object-basic-basic2 \
    list-object-basic-basic-val-object-basic-basic3 \
    list-object-basic-plain-val-basic \
    list-object-basic-plain-val-object-empty \
    list-object-basic-plain-val-object-basic \
    list-object-basic-plain-val-object-basic2 \
    list-object-basic-plain-val-object-basic-basic \
    list-object-basic-plain-val-object-basic-basic2 \
    list-object-basic-plain-val-object-basic-basic3 \
    list-object-plain-basic-val-basic \
    list-object-plain-basic-val-object-empty \
    list-object-plain-basic-val-object-basic \
    list-object-plain-basic-val-object-basic2 \
    list-object-plain-basic-val-object-basic-basic \
    list-object-plain-basic-val-object-basic-basic2 \
    list-object-plain-basic-val-object-basic-basic3 \
    list-basic-object-basic-val-basic \
    list-basic-object-basic-val-object-empty \
    list-basic-object-basic-val-object-basic \
    list-basic-object-basic-val-object-basic2 \
    list-basic-object-basic-val-object-basic-basic \
    list-basic-object-basic-val-object-basic-basic2 \
    list-basic-object-plain-val-basic \
    list-basic-object-plain-val-object-empty \
    list-basic-object-plain-val-object-basic \
    list-basic-object-plain-val-object-basic2 \
    list-basic-object-plain-val-object-basic-basic \
    list-basic-object-plain-val-object-basic-basic2 \
    list-plain-object-basic-val-basic \
    list-plain-object-basic-val-object-empty \
    list-plain-object-basic-val-object-basic \
    list-plain-object-basic-val-object-basic2 \
    list-plain-object-basic-val-object-basic-basic \
    list-plain-object-basic-val-object-basic-basic2 \
    list-plain-object-plain-val-basic \
    list-plain-object-plain-val-array-empty \
    list-plain-object-plain-val-object-basic \
    list-plain-object-plain-val-object-basic2 \
    list-plain-object-plain-val-object-basic-basic \
    list-plain-object-plain-val-object-basic-basic2 \
    list-object-foo-basic-object-foo-basic-val-basic \
    list-object-foo-basic-object-foo-basic-val-object-fuu-basic \
    list-object-foo-basic-object-foo-basic-val-object-foo-basic \
    list-object-foo-basic-object-foo-basic-val-object-foo-basic-fuu-basic \
    list-object-foo-basic-object-bar-basic-val-basic \
    list-object-foo-basic-object-bar-basic-val-object-fuu-basic \
    list-object-foo-basic-object-bar-basic-val-object-foo-basic \
    list-object-foo-basic-object-bar-basic-val-object-bar-basic \
    list-object-foo-basic-object-bar-basic-val-object-foo-basic-fuu-basic \
    list-object-foo-basic-object-bar-basic-val-object-bar-basic-fuu-basic \
    list-object-foo-basic-object-foo-plain-val-basic \
    list-object-foo-basic-object-foo-plain-val-object-fuu-basic \
    list-object-foo-basic-object-foo-plain-val-object-foo-basic \
    list-object-foo-basic-object-foo-plain-val-object-foo-basic-fuu-basic \
    list-object-foo-basic-object-bar-plain-val-basic \
    list-object-foo-basic-object-bar-plain-val-object-fuu-basic \
    list-object-foo-basic-object-bar-plain-val-object-foo-basic \
    list-object-foo-basic-object-bar-plain-val-object-bar-basic \
    list-object-foo-basic-object-bar-plain-val-object-foo-basic-fuu-basic \
    list-object-foo-basic-object-bar-plain-val-object-bar-basic-fuu-basic \
    list-open-array-basic-val-basic \
    list-open-array-basic-val-array-empty \
    list-open-array-basic-val-array-basic \
    list-open-array-basic-val-array-basic-basic \
    list-closed-array-empty-val-basic \
    list-closed-array-empty-val-array-empty \
    list-closed-array-empty-val-array-basic \
    list-closed-array-empty-val-array-basic-basic \
    list-closed-array-empty-closed-array-basic-val-basic \
    list-closed-array-empty-closed-array-basic-val-array-empty \
    list-closed-array-empty-closed-array-basic-val-array-basic \
    list-closed-array-empty-closed-array-basic-val-array-basic-basic \
    list-closed-array-empty-closed-array-plain-val-basic \
    list-closed-array-empty-closed-array-plain-val-array-empty \
    list-closed-array-empty-closed-array-plain-val-array-basic \
    list-closed-array-empty-closed-array-plain-val-array-basic-basic \
    list-closed-array-basic-val-basic \
    list-closed-array-basic-val-array-empty \
    list-closed-array-basic-val-array-basic \
    list-closed-array-basic-val-array-basic-basic \
    list-closed-array-basic-basic-val-basic \
    list-closed-array-basic-basic-val-array-empty \
    list-closed-array-basic-basic-val-array-basic \
    list-closed-array-basic-basic-val-array-basic-basic \
    list-closed-array-basic-plain-val-basic \
    list-closed-array-basic-plain-val-array-empty \
    list-closed-array-basic-plain-val-array-basic \
    list-closed-array-basic-plain-val-array-basic-basic \
    list-open-array-plain-val-basic \
    list-open-array-plain-val-array-empty \
    list-open-array-plain-val-array-basic \
    list-open-array-plain-val-array-basic-basic \
    list-closed-array-plain-val-basic \
    list-closed-array-plain-val-array-empty \
    list-closed-array-plain-val-array-basic \
    list-closed-array-plain-val-array-basic-basic \
    list-closed-array-plain-plain-val-basic \
    list-closed-array-plain-plain-val-array-empty \
    list-closed-array-plain-plain-val-array-basic \
    list-closed-array-plain-plain-val-array-basic-basic \
    list-basic-open-array-basic-val-basic \
    list-basic-open-array-basic-val-array-empty \
    list-basic-open-array-basic-val-array-basic \
    list-basic-open-array-basic-val-array-basic-basic \
    list-basic-closed-array-basic-val-basic \
    list-basic-closed-array-basic-val-array-empty \
    list-basic-closed-array-basic-val-array-basic \
    list-basic-closed-array-basic-val-array-basic-basic \
    list-plain-open-array-basic-val-basic \
    list-plain-open-array-basic-val-array-empty \
    list-plain-open-array-basic-val-array-basic \
    list-plain-open-array-basic-val-array-basic-basic \
    list-plain-closed-array-basic-val-basic \
    list-plain-closed-array-basic-val-array-empty \
    list-plain-closed-array-basic-val-array-basic \
    list-plain-closed-array-basic-val-array-basic-basic \
    list-basic-open-array-plain-val-basic \
    list-basic-open-array-plain-val-array-empty \
    list-basic-open-array-plain-val-array-basic \
    list-basic-open-array-plain-val-array-basic-basic \
    list-basic-closed-array-plain-val-basic \
    list-basic-closed-array-plain-val-array-empty \
    list-basic-closed-array-plain-val-array-basic \
    list-basic-closed-array-plain-val-array-basic-basic \
    list-plain-open-array-plain-val-basic \
    list-plain-open-array-plain-val-array-empty \
    list-plain-open-array-plain-val-array-basic \
    list-plain-open-array-plain-val-array-basic-basic \
    list-plain-closed-array-plain-val-basic \
    list-plain-closed-array-plain-val-array-empty \
    list-plain-closed-array-plain-val-array-basic \
    list-plain-closed-array-plain-val-array-basic-basic \
    list-open-array-basic-open-array-basic-val-basic \
    list-open-array-basic-open-array-basic-val-array-empty \
    list-open-array-basic-open-array-basic-val-array-basic \
    list-open-array-basic-open-array-basic-val-array-basic-basic \
    list-open-array-basic-open-array-plain-val-basic \
    list-open-array-basic-open-array-plain-val-array-empty \
    list-open-array-basic-open-array-plain-val-array-basic \
    list-open-array-basic-open-array-plain-val-array-basic-basic \
    list-open-array-plain-open-array-plain-val-basic \
    list-open-array-plain-open-array-plain-val-array-empty \
    list-open-array-plain-open-array-plain-val-array-basic \
    list-open-array-plain-open-array-plain-val-array-basic-basic \
    list-closed-array-basic-closed-array-basic-val-basic \
    list-closed-array-basic-closed-array-basic-val-array-empty \
    list-closed-array-basic-closed-array-basic-val-array-basic \
    list-closed-array-basic-closed-array-basic-val-array-basic-basic \
    list-closed-array-basic-closed-array-plain-val-basic \
    list-closed-array-basic-closed-array-plain-val-array-empty \
    list-closed-array-basic-closed-array-plain-val-array-basic \
    list-closed-array-basic-closed-array-plain-val-array-basic-basic \
    list-closed-array-plain-closed-array-plain-val-basic \
    list-closed-array-plain-closed-array-plain-val-array-empty \
    list-closed-array-plain-closed-array-plain-val-array-basic \
    list-closed-array-plain-closed-array-plain-val-array-basic-basic \
    list-closed-array-basic-open-array-basic-val-basic \
    list-closed-array-basic-open-array-basic-val-array-empty \
    list-closed-array-basic-open-array-basic-val-array-basic \
    list-closed-array-basic-open-array-basic-val-array-basic-basic \
    list-closed-array-basic-open-array-basic-val-array-basic-basic2 \
    list-closed-array-basic-open-array-plain-val-basic
do
    test -z "$q" &&
    printf >&2 "%-$((w + 6))s " "test: type-checker-list:$t"
    if ! type-checker-list/test-$t.sh &>/dev/null; then
        (( f ++ ))

        test -n "$q" &&
        echo >&2 -n "test: type-checker-list:$t "
        echo >&2 failed
    else
        (( p ++ ))

        test -z "$q" &&
        echo >&2 OK
    fi
done

if [ -z "$c" ]; then
    [ -z "$q" -o "$f" -gt 0 ] &&
    echo >&2
    echo "tests passed: $p"
    echo "tests failed: $f"
else
    echo "$p"
    echo "$f"
fi

exit $(( r != 0 ))

