#!/bin/bash

# Copyright (C) 2016  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-object-basic-basic-val-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-object-basic-basic-val-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''[]'\'''
) -L list-object-basic-basic-val-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"type"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"null"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"boolean"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"number"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"string"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"object"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":"array"}]}]}'\'' <<< '\''[]'\'''
)

