#!/bin/bash

# Copyright (C) 2016  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:literal4
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L literal4.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --literal-value --multi-obj "$@"; }
$ echo -e '\''nullnull'\''|json -b 1
null
null
$ echo -e '\''nullnull'\''|json -b 4
null
null
$ echo -e '\''nullnull'\''|json -b 8
null
null
$ echo -e '\''nullfalse'\''|json -b 1
null
false
$ echo -e '\''nullfalse'\''|json -b 4
null
false
$ echo -e '\''nullfalse'\''|json -b 8
null
false
$ echo -e '\''nulltrue'\''|json -b 1
null
true
$ echo -e '\''nulltrue'\''|json -b 4
null
true
$ echo -e '\''nulltrue'\''|json -b 8
null
true
$ echo -e '\''falsenull'\''|json -b 1
false
null
$ echo -e '\''falsenull'\''|json -b 4
false
null
$ echo -e '\''falsenull'\''|json -b 8
false
null
$ echo -e '\''falsefalse'\''|json -b 1
false
false
$ echo -e '\''falsefalse'\''|json -b 4
false
false
$ echo -e '\''falsefalse'\''|json -b 8
false
false
$ echo -e '\''falsetrue'\''|json -b 1
false
true
$ echo -e '\''falsetrue'\''|json -b 4
false
true
$ echo -e '\''falsetrue'\''|json -b 8
false
true
$ echo -e '\''truenull'\''|json -b 1
true
null
$ echo -e '\''truenull'\''|json -b 4
true
null
$ echo -e '\''truenull'\''|json -b 8
true
null
$ echo -e '\''truefalse'\''|json -b 1
true
false
$ echo -e '\''truefalse'\''|json -b 4
true
false
$ echo -e '\''truefalse'\''|json -b 8
true
false
$ echo -e '\''truetrue'\''|json -b 1
true
true
$ echo -e '\''truetrue'\''|json -b 4
true
true
$ echo -e '\''truetrue'\''|json -b 8
true
true'
) -L literal4.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --literal-value --multi-obj "$@"; }'
json() { json0 --literal-value --multi-obj "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --literal-value --multi-obj "$@"; }'

echo '$ echo -e '\''nullnull'\''|json -b 1'
echo -e 'nullnull'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''nullnull'\''|json -b 1'

echo '$ echo -e '\''nullnull'\''|json -b 4'
echo -e 'nullnull'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''nullnull'\''|json -b 4'

echo '$ echo -e '\''nullnull'\''|json -b 8'
echo -e 'nullnull'|json -b 8 2>&1 ||
echo 'command failed: echo -e '\''nullnull'\''|json -b 8'

echo '$ echo -e '\''nullfalse'\''|json -b 1'
echo -e 'nullfalse'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''nullfalse'\''|json -b 1'

echo '$ echo -e '\''nullfalse'\''|json -b 4'
echo -e 'nullfalse'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''nullfalse'\''|json -b 4'

echo '$ echo -e '\''nullfalse'\''|json -b 8'
echo -e 'nullfalse'|json -b 8 2>&1 ||
echo 'command failed: echo -e '\''nullfalse'\''|json -b 8'

echo '$ echo -e '\''nulltrue'\''|json -b 1'
echo -e 'nulltrue'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''nulltrue'\''|json -b 1'

echo '$ echo -e '\''nulltrue'\''|json -b 4'
echo -e 'nulltrue'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''nulltrue'\''|json -b 4'

echo '$ echo -e '\''nulltrue'\''|json -b 8'
echo -e 'nulltrue'|json -b 8 2>&1 ||
echo 'command failed: echo -e '\''nulltrue'\''|json -b 8'

echo '$ echo -e '\''falsenull'\''|json -b 1'
echo -e 'falsenull'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''falsenull'\''|json -b 1'

echo '$ echo -e '\''falsenull'\''|json -b 4'
echo -e 'falsenull'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''falsenull'\''|json -b 4'

echo '$ echo -e '\''falsenull'\''|json -b 8'
echo -e 'falsenull'|json -b 8 2>&1 ||
echo 'command failed: echo -e '\''falsenull'\''|json -b 8'

echo '$ echo -e '\''falsefalse'\''|json -b 1'
echo -e 'falsefalse'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''falsefalse'\''|json -b 1'

echo '$ echo -e '\''falsefalse'\''|json -b 4'
echo -e 'falsefalse'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''falsefalse'\''|json -b 4'

echo '$ echo -e '\''falsefalse'\''|json -b 8'
echo -e 'falsefalse'|json -b 8 2>&1 ||
echo 'command failed: echo -e '\''falsefalse'\''|json -b 8'

echo '$ echo -e '\''falsetrue'\''|json -b 1'
echo -e 'falsetrue'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''falsetrue'\''|json -b 1'

echo '$ echo -e '\''falsetrue'\''|json -b 4'
echo -e 'falsetrue'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''falsetrue'\''|json -b 4'

echo '$ echo -e '\''falsetrue'\''|json -b 8'
echo -e 'falsetrue'|json -b 8 2>&1 ||
echo 'command failed: echo -e '\''falsetrue'\''|json -b 8'

echo '$ echo -e '\''truenull'\''|json -b 1'
echo -e 'truenull'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''truenull'\''|json -b 1'

echo '$ echo -e '\''truenull'\''|json -b 4'
echo -e 'truenull'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''truenull'\''|json -b 4'

echo '$ echo -e '\''truenull'\''|json -b 8'
echo -e 'truenull'|json -b 8 2>&1 ||
echo 'command failed: echo -e '\''truenull'\''|json -b 8'

echo '$ echo -e '\''truefalse'\''|json -b 1'
echo -e 'truefalse'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''truefalse'\''|json -b 1'

echo '$ echo -e '\''truefalse'\''|json -b 4'
echo -e 'truefalse'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''truefalse'\''|json -b 4'

echo '$ echo -e '\''truefalse'\''|json -b 8'
echo -e 'truefalse'|json -b 8 2>&1 ||
echo 'command failed: echo -e '\''truefalse'\''|json -b 8'

echo '$ echo -e '\''truetrue'\''|json -b 1'
echo -e 'truetrue'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''truetrue'\''|json -b 1'

echo '$ echo -e '\''truetrue'\''|json -b 4'
echo -e 'truetrue'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''truetrue'\''|json -b 4'

echo '$ echo -e '\''truetrue'\''|json -b 8'
echo -e 'truetrue'|json -b 8 2>&1 ||
echo 'command failed: echo -e '\''truetrue'\''|json -b 8'
)

