#!/bin/bash

# Copyright (C) 2016  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C escape:utf8-8
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L utf8-8.old <(echo \
'$ json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --verbose "$@"; }
$ echo -ne '\''\xea\xea'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xea\xea
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xea\xea'\''|json -b 1
$ echo -ne '\''\xea\xea'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xea\xea
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xea\xea'\''|json -b 2
$ echo -ne '\''\xea\xea'\''|json -b 3
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xea\xea
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xea\xea'\''|json -b 3
$ echo -ne '\''\xea\xd5'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xea\xd5
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xea\xd5'\''|json -b 1
$ echo -ne '\''\xea\xd5'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xea\xd5
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xea\xd5'\''|json -b 2
$ echo -ne '\''\xea\xd5'\''|json -b 3
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xea\xd5
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xea\xd5'\''|json -b 3
$ echo -ne '\''\xe5\xea'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xe5\xea
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xe5\xea'\''|json -b 1
$ echo -ne '\''\xe5\xea'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xe5\xea
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xe5\xea'\''|json -b 2
$ echo -ne '\''\xe5\xea'\''|json -b 3
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xe5\xea
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xe5\xea'\''|json -b 3
$ echo -ne '\''\xe5\xd5'\''|json -b 1
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xe5\xd5
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xe5\xd5'\''|json -b 1
$ echo -ne '\''\xe5\xd5'\''|json -b 2
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xe5\xd5
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xe5\xd5'\''|json -b 2
$ echo -ne '\''\xe5\xd5'\''|json -b 3
json: error: <stdin>:1:2: invalid utf-8 encoding
json: error: <stdin>:1:2: \xe5\xd5
json: error: <stdin>:1:2:     ^
command failed: echo -ne '\''\xe5\xd5'\''|json -b 3
$ echo -ne '\''\xf5\xaa\xea'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf5\xaa\xea
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf5\xaa\xea'\''|json -b 1
$ echo -ne '\''\xf5\xaa\xea'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf5\xaa\xea
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf5\xaa\xea'\''|json -b 2
$ echo -ne '\''\xf5\xaa\xea'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf5\xaa\xea
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf5\xaa\xea'\''|json -b 3
$ echo -ne '\''\xf5\xaa\xea'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf5\xaa\xea
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf5\xaa\xea'\''|json -b 4
$ echo -ne '\''\xf5\xaa\xd5'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf5\xaa\xd5
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf5\xaa\xd5'\''|json -b 1
$ echo -ne '\''\xf5\xaa\xd5'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf5\xaa\xd5
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf5\xaa\xd5'\''|json -b 2
$ echo -ne '\''\xf5\xaa\xd5'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf5\xaa\xd5
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf5\xaa\xd5'\''|json -b 3
$ echo -ne '\''\xf5\xaa\xd5'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf5\xaa\xd5
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf5\xaa\xd5'\''|json -b 4
$ echo -ne '\''\xf5\x95\xea'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf5\x95\xea
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf5\x95\xea'\''|json -b 1
$ echo -ne '\''\xf5\x95\xea'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf5\x95\xea
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf5\x95\xea'\''|json -b 2
$ echo -ne '\''\xf5\x95\xea'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf5\x95\xea
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf5\x95\xea'\''|json -b 3
$ echo -ne '\''\xf5\x95\xea'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf5\x95\xea
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf5\x95\xea'\''|json -b 4
$ echo -ne '\''\xf5\x95\xd5'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf5\x95\xd5
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf5\x95\xd5'\''|json -b 1
$ echo -ne '\''\xf5\x95\xd5'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf5\x95\xd5
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf5\x95\xd5'\''|json -b 2
$ echo -ne '\''\xf5\x95\xd5'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf5\x95\xd5
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf5\x95\xd5'\''|json -b 3
$ echo -ne '\''\xf5\x95\xd5'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf5\x95\xd5
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf5\x95\xd5'\''|json -b 4
$ echo -ne '\''\xf2\xaa\xea'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf2\xaa\xea
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf2\xaa\xea'\''|json -b 1
$ echo -ne '\''\xf2\xaa\xea'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf2\xaa\xea
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf2\xaa\xea'\''|json -b 2
$ echo -ne '\''\xf2\xaa\xea'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf2\xaa\xea
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf2\xaa\xea'\''|json -b 3
$ echo -ne '\''\xf2\xaa\xea'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf2\xaa\xea
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf2\xaa\xea'\''|json -b 4
$ echo -ne '\''\xf2\xaa\xd5'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf2\xaa\xd5
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf2\xaa\xd5'\''|json -b 1
$ echo -ne '\''\xf2\xaa\xd5'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf2\xaa\xd5
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf2\xaa\xd5'\''|json -b 2
$ echo -ne '\''\xf2\xaa\xd5'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf2\xaa\xd5
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf2\xaa\xd5'\''|json -b 3
$ echo -ne '\''\xf2\xaa\xd5'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf2\xaa\xd5
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf2\xaa\xd5'\''|json -b 4
$ echo -ne '\''\xf2\x95\xea'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf2\x95\xea
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf2\x95\xea'\''|json -b 1
$ echo -ne '\''\xf2\x95\xea'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf2\x95\xea
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf2\x95\xea'\''|json -b 2
$ echo -ne '\''\xf2\x95\xea'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf2\x95\xea
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf2\x95\xea'\''|json -b 3
$ echo -ne '\''\xf2\x95\xea'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf2\x95\xea
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf2\x95\xea'\''|json -b 4
$ echo -ne '\''\xf2\x95\xd5'\''|json -b 1
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf2\x95\xd5
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf2\x95\xd5'\''|json -b 1
$ echo -ne '\''\xf2\x95\xd5'\''|json -b 2
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf2\x95\xd5
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf2\x95\xd5'\''|json -b 2
$ echo -ne '\''\xf2\x95\xd5'\''|json -b 3
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf2\x95\xd5
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf2\x95\xd5'\''|json -b 3
$ echo -ne '\''\xf2\x95\xd5'\''|json -b 4
json: error: <stdin>:1:3: invalid utf-8 encoding
json: error: <stdin>:1:3: \xf2\x95\xd5
json: error: <stdin>:1:3:         ^
command failed: echo -ne '\''\xf2\x95\xd5'\''|json -b 4'
) -L utf8-8.new <(
echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --verbose "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --verbose "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --verbose "$@"; }'

echo '$ echo -ne '\''\xea\xea'\''|json -b 1'
echo -ne '\xea\xea'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xea\xea'\''|json -b 1'

echo '$ echo -ne '\''\xea\xea'\''|json -b 2'
echo -ne '\xea\xea'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xea\xea'\''|json -b 2'

echo '$ echo -ne '\''\xea\xea'\''|json -b 3'
echo -ne '\xea\xea'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xea\xea'\''|json -b 3'

echo '$ echo -ne '\''\xea\xd5'\''|json -b 1'
echo -ne '\xea\xd5'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xea\xd5'\''|json -b 1'

echo '$ echo -ne '\''\xea\xd5'\''|json -b 2'
echo -ne '\xea\xd5'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xea\xd5'\''|json -b 2'

echo '$ echo -ne '\''\xea\xd5'\''|json -b 3'
echo -ne '\xea\xd5'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xea\xd5'\''|json -b 3'

echo '$ echo -ne '\''\xe5\xea'\''|json -b 1'
echo -ne '\xe5\xea'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe5\xea'\''|json -b 1'

echo '$ echo -ne '\''\xe5\xea'\''|json -b 2'
echo -ne '\xe5\xea'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xe5\xea'\''|json -b 2'

echo '$ echo -ne '\''\xe5\xea'\''|json -b 3'
echo -ne '\xe5\xea'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe5\xea'\''|json -b 3'

echo '$ echo -ne '\''\xe5\xd5'\''|json -b 1'
echo -ne '\xe5\xd5'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xe5\xd5'\''|json -b 1'

echo '$ echo -ne '\''\xe5\xd5'\''|json -b 2'
echo -ne '\xe5\xd5'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xe5\xd5'\''|json -b 2'

echo '$ echo -ne '\''\xe5\xd5'\''|json -b 3'
echo -ne '\xe5\xd5'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xe5\xd5'\''|json -b 3'

echo '$ echo -ne '\''\xf5\xaa\xea'\''|json -b 1'
echo -ne '\xf5\xaa\xea'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf5\xaa\xea'\''|json -b 1'

echo '$ echo -ne '\''\xf5\xaa\xea'\''|json -b 2'
echo -ne '\xf5\xaa\xea'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf5\xaa\xea'\''|json -b 2'

echo '$ echo -ne '\''\xf5\xaa\xea'\''|json -b 3'
echo -ne '\xf5\xaa\xea'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf5\xaa\xea'\''|json -b 3'

echo '$ echo -ne '\''\xf5\xaa\xea'\''|json -b 4'
echo -ne '\xf5\xaa\xea'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf5\xaa\xea'\''|json -b 4'

echo '$ echo -ne '\''\xf5\xaa\xd5'\''|json -b 1'
echo -ne '\xf5\xaa\xd5'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf5\xaa\xd5'\''|json -b 1'

echo '$ echo -ne '\''\xf5\xaa\xd5'\''|json -b 2'
echo -ne '\xf5\xaa\xd5'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf5\xaa\xd5'\''|json -b 2'

echo '$ echo -ne '\''\xf5\xaa\xd5'\''|json -b 3'
echo -ne '\xf5\xaa\xd5'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf5\xaa\xd5'\''|json -b 3'

echo '$ echo -ne '\''\xf5\xaa\xd5'\''|json -b 4'
echo -ne '\xf5\xaa\xd5'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf5\xaa\xd5'\''|json -b 4'

echo '$ echo -ne '\''\xf5\x95\xea'\''|json -b 1'
echo -ne '\xf5\x95\xea'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf5\x95\xea'\''|json -b 1'

echo '$ echo -ne '\''\xf5\x95\xea'\''|json -b 2'
echo -ne '\xf5\x95\xea'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf5\x95\xea'\''|json -b 2'

echo '$ echo -ne '\''\xf5\x95\xea'\''|json -b 3'
echo -ne '\xf5\x95\xea'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf5\x95\xea'\''|json -b 3'

echo '$ echo -ne '\''\xf5\x95\xea'\''|json -b 4'
echo -ne '\xf5\x95\xea'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf5\x95\xea'\''|json -b 4'

echo '$ echo -ne '\''\xf5\x95\xd5'\''|json -b 1'
echo -ne '\xf5\x95\xd5'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf5\x95\xd5'\''|json -b 1'

echo '$ echo -ne '\''\xf5\x95\xd5'\''|json -b 2'
echo -ne '\xf5\x95\xd5'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf5\x95\xd5'\''|json -b 2'

echo '$ echo -ne '\''\xf5\x95\xd5'\''|json -b 3'
echo -ne '\xf5\x95\xd5'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf5\x95\xd5'\''|json -b 3'

echo '$ echo -ne '\''\xf5\x95\xd5'\''|json -b 4'
echo -ne '\xf5\x95\xd5'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf5\x95\xd5'\''|json -b 4'

echo '$ echo -ne '\''\xf2\xaa\xea'\''|json -b 1'
echo -ne '\xf2\xaa\xea'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\xaa\xea'\''|json -b 1'

echo '$ echo -ne '\''\xf2\xaa\xea'\''|json -b 2'
echo -ne '\xf2\xaa\xea'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\xaa\xea'\''|json -b 2'

echo '$ echo -ne '\''\xf2\xaa\xea'\''|json -b 3'
echo -ne '\xf2\xaa\xea'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\xaa\xea'\''|json -b 3'

echo '$ echo -ne '\''\xf2\xaa\xea'\''|json -b 4'
echo -ne '\xf2\xaa\xea'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\xaa\xea'\''|json -b 4'

echo '$ echo -ne '\''\xf2\xaa\xd5'\''|json -b 1'
echo -ne '\xf2\xaa\xd5'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\xaa\xd5'\''|json -b 1'

echo '$ echo -ne '\''\xf2\xaa\xd5'\''|json -b 2'
echo -ne '\xf2\xaa\xd5'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\xaa\xd5'\''|json -b 2'

echo '$ echo -ne '\''\xf2\xaa\xd5'\''|json -b 3'
echo -ne '\xf2\xaa\xd5'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\xaa\xd5'\''|json -b 3'

echo '$ echo -ne '\''\xf2\xaa\xd5'\''|json -b 4'
echo -ne '\xf2\xaa\xd5'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\xaa\xd5'\''|json -b 4'

echo '$ echo -ne '\''\xf2\x95\xea'\''|json -b 1'
echo -ne '\xf2\x95\xea'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\x95\xea'\''|json -b 1'

echo '$ echo -ne '\''\xf2\x95\xea'\''|json -b 2'
echo -ne '\xf2\x95\xea'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\x95\xea'\''|json -b 2'

echo '$ echo -ne '\''\xf2\x95\xea'\''|json -b 3'
echo -ne '\xf2\x95\xea'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\x95\xea'\''|json -b 3'

echo '$ echo -ne '\''\xf2\x95\xea'\''|json -b 4'
echo -ne '\xf2\x95\xea'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\x95\xea'\''|json -b 4'

echo '$ echo -ne '\''\xf2\x95\xd5'\''|json -b 1'
echo -ne '\xf2\x95\xd5'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\x95\xd5'\''|json -b 1'

echo '$ echo -ne '\''\xf2\x95\xd5'\''|json -b 2'
echo -ne '\xf2\x95\xd5'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\x95\xd5'\''|json -b 2'

echo '$ echo -ne '\''\xf2\x95\xd5'\''|json -b 3'
echo -ne '\xf2\x95\xd5'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\x95\xd5'\''|json -b 3'

echo '$ echo -ne '\''\xf2\x95\xd5'\''|json -b 4'
echo -ne '\xf2\x95\xd5'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\xf2\x95\xd5'\''|json -b 4'
)

