#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:plain2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L plain2.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ set -o pipefail
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -ur '\''/fatal error:/s/:[0-9]+:/:???:/'\''; }
$ json -d '\''{"plain":-0}'\'' <<< '\''-0'\''
-0
$ json -d '\''{"plain":-0}'\'' <<< '\''0'\''
0
$ json -d '\''{"plain":-0}'\'' <<< '\''-1'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"plain":-0}'\''
json: error: <stdin>:1:1: -1
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"plain":-0}'\'' <<< '\''-1'\''
$ json -d '\''{"plain":-0}'\'' <<< '\''1'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"plain":-0}'\''
json: error: <stdin>:1:1: 1
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"plain":-0}'\'' <<< '\''1'\''
$ json -d '\''{"plain":-0}'\'' <<< '\''1.0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-0}'\'' <<< '\''1.0'\''
$ json -d '\''{"plain":-0}'\'' <<< '\''-1.0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-0}'\'' <<< '\''-1.0'\''
$ json -d '\''{"plain":-0}'\'' <<< '\''-1e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-0}'\'' <<< '\''-1e1'\''
$ json -d '\''{"plain":-0}'\'' <<< '\''1e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-0}'\'' <<< '\''1e1'\''
$ json -d '\''{"plain":-0}'\'' <<< '\''-1E1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-0}'\'' <<< '\''-1E1'\''
$ json -d '\''{"plain":-0}'\'' <<< '\''1E1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-0}'\'' <<< '\''1E1'\''
$ json -d '\''{"plain":-0}'\'' <<< '\''-1.0e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-0}'\'' <<< '\''-1.0e1'\''
$ json -d '\''{"plain":-0}'\'' <<< '\''1.0e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-0}'\'' <<< '\''1.0e1'\''
$ json -d '\''{"plain":0}'\'' <<< '\''-0'\''
-0
$ json -d '\''{"plain":0}'\'' <<< '\''0'\''
0
$ json -d '\''{"plain":0}'\'' <<< '\''-1'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"plain":0}'\''
json: error: <stdin>:1:1: -1
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"plain":0}'\'' <<< '\''-1'\''
$ json -d '\''{"plain":0}'\'' <<< '\''1'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"plain":0}'\''
json: error: <stdin>:1:1: 1
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"plain":0}'\'' <<< '\''1'\''
$ json -d '\''{"plain":0}'\'' <<< '\''1.0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":0}'\'' <<< '\''1.0'\''
$ json -d '\''{"plain":0}'\'' <<< '\''-1.0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":0}'\'' <<< '\''-1.0'\''
$ json -d '\''{"plain":0}'\'' <<< '\''-1e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":0}'\'' <<< '\''-1e1'\''
$ json -d '\''{"plain":0}'\'' <<< '\''1e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":0}'\'' <<< '\''1e1'\''
$ json -d '\''{"plain":0}'\'' <<< '\''-1E1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":0}'\'' <<< '\''-1E1'\''
$ json -d '\''{"plain":0}'\'' <<< '\''1E1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":0}'\'' <<< '\''1E1'\''
$ json -d '\''{"plain":0}'\'' <<< '\''-1.0e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":0}'\'' <<< '\''-1.0e1'\''
$ json -d '\''{"plain":0}'\'' <<< '\''1.0e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":0}'\'' <<< '\''1.0e1'\''
$ json -d '\''{"plain":-1}'\'' <<< '\''-0'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"plain":-1}'\''
json: error: <stdin>:1:1: -0
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"plain":-1}'\'' <<< '\''-0'\''
$ json -d '\''{"plain":-1}'\'' <<< '\''0'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"plain":-1}'\''
json: error: <stdin>:1:1: 0
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"plain":-1}'\'' <<< '\''0'\''
$ json -d '\''{"plain":-1}'\'' <<< '\''-1'\''
-1
$ json -d '\''{"plain":-1}'\'' <<< '\''1'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"plain":-1}'\''
json: error: <stdin>:1:1: 1
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"plain":-1}'\'' <<< '\''1'\''
$ json -d '\''{"plain":-1}'\'' <<< '\''1.0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1}'\'' <<< '\''1.0'\''
$ json -d '\''{"plain":-1}'\'' <<< '\''-1.0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1}'\'' <<< '\''-1.0'\''
$ json -d '\''{"plain":-1}'\'' <<< '\''-1e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1}'\'' <<< '\''-1e1'\''
$ json -d '\''{"plain":-1}'\'' <<< '\''1e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1}'\'' <<< '\''1e1'\''
$ json -d '\''{"plain":-1}'\'' <<< '\''-1E1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1}'\'' <<< '\''-1E1'\''
$ json -d '\''{"plain":-1}'\'' <<< '\''1E1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1}'\'' <<< '\''1E1'\''
$ json -d '\''{"plain":-1}'\'' <<< '\''-1.0e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1}'\'' <<< '\''-1.0e1'\''
$ json -d '\''{"plain":-1}'\'' <<< '\''1.0e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1}'\'' <<< '\''1.0e1'\''
$ json -d '\''{"plain":1}'\'' <<< '\''-0'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"plain":1}'\''
json: error: <stdin>:1:1: -0
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"plain":1}'\'' <<< '\''-0'\''
$ json -d '\''{"plain":1}'\'' <<< '\''0'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"plain":1}'\''
json: error: <stdin>:1:1: 0
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"plain":1}'\'' <<< '\''0'\''
$ json -d '\''{"plain":1}'\'' <<< '\''-1'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"plain":1}'\''
json: error: <stdin>:1:1: -1
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"plain":1}'\'' <<< '\''-1'\''
$ json -d '\''{"plain":1}'\'' <<< '\''1'\''
1
$ json -d '\''{"plain":1}'\'' <<< '\''1.0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1}'\'' <<< '\''1.0'\''
$ json -d '\''{"plain":1}'\'' <<< '\''-1.0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1}'\'' <<< '\''-1.0'\''
$ json -d '\''{"plain":1}'\'' <<< '\''-1e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1}'\'' <<< '\''-1e1'\''
$ json -d '\''{"plain":1}'\'' <<< '\''1e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1}'\'' <<< '\''1e1'\''
$ json -d '\''{"plain":1}'\'' <<< '\''-1E1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1}'\'' <<< '\''-1E1'\''
$ json -d '\''{"plain":1}'\'' <<< '\''1E1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1}'\'' <<< '\''1E1'\''
$ json -d '\''{"plain":1}'\'' <<< '\''-1.0e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1}'\'' <<< '\''-1.0e1'\''
$ json -d '\''{"plain":1}'\'' <<< '\''1.0e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1}'\'' <<< '\''1.0e1'\''
$ json -d '\''{"plain":1.0}'\'' <<< '\''-0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1.0}'\'' <<< '\''-0'\''
$ json -d '\''{"plain":1.0}'\'' <<< '\''0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1.0}'\'' <<< '\''0'\''
$ json -d '\''{"plain":1.0}'\'' <<< '\''-1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1.0}'\'' <<< '\''-1'\''
$ json -d '\''{"plain":1.0}'\'' <<< '\''1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1.0}'\'' <<< '\''1'\''
$ json -d '\''{"plain":1.0}'\'' <<< '\''1.0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1.0}'\'' <<< '\''1.0'\''
$ json -d '\''{"plain":1.0}'\'' <<< '\''-1.0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1.0}'\'' <<< '\''-1.0'\''
$ json -d '\''{"plain":1.0}'\'' <<< '\''-1e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1.0}'\'' <<< '\''-1e1'\''
$ json -d '\''{"plain":1.0}'\'' <<< '\''1e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1.0}'\'' <<< '\''1e1'\''
$ json -d '\''{"plain":1.0}'\'' <<< '\''-1E1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1.0}'\'' <<< '\''-1E1'\''
$ json -d '\''{"plain":1.0}'\'' <<< '\''1E1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1.0}'\'' <<< '\''1E1'\''
$ json -d '\''{"plain":1.0}'\'' <<< '\''-1.0e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1.0}'\'' <<< '\''-1.0e1'\''
$ json -d '\''{"plain":1.0}'\'' <<< '\''1.0e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1.0}'\'' <<< '\''1.0e1'\''
$ json -d '\''{"plain":-1.0}'\'' <<< '\''-0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1.0}'\'' <<< '\''-0'\''
$ json -d '\''{"plain":-1.0}'\'' <<< '\''0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1.0}'\'' <<< '\''0'\''
$ json -d '\''{"plain":-1.0}'\'' <<< '\''-1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1.0}'\'' <<< '\''-1'\''
$ json -d '\''{"plain":-1.0}'\'' <<< '\''1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1.0}'\'' <<< '\''1'\''
$ json -d '\''{"plain":-1.0}'\'' <<< '\''1.0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1.0}'\'' <<< '\''1.0'\''
$ json -d '\''{"plain":-1.0}'\'' <<< '\''-1.0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1.0}'\'' <<< '\''-1.0'\''
$ json -d '\''{"plain":-1.0}'\'' <<< '\''-1e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1.0}'\'' <<< '\''-1e1'\''
$ json -d '\''{"plain":-1.0}'\'' <<< '\''1e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1.0}'\'' <<< '\''1e1'\''
$ json -d '\''{"plain":-1.0}'\'' <<< '\''-1E1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1.0}'\'' <<< '\''-1E1'\''
$ json -d '\''{"plain":-1.0}'\'' <<< '\''1E1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1.0}'\'' <<< '\''1E1'\''
$ json -d '\''{"plain":-1.0}'\'' <<< '\''-1.0e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1.0}'\'' <<< '\''-1.0e1'\''
$ json -d '\''{"plain":-1.0}'\'' <<< '\''1.0e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1.0}'\'' <<< '\''1.0e1'\''
$ json -d '\''{"plain":-1e1}'\'' <<< '\''-0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1e1}'\'' <<< '\''-0'\''
$ json -d '\''{"plain":-1e1}'\'' <<< '\''0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1e1}'\'' <<< '\''0'\''
$ json -d '\''{"plain":-1e1}'\'' <<< '\''-1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1e1}'\'' <<< '\''-1'\''
$ json -d '\''{"plain":-1e1}'\'' <<< '\''1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1e1}'\'' <<< '\''1'\''
$ json -d '\''{"plain":-1e1}'\'' <<< '\''1.0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1e1}'\'' <<< '\''1.0'\''
$ json -d '\''{"plain":-1e1}'\'' <<< '\''-1.0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1e1}'\'' <<< '\''-1.0'\''
$ json -d '\''{"plain":-1e1}'\'' <<< '\''-1e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1e1}'\'' <<< '\''-1e1'\''
$ json -d '\''{"plain":-1e1}'\'' <<< '\''1e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1e1}'\'' <<< '\''1e1'\''
$ json -d '\''{"plain":-1e1}'\'' <<< '\''-1E1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1e1}'\'' <<< '\''-1E1'\''
$ json -d '\''{"plain":-1e1}'\'' <<< '\''1E1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1e1}'\'' <<< '\''1E1'\''
$ json -d '\''{"plain":-1e1}'\'' <<< '\''-1.0e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1e1}'\'' <<< '\''-1.0e1'\''
$ json -d '\''{"plain":-1e1}'\'' <<< '\''1.0e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1e1}'\'' <<< '\''1.0e1'\''
$ json -d '\''{"plain":1e1}'\'' <<< '\''-0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1e1}'\'' <<< '\''-0'\''
$ json -d '\''{"plain":1e1}'\'' <<< '\''0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1e1}'\'' <<< '\''0'\''
$ json -d '\''{"plain":1e1}'\'' <<< '\''-1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1e1}'\'' <<< '\''-1'\''
$ json -d '\''{"plain":1e1}'\'' <<< '\''1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1e1}'\'' <<< '\''1'\''
$ json -d '\''{"plain":1e1}'\'' <<< '\''1.0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1e1}'\'' <<< '\''1.0'\''
$ json -d '\''{"plain":1e1}'\'' <<< '\''-1.0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1e1}'\'' <<< '\''-1.0'\''
$ json -d '\''{"plain":1e1}'\'' <<< '\''-1e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1e1}'\'' <<< '\''-1e1'\''
$ json -d '\''{"plain":1e1}'\'' <<< '\''1e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1e1}'\'' <<< '\''1e1'\''
$ json -d '\''{"plain":1e1}'\'' <<< '\''-1E1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1e1}'\'' <<< '\''-1E1'\''
$ json -d '\''{"plain":1e1}'\'' <<< '\''1E1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1e1}'\'' <<< '\''1E1'\''
$ json -d '\''{"plain":1e1}'\'' <<< '\''-1.0e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1e1}'\'' <<< '\''-1.0e1'\''
$ json -d '\''{"plain":1e1}'\'' <<< '\''1.0e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1e1}'\'' <<< '\''1.0e1'\''
$ json -d '\''{"plain":-1E1}'\'' <<< '\''-0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1E1}'\'' <<< '\''-0'\''
$ json -d '\''{"plain":-1E1}'\'' <<< '\''0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1E1}'\'' <<< '\''0'\''
$ json -d '\''{"plain":-1E1}'\'' <<< '\''-1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1E1}'\'' <<< '\''-1'\''
$ json -d '\''{"plain":-1E1}'\'' <<< '\''1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1E1}'\'' <<< '\''1'\''
$ json -d '\''{"plain":-1E1}'\'' <<< '\''1.0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1E1}'\'' <<< '\''1.0'\''
$ json -d '\''{"plain":-1E1}'\'' <<< '\''-1.0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1E1}'\'' <<< '\''-1.0'\''
$ json -d '\''{"plain":-1E1}'\'' <<< '\''-1e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1E1}'\'' <<< '\''-1e1'\''
$ json -d '\''{"plain":-1E1}'\'' <<< '\''1e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1E1}'\'' <<< '\''1e1'\''
$ json -d '\''{"plain":-1E1}'\'' <<< '\''-1E1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1E1}'\'' <<< '\''-1E1'\''
$ json -d '\''{"plain":-1E1}'\'' <<< '\''1E1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1E1}'\'' <<< '\''1E1'\''
$ json -d '\''{"plain":-1E1}'\'' <<< '\''-1.0e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1E1}'\'' <<< '\''-1.0e1'\''
$ json -d '\''{"plain":-1E1}'\'' <<< '\''1.0e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1E1}'\'' <<< '\''1.0e1'\''
$ json -d '\''{"plain":1E1}'\'' <<< '\''-0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1E1}'\'' <<< '\''-0'\''
$ json -d '\''{"plain":1E1}'\'' <<< '\''0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1E1}'\'' <<< '\''0'\''
$ json -d '\''{"plain":1E1}'\'' <<< '\''-1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1E1}'\'' <<< '\''-1'\''
$ json -d '\''{"plain":1E1}'\'' <<< '\''1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1E1}'\'' <<< '\''1'\''
$ json -d '\''{"plain":1E1}'\'' <<< '\''1.0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1E1}'\'' <<< '\''1.0'\''
$ json -d '\''{"plain":1E1}'\'' <<< '\''-1.0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1E1}'\'' <<< '\''-1.0'\''
$ json -d '\''{"plain":1E1}'\'' <<< '\''-1e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1E1}'\'' <<< '\''-1e1'\''
$ json -d '\''{"plain":1E1}'\'' <<< '\''1e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1E1}'\'' <<< '\''1e1'\''
$ json -d '\''{"plain":1E1}'\'' <<< '\''-1E1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1E1}'\'' <<< '\''-1E1'\''
$ json -d '\''{"plain":1E1}'\'' <<< '\''1E1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1E1}'\'' <<< '\''1E1'\''
$ json -d '\''{"plain":1E1}'\'' <<< '\''-1.0e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1E1}'\'' <<< '\''-1.0e1'\''
$ json -d '\''{"plain":1E1}'\'' <<< '\''1.0e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1E1}'\'' <<< '\''1.0e1'\''
$ json -d '\''{"plain":-1.0e1}'\'' <<< '\''-0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1.0e1}'\'' <<< '\''-0'\''
$ json -d '\''{"plain":-1.0e1}'\'' <<< '\''0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1.0e1}'\'' <<< '\''0'\''
$ json -d '\''{"plain":-1.0e1}'\'' <<< '\''-1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1.0e1}'\'' <<< '\''-1'\''
$ json -d '\''{"plain":-1.0e1}'\'' <<< '\''1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1.0e1}'\'' <<< '\''1'\''
$ json -d '\''{"plain":-1.0e1}'\'' <<< '\''1.0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1.0e1}'\'' <<< '\''1.0'\''
$ json -d '\''{"plain":-1.0e1}'\'' <<< '\''-1.0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1.0e1}'\'' <<< '\''-1.0'\''
$ json -d '\''{"plain":-1.0e1}'\'' <<< '\''-1e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1.0e1}'\'' <<< '\''-1e1'\''
$ json -d '\''{"plain":-1.0e1}'\'' <<< '\''1e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1.0e1}'\'' <<< '\''1e1'\''
$ json -d '\''{"plain":-1.0e1}'\'' <<< '\''-1E1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1.0e1}'\'' <<< '\''-1E1'\''
$ json -d '\''{"plain":-1.0e1}'\'' <<< '\''1E1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1.0e1}'\'' <<< '\''1E1'\''
$ json -d '\''{"plain":-1.0e1}'\'' <<< '\''-1.0e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1.0e1}'\'' <<< '\''-1.0e1'\''
$ json -d '\''{"plain":-1.0e1}'\'' <<< '\''1.0e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":-1.0e1}'\'' <<< '\''1.0e1'\''
$ json -d '\''{"plain":1.0e1}'\'' <<< '\''-0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1.0e1}'\'' <<< '\''-0'\''
$ json -d '\''{"plain":1.0e1}'\'' <<< '\''0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1.0e1}'\'' <<< '\''0'\''
$ json -d '\''{"plain":1.0e1}'\'' <<< '\''-1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1.0e1}'\'' <<< '\''-1'\''
$ json -d '\''{"plain":1.0e1}'\'' <<< '\''1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1.0e1}'\'' <<< '\''1'\''
$ json -d '\''{"plain":1.0e1}'\'' <<< '\''1.0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1.0e1}'\'' <<< '\''1.0'\''
$ json -d '\''{"plain":1.0e1}'\'' <<< '\''-1.0'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1.0e1}'\'' <<< '\''-1.0'\''
$ json -d '\''{"plain":1.0e1}'\'' <<< '\''-1e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1.0e1}'\'' <<< '\''-1e1'\''
$ json -d '\''{"plain":1.0e1}'\'' <<< '\''1e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1.0e1}'\'' <<< '\''1e1'\''
$ json -d '\''{"plain":1.0e1}'\'' <<< '\''-1E1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1.0e1}'\'' <<< '\''-1E1'\''
$ json -d '\''{"plain":1.0e1}'\'' <<< '\''1E1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1.0e1}'\'' <<< '\''1E1'\''
$ json -d '\''{"plain":1.0e1}'\'' <<< '\''-1.0e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1.0e1}'\'' <<< '\''-1.0e1'\''
$ json -d '\''{"plain":1.0e1}'\'' <<< '\''1.0e1'\''
json.so: fatal error: json-type.c:???:trie_num_cmp: non-integer numerical comparison yet not supported
command failed: json -d '\''{"plain":1.0e1}'\'' <<< '\''1.0e1'\'''
) -L plain2.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ set -o pipefail'
set -o pipefail 2>&1 ||
echo 'command failed: set -o pipefail'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -ur '\''/fatal error:/s/:[0-9]+:/:???:/'\''; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -ur '/fatal error:/s/:[0-9]+:/:???:/'; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -ur '\''/fatal error:/s/:[0-9]+:/:???:/'\''; }'

echo '$ json -d '\''{"plain":-0}'\'' <<< '\''-0'\'''
json -d '{"plain":-0}' <<< '-0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-0}'\'' <<< '\''-0'\'''

echo '$ json -d '\''{"plain":-0}'\'' <<< '\''0'\'''
json -d '{"plain":-0}' <<< '0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-0}'\'' <<< '\''0'\'''

echo '$ json -d '\''{"plain":-0}'\'' <<< '\''-1'\'''
json -d '{"plain":-0}' <<< '-1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-0}'\'' <<< '\''-1'\'''

echo '$ json -d '\''{"plain":-0}'\'' <<< '\''1'\'''
json -d '{"plain":-0}' <<< '1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-0}'\'' <<< '\''1'\'''

echo '$ json -d '\''{"plain":-0}'\'' <<< '\''1.0'\'''
json -d '{"plain":-0}' <<< '1.0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-0}'\'' <<< '\''1.0'\'''

echo '$ json -d '\''{"plain":-0}'\'' <<< '\''-1.0'\'''
json -d '{"plain":-0}' <<< '-1.0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-0}'\'' <<< '\''-1.0'\'''

echo '$ json -d '\''{"plain":-0}'\'' <<< '\''-1e1'\'''
json -d '{"plain":-0}' <<< '-1e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-0}'\'' <<< '\''-1e1'\'''

echo '$ json -d '\''{"plain":-0}'\'' <<< '\''1e1'\'''
json -d '{"plain":-0}' <<< '1e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-0}'\'' <<< '\''1e1'\'''

echo '$ json -d '\''{"plain":-0}'\'' <<< '\''-1E1'\'''
json -d '{"plain":-0}' <<< '-1E1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-0}'\'' <<< '\''-1E1'\'''

echo '$ json -d '\''{"plain":-0}'\'' <<< '\''1E1'\'''
json -d '{"plain":-0}' <<< '1E1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-0}'\'' <<< '\''1E1'\'''

echo '$ json -d '\''{"plain":-0}'\'' <<< '\''-1.0e1'\'''
json -d '{"plain":-0}' <<< '-1.0e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-0}'\'' <<< '\''-1.0e1'\'''

echo '$ json -d '\''{"plain":-0}'\'' <<< '\''1.0e1'\'''
json -d '{"plain":-0}' <<< '1.0e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-0}'\'' <<< '\''1.0e1'\'''

echo '$ json -d '\''{"plain":0}'\'' <<< '\''-0'\'''
json -d '{"plain":0}' <<< '-0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":0}'\'' <<< '\''-0'\'''

echo '$ json -d '\''{"plain":0}'\'' <<< '\''0'\'''
json -d '{"plain":0}' <<< '0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":0}'\'' <<< '\''0'\'''

echo '$ json -d '\''{"plain":0}'\'' <<< '\''-1'\'''
json -d '{"plain":0}' <<< '-1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":0}'\'' <<< '\''-1'\'''

echo '$ json -d '\''{"plain":0}'\'' <<< '\''1'\'''
json -d '{"plain":0}' <<< '1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":0}'\'' <<< '\''1'\'''

echo '$ json -d '\''{"plain":0}'\'' <<< '\''1.0'\'''
json -d '{"plain":0}' <<< '1.0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":0}'\'' <<< '\''1.0'\'''

echo '$ json -d '\''{"plain":0}'\'' <<< '\''-1.0'\'''
json -d '{"plain":0}' <<< '-1.0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":0}'\'' <<< '\''-1.0'\'''

echo '$ json -d '\''{"plain":0}'\'' <<< '\''-1e1'\'''
json -d '{"plain":0}' <<< '-1e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":0}'\'' <<< '\''-1e1'\'''

echo '$ json -d '\''{"plain":0}'\'' <<< '\''1e1'\'''
json -d '{"plain":0}' <<< '1e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":0}'\'' <<< '\''1e1'\'''

echo '$ json -d '\''{"plain":0}'\'' <<< '\''-1E1'\'''
json -d '{"plain":0}' <<< '-1E1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":0}'\'' <<< '\''-1E1'\'''

echo '$ json -d '\''{"plain":0}'\'' <<< '\''1E1'\'''
json -d '{"plain":0}' <<< '1E1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":0}'\'' <<< '\''1E1'\'''

echo '$ json -d '\''{"plain":0}'\'' <<< '\''-1.0e1'\'''
json -d '{"plain":0}' <<< '-1.0e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":0}'\'' <<< '\''-1.0e1'\'''

echo '$ json -d '\''{"plain":0}'\'' <<< '\''1.0e1'\'''
json -d '{"plain":0}' <<< '1.0e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":0}'\'' <<< '\''1.0e1'\'''

echo '$ json -d '\''{"plain":-1}'\'' <<< '\''-0'\'''
json -d '{"plain":-1}' <<< '-0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1}'\'' <<< '\''-0'\'''

echo '$ json -d '\''{"plain":-1}'\'' <<< '\''0'\'''
json -d '{"plain":-1}' <<< '0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1}'\'' <<< '\''0'\'''

echo '$ json -d '\''{"plain":-1}'\'' <<< '\''-1'\'''
json -d '{"plain":-1}' <<< '-1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1}'\'' <<< '\''-1'\'''

echo '$ json -d '\''{"plain":-1}'\'' <<< '\''1'\'''
json -d '{"plain":-1}' <<< '1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1}'\'' <<< '\''1'\'''

echo '$ json -d '\''{"plain":-1}'\'' <<< '\''1.0'\'''
json -d '{"plain":-1}' <<< '1.0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1}'\'' <<< '\''1.0'\'''

echo '$ json -d '\''{"plain":-1}'\'' <<< '\''-1.0'\'''
json -d '{"plain":-1}' <<< '-1.0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1}'\'' <<< '\''-1.0'\'''

echo '$ json -d '\''{"plain":-1}'\'' <<< '\''-1e1'\'''
json -d '{"plain":-1}' <<< '-1e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1}'\'' <<< '\''-1e1'\'''

echo '$ json -d '\''{"plain":-1}'\'' <<< '\''1e1'\'''
json -d '{"plain":-1}' <<< '1e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1}'\'' <<< '\''1e1'\'''

echo '$ json -d '\''{"plain":-1}'\'' <<< '\''-1E1'\'''
json -d '{"plain":-1}' <<< '-1E1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1}'\'' <<< '\''-1E1'\'''

echo '$ json -d '\''{"plain":-1}'\'' <<< '\''1E1'\'''
json -d '{"plain":-1}' <<< '1E1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1}'\'' <<< '\''1E1'\'''

echo '$ json -d '\''{"plain":-1}'\'' <<< '\''-1.0e1'\'''
json -d '{"plain":-1}' <<< '-1.0e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1}'\'' <<< '\''-1.0e1'\'''

echo '$ json -d '\''{"plain":-1}'\'' <<< '\''1.0e1'\'''
json -d '{"plain":-1}' <<< '1.0e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1}'\'' <<< '\''1.0e1'\'''

echo '$ json -d '\''{"plain":1}'\'' <<< '\''-0'\'''
json -d '{"plain":1}' <<< '-0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1}'\'' <<< '\''-0'\'''

echo '$ json -d '\''{"plain":1}'\'' <<< '\''0'\'''
json -d '{"plain":1}' <<< '0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1}'\'' <<< '\''0'\'''

echo '$ json -d '\''{"plain":1}'\'' <<< '\''-1'\'''
json -d '{"plain":1}' <<< '-1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1}'\'' <<< '\''-1'\'''

echo '$ json -d '\''{"plain":1}'\'' <<< '\''1'\'''
json -d '{"plain":1}' <<< '1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1}'\'' <<< '\''1'\'''

echo '$ json -d '\''{"plain":1}'\'' <<< '\''1.0'\'''
json -d '{"plain":1}' <<< '1.0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1}'\'' <<< '\''1.0'\'''

echo '$ json -d '\''{"plain":1}'\'' <<< '\''-1.0'\'''
json -d '{"plain":1}' <<< '-1.0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1}'\'' <<< '\''-1.0'\'''

echo '$ json -d '\''{"plain":1}'\'' <<< '\''-1e1'\'''
json -d '{"plain":1}' <<< '-1e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1}'\'' <<< '\''-1e1'\'''

echo '$ json -d '\''{"plain":1}'\'' <<< '\''1e1'\'''
json -d '{"plain":1}' <<< '1e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1}'\'' <<< '\''1e1'\'''

echo '$ json -d '\''{"plain":1}'\'' <<< '\''-1E1'\'''
json -d '{"plain":1}' <<< '-1E1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1}'\'' <<< '\''-1E1'\'''

echo '$ json -d '\''{"plain":1}'\'' <<< '\''1E1'\'''
json -d '{"plain":1}' <<< '1E1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1}'\'' <<< '\''1E1'\'''

echo '$ json -d '\''{"plain":1}'\'' <<< '\''-1.0e1'\'''
json -d '{"plain":1}' <<< '-1.0e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1}'\'' <<< '\''-1.0e1'\'''

echo '$ json -d '\''{"plain":1}'\'' <<< '\''1.0e1'\'''
json -d '{"plain":1}' <<< '1.0e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1}'\'' <<< '\''1.0e1'\'''

echo '$ json -d '\''{"plain":1.0}'\'' <<< '\''-0'\'''
json -d '{"plain":1.0}' <<< '-0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1.0}'\'' <<< '\''-0'\'''

echo '$ json -d '\''{"plain":1.0}'\'' <<< '\''0'\'''
json -d '{"plain":1.0}' <<< '0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1.0}'\'' <<< '\''0'\'''

echo '$ json -d '\''{"plain":1.0}'\'' <<< '\''-1'\'''
json -d '{"plain":1.0}' <<< '-1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1.0}'\'' <<< '\''-1'\'''

echo '$ json -d '\''{"plain":1.0}'\'' <<< '\''1'\'''
json -d '{"plain":1.0}' <<< '1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1.0}'\'' <<< '\''1'\'''

echo '$ json -d '\''{"plain":1.0}'\'' <<< '\''1.0'\'''
json -d '{"plain":1.0}' <<< '1.0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1.0}'\'' <<< '\''1.0'\'''

echo '$ json -d '\''{"plain":1.0}'\'' <<< '\''-1.0'\'''
json -d '{"plain":1.0}' <<< '-1.0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1.0}'\'' <<< '\''-1.0'\'''

echo '$ json -d '\''{"plain":1.0}'\'' <<< '\''-1e1'\'''
json -d '{"plain":1.0}' <<< '-1e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1.0}'\'' <<< '\''-1e1'\'''

echo '$ json -d '\''{"plain":1.0}'\'' <<< '\''1e1'\'''
json -d '{"plain":1.0}' <<< '1e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1.0}'\'' <<< '\''1e1'\'''

echo '$ json -d '\''{"plain":1.0}'\'' <<< '\''-1E1'\'''
json -d '{"plain":1.0}' <<< '-1E1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1.0}'\'' <<< '\''-1E1'\'''

echo '$ json -d '\''{"plain":1.0}'\'' <<< '\''1E1'\'''
json -d '{"plain":1.0}' <<< '1E1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1.0}'\'' <<< '\''1E1'\'''

echo '$ json -d '\''{"plain":1.0}'\'' <<< '\''-1.0e1'\'''
json -d '{"plain":1.0}' <<< '-1.0e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1.0}'\'' <<< '\''-1.0e1'\'''

echo '$ json -d '\''{"plain":1.0}'\'' <<< '\''1.0e1'\'''
json -d '{"plain":1.0}' <<< '1.0e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1.0}'\'' <<< '\''1.0e1'\'''

echo '$ json -d '\''{"plain":-1.0}'\'' <<< '\''-0'\'''
json -d '{"plain":-1.0}' <<< '-0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1.0}'\'' <<< '\''-0'\'''

echo '$ json -d '\''{"plain":-1.0}'\'' <<< '\''0'\'''
json -d '{"plain":-1.0}' <<< '0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1.0}'\'' <<< '\''0'\'''

echo '$ json -d '\''{"plain":-1.0}'\'' <<< '\''-1'\'''
json -d '{"plain":-1.0}' <<< '-1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1.0}'\'' <<< '\''-1'\'''

echo '$ json -d '\''{"plain":-1.0}'\'' <<< '\''1'\'''
json -d '{"plain":-1.0}' <<< '1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1.0}'\'' <<< '\''1'\'''

echo '$ json -d '\''{"plain":-1.0}'\'' <<< '\''1.0'\'''
json -d '{"plain":-1.0}' <<< '1.0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1.0}'\'' <<< '\''1.0'\'''

echo '$ json -d '\''{"plain":-1.0}'\'' <<< '\''-1.0'\'''
json -d '{"plain":-1.0}' <<< '-1.0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1.0}'\'' <<< '\''-1.0'\'''

echo '$ json -d '\''{"plain":-1.0}'\'' <<< '\''-1e1'\'''
json -d '{"plain":-1.0}' <<< '-1e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1.0}'\'' <<< '\''-1e1'\'''

echo '$ json -d '\''{"plain":-1.0}'\'' <<< '\''1e1'\'''
json -d '{"plain":-1.0}' <<< '1e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1.0}'\'' <<< '\''1e1'\'''

echo '$ json -d '\''{"plain":-1.0}'\'' <<< '\''-1E1'\'''
json -d '{"plain":-1.0}' <<< '-1E1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1.0}'\'' <<< '\''-1E1'\'''

echo '$ json -d '\''{"plain":-1.0}'\'' <<< '\''1E1'\'''
json -d '{"plain":-1.0}' <<< '1E1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1.0}'\'' <<< '\''1E1'\'''

echo '$ json -d '\''{"plain":-1.0}'\'' <<< '\''-1.0e1'\'''
json -d '{"plain":-1.0}' <<< '-1.0e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1.0}'\'' <<< '\''-1.0e1'\'''

echo '$ json -d '\''{"plain":-1.0}'\'' <<< '\''1.0e1'\'''
json -d '{"plain":-1.0}' <<< '1.0e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1.0}'\'' <<< '\''1.0e1'\'''

echo '$ json -d '\''{"plain":-1e1}'\'' <<< '\''-0'\'''
json -d '{"plain":-1e1}' <<< '-0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1e1}'\'' <<< '\''-0'\'''

echo '$ json -d '\''{"plain":-1e1}'\'' <<< '\''0'\'''
json -d '{"plain":-1e1}' <<< '0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1e1}'\'' <<< '\''0'\'''

echo '$ json -d '\''{"plain":-1e1}'\'' <<< '\''-1'\'''
json -d '{"plain":-1e1}' <<< '-1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1e1}'\'' <<< '\''-1'\'''

echo '$ json -d '\''{"plain":-1e1}'\'' <<< '\''1'\'''
json -d '{"plain":-1e1}' <<< '1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1e1}'\'' <<< '\''1'\'''

echo '$ json -d '\''{"plain":-1e1}'\'' <<< '\''1.0'\'''
json -d '{"plain":-1e1}' <<< '1.0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1e1}'\'' <<< '\''1.0'\'''

echo '$ json -d '\''{"plain":-1e1}'\'' <<< '\''-1.0'\'''
json -d '{"plain":-1e1}' <<< '-1.0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1e1}'\'' <<< '\''-1.0'\'''

echo '$ json -d '\''{"plain":-1e1}'\'' <<< '\''-1e1'\'''
json -d '{"plain":-1e1}' <<< '-1e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1e1}'\'' <<< '\''-1e1'\'''

echo '$ json -d '\''{"plain":-1e1}'\'' <<< '\''1e1'\'''
json -d '{"plain":-1e1}' <<< '1e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1e1}'\'' <<< '\''1e1'\'''

echo '$ json -d '\''{"plain":-1e1}'\'' <<< '\''-1E1'\'''
json -d '{"plain":-1e1}' <<< '-1E1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1e1}'\'' <<< '\''-1E1'\'''

echo '$ json -d '\''{"plain":-1e1}'\'' <<< '\''1E1'\'''
json -d '{"plain":-1e1}' <<< '1E1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1e1}'\'' <<< '\''1E1'\'''

echo '$ json -d '\''{"plain":-1e1}'\'' <<< '\''-1.0e1'\'''
json -d '{"plain":-1e1}' <<< '-1.0e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1e1}'\'' <<< '\''-1.0e1'\'''

echo '$ json -d '\''{"plain":-1e1}'\'' <<< '\''1.0e1'\'''
json -d '{"plain":-1e1}' <<< '1.0e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1e1}'\'' <<< '\''1.0e1'\'''

echo '$ json -d '\''{"plain":1e1}'\'' <<< '\''-0'\'''
json -d '{"plain":1e1}' <<< '-0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1e1}'\'' <<< '\''-0'\'''

echo '$ json -d '\''{"plain":1e1}'\'' <<< '\''0'\'''
json -d '{"plain":1e1}' <<< '0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1e1}'\'' <<< '\''0'\'''

echo '$ json -d '\''{"plain":1e1}'\'' <<< '\''-1'\'''
json -d '{"plain":1e1}' <<< '-1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1e1}'\'' <<< '\''-1'\'''

echo '$ json -d '\''{"plain":1e1}'\'' <<< '\''1'\'''
json -d '{"plain":1e1}' <<< '1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1e1}'\'' <<< '\''1'\'''

echo '$ json -d '\''{"plain":1e1}'\'' <<< '\''1.0'\'''
json -d '{"plain":1e1}' <<< '1.0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1e1}'\'' <<< '\''1.0'\'''

echo '$ json -d '\''{"plain":1e1}'\'' <<< '\''-1.0'\'''
json -d '{"plain":1e1}' <<< '-1.0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1e1}'\'' <<< '\''-1.0'\'''

echo '$ json -d '\''{"plain":1e1}'\'' <<< '\''-1e1'\'''
json -d '{"plain":1e1}' <<< '-1e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1e1}'\'' <<< '\''-1e1'\'''

echo '$ json -d '\''{"plain":1e1}'\'' <<< '\''1e1'\'''
json -d '{"plain":1e1}' <<< '1e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1e1}'\'' <<< '\''1e1'\'''

echo '$ json -d '\''{"plain":1e1}'\'' <<< '\''-1E1'\'''
json -d '{"plain":1e1}' <<< '-1E1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1e1}'\'' <<< '\''-1E1'\'''

echo '$ json -d '\''{"plain":1e1}'\'' <<< '\''1E1'\'''
json -d '{"plain":1e1}' <<< '1E1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1e1}'\'' <<< '\''1E1'\'''

echo '$ json -d '\''{"plain":1e1}'\'' <<< '\''-1.0e1'\'''
json -d '{"plain":1e1}' <<< '-1.0e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1e1}'\'' <<< '\''-1.0e1'\'''

echo '$ json -d '\''{"plain":1e1}'\'' <<< '\''1.0e1'\'''
json -d '{"plain":1e1}' <<< '1.0e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1e1}'\'' <<< '\''1.0e1'\'''

echo '$ json -d '\''{"plain":-1E1}'\'' <<< '\''-0'\'''
json -d '{"plain":-1E1}' <<< '-0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1E1}'\'' <<< '\''-0'\'''

echo '$ json -d '\''{"plain":-1E1}'\'' <<< '\''0'\'''
json -d '{"plain":-1E1}' <<< '0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1E1}'\'' <<< '\''0'\'''

echo '$ json -d '\''{"plain":-1E1}'\'' <<< '\''-1'\'''
json -d '{"plain":-1E1}' <<< '-1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1E1}'\'' <<< '\''-1'\'''

echo '$ json -d '\''{"plain":-1E1}'\'' <<< '\''1'\'''
json -d '{"plain":-1E1}' <<< '1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1E1}'\'' <<< '\''1'\'''

echo '$ json -d '\''{"plain":-1E1}'\'' <<< '\''1.0'\'''
json -d '{"plain":-1E1}' <<< '1.0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1E1}'\'' <<< '\''1.0'\'''

echo '$ json -d '\''{"plain":-1E1}'\'' <<< '\''-1.0'\'''
json -d '{"plain":-1E1}' <<< '-1.0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1E1}'\'' <<< '\''-1.0'\'''

echo '$ json -d '\''{"plain":-1E1}'\'' <<< '\''-1e1'\'''
json -d '{"plain":-1E1}' <<< '-1e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1E1}'\'' <<< '\''-1e1'\'''

echo '$ json -d '\''{"plain":-1E1}'\'' <<< '\''1e1'\'''
json -d '{"plain":-1E1}' <<< '1e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1E1}'\'' <<< '\''1e1'\'''

echo '$ json -d '\''{"plain":-1E1}'\'' <<< '\''-1E1'\'''
json -d '{"plain":-1E1}' <<< '-1E1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1E1}'\'' <<< '\''-1E1'\'''

echo '$ json -d '\''{"plain":-1E1}'\'' <<< '\''1E1'\'''
json -d '{"plain":-1E1}' <<< '1E1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1E1}'\'' <<< '\''1E1'\'''

echo '$ json -d '\''{"plain":-1E1}'\'' <<< '\''-1.0e1'\'''
json -d '{"plain":-1E1}' <<< '-1.0e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1E1}'\'' <<< '\''-1.0e1'\'''

echo '$ json -d '\''{"plain":-1E1}'\'' <<< '\''1.0e1'\'''
json -d '{"plain":-1E1}' <<< '1.0e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1E1}'\'' <<< '\''1.0e1'\'''

echo '$ json -d '\''{"plain":1E1}'\'' <<< '\''-0'\'''
json -d '{"plain":1E1}' <<< '-0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1E1}'\'' <<< '\''-0'\'''

echo '$ json -d '\''{"plain":1E1}'\'' <<< '\''0'\'''
json -d '{"plain":1E1}' <<< '0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1E1}'\'' <<< '\''0'\'''

echo '$ json -d '\''{"plain":1E1}'\'' <<< '\''-1'\'''
json -d '{"plain":1E1}' <<< '-1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1E1}'\'' <<< '\''-1'\'''

echo '$ json -d '\''{"plain":1E1}'\'' <<< '\''1'\'''
json -d '{"plain":1E1}' <<< '1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1E1}'\'' <<< '\''1'\'''

echo '$ json -d '\''{"plain":1E1}'\'' <<< '\''1.0'\'''
json -d '{"plain":1E1}' <<< '1.0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1E1}'\'' <<< '\''1.0'\'''

echo '$ json -d '\''{"plain":1E1}'\'' <<< '\''-1.0'\'''
json -d '{"plain":1E1}' <<< '-1.0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1E1}'\'' <<< '\''-1.0'\'''

echo '$ json -d '\''{"plain":1E1}'\'' <<< '\''-1e1'\'''
json -d '{"plain":1E1}' <<< '-1e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1E1}'\'' <<< '\''-1e1'\'''

echo '$ json -d '\''{"plain":1E1}'\'' <<< '\''1e1'\'''
json -d '{"plain":1E1}' <<< '1e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1E1}'\'' <<< '\''1e1'\'''

echo '$ json -d '\''{"plain":1E1}'\'' <<< '\''-1E1'\'''
json -d '{"plain":1E1}' <<< '-1E1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1E1}'\'' <<< '\''-1E1'\'''

echo '$ json -d '\''{"plain":1E1}'\'' <<< '\''1E1'\'''
json -d '{"plain":1E1}' <<< '1E1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1E1}'\'' <<< '\''1E1'\'''

echo '$ json -d '\''{"plain":1E1}'\'' <<< '\''-1.0e1'\'''
json -d '{"plain":1E1}' <<< '-1.0e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1E1}'\'' <<< '\''-1.0e1'\'''

echo '$ json -d '\''{"plain":1E1}'\'' <<< '\''1.0e1'\'''
json -d '{"plain":1E1}' <<< '1.0e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1E1}'\'' <<< '\''1.0e1'\'''

echo '$ json -d '\''{"plain":-1.0e1}'\'' <<< '\''-0'\'''
json -d '{"plain":-1.0e1}' <<< '-0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1.0e1}'\'' <<< '\''-0'\'''

echo '$ json -d '\''{"plain":-1.0e1}'\'' <<< '\''0'\'''
json -d '{"plain":-1.0e1}' <<< '0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1.0e1}'\'' <<< '\''0'\'''

echo '$ json -d '\''{"plain":-1.0e1}'\'' <<< '\''-1'\'''
json -d '{"plain":-1.0e1}' <<< '-1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1.0e1}'\'' <<< '\''-1'\'''

echo '$ json -d '\''{"plain":-1.0e1}'\'' <<< '\''1'\'''
json -d '{"plain":-1.0e1}' <<< '1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1.0e1}'\'' <<< '\''1'\'''

echo '$ json -d '\''{"plain":-1.0e1}'\'' <<< '\''1.0'\'''
json -d '{"plain":-1.0e1}' <<< '1.0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1.0e1}'\'' <<< '\''1.0'\'''

echo '$ json -d '\''{"plain":-1.0e1}'\'' <<< '\''-1.0'\'''
json -d '{"plain":-1.0e1}' <<< '-1.0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1.0e1}'\'' <<< '\''-1.0'\'''

echo '$ json -d '\''{"plain":-1.0e1}'\'' <<< '\''-1e1'\'''
json -d '{"plain":-1.0e1}' <<< '-1e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1.0e1}'\'' <<< '\''-1e1'\'''

echo '$ json -d '\''{"plain":-1.0e1}'\'' <<< '\''1e1'\'''
json -d '{"plain":-1.0e1}' <<< '1e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1.0e1}'\'' <<< '\''1e1'\'''

echo '$ json -d '\''{"plain":-1.0e1}'\'' <<< '\''-1E1'\'''
json -d '{"plain":-1.0e1}' <<< '-1E1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1.0e1}'\'' <<< '\''-1E1'\'''

echo '$ json -d '\''{"plain":-1.0e1}'\'' <<< '\''1E1'\'''
json -d '{"plain":-1.0e1}' <<< '1E1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1.0e1}'\'' <<< '\''1E1'\'''

echo '$ json -d '\''{"plain":-1.0e1}'\'' <<< '\''-1.0e1'\'''
json -d '{"plain":-1.0e1}' <<< '-1.0e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1.0e1}'\'' <<< '\''-1.0e1'\'''

echo '$ json -d '\''{"plain":-1.0e1}'\'' <<< '\''1.0e1'\'''
json -d '{"plain":-1.0e1}' <<< '1.0e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":-1.0e1}'\'' <<< '\''1.0e1'\'''

echo '$ json -d '\''{"plain":1.0e1}'\'' <<< '\''-0'\'''
json -d '{"plain":1.0e1}' <<< '-0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1.0e1}'\'' <<< '\''-0'\'''

echo '$ json -d '\''{"plain":1.0e1}'\'' <<< '\''0'\'''
json -d '{"plain":1.0e1}' <<< '0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1.0e1}'\'' <<< '\''0'\'''

echo '$ json -d '\''{"plain":1.0e1}'\'' <<< '\''-1'\'''
json -d '{"plain":1.0e1}' <<< '-1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1.0e1}'\'' <<< '\''-1'\'''

echo '$ json -d '\''{"plain":1.0e1}'\'' <<< '\''1'\'''
json -d '{"plain":1.0e1}' <<< '1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1.0e1}'\'' <<< '\''1'\'''

echo '$ json -d '\''{"plain":1.0e1}'\'' <<< '\''1.0'\'''
json -d '{"plain":1.0e1}' <<< '1.0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1.0e1}'\'' <<< '\''1.0'\'''

echo '$ json -d '\''{"plain":1.0e1}'\'' <<< '\''-1.0'\'''
json -d '{"plain":1.0e1}' <<< '-1.0' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1.0e1}'\'' <<< '\''-1.0'\'''

echo '$ json -d '\''{"plain":1.0e1}'\'' <<< '\''-1e1'\'''
json -d '{"plain":1.0e1}' <<< '-1e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1.0e1}'\'' <<< '\''-1e1'\'''

echo '$ json -d '\''{"plain":1.0e1}'\'' <<< '\''1e1'\'''
json -d '{"plain":1.0e1}' <<< '1e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1.0e1}'\'' <<< '\''1e1'\'''

echo '$ json -d '\''{"plain":1.0e1}'\'' <<< '\''-1E1'\'''
json -d '{"plain":1.0e1}' <<< '-1E1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1.0e1}'\'' <<< '\''-1E1'\'''

echo '$ json -d '\''{"plain":1.0e1}'\'' <<< '\''1E1'\'''
json -d '{"plain":1.0e1}' <<< '1E1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1.0e1}'\'' <<< '\''1E1'\'''

echo '$ json -d '\''{"plain":1.0e1}'\'' <<< '\''-1.0e1'\'''
json -d '{"plain":1.0e1}' <<< '-1.0e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1.0e1}'\'' <<< '\''-1.0e1'\'''

echo '$ json -d '\''{"plain":1.0e1}'\'' <<< '\''1.0e1'\'''
json -d '{"plain":1.0e1}' <<< '1.0e1' 2>&1 ||
echo 'command failed: json -d '\''{"plain":1.0e1}'\'' <<< '\''1.0e1'\'''
)

