#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-lib:list-plain
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-plain.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --from-ast-print --verbose --no-error; }
$ json <<< '\''{"type":"list","args":[{"plain":null}]}'\''
{
    "type": "list",
    "args": [
        {
            "plain": null
        }
    ],
    "attr": {
        "any": null,
        "plain": {
            "sym": {
                "plain": null
            },
            "lo": null,
            "eq": {
                "val": {
                    "plain": null
                },
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"plain":false}]}'\''
{
    "type": "list",
    "args": [
        {
            "plain": false
        }
    ],
    "attr": {
        "any": null,
        "plain": {
            "sym": {
                "plain": false
            },
            "lo": null,
            "eq": {
                "val": {
                    "plain": false
                },
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"plain":true}]}'\''
{
    "type": "list",
    "args": [
        {
            "plain": true
        }
    ],
    "attr": {
        "any": null,
        "plain": {
            "sym": {
                "plain": true
            },
            "lo": null,
            "eq": {
                "val": {
                    "plain": true
                },
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"plain":123}]}'\''
{
    "type": "list",
    "args": [
        {
            "plain": 123
        }
    ],
    "attr": {
        "any": null,
        "plain": {
            "sym": {
                "plain": 123
            },
            "lo": null,
            "eq": {
                "val": {
                    "plain": 123
                },
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}'
) -L list-plain.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --from-ast-print --verbose --no-error; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --from-ast-print --verbose --no-error; }'

echo '$ json <<< '\''{"type":"list","args":[{"plain":null}]}'\'''
json <<< '{"type":"list","args":[{"plain":null}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"plain":null}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"plain":false}]}'\'''
json <<< '{"type":"list","args":[{"plain":false}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"plain":false}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"plain":true}]}'\'''
json <<< '{"type":"list","args":[{"plain":true}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"plain":true}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"plain":123}]}'\'''
json <<< '{"type":"list","args":[{"plain":123}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"plain":123}]}'\'''
)

