/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.AttributeHandler;
import att.grappa.Edge;
import att.grappa.Element;
import att.grappa.Graph;
import att.grappa.Grappa;
import att.grappa.GrappaBox;
import att.grappa.GrappaColor;
import att.grappa.GrappaConstants;
import att.grappa.GrappaLine;
import att.grappa.GrappaPoint;
import att.grappa.GrappaSize;
import att.grappa.GrappaStyle;
import att.grappa.GrappaSupport;
import att.grappa.GrappaSupportPrintf;
import att.grappa.Node;
import att.grappa.Subgraph;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;

public final class Attribute
extends Observable
implements AttributeHandler,
GrappaConstants {
    private static AttributeHandler specialHandler = null;
    private String name;
    private String stringValue;
    private Object value;
    private int elementType;
    private int attributeType;
    private int nameHash;

    public static AttributeHandler setAttributeHandler(AttributeHandler attributeHandler) {
        AttributeHandler attributeHandler2 = specialHandler;
        specialHandler = attributeHandler;
        return attributeHandler2;
    }

    public Attribute(int n, String string, Object object) {
        if (string == null) {
            throw new IllegalArgumentException("the name of an Attribute pair cannot be null");
        }
        this.attributeType = Attribute.attributeType(n, string);
        this.elementType = n;
        this.name = string;
        this.nameHash = this.name.hashCode();
        this.setValue(object);
    }

    public Attribute(Attribute attribute) {
        this(attribute.getElementType(), attribute.getName(), attribute.getValue());
    }

    public final int getElementType() {
        return this.elementType;
    }

    public final int getAttributeType() {
        return this.attributeType;
    }

    public final String getName() {
        return this.name;
    }

    public final Object getValue() {
        if (this.value == null && this.stringValue != null) {
            this.value = this.convertStringValue(this.elementType, this.name, this.stringValue, this.attributeType);
        }
        return this.value;
    }

    public final String getStringValue() {
        switch (this.attributeType) {
            case 6: {
                this.stringValue = null;
            }
        }
        if (this.stringValue == null && this.value != null) {
            this.stringValue = this.convertValue(this.elementType, this.name, this.value, this.attributeType);
        }
        return this.stringValue;
    }

    public final Object setValue(Object object) {
        boolean bl = false;
        boolean bl2 = false;
        Object object2 = null;
        if (object != null && object instanceof String) {
            bl2 = true;
            object2 = this.getStringValue();
            object = ((String)object).trim();
        } else {
            object2 = this.getValue();
        }
        if (object != null) {
            if (bl2) {
                bl = this.stringValue == null || !object.equals(this.stringValue);
                if (bl) {
                    this.stringValue = (String)object;
                    this.value = null;
                }
            } else {
                bl = this.value == null || !object.equals(this.value);
                if (bl) {
                    this.value = this.copyValue(this.elementType, this.name, object, this.attributeType);
                    this.stringValue = null;
                }
            }
        } else {
            bl = this.value != null;
            if (bl) {
                this.value = null;
                this.stringValue = null;
            }
        }
        if (bl) {
            this.setChanged();
        }
        return object2;
    }

    public final boolean equals(Attribute attribute) {
        if (attribute == null) {
            return false;
        }
        if (this == attribute) {
            return true;
        }
        if (this.nameHash != attribute.getNameHash() || !attribute.getName().equals(this.name)) {
            return false;
        }
        String string = attribute.getStringValue();
        if (string == this.getStringValue()) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return string.equals(this.stringValue);
    }

    public final boolean equalsValue(Attribute attribute) {
        if (attribute == null) {
            return false;
        }
        if (this == attribute) {
            return true;
        }
        String string = attribute.getStringValue();
        if (string == this.getStringValue()) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return string.equals(this.stringValue);
    }

    public final int getNameHash() {
        return this.nameHash;
    }

    public final void setChanged() {
        super.setChanged();
    }

    public final void clearChanged() {
        super.clearChanged();
    }

    public String toString() {
        return this.getClass().getName() + "[name=\"" + this.name + "\",value=\"" + this.getStringValue() + "\"]";
    }

    public String convertValue(int n, String string, Object object, int n2) {
        String string2 = null;
        switch (n2) {
            case 1: {
                if (object instanceof GrappaBox) {
                    string2 = ((GrappaBox)object).toAttributeString();
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + string + "\" is not an instance of GrappaBox");
            }
            case 2: {
                if (object instanceof Color) {
                    string2 = GrappaColor.getColorName((Color)object);
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + string + "\" is not an instance of Color");
            }
            case 3: {
                if (object instanceof Integer) {
                    string2 = GrappaSupport.xlateDir((Integer)object);
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + string + "\" is not an instance of Integer");
            }
            case 4: {
                if (object instanceof Double) {
                    string2 = GrappaSupportPrintf.sprintf(new Object[]{"%g", object});
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + string + "\" is not an instance of Double");
            }
            case 5: {
                if (object instanceof Integer) {
                    string2 = GrappaSupport.xlateFontStyle((Integer)object);
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + string + "\" is not an instance of Integer");
            }
            case 6: {
                if (object instanceof Hashtable) {
                    StringBuffer stringBuffer = new StringBuffer();
                    Enumeration enumeration = ((Hashtable)object).keys();
                    StringBuffer stringBuffer2 = stringBuffer;
                    synchronized (stringBuffer2) {
                        while (enumeration.hasMoreElements()) {
                            if (stringBuffer.length() > 0) {
                                stringBuffer.append(',');
                            }
                            stringBuffer.append((String)enumeration.nextElement());
                        }
                        string2 = stringBuffer.toString();
                        break;
                    }
                }
                throw new IllegalArgumentException("value of attribute \"" + string + "\" is not an instance of Hashtable");
            }
            case 7: {
                if (object instanceof Integer) {
                    string2 = ((Integer)object).toString();
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + string + "\" is not an instance of Integer");
            }
            case 8: {
                if (object instanceof GrappaLine) {
                    string2 = ((GrappaLine)object).toAttributeString();
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + string + "\" is not an instance of GrappaLine");
            }
            case 9: {
                if (object instanceof GrappaPoint) {
                    string2 = ((GrappaPoint)object).toAttributeString();
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + string + "\" is not an instance of GrappaPoint");
            }
            case 10: {
                if (object instanceof Integer) {
                    string2 = (String)Grappa.shapeToKey.get(object);
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + string + "\" is not an instance of Integer");
            }
            case 11: {
                if (object instanceof GrappaSize) {
                    string2 = ((GrappaSize)object).toAttributeString();
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + string + "\" is not an instance of GrappaSize");
            }
            case 12: {
                if (object instanceof String) {
                    string2 = (String)object;
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + string + "\" is not an instance of String");
            }
            case 13: {
                if (object instanceof GrappaStyle) {
                    string2 = ((GrappaStyle)object).toAttributeString();
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + string + "\" is not an instance of GrappaStyle");
            }
            default: {
                if (specialHandler != null) {
                    string2 = specialHandler.convertValue(n, string, object, n2);
                    break;
                }
                throw new RuntimeException(Element.typeString(n, true) + " attribute (" + string + ") needs a special handler");
            }
        }
        if (string2 == null && object != null) {
            if (object instanceof String) {
                string2 = (String)object;
            } else {
                throw new RuntimeException("AttributeHandler needed to perform conversion of attribute \"" + string + "\", please supply one via Attribute.setAttributeHandler()");
            }
        }
        return string2;
    }

    public Object convertStringValue(int n, String string, String string2, int n2) {
        Object object = null;
        if (string2 == null || string2 != null && n2 != 12 && string2.trim().length() == 0) {
            object = null;
            string2 = null;
        } else {
            switch (n2) {
                case 1: {
                    object = new GrappaBox(string2, false);
                    break;
                }
                case 2: {
                    object = GrappaColor.getColor(string2, null);
                    break;
                }
                case 3: {
                    object = new Integer(GrappaSupport.xlateDirString(string2));
                    break;
                }
                case 4: {
                    try {
                        object = Double.valueOf(string2);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("bad number format (" + string2 + ") for attribute \"" + string + "\"");
                    }
                }
                case 5: {
                    object = new Integer(GrappaSupport.xlateFontStyleString(string2));
                    break;
                }
                case 6: {
                    String[] stringArray = GrappaSupport.strsplit(string2);
                    if (this.value != null && this.value instanceof Hashtable) {
                        object = this.value;
                        ((Hashtable)object).clear();
                    } else {
                        object = new Hashtable();
                    }
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        ((Hashtable)object).put(stringArray[n3], stringArray[n3]);
                        ++n3;
                    }
                    break;
                }
                case 7: {
                    try {
                        object = Integer.valueOf(string2);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("bad integer format (" + string2 + ") for attribute \"" + string + "\"");
                    }
                }
                case 8: {
                    object = new GrappaLine(string2);
                    break;
                }
                case 9: {
                    object = new GrappaPoint(string2);
                    break;
                }
                case 10: {
                    Attribute attribute;
                    object = (Integer)Grappa.keyToShape.get(string2);
                    if (object != null || (attribute = Graph.getGlobalAttribute(1, "shape")) != null && (object = (Integer)Grappa.keyToShape.get(attribute.getValue())) != null) break;
                    throw new InternalError("could not provide default when unkown shape (" + string2 + ") supplied for attribute \"" + string + "\"");
                }
                case 11: {
                    object = new GrappaSize(string2);
                    break;
                }
                case 12: {
                    object = string2;
                    break;
                }
                case 13: {
                    object = new GrappaStyle(this.elementType, string2);
                    break;
                }
                default: {
                    if (specialHandler != null) {
                        object = specialHandler.convertStringValue(n, string, string2, n2);
                        break;
                    }
                    throw new RuntimeException(Element.typeString(n, true) + " attribute (" + string + ") needs a special handler");
                }
            }
            if (object == null && string2 != null) {
                object = string2;
            }
        }
        return object;
    }

    public Object copyValue(int n, String string, Object object, int n2) {
        Object object2 = null;
        switch (n2) {
            case 1: {
                if (object instanceof GrappaBox) {
                    object2 = ((GrappaBox)object).clone();
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + string + "\" is not an instance of GrappaBox");
            }
            case 2: {
                if (object instanceof Color) {
                    object2 = object;
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + string + "\" is not an instance of Color");
            }
            case 3: {
                if (object instanceof Integer) {
                    object2 = object;
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + string + "\" is not an instance of Integer");
            }
            case 4: {
                if (object instanceof Double) {
                    object2 = object;
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + string + "\" is not an instance of Double");
            }
            case 5: {
                if (object instanceof Integer) {
                    object2 = object;
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + string + "\" is not an instance of Integer");
            }
            case 6: {
                if (object instanceof Hashtable) {
                    object2 = ((Hashtable)object).clone();
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + string + "\" is not an instance of Integer");
            }
            case 7: {
                if (object instanceof Integer) {
                    object2 = object;
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + string + "\" is not an instance of Integer");
            }
            case 8: {
                if (object instanceof GrappaLine) {
                    object2 = ((GrappaLine)object).clone();
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + string + "\" is not an instance of GrappaLine");
            }
            case 9: {
                if (object instanceof GrappaPoint) {
                    object2 = ((GrappaPoint)object).clone();
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + string + "\" is not an instance of GrappaPoint");
            }
            case 10: {
                if (object instanceof Integer) {
                    object2 = object;
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + string + "\" is not an instance of Integer");
            }
            case 11: {
                if (object instanceof GrappaSize) {
                    object2 = ((GrappaSize)object).clone();
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + string + "\" is not an instance of GrappaSize");
            }
            case 12: {
                if (object instanceof String) {
                    object2 = object;
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + string + "\" is not an instance of String");
            }
            case 13: {
                if (object instanceof GrappaStyle) {
                    object2 = ((GrappaStyle)object).clone();
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + string + "\" is not an instance of GrappaPoint");
            }
            default: {
                if (specialHandler != null) {
                    object2 = specialHandler.copyValue(n, string, object, n2);
                    break;
                }
                throw new RuntimeException(Element.typeString(n, true) + " attribute (" + string + ") needs a special handler");
            }
        }
        if (object2 == null && object != null) {
            if (object instanceof String) {
                object2 = object;
            } else {
                throw new RuntimeException("AttributeHandler needed to perform copy of attribute \"" + string + "\", please supply one via Attribute.setAttributeHandler()");
            }
        }
        return object2;
    }

    public static int attributeType(int n, String string) {
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = Node.attributeType(string);
                break;
            }
            case 2: {
                n2 = Edge.attributeType(string);
                break;
            }
            case 4: {
                n2 = Subgraph.attributeType(string);
                break;
            }
            case 8: {
                n2 = Graph.attributeType(string);
                break;
            }
            default: {
                throw new IllegalArgumentException("type of attribute \"" + string + "\" must be one of Grappa.NODE, Grappa.EDGE or Grappa.SUBGRAPH");
            }
        }
        return n2;
    }
}

