/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.Attribute;
import att.grappa.Element;
import att.grappa.GraphEnumeration;
import att.grappa.Grappa;
import att.grappa.GrappaConstants;
import att.grappa.GrappaPanel;
import att.grappa.Subgraph;
import java.awt.font.FontRenderContext;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class Graph
extends Subgraph {
    public static final String INDENT_STRING = "  ";
    boolean filterMode = false;
    private StringBuffer indent = null;
    private PrintWriter errWriter = null;
    private boolean paintCalled = false;
    private boolean busy = false;
    private boolean synchronizePaint = false;
    private String toolTipText = null;
    private List panelList = null;
    private int gid = 0;
    private int nid = 0;
    private int eid = 0;
    private boolean editable = false;
    private boolean menuable = false;
    private boolean selectable = true;
    private boolean directed = true;
    private boolean strict = false;
    Hashtable id2element = null;
    private Hashtable grattributes = null;
    private static Hashtable sysdfltNodeAttributes = new Hashtable(8);
    private static Hashtable sysdfltEdgeAttributes = new Hashtable(7);
    private static Hashtable sysdfltGraphAttributes = new Hashtable(11);
    public final FontRenderContext REFCNTXT = new FontRenderContext(GrappaConstants.IDENTXFRM, Grappa.useAntiAliasing, Grappa.useFractionalMetrics);

    private static void putAttribute(Hashtable hashtable, int n, String string, String string2) {
        Attribute attribute = new Attribute(n, string, string2);
        attribute.clearChanged();
        hashtable.put(string, attribute);
    }

    public Graph(String string, boolean bl, boolean bl2) {
        this.initialize(string);
        this.setDirection(bl);
        this.strict = bl2;
        this.setGrappaAttribute("grappaBackgroundColor", "white");
        this.setGrappaAttribute("grappaSelectionColor", "lineColor(red),lineWidth(3)");
        this.setGrappaAttribute("grappaDeletionColor", "lineColor(grey85),lineWidth(3),dotted");
        this.setGrappaAttribute("grappaFontsizeAdjustment", "0");
    }

    public Graph(String string) {
        this(string, true, false);
    }

    private void initialize(String string) {
        this.gid = 0;
        this.nid = 0;
        this.eid = 0;
        this.clearBBox();
        if (this.id2element != null) {
            this.id2element.clear();
        }
        this.setGraph(this);
        this.setSubgraph(null);
        this.setIdKey(4);
        this.addIdMapping(this);
        this.setName(string);
        Object var2_2 = null;
        Enumeration enumeration = Graph.getGlobalAttributePairs(1);
        while (enumeration.hasMoreElements()) {
            this.setNodeAttribute((Attribute)enumeration.nextElement());
        }
        enumeration = Graph.getGlobalAttributePairs(2);
        while (enumeration.hasMoreElements()) {
            this.setEdgeAttribute((Attribute)enumeration.nextElement());
        }
        enumeration = Graph.getGlobalAttributePairs(4);
        while (enumeration.hasMoreElements()) {
            this.setAttribute((Attribute)enumeration.nextElement());
        }
        this.setDelete(false);
    }

    private void setDirection(boolean bl) {
        this.directed = bl;
        if (bl) {
            this.setEdgeAttribute("dir", "forward");
        } else {
            this.setEdgeAttribute("dir", "none");
        }
    }

    public boolean setSynchronizePaint(boolean bl) {
        boolean bl2 = this.synchronizePaint;
        this.synchronizePaint = bl;
        return bl2;
    }

    public boolean getSynchronizePaint() {
        return this.synchronizePaint;
    }

    public boolean dropcloth(boolean bl, boolean bl2) {
        return this.setBlocked(bl, false, bl2);
    }

    boolean setPaint(boolean bl) {
        return this.setBlocked(bl, true, false);
    }

    private synchronized boolean setBlocked(boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            if (bl) {
                this.paintCalled = true;
                if (this.busy) {
                    return false;
                }
                this.busy = true;
                return true;
            }
            this.busy = false;
            this.paintCalled = false;
            return true;
        }
        if (bl) {
            if (this.paintCalled) {
                return false;
            }
            this.busy = true;
            return true;
        }
        if (!this.paintCalled) {
            this.busy = false;
        } else {
            this.paintCalled = false;
            this.busy = false;
            if (bl3) {
                this.repaint();
            }
        }
        return true;
    }

    public Attribute getGrappaAttribute(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("key value cannot be null");
        }
        if (this.grattributes == null) {
            return null;
        }
        return (Attribute)this.grattributes.get(string);
    }

    public Object getGrappaAttributeValue(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("key value cannot be null");
        }
        if (this.grattributes == null) {
            return null;
        }
        Attribute attribute = (Attribute)this.grattributes.get(string);
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }

    public Object setGrappaAttribute(String string, String string2) throws IllegalArgumentException {
        Attribute attribute;
        if (this.grattributes == null) {
            this.grattributes = new Hashtable(4);
        }
        if ((attribute = this.getGrappaAttribute(string)) == null) {
            if (!Graph.validGrappaAttributeKey(string)) {
                throw new IllegalArgumentException("Grappa attribute key must use \"grappa\" as a prefix");
            }
            attribute = new Attribute(8, string, string2);
            this.grattributes.put(string, attribute);
            return null;
        }
        this.grattributes.put(string, new Attribute(8, string, string2));
        return attribute.getValue();
    }

    public static int attributeType(String string) {
        int n = -1;
        if (string != null) {
            int n2 = string.hashCode();
            n = n2 == GrappaConstants.GRAPPA_BACKGROUND_COLOR_HASH && string.equals("grappaBackgroundColor") ? 2 : (n2 == GrappaConstants.GRAPPA_SELECTION_STYLE_HASH && string.equals("grappaSelectionColor") ? 13 : (n2 == GrappaConstants.GRAPPA_DELETION_STYLE_HASH && string.equals("grappaDeletionColor") ? 13 : (n2 == GrappaConstants.GRAPPA_FONTSIZE_ADJUSTMENT_HASH && string.equals("grappaFontsizeAdjustment") ? 7 : 12)));
        }
        return n;
    }

    public Enumeration getGrappaAttributeKeys() {
        if (this.grattributes == null) {
            return Grappa.emptyEnumeration.elements();
        }
        return this.grattributes.keys();
    }

    public static boolean validGrappaAttributeKey(String string) {
        return string != null && string.startsWith("grappa") && string.length() > "grappa".length();
    }

    public static Attribute getGlobalAttribute(int n, String string) throws IllegalArgumentException {
        switch (n) {
            case 1: {
                return (Attribute)sysdfltNodeAttributes.get(string);
            }
            case 2: {
                return (Attribute)sysdfltEdgeAttributes.get(string);
            }
            case 4: {
                return (Attribute)sysdfltGraphAttributes.get(string);
            }
        }
        throw new IllegalArgumentException("specified type must be NODE, EDGE or SUBGRAPH");
    }

    public static Enumeration getGlobalAttributeKeys(int n) throws IllegalArgumentException {
        switch (n) {
            case 1: {
                return sysdfltNodeAttributes.keys();
            }
            case 2: {
                return sysdfltEdgeAttributes.keys();
            }
            case 4: {
                return sysdfltGraphAttributes.keys();
            }
        }
        throw new IllegalArgumentException("specified type must be NODE, EDGE or SUBGRAPH");
    }

    public static Enumeration getGlobalAttributePairs(int n) throws IllegalArgumentException {
        switch (n) {
            case 1: {
                return sysdfltNodeAttributes.elements();
            }
            case 2: {
                return sysdfltEdgeAttributes.elements();
            }
            case 4: {
                return sysdfltGraphAttributes.elements();
            }
        }
        throw new IllegalArgumentException("specified type must be NODE, EDGE or SUBGRAPH");
    }

    public static int getGlobalAttributeSize(int n) throws IllegalArgumentException {
        switch (n) {
            case 1: {
                return sysdfltNodeAttributes.size();
            }
            case 2: {
                return sysdfltEdgeAttributes.size();
            }
            case 4: {
                return sysdfltGraphAttributes.size();
            }
        }
        throw new IllegalArgumentException("specified type must be NODE, EDGE or SUBGRAPH");
    }

    Element addIdMapping(Element element) {
        if (element == null) {
            return null;
        }
        if (this.id2element == null) {
            this.id2element = new Hashtable();
        }
        return this.id2element.put(element.getIdKey(), element);
    }

    static Long idMapKey(int n, int n2) throws IllegalArgumentException {
        long l = n2;
        int n3 = n & 7;
        if (n3 == 0) {
            throw new IllegalArgumentException("supplied type does not specify node, edge or subgraph");
        }
        l = l << 3 | (long)(n & 7);
        return new Long(l);
    }

    static int idKeyType(Long l) {
        long l2 = l;
        return (int)(l2 & 7L);
    }

    static int idKeyId(Long l) {
        long l2 = l;
        return (int)(l2 >>> 3);
    }

    Element element4Id(Long l) {
        if (this.id2element == null) {
            return null;
        }
        return (Element)this.id2element.get(l);
    }

    void removeIdMapping(Element element) {
        if (this.id2element != null && element != null) {
            this.id2element.remove(element.getIdKey());
        }
    }

    public void printGraph(Writer writer) {
        PrintWriter printWriter = null;
        printWriter = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        this.getGraph().printSubgraph(printWriter);
        printWriter.flush();
    }

    public void printGraph(OutputStream outputStream) {
        this.printGraph(new PrintWriter(outputStream));
    }

    int nextId(int n) throws IllegalArgumentException {
        switch (n) {
            case 1: {
                return this.nid++;
            }
            case 2: {
                return this.eid++;
            }
            case 4: {
                return this.gid++;
            }
        }
        throw new IllegalArgumentException("Type (" + n + ") is not recognized.");
    }

    public int getId(int n) throws IllegalArgumentException {
        switch (n) {
            case 1: {
                return this.nid;
            }
            case 2: {
                return this.eid;
            }
            case 4: {
                return this.gid;
            }
        }
        throw new IllegalArgumentException("Type (" + n + ") is not recognized.");
    }

    public String getIndent() {
        if (this.indent == null) {
            this.indent = new StringBuffer(5 * INDENT_STRING.length());
        }
        return this.indent.toString();
    }

    public void incrementIndent() {
        if (this.indent == null) {
            this.indent = new StringBuffer(5 * INDENT_STRING.length());
        }
        this.indent.append(INDENT_STRING);
    }

    public void decrementIndent() {
        int n = this.indent.length();
        if (n == 0) {
            return;
        }
        if (n < INDENT_STRING.length()) {
            this.indent.setLength(0);
        } else {
            this.indent.setLength(n - INDENT_STRING.length());
        }
    }

    public boolean isDirected() {
        return this.directed;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public String setToolTipText(String string) {
        String string2 = this.toolTipText;
        this.toolTipText = string;
        return string2;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void reset() {
        String string = this.getName();
        if (this.delete()) {
            this.initialize(string);
        }
    }

    public void reset(String string, boolean bl, boolean bl2) {
        this.name = string;
        this.reset();
        this.setDirection(bl);
        this.strict = bl2;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean setEditable(boolean bl) {
        boolean bl2 = this.editable;
        this.editable = bl;
        return bl2;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public boolean setSelectable(boolean bl) {
        boolean bl2 = this.selectable;
        this.selectable = bl;
        return bl2;
    }

    public boolean isMenuable() {
        return this.menuable;
    }

    public boolean setMenuable(boolean bl) {
        boolean bl2 = this.menuable;
        this.menuable = bl;
        return bl2;
    }

    public PrintWriter setErrorWriter(PrintWriter printWriter) {
        PrintWriter printWriter2 = this.errWriter;
        this.errWriter = printWriter;
        return printWriter2;
    }

    public PrintWriter getErrorWriter() {
        return this.errWriter;
    }

    public void printError(String string) {
        this.printError(string, null);
    }

    public void printError(String string, Exception exception) {
        if (this.getErrorWriter() == null) {
            return;
        }
        this.getErrorWriter().println("ERROR: " + string);
        if (exception != null) {
            exception.printStackTrace(this.getErrorWriter());
        }
        this.getErrorWriter().flush();
    }

    public void buildShapes() {
        GraphEnumeration graphEnumeration = this.elements();
        while (graphEnumeration.hasMoreElements()) {
            Element element = graphEnumeration.nextGraphElement();
            if (element.grappaNexus != null) continue;
            element.buildShape();
        }
    }

    public void resync() {
        Element element = null;
        GraphEnumeration graphEnumeration = this.elements();
        while (graphEnumeration.hasMoreElements()) {
            element = graphEnumeration.nextGraphElement();
            if (element.grappaNexus == null) {
                element.buildShape();
                continue;
            }
            element.grappaNexus.rebuild();
        }
    }

    public void repaint() {
        if (this.panelList == null) {
            return;
        }
        boolean bl = true;
        ListIterator listIterator = null;
        while (bl) {
            try {
                listIterator = this.panelList.listIterator(0);
                while (listIterator.hasNext()) {
                    ((GrappaPanel)listIterator.next()).repaint();
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            bl = false;
        }
    }

    public void paintImmediately() {
        if (this.panelList == null) {
            return;
        }
        boolean bl = true;
        ListIterator listIterator = null;
        GrappaPanel grappaPanel = null;
        while (bl) {
            try {
                listIterator = this.panelList.listIterator(0);
                while (listIterator.hasNext()) {
                    grappaPanel = (GrappaPanel)listIterator.next();
                    grappaPanel.paintImmediately(grappaPanel.getVisibleRect());
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            bl = false;
        }
    }

    public void addPanel(GrappaPanel grappaPanel) {
        if (this.panelList == null) {
            this.panelList = Collections.synchronizedList(new LinkedList());
        }
        List list = this.panelList;
        synchronized (list) {
            if (!this.panelList.contains(grappaPanel)) {
                this.panelList.add(grappaPanel);
            }
        }
    }

    public void removePanel(GrappaPanel grappaPanel) {
        if (this.panelList == null) {
            return;
        }
        List list = this.panelList;
        synchronized (list) {
            this.panelList.remove(grappaPanel);
        }
    }

    static {
        Graph.putAttribute(sysdfltNodeAttributes, 1, "color", "black");
        Graph.putAttribute(sysdfltNodeAttributes, 1, "fontcolor", "black");
        Graph.putAttribute(sysdfltNodeAttributes, 1, "fontname", "TimesRoman");
        Graph.putAttribute(sysdfltNodeAttributes, 1, "fontsize", "14");
        Graph.putAttribute(sysdfltNodeAttributes, 1, "fontstyle", "normal");
        Graph.putAttribute(sysdfltNodeAttributes, 1, "height", "0.5");
        Graph.putAttribute(sysdfltNodeAttributes, 1, "pos", "0,0");
        Graph.putAttribute(sysdfltNodeAttributes, 1, "label", "\\N");
        Graph.putAttribute(sysdfltNodeAttributes, 1, "shape", "ellipse");
        Graph.putAttribute(sysdfltNodeAttributes, 1, "style", "__default__");
        Graph.putAttribute(sysdfltNodeAttributes, 1, "width", "0.75");
        Graph.putAttribute(sysdfltEdgeAttributes, 2, "color", "black");
        Graph.putAttribute(sysdfltEdgeAttributes, 2, "dir", "forward");
        Graph.putAttribute(sysdfltEdgeAttributes, 2, "fontcolor", "black");
        Graph.putAttribute(sysdfltEdgeAttributes, 2, "fontname", "TimesRoman");
        Graph.putAttribute(sysdfltEdgeAttributes, 2, "fontsize", "14");
        Graph.putAttribute(sysdfltEdgeAttributes, 2, "fontstyle", "normal");
        Graph.putAttribute(sysdfltEdgeAttributes, 2, "minlen", "1");
        Graph.putAttribute(sysdfltEdgeAttributes, 2, "style", "__default__");
        Graph.putAttribute(sysdfltEdgeAttributes, 2, "weight", "1");
        Graph.putAttribute(sysdfltGraphAttributes, 4, "clusterrank", "local");
        Graph.putAttribute(sysdfltGraphAttributes, 4, "color", "white");
        Graph.putAttribute(sysdfltGraphAttributes, 4, "fontcolor", "black");
        Graph.putAttribute(sysdfltGraphAttributes, 4, "fontname", "TimesRoman");
        Graph.putAttribute(sysdfltGraphAttributes, 4, "fontsize", "14");
        Graph.putAttribute(sysdfltGraphAttributes, 4, "fontstyle", "normal");
        Graph.putAttribute(sysdfltGraphAttributes, 4, "margin", "0.5,0.5");
        Graph.putAttribute(sysdfltGraphAttributes, 4, "mclimit", "1");
        Graph.putAttribute(sysdfltGraphAttributes, 4, "nodesep", "0.25");
        Graph.putAttribute(sysdfltGraphAttributes, 4, "orientation", "portrait");
        Graph.putAttribute(sysdfltGraphAttributes, 4, "rankdir", "TB");
        Graph.putAttribute(sysdfltGraphAttributes, 4, "ranksep", "0.75");
        Graph.putAttribute(sysdfltGraphAttributes, 4, "style", "__default__");
    }
}

