/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.Grappa;
import att.grappa.GrappaSupport;
import att.grappa.GrappaSupportPrintf;
import java.awt.geom.Point2D;

public class GrappaPoint
extends Point2D.Double {
    public GrappaPoint() {
    }

    public GrappaPoint(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public GrappaPoint(String string) {
        double[] dArray = null;
        try {
            dArray = GrappaSupport.arrayForTuple(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("coordinate string (" + string + ") has a bad number format (" + numberFormatException.getMessage() + ")");
        }
        if (dArray == null || dArray.length != 2) {
            throw new IllegalArgumentException("coordinate string (" + string + ") does not contain 2 valid coordinates");
        }
        this.x = dArray[0];
        this.y = Grappa.negateStringYCoord ? -dArray[1] : dArray[1];
    }

    public String toAttributeString() {
        return this.toFormattedString("%p");
    }

    public String toFormattedString(String string) {
        return GrappaSupportPrintf.sprintf(new Object[]{string, this});
    }

    public String toString() {
        return this.x + "," + this.y;
    }
}

