/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.Attribute;
import att.grappa.Edge;
import att.grappa.Element;
import att.grappa.Graph;
import att.grappa.GraphEnumeration;
import att.grappa.Grappa;
import att.grappa.GrappaBox;
import att.grappa.GrappaConstants;
import att.grappa.GrappaPoint;
import att.grappa.GrappaSize;
import att.grappa.Node;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

public class Subgraph
extends Element
implements Comparator {
    public static final String defaultNamePrefix = "G";
    private Hashtable nodedict = null;
    private Hashtable edgedict = null;
    private Hashtable graphdict = null;
    private boolean nodeLabels = true;
    private boolean edgeLabels = true;
    private boolean subgLabels = true;
    private Hashtable nodeAttributes = null;
    private Hashtable edgeAttributes = null;
    private boolean cluster = false;
    public Object currentSelection = null;
    private double PATCHEDGE = 2.0;
    private double PATCHEDGE2 = 2.0 * this.PATCHEDGE;
    private Element[] sgPatches = null;
    private Element[] elPatches = null;
    private GrappaBox patch = null;

    Subgraph() {
        this.cluster = true;
        this.subgraphAttrsOfInterest();
    }

    public Subgraph(Subgraph subgraph, String string) {
        super(4, subgraph);
        this.setName(string);
        Enumeration enumeration = subgraph.getNodeAttributePairs();
        while (enumeration.hasMoreElements()) {
            this.setNodeAttribute((Attribute)enumeration.nextElement());
        }
        enumeration = subgraph.getEdgeAttributePairs();
        while (enumeration.hasMoreElements()) {
            this.setEdgeAttribute((Attribute)enumeration.nextElement());
        }
        enumeration = subgraph.getLocalAttributePairs();
        while (enumeration.hasMoreElements()) {
            this.setAttribute((Attribute)enumeration.nextElement());
        }
        this.subgraphAttrsOfInterest();
    }

    public Subgraph(Subgraph subgraph) {
        this(subgraph, (String)null);
    }

    private void subgraphAttrsOfInterest() {
        this.attrOfInterest("minbox");
        this.attrOfInterest("minsize");
        this.attrOfInterest("label");
        this.attrOfInterest("lp");
        this.attrOfInterest("style");
    }

    public boolean isSubgraph() {
        return true;
    }

    public int getType() {
        return 4;
    }

    void setName() {
        String string = this.name;
        do {
            this.name = defaultNamePrefix + this.getId() + "_" + System.currentTimeMillis();
        } while (this.getGraph().findSubgraphByName(this.name) != null);
        if (this.getSubgraph() != null) {
            if (string != null) {
                this.getSubgraph().removeSubgraph(string);
            }
            this.getSubgraph().addSubgraph(this);
        }
        this.canonName = null;
    }

    public void setName(String string) throws IllegalArgumentException {
        if (string == null) {
            this.setName();
            return;
        }
        String string2 = this.name;
        if (string2 != null && string2.equals(string)) {
            return;
        }
        if (this.getGraph().findSubgraphByName(string) != null) {
            throw new IllegalArgumentException("graph name (" + string + ") is not unique");
        }
        this.name = string;
        if (this.name.startsWith("cluster")) {
            this.cluster = true;
        }
        if (this.getSubgraph() != null) {
            if (string2 != null) {
                this.getSubgraph().removeSubgraph(string2);
            }
            this.getSubgraph().addSubgraph(this);
        }
        this.canonName = null;
    }

    public boolean isCluster() {
        return this.cluster;
    }

    public boolean isRoot() {
        return this == this.getGraph();
    }

    public Attribute getNodeAttribute(String string) {
        if (this.nodeAttributes == null) {
            return null;
        }
        return (Attribute)this.nodeAttributes.get(string);
    }

    public Object getNodeAttributeValue(String string) {
        if (this.nodeAttributes == null) {
            return null;
        }
        Attribute attribute = (Attribute)this.nodeAttributes.get(string);
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }

    public Enumeration getNodeAttributeKeys() {
        if (this.nodeAttributes == null) {
            return Grappa.emptyEnumeration.elements();
        }
        return this.nodeAttributes.keys();
    }

    public Enumeration getNodeAttributePairs() {
        if (this.nodeAttributes == null) {
            return Grappa.emptyEnumeration.elements();
        }
        return this.nodeAttributes.elements();
    }

    public Object setNodeAttribute(Attribute attribute) {
        Subgraph subgraph;
        Attribute attribute2;
        if (attribute == null) {
            return null;
        }
        if (this.nodeAttributes == null) {
            this.nodeAttributes = new Hashtable();
        }
        Attribute attribute3 = attribute2 = (subgraph = this.getSubgraph()) == null ? null : subgraph.getNodeAttribute(attribute.getName());
        if (attribute != attribute2) {
            return this.setNodeAttribute(attribute.getName(), attribute.getValue());
        }
        Object object = null;
        Attribute attribute4 = null;
        Attribute attribute5 = this.getNodeAttribute(attribute.getName());
        if (attribute == attribute5) {
            return attribute.getValue();
        }
        if (attribute5 == null) {
            if (attribute.getValue() == null) {
                return null;
            }
            attribute5 = attribute;
            this.nodeAttributes.put(attribute.getName(), attribute5);
        } else {
            object = attribute5.getValue();
            attribute5.setChanged();
            this.nodeAttributes.put(attribute.getName(), attribute);
            attribute4 = attribute;
        }
        if (attribute5.hasChanged()) {
            attribute5.notifyObservers(new Object[]{attribute4, new Long(System.currentTimeMillis())});
        }
        return object;
    }

    public Object setNodeAttribute(String string, Object object) {
        if (this.nodeAttributes == null) {
            this.nodeAttributes = new Hashtable();
        }
        if (string == null) {
            throw new IllegalArgumentException("cannot set an attribute using a null name");
        }
        Subgraph subgraph = this.getSubgraph();
        Attribute attribute = subgraph == null ? null : subgraph.getNodeAttribute(string);
        Object object2 = null;
        Attribute attribute2 = this.getNodeAttribute(string);
        if (attribute2 == null || attribute2 == attribute) {
            if (object == null) {
                return null;
            }
            attribute2 = new Attribute(1, string, object);
            this.nodeAttributes.put(string, attribute2);
        } else {
            object2 = attribute2.getValue();
            if (object == null) {
                if (attribute == null) {
                    this.removeNodeAttribute(string);
                    return object2;
                }
                return this.setNodeAttribute(attribute);
            }
            attribute2.setValue(object);
        }
        if (attribute2.hasChanged()) {
            attribute2.notifyObservers(new Long(System.currentTimeMillis()));
        }
        return object2;
    }

    private void removeNodeAttribute(String string) {
        if (string == null || this.nodeAttributes == null) {
            return;
        }
        Attribute attribute = (Attribute)this.nodeAttributes.remove(string);
        if (attribute == null) {
            return;
        }
        attribute.setValue("");
        if (attribute.hasChanged()) {
            attribute.notifyObservers(new Long(System.currentTimeMillis()));
        }
        attribute.deleteObservers();
    }

    public Object setEdgeAttribute(Attribute attribute) {
        Subgraph subgraph;
        Attribute attribute2;
        if (attribute == null) {
            return null;
        }
        if (this.edgeAttributes == null) {
            this.edgeAttributes = new Hashtable();
        }
        Attribute attribute3 = attribute2 = (subgraph = this.getSubgraph()) == null ? null : subgraph.getEdgeAttribute(attribute.getName());
        if (attribute != attribute2) {
            return this.setEdgeAttribute(attribute.getName(), attribute.getValue());
        }
        Object object = null;
        Attribute attribute4 = null;
        Attribute attribute5 = this.getEdgeAttribute(attribute.getName());
        if (attribute == attribute5) {
            return attribute.getValue();
        }
        if (attribute5 == null) {
            if (attribute.getValue() == null) {
                return null;
            }
            attribute5 = attribute;
            this.edgeAttributes.put(attribute.getName(), attribute5);
        } else {
            object = attribute5.getValue();
            attribute5.setChanged();
            this.edgeAttributes.put(attribute.getName(), attribute);
            attribute4 = attribute;
        }
        if (attribute5.hasChanged()) {
            attribute5.notifyObservers(new Object[]{attribute4, new Long(System.currentTimeMillis())});
        }
        return object;
    }

    public Object setEdgeAttribute(String string, Object object) {
        if (this.edgeAttributes == null) {
            this.edgeAttributes = new Hashtable();
        }
        if (string == null) {
            throw new IllegalArgumentException("cannot set an attribute using a null name");
        }
        Subgraph subgraph = this.getSubgraph();
        Attribute attribute = subgraph == null ? null : subgraph.getEdgeAttribute(string);
        Object object2 = null;
        Attribute attribute2 = this.getEdgeAttribute(string);
        if (attribute2 == null || attribute2 == attribute) {
            if (object == null) {
                return null;
            }
            attribute2 = new Attribute(2, string, object);
            this.edgeAttributes.put(string, attribute2);
        } else {
            object2 = attribute2.getValue();
            if (object == null) {
                if (attribute == null) {
                    this.removeEdgeAttribute(string);
                    return object2;
                }
                return this.setEdgeAttribute(attribute);
            }
            attribute2.setValue(object);
        }
        if (attribute2.hasChanged()) {
            attribute2.notifyObservers(new Long(System.currentTimeMillis()));
        }
        return object2;
    }

    private void removeEdgeAttribute(String string) {
        if (string == null || this.edgeAttributes == null) {
            return;
        }
        Attribute attribute = (Attribute)this.edgeAttributes.remove(string);
        if (attribute == null) {
            return;
        }
        attribute.setValue("");
        if (attribute.hasChanged()) {
            attribute.notifyObservers(new Long(System.currentTimeMillis()));
        }
        attribute.deleteObservers();
    }

    public Object setAttribute(Attribute attribute) {
        Subgraph subgraph;
        Attribute attribute2;
        if (attribute == null) {
            return null;
        }
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        Attribute attribute3 = attribute2 = (subgraph = this.getSubgraph()) == null ? null : subgraph.getLocalAttribute(attribute.getName());
        if (attribute != attribute2) {
            return this.setAttribute(attribute.getName(), attribute.getValue());
        }
        Object object = null;
        Attribute attribute4 = null;
        Attribute attribute5 = this.getLocalAttribute(attribute.getName());
        if (attribute == attribute5) {
            return attribute.getValue();
        }
        if (attribute5 == null) {
            if (attribute.getValue() == null) {
                return null;
            }
            attribute5 = attribute;
            this.attributes.put(attribute.getName(), attribute5);
        } else {
            object = attribute5.getValue();
            attribute5.setChanged();
            this.attributes.put(attribute.getName(), attribute);
            attribute4 = attribute;
        }
        if (attribute5.hasChanged()) {
            attribute5.notifyObservers(new Object[]{attribute4, new Long(System.currentTimeMillis())});
        }
        return object;
    }

    public Object setAttribute(String string, Object object) {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        if (string == null) {
            throw new IllegalArgumentException("cannot set an attribute using a null name");
        }
        Subgraph subgraph = this.getSubgraph();
        Attribute attribute = subgraph == null ? null : subgraph.getLocalAttribute(string);
        Object object2 = null;
        Attribute attribute2 = this.getLocalAttribute(string);
        if (attribute2 == null || attribute2 == attribute) {
            if (object == null) {
                return null;
            }
            if (object instanceof String && ((String)object).trim().length() == 0 && Attribute.attributeType(this.getType(), string) != 12) {
                return null;
            }
            attribute2 = new Attribute(4, string, object);
            this.attributes.put(string, attribute2);
            if (this.grappaNexus != null && this.isOfInterest(string)) {
                attribute2.addObserver(this.grappaNexus);
            }
        } else {
            object2 = attribute2.getValue();
            if (object == null) {
                if (attribute == null) {
                    super.setAttribute(string, null);
                    return object2;
                }
                return this.setAttribute(attribute);
            }
            if (object instanceof String && ((String)object).trim().length() == 0 && Attribute.attributeType(this.getType(), string) != 12) {
                if (attribute == null) {
                    super.setAttribute(string, null);
                    return object2;
                }
                return this.setAttribute(attribute);
            }
            attribute2.setValue(object);
        }
        if (attribute2.hasChanged()) {
            attribute2.notifyObservers(new Long(System.currentTimeMillis()));
        }
        return object2;
    }

    public Attribute getEdgeAttribute(String string) {
        if (this.edgeAttributes == null) {
            return null;
        }
        return (Attribute)this.edgeAttributes.get(string);
    }

    public Object getEdgeAttributeValue(String string) {
        if (this.edgeAttributes == null) {
            return null;
        }
        Attribute attribute = (Attribute)this.edgeAttributes.get(string);
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }

    public Enumeration getEdgeAttributeKeys() {
        if (this.edgeAttributes == null) {
            return Grappa.emptyEnumeration.elements();
        }
        return this.edgeAttributes.keys();
    }

    public Enumeration getEdgeAttributePairs() {
        if (this.edgeAttributes == null) {
            return Grappa.emptyEnumeration.elements();
        }
        return this.edgeAttributes.elements();
    }

    public Rectangle2D getBoundingBox() {
        Rectangle2D rectangle2D = null;
        if (this.grappaNexus == null || (rectangle2D = this.grappaNexus.bbox) == null) {
            GrappaBox grappaBox;
            if (this.grappaNexus == null) {
                this.buildShape();
            }
            rectangle2D = null;
            Element element = null;
            GraphEnumeration graphEnumeration = this.elements();
            while (graphEnumeration.hasMoreElements()) {
                element = graphEnumeration.nextGraphElement();
                if (element == this) continue;
                switch (element.getType()) {
                    case 1: 
                    case 2: {
                        element.buildShape();
                        if (rectangle2D == null) {
                            rectangle2D = element.grappaNexus.getBounds2D();
                            break;
                        }
                        rectangle2D.add(element.grappaNexus.getBounds2D());
                        break;
                    }
                    case 4: {
                        if (rectangle2D == null) {
                            rectangle2D = ((Subgraph)element).getBoundingBox();
                            break;
                        }
                        rectangle2D.add(((Subgraph)element).getBoundingBox());
                        break;
                    }
                    default: {
                        throw new InternalError("unknown type (" + element.getType() + ")");
                    }
                }
            }
            GrappaSize grappaSize = (GrappaSize)this.getAttributeValue("minsize");
            if (grappaSize != null) {
                if (rectangle2D == null) {
                    rectangle2D = new Rectangle2D.Double(0.0, 0.0, grappaSize.getWidth(), grappaSize.getHeight());
                } else {
                    rectangle2D.add(new Rectangle2D.Double(rectangle2D.getCenterX() - grappaSize.getWidth() / 2.0, rectangle2D.getCenterY() - grappaSize.getHeight() / 2.0, grappaSize.getWidth(), grappaSize.getHeight()));
                }
            }
            if ((grappaBox = (GrappaBox)this.getThisAttributeValue("minbox")) != null) {
                if (rectangle2D == null) {
                    rectangle2D = new Rectangle2D.Double(grappaBox.x, grappaBox.y, grappaBox.width, grappaBox.height);
                } else {
                    rectangle2D.add(new Rectangle2D.Double(grappaBox.x, grappaBox.y, grappaBox.width, grappaBox.height));
                }
            }
            if ((grappaBox = (GrappaBox)this.getThisAttributeValue("bb")) != null) {
                if (rectangle2D == null) {
                    rectangle2D = new Rectangle2D.Double(grappaBox.x, grappaBox.y, grappaBox.width, grappaBox.height);
                } else {
                    rectangle2D.add(new Rectangle2D.Double(grappaBox.x, grappaBox.y, grappaBox.width, grappaBox.height));
                }
            }
            if (rectangle2D == null) {
                rectangle2D = new Rectangle2D.Double();
            }
            rectangle2D.add(rectangle2D.getX() + rectangle2D.getWidth() + 1.0, rectangle2D.getY() + rectangle2D.getHeight() + 1.0);
            this.grappaNexus.bbox = rectangle2D;
            if (Grappa.provideBBoxAttribute) {
                this.setAttribute("bb", new GrappaBox(rectangle2D));
            }
            this.grappaNexus.updateShape();
        }
        return (Rectangle2D)rectangle2D.clone();
    }

    public Rectangle2D resetBoundingBox() {
        Element element = null;
        GraphEnumeration graphEnumeration = this.elements(4);
        while (graphEnumeration.hasMoreElements()) {
            element = graphEnumeration.nextGraphElement();
            element.grappaNexus.bbox = null;
            element.setAttribute("bb", null);
        }
        return this.getBoundingBox();
    }

    public void printSubgraph(PrintWriter printWriter) {
        Enumeration enumeration;
        Graph graph = this.getGraph();
        String string = new String(graph.getIndent());
        if (Grappa.printVisibleOnly && (!this.visible || this.grappaNexus.style.invis)) {
            return;
        }
        if (this.getSubgraph() == null) {
            printWriter.println(string + (graph.isStrict() ? "strict " : "") + (graph.isDirected() ? "digraph" : "graph") + " " + graph.toString() + " {");
        } else if (this.getName().startsWith("_anonymous_")) {
            printWriter.println(string + "{");
        } else {
            printWriter.println(string + "subgraph " + this.toString() + " {");
        }
        graph.incrementIndent();
        this.printDflt(printWriter, 4);
        this.printDflt(printWriter, 1);
        this.printDflt(printWriter, 2);
        if (this.graphdict != null && !this.graphdict.isEmpty()) {
            enumeration = this.graphdict.elements();
            while (enumeration.hasMoreElements()) {
                ((Subgraph)enumeration.nextElement()).printSubgraph(printWriter);
            }
        }
        if (this.nodedict != null && !this.nodedict.isEmpty()) {
            enumeration = this.nodedict.elements();
            while (enumeration.hasMoreElements()) {
                ((Node)enumeration.nextElement()).printNode(printWriter);
            }
        }
        if (this.edgedict != null && !this.edgedict.isEmpty()) {
            enumeration = this.edgedict.elements();
            while (enumeration.hasMoreElements()) {
                ((Edge)enumeration.nextElement()).printEdge(printWriter);
            }
        }
        graph.decrementIndent();
        printWriter.println(string + "}");
    }

    private void printDflt(PrintWriter printWriter, int n) {
        String string = new String(this.getGraph().getIndent());
        Hashtable hashtable = null;
        String string2 = null;
        switch (n) {
            case 4: {
                hashtable = this.attributes;
                string2 = "graph";
                break;
            }
            case 1: {
                hashtable = this.nodeAttributes;
                string2 = "node";
                break;
            }
            case 2: {
                hashtable = this.edgeAttributes;
                string2 = "edge";
            }
        }
        if (hashtable == null || hashtable.isEmpty()) {
            this.getGraph().printError("no " + string2 + " atrtibutes for " + this.getName());
            return;
        }
        this.getGraph().incrementIndent();
        this.printDfltAttr(printWriter, hashtable, n, string + string2 + " [", string + "];");
        this.getGraph().decrementIndent();
    }

    private void printDfltAttr(PrintWriter printWriter, Hashtable hashtable, int n, String string, String string2) {
        String string3 = new String(this.getGraph().getIndent());
        int n2 = 0;
        Enumeration enumeration = hashtable.elements();
        Subgraph subgraph = this.getSubgraph();
        Hashtable hashtable2 = null;
        if (n == 4 && (Grappa.usePrintList || Element.usePrintList)) {
            hashtable2 = (Hashtable)this.getAttributeValue("printlist");
        }
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (attribute == null) continue;
            String string4 = attribute.getName();
            if (hashtable2 != null && hashtable2.get(string4) == null) continue;
            String string5 = attribute.getStringValue();
            if (!Grappa.elementPrintAllAttributes && !Grappa.elementPrintDefaultAttributes && !this.printAllAttributes && !this.printDefaultAttributes && attribute.equalsValue(this.getParentDefault(n, string4))) continue;
            if (++n2 == 1) {
                printWriter.println(string);
                printWriter.print(string3 + string4 + " = " + Element.canonString(string5));
                continue;
            }
            printWriter.println(",");
            printWriter.print(string3 + string4 + " = " + Element.canonString(string5));
        }
        if (n2 > 0) {
            printWriter.println();
            printWriter.println(string2);
            printWriter.println();
        }
    }

    public static int attributeType(String string) {
        int n = -1;
        if (string != null) {
            int n2 = string.hashCode();
            if (n2 == GrappaConstants.MARGIN_HASH && string.equals("margin")) {
                n = 11;
            } else if (n2 == GrappaConstants.MCLIMIT_HASH && string.equals("mclimit")) {
                n = 4;
            } else if (n2 == GrappaConstants.MINBOX_HASH && string.equals("minbox")) {
                n = 1;
            } else if (n2 == GrappaConstants.NODESEP_HASH && string.equals("nodesep")) {
                n = 4;
            } else if (n2 == GrappaConstants.MINSIZE_HASH && string.equals("minsize")) {
                n = 11;
            } else if (n2 == GrappaConstants.NODESEP_HASH && string.equals("nodesep")) {
                n = 4;
            } else if (n2 == GrappaConstants.RANKSEP_HASH && string.equals("ranksep")) {
                n = 4;
            } else if (n2 == GrappaConstants.SIZE_HASH && string.equals("size")) {
                n = 11;
            } else {
                return Element.attributeType(string);
            }
        }
        return n;
    }

    private Attribute getParentDefault(int n, String string) {
        Attribute attribute = null;
        Subgraph subgraph = this.getSubgraph();
        switch (n) {
            case 4: {
                while (subgraph != null && (attribute = subgraph.getLocalAttribute(string)) == null) {
                    subgraph = subgraph.getSubgraph();
                }
                if (attribute == null) {
                    this.getGraph();
                    attribute = Graph.getGlobalAttribute(4, string);
                }
                return attribute;
            }
            case 1: {
                while (subgraph != null && (attribute = subgraph.getNodeAttribute(string)) == null) {
                    subgraph = subgraph.getSubgraph();
                }
                if (attribute == null) {
                    this.getGraph();
                    attribute = Graph.getGlobalAttribute(1, string);
                }
                return attribute;
            }
            case 2: {
                while (subgraph != null && (attribute = subgraph.getEdgeAttribute(string)) == null) {
                    subgraph = subgraph.getSubgraph();
                }
                if (attribute == null) {
                    this.getGraph();
                    attribute = Graph.getGlobalAttribute(2, string);
                }
                return attribute;
            }
        }
        return null;
    }

    private Element findElementByName(int n, String string) {
        if (string == null) {
            return null;
        }
        return this.findElementInSubgraphByName(n, string);
    }

    private Element findElementInSubgraphByName(int n, String string) {
        Element element = null;
        switch (n) {
            case 1: {
                if (this.nodedict == null) break;
                element = (Element)this.nodedict.get(string);
                break;
            }
            case 2: {
                if (this.edgedict == null) break;
                element = (Element)this.edgedict.get(string);
                break;
            }
            case 4: {
                if (this.graphdict == null) break;
                element = (Element)this.graphdict.get(string);
            }
        }
        if (element != null || this.graphdict == null) {
            return element;
        }
        Enumeration enumeration = this.graphdict.elements();
        while (enumeration.hasMoreElements()) {
            element = ((Subgraph)enumeration.nextElement()).findElementInSubgraphByName(n, string);
            if (element == null) continue;
            return element;
        }
        return element;
    }

    public Node findNodeByName(String string) {
        return (Node)this.findElementByName(1, string);
    }

    public Edge findEdgeByName(String string) {
        return (Edge)this.findElementByName(2, string);
    }

    public Subgraph findSubgraphByName(String string) {
        return (Subgraph)this.findElementByName(4, string);
    }

    public Element createElement(int n, Object[] objectArray, Attribute[] attributeArray) {
        Element element = null;
        switch (n) {
            case 1: {
                String string = null;
                if (objectArray != null && objectArray.length >= 1) {
                    string = (String)objectArray[0];
                }
                Node node = new Node(this, string);
                if (attributeArray != null) {
                    int n2 = 0;
                    while (n2 < attributeArray.length) {
                        node.setAttribute(attributeArray[n2]);
                        ++n2;
                    }
                }
                element = node;
                break;
            }
            case 2: {
                if (objectArray == null || objectArray.length < 3) {
                    throw new IllegalArgumentException("insufficient info supplied for edge creation");
                }
                Node node = (Node)objectArray[0];
                String string = (String)objectArray[1];
                Node node2 = (Node)objectArray[2];
                String string2 = null;
                String string3 = null;
                if (objectArray.length > 3) {
                    string2 = (String)objectArray[3];
                    if (objectArray.length > 4) {
                        string3 = (String)objectArray[4];
                    }
                }
                Edge edge = new Edge(this, node2, string2, node, string, string3);
                if (attributeArray != null) {
                    int n3 = 0;
                    while (n3 < attributeArray.length) {
                        edge.setAttribute(attributeArray[n3]);
                        ++n3;
                    }
                }
                element = edge;
                break;
            }
            case 4: {
                String string = null;
                if (objectArray != null && objectArray.length >= 1) {
                    string = (String)objectArray[0];
                }
                Subgraph subgraph = new Subgraph(this, string);
                if (attributeArray != null) {
                    int n4 = 0;
                    while (n4 < attributeArray.length) {
                        subgraph.setAttribute(attributeArray[n4]);
                        ++n4;
                    }
                }
                element = subgraph;
                break;
            }
            default: {
                return null;
            }
        }
        return element;
    }

    public void addNode(Node node) {
        if (node == null) {
            return;
        }
        if (this.nodedict == null) {
            this.nodedict = new Hashtable();
        }
        this.nodedict.put(node.getName(), node);
    }

    public Node removeNode(String string) {
        if (this.nodedict == null) {
            return null;
        }
        return (Node)this.nodedict.remove(string);
    }

    public void addEdge(Edge edge) {
        if (edge == null) {
            return;
        }
        if (this.edgedict == null) {
            this.edgedict = new Hashtable();
        }
        this.edgedict.put(edge.getName(), edge);
    }

    public Edge removeEdge(String string) {
        if (this.edgedict == null) {
            return null;
        }
        return (Edge)this.edgedict.remove(string);
    }

    public void addSubgraph(Subgraph subgraph) {
        if (subgraph == null) {
            return;
        }
        if (this.graphdict == null) {
            this.graphdict = new Hashtable();
        }
        this.graphdict.put(subgraph.getName(), subgraph);
    }

    public Subgraph removeSubgraph(String string) {
        if (this.graphdict == null) {
            return null;
        }
        return (Subgraph)this.graphdict.remove(string);
    }

    public boolean setShowSubgraphLabels(boolean bl) {
        boolean bl2 = this.subgLabels;
        this.subgLabels = bl;
        return bl2;
    }

    public boolean setShowNodeLabels(boolean bl) {
        boolean bl2 = this.nodeLabels;
        this.nodeLabels = bl;
        return bl2;
    }

    public boolean setShowEdgeLabels(boolean bl) {
        boolean bl2 = this.edgeLabels;
        this.edgeLabels = bl;
        return bl2;
    }

    public boolean getShowSubgraphLabels() {
        return this.subgLabels;
    }

    public boolean getShowNodeLabels() {
        return this.nodeLabels;
    }

    public boolean getShowEdgeLabels() {
        return this.edgeLabels;
    }

    public boolean isLR() {
        Attribute attribute = this.getAttribute("rankdir");
        if (attribute == null) {
            return false;
        }
        String string = attribute.getStringValue();
        if (string == null) {
            return false;
        }
        return string.equals("LR");
    }

    public void addTypeTag(int n, String string) {
        if (string == null || string.indexOf(44) >= 0) {
            throw new RuntimeException("tag value null or contains a comma (" + string + ")");
        }
        Attribute attribute = null;
        switch (n) {
            case 1: {
                attribute = this.getNodeAttribute("tag");
                break;
            }
            case 2: {
                attribute = this.getEdgeAttribute("tag");
                break;
            }
            case 4: {
                attribute = this.getLocalAttribute("tag");
            }
        }
        if (attribute == null) {
            attribute = new Attribute(n, "tag", new Hashtable());
            this.setAttribute(attribute);
            switch (n) {
                case 1: {
                    this.setNodeAttribute(attribute);
                    break;
                }
                case 2: {
                    this.setEdgeAttribute(attribute);
                    break;
                }
                case 4: {
                    this.setAttribute(attribute);
                }
            }
        }
        Hashtable hashtable = (Hashtable)attribute.getValue();
        hashtable.put(string, string);
    }

    public boolean hasTypeTag(int n, String string) {
        Attribute attribute = null;
        switch (n) {
            case 1: {
                attribute = this.getNodeAttribute("tag");
                break;
            }
            case 2: {
                attribute = this.getEdgeAttribute("tag");
                break;
            }
            case 4: {
                attribute = this.getLocalAttribute("tag");
            }
        }
        if (attribute == null) {
            return false;
        }
        Hashtable hashtable = (Hashtable)attribute.getValue();
        if (hashtable == null || hashtable.size() == 0) {
            return false;
        }
        return hashtable.containsKey(string);
    }

    public boolean hasTypeTags(int n) {
        Attribute attribute = null;
        switch (n) {
            case 1: {
                attribute = this.getNodeAttribute("tag");
                break;
            }
            case 2: {
                attribute = this.getEdgeAttribute("tag");
                break;
            }
            case 4: {
                attribute = this.getLocalAttribute("tag");
            }
        }
        if (attribute == null) {
            return false;
        }
        Hashtable hashtable = (Hashtable)attribute.getValue();
        return hashtable != null && hashtable.size() != 0;
    }

    public void removeTypeTags(int n) {
        Attribute attribute = null;
        switch (n) {
            case 1: {
                attribute = this.getNodeAttribute("tag");
                break;
            }
            case 2: {
                attribute = this.getEdgeAttribute("tag");
                break;
            }
            case 4: {
                attribute = this.getLocalAttribute("tag");
            }
        }
        if (attribute == null) {
            return;
        }
        Hashtable hashtable = (Hashtable)attribute.getValue();
        if (hashtable == null || hashtable.size() == 0) {
            return;
        }
        hashtable.clear();
    }

    public void removeTypeTag(int n, String string) {
        Attribute attribute = null;
        switch (n) {
            case 1: {
                attribute = this.getNodeAttribute("tag");
                break;
            }
            case 2: {
                attribute = this.getEdgeAttribute("tag");
                break;
            }
            case 4: {
                attribute = this.getLocalAttribute("tag");
            }
        }
        if (attribute == null) {
            return;
        }
        Hashtable hashtable = (Hashtable)attribute.getValue();
        if (hashtable == null || hashtable.size() == 0) {
            return;
        }
        hashtable.remove(string);
    }

    public int countOfLocalElements(int n) {
        int n2 = 0;
        if ((n & 1) != 0 && this.nodedict != null) {
            n2 += this.nodedict.size();
        }
        if ((n & 2) != 0 && this.edgedict != null) {
            n2 += this.edgedict.size();
        }
        if ((n & 4) != 0 && this.graphdict != null) {
            n2 += this.graphdict.size();
        }
        return n2;
    }

    public int countOfElements(int n) {
        int n2 = 0;
        if ((n & 1) != 0 && this.nodedict != null) {
            n2 += this.nodedict.size();
        }
        if ((n & 2) != 0 && this.edgedict != null) {
            n2 += this.edgedict.size();
        }
        if (this.graphdict != null) {
            if ((n & 4) != 0) {
                n2 += this.graphdict.size();
            }
            Enumeration enumeration = this.graphdict.elements();
            while (enumeration.hasMoreElements()) {
                n2 += ((Subgraph)enumeration.nextElement()).countOfElements(n);
            }
        }
        return n2;
    }

    public void removeEmptySubgraphs() {
        if (!(this.graphdict != null && this.graphdict.size() != 0 || this.nodedict != null && this.nodedict.size() != 0 || this.edgedict != null && this.edgedict.size() != 0)) {
            this.delete();
            return;
        }
        if (this.graphdict != null) {
            Enumeration enumeration = this.graphdict.elements();
            while (enumeration.hasMoreElements()) {
                ((Subgraph)enumeration.nextElement()).removeEmptySubgraphs();
            }
        }
    }

    public boolean hasEmptySubgraphs() {
        if (!(this.graphdict != null && this.graphdict.size() != 0 || this.nodedict != null && this.nodedict.size() != 0 || this.edgedict != null && this.edgedict.size() != 0)) {
            return true;
        }
        if (this.graphdict != null) {
            Enumeration enumeration = this.graphdict.elements();
            while (enumeration.hasMoreElements()) {
                if (!((Subgraph)enumeration.nextElement()).hasEmptySubgraphs()) continue;
                return true;
            }
        }
        return false;
    }

    public void clearPatchWork() {
        this.prepPatchWork(null, -1);
    }

    public void patchWork(Rectangle2D.Double double_, boolean bl, int n) {
        this.preparePatchWork(n);
        this.computePatchWork(double_ instanceof GrappaBox ? double_ : new GrappaBox(double_), bl);
        if (n == 0) {
            GraphEnumeration graphEnumeration = this.elements(4);
            while (graphEnumeration.hasMoreElements()) {
                Attribute attribute;
                Subgraph subgraph = (Subgraph)graphEnumeration.nextElement();
                if (subgraph == this || (attribute = subgraph.getAttribute("style")) == null) continue;
                String string = attribute.getStringValue();
                subgraph.setAttribute("style", string != null && string.length() > 0 ? string + ",filled(false)" : null);
            }
        } else {
            float f = this.countOfElements(4) - 2;
            float f2 = 0.0f;
            GraphEnumeration graphEnumeration = this.elements(4);
            while (graphEnumeration.hasMoreElements()) {
                Subgraph subgraph = (Subgraph)graphEnumeration.nextElement();
                if (subgraph == this) continue;
                float f3 = f2;
                f2 = f3 + 1.0f;
                subgraph.setAttribute("color", Color.getHSBColor((float)(0.05 + 0.9 * (double)(f3 / f)), 1.0f, 1.0f));
                Attribute attribute = subgraph.getAttribute("style");
                if (attribute == null) {
                    subgraph.setAttribute("style", "filled");
                    continue;
                }
                String string = attribute.getStringValue();
                subgraph.setAttribute("style", string == null || string.length() == 0 ? "filled" : string + ",filled");
            }
        }
    }

    public double preparePatchWork(int n) {
        double d = this.prepPatchWork("patch", n);
        if (n == 0) {
            this.combPatchWork();
            if (this.elPatches != null) {
                Arrays.sort(this.elPatches, 0, this.elPatches.length, this);
            }
        }
        return d;
    }

    Element[] getPatches() {
        return this.elPatches;
    }

    private void combPatchWork() {
        Element[] elementArray = this.elPatches;
        Element[] elementArray2 = this.sgPatches;
        if (elementArray2 != null && elementArray2.length > 0) {
            int n = 0;
            while (n < elementArray2.length) {
                Subgraph subgraph = (Subgraph)elementArray2[n];
                subgraph.combPatchWork();
                Element[] elementArray3 = subgraph.getPatches();
                if (elementArray3 != null && elementArray3.length > 0) {
                    if (elementArray == null || elementArray.length == 0) {
                        elementArray = elementArray3;
                    } else {
                        Element[] elementArray4 = new Element[elementArray.length + elementArray3.length];
                        System.arraycopy(elementArray, 0, elementArray4, 0, elementArray.length);
                        System.arraycopy(elementArray3, 0, elementArray4, elementArray.length, elementArray3.length);
                        elementArray = elementArray4;
                    }
                }
                ++n;
            }
        }
        this.sgPatches = null;
        this.elPatches = elementArray;
    }

    private double prepPatchWork(String string, int n) {
        Enumeration enumeration;
        int n2;
        double d = 0.0;
        Hashtable hashtable = this.graphdict;
        this.sgPatches = null;
        if (hashtable != null && hashtable.size() > 0) {
            if (string != null) {
                this.sgPatches = new Element[hashtable.size()];
            }
            n2 = 0;
            enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                Subgraph subgraph = (Subgraph)enumeration.nextElement();
                d += subgraph.prepPatchWork(string, n);
                if (string == null) continue;
                this.sgPatches[n2++] = subgraph;
            }
        }
        hashtable = this.nodedict;
        this.elPatches = null;
        if (string != null && hashtable != null && hashtable.size() > 0) {
            int n3 = 0;
            n2 = 0;
            if (n <= 0) {
                this.elPatches = new Element[hashtable.size()];
            } else if (this.sgPatches == null) {
                this.elPatches = new Element[hashtable.size()];
            } else {
                n2 = this.sgPatches.length;
                this.elPatches = new Element[n2 + hashtable.size()];
                System.arraycopy(this.sgPatches, 0, this.elPatches, 0, n2);
                this.sgPatches = null;
            }
            enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                Element element = (Element)enumeration.nextElement();
                Object object = element.getAttributeValue(string);
                if (object != null) {
                    if (object instanceof Number) {
                        element.setPatchSize(((Number)object).doubleValue());
                        d += element.getPatchSize();
                        this.elPatches[n2++] = element;
                        continue;
                    }
                    ++n3;
                    continue;
                }
                ++n3;
            }
            if (n3 > 0) {
                if (n2 == n3) {
                    this.elPatches = null;
                } else {
                    Element[] elementArray = new Element[n2 - n3];
                    System.arraycopy(this.elPatches, 0, elementArray, 0, elementArray.length);
                    this.elPatches = elementArray;
                }
            }
        }
        if (n != 0) {
            if (this.sgPatches != null) {
                Arrays.sort(this.sgPatches, 0, this.sgPatches.length, this);
            }
            if (this.elPatches != null) {
                Arrays.sort(this.elPatches, 0, this.elPatches.length, this);
            }
        }
        this.setPatchSize(d);
        return d;
    }

    double aspect(Rectangle2D.Double double_) {
        return double_.getWidth() == 0.0 ? 1.0 : double_.getHeight() / double_.getWidth();
    }

    double score(double d, double d2) {
        return d2 <= this.PATCHEDGE2 || d <= this.PATCHEDGE2 ? Double.MAX_VALUE : (d2 > d ? (d == 0.0 ? (d2 == 0.0 ? 1.0 : Double.MAX_VALUE) : d2 / d) : (d2 == 0.0 ? (d == 0.0 ? 1.0 : Double.MAX_VALUE) : d / d2));
    }

    public void computePatchWork(Rectangle2D.Double double_, boolean bl) {
        if (bl) {
            this.compSqPatchWork(double_, true);
        } else {
            this.compStdPatchWork(double_, true);
        }
    }

    private void compSqPatchWork(Rectangle2D.Double double_, boolean bl) {
        Rectangle2D.Double double_2;
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        int n;
        double d8;
        double d9;
        double d10;
        double d11;
        Element element;
        int n2;
        this.setPatch(double_);
        this.setAttribute("minsize", new GrappaSize(double_.getWidth(), double_.getHeight() + (bl ? 0.0 : 1.0)));
        double d12 = this.aspect(double_);
        double d13 = this.getPatchSize();
        GrappaBox grappaBox = bl ? new GrappaBox(double_) : new GrappaBox(double_.getX() + this.PATCHEDGE, double_.getY() + this.PATCHEDGE, double_.getWidth() - this.PATCHEDGE2, double_.getHeight() - this.PATCHEDGE2);
        double d14 = d12 > 1.0 ? grappaBox.getY() : grappaBox.getX();
        if (this.sgPatches != null) {
            n2 = 0;
            while (n2 < this.sgPatches.length) {
                element = this.sgPatches[n2];
                d11 = element.getPatchSize();
                if (n2 + 1 < this.sgPatches.length) {
                    block38: {
                        d10 = 0.0;
                        d9 = d11 / d13;
                        d8 = d12 > 1.0 ? this.score(grappaBox.getWidth(), d9 * grappaBox.getHeight()) : this.score(d9 * grappaBox.getWidth(), grappaBox.getHeight());
                        n = n2 + 1;
                        while (true) {
                            d7 = this.sgPatches[n].getPatchSize();
                            d6 = d10 + d11 + d7;
                            d5 = d6 / d13;
                            d4 = d12 > 1.0 ? this.score(grappaBox.getWidth() * d11 / d6, d5 * grappaBox.getHeight()) : this.score(d5 * grappaBox.getWidth(), grappaBox.getHeight() * d11 / d6);
                            if (!(d4 <= d8)) break;
                            d8 = d12 > 1.0 ? this.score(grappaBox.getWidth() * d7 / d6, d5 * grappaBox.getHeight()) : this.score(d5 * grappaBox.getWidth(), grappaBox.getHeight() * d7 / d6);
                            d10 += d11;
                            d11 = d7;
                            d7 = 0.0;
                            if (++n < this.sgPatches.length) {
                                continue;
                            }
                            break block38;
                            break;
                        }
                        d7 = 0.0;
                    }
                    d6 = d10 + d11 + d7;
                    d9 = d6 / d13;
                    if (d12 > 1.0) {
                        d3 = grappaBox.getX();
                        d2 = d9 * grappaBox.getHeight();
                    } else {
                        d3 = grappaBox.getY();
                        d2 = d9 * grappaBox.getWidth();
                    }
                    while (n2 < n) {
                        element = this.sgPatches[n2];
                        if (d12 > 1.0) {
                            d = grappaBox.getWidth() * element.getPatchSize() / d6;
                            double_2 = new GrappaBox(d3, d14, d, d2);
                        } else {
                            d = grappaBox.getHeight() * element.getPatchSize() / d6;
                            double_2 = new GrappaBox(d14, d3, d2, d);
                        }
                        ((Subgraph)element).compSqPatchWork(double_2, false);
                        d3 += d;
                        ++n2;
                    }
                } else {
                    d9 = d11 / d13;
                    if (d12 > 1.0) {
                        d2 = d9 * grappaBox.getHeight();
                        double_2 = new GrappaBox(grappaBox.getX(), d14, grappaBox.getWidth(), d2);
                    } else {
                        d2 = d9 * grappaBox.getWidth();
                        double_2 = new GrappaBox(d14, grappaBox.getY(), d2, grappaBox.getHeight());
                    }
                    ((Subgraph)element).compSqPatchWork(double_2, false);
                    ++n2;
                }
                d14 += d2;
            }
        }
        if (this.elPatches != null) {
            n2 = 0;
            while (n2 < this.elPatches.length) {
                String string;
                Attribute attribute;
                element = this.elPatches[n2];
                d11 = element.getPatchSize();
                if (n2 + 1 < this.elPatches.length) {
                    block39: {
                        d10 = 0.0;
                        d9 = d11 / d13;
                        d8 = d12 > 1.0 ? this.score(grappaBox.getWidth(), d9 * grappaBox.getHeight()) : this.score(d9 * grappaBox.getWidth(), grappaBox.getHeight());
                        n = n2 + 1;
                        while (true) {
                            d7 = this.elPatches[n].getPatchSize();
                            d6 = d10 + d11 + d7;
                            d5 = d6 / d13;
                            d4 = d12 > 1.0 ? this.score(grappaBox.getWidth() * d11 / d6, d5 * grappaBox.getHeight()) : this.score(d5 * grappaBox.getWidth(), grappaBox.getHeight() * d11 / d6);
                            if (!(d4 <= d8)) break;
                            d8 = d12 > 1.0 ? this.score(grappaBox.getWidth() * d7 / d6, d5 * grappaBox.getHeight()) : this.score(d5 * grappaBox.getWidth(), grappaBox.getHeight() * d7 / d6);
                            d10 += d11;
                            d11 = d7;
                            d7 = 0.0;
                            if (++n < this.elPatches.length) {
                                continue;
                            }
                            break block39;
                            break;
                        }
                        d7 = 0.0;
                    }
                    d6 = d10 + d11 + d7;
                    d9 = d6 / d13;
                    if (d12 > 1.0) {
                        d3 = grappaBox.getX();
                        d2 = d9 * grappaBox.getHeight();
                    } else {
                        d3 = grappaBox.getY();
                        d2 = d9 * grappaBox.getWidth();
                    }
                    while (n2 < n) {
                        element = this.elPatches[n2];
                        if (element instanceof Node) {
                            if (d12 > 1.0) {
                                d = grappaBox.getWidth() * element.getPatchSize() / d6;
                                element.setPatch(d3, d14, d, d2);
                            } else {
                                d = grappaBox.getHeight() * element.getPatchSize() / d6;
                                element.setPatch(d14, d3, d2, d);
                            }
                            double_2 = element.getPatch();
                            element.setAttribute("pos", new GrappaPoint(double_2.getCenterX(), -double_2.getCenterY()));
                            element.setAttribute("width", new Double(double_2.getWidth() / 72.0));
                            element.setAttribute("height", new Double(double_2.getHeight() / 72.0));
                            element.setAttribute("color", "white");
                            attribute = element.getAttribute("style");
                            if (attribute == null) {
                                element.setAttribute("style", "filled,lineColor(black)");
                            } else {
                                string = attribute.getStringValue();
                                element.setAttribute("style", string == null || string.length() == 0 ? "filled,lineColor(black)" : string + ",filled,lineColor(black)");
                            }
                        } else {
                            if (d12 > 1.0) {
                                d = grappaBox.getWidth() * element.getPatchSize() / d6;
                                double_2 = new GrappaBox(d3, d14, d, d2);
                            } else {
                                d = grappaBox.getHeight() * element.getPatchSize() / d6;
                                double_2 = new GrappaBox(d14, d3, d2, d);
                            }
                            ((Subgraph)element).compSqPatchWork(double_2, false);
                        }
                        d3 += d;
                        ++n2;
                    }
                } else {
                    d9 = d11 / d13;
                    if (element instanceof Node) {
                        if (d12 > 1.0) {
                            d2 = d9 * grappaBox.getHeight();
                            element.setPatch(grappaBox.getX(), d14, grappaBox.getWidth(), d2);
                        } else {
                            d2 = d9 * grappaBox.getWidth();
                            element.setPatch(d14, grappaBox.getY(), d2, grappaBox.getHeight());
                        }
                        double_2 = element.getPatch();
                        element.setAttribute("pos", new GrappaPoint(double_2.getCenterX(), -double_2.getCenterY()));
                        element.setAttribute("width", new Double(double_2.getWidth() / 72.0));
                        element.setAttribute("height", new Double(double_2.getHeight() / 72.0));
                        element.setAttribute("color", "white");
                        attribute = element.getAttribute("style");
                        if (attribute == null) {
                            element.setAttribute("style", "filled,lineColor(black)");
                        } else {
                            string = attribute.getStringValue();
                            element.setAttribute("style", string == null || string.length() == 0 ? "filled,lineColor(black)" : string + ",filled,lineColor(black)");
                        }
                    } else {
                        if (d12 > 1.0) {
                            d2 = d9 * grappaBox.getHeight();
                            double_2 = new GrappaBox(grappaBox.getX(), d14, grappaBox.getWidth(), d2);
                        } else {
                            d2 = d9 * grappaBox.getWidth();
                            double_2 = new GrappaBox(d14, grappaBox.getY(), d2, grappaBox.getHeight());
                        }
                        ((Subgraph)element).compSqPatchWork(double_2, false);
                    }
                    ++n2;
                }
                d14 += d2;
            }
        }
    }

    private void compStdPatchWork(Rectangle2D.Double double_, boolean bl) {
        double d;
        double d2;
        double d3;
        Element element;
        int n;
        this.setPatch(double_);
        this.setAttribute("minsize", new GrappaSize(double_.getWidth(), double_.getHeight() + (bl ? 0.0 : 1.0)));
        double d4 = this.aspect(double_);
        double d5 = this.getPatchSize();
        GrappaBox grappaBox = bl ? new GrappaBox(double_) : new GrappaBox(double_.getX() + this.PATCHEDGE, double_.getY() + this.PATCHEDGE, double_.getWidth() - this.PATCHEDGE2, double_.getHeight() - this.PATCHEDGE2);
        double d6 = d4 > 1.0 ? grappaBox.getY() : grappaBox.getX();
        if (this.sgPatches != null) {
            n = 0;
            while (n < this.sgPatches.length) {
                element = this.sgPatches[n];
                d3 = element.getPatchSize();
                d2 = d3 / d5;
                if (d4 > 1.0) {
                    d = d2 * grappaBox.getHeight();
                    ((Subgraph)element).compStdPatchWork(new GrappaBox(grappaBox.getX(), d6, grappaBox.getWidth(), d), false);
                } else {
                    d = d2 * grappaBox.getWidth();
                    ((Subgraph)element).compStdPatchWork(new GrappaBox(d6, grappaBox.getY(), d, grappaBox.getHeight()), false);
                }
                d6 += d;
                ++n;
            }
        }
        if (this.elPatches != null) {
            n = 0;
            while (n < this.elPatches.length) {
                element = this.elPatches[n];
                d3 = element.getPatchSize();
                d2 = d3 / d5;
                if (element instanceof Node) {
                    if (d4 > 1.0) {
                        d = d2 * grappaBox.getHeight();
                        element.setPatch(grappaBox.getX(), d6, grappaBox.getWidth(), d);
                    } else {
                        d = d2 * grappaBox.getWidth();
                        element.setPatch(d6, grappaBox.getY(), d, grappaBox.getHeight());
                    }
                    Rectangle2D.Double double_2 = element.getPatch();
                    element.setAttribute("pos", new GrappaPoint(double_2.getCenterX(), -double_2.getCenterY()));
                    element.setAttribute("width", new Double(double_2.getWidth() / 72.0));
                    element.setAttribute("height", new Double(double_2.getHeight() / 72.0));
                    element.setAttribute("color", "white");
                    Attribute attribute = element.getAttribute("style");
                    if (attribute == null) {
                        element.setAttribute("style", "filled,lineColor(black)");
                    } else {
                        String string = attribute.getStringValue();
                        element.setAttribute("style", string == null || string.length() == 0 ? "filled,lineColor(black)" : string + ",filled,lineColor(black)");
                    }
                } else if (d4 > 1.0) {
                    d = d2 * grappaBox.getHeight();
                    ((Subgraph)element).compStdPatchWork(new GrappaBox(grappaBox.getX(), d6, grappaBox.getWidth(), d), false);
                } else {
                    d = d2 * grappaBox.getWidth();
                    ((Subgraph)element).compStdPatchWork(new GrappaBox(d6, grappaBox.getY(), d, grappaBox.getHeight()), false);
                }
                d6 += d;
                ++n;
            }
        }
    }

    public int compare(Object object, Object object2) {
        if (object instanceof Element) {
            if (object2 instanceof Element) {
                double d = ((Element)object2).getPatchSize() - ((Element)object).getPatchSize();
                return d < 0.0 ? -1 : (d > 0.0 ? 1 : 0);
            }
            return 0;
        }
        return 0;
    }

    public boolean equals(Object object) {
        return false;
    }

    public Enumeration nodeElements() {
        if (this.nodedict == null) {
            return Grappa.emptyEnumeration.elements();
        }
        return this.nodedict.elements();
    }

    public Enumeration edgeElements() {
        if (this.edgedict == null) {
            return Grappa.emptyEnumeration.elements();
        }
        return this.edgedict.elements();
    }

    public Enumeration subgraphElements() {
        if (this.graphdict == null) {
            return Grappa.emptyEnumeration.elements();
        }
        return this.graphdict.elements();
    }

    public GraphEnumeration elements(int n) {
        return new Enumerator(n);
    }

    public GraphEnumeration elements() {
        return new Enumerator(7);
    }

    public Vector vectorOfElements(int n) {
        Vector vector = new Vector();
        int n2 = 0;
        Enumeration enumeration = null;
        if ((n & 1) != 0 && this.nodedict != null) {
            vector.ensureCapacity(n2 += this.nodedict.size());
            enumeration = this.nodedict.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        if ((n & 2) != 0 && this.edgedict != null) {
            vector.ensureCapacity(n2 += this.edgedict.size());
            enumeration = this.edgedict.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        if (this.graphdict != null) {
            if ((n & 4) != 0) {
                vector.ensureCapacity(n2 += this.graphdict.size());
            }
            enumeration = this.graphdict.elements();
            while (enumeration.hasMoreElements()) {
                ((Subgraph)enumeration.nextElement()).recurseVectorOfElements(n, vector, n2);
            }
        }
        return vector;
    }

    void recurseVectorOfElements(int n, Vector vector, int n2) {
        if ((n & 4) != 0) {
            vector.addElement(this);
        }
        Enumeration enumeration = null;
        if ((n & 1) != 0 && this.nodedict != null) {
            vector.ensureCapacity(n2 += this.nodedict.size());
            enumeration = this.nodedict.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        if ((n & 2) != 0 && this.edgedict != null) {
            vector.ensureCapacity(n2 += this.edgedict.size());
            enumeration = this.edgedict.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        if (this.graphdict != null) {
            if ((n & 4) != 0) {
                vector.ensureCapacity(n2 += this.graphdict.size());
            }
            enumeration = this.graphdict.elements();
            while (enumeration.hasMoreElements()) {
                ((Subgraph)enumeration.nextElement()).recurseVectorOfElements(n, vector, n2);
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Enumerator
    implements GraphEnumeration {
        private Subgraph root = null;
        private int types = 0;
        private Enumeration enum = null;
        private GraphEnumeration subEnum = null;
        private Element elem = null;
        private int dictType = 0;

        Enumerator(int n) {
            this.root = Subgraph.this;
            this.types = n;
            this.elem = (this.types & 4) != 0 ? this.root : null;
            this.enum = Subgraph.this.subgraphElements();
            if (this.enum.hasMoreElements()) {
                this.dictType = 4;
                while (this.enum.hasMoreElements()) {
                    this.subEnum = (Subgraph)this.enum.nextElement().new Enumerator(this.types);
                    if (!this.subEnum.hasMoreElements()) continue;
                    if (this.elem == null) {
                        this.elem = (Element)this.subEnum.nextElement();
                    }
                    break;
                }
            } else {
                this.dictType = 0;
                this.enum = null;
                this.subEnum = null;
            }
            if (this.enum == null) {
                if ((this.types & 1) != 0 && (this.enum = Subgraph.this.nodeElements()).hasMoreElements()) {
                    this.dictType = 1;
                    if (this.elem == null) {
                        this.elem = (Element)this.enum.nextElement();
                    }
                } else if ((this.types & 2) != 0 && (this.enum = Subgraph.this.edgeElements()).hasMoreElements()) {
                    this.dictType = 2;
                    if (this.elem == null) {
                        this.elem = (Element)this.enum.nextElement();
                    }
                } else {
                    this.enum = null;
                }
            }
        }

        public boolean hasMoreElements() {
            return this.elem != null;
        }

        public Object nextElement() {
            if (this.elem == null) {
                throw new NoSuchElementException("Subgraph$Enumerator");
            }
            Element element = this.elem;
            if (this.subEnum != null && this.subEnum.hasMoreElements()) {
                this.elem = (Element)this.subEnum.nextElement();
            } else if (this.enum != null && this.enum.hasMoreElements()) {
                do {
                    this.elem = (Element)this.enum.nextElement();
                    if (!this.elem.isSubgraph()) break;
                    this.subEnum = (Subgraph)this.elem.new Enumerator(this.getEnumerationTypes());
                    if (this.subEnum.hasMoreElements()) {
                        this.elem = (Element)this.subEnum.nextElement();
                        break;
                    }
                    this.elem = null;
                } while (this.enum.hasMoreElements());
            } else {
                this.elem = null;
            }
            if (this.elem == null && this.dictType != 0) {
                if (this.dictType == 4) {
                    if ((this.getEnumerationTypes() & 1) != 0 && (this.enum = Subgraph.this.nodeElements()).hasMoreElements()) {
                        this.dictType = 1;
                        this.elem = (Element)this.enum.nextElement();
                    } else if ((this.getEnumerationTypes() & 2) != 0 && (this.enum = Subgraph.this.edgeElements()).hasMoreElements()) {
                        this.dictType = 2;
                        this.elem = (Element)this.enum.nextElement();
                    } else {
                        this.dictType = 0;
                        this.enum = null;
                    }
                } else if (this.dictType == 1) {
                    if ((this.getEnumerationTypes() & 2) != 0 && (this.enum = Subgraph.this.edgeElements()).hasMoreElements()) {
                        this.dictType = 2;
                        this.elem = (Element)this.enum.nextElement();
                    } else {
                        this.dictType = 0;
                        this.enum = null;
                    }
                } else {
                    this.dictType = 0;
                    this.enum = null;
                }
            }
            return element;
        }

        public Element nextGraphElement() {
            return (Element)this.nextElement();
        }

        public Subgraph getSubgraphRoot() {
            return this.root;
        }

        public int getEnumerationTypes() {
            return this.types;
        }
    }
}

