/* BEGIN LICENSE BLOCK
 * Version: CMPL 1.1
 *
 * The contents of this file are subject to the Cisco-style Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file except
 * in compliance with the License.  You may obtain a copy of the License
 * at www.eclipse-clp.org/license.
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See
 * the License for the specific language governing rights and limitations
 * under the License. 
 * 
 * The Original Code is  The ECLiPSe Constraint Logic Programming System. 
 * The Initial Developer of the Original Code is  Cisco Systems, Inc. 
 * Portions created by the Initial Developer are
 * Copyright (C) 1989-2006 Cisco Systems, Inc.  All Rights Reserved.
 * 
 * Contributor(s): 
 * 
 * END LICENSE BLOCK */

/*
 * VERSION	$Id: opcode.h,v 1.4 2008/07/10 01:08:47 jschimpf Exp $
 */

/*
 * IDENTIFICATION		opcode.h
 *
 * DESCRIPTION	
 *	
 *	Here are defined the opcode values for the C emulator.
 *
 *	Note that the order of Write_, Read_ and Read_matched_ is significant.
 *
 * CONTENTS:
 *
 *
 * REVISION HISTORY:
 *
 * AUTHOR	VERSION	 DATE	REASON
 */

#ifdef THREADED

extern vmcode op_addr[];
#define Op_Value(x)	op_addr[x]
#define Get_Int_Opcode(code)	((vmcode) get_int_opcode(code))

#else /* THREADED */

#define Op_Value(x)	(x)
#define Get_Int_Opcode(code)	*(code)

#endif /* THREADED */

#define SameCode(x,i)		((x) == Op_Value(i))


/*
 * To have consecutive blocks of real instructions, we must set the
 * block beginnings properly.  Currently only one block.
 */
#define BLOCK1					0


/*
 * Inst_Error must be the last instruction of this file.
 * NUMBER_OP is the number of instructions, eventually set by an extension.
 */
#define Code_end				(BLOCK1 + 0)/*PSEUDO,must be 0*/
#define MoveAM					(BLOCK1 + 1)
#define MoveAMAM				(BLOCK1 + 2)
#define MoveAML					(BLOCK1 + 3)
#define MoveLAM					(BLOCK1 + 4)
#define MoveTMAM				(BLOCK1 + 5)
#define Get_variableNAML			(BLOCK1 + 6)
#define Get_valueAMAM				(BLOCK1 + 7)
#define Get_valueAML				(BLOCK1 + 8)
#define Get_valueAMTM				(BLOCK1 + 9)
#define Get_nilAM				(BLOCK1 + 10)
#define Get_integerAM				(BLOCK1 + 11)
#define Get_floatAM				(BLOCK1 + 12)
#define Get_atomAM				(BLOCK1 + 13)
#define Get_stringAM				(BLOCK1 + 14)
#define Get_listAM				(BLOCK1 + 15)
#define Get_structureAM				(BLOCK1 + 16)
#define In_get_nilAM				(BLOCK1 + 17)
#define In_get_integerAM			(BLOCK1 + 18)
#define In_get_floatAM				(BLOCK1 + 19)
#define In_get_atomAM				(BLOCK1 + 20)
#define In_get_stringAM				(BLOCK1 + 21)
#define In_get_listAM				(BLOCK1 + 22)
#define In_get_structureAM			(BLOCK1 + 23)
#define Out_get_nilAM				(BLOCK1 + 24)
#define Out_get_integerAM			(BLOCK1 + 25)
#define Out_get_floatAM				(BLOCK1 + 26)
#define Out_get_atomAM				(BLOCK1 + 27)
#define Out_get_stringAM			(BLOCK1 + 28)
#define Out_get_listAM				(BLOCK1 + 29)
#define Out_get_structureAM			(BLOCK1 + 30)
#define Get_list_argumentsAM			(BLOCK1 + 31)
#define Get_structure_argumentsAM		(BLOCK1 + 32)
/* The Write and Read instructions must be in the following order:
 *	Write_*
 *	Read_*
 *	Read_matched_*
 *	Write_local_*
 */
#define Write_void				(BLOCK1 + 33)
#define Read_void				(BLOCK1 + 34)
#define Write_variable				(BLOCK1 + 35)
#define Read_variable				(BLOCK1 + 36)
#define Write_variableAM			(BLOCK1 + 37)
#define Read_variableAM				(BLOCK1 + 38)
#define Write_variableNL			(BLOCK1 + 39)
#define Read_variableNL				(BLOCK1 + 40)
#define Write_variableL				(BLOCK1 + 41)
#define Read_variableL				(BLOCK1 + 42)
#define Write_valueAM				(BLOCK1 + 43)
#define Read_valueAM				(BLOCK1 + 44)
#define Read_matched_valueAM                    (BLOCK1 + 45)
#define Write_local_valueAM			(BLOCK1 + 46)
#define Write_valueL				(BLOCK1 + 47)
#define Read_valueL				(BLOCK1 + 48)
#define Read_matched_valueL                     (BLOCK1 + 49)
#define Write_local_valueL			(BLOCK1 + 50)
#define Write_valueTM				(BLOCK1 + 51)
#define Read_valueTM				(BLOCK1 + 52)
#define Read_matched_valueTM                    (BLOCK1 + 53)
#define Write_local_valueTM			(BLOCK1 + 54)
#define Write_nil				(BLOCK1 + 55)
#define Read_nil				(BLOCK1 + 56)
#define Write_integer				(BLOCK1 + 57)
#define Read_integer				(BLOCK1 + 58)
#define Write_float				(BLOCK1 + 59)
#define Read_float				(BLOCK1 + 60)
#define Write_did				(BLOCK1 + 61)
#define Read_atom				(BLOCK1 + 62)
#define Write_string				(BLOCK1 + 63)
#define Read_string				(BLOCK1 + 64)
#define Write_list				(BLOCK1 + 65)
#define Write_structure				(BLOCK1 + 66)
#define Read_list				(BLOCK1 + 67)
#define Read_listTM				(BLOCK1 + 68)
#define Read_next_listTM			(BLOCK1 + 69)
#define Read_last_list				(BLOCK1 + 70)
#define Read_structure				(BLOCK1 + 71)
#define Read_structureTM			(BLOCK1 + 72)
#define Read_next_structureTM			(BLOCK1 + 73)
#define Read_last_structure			(BLOCK1 + 74)
#define Push_void				(BLOCK1 + 75)
#define Push_variableAM				(BLOCK1 + 76)
#define Push_variableL				(BLOCK1 + 77)
#define Push_variable				(BLOCK1 + 78)
#define Push_valueAM				(BLOCK1 + 79)
#define Push_valueL				(BLOCK1 + 80)
#define Push_valueTM				(BLOCK1 + 81)
#define Push_local_valueAM			(BLOCK1 + 82)
#define Push_local_valueL			(BLOCK1 + 83)
#define Push_local_valueTM			(BLOCK1 + 84)
#define Push_nil				(BLOCK1 + 85)
#define Push_integer				(BLOCK1 + 86)
#define Push_float				(BLOCK1 + 87)
#define Push_init_variableL			(BLOCK1 + 88)
#define Push_string				(BLOCK1 + 89)
#define Push_list				(BLOCK1 + 90)
#define Push_structure				(BLOCK1 + 91)
#define Bounce					(BLOCK1 + 92)
#define First					(BLOCK1 + 93)
#define NextTM					(BLOCK1 + 94)
#define ModeTM					(BLOCK1 + 95)
#define NextTMlab				(BLOCK1 + 96)
#define ModeTMlab				(BLOCK1 + 97)
#define Put_variableAML				(BLOCK1 + 98)
#define Put_variableAM				(BLOCK1 + 99)
#define Put_unsafe_valueAML			(BLOCK1 + 100)
#define Put_nilAM				(BLOCK1 + 101)
#define Put_integerAM				(BLOCK1 + 102)
#define Put_floatAM				(BLOCK1 + 103)
#define Put_atomAM				(BLOCK1 + 104)
#define Put_stringAM				(BLOCK1 + 105)
#define Put_listAM				(BLOCK1 + 106)
#define Put_structureAM				(BLOCK1 + 107)
#define Puts_variable				(BLOCK1 + 108)
#define Puts_variableL				(BLOCK1 + 109)
#define Puts_valueAM				(BLOCK1 + 110)
#define Puts_valueL				(BLOCK1 + 111)
#define Puts_valueTM				(BLOCK1 + 112)
#define Puts_nil				(BLOCK1 + 113)
#define Puts_integer				(BLOCK1 + 114)
#define Puts_float				(BLOCK1 + 115)
#define Puts_atom				(BLOCK1 + 116)
#define Puts_string				(BLOCK1 + 117)
#define Puts_list				(BLOCK1 + 118)
#define Puts_structure				(BLOCK1 + 119)
#define Integer_switchAM			(BLOCK1 + 120)
#define Atom_switchAM				(BLOCK1 + 121)
#define List_switchAM				(BLOCK1 + 122)
#define Functor_switchAM			(BLOCK1 + 123)
#define Switch_on_typeAM			(BLOCK1 + 124)
#define Atom_switchL				(BLOCK1 + 125)
#define Functor_switchL				(BLOCK1 + 126)
#define Integer_switchL				(BLOCK1 + 127)
#define Try_me_else				(BLOCK1 + 128)
#define Try					(BLOCK1 + 129)
#define Trylab					(BLOCK1 + 130)
#define Retry_me_else				(BLOCK1 + 131)
#define Retry					(BLOCK1 + 132)
#define Retrylab				(BLOCK1 + 133)
#define Trust_me				(BLOCK1 + 134)
#define Trust					(BLOCK1 + 135)
#define Allocate				(BLOCK1 + 136)
#define Space					(BLOCK1 + 137)
#define Initialize				(BLOCK1 + 138)
#define Branch					(BLOCK1 + 139)
#define CallA					(BLOCK1 + 140) /* Call etc.  */
#define CallP					(BLOCK1 + 141) /* must stay  */
#define CallfA					(BLOCK1 + 142) /* together   */
#define CallfP					(BLOCK1 + 143) /* (peephole) */
#define ChainA					(BLOCK1 + 144)
#define ChainP					(BLOCK1 + 145)
#define ChaincA					(BLOCK1 + 146)
#define ChaincP					(BLOCK1 + 147)
#define ChaindA					(BLOCK1 + 148)
#define ChaindP					(BLOCK1 + 149)
#define JmpA					(BLOCK1 + 150)
#define JmpP					(BLOCK1 + 151)
#define JmpdA					(BLOCK1 + 152)
#define JmpdP					(BLOCK1 + 153)
#define Exit					(BLOCK1 + 154)
#define Exitd					(BLOCK1 + 155)
#define Exitc					(BLOCK1 + 156)
#define Ret					(BLOCK1 + 157)
#define Retd					(BLOCK1 + 158)
#define Retn					(BLOCK1 + 159)
#define Savecut					(BLOCK1 + 160)
#define Neckcut					(BLOCK1 + 161)
#define Cut					(BLOCK1 + 162)
#define Failure					(BLOCK1 + 163)
#define Continue_after_event			(BLOCK1 + 164)
#define Continue_after_event_debug		(BLOCK1 + 165)
#define Escape					(BLOCK1 + 166)
#define List_switchL				(BLOCK1 + 167)
#define External				(BLOCK1 + 168)
#define Puts_proc				(BLOCK1 + 169)
#define Debug_call_simple			(BLOCK1 + 170)
#define Gc					(BLOCK1 + 171)
#define Debug_exit_simple			(BLOCK1 + 172)
#define Refail					(BLOCK1 + 173)
#define Exit_emulator				(BLOCK1 + 174)
#define Debug_exit				(BLOCK1 + 175)
#define Get_matched_valueAML                    (BLOCK1 + 176)
#define Nop					(BLOCK1 + 177)
#define Ress					(BLOCK1 + 178)
#define Deallocate				(BLOCK1 + 179)
#define Get_constantAM				(BLOCK1 + 180)
#define In_get_constantAM			(BLOCK1 + 181)
#define Out_get_constantAM			(BLOCK1 + 182)
#define Read_constant				(BLOCK1 + 183)
#define Write_constant				(BLOCK1 + 184)
#define Push_constant				(BLOCK1 + 185)
#define Put_constantAM				(BLOCK1 + 186)
#define Puts_constant				(BLOCK1 + 187)
#define Get_matched_valueAMAM                   (BLOCK1 + 188)
#define Get_matched_valueAMTM                   (BLOCK1 + 189)
#define Debug_exit_simple_args                 	(BLOCK1 + 190)
#define Put_unsafe_valueAMTM                   	(BLOCK1 + 191)
#define Branchs		                   	(BLOCK1 + 192)
#define Gc_test					(BLOCK1 + 193)
#define Gc_testA				(BLOCK1 + 194)
#define Try_me_dynamic				(BLOCK1 + 195)
#define Retry_me_dynamic			(BLOCK1 + 196)
#define Read_test_var				(BLOCK1 + 197)
#define Retry_me_inline				(BLOCK1 + 198)
#define Trust_me_inline				(BLOCK1 + 199)
#define Set_bp					(BLOCK1 + 200)
#define Restore_bp				(BLOCK1 + 201)
#define New_bp					(BLOCK1 + 202)
#define SavecutL				(BLOCK1 + 203)
#define CutL					(BLOCK1 + 204)
#define JmpdAs					(BLOCK1 + 205)
#define Switch_on_typeL				(BLOCK1 + 206)
#define Metacall				(BLOCK1 + 207)
#define Fastcall				(BLOCK1 + 208)
#define Integer_range_switchL			(BLOCK1 + 209)
#define Suspension_call				(BLOCK1 + 210)
#define Throw					(BLOCK1 + 211)
#define SavecutAM				(BLOCK1 + 212)
#define Cut_single				(BLOCK1 + 213)
#define Initialize_named			(BLOCK1 + 214)
#define Write_named_void			(BLOCK1 + 215)
#define Write_named_variable			(BLOCK1 + 216)
#define Write_named_variableAM			(BLOCK1 + 217)
#define Write_named_variableL			(BLOCK1 + 218)
#define Write_named_variableNL			(BLOCK1 + 219)
#define Put_referenceAM				(BLOCK1 + 220)
#define Put_referenceAML			(BLOCK1 + 221)
#define Push_self_reference			(BLOCK1 + 222)
#define Push_void_reference			(BLOCK1 + 223)
#define Push_reference				(BLOCK1 + 224)
#define Push_referenceAM			(BLOCK1 + 225)
#define Push_referenceL				(BLOCK1 + 226)
#define Puts_reference				(BLOCK1 + 227)
#define Puts_referenceL				(BLOCK1 + 228)
#define Occur_check_next			(BLOCK1 + 229)
#define SoftcutL				(BLOCK1 + 230)
#define Dfid_testL				(BLOCK1 + 231)
#define Dfid_test				(BLOCK1 + 232)
#define Depth					(BLOCK1 + 233)
#define Meta_jmpA				(BLOCK1 + 234)
#define Undefined				(BLOCK1 + 235)
#define Label					(BLOCK1 + 236) /* PSEUDO */
#define Comment					(BLOCK1 + 237) /* PSEUDO */
#define Reserve					(BLOCK1 + 238) /* PSEUDO */
#define Get_metaAM				(BLOCK1 + 239)
#define In_get_metaAM				(BLOCK1 + 240)
#define Write_meta				(BLOCK1 + 241)
#define Match_meta				(BLOCK1 + 242)
#define Match_next_metaTM			(BLOCK1 + 243)
#define Match_metaTM				(BLOCK1 + 244)
#define Match_last_meta				(BLOCK1 + 245)
#define Read_meta				(BLOCK1 + 246)
#define Read_next_metaTM			(BLOCK1 + 247)
#define Read_metaTM				(BLOCK1 + 248)
#define Read_last_meta				(BLOCK1 + 249)
#define Continue_after_exception		(BLOCK1 + 250)
#define CutAM					(BLOCK1 + 251)
#define Catch					(BLOCK1 + 252)
#define Res					(BLOCK1 + 253)
#define Handler_call				(BLOCK1 + 254)
#define Retd_nowake				(BLOCK1 + 255)
#define Push_init_referenceL			(BLOCK1 + 256)
#define Exitd_nowake				(BLOCK1 + 257)
#define Meta_jmp				(BLOCK1 + 258)
#define Suspension_jmp				(BLOCK1 + 259)
#define Explicit_jmp				(BLOCK1 + 260)
#define Read_referenceNL			(BLOCK1 + 261)
#define Read_referenceL				(BLOCK1 + 262)
#define Read_referenceAM			(BLOCK1 + 263)
#define Read_reference				(BLOCK1 + 264)
#define Read_voidN				(BLOCK1 + 265)
#define Integer_range_switchAM			(BLOCK1 + 266)
#define Puts_valueG				(BLOCK1 + 267)
#define Push_valueG				(BLOCK1 + 268)
#define GuardL					(BLOCK1 + 269)
#define Try_parallel				(BLOCK1 + 270)
#define Retry_seq				(BLOCK1 + 271)
#define Fail_clause				(BLOCK1 + 272)
#define Try_clause				(BLOCK1 + 273)
#define Read_attribute				(BLOCK1 + 274)
#define Wake_init				(BLOCK1 + 275)
#define Wake					(BLOCK1 + 276)
#define Ret_nowake				(BLOCK1 + 277)
#define Neckcut_par				(BLOCK1 + 278)
#define ExtCall					(BLOCK1 + 279)
#define External0				(BLOCK1 + 280)
#define External1				(BLOCK1 + 281)
#define External2				(BLOCK1 + 282)
#define External3				(BLOCK1 + 283)
#define Clause					(BLOCK1 + 284)
#define Put_global_variableAML			(BLOCK1 + 285)
#define Put_global_variableL			(BLOCK1 + 286)
#define Put_global_variableAM			(BLOCK1 + 287)
#define MoveLL					(BLOCK1 + 288)
#define Get_valueLL				(BLOCK1 + 289)
#define Escapef					(BLOCK1 + 290)
#define BI_Exit					(BLOCK1 + 291)
#define BI_Bignum				(BLOCK1 + 292)
#define BI_Callable				(BLOCK1 + 293)
#define BI_CutToStamp				(BLOCK1 + 294)
#define BI_SetBipError				(BLOCK1 + 295)
#define BI_GetBipError				(BLOCK1 + 296)
#define BI_Free					(BLOCK1 + 297)
#define BI_Var					(BLOCK1 + 298)
#define BI_NonVar				(BLOCK1 + 299)
#define BI_Atom					(BLOCK1 + 300)
#define BI_Integer				(BLOCK1 + 301)
#define BI_Float				(BLOCK1 + 302)
#define BI_Breal				(BLOCK1 + 303)
#define BI_Real					(BLOCK1 + 304)
#define BI_Rational				(BLOCK1 + 305)
#define BI_String				(BLOCK1 + 306)
#define BI_Number				(BLOCK1 + 307)
#define BI_Atomic				(BLOCK1 + 308)
#define BI_Compound				(BLOCK1 + 309)
#define BI_Meta					(BLOCK1 + 310)
#define BI_IsSuspension				(BLOCK1 + 311)
#define BI_IsHandle				(BLOCK1 + 312)
#define BI_IsEvent				(BLOCK1 + 313)
#define BI_IsList				(BLOCK1 + 314)
#define BI_Identical				(BLOCK1 + 315)
#define BI_NotIdentical				(BLOCK1 + 316)
#define BI_Inequality				(BLOCK1 + 317)
#define BI_NotIdentList				(BLOCK1 + 318)
#define BI_ContDebug				(BLOCK1 + 319)
#define BI_Minus				(BLOCK1 + 320)
#define BI_Addi					(BLOCK1 + 321)
#define BI_Add					(BLOCK1 + 322)
#define BI_Sub					(BLOCK1 + 323)
#define BI_Mul					(BLOCK1 + 324)
#define BI_Quot					(BLOCK1 + 325)
#define BI_Div					(BLOCK1 + 326)
#define BI_Rem					(BLOCK1 + 327)
#define BI_FloorDiv				(BLOCK1 + 328)
#define BI_FloorRem				(BLOCK1 + 329)
#define BI_And					(BLOCK1 + 330)
#define BI_Or					(BLOCK1 + 331)
#define BI_Xor					(BLOCK1 + 332)
#define BI_Bitnot				(BLOCK1 + 333)
#define BI_Lt					(BLOCK1 + 334)
#define BI_Le					(BLOCK1 + 335)
#define BI_Gt					(BLOCK1 + 336)
#define BI_Ge					(BLOCK1 + 337)
#define BI_Eq					(BLOCK1 + 338)
#define BI_Ne					(BLOCK1 + 339)
#define BI_Arg					(BLOCK1 + 340)
#define BI_MakeSuspension			(BLOCK1 + 341)
#define Debug_call				(BLOCK1 + 342)
#define Retry_inline				(BLOCK1 + 343)
#define Trust_inline				(BLOCK1 + 344)
#define Put_named_variableAM			(BLOCK1 + 345)
#define Put_named_variableL			(BLOCK1 + 346)
#define Put_named_variableAML			(BLOCK1 + 347)
#define Call_dynamic				(BLOCK1 + 348)
#define Write_voidN		       		(BLOCK1 + 349)
#define Push_voidN		       		(BLOCK1 + 350)
#define MoveNLAM				(BLOCK1 + 351)
#define MoveNAML				(BLOCK1 + 352)
#define Move2LAM				(BLOCK1 + 353)
#define Move3LAM				(BLOCK1 + 354)
#define Move2AML				(BLOCK1 + 355)
#define Move3AML				(BLOCK1 + 356)
#define Move2AMAM				(BLOCK1 + 357)
#define Move3AMAM				(BLOCK1 + 358)
#define Move2LL					(BLOCK1 + 359)
#define Move3LL					(BLOCK1 + 360)
#define SwapAMAM				(BLOCK1 + 361)
#define ShiftAMAMAM				(BLOCK1 + 362)
#define ShiftAMAMAMAM				(BLOCK1 + 363)
#define ShiftAMAMAMAMAM				(BLOCK1 + 364)
#define Read_variable2AML			(BLOCK1 + 365)
#define Read_variable2AM			(BLOCK1 + 366)
#define Read_variable2L				(BLOCK1 + 367)
#define Write_variable2AML			(BLOCK1 + 368)
#define Write_variable2AM			(BLOCK1 + 369)
#define Write_variable2L       			(BLOCK1 + 370)
#define Write_local_value2AM       	       	(BLOCK1 + 371)
#define Write_local_value2L       	        (BLOCK1 + 372)
#define Push_local_value2AM       	       	(BLOCK1 + 373)
#define Push_local_value2L       	        (BLOCK1 + 374)
#define Put_global_variable2AML                 (BLOCK1 + 375)
#define Put_variable2AM				(BLOCK1 + 376)
#define Get_atom2AM				(BLOCK1 + 377)
#define Get_integer2AM				(BLOCK1 + 378)
#define Get_atomintegerAMAM			(BLOCK1 + 379)
#define Write_first_structure			(BLOCK1 + 380)
#define Write_first_list			(BLOCK1 + 381)
#define Write_next_structureTM			(BLOCK1 + 382)
#define Write_next_listTM			(BLOCK1 + 383)
#define Write_next_structureTMlab		(BLOCK1 + 384)
#define Write_next_listTMlab			(BLOCK1 + 385)
#define Read_atom2				(BLOCK1 + 386)
#define Read_integer2				(BLOCK1 + 387)
#define Read_integeratom			(BLOCK1 + 388)
#define Read_atominteger			(BLOCK1 + 389)
#define Write_did2				(BLOCK1 + 390)
#define Write_integer2				(BLOCK1 + 391)
#define Write_integerdid			(BLOCK1 + 392)
#define Write_didinteger			(BLOCK1 + 393)
#define MoveLAMCallfA                           (BLOCK1 + 394)
#define MoveLAMCallfP                           (BLOCK1 + 395)
#define MoveLAMChainA                           (BLOCK1 + 396)
#define MoveLAMChainP                           (BLOCK1 + 397)
#define Put_global_variableAMLCallfA            (BLOCK1 + 398)
#define Put_global_variableAMLCallfP            (BLOCK1 + 399)
#define RotAMAMAM				(BLOCK1 + 400)
#define BI_Arity				(BLOCK1 + 401)
#define Exits					(BLOCK1 + 402)
#define CutAMN					(BLOCK1 + 403)
#define Put_moduleAM				(BLOCK1 + 404)

/*
 * Insert new instructions here.  Don't forget to update the following files:
 * names.h emu_op_addr.h printam.c asm.pl
 */

#define Inst_Error				(BLOCK1 + 405)
#define NUMBER_OP				(Inst_Error + 1)

