/* BEGIN LICENSE BLOCK
 * Version: CMPL 1.1
 *
 * The contents of this file are subject to the Cisco-style Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file except
 * in compliance with the License.  You may obtain a copy of the License
 * at www.eclipse-clp.org/license.
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See
 * the License for the specific language governing rights and limitations
 * under the License. 
 * 
 * The Original Code is  The ECLiPSe Constraint Logic Programming System. 
 * The Initial Developer of the Original Code is  Cisco Systems, Inc. 
 * Portions created by the Initial Developer are
 * Copyright (C) 1999-2006 Cisco Systems, Inc.  All Rights Reserved.
 * 
 * Contributor(s): Joachim Schimpf and Kish Shen , IC-Parc
 * 
 * END LICENSE BLOCK */
/*
 * ECLiPSe / CPLEX interface
 *
 * System:	ECLiPSe Constraint Logic Programming System
 * Author/s:	Joachim Schimpf, IC-Parc
 * Version:	$Id: eplex_params.h,v 1.4.2.2 2010/03/31 04:22:00 jschimpf Exp $
 *
 */

/*

This file defines a table params[] which maps the symbolic names
of the optimizer flags to the internal numbers. The set of flags
and the numbers differ in each version and between optimizers,
therefore this file has to be updated for every new release
of CPLEX/XPRESS etc.

For a new version do the following:

- CPLEX: grep the CPX_PARAM_ lines out of cplex.h
  ignore the aliases for old names in ifndef CPLEX_MODERN
  ignore the boundary definitions CPX_PARAM_ALL_MIN/MAX
- XPRESS: grep the N_ lines out of xpresso.h (only the control variable ones)
- convert the lines into the table entries
  (with :% to do global replacement in vi)
  CPLEX:
    s/^#define[	 ]CPX_PARAM_\([^ ]*\).*$/{"\L\1\E", CPX_PARAM_\1, 0},/

  XPRESS pre 13:
    s/^#define N_\([^ ]*\).*$/{"\L\1\E", N_\1, 0},/

  XPRESS 13+:
    s/^#define XPRS_\([^ ]*\).*$/{"\L\1\E", XPRS_\1, 0},/

- mark the int params with 0, the doubles with 1, the strings with 2
- count the lines and define NUMPARAMS accordingly!
- add the new section within the proper #if's

*/


/* The number of version-independent aliases, see end of file */

#ifdef CPLEX
#define NUMALIASES 44
#endif
#ifdef XPRESS
#define NUMALIASES 13
#endif
#ifdef COIN
#define NUMALIASES 2
#endif

/*
 * The version-dependent definition of params[]
 */


#if CPLEX==7 && (CPLEXMINOR>=1)

#define NUMPARAMS 129
static struct param_desc params[NUMPARAMS+NUMALIASES] = {
{"advind", CPX_PARAM_ADVIND, 0},
{"aggfill", CPX_PARAM_AGGFILL, 0},
{"aggind", CPX_PARAM_AGGIND, 0},
{"basinterval", CPX_PARAM_BASINTERVAL, 0},
{"cfilemul", CPX_PARAM_CFILEMUL, 0},
{"clocktype", CPX_PARAM_CLOCKTYPE, 0},
{"craind", CPX_PARAM_CRAIND, 0},
{"depind", CPX_PARAM_DEPIND, 0},
{"dpriind", CPX_PARAM_DPRIIND, 0},
{"pricelim", CPX_PARAM_PRICELIM, 0},
{"rimreadlim", CPX_PARAM_RIMREADLIM, 0},
{"rimnzreadlim", CPX_PARAM_RIMNZREADLIM, 0},
{"epmrk", CPX_PARAM_EPMRK, 1},
{"epopt", CPX_PARAM_EPOPT, 1},
{"epper", CPX_PARAM_EPPER, 1},
{"eprhs", CPX_PARAM_EPRHS, 1},
{"fastmip", CPX_PARAM_FASTMIP, 0},
{"iisind", CPX_PARAM_IISIND, 0},
{"simdisplay", CPX_PARAM_SIMDISPLAY, 0},
{"itlim", CPX_PARAM_ITLIM, 0},
{"rowreadlim", CPX_PARAM_ROWREADLIM, 0},
{"netfind", CPX_PARAM_NETFIND, 0},
{"colreadlim", CPX_PARAM_COLREADLIM, 0},
{"nzreadlim", CPX_PARAM_NZREADLIM, 0},
{"objllim", CPX_PARAM_OBJLLIM, 1},
{"objulim", CPX_PARAM_OBJULIM, 1},
{"perind", CPX_PARAM_PERIND, 0},
{"perlim", CPX_PARAM_PERLIM, 0},
{"ppriind", CPX_PARAM_PPRIIND, 0},
{"preind", CPX_PARAM_PREIND, 0},
{"reinv", CPX_PARAM_REINV, 0},
{"reverseind", CPX_PARAM_REVERSEIND, 0},
{"rfilemul", CPX_PARAM_RFILEMUL, 0},
{"scaind", CPX_PARAM_SCAIND, 0},
{"scrind", CPX_PARAM_SCRIND, 0},
{"simthreads", CPX_PARAM_SIMTHREADS, 0},
{"singlim", CPX_PARAM_SINGLIM, 0},
{"singtol", CPX_PARAM_SINGTOL, 0},
{"tilim", CPX_PARAM_TILIM, 1},
{"xxxind", CPX_PARAM_XXXIND, 0},
{"effslackind", CPX_PARAM_EFFSLACKIND, 0},
{"predual", CPX_PARAM_PREDUAL, 0},
{"rowgrowth", CPX_PARAM_ROWGROWTH, 0},
{"colgrowth", CPX_PARAM_COLGROWTH, 0},
{"nzgrowth", CPX_PARAM_NZGROWTH, 0},
{"epopt_h", CPX_PARAM_EPOPT_H, 0},
{"eprhs_h", CPX_PARAM_EPRHS_H, 0},
{"prepass", CPX_PARAM_PREPASS, 0},
{"datacheck", CPX_PARAM_DATACHECK, 0},
{"reduce", CPX_PARAM_REDUCE, 0},
{"prelinear", CPX_PARAM_PRELINEAR, 0},
{"lpmethod", CPX_PARAM_LPMETHOD, 0},
{"workdir", CPX_PARAM_WORKDIR, 2},
{"workmem", CPX_PARAM_WORKMEM, 1},
{"precompress", CPX_PARAM_PRECOMPRESS, 0},
{"bardstart", CPX_PARAM_BARDSTART, 0},
{"barepcomp", CPX_PARAM_BAREPCOMP, 1},
{"bargrowth", CPX_PARAM_BARGROWTH, 1},
{"barobjrng", CPX_PARAM_BAROBJRNG, 1},
{"barpstart", CPX_PARAM_BARPSTART, 0},
{"barvarup", CPX_PARAM_BARVARUP, 1},
{"baralg", CPX_PARAM_BARALG, 0},
{"barcolnz", CPX_PARAM_BARCOLNZ, 0},
{"bardisplay", CPX_PARAM_BARDISPLAY, 0},
{"baritlim", CPX_PARAM_BARITLIM, 0},
{"barmaxcor", CPX_PARAM_BARMAXCOR, 0},
{"barorder", CPX_PARAM_BARORDER, 0},
{"barrowsden", CPX_PARAM_BARROWSDEN, 0},
{"barthreads", CPX_PARAM_BARTHREADS, 0},
{"barstartalg", CPX_PARAM_BARSTARTALG, 0},
{"barcrossalg", CPX_PARAM_BARCROSSALG, 0},
{"barooc", CPX_PARAM_BAROOC, 0},
{"brdir", CPX_PARAM_BRDIR, 0}, 
{"bttol", CPX_PARAM_BTTOL, 1},
{"cliques", CPX_PARAM_CLIQUES, 0},
{"coeredind", CPX_PARAM_COEREDIND, 0},
{"covers", CPX_PARAM_COVERS, 0},
{"cutlo", CPX_PARAM_CUTLO, 1},
{"cutup", CPX_PARAM_CUTUP, 1},
{"epagap", CPX_PARAM_EPAGAP, 1},
{"epgap", CPX_PARAM_EPGAP, 1},
{"epint", CPX_PARAM_EPINT, 1},
{"heuristic", CPX_PARAM_HEURISTIC, 0},
{"mipdisplay", CPX_PARAM_MIPDISPLAY, 0},
{"mipinterval", CPX_PARAM_MIPINTERVAL, 0},
{"mipthreads", CPX_PARAM_MIPTHREADS, 0},
{"intsollim", CPX_PARAM_INTSOLLIM, 0},
{"nodefileind", CPX_PARAM_NODEFILEIND, 0},
{"nodelim", CPX_PARAM_NODELIM, 0},
{"nodesel", CPX_PARAM_NODESEL, 0},
{"objdif", CPX_PARAM_OBJDIF, 1},
{"mipordind", CPX_PARAM_MIPORDIND, 0},
{"relobjdif", CPX_PARAM_RELOBJDIF, 1},
{"startalg", CPX_PARAM_STARTALG, 0},
{"subalg", CPX_PARAM_SUBALG, 0},
{"trelim", CPX_PARAM_TRELIM, 1},
{"varsel", CPX_PARAM_VARSEL, 0},
{"bndstrenind", CPX_PARAM_BNDSTRENIND, 0},
{"heurfreq", CPX_PARAM_HEURFREQ, 0},
{"mipordtype", CPX_PARAM_MIPORDTYPE, 0},
{"cutsfactor", CPX_PARAM_CUTSFACTOR, 1},
{"relaxpreind", CPX_PARAM_RELAXPREIND, 0},
{"mipstart", CPX_PARAM_MIPSTART, 0},
{"preslvnd", CPX_PARAM_PRESLVND, 0},
{"bbinterval", CPX_PARAM_BBINTERVAL, 0},
{"flowcovers", CPX_PARAM_FLOWCOVERS, 0},
{"implbd", CPX_PARAM_IMPLBD, 0},
{"probe", CPX_PARAM_PROBE, 0},
{"gubcovers", CPX_PARAM_GUBCOVERS, 0},
{"strongcandlim", CPX_PARAM_STRONGCANDLIM, 0},
{"strongitlim", CPX_PARAM_STRONGITLIM, 0},
{"strongthreadlim", CPX_PARAM_STRONGTHREADLIM, 0},
{"fraccand", CPX_PARAM_FRACCAND, 0},
{"fraccuts", CPX_PARAM_FRACCUTS, 0},
{"fracpass", CPX_PARAM_FRACPASS, 0},
{"flowpaths", CPX_PARAM_FLOWPATHS, 0},
{"mircuts", CPX_PARAM_MIRCUTS, 0},
{"disjcuts", CPX_PARAM_DISJCUTS, 0},
{"aggcutlim", CPX_PARAM_AGGCUTLIM, 0},
{"mipcbredlp", CPX_PARAM_MIPCBREDLP, 0},
{"cutpass", CPX_PARAM_CUTPASS, 0},
{"mipemphasis", CPX_PARAM_MIPEMPHASIS, 0},
{"netitlim", CPX_PARAM_NETITLIM, 0},
{"netepopt", CPX_PARAM_NETEPOPT, 1},
{"neteprhs", CPX_PARAM_NETEPRHS, 1},
{"netppriind", CPX_PARAM_NETPPRIIND, 0},
{"netdisplay", CPX_PARAM_NETDISPLAY, 0},
{"qpnzreadlim", CPX_PARAM_QPNZREADLIM, 0},
{"qpnzgrowth", CPX_PARAM_QPNZGROWTH, 0},

#elif CPLEX==8

#define NUMPARAMS 134
static struct param_desc params[NUMPARAMS+NUMALIASES] = {
{"advind", CPX_PARAM_ADVIND, 0},
{"aggfill", CPX_PARAM_AGGFILL, 0},
{"aggind", CPX_PARAM_AGGIND, 0},
{"basinterval", CPX_PARAM_BASINTERVAL, 0},
{"cfilemul", CPX_PARAM_CFILEMUL, 0},
{"clocktype", CPX_PARAM_CLOCKTYPE, 0},
{"craind", CPX_PARAM_CRAIND, 0},
{"depind", CPX_PARAM_DEPIND, 0},
{"dpriind", CPX_PARAM_DPRIIND, 0},
{"pricelim", CPX_PARAM_PRICELIM, 0},
{"epmrk", CPX_PARAM_EPMRK, 1},
{"epopt", CPX_PARAM_EPOPT, 1},
{"epper", CPX_PARAM_EPPER, 1},
{"eprhs", CPX_PARAM_EPRHS, 1},
{"fastmip", CPX_PARAM_FASTMIP, 0},
{"iisind", CPX_PARAM_IISIND, 0},
{"simdisplay", CPX_PARAM_SIMDISPLAY, 0},
{"itlim", CPX_PARAM_ITLIM, 0},
{"rowreadlim", CPX_PARAM_ROWREADLIM, 0},
{"netfind", CPX_PARAM_NETFIND, 0},
{"colreadlim", CPX_PARAM_COLREADLIM, 0},
{"nzreadlim", CPX_PARAM_NZREADLIM, 0},
{"objllim", CPX_PARAM_OBJLLIM, 1},
{"objulim", CPX_PARAM_OBJULIM, 1},
{"perind", CPX_PARAM_PERIND, 0},
{"perlim", CPX_PARAM_PERLIM, 0},
{"ppriind", CPX_PARAM_PPRIIND, 0},
{"preind", CPX_PARAM_PREIND, 0},
{"reinv", CPX_PARAM_REINV, 0},
{"reverseind", CPX_PARAM_REVERSEIND, 0},
{"rfilemul", CPX_PARAM_RFILEMUL, 0},
{"scaind", CPX_PARAM_SCAIND, 0},
{"scrind", CPX_PARAM_SCRIND, 0},
{"simthreads", CPX_PARAM_SIMTHREADS, 0},
{"singlim", CPX_PARAM_SINGLIM, 0},
{"singtol", CPX_PARAM_SINGTOL, 0},
{"tilim", CPX_PARAM_TILIM, 1},
{"xxxind", CPX_PARAM_XXXIND, 0},
{"predual", CPX_PARAM_PREDUAL, 0},
{"rowgrowth", CPX_PARAM_ROWGROWTH, 0},
{"colgrowth", CPX_PARAM_COLGROWTH, 0},
{"nzgrowth", CPX_PARAM_NZGROWTH, 0},
{"epopt_h", CPX_PARAM_EPOPT_H, 0},
{"eprhs_h", CPX_PARAM_EPRHS_H, 0},
{"prepass", CPX_PARAM_PREPASS, 0},
{"datacheck", CPX_PARAM_DATACHECK, 0},
{"reduce", CPX_PARAM_REDUCE, 0},
{"prelinear", CPX_PARAM_PRELINEAR, 0},
{"lpmethod", CPX_PARAM_LPMETHOD, 0},
{"qpmethod", CPX_PARAM_QPMETHOD, 0},
{"workdir", CPX_PARAM_WORKDIR, 2},
{"workmem", CPX_PARAM_WORKMEM, 1},
{"precompress", CPX_PARAM_PRECOMPRESS, 0},
{"threads", CPX_PARAM_THREADS, 0},
{"siftdisplay", CPX_PARAM_SIFTDISPLAY, 0},
{"siftalg", CPX_PARAM_SIFTALG, 0},
{"siftitlim", CPX_PARAM_SIFTITLIM, 0}, 
{"bardstart", CPX_PARAM_BARDSTART, 0},
{"barepcomp", CPX_PARAM_BAREPCOMP, 1},
{"bargrowth", CPX_PARAM_BARGROWTH, 1},
{"barobjrng", CPX_PARAM_BAROBJRNG, 1},
{"barpstart", CPX_PARAM_BARPSTART, 0},
{"barvarup", CPX_PARAM_BARVARUP, 1},
{"baralg", CPX_PARAM_BARALG, 0},
{"barcolnz", CPX_PARAM_BARCOLNZ, 0},
{"bardisplay", CPX_PARAM_BARDISPLAY, 0},
{"baritlim", CPX_PARAM_BARITLIM, 0},
{"barmaxcor", CPX_PARAM_BARMAXCOR, 0},
{"barorder", CPX_PARAM_BARORDER, 0},
{"barrowsden", CPX_PARAM_BARROWSDEN, 0},
{"barthreads", CPX_PARAM_BARTHREADS, 0},
{"barstartalg", CPX_PARAM_BARSTARTALG, 0},
{"barcrossalg", CPX_PARAM_BARCROSSALG, 0},
{"barooc", CPX_PARAM_BAROOC, 0},
{"brdir", CPX_PARAM_BRDIR, 0}, 
{"bttol", CPX_PARAM_BTTOL, 1},
{"cliques", CPX_PARAM_CLIQUES, 0},
{"coeredind", CPX_PARAM_COEREDIND, 0},
{"covers", CPX_PARAM_COVERS, 0},
{"cutlo", CPX_PARAM_CUTLO, 1},
{"cutup", CPX_PARAM_CUTUP, 1},
{"epagap", CPX_PARAM_EPAGAP, 1},
{"epgap", CPX_PARAM_EPGAP, 1},
{"epint", CPX_PARAM_EPINT, 1},
{"heuristic", CPX_PARAM_HEURISTIC, 0},
{"mipdisplay", CPX_PARAM_MIPDISPLAY, 0},
{"mipinterval", CPX_PARAM_MIPINTERVAL, 0},
{"mipthreads", CPX_PARAM_MIPTHREADS, 0},
{"intsollim", CPX_PARAM_INTSOLLIM, 0},
{"nodefileind", CPX_PARAM_NODEFILEIND, 0},
{"nodelim", CPX_PARAM_NODELIM, 0},
{"nodesel", CPX_PARAM_NODESEL, 0},
{"objdif", CPX_PARAM_OBJDIF, 1},
{"mipordind", CPX_PARAM_MIPORDIND, 0},
{"relobjdif", CPX_PARAM_RELOBJDIF, 1},
{"startalg", CPX_PARAM_STARTALG, 0},
{"subalg", CPX_PARAM_SUBALG, 0},
{"trelim", CPX_PARAM_TRELIM, 1},
{"varsel", CPX_PARAM_VARSEL, 0},
{"bndstrenind", CPX_PARAM_BNDSTRENIND, 0},
{"heurfreq", CPX_PARAM_HEURFREQ, 0},
{"mipordtype", CPX_PARAM_MIPORDTYPE, 0},
{"cutsfactor", CPX_PARAM_CUTSFACTOR, 1},
{"relaxpreind", CPX_PARAM_RELAXPREIND, 0},
{"mipstart", CPX_PARAM_MIPSTART, 0},
{"preslvnd", CPX_PARAM_PRESLVND, 0},
{"bbinterval", CPX_PARAM_BBINTERVAL, 0},
{"flowcovers", CPX_PARAM_FLOWCOVERS, 0},
{"implbd", CPX_PARAM_IMPLBD, 0},
{"probe", CPX_PARAM_PROBE, 0},
{"gubcovers", CPX_PARAM_GUBCOVERS, 0},
{"strongcandlim", CPX_PARAM_STRONGCANDLIM, 0},
{"strongitlim", CPX_PARAM_STRONGITLIM, 0},
{"strongthreadlim", CPX_PARAM_STRONGTHREADLIM, 0},
{"fraccand", CPX_PARAM_FRACCAND, 0},
{"fraccuts", CPX_PARAM_FRACCUTS, 0},
{"fracpass", CPX_PARAM_FRACPASS, 0},
{"flowpaths", CPX_PARAM_FLOWPATHS, 0},
{"mircuts", CPX_PARAM_MIRCUTS, 0},
{"disjcuts", CPX_PARAM_DISJCUTS, 0},
{"aggcutlim", CPX_PARAM_AGGCUTLIM, 0},
{"mipcbredlp", CPX_PARAM_MIPCBREDLP, 0},
{"cutpass", CPX_PARAM_CUTPASS, 0},
{"mipemphasis", CPX_PARAM_MIPEMPHASIS, 0},
{"symmetry", CPX_PARAM_SYMMETRY, 0},
{"divetype", CPX_PARAM_DIVETYPE, 0},
{"netitlim", CPX_PARAM_NETITLIM, 0},
{"netepopt", CPX_PARAM_NETEPOPT, 1},
{"neteprhs", CPX_PARAM_NETEPRHS, 1},
{"netppriind", CPX_PARAM_NETPPRIIND, 0},
{"netdisplay", CPX_PARAM_NETDISPLAY, 0},
{"qpnzreadlim", CPX_PARAM_QPNZREADLIM, 0},
{"qpnzgrowth", CPX_PARAM_QPNZGROWTH, 0},
{"qpmakepsdind", CPX_PARAM_QPMAKEPSDIND, 0},

#elif CPLEX==9

#define NUMPARAMS 135
static struct param_desc params[NUMPARAMS+NUMALIASES] = {
{"advind", CPX_PARAM_ADVIND, 0},
{"aggfill", CPX_PARAM_AGGFILL, 0},
{"aggind", CPX_PARAM_AGGIND, 0},
{"basinterval", CPX_PARAM_BASINTERVAL, 0},
{"cfilemul", CPX_PARAM_CFILEMUL, 0},
{"clocktype", CPX_PARAM_CLOCKTYPE, 0},
{"craind", CPX_PARAM_CRAIND, 0},
{"depind", CPX_PARAM_DEPIND, 0},
{"dpriind", CPX_PARAM_DPRIIND, 0},
{"pricelim", CPX_PARAM_PRICELIM, 0},
{"epmrk", CPX_PARAM_EPMRK, 1},
{"epopt", CPX_PARAM_EPOPT, 1},
{"epper", CPX_PARAM_EPPER, 1},
{"eprhs", CPX_PARAM_EPRHS, 1},
{"fastmip", CPX_PARAM_FASTMIP, 0},
{"iisind", CPX_PARAM_IISIND, 0},
{"simdisplay", CPX_PARAM_SIMDISPLAY, 0},
{"itlim", CPX_PARAM_ITLIM, 0},
{"rowreadlim", CPX_PARAM_ROWREADLIM, 0},
{"netfind", CPX_PARAM_NETFIND, 0},
{"colreadlim", CPX_PARAM_COLREADLIM, 0},
{"nzreadlim", CPX_PARAM_NZREADLIM, 0},
{"objllim", CPX_PARAM_OBJLLIM, 1},
{"objulim", CPX_PARAM_OBJULIM, 1},
{"perind", CPX_PARAM_PERIND, 0},
{"perlim", CPX_PARAM_PERLIM, 0},
{"ppriind", CPX_PARAM_PPRIIND, 0},
{"preind", CPX_PARAM_PREIND, 0},
{"reinv", CPX_PARAM_REINV, 0},
{"reverseind", CPX_PARAM_REVERSEIND, 0},
{"rfilemul", CPX_PARAM_RFILEMUL, 0},
{"scaind", CPX_PARAM_SCAIND, 0},
{"scrind", CPX_PARAM_SCRIND, 0},
{"singlim", CPX_PARAM_SINGLIM, 0},
{"singtol", CPX_PARAM_SINGTOL, 0},
{"tilim", CPX_PARAM_TILIM, 1},
{"xxxind", CPX_PARAM_XXXIND, 0},
{"predual", CPX_PARAM_PREDUAL, 0},
{"rowgrowth", CPX_PARAM_ROWGROWTH, 0},
{"colgrowth", CPX_PARAM_COLGROWTH, 0},
{"nzgrowth", CPX_PARAM_NZGROWTH, 0},
{"epopt_h", CPX_PARAM_EPOPT_H, 0},
{"eprhs_h", CPX_PARAM_EPRHS_H, 0},
{"prepass", CPX_PARAM_PREPASS, 0},
{"datacheck", CPX_PARAM_DATACHECK, 0},
{"reduce", CPX_PARAM_REDUCE, 0},
{"prelinear", CPX_PARAM_PRELINEAR, 0},
{"lpmethod", CPX_PARAM_LPMETHOD, 0},
{"qpmethod", CPX_PARAM_QPMETHOD, 0},
{"workdir", CPX_PARAM_WORKDIR, 2},
{"workmem", CPX_PARAM_WORKMEM, 1},
{"precompress", CPX_PARAM_PRECOMPRESS, 0},
{"threads", CPX_PARAM_THREADS, 0},
{"siftdisplay", CPX_PARAM_SIFTDISPLAY, 0},
{"siftalg", CPX_PARAM_SIFTALG, 0},
{"siftitlim", CPX_PARAM_SIFTITLIM, 0},
{"finalfactor", CPX_PARAM_FINALFACTOR, 0},
{"bardstart", CPX_PARAM_BARDSTART, 0},
{"barepcomp", CPX_PARAM_BAREPCOMP, 1},
{"bargrowth", CPX_PARAM_BARGROWTH, 1},
{"barobjrng", CPX_PARAM_BAROBJRNG, 1},
{"barpstart", CPX_PARAM_BARPSTART, 0},
{"baralg", CPX_PARAM_BARALG, 0},
{"barcolnz", CPX_PARAM_BARCOLNZ, 0},
{"bardisplay", CPX_PARAM_BARDISPLAY, 0},
{"baritlim", CPX_PARAM_BARITLIM, 0},
{"barmaxcor", CPX_PARAM_BARMAXCOR, 0},
{"barorder", CPX_PARAM_BARORDER, 0},
{"barrowsden", CPX_PARAM_BARROWSDEN, 0},
{"barthreads", CPX_PARAM_BARTHREADS, 0},
{"barstartalg", CPX_PARAM_BARSTARTALG, 0},
{"barcrossalg", CPX_PARAM_BARCROSSALG, 0},
{"barooc", CPX_PARAM_BAROOC, 0},
{"barqcpepcomp", CPX_PARAM_BARQCPEPCOMP, 1},
{"brdir", CPX_PARAM_BRDIR, 0},
{"bttol", CPX_PARAM_BTTOL, 1},
{"cliques", CPX_PARAM_CLIQUES, 0},
{"coeredind", CPX_PARAM_COEREDIND, 0},
{"covers", CPX_PARAM_COVERS, 0},
{"cutlo", CPX_PARAM_CUTLO, 1},
{"cutup", CPX_PARAM_CUTUP, 1},
{"epagap", CPX_PARAM_EPAGAP, 1},
{"epgap", CPX_PARAM_EPGAP, 1},
{"epint", CPX_PARAM_EPINT, 1},
{"mipdisplay", CPX_PARAM_MIPDISPLAY, 0},
{"mipinterval", CPX_PARAM_MIPINTERVAL, 0},
{"mipthreads", CPX_PARAM_MIPTHREADS, 0},
{"intsollim", CPX_PARAM_INTSOLLIM, 0},
{"nodefileind", CPX_PARAM_NODEFILEIND, 0},
{"nodelim", CPX_PARAM_NODELIM, 0},
{"nodesel", CPX_PARAM_NODESEL, 0},
{"objdif", CPX_PARAM_OBJDIF, 1},
{"mipordind", CPX_PARAM_MIPORDIND, 0},
{"relobjdif", CPX_PARAM_RELOBJDIF, 1},
{"startalg", CPX_PARAM_STARTALG, 0},
{"subalg", CPX_PARAM_SUBALG, 0},
{"trelim", CPX_PARAM_TRELIM, 1},
{"varsel", CPX_PARAM_VARSEL, 0},
{"bndstrenind", CPX_PARAM_BNDSTRENIND, 0},
{"heurfreq", CPX_PARAM_HEURFREQ, 0},
{"mipordtype", CPX_PARAM_MIPORDTYPE, 0},
{"cutsfactor", CPX_PARAM_CUTSFACTOR, 1},
{"relaxpreind", CPX_PARAM_RELAXPREIND, 0},
{"mipstart", CPX_PARAM_MIPSTART, 0},
{"preslvnd", CPX_PARAM_PRESLVND, 0},
{"bbinterval", CPX_PARAM_BBINTERVAL, 0},
{"flowcovers", CPX_PARAM_FLOWCOVERS, 0},
{"implbd", CPX_PARAM_IMPLBD, 0},
{"probe", CPX_PARAM_PROBE, 0},
{"gubcovers", CPX_PARAM_GUBCOVERS, 0},
{"strongcandlim", CPX_PARAM_STRONGCANDLIM, 0},
{"strongitlim", CPX_PARAM_STRONGITLIM, 0},
{"strongthreadlim", CPX_PARAM_STRONGTHREADLIM, 0},
{"fraccand", CPX_PARAM_FRACCAND, 0},
{"fraccuts", CPX_PARAM_FRACCUTS, 0},
{"fracpass", CPX_PARAM_FRACPASS, 0},
{"flowpaths", CPX_PARAM_FLOWPATHS, 0},
{"mircuts", CPX_PARAM_MIRCUTS, 0},
{"disjcuts", CPX_PARAM_DISJCUTS, 0},
{"aggcutlim", CPX_PARAM_AGGCUTLIM, 0},
{"mipcbredlp", CPX_PARAM_MIPCBREDLP, 0},
{"cutpass", CPX_PARAM_CUTPASS, 0},
{"mipemphasis", CPX_PARAM_MIPEMPHASIS, 0},
{"symmetry", CPX_PARAM_SYMMETRY, 0},
{"divetype", CPX_PARAM_DIVETYPE, 0},
{"rinsheur", CPX_PARAM_RINSHEUR, 0},
{"submipnodelim", CPX_PARAM_SUBMIPNODELIM, 0},
{"netitlim", CPX_PARAM_NETITLIM, 0},
{"netepopt", CPX_PARAM_NETEPOPT, 1},
{"neteprhs", CPX_PARAM_NETEPRHS, 1},
{"netppriind", CPX_PARAM_NETPPRIIND, 0},
{"netdisplay", CPX_PARAM_NETDISPLAY, 0},
{"qpnzreadlim", CPX_PARAM_QPNZREADLIM, 0},
{"qpnzgrowth", CPX_PARAM_QPNZGROWTH, 0},
{"qpmakepsdind", CPX_PARAM_QPMAKEPSDIND, 0},

#elif CPLEX==10

#define NUMPARAMS 137
static struct param_desc params[NUMPARAMS+NUMALIASES] = {
{"advind", CPX_PARAM_ADVIND, 0},
{"aggfill", CPX_PARAM_AGGFILL, 0},
{"aggind", CPX_PARAM_AGGIND, 0},
{"basinterval", CPX_PARAM_BASINTERVAL, 0},
{"cfilemul", CPX_PARAM_CFILEMUL, 0},
{"clocktype", CPX_PARAM_CLOCKTYPE, 0},
{"craind", CPX_PARAM_CRAIND, 0},
{"depind", CPX_PARAM_DEPIND, 0},
{"dpriind", CPX_PARAM_DPRIIND, 0},
{"pricelim", CPX_PARAM_PRICELIM, 0},
{"epmrk", CPX_PARAM_EPMRK, 1},
{"epopt", CPX_PARAM_EPOPT, 1},
{"epper", CPX_PARAM_EPPER, 1},
{"eprhs", CPX_PARAM_EPRHS, 1},
{"fastmip", CPX_PARAM_FASTMIP, 0},
{"simdisplay", CPX_PARAM_SIMDISPLAY, 0},
{"itlim", CPX_PARAM_ITLIM, 0},
{"rowreadlim", CPX_PARAM_ROWREADLIM, 0},
{"netfind", CPX_PARAM_NETFIND, 0},
{"colreadlim", CPX_PARAM_COLREADLIM, 0},
{"nzreadlim", CPX_PARAM_NZREADLIM, 0},
{"objllim", CPX_PARAM_OBJLLIM, 1},
{"objulim", CPX_PARAM_OBJULIM, 1},
{"perind", CPX_PARAM_PERIND, 0},
{"perlim", CPX_PARAM_PERLIM, 0},
{"ppriind", CPX_PARAM_PPRIIND, 0},
{"preind", CPX_PARAM_PREIND, 0},
{"reinv", CPX_PARAM_REINV, 0},
{"reverseind", CPX_PARAM_REVERSEIND, 0},
{"rfilemul", CPX_PARAM_RFILEMUL, 0},
{"scaind", CPX_PARAM_SCAIND, 0},
{"scrind", CPX_PARAM_SCRIND, 0},
{"singlim", CPX_PARAM_SINGLIM, 0},
{"singtol", CPX_PARAM_SINGTOL, 0},
{"tilim", CPX_PARAM_TILIM, 1},
{"xxxind", CPX_PARAM_XXXIND, 0},
{"predual", CPX_PARAM_PREDUAL, 0},
{"epopt_h", CPX_PARAM_EPOPT_H, 0},
{"eprhs_h", CPX_PARAM_EPRHS_H, 0},
{"prepass", CPX_PARAM_PREPASS, 0},
{"datacheck", CPX_PARAM_DATACHECK, 0},
{"reduce", CPX_PARAM_REDUCE, 0},
{"prelinear", CPX_PARAM_PRELINEAR, 0},
{"lpmethod", CPX_PARAM_LPMETHOD, 0},
{"qpmethod", CPX_PARAM_QPMETHOD, 0},
{"workdir", CPX_PARAM_WORKDIR, 2},
{"workmem", CPX_PARAM_WORKMEM, 1},
{"threads", CPX_PARAM_THREADS, 0},
{"conflictdisplay", CPX_PARAM_CONFLICTDISPLAY, 0},
{"siftdisplay", CPX_PARAM_SIFTDISPLAY, 0},
{"siftalg", CPX_PARAM_SIFTALG, 0},
{"siftitlim", CPX_PARAM_SIFTITLIM, 0},
{"mpslongnum", CPX_PARAM_MPSLONGNUM, 0},
{"memoryemphasis", CPX_PARAM_MEMORYEMPHASIS, 0},
{"numericalemphasis", CPX_PARAM_NUMERICALEMPHASIS, 0},
{"feasoptmode", CPX_PARAM_FEASOPTMODE, 0},
{"bardstart", CPX_PARAM_BARDSTART, 0},
{"barepcomp", CPX_PARAM_BAREPCOMP, 1},
{"bargrowth", CPX_PARAM_BARGROWTH, 1},
{"barobjrng", CPX_PARAM_BAROBJRNG, 1},
{"barpstart", CPX_PARAM_BARPSTART, 0},
{"baralg", CPX_PARAM_BARALG, 0},
{"barcolnz", CPX_PARAM_BARCOLNZ, 0},
{"bardisplay", CPX_PARAM_BARDISPLAY, 0},
{"baritlim", CPX_PARAM_BARITLIM, 0},
{"barmaxcor", CPX_PARAM_BARMAXCOR, 0},
{"barorder", CPX_PARAM_BARORDER, 0},
{"barthreads", CPX_PARAM_BARTHREADS, 0},
{"barstartalg", CPX_PARAM_BARSTARTALG, 0},
{"barcrossalg", CPX_PARAM_BARCROSSALG, 0},
{"barqcpepcomp", CPX_PARAM_BARQCPEPCOMP, 1},
{"brdir", CPX_PARAM_BRDIR, 0},
{"bttol", CPX_PARAM_BTTOL, 1},
{"cliques", CPX_PARAM_CLIQUES, 0},
{"coeredind", CPX_PARAM_COEREDIND, 0},
{"covers", CPX_PARAM_COVERS, 0},
{"cutlo", CPX_PARAM_CUTLO, 1},
{"cutup", CPX_PARAM_CUTUP, 1},
{"epagap", CPX_PARAM_EPAGAP, 1},
{"epgap", CPX_PARAM_EPGAP, 1},
{"epint", CPX_PARAM_EPINT, 1},
{"mipdisplay", CPX_PARAM_MIPDISPLAY, 0},
{"mipinterval", CPX_PARAM_MIPINTERVAL, 0},
{"mipthreads", CPX_PARAM_MIPTHREADS, 0},
{"intsollim", CPX_PARAM_INTSOLLIM, 0},
{"nodefileind", CPX_PARAM_NODEFILEIND, 0},
{"nodelim", CPX_PARAM_NODELIM, 0},
{"nodesel", CPX_PARAM_NODESEL, 0},
{"objdif", CPX_PARAM_OBJDIF, 1},
{"mipordind", CPX_PARAM_MIPORDIND, 0},
{"relobjdif", CPX_PARAM_RELOBJDIF, 1},
{"startalg", CPX_PARAM_STARTALG, 0},
{"subalg", CPX_PARAM_SUBALG, 0},
{"trelim", CPX_PARAM_TRELIM, 1},
{"varsel", CPX_PARAM_VARSEL, 0},
{"bndstrenind", CPX_PARAM_BNDSTRENIND, 0},
{"heurfreq", CPX_PARAM_HEURFREQ, 0},
{"mipordtype", CPX_PARAM_MIPORDTYPE, 0},
{"cutsfactor", CPX_PARAM_CUTSFACTOR, 1},
{"relaxpreind", CPX_PARAM_RELAXPREIND, 0},
{"preslvnd", CPX_PARAM_PRESLVND, 0},
{"bbinterval", CPX_PARAM_BBINTERVAL, 0},
{"flowcovers", CPX_PARAM_FLOWCOVERS, 0},
{"implbd", CPX_PARAM_IMPLBD, 0},
{"probe", CPX_PARAM_PROBE, 0},
{"gubcovers", CPX_PARAM_GUBCOVERS, 0},
{"strongcandlim", CPX_PARAM_STRONGCANDLIM, 0},
{"strongitlim", CPX_PARAM_STRONGITLIM, 0},
{"strongthreadlim", CPX_PARAM_STRONGTHREADLIM, 0},
{"fraccand", CPX_PARAM_FRACCAND, 0},
{"fraccuts", CPX_PARAM_FRACCUTS, 0},
{"fracpass", CPX_PARAM_FRACPASS, 0},
{"flowpaths", CPX_PARAM_FLOWPATHS, 0},
{"mircuts", CPX_PARAM_MIRCUTS, 0},
{"disjcuts", CPX_PARAM_DISJCUTS, 0},
{"aggcutlim", CPX_PARAM_AGGCUTLIM, 0},
{"mipcbredlp", CPX_PARAM_MIPCBREDLP, 0},
{"cutpass", CPX_PARAM_CUTPASS, 0},
{"mipemphasis", CPX_PARAM_MIPEMPHASIS, 0},
{"symmetry", CPX_PARAM_SYMMETRY, 0},
{"divetype", CPX_PARAM_DIVETYPE, 0},
{"rinsheur", CPX_PARAM_RINSHEUR, 0},
{"submipnodelim", CPX_PARAM_SUBMIPNODELIM, 0},
{"lbheur", CPX_PARAM_LBHEUR, 0},
{"repeatpresolve", CPX_PARAM_REPEATPRESOLVE, 0},
{"probetime", CPX_PARAM_PROBETIME, 1},
{"polishtime", CPX_PARAM_POLISHTIME, 1},
{"repairtries", CPX_PARAM_REPAIRTRIES, 0},
{"eplin", CPX_PARAM_EPLIN, 1},
{"eprelax", CPX_PARAM_EPRELAX, 1},
{"netitlim", CPX_PARAM_NETITLIM, 0},
{"netepopt", CPX_PARAM_NETEPOPT, 1},
{"neteprhs", CPX_PARAM_NETEPRHS, 1},
{"netppriind", CPX_PARAM_NETPPRIIND, 0},
{"netdisplay", CPX_PARAM_NETDISPLAY, 0},
{"qpnzreadlim", CPX_PARAM_QPNZREADLIM, 0},
{"qpmakepsdind", CPX_PARAM_QPMAKEPSDIND, 0},

#elif CPLEX==11

#define NUMPARAMS 150
static struct param_desc params[NUMPARAMS+NUMALIASES] = {
{"advind", CPX_PARAM_ADVIND, 0},
{"aggfill", CPX_PARAM_AGGFILL, 0},
{"aggind", CPX_PARAM_AGGIND, 0},
{"basinterval", CPX_PARAM_BASINTERVAL, 0},
{"cfilemul", CPX_PARAM_CFILEMUL, 0},
{"clocktype", CPX_PARAM_CLOCKTYPE, 0},
{"craind", CPX_PARAM_CRAIND, 0},
{"depind", CPX_PARAM_DEPIND, 0},
{"dpriind", CPX_PARAM_DPRIIND, 0},
{"pricelim", CPX_PARAM_PRICELIM, 0},
{"epmrk", CPX_PARAM_EPMRK, 1},
{"epopt", CPX_PARAM_EPOPT, 1},
{"epper", CPX_PARAM_EPPER, 1},
{"eprhs", CPX_PARAM_EPRHS, 1},
{"fastmip", CPX_PARAM_FASTMIP, 0},
{"simdisplay", CPX_PARAM_SIMDISPLAY, 0},
{"itlim", CPX_PARAM_ITLIM, 0},
{"rowreadlim", CPX_PARAM_ROWREADLIM, 0},
{"netfind", CPX_PARAM_NETFIND, 0},
{"colreadlim", CPX_PARAM_COLREADLIM, 0},
{"nzreadlim", CPX_PARAM_NZREADLIM, 0},
{"objllim", CPX_PARAM_OBJLLIM, 1},
{"objulim", CPX_PARAM_OBJULIM, 1},
{"perind", CPX_PARAM_PERIND, 0},
{"perlim", CPX_PARAM_PERLIM, 0},
{"ppriind", CPX_PARAM_PPRIIND, 0},
{"preind", CPX_PARAM_PREIND, 0},
{"reinv", CPX_PARAM_REINV, 0},
{"reverseind", CPX_PARAM_REVERSEIND, 0},
{"rfilemul", CPX_PARAM_RFILEMUL, 0},
{"scaind", CPX_PARAM_SCAIND, 0},
{"scrind", CPX_PARAM_SCRIND, 0},
{"singlim", CPX_PARAM_SINGLIM, 0},
{"singtol", CPX_PARAM_SINGTOL, 0},
{"tilim", CPX_PARAM_TILIM, 1},
{"xxxind", CPX_PARAM_XXXIND, 0},
{"predual", CPX_PARAM_PREDUAL, 0},
{"epopt_h", CPX_PARAM_EPOPT_H, 0},
{"eprhs_h", CPX_PARAM_EPRHS_H, 0},
{"prepass", CPX_PARAM_PREPASS, 0},
{"datacheck", CPX_PARAM_DATACHECK, 0},
{"reduce", CPX_PARAM_REDUCE, 0},
{"prelinear", CPX_PARAM_PRELINEAR, 0},
{"lpmethod", CPX_PARAM_LPMETHOD, 0},
{"qpmethod", CPX_PARAM_QPMETHOD, 0},
{"workdir", CPX_PARAM_WORKDIR, 2},
{"workmem", CPX_PARAM_WORKMEM, 1},
{"threads", CPX_PARAM_THREADS, 0},
{"conflictdisplay", CPX_PARAM_CONFLICTDISPLAY, 0},
{"siftdisplay", CPX_PARAM_SIFTDISPLAY, 0},
{"siftalg", CPX_PARAM_SIFTALG, 0},
{"siftitlim", CPX_PARAM_SIFTITLIM, 0},
{"mpslongnum", CPX_PARAM_MPSLONGNUM, 0},
{"memoryemphasis", CPX_PARAM_MEMORYEMPHASIS, 0},
{"numericalemphasis", CPX_PARAM_NUMERICALEMPHASIS, 0},
{"feasoptmode", CPX_PARAM_FEASOPTMODE, 0},
{"parallelmode", CPX_PARAM_PARALLELMODE, 0},
{"tuningmeasure", CPX_PARAM_TUNINGMEASURE, 0},
{"tuningrepeat", CPX_PARAM_TUNINGREPEAT, 0},
{"tuningtilim", CPX_PARAM_TUNINGTILIM, 1},
{"tuningdisplay", CPX_PARAM_TUNINGDISPLAY, 0},
{"bardstart", CPX_PARAM_BARDSTART, 0},
{"barepcomp", CPX_PARAM_BAREPCOMP, 1},
{"bargrowth", CPX_PARAM_BARGROWTH, 1},
{"barobjrng", CPX_PARAM_BAROBJRNG, 1},
{"barpstart", CPX_PARAM_BARPSTART, 0},
{"baralg", CPX_PARAM_BARALG, 0},
{"barcolnz", CPX_PARAM_BARCOLNZ, 0},
{"bardisplay", CPX_PARAM_BARDISPLAY, 0},
{"baritlim", CPX_PARAM_BARITLIM, 0},
{"barmaxcor", CPX_PARAM_BARMAXCOR, 0},
{"barorder", CPX_PARAM_BARORDER, 0},
{"barstartalg", CPX_PARAM_BARSTARTALG, 0},
{"barcrossalg", CPX_PARAM_BARCROSSALG, 0},
{"barqcpepcomp", CPX_PARAM_BARQCPEPCOMP, 1},
{"brdir", CPX_PARAM_BRDIR, 0},
{"bttol", CPX_PARAM_BTTOL, 1},
{"cliques", CPX_PARAM_CLIQUES, 0},
{"coeredind", CPX_PARAM_COEREDIND, 0},
{"covers", CPX_PARAM_COVERS, 0},
{"cutlo", CPX_PARAM_CUTLO, 1},
{"cutup", CPX_PARAM_CUTUP, 1},
{"epagap", CPX_PARAM_EPAGAP, 1},
{"epgap", CPX_PARAM_EPGAP, 1},
{"epint", CPX_PARAM_EPINT, 1},
{"mipdisplay", CPX_PARAM_MIPDISPLAY, 0},
{"mipinterval", CPX_PARAM_MIPINTERVAL, 0},
{"intsollim", CPX_PARAM_INTSOLLIM, 0},
{"nodefileind", CPX_PARAM_NODEFILEIND, 0},
{"nodelim", CPX_PARAM_NODELIM, 0},
{"nodesel", CPX_PARAM_NODESEL, 0},
{"objdif", CPX_PARAM_OBJDIF, 1},
{"mipordind", CPX_PARAM_MIPORDIND, 0},
{"relobjdif", CPX_PARAM_RELOBJDIF, 1},
{"startalg", CPX_PARAM_STARTALG, 0},
{"subalg", CPX_PARAM_SUBALG, 0},
{"trelim", CPX_PARAM_TRELIM, 1},
{"varsel", CPX_PARAM_VARSEL, 0},
{"bndstrenind", CPX_PARAM_BNDSTRENIND, 0},
{"heurfreq", CPX_PARAM_HEURFREQ, 0},
{"mipordtype", CPX_PARAM_MIPORDTYPE, 0},
{"cutsfactor", CPX_PARAM_CUTSFACTOR, 1},
{"relaxpreind", CPX_PARAM_RELAXPREIND, 0},
{"preslvnd", CPX_PARAM_PRESLVND, 0},
{"bbinterval", CPX_PARAM_BBINTERVAL, 0},
{"flowcovers", CPX_PARAM_FLOWCOVERS, 0},
{"implbd", CPX_PARAM_IMPLBD, 0},
{"probe", CPX_PARAM_PROBE, 0},
{"gubcovers", CPX_PARAM_GUBCOVERS, 0},
{"strongcandlim", CPX_PARAM_STRONGCANDLIM, 0},
{"strongitlim", CPX_PARAM_STRONGITLIM, 0},
{"fraccand", CPX_PARAM_FRACCAND, 0},
{"fraccuts", CPX_PARAM_FRACCUTS, 0},
{"fracpass", CPX_PARAM_FRACPASS, 0},
{"flowpaths", CPX_PARAM_FLOWPATHS, 0},
{"mircuts", CPX_PARAM_MIRCUTS, 0},
{"disjcuts", CPX_PARAM_DISJCUTS, 0},
{"aggcutlim", CPX_PARAM_AGGCUTLIM, 0},
{"mipcbredlp", CPX_PARAM_MIPCBREDLP, 0},
{"cutpass", CPX_PARAM_CUTPASS, 0},
{"mipemphasis", CPX_PARAM_MIPEMPHASIS, 0},
{"symmetry", CPX_PARAM_SYMMETRY, 0},
{"divetype", CPX_PARAM_DIVETYPE, 0},
{"rinsheur", CPX_PARAM_RINSHEUR, 0},
{"submipnodelim", CPX_PARAM_SUBMIPNODELIM, 0},
{"lbheur", CPX_PARAM_LBHEUR, 0},
{"repeatpresolve", CPX_PARAM_REPEATPRESOLVE, 0},
{"probetime", CPX_PARAM_PROBETIME, 1},
{"polishtime", CPX_PARAM_POLISHTIME, 1},
{"repairtries", CPX_PARAM_REPAIRTRIES, 0},
{"eplin", CPX_PARAM_EPLIN, 1},
{"eprelax", CPX_PARAM_EPRELAX, 1},
{"fpheur", CPX_PARAM_FPHEUR, 0},
{"eachcutlim", CPX_PARAM_EACHCUTLIM, 0},
{"solnpoolcapacity", CPX_PARAM_SOLNPOOLCAPACITY, 0},
{"solnpoolreplace", CPX_PARAM_SOLNPOOLREPLACE, 0},
{"solnpoolgap", CPX_PARAM_SOLNPOOLGAP, 1},
{"solnpoolagap", CPX_PARAM_SOLNPOOLAGAP, 1},
{"solnpoolintensity", CPX_PARAM_SOLNPOOLINTENSITY, 0},
{"populatelim", CPX_PARAM_POPULATELIM, 0},
{"mipsearch", CPX_PARAM_MIPSEARCH, 0},
{"miqcpstrat", CPX_PARAM_MIQCPSTRAT, 0},
{"zerohalfcuts", CPX_PARAM_ZEROHALFCUTS, 0},
{"netitlim", CPX_PARAM_NETITLIM, 0},
{"netepopt", CPX_PARAM_NETEPOPT, 1},
{"neteprhs", CPX_PARAM_NETEPRHS, 1},
{"netppriind", CPX_PARAM_NETPPRIIND, 0},
{"netdisplay", CPX_PARAM_NETDISPLAY, 0},
{"qpnzreadlim", CPX_PARAM_QPNZREADLIM, 0},
{"qpmakepsdind", CPX_PARAM_QPMAKEPSDIND, 0},

#elif CPLEX==12

#define NUMPARAMS 157
static struct param_desc params[NUMPARAMS+NUMALIASES] = {
{"advind", CPX_PARAM_ADVIND, 0},
{"aggfill", CPX_PARAM_AGGFILL, 0},
{"aggind", CPX_PARAM_AGGIND, 0},
{"basinterval", CPX_PARAM_BASINTERVAL, 0},
{"cfilemul", CPX_PARAM_CFILEMUL, 0},
{"clocktype", CPX_PARAM_CLOCKTYPE, 0},
{"craind", CPX_PARAM_CRAIND, 0},
{"depind", CPX_PARAM_DEPIND, 0},
{"dpriind", CPX_PARAM_DPRIIND, 0},
{"pricelim", CPX_PARAM_PRICELIM, 0},
{"epmrk", CPX_PARAM_EPMRK, 1},
{"epopt", CPX_PARAM_EPOPT, 1},
{"epper", CPX_PARAM_EPPER, 1},
{"eprhs", CPX_PARAM_EPRHS, 1},
{"fastmip", CPX_PARAM_FASTMIP, 0},
{"simdisplay", CPX_PARAM_SIMDISPLAY, 0},
{"itlim", CPX_PARAM_ITLIM, 0},
{"rowreadlim", CPX_PARAM_ROWREADLIM, 0},
{"netfind", CPX_PARAM_NETFIND, 0},
{"colreadlim", CPX_PARAM_COLREADLIM, 0},
{"nzreadlim", CPX_PARAM_NZREADLIM, 0},
{"objllim", CPX_PARAM_OBJLLIM, 1},
{"objulim", CPX_PARAM_OBJULIM, 1},
{"perind", CPX_PARAM_PERIND, 0},
{"perlim", CPX_PARAM_PERLIM, 0},
{"ppriind", CPX_PARAM_PPRIIND, 0},
{"preind", CPX_PARAM_PREIND, 0},
{"reinv", CPX_PARAM_REINV, 0},
{"reverseind", CPX_PARAM_REVERSEIND, 0},
{"rfilemul", CPX_PARAM_RFILEMUL, 0},
{"scaind", CPX_PARAM_SCAIND, 0},
{"scrind", CPX_PARAM_SCRIND, 0},
{"singlim", CPX_PARAM_SINGLIM, 0},
{"singtol", CPX_PARAM_SINGTOL, 0},
{"tilim", CPX_PARAM_TILIM, 1},
{"xxxind", CPX_PARAM_XXXIND, 0},
{"predual", CPX_PARAM_PREDUAL, 0},
{"epopt_h", CPX_PARAM_EPOPT_H, 0},
{"eprhs_h", CPX_PARAM_EPRHS_H, 0},
{"prepass", CPX_PARAM_PREPASS, 0},
{"datacheck", CPX_PARAM_DATACHECK, 0},
{"reduce", CPX_PARAM_REDUCE, 0},
{"prelinear", CPX_PARAM_PRELINEAR, 0},
{"lpmethod", CPX_PARAM_LPMETHOD, 0},
{"qpmethod", CPX_PARAM_QPMETHOD, 0},
{"workdir", CPX_PARAM_WORKDIR, 2},
{"workmem", CPX_PARAM_WORKMEM, 1},
{"threads", CPX_PARAM_THREADS, 0},
{"conflictdisplay", CPX_PARAM_CONFLICTDISPLAY, 0},
{"siftdisplay", CPX_PARAM_SIFTDISPLAY, 0},
{"siftalg", CPX_PARAM_SIFTALG, 0},
{"siftitlim", CPX_PARAM_SIFTITLIM, 0},
{"mpslongnum", CPX_PARAM_MPSLONGNUM, 0},
{"memoryemphasis", CPX_PARAM_MEMORYEMPHASIS, 0},
{"numericalemphasis", CPX_PARAM_NUMERICALEMPHASIS, 0},
{"feasoptmode", CPX_PARAM_FEASOPTMODE, 0},
{"parallelmode", CPX_PARAM_PARALLELMODE, 0},
{"tuningmeasure", CPX_PARAM_TUNINGMEASURE, 0},
{"tuningrepeat", CPX_PARAM_TUNINGREPEAT, 0},
{"tuningtilim", CPX_PARAM_TUNINGTILIM, 1},
{"tuningdisplay", CPX_PARAM_TUNINGDISPLAY, 0},
{"writelevel", CPX_PARAM_WRITELEVEL, 0},
{"bardstart", CPX_PARAM_BARDSTART, 0},
{"barepcomp", CPX_PARAM_BAREPCOMP, 1},
{"bargrowth", CPX_PARAM_BARGROWTH, 1},
{"barobjrng", CPX_PARAM_BAROBJRNG, 1},
{"barpstart", CPX_PARAM_BARPSTART, 0},
{"baralg", CPX_PARAM_BARALG, 0},
{"barcolnz", CPX_PARAM_BARCOLNZ, 0},
{"bardisplay", CPX_PARAM_BARDISPLAY, 0},
{"baritlim", CPX_PARAM_BARITLIM, 0},
{"barmaxcor", CPX_PARAM_BARMAXCOR, 0},
{"barorder", CPX_PARAM_BARORDER, 0},
{"barstartalg", CPX_PARAM_BARSTARTALG, 0},
{"barcrossalg", CPX_PARAM_BARCROSSALG, 0},
{"barqcpepcomp", CPX_PARAM_BARQCPEPCOMP, 1},
{"brdir", CPX_PARAM_BRDIR, 0},
{"bttol", CPX_PARAM_BTTOL, 1},
{"cliques", CPX_PARAM_CLIQUES, 0},
{"coeredind", CPX_PARAM_COEREDIND, 0},
{"covers", CPX_PARAM_COVERS, 0},
{"cutlo", CPX_PARAM_CUTLO, 1},
{"cutup", CPX_PARAM_CUTUP, 1},
{"epagap", CPX_PARAM_EPAGAP, 1},
{"epgap", CPX_PARAM_EPGAP, 1},
{"epint", CPX_PARAM_EPINT, 1},
{"mipdisplay", CPX_PARAM_MIPDISPLAY, 0},
{"mipinterval", CPX_PARAM_MIPINTERVAL, 0},
{"intsollim", CPX_PARAM_INTSOLLIM, 0},
{"nodefileind", CPX_PARAM_NODEFILEIND, 0},
{"nodelim", CPX_PARAM_NODELIM, 0},
{"nodesel", CPX_PARAM_NODESEL, 0},
{"objdif", CPX_PARAM_OBJDIF, 1},
{"mipordind", CPX_PARAM_MIPORDIND, 0},
{"relobjdif", CPX_PARAM_RELOBJDIF, 1},
{"startalg", CPX_PARAM_STARTALG, 0},
{"subalg", CPX_PARAM_SUBALG, 0},
{"trelim", CPX_PARAM_TRELIM, 1},
{"varsel", CPX_PARAM_VARSEL, 0},
{"bndstrenind", CPX_PARAM_BNDSTRENIND, 0},
{"heurfreq", CPX_PARAM_HEURFREQ, 0},
{"mipordtype", CPX_PARAM_MIPORDTYPE, 0},
{"cutsfactor", CPX_PARAM_CUTSFACTOR, 1},
{"relaxpreind", CPX_PARAM_RELAXPREIND, 0},
{"preslvnd", CPX_PARAM_PRESLVND, 0},
{"bbinterval", CPX_PARAM_BBINTERVAL, 0},
{"flowcovers", CPX_PARAM_FLOWCOVERS, 0},
{"implbd", CPX_PARAM_IMPLBD, 0},
{"probe", CPX_PARAM_PROBE, 0},
{"gubcovers", CPX_PARAM_GUBCOVERS, 0},
{"strongcandlim", CPX_PARAM_STRONGCANDLIM, 0},
{"strongitlim", CPX_PARAM_STRONGITLIM, 0},
{"fraccand", CPX_PARAM_FRACCAND, 0},
{"fraccuts", CPX_PARAM_FRACCUTS, 0},
{"fracpass", CPX_PARAM_FRACPASS, 0},
{"flowpaths", CPX_PARAM_FLOWPATHS, 0},
{"mircuts", CPX_PARAM_MIRCUTS, 0},
{"disjcuts", CPX_PARAM_DISJCUTS, 0},
{"aggcutlim", CPX_PARAM_AGGCUTLIM, 0},
{"mipcbredlp", CPX_PARAM_MIPCBREDLP, 0},
{"cutpass", CPX_PARAM_CUTPASS, 0},
{"mipemphasis", CPX_PARAM_MIPEMPHASIS, 0},
{"symmetry", CPX_PARAM_SYMMETRY, 0},
{"divetype", CPX_PARAM_DIVETYPE, 0},
{"rinsheur", CPX_PARAM_RINSHEUR, 0},
{"submipnodelim", CPX_PARAM_SUBMIPNODELIM, 0},
{"lbheur", CPX_PARAM_LBHEUR, 0},
{"repeatpresolve", CPX_PARAM_REPEATPRESOLVE, 0},
{"probetime", CPX_PARAM_PROBETIME, 1},
{"polishtime", CPX_PARAM_POLISHTIME, 1},
{"repairtries", CPX_PARAM_REPAIRTRIES, 0},
{"eplin", CPX_PARAM_EPLIN, 1},
{"eprelax", CPX_PARAM_EPRELAX, 1},
{"fpheur", CPX_PARAM_FPHEUR, 0},
{"eachcutlim", CPX_PARAM_EACHCUTLIM, 0},
{"solnpoolcapacity", CPX_PARAM_SOLNPOOLCAPACITY, 0},
{"solnpoolreplace", CPX_PARAM_SOLNPOOLREPLACE, 0},
{"solnpoolgap", CPX_PARAM_SOLNPOOLGAP, 1},
{"solnpoolagap", CPX_PARAM_SOLNPOOLAGAP, 1},
{"solnpoolintensity", CPX_PARAM_SOLNPOOLINTENSITY, 0},
{"populatelim", CPX_PARAM_POPULATELIM, 0},
{"mipsearch", CPX_PARAM_MIPSEARCH, 0},
{"miqcpstrat", CPX_PARAM_MIQCPSTRAT, 0},
{"zerohalfcuts", CPX_PARAM_ZEROHALFCUTS, 0},
{"polishafterepagap", CPX_PARAM_POLISHAFTEREPAGAP, 1},
{"polishafterepgap", CPX_PARAM_POLISHAFTEREPGAP, 1},
{"polishafternode", CPX_PARAM_POLISHAFTERNODE, 0},
{"polishafterintsol", CPX_PARAM_POLISHAFTERINTSOL, 0},
{"polishaftertime", CPX_PARAM_POLISHAFTERTIME, 1},
{"mcfcuts", CPX_PARAM_MCFCUTS, 0},
{"netitlim", CPX_PARAM_NETITLIM, 0},
{"netepopt", CPX_PARAM_NETEPOPT, 1},
{"neteprhs", CPX_PARAM_NETEPRHS, 1},
{"netppriind", CPX_PARAM_NETPPRIIND, 0},
{"netdisplay", CPX_PARAM_NETDISPLAY, 0},
{"qpnzreadlim", CPX_PARAM_QPNZREADLIM, 0},
{"qpmakepsdind", CPX_PARAM_QPMAKEPSDIND, 0},

#elif (XPRESS==13)

#define NUMPARAMS 105
static struct param_desc params[NUMPARAMS+NUMALIASES] = {
{"mpsrhsname", XPRS_MPSRHSNAME, 2},
{"mpsobjname", XPRS_MPSOBJNAME, 2},
{"mpsrangename", XPRS_MPSRANGENAME, 2},
{"mpsboundname", XPRS_MPSBOUNDNAME, 2},
{"outputmask", XPRS_OUTPUTMASK, 2},
{"omnidataname", XPRS_OMNIDATANAME, 2},
{"matrixtol", XPRS_MATRIXTOL, 1},
{"pivottol", XPRS_PIVOTTOL, 1},
{"feastol", XPRS_FEASTOL, 1},
{"outputtol", XPRS_OUTPUTTOL, 1},
{"sosreftol", XPRS_SOSREFTOL, 1},
{"optimalitytol", XPRS_OPTIMALITYTOL, 1},
{"etatol", XPRS_ETATOL, 1},
{"relpivottol", XPRS_RELPIVOTTOL, 1},
{"miptol", XPRS_MIPTOL, 1},
{"degradefactor", XPRS_DEGRADEFACTOR, 1},
{"miptarget", XPRS_MIPTARGET, 1},
{"mipaddcutoff", XPRS_MIPADDCUTOFF, 1},
{"mipabscutoff", XPRS_MIPABSCUTOFF, 1},
{"miprelcutoff", XPRS_MIPRELCUTOFF, 1},
{"pseudocost", XPRS_PSEUDOCOST, 1},
{"penalty", XPRS_PENALTY, 1},
{"bigm", XPRS_BIGM, 1},
{"mipabsstop", XPRS_MIPABSSTOP, 1},
{"miprelstop", XPRS_MIPRELSTOP, 1},
{"choleskytol", XPRS_CHOLESKYTOL, 1},
{"bargapstop", XPRS_BARGAPSTOP, 1},
{"bardualstop", XPRS_BARDUALSTOP, 1},
{"barprimalstop", XPRS_BARPRIMALSTOP, 1},
{"barstepstop", XPRS_BARSTEPSTOP, 1},
{"elimtol", XPRS_ELIMTOL, 1},
{"perturb", XPRS_PERTURB, 1},
{"markowitztol", XPRS_MARKOWITZTOL, 1},
{"recsteplength", XPRS_RECSTEPLENGTH, 1},
{"recexpand", XPRS_RECEXPAND, 1},
{"recshrink", XPRS_RECSHRINK, 1},
{"recstop", XPRS_RECSTOP, 1},
{"ppfactor", XPRS_PPFACTOR, 1},
{"extrarows", XPRS_EXTRAROWS, 0},
{"extracols", XPRS_EXTRACOLS, 0},
{"extraelems", XPRS_EXTRAELEMS, 0},
{"lpiterlimit", XPRS_LPITERLIMIT, 0},
{"lplog", XPRS_LPLOG, 0},
{"scaling", XPRS_SCALING, 0},
{"presolve", XPRS_PRESOLVE, 0},
{"crash", XPRS_CRASH, 0},
{"pricingalg", XPRS_PRICINGALG, 0},
{"invertfreq", XPRS_INVERTFREQ, 0},
{"invertmin", XPRS_INVERTMIN, 0},
{"maxnode", XPRS_MAXNODE, 0},
{"maxtime", XPRS_MAXTIME, 0},
{"maxmipsol", XPRS_MAXMIPSOL, 0},
{"keepmipsol", XPRS_KEEPMIPSOL, 0},
{"defaultalg", XPRS_DEFAULTALG, 0},
{"varselection", XPRS_VARSELECTION, 0},
{"nodeselection", XPRS_NODESELECTION, 0},
{"backtrack", XPRS_BACKTRACK, 0},
{"miplog", XPRS_MIPLOG, 0},
{"mpserrignore", XPRS_MPSERRIGNORE, 0},
{"keepnrows", XPRS_KEEPNROWS, 0},
{"mpsecho", XPRS_MPSECHO, 0},
{"maxpagelines", XPRS_MAXPAGELINES, 0},
{"outputlog", XPRS_OUTPUTLOG, 0},
{"extrapresolve", XPRS_EXTRAPRESOLVE, 0},
{"cpmaxcuts", XPRS_CPMAXCUTS, 0},
{"cpmaxelems", XPRS_CPMAXELEMS, 0},
{"cpkeepallcuts", XPRS_CPKEEPALLCUTS, 0},
{"cachesize", XPRS_CACHESIZE, 0},
{"crossover", XPRS_CROSSOVER, 0},
{"bariterlimit", XPRS_BARITERLIMIT, 0},
{"choleskyalg", XPRS_CHOLESKYALG, 0},
{"baroutput", XPRS_BAROUTPUT, 0},
{"cstyle", XPRS_CSTYLE, 0},
{"extramipents", XPRS_EXTRAMIPENTS, 0},
{"refactor", XPRS_REFACTOR, 0},
{"barthreads", XPRS_BARTHREADS, 0},
{"keepbasis", XPRS_KEEPBASIS, 0},
{"omniformat", XPRS_OMNIFORMAT, 0},
{"version", XPRS_VERSION, 0},
{"recmaxpasses", XPRS_RECMAXPASSES, 0},
{"bigmmethod", XPRS_BIGMMETHOD, 0},
{"rel10style", XPRS_REL10STYLE, 0},
{"mpsnamelength", XPRS_MPSNAMELENGTH, 0},
{"solutionfile", XPRS_SOLUTIONFILE, 0},
{"presolveops", XPRS_PRESOLVEOPS, 0},
{"mippresolve", XPRS_MIPPRESOLVE, 0},
{"maxslave", XPRS_MAXSLAVE, 0},
{"barorder", XPRS_BARORDER, 0},
{"breadthfirst", XPRS_BREADTHFIRST, 0},
{"autoperturb", XPRS_AUTOPERTURB, 0},
{"densecollimit", XPRS_DENSECOLLIMIT, 0},
{"cutfreq", XPRS_CUTFREQ, 0},
{"trace", XPRS_TRACE, 0},
{"maxiis", XPRS_MAXIIS, 0},
{"cputime", XPRS_CPUTIME, 0},
{"covercuts", XPRS_COVERCUTS, 0},
{"gomcuts", XPRS_GOMCUTS, 0},
{"mpsformat", XPRS_MPSFORMAT, 0},
{"cutstrategy", XPRS_CUTSTRATEGY, 0},
{"cutdepth", XPRS_CUTDEPTH, 0},
{"treecovercuts", XPRS_TREECOVERCUTS, 0},
{"treegomcuts", XPRS_TREEGOMCUTS, 0},
{"barmemory", XPRS_BARMEMORY, 0},
/*{"dualgradient", XPRS_DUALGRADIENT, 0}, not in 13.10 */
{"sbiterlimit", XPRS_SBITERLIMIT, 0},
{"sbbest", XPRS_SBBEST, 0},

#elif (XPRESS==14)

#define NUMPARAMS 109
static struct param_desc params[NUMPARAMS+NUMALIASES] = {
{"mpsrhsname", XPRS_MPSRHSNAME, 2},
{"mpsobjname", XPRS_MPSOBJNAME, 2},
{"mpsrangename", XPRS_MPSRANGENAME, 2},
{"mpsboundname", XPRS_MPSBOUNDNAME, 2},
{"outputmask", XPRS_OUTPUTMASK, 2},
{"omnidataname", XPRS_OMNIDATANAME, 2},
{"matrixtol", XPRS_MATRIXTOL, 1},
{"pivottol", XPRS_PIVOTTOL, 1},
{"feastol", XPRS_FEASTOL, 1},
{"outputtol", XPRS_OUTPUTTOL, 1},
{"sosreftol", XPRS_SOSREFTOL, 1},
{"optimalitytol", XPRS_OPTIMALITYTOL, 1},
{"etatol", XPRS_ETATOL, 1},
{"relpivottol", XPRS_RELPIVOTTOL, 1},
{"miptol", XPRS_MIPTOL, 1},
{"degradefactor", XPRS_DEGRADEFACTOR, 1},
{"miptarget", XPRS_MIPTARGET, 1},
{"mipaddcutoff", XPRS_MIPADDCUTOFF, 1},
{"mipabscutoff", XPRS_MIPABSCUTOFF, 1},
{"miprelcutoff", XPRS_MIPRELCUTOFF, 1},
{"pseudocost", XPRS_PSEUDOCOST, 1},
{"penalty", XPRS_PENALTY, 1},
{"bigm", XPRS_BIGM, 1},
{"mipabsstop", XPRS_MIPABSSTOP, 1},
{"miprelstop", XPRS_MIPRELSTOP, 1},
{"choleskytol", XPRS_CHOLESKYTOL, 1},
{"bargapstop", XPRS_BARGAPSTOP, 1},
{"bardualstop", XPRS_BARDUALSTOP, 1},
{"barprimalstop", XPRS_BARPRIMALSTOP, 1},
{"barstepstop", XPRS_BARSTEPSTOP, 1},
{"elimtol", XPRS_ELIMTOL, 1},
{"perturb", XPRS_PERTURB, 1},
{"markowitztol", XPRS_MARKOWITZTOL, 1},
{"ppfactor", XPRS_PPFACTOR, 1},
{"extrarows", XPRS_EXTRAROWS, 0},
{"extracols", XPRS_EXTRACOLS, 0},
{"extraelems", XPRS_EXTRAELEMS, 0},
{"lpiterlimit", XPRS_LPITERLIMIT, 0},
{"lplog", XPRS_LPLOG, 0},
{"scaling", XPRS_SCALING, 0},
{"presolve", XPRS_PRESOLVE, 0},
{"crash", XPRS_CRASH, 0},
{"pricingalg", XPRS_PRICINGALG, 0},
{"invertfreq", XPRS_INVERTFREQ, 0},
{"invertmin", XPRS_INVERTMIN, 0},
{"maxnode", XPRS_MAXNODE, 0},
{"maxtime", XPRS_MAXTIME, 0},
{"maxmipsol", XPRS_MAXMIPSOL, 0},
{"keepmipsol", XPRS_KEEPMIPSOL, 0},
{"defaultalg", XPRS_DEFAULTALG, 0},
{"varselection", XPRS_VARSELECTION, 0},
{"nodeselection", XPRS_NODESELECTION, 0},
{"backtrack", XPRS_BACKTRACK, 0},
{"miplog", XPRS_MIPLOG, 0},
{"mpserrignore", XPRS_MPSERRIGNORE, 0},
{"keepnrows", XPRS_KEEPNROWS, 0},
{"mpsecho", XPRS_MPSECHO, 0},
{"maxpagelines", XPRS_MAXPAGELINES, 0},
{"outputlog", XPRS_OUTPUTLOG, 0},
{"extrapresolve", XPRS_EXTRAPRESOLVE, 0},
{"cpmaxcuts", XPRS_CPMAXCUTS, 0},
{"cpmaxelems", XPRS_CPMAXELEMS, 0},
{"cpkeepallcuts", XPRS_CPKEEPALLCUTS, 0},
{"cachesize", XPRS_CACHESIZE, 0},
{"crossover", XPRS_CROSSOVER, 0},
{"bariterlimit", XPRS_BARITERLIMIT, 0},
{"choleskyalg", XPRS_CHOLESKYALG, 0},
{"baroutput", XPRS_BAROUTPUT, 0},
{"cstyle", XPRS_CSTYLE, 0},
{"extramipents", XPRS_EXTRAMIPENTS, 0},
{"refactor", XPRS_REFACTOR, 0},
{"barthreads", XPRS_BARTHREADS, 0},
{"keepbasis", XPRS_KEEPBASIS, 0},
{"omniformat", XPRS_OMNIFORMAT, 0},
{"version", XPRS_VERSION, 0},
{"bigmmethod", XPRS_BIGMMETHOD, 0},
{"rel10style", XPRS_REL10STYLE, 0},
{"mpsnamelength", XPRS_MPSNAMELENGTH, 0},
{"solutionfile", XPRS_SOLUTIONFILE, 0},
{"presolveops", XPRS_PRESOLVEOPS, 0},
{"mippresolve", XPRS_MIPPRESOLVE, 0},
{"maxslave", XPRS_MAXSLAVE, 0},
{"barorder", XPRS_BARORDER, 0},
{"breadthfirst", XPRS_BREADTHFIRST, 0},
{"autoperturb", XPRS_AUTOPERTURB, 0},
{"densecollimit", XPRS_DENSECOLLIMIT, 0},
{"cutfreq", XPRS_CUTFREQ, 0},
{"trace", XPRS_TRACE, 0},
{"maxiis", XPRS_MAXIIS, 0},
{"cputime", XPRS_CPUTIME, 0},
{"covercuts", XPRS_COVERCUTS, 0},
{"gomcuts", XPRS_GOMCUTS, 0},
{"mpsformat", XPRS_MPSFORMAT, 0},
{"cutstrategy", XPRS_CUTSTRATEGY, 0},
{"cutdepth", XPRS_CUTDEPTH, 0},
{"treecovercuts", XPRS_TREECOVERCUTS, 0},
{"treegomcuts", XPRS_TREEGOMCUTS, 0},
{"barmemory", XPRS_BARMEMORY, 0},
{"dualgradient", XPRS_DUALGRADIENT, 0},
{"sbiterlimit", XPRS_SBITERLIMIT, 0},
{"sbbest", XPRS_SBBEST, 0},
{"maxcuttime", XPRS_MAXCUTTIME, 0},
{"activeset", XPRS_ACTIVESET, 0},
{"barindeflimit", XPRS_BARINDEFLIMIT, 0},
{"heurstrategy", XPRS_HEURSTRATEGY, 0},
{"heurfreq", XPRS_HEURFREQ, 0},
{"heurdepth", XPRS_HEURDEPTH, 0},
{"heurmaxsol", XPRS_HEURMAXSOL, 0},
{"heurnodes", XPRS_HEURNODES, 0},

#elif XPRESS==15

#define NUMPARAMS 114
static struct param_desc params[NUMPARAMS+NUMALIASES] = {
{"mpsrhsname", XPRS_MPSRHSNAME, 2},
{"mpsobjname", XPRS_MPSOBJNAME, 2},
{"mpsrangename", XPRS_MPSRANGENAME, 2},
{"mpsboundname", XPRS_MPSBOUNDNAME, 2},
{"outputmask", XPRS_OUTPUTMASK, 2},
{"omnidataname", XPRS_OMNIDATANAME, 2},
{"matrixtol", XPRS_MATRIXTOL, 1},
{"pivottol", XPRS_PIVOTTOL, 1},
{"feastol", XPRS_FEASTOL, 1},
{"outputtol", XPRS_OUTPUTTOL, 1},
{"sosreftol", XPRS_SOSREFTOL, 1},
{"optimalitytol", XPRS_OPTIMALITYTOL, 1},
{"etatol", XPRS_ETATOL, 1},
{"relpivottol", XPRS_RELPIVOTTOL, 1},
{"miptol", XPRS_MIPTOL, 1},
{"degradefactor", XPRS_DEGRADEFACTOR, 1},
{"miptarget", XPRS_MIPTARGET, 1},
{"mipaddcutoff", XPRS_MIPADDCUTOFF, 1},
{"mipabscutoff", XPRS_MIPABSCUTOFF, 1},
{"miprelcutoff", XPRS_MIPRELCUTOFF, 1},
{"pseudocost", XPRS_PSEUDOCOST, 1},
{"penalty", XPRS_PENALTY, 1},
{"bigm", XPRS_BIGM, 1},
{"mipabsstop", XPRS_MIPABSSTOP, 1},
{"miprelstop", XPRS_MIPRELSTOP, 1},
{"choleskytol", XPRS_CHOLESKYTOL, 1},
{"bargapstop", XPRS_BARGAPSTOP, 1},
{"bardualstop", XPRS_BARDUALSTOP, 1},
{"barprimalstop", XPRS_BARPRIMALSTOP, 1},
{"barstepstop", XPRS_BARSTEPSTOP, 1},
{"elimtol", XPRS_ELIMTOL, 1},
{"perturb", XPRS_PERTURB, 1},
{"markowitztol", XPRS_MARKOWITZTOL, 1},
{"ppfactor", XPRS_PPFACTOR, 1},
{"extrarows", XPRS_EXTRAROWS, 0},
{"extracols", XPRS_EXTRACOLS, 0},
{"extraelems", XPRS_EXTRAELEMS, 0},
{"lpiterlimit", XPRS_LPITERLIMIT, 0},
{"lplog", XPRS_LPLOG, 0},
{"scaling", XPRS_SCALING, 0},
{"presolve", XPRS_PRESOLVE, 0},
{"crash", XPRS_CRASH, 0},
{"pricingalg", XPRS_PRICINGALG, 0},
{"invertfreq", XPRS_INVERTFREQ, 0},
{"invertmin", XPRS_INVERTMIN, 0},
{"maxnode", XPRS_MAXNODE, 0},
{"maxtime", XPRS_MAXTIME, 0},
{"maxmipsol", XPRS_MAXMIPSOL, 0},
{"keepmipsol", XPRS_KEEPMIPSOL, 0},
{"defaultalg", XPRS_DEFAULTALG, 0},
{"varselection", XPRS_VARSELECTION, 0},
{"nodeselection", XPRS_NODESELECTION, 0},
{"backtrack", XPRS_BACKTRACK, 0},
{"miplog", XPRS_MIPLOG, 0},
{"mpserrignore", XPRS_MPSERRIGNORE, 0},
{"keepnrows", XPRS_KEEPNROWS, 0},
{"mpsecho", XPRS_MPSECHO, 0},
{"maxpagelines", XPRS_MAXPAGELINES, 0},
{"outputlog", XPRS_OUTPUTLOG, 0},
{"extrapresolve", XPRS_EXTRAPRESOLVE, 0},
{"cpmaxcuts", XPRS_CPMAXCUTS, 0},
{"cpmaxelems", XPRS_CPMAXELEMS, 0},
{"cpkeepallcuts", XPRS_CPKEEPALLCUTS, 0},
{"cachesize", XPRS_CACHESIZE, 0},
{"crossover", XPRS_CROSSOVER, 0},
{"bariterlimit", XPRS_BARITERLIMIT, 0},
{"choleskyalg", XPRS_CHOLESKYALG, 0},
{"baroutput", XPRS_BAROUTPUT, 0},
{"cstyle", XPRS_CSTYLE, 0},
{"extramipents", XPRS_EXTRAMIPENTS, 0},
{"refactor", XPRS_REFACTOR, 0},
{"barthreads", XPRS_BARTHREADS, 0},
{"keepbasis", XPRS_KEEPBASIS, 0},
{"omniformat", XPRS_OMNIFORMAT, 0},
{"version", XPRS_VERSION, 0},
{"bigmmethod", XPRS_BIGMMETHOD, 0},
{"rel10style", XPRS_REL10STYLE, 0},
{"mpsnamelength", XPRS_MPSNAMELENGTH, 0},
{"solutionfile", XPRS_SOLUTIONFILE, 0},
{"presolveops", XPRS_PRESOLVEOPS, 0},
{"mippresolve", XPRS_MIPPRESOLVE, 0},
{"maxslave", XPRS_MAXSLAVE, 0},
{"barorder", XPRS_BARORDER, 0},
{"breadthfirst", XPRS_BREADTHFIRST, 0},
{"autoperturb", XPRS_AUTOPERTURB, 0},
{"densecollimit", XPRS_DENSECOLLIMIT, 0},
{"cutfreq", XPRS_CUTFREQ, 0},
{"trace", XPRS_TRACE, 0},
{"maxiis", XPRS_MAXIIS, 0},
{"cputime", XPRS_CPUTIME, 0},
{"covercuts", XPRS_COVERCUTS, 0},
{"gomcuts", XPRS_GOMCUTS, 0},
{"mpsformat", XPRS_MPSFORMAT, 0},
{"cutstrategy", XPRS_CUTSTRATEGY, 0},
{"cutdepth", XPRS_CUTDEPTH, 0},
{"treecovercuts", XPRS_TREECOVERCUTS, 0},
{"treegomcuts", XPRS_TREEGOMCUTS, 0},
{"barmemory", XPRS_BARMEMORY, 0},
{"dualgradient", XPRS_DUALGRADIENT, 0},
{"sbiterlimit", XPRS_SBITERLIMIT, 0},
{"sbbest", XPRS_SBBEST, 0},
{"maxcuttime", XPRS_MAXCUTTIME, 0},
{"activeset", XPRS_ACTIVESET, 0},
{"barindeflimit", XPRS_BARINDEFLIMIT, 0},
{"heurstrategy", XPRS_HEURSTRATEGY, 0},
{"heurfreq", XPRS_HEURFREQ, 0},
{"heurdepth", XPRS_HEURDEPTH, 0},
{"heurmaxsol", XPRS_HEURMAXSOL, 0},
{"heurnodes", XPRS_HEURNODES, 0},
{"lnpbest", XPRS_LNPBEST, 0},
{"lnpiterlimit", XPRS_LNPITERLIMIT, 0},
{"branchchoice", XPRS_BRANCHCHOICE, 0},
{"sbselect", XPRS_SBSELECT, 0},
{"sbthreads", XPRS_SBTHREADS, 0},

#elif XPRESS==16

#define NUMPARAMS 115
static struct param_desc params[NUMPARAMS+NUMALIASES] = {
{"mpsrhsname", XPRS_MPSRHSNAME, 2},
{"mpsobjname", XPRS_MPSOBJNAME, 2},
{"mpsrangename", XPRS_MPSRANGENAME, 2},
{"mpsboundname", XPRS_MPSBOUNDNAME, 2},
{"outputmask", XPRS_OUTPUTMASK, 2},
{"omnidataname", XPRS_OMNIDATANAME, 2},
{"matrixtol", XPRS_MATRIXTOL, 1},
{"pivottol", XPRS_PIVOTTOL, 1},
{"feastol", XPRS_FEASTOL, 1},
{"outputtol", XPRS_OUTPUTTOL, 1},
{"sosreftol", XPRS_SOSREFTOL, 1},
{"optimalitytol", XPRS_OPTIMALITYTOL, 1},
{"etatol", XPRS_ETATOL, 1},
{"relpivottol", XPRS_RELPIVOTTOL, 1},
{"miptol", XPRS_MIPTOL, 1},
{"degradefactor", XPRS_DEGRADEFACTOR, 1},
{"miptarget", XPRS_MIPTARGET, 1},
{"mipaddcutoff", XPRS_MIPADDCUTOFF, 1},
{"mipabscutoff", XPRS_MIPABSCUTOFF, 1},
{"miprelcutoff", XPRS_MIPRELCUTOFF, 1},
{"pseudocost", XPRS_PSEUDOCOST, 1},
{"penalty", XPRS_PENALTY, 1},
{"bigm", XPRS_BIGM, 1},
{"mipabsstop", XPRS_MIPABSSTOP, 1},
{"miprelstop", XPRS_MIPRELSTOP, 1},
{"choleskytol", XPRS_CHOLESKYTOL, 1},
{"bargapstop", XPRS_BARGAPSTOP, 1},
{"bardualstop", XPRS_BARDUALSTOP, 1},
{"barprimalstop", XPRS_BARPRIMALSTOP, 1},
{"barstepstop", XPRS_BARSTEPSTOP, 1},
{"elimtol", XPRS_ELIMTOL, 1},
{"perturb", XPRS_PERTURB, 1},
{"markowitztol", XPRS_MARKOWITZTOL, 1},
{"ppfactor", XPRS_PPFACTOR, 1},
{"extrarows", XPRS_EXTRAROWS, 0},
{"extracols", XPRS_EXTRACOLS, 0},
{"extraelems", XPRS_EXTRAELEMS, 0},
{"lpiterlimit", XPRS_LPITERLIMIT, 0},
{"lplog", XPRS_LPLOG, 0},
{"scaling", XPRS_SCALING, 0},
{"presolve", XPRS_PRESOLVE, 0},
{"crash", XPRS_CRASH, 0},
{"pricingalg", XPRS_PRICINGALG, 0},
{"invertfreq", XPRS_INVERTFREQ, 0},
{"invertmin", XPRS_INVERTMIN, 0},
{"maxnode", XPRS_MAXNODE, 0},
{"maxtime", XPRS_MAXTIME, 0},
{"maxmipsol", XPRS_MAXMIPSOL, 0},
{"keepmipsol", XPRS_KEEPMIPSOL, 0},
{"defaultalg", XPRS_DEFAULTALG, 0},
{"varselection", XPRS_VARSELECTION, 0},
{"nodeselection", XPRS_NODESELECTION, 0},
{"backtrack", XPRS_BACKTRACK, 0},
{"miplog", XPRS_MIPLOG, 0},
{"mpserrignore", XPRS_MPSERRIGNORE, 0},
{"keepnrows", XPRS_KEEPNROWS, 0},
{"mpsecho", XPRS_MPSECHO, 0},
{"maxpagelines", XPRS_MAXPAGELINES, 0},
{"outputlog", XPRS_OUTPUTLOG, 0},
{"extrapresolve", XPRS_EXTRAPRESOLVE, 0},
{"cpmaxcuts", XPRS_CPMAXCUTS, 0},
{"cpmaxelems", XPRS_CPMAXELEMS, 0},
{"cpkeepallcuts", XPRS_CPKEEPALLCUTS, 0},
{"cachesize", XPRS_CACHESIZE, 0},
{"crossover", XPRS_CROSSOVER, 0},
{"bariterlimit", XPRS_BARITERLIMIT, 0},
{"choleskyalg", XPRS_CHOLESKYALG, 0},
{"baroutput", XPRS_BAROUTPUT, 0},
{"cstyle", XPRS_CSTYLE, 0},
{"extramipents", XPRS_EXTRAMIPENTS, 0},
{"refactor", XPRS_REFACTOR, 0},
{"barthreads", XPRS_BARTHREADS, 0},
{"keepbasis", XPRS_KEEPBASIS, 0},
{"omniformat", XPRS_OMNIFORMAT, 0},
{"version", XPRS_VERSION, 0},
{"bigmmethod", XPRS_BIGMMETHOD, 0},
{"rel10style", XPRS_REL10STYLE, 0},
{"mpsnamelength", XPRS_MPSNAMELENGTH, 0},
{"solutionfile", XPRS_SOLUTIONFILE, 0},
{"presolveops", XPRS_PRESOLVEOPS, 0},
{"mippresolve", XPRS_MIPPRESOLVE, 0},
{"mipthreads", XPRS_MIPTHREADS, 0},
{"barorder", XPRS_BARORDER, 0},
{"breadthfirst", XPRS_BREADTHFIRST, 0},
{"autoperturb", XPRS_AUTOPERTURB, 0},
{"densecollimit", XPRS_DENSECOLLIMIT, 0},
{"cutfreq", XPRS_CUTFREQ, 0},
{"trace", XPRS_TRACE, 0},
{"maxiis", XPRS_MAXIIS, 0},
{"cputime", XPRS_CPUTIME, 0},
{"covercuts", XPRS_COVERCUTS, 0},
{"gomcuts", XPRS_GOMCUTS, 0},
{"mpsformat", XPRS_MPSFORMAT, 0},
{"cutstrategy", XPRS_CUTSTRATEGY, 0},
{"cutdepth", XPRS_CUTDEPTH, 0},
{"treecovercuts", XPRS_TREECOVERCUTS, 0},
{"treegomcuts", XPRS_TREEGOMCUTS, 0},
{"dualgradient", XPRS_DUALGRADIENT, 0},
{"sbiterlimit", XPRS_SBITERLIMIT, 0},
{"sbbest", XPRS_SBBEST, 0},
{"maxcuttime", XPRS_MAXCUTTIME, 0},
{"activeset", XPRS_ACTIVESET, 0},
{"barindeflimit", XPRS_BARINDEFLIMIT, 0},
{"heurstrategy", XPRS_HEURSTRATEGY, 0},
{"heurfreq", XPRS_HEURFREQ, 0},
{"heurdepth", XPRS_HEURDEPTH, 0},
{"heurmaxsol", XPRS_HEURMAXSOL, 0},
{"heurnodes", XPRS_HEURNODES, 0},
{"lnpbest", XPRS_LNPBEST, 0},
{"lnpiterlimit", XPRS_LNPITERLIMIT, 0},
{"branchchoice", XPRS_BRANCHCHOICE, 0},
{"sbselect", XPRS_SBSELECT, 0},
{"sbthreads", XPRS_SBTHREADS, 0},
{"heurdivestrategy", XPRS_HEURDIVESTRATEGY, 0},
{"heurselect", XPRS_HEURSELECT, 0},

#elif XPRESS==20

#define NUMPARAMS 164
static struct param_desc params[NUMPARAMS+NUMALIASES] = {
{"mpsrhsname", XPRS_MPSRHSNAME, 2},
{"mpsobjname", XPRS_MPSOBJNAME, 2},
{"mpsrangename", XPRS_MPSRANGENAME, 2},
{"mpsboundname", XPRS_MPSBOUNDNAME, 2},
{"outputmask", XPRS_OUTPUTMASK, 2},
{"matrixtol", XPRS_MATRIXTOL, 1},
{"pivottol", XPRS_PIVOTTOL, 1},
{"feastol", XPRS_FEASTOL, 1},
{"outputtol", XPRS_OUTPUTTOL, 1},
{"sosreftol", XPRS_SOSREFTOL, 1},
{"optimalitytol", XPRS_OPTIMALITYTOL, 1},
{"etatol", XPRS_ETATOL, 1},
{"relpivottol", XPRS_RELPIVOTTOL, 1},
{"miptol", XPRS_MIPTOL, 1},
{"degradefactor", XPRS_DEGRADEFACTOR, 1},
{"miptarget", XPRS_MIPTARGET, 1},
{"mipaddcutoff", XPRS_MIPADDCUTOFF, 1},
{"mipabscutoff", XPRS_MIPABSCUTOFF, 1},
{"miprelcutoff", XPRS_MIPRELCUTOFF, 1},
{"pseudocost", XPRS_PSEUDOCOST, 1},
{"penalty", XPRS_PENALTY, 1},
{"bigm", XPRS_BIGM, 1},
{"mipabsstop", XPRS_MIPABSSTOP, 1},
{"miprelstop", XPRS_MIPRELSTOP, 1},
{"choleskytol", XPRS_CHOLESKYTOL, 1},
{"bargapstop", XPRS_BARGAPSTOP, 1},
{"bardualstop", XPRS_BARDUALSTOP, 1},
{"barprimalstop", XPRS_BARPRIMALSTOP, 1},
{"barstepstop", XPRS_BARSTEPSTOP, 1},
{"elimtol", XPRS_ELIMTOL, 1},
{"perturb", XPRS_PERTURB, 1},
{"markowitztol", XPRS_MARKOWITZTOL, 1},
{"ppfactor", XPRS_PPFACTOR, 1},
{"sbeffort", XPRS_SBEFFORT, 1},
{"heurdiverandomize", XPRS_HEURDIVERANDOMIZE, 1},
{"heursearcheffort", XPRS_HEURSEARCHEFFORT, 1},
{"cutfactor", XPRS_CUTFACTOR, 1},
{"eigenvaluetol", XPRS_EIGENVALUETOL, 1},
{"indlinbigm", XPRS_INDLINBIGM, 1},
{"treememorysavingtarget", XPRS_TREEMEMORYSAVINGTARGET, 1},
{"globalfilebias", XPRS_GLOBALFILEBIAS, 1},
{"extrarows", XPRS_EXTRAROWS, 0},
{"extracols", XPRS_EXTRACOLS, 0},
{"extraelems", XPRS_EXTRAELEMS, 0},
{"lpiterlimit", XPRS_LPITERLIMIT, 0},
{"lplog", XPRS_LPLOG, 0},
{"scaling", XPRS_SCALING, 0},
{"presolve", XPRS_PRESOLVE, 0},
{"crash", XPRS_CRASH, 0},
{"pricingalg", XPRS_PRICINGALG, 0},
{"invertfreq", XPRS_INVERTFREQ, 0},
{"invertmin", XPRS_INVERTMIN, 0},
{"maxnode", XPRS_MAXNODE, 0},
{"maxtime", XPRS_MAXTIME, 0},
{"maxmipsol", XPRS_MAXMIPSOL, 0},
{"keepmipsol", XPRS_KEEPMIPSOL, 0},
{"defaultalg", XPRS_DEFAULTALG, 0},
{"varselection", XPRS_VARSELECTION, 0},
{"nodeselection", XPRS_NODESELECTION, 0},
{"backtrack", XPRS_BACKTRACK, 0},
{"miplog", XPRS_MIPLOG, 0},
{"keepnrows", XPRS_KEEPNROWS, 0},
{"mpsecho", XPRS_MPSECHO, 0},
{"maxpagelines", XPRS_MAXPAGELINES, 0},
{"outputlog", XPRS_OUTPUTLOG, 0},
{"extrapresolve", XPRS_EXTRAPRESOLVE, 0},
{"cachesize", XPRS_CACHESIZE, 0},
{"crossover", XPRS_CROSSOVER, 0},
{"bariterlimit", XPRS_BARITERLIMIT, 0},
{"choleskyalg", XPRS_CHOLESKYALG, 0},
{"baroutput", XPRS_BAROUTPUT, 0},
{"cstyle", XPRS_CSTYLE, 0},
{"extramipents", XPRS_EXTRAMIPENTS, 0},
{"refactor", XPRS_REFACTOR, 0},
{"barthreads", XPRS_BARTHREADS, 0},
{"keepbasis", XPRS_KEEPBASIS, 0},
{"version", XPRS_VERSION, 0},
{"bigmmethod", XPRS_BIGMMETHOD, 0},
{"mpsnamelength", XPRS_MPSNAMELENGTH, 0},
{"solutionfile", XPRS_SOLUTIONFILE, 0},
{"presolveops", XPRS_PRESOLVEOPS, 0},
{"mippresolve", XPRS_MIPPRESOLVE, 0},
{"mipthreads", XPRS_MIPTHREADS, 0},
{"barorder", XPRS_BARORDER, 0},
{"breadthfirst", XPRS_BREADTHFIRST, 0},
{"autoperturb", XPRS_AUTOPERTURB, 0},
{"densecollimit", XPRS_DENSECOLLIMIT, 0},
{"cutfreq", XPRS_CUTFREQ, 0},
{"trace", XPRS_TRACE, 0},
{"maxiis", XPRS_MAXIIS, 0},
{"cputime", XPRS_CPUTIME, 0},
{"covercuts", XPRS_COVERCUTS, 0},
{"gomcuts", XPRS_GOMCUTS, 0},
{"mpsformat", XPRS_MPSFORMAT, 0},
{"cutstrategy", XPRS_CUTSTRATEGY, 0},
{"cutdepth", XPRS_CUTDEPTH, 0},
{"treecovercuts", XPRS_TREECOVERCUTS, 0},
{"treegomcuts", XPRS_TREEGOMCUTS, 0},
{"cutselect", XPRS_CUTSELECT, 0},
{"treecutselect", XPRS_TREECUTSELECT, 0},
{"dualize", XPRS_DUALIZE, 0},
{"dualgradient", XPRS_DUALGRADIENT, 0},
{"sbiterlimit", XPRS_SBITERLIMIT, 0},
{"sbbest", XPRS_SBBEST, 0},
{"maxcuttime", XPRS_MAXCUTTIME, 0},
{"activeset", XPRS_ACTIVESET, 0},
{"barindeflimit", XPRS_BARINDEFLIMIT, 0},
{"heurstrategy", XPRS_HEURSTRATEGY, 0},
{"heurfreq", XPRS_HEURFREQ, 0},
{"heurdepth", XPRS_HEURDEPTH, 0},
{"heurmaxsol", XPRS_HEURMAXSOL, 0},
{"heurnodes", XPRS_HEURNODES, 0},
{"lnpbest", XPRS_LNPBEST, 0},
{"lnpiterlimit", XPRS_LNPITERLIMIT, 0},
{"branchchoice", XPRS_BRANCHCHOICE, 0},
{"sbselect", XPRS_SBSELECT, 0},
{"localchoice", XPRS_LOCALCHOICE, 0},
{"localbacktrack", XPRS_LOCALBACKTRACK, 0},
{"dualstrategy", XPRS_DUALSTRATEGY, 0},
{"l1cache", XPRS_L1CACHE, 0},
{"heurdivestrategy", XPRS_HEURDIVESTRATEGY, 0},
{"heurselect", XPRS_HEURSELECT, 0},
{"extrasets", XPRS_EXTRASETS, 0},
{"extrasetelems", XPRS_EXTRASETELEMS, 0},
{"feasibilitypump", XPRS_FEASIBILITYPUMP, 0},
{"precoefelim", XPRS_PRECOEFELIM, 0},
{"predomcol", XPRS_PREDOMCOL, 0},
{"heursearchfreq", XPRS_HEURSEARCHFREQ, 0},
{"heurdivespeedup", XPRS_HEURDIVESPEEDUP, 0},
{"sbestimate", XPRS_SBESTIMATE, 0},
{"historycosts", XPRS_HISTORYCOSTS, 0},
{"algaftercrossover", XPRS_ALGAFTERCROSSOVER, 0},
{"linelength", XPRS_LINELENGTH, 0},
{"mutexcallbacks", XPRS_MUTEXCALLBACKS, 0},
{"barcrash", XPRS_BARCRASH, 0},
{"heursearchrootselect", XPRS_HEURSEARCHROOTSELECT, 0},
{"heursearchtreeselect", XPRS_HEURSEARCHTREESELECT, 0},
{"mps18compatible", XPRS_MPS18COMPATIBLE, 0},
{"rootpresolve", XPRS_ROOTPRESOLVE, 0},
{"crossoverdrp", XPRS_CROSSOVERDRP, 0},
{"forceoutput", XPRS_FORCEOUTPUT, 0},
{"deterministic", XPRS_DETERMINISTIC, 0},
{"preprobing", XPRS_PREPROBING, 0},
{"extraqcelements", XPRS_EXTRAQCELEMENTS, 0},
{"extraqcrows", XPRS_EXTRAQCROWS, 0},
{"treememorylimit", XPRS_TREEMEMORYLIMIT, 0},
{"treecompression", XPRS_TREECOMPRESSION, 0},
{"treediagnostics", XPRS_TREEDIAGNOSTICS, 0},
{"maxglobalfilesize", XPRS_MAXGLOBALFILESIZE, 0},
{"tempbounds", XPRS_TEMPBOUNDS, 0},
{"ifcheckconvexity", XPRS_IFCHECKCONVEXITY, 0},
{"primalunshift", XPRS_PRIMALUNSHIFT, 0},
{"repairindefiniteq", XPRS_REPAIRINDEFINITEQ, 0},
{"maxlocalbacktrack", XPRS_MAXLOCALBACKTRACK, 0},
{"backtracktie", XPRS_BACKTRACKTIE, 0},
{"branchdisj", XPRS_BRANCHDISJ, 0},
{"lpthreads", XPRS_LPTHREADS, 0},
{"maxscalefactor", XPRS_MAXSCALEFACTOR, 0},
{"heurthreads", XPRS_HEURTHREADS, 0},
{"threads", XPRS_THREADS, 0},
{"predomrow", XPRS_PREDOMROW, 0},
{"branchstructural", XPRS_BRANCHSTRUCTURAL, 0},
{"quadraticunshift", XPRS_QUADRATICUNSHIFT, 0},
{"barpresolveops", XPRS_BARPRESOLVEOPS, 0},

#elif defined(COIN)

#define NUMPARAMS 14

/* these are taken from OsiSolverParameters.hpp */
#define OsiProbName 			0
#define OsiSolverName 			1
#define OsiDualObjectiveLimit 		0
#define OsiPrimallObjectiveLimit 	1
#define OsiDualTolerance 		2
#define OsiPrimalTolerance 		3
#define OsiMaxNumIteration 		0
#define OsiMaxNumIterationHotStart 	1
/* Solver dependent parameters - these define the positions in the arrays
   that maps to the corresponding actual paramters of the solver
   (e.g. cbc_iparam[] and cbc_dparam[]) in coinplex.cpp
*/
#define SolverMaxNumNode		0
#define SolverMaxNumSol			1
#define SolverIntegerTolerance		0
#define SolverAllowableGap		1
#define SolverAllowableFractionGap	2
#define SolverCutoffIncrement		3

static struct param_desc params[NUMPARAMS+NUMALIASES] = {
{"probname", OsiProbName, 2},
{"solvername", OsiSolverName, 2},
{"dualobjectivelimit", OsiDualObjectiveLimit, 1},
{"prinmalobjectivelimit", OsiPrimallObjectiveLimit, 1},
{"dualtolerance", OsiDualTolerance, 1},
{"primaltolerance", OsiPrimalTolerance, 1},
{"maxnumiteration", OsiMaxNumIteration, 0},
{"maxnumiterationhotstart", OsiMaxNumIterationHotStart, 0},
/* the following are solver dependent (i.e. non-OSI)
*/
{"node_limit", SolverMaxNumNode,  3},
{"solution_limit", SolverMaxNumSol, 3},
{"integrality", SolverIntegerTolerance, 4},
{"absmipgap", SolverAllowableGap, 4},
{"mipgap", SolverAllowableFractionGap, 4},
{"objdifference", SolverCutoffIncrement, 4},

#else

No parameter data for this version!!!

#endif


/*
 * Add some version-independent aliases to the table
 * This must remain at the end of the file!!!
 * If you add lines here, update NUMALIASES above!
 */

#ifdef CPLEX

/* NUMALIASES lines follow */
{"timelimit", CPX_PARAM_TILIM, 1},
{"time_limit", CPX_PARAM_TILIM, 1},
{"perturbation_const", CPX_PARAM_EPPER, 1},
{"lowerobj_limit", CPX_PARAM_OBJLLIM, 1},
{"upperobj_limit", CPX_PARAM_OBJULIM, 1},
{"feasibility_tol", CPX_PARAM_EPRHS, 1},
{"markowitz_tol", CPX_PARAM_EPMRK, 1},
{"optimality_tol", CPX_PARAM_EPOPT, 1},
{"backtrack", CPX_PARAM_BTTOL, 1},
{"treememory", CPX_PARAM_TRELIM, 1},
{"lowercutoff", CPX_PARAM_CUTLO, 1},
{"uppercutoff", CPX_PARAM_CUTUP, 1},
{"absmipgap", CPX_PARAM_EPAGAP, 1},
{"mipgap", CPX_PARAM_EPGAP, 1},
{"integrality", CPX_PARAM_EPINT, 1},
{"objdifference", CPX_PARAM_OBJDIF, 1},
{"relobjdifference", CPX_PARAM_RELOBJDIF, 1},
{"crash", CPX_PARAM_CRAIND, 0},
{"dgradient", CPX_PARAM_DPRIIND, 0},
{"pricing", CPX_PARAM_PRICELIM, 0},
/*{"iisfind", CPX_PARAM_IISIND, 0}, removed in CPLEX 10 */
{"perturbation_ind", CPX_PARAM_PERIND, 0},
{"pgradient", CPX_PARAM_PPRIIND, 0},
{"refactor", CPX_PARAM_REINV, 0},
{"iteration_limit", CPX_PARAM_ITLIM, 0},
{"singularity_limit", CPX_PARAM_SINGLIM, 0},
{"simplex_display", CPX_PARAM_SIMDISPLAY, 0},
{"basisinterval", CPX_PARAM_BASINTERVAL, 0},
{"branch", CPX_PARAM_BRDIR, 0},
{"nodeselect", CPX_PARAM_NODESEL, 0},
{"order", CPX_PARAM_MIPORDIND, 0},
{"startalgorithm", CPX_PARAM_STARTALG, 0},
{"subalgorithm", CPX_PARAM_SUBALG, 0},
{"variableselect", CPX_PARAM_VARSEL, 0},
{"solution_limit", CPX_PARAM_INTSOLLIM, 0},
{"node_limit", CPX_PARAM_NODELIM, 0},
{"mip_display", CPX_PARAM_MIPDISPLAY, 0},
{"mip_interval", CPX_PARAM_MIPINTERVAL, 0},
{"advance", CPX_PARAM_ADVIND, 0},
{"aggregator", CPX_PARAM_AGGIND, 0},
{"coeffreduce", CPX_PARAM_COEREDIND, 0},
{"dependency", CPX_PARAM_DEPIND, 0},
{"presolve", CPX_PARAM_PREIND, 0},
{"scale", CPX_PARAM_SCAIND, 0},
{"xxxstart", CPX_PARAM_XXXIND, 0},

#endif
#ifdef XPRESS

/* NUMALIASES lines follow */
{"timelimit", XPRS_MAXTIME, 0},
{"time_limit", XPRS_MAXTIME, 0},
{"feasibility_tol", XPRS_FEASTOL, 1},
{"integrality", XPRS_MIPTOL, 1},
{"objdifference", XPRS_MIPADDCUTOFF, 1},
{"iteration_limit", XPRS_LPITERLIMIT, 0},
{"presolve", XPRS_PRESOLVE, 0},
{"crash", XPRS_CRASH, 0},
{"refactor", XPRS_INVERTFREQ, 0},
{"node_limit", XPRS_MAXNODE, 0},
{"scrind", XPRS_OUTPUTLOG, 0},
{"logfile", 0, 3},		/* special */
{"subalgorithm", XPRS_DEFAULTALG, 0},

#endif
#ifdef COIN
{"iteration_limit",OsiMaxNumIteration, 0},
{"feasibility_tol", OsiPrimalTolerance, 1},
#endif
};
