/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation.viewers;

import att.grappa.Element;
import com.parctechnologies.eclipse.visualisation.ViewletAction;
import com.parctechnologies.eclipse.visualisation.ViewletData;
import com.parctechnologies.eclipse.visualisation.ViewletDataStore;
import com.parctechnologies.eclipse.visualisation.ViewletRange;
import com.parctechnologies.eclipse.visualisation.viewers.AbstractViewletType;
import com.parctechnologies.eclipse.visualisation.viewers.BoundsViewletType;
import com.parctechnologies.eclipse.visualisation.viewers.CustRenderer;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class GanttTaskViewletType
extends BoundsViewletType {
    double xScale = 1.0;
    final Color DEFAULT_COLOR = Color.blue;
    Color color;

    public GanttTaskViewletType(String string) {
        super(string);
    }

    @Override
    public ViewletData build() {
        return new BoundsViewletType.Data();
    }

    @Override
    public String getDescription() {
        return "GanttTask viewlet";
    }

    @Override
    public Class getCustomRendererClass() {
        return Renderer.class;
    }

    public void setXScale(double d) {
        this.xScale = d;
    }

    public void setFillColor(Color color) {
        this.color = color;
    }

    @Override
    public void customizeElement(ViewletDataStore viewletDataStore, List list, Element element) {
        if ((Integer)list.get(0) == -1) {
            Color color;
            ArrayList<Integer> arrayList = new ArrayList<Integer>(list);
            double[] dArray = new double[6];
            arrayList.set(0, new Integer(1));
            BoundsViewletType.Data data = (BoundsViewletType.Data)viewletDataStore.getViewletDataAt(arrayList);
            dArray[0] = data.min;
            dArray[1] = data.max;
            arrayList.set(0, new Integer(2));
            data = (BoundsViewletType.Data)viewletDataStore.getViewletDataAt(arrayList);
            dArray[2] = dArray[0] + data.min;
            dArray[3] = dArray[1] + data.max;
            arrayList.set(0, new Integer(3));
            data = (BoundsViewletType.Data)viewletDataStore.getViewletDataAt(arrayList);
            dArray[4] = data.min;
            dArray[5] = data.max + 0.9;
            double d = (dArray[3] - dArray[0]) * this.xScale / 72.0;
            double d2 = (dArray[5] - dArray[4]) * 40.0 / 72.0;
            double d3 = (dArray[3] + dArray[0]) * this.xScale / 2.0;
            double d4 = (dArray[5] + dArray[4]) * 40.0 / 2.0;
            element.setAttribute("pos", (Object)(d3 + ",-" + d4));
            element.setAttribute("width", (Object)("" + d));
            element.setAttribute("height", (Object)("" + d2));
            element.getGrappaNexus().updateShape();
            element.setAttribute("shape", (Object)new Integer(27));
            element.setAttribute("custom", (Object)this.getCustomRendererClass().getName());
            Color color2 = color = this.color == null ? this.DEFAULT_COLOR : this.color;
            if (this.color != null) {
                element.setAttribute("style", (Object)"filled");
                if (data.getHoldsOnUpdates()) {
                    element.setAttribute("color", (Object)color.darker());
                } else {
                    element.setAttribute("color", (Object)color);
                }
            } else {
                element.setAttribute("color", (Object)color);
                if (data.getHoldsOnUpdates()) {
                    element.setAttribute("style", (Object)"dotted");
                } else {
                    element.setAttribute("style", (Object)"solid");
                }
            }
            element.object = dArray;
            element.getGrappaNexus().updateText();
            element.getGrappaNexus().updateShape();
        } else {
            super.customizeElement(viewletDataStore, list, element);
        }
    }

    @Override
    public Collection getActions(ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
        List list;
        LinkedList<ViewletAction> linkedList = new LinkedList<ViewletAction>();
        if (viewletRange != null & !viewletRange.isEmpty()) {
            linkedList.add(new AbstractViewletType.ToggleHoldAction(this).createCompoundAction(viewletDataStore, viewletRange));
        }
        if (viewletRange != null & viewletRange.size() == 1) {
            list = (List)viewletRange.iterator().next();
        }
        if (viewletRange != null & viewletRange.size() == 3) {
            list = (List)viewletRange.iterator().next();
            linkedList.add(new DisplayTaskInDetailAction(viewletDataStore, list));
        }
        return linkedList;
    }

    public static class Renderer
    extends CustRenderer {
        public Renderer(Element element, double d, double d2, double d3, double d4) {
            super(element, d, d2, d3, d4);
            double[] dArray = (double[])element.object;
            if (dArray != null) {
                this.configure(new Rectangle2D.Double(d, d2, d3, d4), dArray);
            }
        }

        public void configure(Rectangle2D rectangle2D, double[] dArray) {
            float f = (float)rectangle2D.getMinX();
            float f2 = (float)rectangle2D.getMaxX();
            float f3 = (float)rectangle2D.getMinY();
            float f4 = (float)rectangle2D.getMaxY();
            if (dArray[0] == dArray[3]) {
                dArray[3] = dArray[3] + 0.001;
            }
            double d = dArray[3] - dArray[0];
            double d2 = dArray[5] - dArray[4];
            float f5 = f + (float)((dArray[2] - dArray[0]) * rectangle2D.getWidth() / d);
            float f6 = f + (float)((dArray[1] - dArray[0]) * rectangle2D.getWidth() / d);
            float[][] fArrayArray = new float[][]{{f, f4}, {f, f3}, {f5, f3}, {f5, f4}, {f6, f4}, {f6, f3}, {f2, f3}, {f2, f4}};
            this.path.moveTo(fArrayArray[0][0], fArrayArray[0][1]);
            for (int i = 1; i < fArrayArray.length; ++i) {
                this.path.lineTo(fArrayArray[i][0], fArrayArray[i][1]);
            }
            this.path.closePath();
        }
    }

    private class DisplayTaskInDetailAction
    extends ViewletAction {
        List index;
        ViewletDataStore store;

        DisplayTaskInDetailAction(ViewletDataStore viewletDataStore, List list) {
            super("Display task bounds");
            this.putValue("Name", "Display task bounds");
            this.putValue("LongDescription", "Popup window displaying the task in detail");
            this.putValue("ShortDescription", "Popup window displaying the task in detail");
            this.store = viewletDataStore;
            this.index = list;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(this.index);
            Object[][] objectArray = new Double[4][4];
            arrayList.set(0, new Integer(1));
            BoundsViewletType.Data data = (BoundsViewletType.Data)this.store.getViewletDataAt(arrayList);
            objectArray[0][0] = new Double(data.initialMin);
            objectArray[0][1] = new Double(data.min);
            objectArray[0][2] = new Double(data.max);
            objectArray[0][3] = new Double(data.initialMax);
            arrayList.set(0, new Integer(2));
            data = (BoundsViewletType.Data)this.store.getViewletDataAt(arrayList);
            objectArray[1][0] = new Double(data.initialMin);
            objectArray[1][1] = new Double(data.max);
            objectArray[1][2] = new Double(data.min);
            objectArray[1][3] = new Double(data.initialMax);
            objectArray[2][0] = new Double(objectArray[0][0] + objectArray[1][0]);
            objectArray[2][1] = new Double(objectArray[0][1] + objectArray[1][1]);
            objectArray[2][2] = new Double(objectArray[0][2] + objectArray[1][2]);
            objectArray[2][3] = new Double(objectArray[0][3] + objectArray[1][3]);
            arrayList.set(0, new Integer(3));
            data = (BoundsViewletType.Data)this.store.getViewletDataAt(arrayList);
            objectArray[3][0] = new Double(data.initialMin);
            objectArray[3][1] = new Double(data.max);
            objectArray[3][2] = new Double(data.min);
            objectArray[3][3] = new Double(data.initialMax);
            Object[] objectArray2 = new String[]{"Initial Min", "Min", "Max", "Initial Max"};
            Object[][] objectArray3 = new String[][]{{"Start"}, {"Duration"}, {"End"}, {"Resource"}};
            JTable jTable = new JTable(objectArray, objectArray2);
            jTable.setEnabled(false);
            jTable.setColumnSelectionAllowed(false);
            jTable.setRowSelectionAllowed(false);
            jTable.setCellSelectionEnabled(false);
            JScrollPane jScrollPane = new JScrollPane(jTable);
            Object[] objectArray4 = new String[]{""};
            JTable jTable2 = new JTable(objectArray3, objectArray4);
            jScrollPane.setRowHeaderView(jTable2);
            jScrollPane.getRowHeader().setPreferredSize(jTable2.getPreferredSize());
            jScrollPane.getViewport().setPreferredSize(jTable.getPreferredSize());
            JOptionPane.showConfirmDialog(null, jScrollPane, "Task bounds in detail", -1);
        }
    }
}

