/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation.viewers;

import att.grappa.CustomRenderer;
import att.grappa.Element;
import att.grappa.Node;
import com.parctechnologies.eclipse.Atom;
import com.parctechnologies.eclipse.CompoundTerm;
import com.parctechnologies.eclipse.CompoundTermImpl;
import com.parctechnologies.eclipse.visualisation.BatchGoal;
import com.parctechnologies.eclipse.visualisation.ElementType;
import com.parctechnologies.eclipse.visualisation.ForwardUpdateEvent;
import com.parctechnologies.eclipse.visualisation.UpdateEvent;
import com.parctechnologies.eclipse.visualisation.Viewer;
import com.parctechnologies.eclipse.visualisation.ViewletAction;
import com.parctechnologies.eclipse.visualisation.ViewletData;
import com.parctechnologies.eclipse.visualisation.ViewletDataImpl;
import com.parctechnologies.eclipse.visualisation.ViewletDataStore;
import com.parctechnologies.eclipse.visualisation.ViewletRange;
import com.parctechnologies.eclipse.visualisation.ViewletRangeCollection;
import com.parctechnologies.eclipse.visualisation.viewers.AbstractViewletType;
import com.parctechnologies.eclipse.visualisation.viewers.CustRenderer;
import com.parctechnologies.eclipse.visualisation.viewers.FadeColorSupport;
import com.parctechnologies.eclipse.visualisation.viewers.FadeIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class TextViewletType
extends AbstractViewletType {
    private TableCellRenderer tableCellRenderer;
    private CustomRenderer customRenderer;
    public static final int MAX_FADE = 10;
    FadeColorSupport fadeColorSupport = new FadeColorSupport(10, new Color(0, 255, 0), new Color(255, 0, 0));

    public TextViewletType(String string) {
        super(string);
    }

    @Override
    public boolean canBuildFrom(ElementType elementType) {
        return true;
    }

    @Override
    public ViewletData build() {
        return new Data();
    }

    @Override
    public String getDescription() {
        return "Text viewlet";
    }

    @Override
    public synchronized TableCellRenderer getTableCellRenderer() {
        if (this.tableCellRenderer == null) {
            this.tableCellRenderer = new CellRenderer();
        }
        return this.tableCellRenderer;
    }

    @Override
    synchronized Class getCustomRendererClass() {
        return Renderer.class;
    }

    protected Color getColor(Data data, boolean bl) {
        int n;
        int n2 = 0;
        if (data.getHoldsOnUpdates()) {
            ++n2;
        }
        if (bl) {
            n2 += 2;
        }
        Color color = (n = data.getFadeCount()) > 0 ? this.fadeColorSupport.forwardColor[n][n2] : this.fadeColorSupport.backwardColor[-n][n2];
        return color;
    }

    @Override
    public void customizeElement(ViewletDataStore viewletDataStore, List list, Element element) {
        Data data = (Data)viewletDataStore.getViewletDataAt(list);
        if (element instanceof Node) {
            element.object = data;
            element.setAttribute("shape", (Object)new Integer(27));
            element.setAttribute("custom", (Object)this.getCustomRendererClass().getName());
            element.setAttribute("label", (Object)data.getText());
            element.setAttribute("style", (Object)"filled");
            element.setAttribute("color", (Object)this.getColor(data, false));
            element.getGrappaNexus().updateShape();
        }
    }

    @Override
    public BatchGoal collectPreBuildGoal(Viewer viewer, ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
        BatchGoal batchGoal = new BatchGoal();
        for (List list : viewletRange) {
            CompoundTermImpl compoundTermImpl = new CompoundTermImpl(":", (Object)new Atom("vc_support"), (Object)new CompoundTermImpl("viewable_element_to_string", (Object)new CompoundTermImpl("element", (Object)list), null));
            batchGoal.add(this.composeElementGoal(list, (CompoundTerm)viewletDataStore.getViewable().getNameAtom(), (CompoundTerm)compoundTermImpl));
        }
        return batchGoal;
    }

    @Override
    public void startBuild(Viewer viewer, ViewletDataStore viewletDataStore, ViewletRange viewletRange, List list) {
        Iterator iterator = viewletRange.iterator();
        Iterator iterator2 = list.iterator();
        while (iterator.hasNext()) {
            List list2 = (List)iterator.next();
            Data data = (Data)viewletDataStore.getViewletDataAt(list2);
            CompoundTermImpl compoundTermImpl = (CompoundTermImpl)iterator2.next();
            Object object = ((CompoundTermImpl)this.decomposeElementGoal((CompoundTerm)compoundTermImpl)).argCT(2).arg(2);
            if (data == null) {
                data = (Data)this.build();
            }
            data.setText(object.toString());
            viewletDataStore.setViewletDataAt(list2, data);
        }
    }

    @Override
    public BatchGoal collectPreUpdateGoal(Viewer viewer, ViewletDataStore viewletDataStore, ViewletRange viewletRange, UpdateEvent updateEvent) {
        BatchGoal batchGoal = new BatchGoal();
        for (List list : viewletRange) {
            CompoundTermImpl compoundTermImpl = new CompoundTermImpl(":", (Object)new Atom("vc_support"), (Object)new CompoundTermImpl("viewable_element_to_string", (Object)new CompoundTermImpl("element", (Object)list), null));
            batchGoal.add(this.composeElementGoal(list, (CompoundTerm)viewletDataStore.getViewable().getNameAtom(), (CompoundTerm)compoundTermImpl));
        }
        return batchGoal;
    }

    protected void setUpdating(Viewer viewer, ViewletDataStore viewletDataStore, ViewletRange viewletRange, int n) {
        for (List list : viewletRange) {
            Data data = (Data)viewletDataStore.getViewletDataAt(list);
            if (data == null) {
                data = (Data)this.build();
            }
            data.setFadeCount(n);
            viewletDataStore.setViewletDataAt(list, data);
        }
    }

    @Override
    public void startUpdate(Viewer viewer, ViewletDataStore viewletDataStore, ViewletRange viewletRange, List list, UpdateEvent updateEvent) {
        this.startBuild(viewer, viewletDataStore, viewletRange, list);
        this.setUpdating(viewer, viewletDataStore, viewletRange, updateEvent instanceof ForwardUpdateEvent ? 10 : -10);
        ViewletRange viewletRange2 = viewletDataStore.getEntireViewletRange();
        ViewletRangeCollection viewletRangeCollection = new ViewletRangeCollection();
        for (List list2 : viewletRange2) {
            Data data = (Data)viewletDataStore.getViewletDataAt(list2);
            if (!data.fade()) continue;
            viewletRangeCollection.add(list2);
        }
        viewletDataStore.fireViewletRangeUpdated(viewletRangeCollection);
    }

    @Override
    public Collection getActions(ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
        Collection collection = super.getActions(viewletDataStore, viewletRange);
        if (viewletRange != null & !viewletRange.isEmpty()) {
            collection.add(new ToggleFadeAction().createCompoundAction(viewletDataStore, viewletRange));
        }
        return collection;
    }

    public static class Renderer
    extends CustRenderer {
        public Renderer(Element element, double d, double d2, double d3, double d4) {
            super(element, d, d2, d3, d4);
            Data data = (Data)this.getViewletData();
            if (data != null) {
                this.configure(new Rectangle2D.Double(d, d2, d3, d4), data);
            }
        }

        public void configure(Rectangle2D rectangle2D, Data data) {
            float f = (float)rectangle2D.getMaxY();
            float f2 = 1.0f;
            float[][] fArrayArray = new float[][]{{(float)rectangle2D.getMinX(), f - f2}, {(float)rectangle2D.getMaxX(), f - f2}, {(float)rectangle2D.getMaxX(), f + f2}, {(float)rectangle2D.getMinX(), f + f2}};
            this.path.moveTo(fArrayArray[0][0], fArrayArray[0][1]);
            for (int i = 1; i < fArrayArray.length; ++i) {
                this.path.lineTo(fArrayArray[i][0], fArrayArray[i][1]);
            }
            this.path.closePath();
        }

        @Override
        public void draw(Graphics2D graphics2D) {
            if ((this.element.highlight & 1) != 0) {
                super.draw(graphics2D);
            }
        }
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        Icon fadeIcon;

        public CellRenderer() {
            this.setHorizontalAlignment(0);
            this.fadeIcon = TextViewletType.this.fadeColorSupport.getFadeIcon(10, 10);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = jTable == null ? new JLabel() : (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Data data = (Data)object;
            jLabel.setBackground(TextViewletType.this.getColor(data, bl));
            if (data.getFading()) {
                jLabel.setIcon(this.fadeIcon);
            } else {
                jLabel.setIcon(null);
            }
            return jLabel;
        }

        @Override
        public void setValue(Object object) {
            super.setValue(object);
            this.setToolTipText(object.toString());
        }
    }

    private class CompoundToggleFadeAction
    extends ToggleFadeAction {
        private boolean newValue;
        private ViewletRange range;
        private ViewletDataStore store;

        CompoundToggleFadeAction(boolean bl, ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
            this.newValue = bl;
            this.range = viewletRange;
            this.store = viewletDataStore;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (List list : this.range) {
                Data data = (Data)this.store.getViewletDataAt(list);
                data.setFading(this.newValue);
                this.store.setViewletDataAt(list, data);
            }
            this.store.fireViewletRangeUpdated(this.range);
        }
    }

    private class ToggleFadeAction
    extends ViewletAction {
        ToggleFadeAction() {
            super("Fade update history");
            this.putValue("Name", "Fade update history");
            this.putValue("LongDescription", "Change whether previous updates show as fading colours or not");
            this.putValue("ShortDescription", "Change whether colours fade");
            this.putValue("SmallIcon", new FadeIcon(20, 20));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }

        public ViewletAction createCompoundAction(ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
            boolean bl = true;
            Iterator iterator = viewletDataStore.getViewletDataIterator(viewletRange);
            while (iterator.hasNext()) {
                Data data = (Data)iterator.next();
                if (data.getFading()) continue;
                bl = false;
                break;
            }
            return new CompoundToggleFadeAction(!bl, viewletDataStore, viewletRange);
        }
    }

    public static class Data
    extends ViewletDataImpl {
        private String text = "";
        int updating;
        private int fadeCount = 0;
        private boolean fading = true;

        public String getText() {
            return this.text;
        }

        public void setText(String string) {
            this.text = string;
        }

        public String toString() {
            return this.text;
        }

        public int getFadeCount() {
            return this.fadeCount;
        }

        public void setFadeCount(int n) {
            this.fadeCount = n;
        }

        public void setFading(boolean bl) {
            this.fading = bl;
        }

        public boolean getFading() {
            return this.fading;
        }

        public boolean fade() {
            if (this.fadeCount == 0) {
                return false;
            }
            this.fadeCount = this.fading ? (this.fadeCount > 0 ? --this.fadeCount : ++this.fadeCount) : 0;
            return true;
        }
    }
}

