/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.GrappaConstants;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ExceptionDisplay {
    private String title = null;
    Exception exception = null;
    Display display = null;

    public ExceptionDisplay(String string) {
        this.title = string;
    }

    public void displayException(Exception exception) {
        this.displayException(exception, null);
    }

    public void displayException(Exception exception, String string) {
        if (this.display == null) {
            this.display = new Display(this.title);
        }
        this.exception = exception;
        if (exception == null && string == null) {
            return;
        }
        if (string != null) {
            if (exception == null) {
                this.display.setText(string);
            } else {
                this.display.setText(string + GrappaConstants.NEW_LINE + exception.getMessage());
            }
        } else {
            this.display.setText(exception.getMessage());
        }
        ((Component)this.display).setVisible(true);
    }

    class Display
    extends Frame {
        private TextArea textarea = null;
        private Panel buttonPanel = null;
        private Button trace = null;
        private Button dismiss = null;
        private WindowObserver observer = new WindowObserver();

        Display(String string) {
            super(string);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 0;
            this.setLayout(gridBagLayout);
            this.textarea = new TextArea("", 7, 80);
            this.textarea.setEditable(false);
            this.buttonPanel = new Panel();
            this.buttonPanel.setLayout(new BorderLayout());
            this.trace = new Button("Stack Trace");
            this.trace.addActionListener(this.observer);
            this.dismiss = new Button("Dismiss");
            this.dismiss.addActionListener(this.observer);
            this.buttonPanel.add("West", this.trace);
            this.buttonPanel.add("East", this.dismiss);
            gridBagConstraints.fill = 1;
            gridBagLayout.setConstraints(this.textarea, gridBagConstraints);
            this.add(this.textarea);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagLayout.setConstraints(this.buttonPanel, gridBagConstraints);
            this.add(this.buttonPanel);
            this.addWindowListener(this.observer);
            this.pack();
        }

        void setText(String string) {
            if (string == null) {
                string = "No message to display, try stack trace.";
            }
            this.textarea.setText(string);
        }

        Exception getException() {
            return ExceptionDisplay.this.exception;
        }

        class WindowObserver
        extends WindowAdapter
        implements ActionListener {
            WindowObserver() {
            }

            public void windowClosing(WindowEvent windowEvent) {
                this.dismiss();
            }

            private void dismiss() {
                ((Component)Display.this).setVisible(false);
                Display.this.dispose();
                ((Display)Display.this).ExceptionDisplay.this.display = null;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object instanceof Button) {
                    Button button = (Button)object;
                    if (button.getLabel().equals("Dismiss")) {
                        ((Component)Display.this).setVisible(false);
                    } else if (button.getLabel().equals("Stack Trace")) {
                        if (Display.this.getException() == null) {
                            Display.this.setText("No stack trace available (exception is null).");
                        } else {
                            StringWriter stringWriter = new StringWriter();
                            PrintWriter printWriter = new PrintWriter(stringWriter);
                            Display.this.getException().printStackTrace(printWriter);
                            printWriter.flush();
                            Display.this.setText(stringWriter.toString());
                            printWriter.close();
                        }
                    }
                }
            }
        }
    }
}

