/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.Grappa;
import att.grappa.GrappaNexus;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;

public class GrappaPathIterator
implements PathIterator {
    GrappaNexus grappaNexus;
    AffineTransform affine;
    PathIterator shapeIterator = null;
    PathIterator areaIterator = null;
    double[] pts = new double[6];
    int type;

    public GrappaPathIterator(GrappaNexus grappaNexus) {
        this(grappaNexus, null);
    }

    public GrappaPathIterator(GrappaNexus grappaNexus, AffineTransform affineTransform) {
        if (grappaNexus == null) {
            throw new IllegalArgumentException("shape cannot be null");
        }
        this.grappaNexus = grappaNexus;
        if (grappaNexus.xform == null) {
            this.affine = affineTransform;
        } else if (affineTransform == null) {
            this.affine = grappaNexus.xform;
        } else {
            this.affine = (AffineTransform)grappaNexus.xform.clone();
            this.affine.preConcatenate(affineTransform);
        }
        if (grappaNexus.shape != null) {
            this.shapeIterator = grappaNexus.shape.getPathIterator(this.affine);
            if (this.shapeIterator.isDone()) {
                this.shapeIterator = null;
            }
        }
        if (grappaNexus.textArea != null && (Grappa.shapeClearText || grappaNexus.clearText)) {
            this.areaIterator = grappaNexus.textArea.getPathIterator(this.affine);
            if (this.areaIterator.isDone()) {
                this.areaIterator = null;
            }
        }
        if (this.shapeIterator != null) {
            this.type = this.shapeIterator.currentSegment(this.pts);
        } else if (this.areaIterator != null) {
            this.type = this.areaIterator.currentSegment(this.pts);
        } else {
            throw new RuntimeException("cannot initialize; nothing to iterate over");
        }
    }

    public int currentSegment(double[] dArray) {
        System.arraycopy(this.pts, 0, dArray, 0, 6);
        return this.type;
    }

    public int currentSegment(float[] fArray) {
        fArray[0] = (float)this.pts[0];
        fArray[1] = (float)this.pts[1];
        fArray[2] = (float)this.pts[2];
        fArray[3] = (float)this.pts[3];
        fArray[4] = (float)this.pts[4];
        fArray[5] = (float)this.pts[5];
        return this.type;
    }

    public int getWindingRule() {
        return this.grappaNexus.getWindingRule();
    }

    public boolean isDone() {
        return !(this.shapeIterator != null && !this.shapeIterator.isDone() || this.areaIterator != null && !this.areaIterator.isDone());
    }

    public void next() {
        if (this.shapeIterator != null) {
            if (this.shapeIterator.isDone()) {
                this.shapeIterator = null;
            } else {
                this.shapeIterator.next();
                if (this.shapeIterator.isDone()) {
                    this.shapeIterator = null;
                } else {
                    this.type = this.shapeIterator.currentSegment(this.pts);
                }
                return;
            }
        }
        if (this.areaIterator != null) {
            if (this.areaIterator.isDone()) {
                this.areaIterator = null;
            } else {
                this.areaIterator.next();
                if (this.areaIterator.isDone()) {
                    this.areaIterator = null;
                } else {
                    this.type = this.areaIterator.currentSegment(this.pts);
                }
                return;
            }
        }
    }
}

