/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.GraphParserException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Hashtable;
import java_cup.runtime.Symbol;

public class Lexer {
    private int next_char = 10;
    private int next_char2 = 10;
    private int current_line = -1;
    private int current_position = 1;
    private static final int EOF_CHAR = -1;
    private boolean haveId = false;
    private int old_char;
    private int old_position;
    boolean retreated = false;
    private int error_count = 0;
    private int warning_count = 0;
    private Hashtable keywords = new Hashtable(32);
    private Hashtable char_symbols = new Hashtable(32);
    private Reader inReader;
    private PrintWriter errWriter = null;
    private StringBuffer cmnstrbuf = new StringBuffer();

    public Lexer(Reader reader, PrintWriter printWriter) throws IllegalArgumentException {
        if (reader == null) {
            throw new IllegalArgumentException("Reader cannot be null");
        }
        this.inReader = reader;
        this.errWriter = printWriter;
    }

    public void init() throws IOException {
        this.keywords.put("strict", new Integer(8));
        this.keywords.put("strictdigraph", new Integer(11));
        this.keywords.put("strictgraph", new Integer(10));
        this.keywords.put("digraph", new Integer(9));
        this.keywords.put("graph", new Integer(2));
        this.keywords.put("subgraph", new Integer(5));
        this.keywords.put("node", new Integer(3));
        this.keywords.put("edge", new Integer(4));
        this.keywords.put("--", new Integer(7));
        this.keywords.put("->", new Integer(6));
        this.char_symbols.put(new Integer(59), new Integer(12));
        this.char_symbols.put(new Integer(44), new Integer(13));
        this.char_symbols.put(new Integer(123), new Integer(14));
        this.char_symbols.put(new Integer(125), new Integer(15));
        this.char_symbols.put(new Integer(91), new Integer(16));
        this.char_symbols.put(new Integer(93), new Integer(17));
        this.char_symbols.put(new Integer(61), new Integer(18));
        this.char_symbols.put(new Integer(58), new Integer(19));
        this.advance();
        this.advance();
    }

    public void advance() throws IOException {
        if (this.retreated) {
            this.retreated = false;
            int n = this.old_char;
            this.old_char = this.next_char;
            this.next_char = this.next_char2;
            this.next_char2 = n;
        } else {
            this.old_char = this.next_char;
            this.next_char = this.next_char2;
            this.next_char2 = this.next_char == -1 ? -1 : this.inReader.read();
        }
        if (this.next_char == 92 && (this.next_char2 == 10 || this.next_char2 == 13)) {
            this.next_char = this.next_char2;
            this.next_char2 = this.inReader.read();
            if (this.next_char == 13 && this.next_char2 == 10) {
                this.next_char = this.next_char2;
                this.next_char2 = this.inReader.read();
            }
            this.next_char = this.next_char2;
            this.next_char2 = this.inReader.read();
        }
        if (this.next_char == 13) {
            if (this.next_char2 == 10) {
                this.next_char2 = this.inReader.read();
            }
            this.next_char = 10;
        }
        if (this.old_char == 10) {
            ++this.current_line;
            this.old_position = this.current_position;
            this.current_position = 1;
        } else {
            ++this.current_position;
        }
    }

    private void retreat() {
        if (this.retreated) {
            return;
        }
        this.retreated = true;
        if (this.old_char == 10) {
            --this.current_line;
            this.current_position = this.old_position;
        } else {
            --this.current_position;
        }
        int n = this.next_char2;
        this.next_char2 = this.next_char;
        this.next_char = this.old_char;
        this.old_char = n;
    }

    private void emit_error(String string) {
        String string2 = "Lexer" + this.getLocation() + ": " + string;
        if (this.errWriter != null) {
            this.errWriter.println("ERROR: " + string2);
        }
        ++this.error_count;
        throw new GraphParserException(string2);
    }

    public String getLocation() {
        return "[" + this.current_line + "(" + this.current_position + ")]";
    }

    private void emit_warn(String string) {
        if (this.errWriter != null) {
            this.errWriter.println("WARNING: Lexer" + this.getLocation() + ": " + string);
        }
        ++this.warning_count;
    }

    private boolean id_start_char(int n) {
        return n >= 97 && n <= 122 || n >= 65 && n <= 90 || n == 95 || n >= 48 && n <= 57;
    }

    private boolean id_char(int n) {
        return this.id_start_char(n) || n >= 48 && n <= 57;
    }

    private int find_single_char(int n) {
        Integer n2 = (Integer)this.char_symbols.get(new Integer((char)n));
        if (n2 == null) {
            return -1;
        }
        return n2;
    }

    private void swallow_comment() throws IOException {
        if (this.next_char2 == 42) {
            this.advance();
            this.advance();
            while (true) {
                if (this.next_char == -1) {
                    this.emit_error("Specification file ends inside a comment");
                    return;
                }
                if (this.next_char == 42 && this.next_char2 == 47) {
                    this.advance();
                    this.advance();
                    return;
                }
                this.advance();
            }
        }
        if (this.next_char2 == 47) {
            this.advance();
            this.advance();
            while (this.next_char != 10 && this.next_char != 12 && this.next_char != -1) {
                this.advance();
            }
            return;
        }
        this.emit_error("Malformed comment in specification -- ignored");
        this.advance();
    }

    private Symbol do_quote_string() throws IOException {
        String string;
        this.advance();
        StringBuffer stringBuffer = this.cmnstrbuf;
        synchronized (stringBuffer) {
            this.cmnstrbuf.delete(0, this.cmnstrbuf.length());
            while (this.next_char != 34) {
                if (this.next_char == 92 && this.next_char2 == 34) {
                    this.advance();
                }
                if (this.next_char == -1) {
                    this.emit_error("Specification file ends inside a code string");
                    break;
                }
                this.cmnstrbuf.append(new Character((char)this.next_char));
                this.advance();
            }
            string = this.cmnstrbuf.toString();
        }
        this.advance();
        this.haveId = true;
        return new Symbol(21, string);
    }

    private Symbol do_id() throws IOException {
        String string;
        char[] cArray = new char[]{(char)this.next_char};
        StringBuffer stringBuffer = this.cmnstrbuf;
        synchronized (stringBuffer) {
            this.cmnstrbuf.delete(0, this.cmnstrbuf.length());
            this.cmnstrbuf.append(cArray, 0, 1);
            this.advance();
            while (this.id_char(this.next_char)) {
                cArray[0] = (char)this.next_char;
                this.cmnstrbuf.append(cArray, 0, 1);
                this.advance();
            }
            string = this.cmnstrbuf.toString();
        }
        Integer n = (Integer)this.keywords.get(string);
        if (n != null) {
            this.haveId = false;
            return new Symbol(n);
        }
        this.haveId = true;
        return new Symbol(21, string);
    }

    private Symbol real_next_token() throws IOException {
        while (true) {
            int n;
            if (this.next_char == 32 || this.next_char == 9 || this.next_char == 10 || this.next_char == 12) {
                this.advance();
                continue;
            }
            if (this.next_char == 45) {
                if (this.next_char2 == 62) {
                    this.advance();
                    this.advance();
                    this.haveId = false;
                    return new Symbol(6);
                }
                if (this.next_char2 == 45) {
                    this.advance();
                    this.advance();
                    this.haveId = false;
                    return new Symbol(7);
                }
            }
            if ((n = this.find_single_char(this.next_char)) != -1) {
                if (n == 14 && !this.haveId) {
                    Symbol symbol = new Symbol(5);
                    this.haveId = true;
                    this.retreat();
                    return symbol;
                }
                this.advance();
                this.haveId = false;
                return new Symbol(n);
            }
            if (this.next_char == 34) {
                return this.do_quote_string();
            }
            if (this.next_char == 47 && (this.next_char2 == 42 || this.next_char2 == 47)) {
                this.swallow_comment();
                continue;
            }
            if (this.id_start_char(this.next_char)) {
                return this.do_id();
            }
            if (this.next_char == -1) {
                this.haveId = false;
                return new Symbol(0);
            }
            this.emit_warn("Unrecognized character '" + new Character((char)this.next_char) + "'(" + this.next_char + ") -- ignored");
            this.advance();
        }
    }

    public Symbol next_token(int n) throws IOException {
        if (n > 0) {
            Symbol symbol = this.real_next_token();
            if (this.errWriter != null && n >= 5) {
                this.errWriter.println("DEBUG: Lexer: next_token() => " + symbol.sym);
            }
            return symbol;
        }
        return this.real_next_token();
    }
}

