/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.Grappa;
import att.grappa.GrappaConstants;
import att.grappa.GrappaSupport;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

class PrintfParser
implements GrappaConstants {
    private boolean alternate;
    private boolean rightpad;
    private boolean sign;
    private boolean space;
    private boolean zeropad;
    private boolean trim;
    private int precision;
    private int width;
    private String plus;
    private char padding;
    private StringBuffer scratch = new StringBuffer();

    PrintfParser() {
    }

    final int parse(char[] cArray) {
        return this.parse(cArray, 0);
    }

    final int parse(char[] cArray, int n) {
        char c;
        this.alternate = false;
        this.rightpad = false;
        this.sign = false;
        this.space = false;
        this.zeropad = false;
        this.trim = false;
        boolean bl = false;
        while (n < cArray.length && !bl) {
            switch (cArray[n]) {
                case '-': {
                    this.rightpad = true;
                    break;
                }
                case '+': {
                    this.sign = true;
                    break;
                }
                case ' ': {
                    this.space = true;
                    break;
                }
                case '0': {
                    this.zeropad = true;
                    break;
                }
                case '#': {
                    this.alternate = true;
                    break;
                }
                default: {
                    bl = true;
                    --n;
                }
            }
            ++n;
        }
        this.plus = this.sign ? "+" : (this.space ? " " : "");
        this.width = 0;
        while (n < cArray.length && GrappaSupport.isdigit(c = cArray[n])) {
            this.width = this.width * 10 + (c - 48);
            ++n;
        }
        if (n < cArray.length && cArray[n] == '.') {
            ++n;
            this.precision = 0;
            while (n < cArray.length && GrappaSupport.isdigit(c = cArray[n])) {
                this.precision = this.precision * 10 + (c - 48);
                ++n;
            }
        } else {
            this.precision = -1;
        }
        this.padding = (char)(this.zeropad && !this.rightpad ? 48 : 32);
        return n;
    }

    final StringBuffer buildChar(StringBuffer stringBuffer, int n) {
        this.scratch.setLength(0);
        this.scratch.append((char)n);
        return this.strpad(stringBuffer, this.scratch.toString(), 32, this.width, this.rightpad);
    }

    final StringBuffer buildExp(StringBuffer stringBuffer, double d, boolean bl) {
        double d2;
        double d3;
        this.precision = this.precision >= 0 ? this.precision : 6;
        double d4 = d;
        int n = d4 >= 0.0 ? 1 : -1;
        double d5 = d4 = d4 < 0.0 ? -d4 : d4;
        if (d4 >= 1.0) {
            d3 = Math.log(d4) / GrappaConstants.LOG10;
            d2 = Math.pow(10.0, d3 - (double)((int)d3));
        } else {
            d3 = Math.log(d4 / 10.0) / GrappaConstants.LOG10;
            d2 = Math.pow(10.0, d3 - (double)((int)d3) + 1.0);
        }
        this.scratch.setLength(0);
        this.scratch.append(bl ? "E" : "e");
        this.scratch.append(d3 > 0.0 ? (char)'+' : '-');
        this.strpad(this.scratch, "" + (d3 > 0.0 ? (int)d3 : (int)(-d3)), 48, 2, false);
        if (this.padding == '0' && this.precision >= 0) {
            this.padding = (char)32;
        }
        return this.strpad(stringBuffer, this.doubleToString((double)n * d2, this.scratch.toString()), this.padding, this.width, this.rightpad);
    }

    final StringBuffer buildFlex(StringBuffer stringBuffer, double d, boolean bl) {
        StringBuffer stringBuffer2;
        this.trim = true;
        double d2 = d;
        double d3 = (int)d;
        d2 = d2 < 0.0 ? -d2 : d2;
        double d4 = d2 >= 1.0 ? Math.log(d2) / GrappaConstants.LOG10 : Math.log(d2 / 10.0) / GrappaConstants.LOG10;
        int n = (int)d4;
        int n2 = this.precision = this.precision >= 0 ? (this.precision = this.precision - 1) : 5;
        if (d2 == d3) {
            if (this.alternate) {
                if (this.precision < 0 || n <= this.precision) {
                    this.precision -= n;
                    stringBuffer2 = this.buildFloat(stringBuffer, d);
                } else {
                    stringBuffer2 = this.buildExp(stringBuffer, d, bl);
                }
            } else if (this.precision < 0 || n <= this.precision) {
                this.precision = -1;
                stringBuffer2 = this.buildInteger(stringBuffer, (int)d);
            } else {
                stringBuffer2 = this.buildExp(stringBuffer, d, bl);
            }
        } else {
            stringBuffer2 = n < -4 || n > this.precision ? this.buildExp(stringBuffer, d, bl) : this.buildFloat(stringBuffer, d);
        }
        return stringBuffer2;
    }

    final StringBuffer buildPoint(StringBuffer stringBuffer, Point2D point2D, boolean bl) {
        double[] dArray = new double[]{0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 0.0};
        double[] dArray3 = new double[]{0.0, 0.0};
        double[] dArray4 = new double[]{0.0, 0.0};
        int[] nArray = new int[]{0, 0};
        StringBuffer stringBuffer2 = null;
        this.trim = true;
        dArray[0] = point2D.getX();
        dArray[1] = Grappa.negateStringYCoord ? -point2D.getY() : point2D.getY();
        dArray3[0] = dArray[0];
        dArray3[1] = dArray[1];
        int n = this.precision;
        int n2 = 0;
        while (n2 < 2) {
            int n3;
            this.precision = n;
            dArray4[n2] = (int)dArray3[n2];
            dArray3[n2] = dArray3[n2] < 0.0 ? -dArray3[n2] : dArray3[n2];
            dArray2[n2] = dArray3[n2] >= 1.0 ? Math.log(dArray3[n2]) / GrappaConstants.LOG10 : Math.log(dArray3[n2] / 10.0) / GrappaConstants.LOG10;
            nArray[n2] = (int)dArray2[n2];
            if (this.precision >= 0) {
                n3 = this.precision - 1;
                this.precision = this.precision;
            } else {
                n3 = this.precision = 5;
            }
            if (dArray3[n2] == dArray4[n2]) {
                if (this.alternate) {
                    if (this.precision < 0 || nArray[n2] <= this.precision) {
                        this.precision -= nArray[n2];
                        stringBuffer2 = this.buildFloat(stringBuffer, dArray[n2]);
                    } else {
                        stringBuffer2 = this.buildExp(stringBuffer, dArray[n2], bl);
                    }
                } else if (this.precision < 0 || nArray[n2] <= this.precision) {
                    this.precision = -1;
                    stringBuffer2 = this.buildInteger(stringBuffer, (long)dArray[n2]);
                } else {
                    stringBuffer2 = this.buildExp(stringBuffer, dArray[n2], bl);
                }
            } else {
                stringBuffer2 = nArray[n2] < -4 || nArray[n2] > this.precision ? this.buildExp(stringBuffer, dArray[n2], bl) : this.buildFloat(stringBuffer, dArray[n2]);
            }
            if (n2 == 0) {
                stringBuffer = stringBuffer2 = stringBuffer2.append(',');
            }
            ++n2;
        }
        return stringBuffer2;
    }

    final StringBuffer buildSize(StringBuffer stringBuffer, Dimension2D dimension2D, boolean bl) {
        double[] dArray = new double[]{0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 0.0};
        double[] dArray3 = new double[]{0.0, 0.0};
        double[] dArray4 = new double[]{0.0, 0.0};
        int[] nArray = new int[]{0, 0};
        StringBuffer stringBuffer2 = null;
        this.trim = true;
        dArray[0] = dimension2D.getWidth();
        dArray[1] = dimension2D.getHeight();
        dArray3[0] = dArray[0];
        dArray3[1] = dArray[1];
        int n = this.precision;
        int n2 = 0;
        while (n2 < 2) {
            int n3;
            this.precision = n;
            dArray4[n2] = (int)dArray3[n2];
            dArray3[n2] = dArray3[n2] < 0.0 ? -dArray3[n2] : dArray3[n2];
            dArray2[n2] = dArray3[n2] >= 1.0 ? Math.log(dArray3[n2]) / GrappaConstants.LOG10 : Math.log(dArray3[n2] / 10.0) / GrappaConstants.LOG10;
            nArray[n2] = (int)dArray2[n2];
            if (this.precision >= 0) {
                n3 = this.precision - 1;
                this.precision = this.precision;
            } else {
                n3 = this.precision = 5;
            }
            if (dArray3[n2] == dArray4[n2]) {
                if (this.alternate) {
                    if (this.precision < 0 || nArray[n2] <= this.precision) {
                        this.precision -= nArray[n2];
                        stringBuffer2 = this.buildFloat(stringBuffer, dArray[n2]);
                    } else {
                        stringBuffer2 = this.buildExp(stringBuffer, dArray[n2], bl);
                    }
                } else if (this.precision < 0 || nArray[n2] <= this.precision) {
                    this.precision = -1;
                    stringBuffer2 = this.buildInteger(stringBuffer, (long)dArray[n2]);
                } else {
                    stringBuffer2 = this.buildExp(stringBuffer, dArray[n2], bl);
                }
            } else {
                stringBuffer2 = nArray[n2] < -4 || nArray[n2] > this.precision ? this.buildExp(stringBuffer, dArray[n2], bl) : this.buildFloat(stringBuffer, dArray[n2]);
            }
            if (n2 == 0) {
                stringBuffer = stringBuffer2 = stringBuffer2.append(',');
            }
            ++n2;
        }
        return stringBuffer2;
    }

    final StringBuffer buildBox(StringBuffer stringBuffer, Rectangle2D rectangle2D, boolean bl, boolean bl2) {
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 0.0, 0.0, 0.0};
        double[] dArray3 = new double[]{0.0, 0.0, 0.0, 0.0};
        double[] dArray4 = new double[]{0.0, 0.0, 0.0, 0.0};
        int[] nArray = new int[]{0, 0, 0, 0};
        StringBuffer stringBuffer2 = null;
        this.trim = true;
        if (!bl2) {
            dArray[0] = rectangle2D.getX();
            dArray[1] = rectangle2D.getY();
            dArray[2] = dArray[0] + dArray[2];
            dArray[3] = dArray[1] + dArray[3];
            dArray[1] = Grappa.negateStringYCoord ? -dArray[1] : dArray[1];
            dArray[3] = Grappa.negateStringYCoord ? -dArray[3] : dArray[3];
        } else {
            dArray[0] = rectangle2D.getX();
            dArray[1] = Grappa.negateStringYCoord ? -rectangle2D.getY() : rectangle2D.getY();
            dArray[2] = rectangle2D.getWidth();
            dArray[3] = rectangle2D.getHeight();
        }
        dArray3[0] = dArray[0];
        dArray3[1] = dArray[1];
        dArray3[2] = dArray[2];
        dArray3[3] = dArray[3];
        int n = this.precision;
        int n2 = 0;
        while (n2 < 4) {
            int n3;
            this.precision = n;
            dArray4[n2] = (int)dArray3[n2];
            dArray3[n2] = dArray3[n2] < 0.0 ? -dArray3[n2] : dArray3[n2];
            dArray2[n2] = dArray3[n2] >= 1.0 ? Math.log(dArray3[n2]) / GrappaConstants.LOG10 : Math.log(dArray3[n2] / 10.0) / GrappaConstants.LOG10;
            nArray[n2] = (int)dArray2[n2];
            if (this.precision >= 0) {
                n3 = this.precision - 1;
                this.precision = this.precision;
            } else {
                n3 = this.precision = 5;
            }
            if (dArray3[n2] == dArray4[n2]) {
                if (this.alternate) {
                    if (this.precision < 0 || nArray[n2] <= this.precision) {
                        this.precision -= nArray[n2];
                        stringBuffer2 = this.buildFloat(stringBuffer, dArray[n2]);
                    } else {
                        stringBuffer2 = this.buildExp(stringBuffer, dArray[n2], bl);
                    }
                } else if (this.precision < 0 || nArray[n2] <= this.precision) {
                    this.precision = -1;
                    stringBuffer2 = this.buildInteger(stringBuffer, (long)dArray[n2]);
                } else {
                    stringBuffer2 = this.buildExp(stringBuffer, dArray[n2], bl);
                }
            } else {
                stringBuffer2 = nArray[n2] < -4 || nArray[n2] > this.precision ? this.buildExp(stringBuffer, dArray[n2], bl) : this.buildFloat(stringBuffer, dArray[n2]);
            }
            if (n2 < 3) {
                stringBuffer = stringBuffer2 = stringBuffer2.append(',');
            }
            ++n2;
        }
        return stringBuffer2;
    }

    final StringBuffer buildFloat(StringBuffer stringBuffer, double d) {
        this.precision = this.precision >= 0 ? this.precision : 6;
        double d2 = d;
        if (this.padding == '0' && this.precision >= 0) {
            this.padding = (char)32;
        }
        return this.strpad(stringBuffer, this.doubleToString(d2, ""), this.padding, this.width, this.rightpad);
    }

    final StringBuffer buildHex(StringBuffer stringBuffer, int n, boolean bl) {
        String string;
        this.scratch.setLength(0);
        String string2 = string = bl ? Integer.toHexString(n).toUpperCase() : Integer.toHexString(n);
        if (this.precision > string.length()) {
            if (this.alternate) {
                this.scratch.append(bl ? "0X" : "0x");
            }
            this.strpad(this.scratch, string, 48, this.precision, false);
            this.strpad(stringBuffer, this.scratch.toString(), 32, this.width, this.rightpad);
        } else if (this.zeropad && !this.rightpad && this.precision < 0) {
            if (this.alternate) {
                if (this.width > 2) {
                    this.strpad(this.scratch, string, 48, this.width - 2, this.rightpad);
                    stringBuffer.append(bl ? "0X" : "0x");
                    stringBuffer.append(this.scratch.toString());
                } else {
                    stringBuffer.append(bl ? "0X" : "0x");
                    stringBuffer.append(string);
                }
            } else {
                this.strpad(stringBuffer, string, 48, this.width, this.rightpad);
            }
        } else {
            if (this.alternate) {
                this.scratch.append(bl ? "0X" : "0x");
                this.scratch.append(string);
                string = this.scratch.toString();
            }
            this.strpad(stringBuffer, string, 32, this.width, this.rightpad);
        }
        return stringBuffer;
    }

    final StringBuffer buildInteger(StringBuffer stringBuffer, long l) {
        this.scratch.setLength(0);
        long l2 = l;
        String string = l2 >= 0L ? this.plus : "-";
        String string2 = "" + (l2 < 0L ? -l2 : l2);
        if (this.precision > string2.length()) {
            this.strpad(this.scratch, string2, 48, this.precision, false);
            this.scratch.insert(0, string);
        } else {
            this.scratch.append(string);
            this.scratch.append(string2);
        }
        if (this.padding == '0' && this.precision >= 0) {
            this.padding = (char)32;
        }
        return this.strpad(stringBuffer, this.scratch.toString(), this.padding, this.width, this.rightpad);
    }

    final StringBuffer buildOctal(StringBuffer stringBuffer, int n) {
        this.scratch.setLength(0);
        if (this.alternate) {
            this.scratch.append('0');
        }
        this.scratch.append(Integer.toOctalString(n));
        if (this.precision > this.scratch.length()) {
            String string = this.scratch.toString();
            this.scratch.setLength(0);
            this.strpad(this.scratch, string, 48, this.precision, false);
        }
        if (this.padding == '0' && this.precision >= 0) {
            this.padding = (char)32;
        }
        return this.strpad(stringBuffer, this.scratch.toString(), this.padding, this.width, this.rightpad);
    }

    final StringBuffer buildString(StringBuffer stringBuffer, String string) {
        String string2 = this.precision > 0 ? (this.precision < string.length() ? string.substring(0, this.precision) : string) : string;
        return this.strpad(stringBuffer, string2, this.padding, this.width, this.rightpad);
    }

    private String doubleToString(double d, String string) {
        String string2;
        this.scratch.setLength(0);
        String string3 = d >= 0.0 ? this.plus : "-";
        d = d < 0.0 ? -d : d;
        double d2 = Math.floor(d);
        if (this.precision != 0) {
            double d3 = Math.pow(10.0, this.precision);
            double d4 = (d - d2) * d3;
            this.scratch.append((long)d2);
            string2 = "" + Math.round(d4);
            if (this.trim) {
                int n = string2.length();
                int n2 = 0;
                while (n2 < n && string2.charAt(n - n2 - 1) == '0') {
                    ++n2;
                }
                if (n2 == n) {
                    string2 = string.length() > 0 ? ".0" : "";
                    this.precision = 0;
                } else if (n2 > 0) {
                    this.scratch.append('.');
                    string2 = string2.substring(0, n - n2);
                    this.precision -= n2;
                } else {
                    this.scratch.append('.');
                }
            } else {
                this.scratch.append('.');
            }
            if (this.precision > 0 && d3 / 10.0 > d4) {
                this.strpad(this.scratch, string2, 48, this.precision, false);
            } else {
                this.scratch.append(string2);
            }
            this.scratch.append(string);
        } else {
            this.scratch.append((long)d2);
            if (this.alternate && string.length() == 0) {
                this.scratch.append('.');
            }
            this.scratch.append(string);
        }
        if (this.zeropad && !this.rightpad) {
            string2 = this.scratch.toString();
            this.scratch.setLength(0);
            this.strpad(this.scratch, string2, 48, this.width - string3.length(), false);
        }
        this.scratch.insert(0, string3);
        return this.scratch.toString();
    }

    private StringBuffer strpad(StringBuffer stringBuffer, String string, int n, int n2, boolean bl) {
        if (n2 > 0) {
            int n3 = n2 - string.length();
            if (n3 > 0) {
                if (bl) {
                    stringBuffer.append(string);
                }
                int n4 = 0;
                while (n4 < n3) {
                    stringBuffer.append((char)n);
                    ++n4;
                }
                if (!bl) {
                    stringBuffer.append(string);
                }
            } else {
                stringBuffer.append(string);
            }
        } else {
            stringBuffer.append(string);
        }
        return stringBuffer;
    }
}

