% ----------------------------------------------------------------------
% BEGIN LICENSE BLOCK
% Version: CMPL 1.1
%
% The contents of this file are subject to the Cisco-style Mozilla Public
% License Version 1.1 (the "License"); you may not use this file except
% in compliance with the License.  You may obtain a copy of the License
% at www.eclipse-clp.org/license.
% 
% Software distributed under the License is distributed on an "AS IS"
% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See
% the License for the specific language governing rights and limitations
% under the License. 
% 
% The Original Code is  The ECLiPSe Constraint Logic Programming System. 
% The Initial Developer of the Original Code is  Cisco Systems, Inc. 
% Portions created by the Initial Developer are
% Copyright (C) 1991-2006 Cisco Systems, Inc.  All Rights Reserved.
% 
% Contributor(s): ECRC GmbH
% Contributor(s): IC-Parc, Imperal College London
% 
% END LICENSE BLOCK
%
% System:	ECLiPSe Constraint Logic Programming System
% Version:	$Id: http.pl,v 1.1.2.1 2009/02/19 05:38:37 jschimpf Exp $
% ----------------------------------------------------------------------

:- module(http).

:- comment(categories, ["Interfacing"]).
:- comment(summary, "HTTP library").
:- comment(author, "Ph. Bonnet, S. Bressan and M. Meier, ECRC Munich").
:- comment(copyright, "Cisco Systems, Inc").
:- comment(date, "$Date: 2009/02/19 05:38:37 $").
:- comment(desc, html("
    The HTTP library contains an extensible server and a client for the
    Hyper Text Transfer Protocol.  The library is entirely written in ECLiPSe. 
    <P>
    Typical use of the client is for building WWW \"Worms\", WWW
    \"Robots\" or customized WWW browsers.  Typical use of the server is
    for building customized servers, e.g.  dynamic generation of HTML
    pages.  The server and the client can typically be used together
    to build proxy servers. 
    <P>
    Limitations and Bugs: 
    <UL>
    <LI> The current version of the server is sequential. 
    <LI> The MIME and HTTP grammar is not complete and may fail
	parsing some sentences generated by existing browsers and servers. 
    </UL>
    The library consists of two sub-modules, http_client and http_server,
    which can also be loaded separately.
    <P>
    The structure of the HTTP messages is precisely described in the
    specification document (http://www.w3.org/pub/WWW/Protocols/).  An
    augmented BNF is provided for each component of the header.  We
    have used the DCG (Definite Clause Grammar) mechanism of ECLiPSe
    to encode the grammar, that we use for both parsing (from HTTP
    messages into Prolog terms) and pretty printing (from prolog terms
    into HTTP messages). 
    <P>
    This DCG grammar may have to be modified with the evolutions of
    the HTTP protocol (standard modification and available client or
    server implementations). 
    ")).

:- reexport http_client.
:- reexport http_server.
