/*
 * Decompiled with CFR 0.152.
 */
package components;

import components.SquiggleInputHandler;
import java.io.File;
import org.apache.batik.util.ParsedURL;

public class SVGInputHandler
implements SquiggleInputHandler {
    public static final String[] SVG_MIME_TYPES = new String[]{"image/svg+xml"};
    public static final String[] SVG_FILE_EXTENSIONS = new String[]{".idx"};

    @Override
    public String[] getHandledMimeTypes() {
        return SVG_MIME_TYPES;
    }

    @Override
    public String[] getHandledExtensions() {
        return SVG_FILE_EXTENSIONS;
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public boolean accept(File file) {
        return file != null && file.isFile() && this.accept(file.getPath());
    }

    @Override
    public boolean accept(ParsedURL parsedURL) {
        if (parsedURL == null) {
            return false;
        }
        String string = parsedURL.getPath();
        if (string == null) {
            return false;
        }
        return this.accept(string);
    }

    public boolean accept(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < SVG_FILE_EXTENSIONS.length; ++i) {
            if (!string.endsWith(SVG_FILE_EXTENSIONS[i])) continue;
            return true;
        }
        return false;
    }
}

