/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.Grappa;
import att.grappa.GrappaSupport;
import att.grappa.GrappaSupportPrintf;
import java.awt.geom.Rectangle2D;

public class GrappaBox
extends Rectangle2D.Double {
    private boolean dimensioned = true;

    public GrappaBox() {
    }

    public GrappaBox(Rectangle2D r) {
        this(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public GrappaBox(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public GrappaBox(String coordString, boolean dimensioned) {
        this.dimensioned = dimensioned;
        double[] coords = null;
        try {
            coords = GrappaSupport.arrayForTuple(coordString);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("coordinate string (" + coordString + ") has a bad number format (" + nfe.getMessage() + ")");
        }
        if (coords == null || coords.length != 4) {
            throw new IllegalArgumentException("coordinate string (" + coordString + ") does not contain 4 valid coordinates");
        }
        if (dimensioned) {
            this.x = coords[0];
            this.y = Grappa.negateStringYCoord ? -coords[1] : coords[1];
            this.width = coords[2];
            this.height = coords[3];
        } else {
            double tmp;
            if (Grappa.negateStringYCoord) {
                coords[1] = -coords[1];
                coords[3] = -coords[3];
            }
            if (coords[0] > coords[2]) {
                tmp = coords[0];
                coords[0] = coords[2];
                coords[2] = tmp;
            }
            if (coords[1] > coords[3]) {
                tmp = coords[1];
                coords[1] = coords[3];
                coords[3] = tmp;
            }
            this.x = coords[0];
            this.y = coords[1];
            this.width = coords[2] - coords[0];
            this.height = coords[3] - coords[1];
        }
    }

    public GrappaBox(String coordString) {
        this(coordString, true);
    }

    public String toAttributeString() {
        return this.toFormattedString("%b");
    }

    public String toFormattedString(String format) {
        return GrappaSupportPrintf.sprintf(new Object[]{format, this});
    }

    public String toString() {
        return this.x + "," + this.y + "," + this.width + "," + this.height;
    }

    public boolean isDimensioned() {
        return this.dimensioned;
    }
}

