/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.Attribute;
import att.grappa.CustomRenderer;
import att.grappa.Edge;
import att.grappa.Element;
import att.grappa.GraphIterator;
import att.grappa.Grappa;
import att.grappa.GrappaBox;
import att.grappa.GrappaConstants;
import att.grappa.GrappaLine;
import att.grappa.GrappaPathIterator;
import att.grappa.GrappaPoint;
import att.grappa.GrappaShape;
import att.grappa.GrappaSize;
import att.grappa.GrappaStyle;
import att.grappa.GrappaSupportRects;
import att.grappa.IGrappaObjectListener;
import att.grappa.Node;
import att.grappa.Subgraph;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.ImageObserver;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class GrappaNexus
implements GrappaConstants,
Cloneable,
ImageObserver,
Shape,
IGrappaObjectListener {
    static Map<String, Font> FontCache = new HashMap<String, Font>();
    public static double arcHeightFactor = 0.05;
    public static double arcWidthFactor = 0.05;
    Area textArea = null;
    Shape shape = null;
    int shapeType = 0;
    Rectangle2D bbox = null;
    GrappaStyle style = null;
    Color fillcolor = null;
    Color color = null;
    Image image = null;
    boolean imageLoading = false;
    boolean dirty = false;
    Stroke stroke = null;
    private Object[] objs = null;
    private Object custom_shape = null;
    public boolean boundText = true;
    public boolean clearText = false;
    public boolean drawText = true;
    Element element = null;
    long lastUpdate = 0L;
    private long lastShapeUpdate = 0L;
    private long lastTextUpdate = 0L;
    private long lastStyleUpdate = 0L;
    private long lastDecorationUpdate = 0L;
    private long lastImageUpdate = 0L;
    Font font = null;
    String[] lstr = null;
    GrappaPoint[] lpos = null;
    Color font_color = null;
    private int windingRule = Grappa.windingRule;

    public GrappaNexus(Element elem) {
        this.element = elem;
        this.rebuild();
    }

    public Element getElement() {
        return this.element;
    }

    public Image getImage() {
        return this.image;
    }

    public boolean isImageLoading() {
        return this.imageLoading;
    }

    public int getWindingRule() {
        return this.windingRule;
    }

    public void rebuild() {
        this.updateStyle();
        this.updateDecoration();
        this.updateShape();
        this.updateText();
        this.updateImage();
    }

    public void updateShape() {
        long thisShapeUpdate = System.currentTimeMillis();
        switch (this.element.getType()) {
            case 1: {
                double rotation;
                this.custom_shape = null;
                this.objs = null;
                if (this.element.getSubgraph().isCluster() && this.element.getSubgraph().grappaNexus != null) {
                    this.element.getSubgraph().grappaNexus.dirty = true;
                }
                Node node = (Node)this.element;
                GrappaPoint pos = (GrappaPoint)node.getAttributeValue("pos");
                Double Width = (Double)node.getAttributeValue("width");
                Double Height = (Double)node.getAttributeValue("height");
                Integer Type2 = (Integer)node.getAttributeValue("shape");
                double width = 72.0 * Width;
                double height = 72.0 * Height;
                int type = Type2;
                Integer Peripheries = (Integer)node.getAttributeValue("peripheries");
                Integer Sides = (Integer)node.getAttributeValue("sides");
                Double Distortion = (Double)node.getAttributeValue("distortion");
                Double Skew = (Double)node.getAttributeValue("skew");
                Double Orientation = (Double)node.getAttributeValue("orientation");
                Double Rotation = (Double)node.getAttributeValue("rotation");
                int peripheries = Peripheries == null ? -1 : Peripheries;
                int sides = Sides == null ? -1 : Sides;
                double distortion = Distortion == null ? 0.0 : Distortion;
                double skew = Skew == null ? 0.0 : Skew;
                double orientation = Orientation == null ? 0.0 : Orientation;
                double d = rotation = Rotation == null ? 0.0 : Rotation;
                if (Orientation != null && orientation != 0.0 && Grappa.orientationInDegrees) {
                    orientation = Math.PI * orientation / 180.0;
                }
                switch (type) {
                    case 28: {
                        Constructor<?> ccustom;
                        Class<?> custom_class;
                        String custom = (String)node.getAttributeValue("custom");
                        if (custom == null) {
                            throw new IllegalArgumentException("custom attibuted null for node (" + node.getName() + ") with custom shape");
                        }
                        try {
                            custom_class = Class.forName(custom);
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("custom class unavailable for custom shape '" + custom + "'");
                        }
                        if (!GrappaShape.class.isAssignableFrom(custom_class)) {
                            throw new IllegalArgumentException("custom class '" + custom + "' does not extend the GrappaShape class");
                        }
                        try {
                            ccustom = custom_class.getConstructor(Element.class, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("constructor for custom class shape '" + custom + "' not found");
                        }
                        try {
                            if (Grappa.centerPointNodes) {
                                this.custom_shape = ccustom.newInstance(node, new Double(pos.x - width / 2.0), new Double(pos.y - height / 2.0), new Double(width), new Double(height));
                                this.shape = (Shape)this.custom_shape;
                            } else {
                                this.custom_shape = ccustom.newInstance(node, new Double(pos.x), new Double(pos.y), new Double(width), new Double(height));
                                this.shape = (Shape)this.custom_shape;
                            }
                        }
                        catch (Exception e) {
                            if (e instanceof InvocationTargetException) {
                                Throwable t = ((InvocationTargetException)e).getTargetException();
                                Grappa.displayException((Exception)t);
                            }
                            if (e instanceof UndeclaredThrowableException) {
                                throw new IllegalArgumentException("cannot instantiate custom shape '" + custom + "' for node '" + node.getName() + "' because2: " + ((UndeclaredThrowableException)e).getUndeclaredThrowable().getMessage());
                            }
                            throw new IllegalArgumentException("cannot instantiate custom shape '" + custom + "' for node '" + node.getName() + "' because3: " + e.getMessage());
                        }
                        this.shapeType = 28;
                        break;
                    }
                    case 2: {
                        if (!(Distortion != null && distortion != 0.0 || Skew != null && skew != 0.0 || Orientation != null && orientation != 0.0)) {
                            this.shapeType = 2;
                            this.shape = Grappa.centerPointNodes ? new Rectangle2D.Double(pos.x - width / 2.0, pos.y - height / 2.0, width, height) : new Rectangle2D.Double(pos.x, pos.y, width, height);
                            if (Peripheries == null || peripheries <= 1) break;
                            GeneralPath path = new GeneralPath(this.shape);
                            for (int i = 1; i < peripheries; ++i) {
                                if (Grappa.centerPointNodes) {
                                    path.append(new Rectangle2D.Double(pos.x - width / 2.0 + (double)(i * 4), pos.y - height / 2.0 + (double)(i * 4), width - (double)(2 * i * 4), height - (double)(2 * i * 4)), false);
                                    continue;
                                }
                                path.append(new Rectangle2D.Double(pos.x + (double)(i * 4), pos.y + (double)(i * 4), width - (double)(2 * i * 4), height - (double)(2 * i * 4)), false);
                            }
                            this.shape = path;
                            break;
                        }
                        this.shapeType = 1026;
                        if (Grappa.centerPointNodes) {
                            this.shape = new GrappaShape(this.shapeType, pos.x, pos.y, width, height, sides, peripheries, distortion, skew, orientation, this.style.rounded, this.style.diagonals, null);
                            break;
                        }
                        this.shape = new GrappaShape(this.shapeType, pos.x + width / 2.0, pos.y + height / 2.0, width, height, sides, peripheries, distortion, skew, orientation, this.style.rounded, this.style.diagonals, null);
                        break;
                    }
                    case 20: {
                        if (!(Distortion != null && distortion != 0.0 || Skew != null && skew != 0.0 || Orientation != null && orientation != 0.0)) {
                            this.shapeType = 20;
                            this.shape = Grappa.centerPointNodes ? new RoundRectangle2D.Double(pos.x - width / 2.0, pos.y - height / 2.0, width, height, arcWidthFactor * width, arcHeightFactor * height) : new RoundRectangle2D.Double(pos.x, pos.y, width, height, arcWidthFactor * width, arcHeightFactor * height);
                            if (Peripheries == null || peripheries <= 1) break;
                            GeneralPath path = new GeneralPath(this.shape);
                            for (int i = 1; i < peripheries; ++i) {
                                if (Grappa.centerPointNodes) {
                                    path.append(new RoundRectangle2D.Double(pos.x - width / 2.0 + (double)(i * 4), pos.y - height / 2.0 + (double)(i * 4), width - (double)(2 * i * 4), height - (double)(2 * i * 4), arcWidthFactor * (width - (double)(2 * i * 4)), arcHeightFactor * (height - (double)(2 * i * 4))), false);
                                    continue;
                                }
                                path.append(new RoundRectangle2D.Double(pos.x + (double)(i * 4), pos.y + (double)(i * 4), width - (double)(2 * i * 4), height - (double)(2 * i * 4), arcWidthFactor * (width - (double)(2 * i * 4)), arcHeightFactor * (height - (double)(2 * i * 4))), false);
                            }
                            this.shape = path;
                            break;
                        }
                        this.shapeType = 1044;
                        if (Grappa.centerPointNodes) {
                            this.shape = new GrappaShape(this.shapeType, pos.x, pos.y, width, height, sides, peripheries, distortion, skew, orientation, this.style.rounded, this.style.diagonals, null);
                            break;
                        }
                        this.shape = new GrappaShape(this.shapeType, pos.x + width / 2.0, pos.y + height / 2.0, width, height, sides, peripheries, distortion, skew, orientation, this.style.rounded, this.style.diagonals, null);
                        break;
                    }
                    case 13: {
                        if (!(Distortion != null && distortion != 0.0 || Skew != null && skew != 0.0 || Orientation != null && orientation != 0.0)) {
                            this.shapeType = 13;
                            this.shape = Grappa.centerPointNodes ? new Ellipse2D.Double(pos.x - width / 2.0, pos.y - height / 2.0, width, height) : new Ellipse2D.Double(pos.x, pos.y, width, height);
                            if (Peripheries == null || peripheries <= 1) break;
                            GeneralPath path = new GeneralPath(this.shape);
                            for (int i = 1; i < peripheries; ++i) {
                                if (Grappa.centerPointNodes) {
                                    path.append(new Ellipse2D.Double(pos.x - width / 2.0 + (double)(i * 4), pos.y - height / 2.0 + (double)(i * 4), width - (double)(2 * i * 4), height - (double)(2 * i * 4)), false);
                                    continue;
                                }
                                path.append(new Ellipse2D.Double(pos.x + (double)(i * 4), pos.y + (double)(i * 4), width - (double)(2 * i * 4), height - (double)(2 * i * 4)), false);
                            }
                            this.shape = path;
                            break;
                        }
                        this.shapeType = 1037;
                        if (Grappa.centerPointNodes) {
                            this.shape = new GrappaShape(this.shapeType, pos.x, pos.y, width, height, sides, peripheries, distortion, skew, orientation, this.style.rounded, this.style.diagonals, null);
                            break;
                        }
                        this.shape = new GrappaShape(this.shapeType, pos.x + width / 2.0, pos.y + height / 2.0, width, height, sides, peripheries, distortion, skew, orientation, this.style.rounded, this.style.diagonals, null);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 27: {
                        this.shapeType = type | 0x400;
                        if (Grappa.centerPointNodes) {
                            this.shape = new GrappaShape(this.shapeType, pos.x, pos.y, width, height, sides, peripheries, distortion, skew, orientation, this.style.rounded, this.style.diagonals, null);
                            break;
                        }
                        this.shape = new GrappaShape(this.shapeType, pos.x + width / 2.0, pos.y + height / 2.0, width, height, sides, peripheries, distortion, skew, orientation, this.style.rounded, this.style.diagonals, null);
                        break;
                    }
                    case 19: 
                    case 26: {
                        this.shapeType = type | 0x400;
                        this.objs = GrappaSupportRects.parseRecordInfo(node);
                        String rects = null;
                        if (this.objs != null) {
                            rects = (String)this.objs[2];
                        }
                        if (Grappa.centerPointNodes) {
                            this.shape = new GrappaShape(this.shapeType, pos.x, pos.y, width, height, sides, peripheries, distortion, skew, orientation, this.style.rounded, this.style.diagonals, rects);
                            break;
                        }
                        this.shape = new GrappaShape(this.shapeType, pos.x + width / 2.0, pos.y + height / 2.0, width, height, sides, peripheries, distortion, skew, orientation, this.style.rounded, this.style.diagonals, rects);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unsupported type for this constructor (" + type + ")");
                    }
                }
                if (Rotation == null || rotation == 0.0 || this.shape == null) break;
                double theta = rotation;
                if (Grappa.rotationInDegrees) {
                    theta = Math.PI * theta / 180.0;
                }
                if (Grappa.centerPointNodes) {
                    this.shape = AffineTransform.getRotateInstance(theta, pos.x, pos.y).createTransformedShape(this.shape);
                    break;
                }
                this.shape = AffineTransform.getRotateInstance(theta, pos.x + width / 2.0, pos.y + height / 2.0).createTransformedShape(this.shape);
                break;
            }
            case 2: {
                Edge edge = (Edge)this.element;
                this.shapeType = 1;
                if (this.element.getSubgraph().isCluster() && this.element.getSubgraph().grappaNexus != null) {
                    this.element.getSubgraph().grappaNexus.dirty = true;
                }
                if ((this.shape = (Shape)edge.getAttributeValue("pos")) != null) break;
                Integer attr_type = (Integer)edge.getAttributeValue("dir");
                edge.direction = attr_type != null ? attr_type : (edge.getGraph().isDirected() ? 2 : 0);
                edge.setAttribute("pos", new GrappaLine(new GrappaPoint[]{(GrappaPoint)edge.getTail().getAttributeValue("pos"), (GrappaPoint)edge.getHead().getAttributeValue("pos")}, edge.direction));
                this.shape = (Shape)edge.getAttributeValue("pos");
                break;
            }
            case 4: {
                GrappaBox minBox;
                Subgraph subgraph = (Subgraph)this.element;
                this.shapeType = 2;
                this.dirty = false;
                RectangularShape sgbox = null;
                Element elem = null;
                GraphIterator enm = subgraph.elements();
                block26: while (enm.hasNext()) {
                    elem = enm.nextGraphElement();
                    if (elem == this.element) continue;
                    switch (elem.getType()) {
                        case 1: 
                        case 2: {
                            elem.buildShape();
                            if (sgbox == null) {
                                sgbox = elem.grappaNexus.getBounds2D();
                                continue block26;
                            }
                            ((Rectangle2D)sgbox).add(elem.grappaNexus.rawBounds2D());
                            continue block26;
                        }
                        case 4: {
                            if (sgbox == null) {
                                sgbox = ((Subgraph)elem).getBoundingBox();
                                continue block26;
                            }
                            ((Rectangle2D)sgbox).add(((Subgraph)elem).getBoundingBox());
                            continue block26;
                        }
                    }
                    throw new InternalError("unknown type (" + elem.getType() + ")");
                }
                GrappaSize minSize = (GrappaSize)this.element.getAttributeValue("minsize");
                if (minSize != null) {
                    if (sgbox == null) {
                        sgbox = new Rectangle2D.Double(0.0, 0.0, minSize.getWidth(), minSize.getHeight());
                    } else {
                        ((Rectangle2D)sgbox).add(new Rectangle2D.Double(sgbox.getCenterX() - minSize.getWidth() / 2.0, sgbox.getCenterY() - minSize.getHeight() / 2.0, minSize.getWidth(), minSize.getHeight()));
                    }
                }
                if ((minBox = (GrappaBox)this.element.getAttributeValue("minbox")) != null) {
                    if (sgbox == null) {
                        sgbox = new Rectangle2D.Double(minBox.x, minBox.y, minBox.width, minBox.height);
                    } else {
                        ((Rectangle2D)sgbox).add(new Rectangle2D.Double(minBox.x, minBox.y, minBox.width, minBox.height));
                    }
                }
                if (sgbox == null) {
                    sgbox = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
                }
                this.shape = sgbox;
                break;
            }
            default: {
                throw new IllegalArgumentException("unrecognized element type (" + this.element.getType() + ") for " + this.element.getName());
            }
        }
        this.bboxCheckSet();
        this.lastUpdate = this.lastShapeUpdate = thisShapeUpdate;
    }

    public void updateStyle() {
        long thisStyleUpdate = System.currentTimeMillis();
        this.style = (GrappaStyle)this.element.getAttributeValue("style");
        if (this.style == null) {
            throw new InternalError("style defaults not properly set in Graph.java");
        }
        if (this.style.font_style != null && this.style.font_style != (Integer)this.element.getAttributeValue("fontstyle")) {
            this.element.setAttribute("fontstyle", this.style.font_style);
            this.style.font_style = null;
        }
        this.lastUpdate = this.lastStyleUpdate = thisStyleUpdate;
    }

    public void updateText() {
        String[] tstr = null;
        GrappaPoint[] tpos = null;
        Area area = null;
        Font tfont = null;
        boolean makeAdjustment = false;
        double signum = -1.0;
        int offset = 0;
        int lcnt = 0;
        boolean hasEdgeLabel = false;
        Attribute attr = null;
        long thisTextUpdate = System.currentTimeMillis();
        String labelAttr = (String)this.element.getAttributeValue("label");
        if ("\\N".equals(labelAttr)) {
            labelAttr = this.element.getName();
        }
        if (labelAttr != null && labelAttr.length() > 0) {
            ++lcnt;
        } else {
            labelAttr = null;
        }
        String tailstr = null;
        String headstr = null;
        GrappaPoint tailpt = null;
        GrappaPoint headpt = null;
        if (this.element.isEdge()) {
            headstr = (String)this.element.getAttributeValue("headlabel");
            if (headstr != null && (attr = this.element.getLocalAttribute("head_lp")) != null) {
                headpt = (GrappaPoint)attr.getValue();
                ++lcnt;
                hasEdgeLabel = true;
            } else {
                headstr = null;
            }
            tailstr = (String)this.element.getAttributeValue("taillabel");
            if (tailstr != null && (attr = this.element.getLocalAttribute("tail_lp")) != null) {
                tailpt = (GrappaPoint)attr.getValue();
                ++lcnt;
                hasEdgeLabel = true;
            } else {
                tailstr = null;
            }
        }
        if (labelAttr != null || hasEdgeLabel) {
            if (this.element.isNode() && (this.shapeType == 1043 || this.shapeType == 1050) && labelAttr.indexOf(124) < 0 && labelAttr.indexOf(123) == 0 && labelAttr.lastIndexOf(125) == labelAttr.length() - 1) {
                labelAttr = labelAttr.substring(1, labelAttr.length() - 1).trim();
            }
            if (hasEdgeLabel || labelAttr.length() > 0) {
                GrappaPoint[] lps;
                String[] labels;
                String fontname = (String)this.element.getAttributeValue("fontname");
                Integer fontstyle = (Integer)this.element.getAttributeValue("fontstyle");
                Number fontsize = (Number)this.element.getAttributeValue("fontsize");
                Number fontadj = (Number)this.element.getGraph().getGrappaAttributeValue("grappaFontsizeAdjustment");
                String fontKey = fontname + "_" + fontstyle + "_" + (fontsize.floatValue() + fontadj.floatValue());
                tfont = FontCache.get(fontKey);
                if (tfont == null) {
                    tfont = new Font(fontname, (int)fontstyle, fontsize.intValue() + fontadj.intValue()).deriveFont(fontsize.floatValue());
                    FontCache.put(fontKey, tfont);
                }
                if (this.element.isNode() && (this.shapeType == 1043 || this.shapeType == 1050) && labelAttr.indexOf(124) >= 0) {
                    if (this.objs == null) {
                        this.updateShape();
                    }
                    if (this.objs != null && this.objs[0] != null && this.objs[1] != null) {
                        labels = (String[])this.objs[0];
                        lps = (GrappaPoint[])this.objs[1];
                    } else {
                        labels = new String[]{labelAttr};
                        lps = new GrappaPoint[]{((Node)this.element).getCenterPoint()};
                    }
                } else {
                    labels = new String[lcnt];
                    lps = new GrappaPoint[lcnt];
                    lcnt = 0;
                    if (labelAttr != null) {
                        labels[lcnt++] = labelAttr;
                    }
                    if (headstr != null) {
                        labels[lcnt] = headstr;
                        lps[lcnt] = headpt;
                        ++lcnt;
                    }
                    if (tailstr != null) {
                        labels[lcnt] = tailstr;
                        lps[lcnt] = tailpt;
                    }
                    if (labelAttr != null) {
                        if (Grappa.autoPositionNodeLabel && this.element.isNode()) {
                            lps[0] = ((Node)this.element).getCenterPoint();
                        } else {
                            Subgraph sg;
                            attr = this.element.getLocalAttribute("lp");
                            if (attr == null || (sg = this.element.getSubgraph()) != null && attr == sg.getLocalAttribute("lp")) {
                                Rectangle2D lbox = (Rectangle2D)this.element.getAttributeValue("bb");
                                if (lbox == null) {
                                    lbox = this.bbox;
                                }
                                if (this.element.isSubgraph() && lbox != null) {
                                    lps[0] = new GrappaPoint(lbox.getX() + lbox.getWidth() / 2.0, Grappa.labelGraphBottom ? lbox.getMaxY() : lbox.getMinY());
                                    this.element.setAttribute("lp", lps[0].clone());
                                } else {
                                    lps[0] = null;
                                }
                            } else {
                                lps[0] = (GrappaPoint)attr.getValue();
                            }
                        }
                        if (this.element.isSubgraph() && attr == null) {
                            signum = Grappa.labelGraphBottom ? 1.0 : -1.0;
                            makeAdjustment = true;
                        }
                    }
                }
                for (int l = 0; l < labels.length; ++l) {
                    int i;
                    if (labels[l] == null || lps[l] == null || labels[l].length() <= 0) continue;
                    if (labels[l].equals("\\N")) {
                        labels[l] = this.element.getName();
                        if (labels[l] == null) continue;
                    }
                    int lines = 1;
                    char[] array = labels[l].toCharArray();
                    for (i = 0; i < array.length; ++i) {
                        if (array[i] != '\\' || ++i >= array.length || array[i] != 'l' && array[i] != 'r' && array[i] != 'n' || i + 1 >= array.length) continue;
                        ++lines;
                    }
                    if (tpos == null) {
                        offset = 0;
                        tpos = new GrappaPoint[lines];
                        tstr = new String[lines];
                    } else {
                        offset = tpos.length;
                        GrappaPoint[] p = new GrappaPoint[offset + lines];
                        String[] s = new String[offset + lines];
                        System.arraycopy(tpos, 0, p, 0, offset);
                        System.arraycopy(tstr, 0, s, 0, offset);
                        tpos = p;
                        tstr = s;
                    }
                    int[] justification = new int[lines];
                    Rectangle2D[] bnds = new Rectangle2D[lines];
                    LineMetrics[] mtrc = new LineMetrics[lines];
                    lines = 0;
                    int start = 0;
                    int ch = 110;
                    double htinfo = 0.0;
                    double wdinfo = 0.0;
                    for (i = 0; i < array.length; ++i) {
                        if (array[i] != '\\' || ++i >= array.length || (ch = array[i]) != 108 && array[i] != 'r' && array[i] != 'n') continue;
                        tstr[offset + lines] = new String(array, start, i - 1 - start);
                        bnds[lines] = tfont.getStringBounds(tstr[offset + lines], this.element.getGraph().REFCNTXT);
                        mtrc[lines] = tfont.getLineMetrics(tstr[offset + lines], this.element.getGraph().REFCNTXT);
                        if (bnds[lines].getWidth() > wdinfo) {
                            wdinfo = bnds[lines].getWidth();
                        }
                        htinfo += (double)(2 + tfont.getSize());
                        justification[lines++] = ch == 108 ? -1 : (ch == 114 ? 1 : 0);
                        start = i + 1;
                    }
                    if (start < array.length) {
                        tstr[offset + lines] = new String(array, start, array.length - start);
                        bnds[lines] = tfont.getStringBounds(tstr[offset + lines], this.element.getGraph().REFCNTXT);
                        mtrc[lines] = tfont.getLineMetrics(tstr[offset + lines], this.element.getGraph().REFCNTXT);
                        if (bnds[lines].getWidth() > wdinfo) {
                            wdinfo = bnds[lines].getWidth();
                        }
                        htinfo += (double)(2 + tfont.getSize());
                        justification[lines] = ch == 108 ? -1 : (ch == 114 ? 1 : 0);
                    }
                    if (makeAdjustment) {
                        lps[l].y = Grappa.labelGraphOutside ? (lps[l].y += signum * htinfo) : (lps[l].y -= signum * htinfo);
                    }
                    wdinfo /= 2.0;
                    double top = lps[l].y - (htinfo /= 2.0);
                    double x = 0.0;
                    for (i = 0; i < bnds.length; ++i) {
                        x = justification[i] < 0 ? lps[l].x - wdinfo : (justification[i] > 0 ? lps[l].x + wdinfo - bnds[i].getWidth() : lps[l].x - bnds[i].getWidth() / 2.0);
                        bnds[i].setRect(x, top, bnds[i].getWidth(), bnds[i].getHeight());
                        if (area == null) {
                            area = new Area(bnds[i]);
                        } else {
                            area.add(new Area(bnds[i]));
                        }
                        tpos[offset + i] = new GrappaPoint(x, top + (double)tfont.getSize() - 1.0);
                        top += (double)(2 + tfont.getSize());
                    }
                }
            }
        }
        this.font = tfont;
        this.lpos = tpos;
        this.lstr = tstr;
        this.textArea = area;
        this.bboxCheckSet();
        this.lastUpdate = this.lastTextUpdate = thisTextUpdate;
    }

    public void updateDecoration() {
        long thisDecorationUpdate = System.currentTimeMillis();
        this.color = (Color)this.element.getAttributeValue("color");
        this.fillcolor = (Color)this.element.getAttributeValue("fillcolor");
        this.font_color = (Color)this.element.getAttributeValue("fontcolor");
        if (this.element.isEdge() && this.shape != null && this.shape instanceof GrappaLine) {
            int line_dir;
            int graph_dir;
            Edge edge = (Edge)this.element;
            int dir = graph_dir = edge.getGraph().isDirected() ? 2 : 0;
            Integer attr_type = (Integer)edge.getThisAttributeValue("dir");
            if (attr_type != null) {
                dir = attr_type;
            }
            edge.direction = dir;
            GrappaLine gline = (GrappaLine)this.shape;
            boolean forward = gline.startsNear((Point2D)edge.getTail().getAttributeValue("pos"));
            if (!forward && edge.getHead() == edge.getTail()) {
                forward = true;
            }
            if (forward) {
                line_dir = gline.getArrowType();
            } else {
                switch (gline.getArrowType()) {
                    case 1: {
                        line_dir = 2;
                    }
                    case 2: {
                        line_dir = 1;
                        break;
                    }
                    default: {
                        line_dir = gline.getArrowType();
                    }
                }
            }
            if (line_dir != dir) {
                if (forward) {
                    line_dir = dir;
                } else {
                    switch (dir) {
                        case 1: {
                            line_dir = 2;
                        }
                        case 2: {
                            line_dir = 1;
                            break;
                        }
                        default: {
                            line_dir = dir;
                        }
                    }
                }
                gline.changeArrowType(line_dir);
                edge.setAttribute("pos", gline);
            }
        }
        this.lastUpdate = this.lastDecorationUpdate = thisDecorationUpdate;
    }

    public void updateImage() {
        long thisImageUpdate = System.currentTimeMillis();
        String path = (String)this.element.getAttributeValue("image");
        if (path != null && Grappa.toolkit != null) {
            this.image = null;
            this.imageLoading = true;
            Image raw_image = null;
            try {
                URL url = new URL(path);
                raw_image = Grappa.toolkit.getImage(url);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (raw_image == null) {
                try {
                    raw_image = Grappa.toolkit.getImage(path);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (raw_image != null) {
                if (Grappa.toolkit.prepareImage(raw_image, -1, -1, this)) {
                    this.image = raw_image;
                    this.imageLoading = false;
                }
            } else {
                this.imageLoading = false;
            }
        } else {
            this.image = null;
            this.imageLoading = false;
        }
        this.lastUpdate = this.lastImageUpdate = thisImageUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean imageUpdate(Image image, int flags, int x, int y, int width, int height) {
        boolean ret = true;
        GrappaNexus grappaNexus = this;
        synchronized (grappaNexus) {
            if ((flags & 0x20) == 32) {
                ret = false;
                this.image = image;
                this.imageLoading = false;
                this.notifyAll();
            } else if ((flags & 0xC0) != 0) {
                ret = false;
                this.imageLoading = false;
                this.notifyAll();
            }
        }
        return ret;
    }

    private void bboxCheckSet() {
        Rectangle2D oldbox = this.bbox;
        this.bbox = null;
        Rectangle2D newbox = null;
        try {
            newbox = this.rawBounds2D();
        }
        catch (Exception ex) {
            throw (RuntimeException)ex.fillInStackTrace();
        }
        finally {
            this.bbox = oldbox;
        }
        if (newbox == null) {
            if (this.element.isSubgraph() && ((Subgraph)this.element).countOfElements(7) == 0) {
                newbox = new Rectangle2D.Double();
            } else {
                throw new InternalError("new bounding box of \"" + this.element.getName() + "\" is null");
            }
        }
        if (oldbox == null && newbox != null || oldbox != null && newbox == null || newbox != null && !newbox.equals(oldbox)) {
            for (Subgraph prnt = this.element.getSubgraph(); prnt != null; prnt = prnt.getSubgraph()) {
                if (prnt.grappaNexus == null) continue;
                prnt.grappaNexus.bbox = null;
            }
            this.bbox = newbox;
            this.lastUpdate = System.currentTimeMillis();
        }
    }

    public Object clone() {
        try {
            GrappaNexus copy = (GrappaNexus)super.clone();
            if (this.shape != null) {
                copy.shape = this.shapeType == 1 ? (Shape)((GrappaLine)this.shape).clone() : (this.shapeType == 2 ? (Shape)((Rectangle2D)this.shape).clone() : (this.shapeType == 20 ? (Shape)((RoundRectangle2D)this.shape).clone() : (this.shapeType == 13 ? (Shape)((Ellipse2D)this.shape).clone() : ((this.shapeType & 0x400) != 0 ? (Shape)((GrappaShape)this.shape).clone() : (Shape)((GeneralPath)this.shape).clone()))));
            }
            if (this.textArea != null) {
                copy.textArea = (Area)this.textArea.clone();
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean contains(double x, double y) {
        boolean contains = false;
        if (this.shape != null) {
            contains = this.shape.contains(x, y);
        }
        if (this.textArea != null && !contains && !this.clearText && this.drawText && (this.element.isNode() && this.element.getGraph().getShowNodeLabels() || this.element.isEdge() && this.element.getGraph().getShowEdgeLabels() || this.element.isSubgraph() && this.element.getGraph().getShowSubgraphLabels())) {
            contains = this.textArea.contains(x, y);
        }
        return contains;
    }

    public boolean contains(double x, double y, double width, double height) {
        boolean contains = false;
        if (this.shape != null) {
            contains = this.shape.contains(x, y, width, height);
        }
        if (this.textArea != null && !contains && !this.clearText && this.drawText && (this.element.isNode() && this.element.getGraph().getShowNodeLabels() || this.element.isEdge() && this.element.getGraph().getShowEdgeLabels() || this.element.isSubgraph() && this.element.getGraph().getShowSubgraphLabels())) {
            contains = this.textArea.contains(x, y, width, height);
        }
        return contains;
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public Rectangle2D getBounds2D() {
        if (this.dirty) {
            this.bbox = null;
            this.updateShape();
        }
        if (this.bbox == null) {
            if (this.shape != null) {
                this.bbox = this.shape.getBounds2D();
            }
            if (this.textArea != null && Grappa.shapeBoundText && this.boundText) {
                if (this.bbox == null) {
                    this.bbox = this.textArea.getBounds();
                } else {
                    this.bbox.add(this.textArea.getBounds());
                }
            }
            if (this.bbox.getHeight() == 0.0) {
                this.bbox.setRect(this.bbox.getX(), this.bbox.getY(), this.bbox.getWidth(), 0.01);
            }
            if (this.bbox.getWidth() == 0.0) {
                this.bbox.setRect(this.bbox.getX(), this.bbox.getY(), 0.01, this.bbox.getHeight());
            }
        }
        return (Rectangle2D)this.bbox.clone();
    }

    Rectangle2D rawBounds2D() {
        if (this.dirty) {
            this.bbox = null;
            this.updateShape();
        }
        if (this.bbox == null) {
            if (this.shape != null) {
                this.bbox = this.shape.getBounds2D();
            }
            if (this.textArea != null && Grappa.shapeBoundText && this.boundText) {
                if (this.bbox == null) {
                    this.bbox = this.textArea.getBounds();
                } else {
                    this.bbox.add(this.textArea.getBounds());
                }
            }
            if (this.bbox.getHeight() == 0.0) {
                this.bbox.setRect(this.bbox.getX(), this.bbox.getY(), this.bbox.getWidth(), 0.01);
            }
            if (this.bbox.getWidth() == 0.0) {
                this.bbox.setRect(this.bbox.getX(), this.bbox.getY(), 0.01, this.bbox.getHeight());
            }
        }
        return this.bbox;
    }

    public PathIterator getPathIterator() {
        return new GrappaPathIterator(this, null);
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return new GrappaPathIterator(this, at);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new FlatteningPathIterator(new GrappaPathIterator(this, at), flatness);
    }

    public boolean intersects(double x, double y, double width, double height) {
        boolean intersects = false;
        if (this.shape != null) {
            intersects = this.shape.intersects(x, y, width, height);
        }
        if (this.textArea != null && !intersects && !this.clearText && this.drawText && (this.element.isNode() && this.element.getGraph().getShowNodeLabels() || this.element.isEdge() && this.element.getGraph().getShowEdgeLabels() || this.element.isSubgraph() && this.element.getGraph().getShowSubgraphLabels())) {
            intersects = this.textArea.intersects(x, y, width, height);
        }
        return intersects;
    }

    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public void update(Object obs, Object arg) {
        if (!(obs instanceof Attribute)) {
            throw new IllegalArgumentException("expected to be observing attributes only (obs) for \"" + this.element.getName() + "\"");
        }
        Attribute attr = (Attribute)obs;
        if (arg instanceof Object[]) {
            Object[] args = (Object[])arg;
            if (args.length == 2 && args[0] instanceof Attribute && args[1] instanceof Long) {
                attr.removeListener(this);
                attr = (Attribute)args[0];
                attr.addListener(this);
                obs = attr;
                arg = args[1];
            } else {
                throw new IllegalArgumentException("badly formated update information for \"" + this.element.getName() + "\"");
            }
        }
        if (arg instanceof Long) {
            String attrName = attr.getName();
            int attrHash = attr.getNameHash();
            long thisUpdate = (Long)arg + 1L;
            if (this.element == null || !this.element.reserve()) {
                return;
            }
            this.objs = null;
            switch (this.element.getType()) {
                case 1: {
                    if (POS_HASH == attrHash && "pos".equals(attrName) || WIDTH_HASH == attrHash && "width".equals(attrName) || HEIGHT_HASH == attrHash && "height".equals(attrName) || SHAPE_HASH == attrHash && "shape".equals(attrName)) {
                        if (this.lastShapeUpdate >= thisUpdate) break;
                        this.updateShape();
                        if (!Grappa.autoPositionNodeLabel) break;
                        this.updateText();
                        break;
                    }
                    if (LABEL_HASH == attrHash && "label".equals(attrName) || !Grappa.autoPositionNodeLabel && LP_HASH == attrHash && "lp".equals(attrName) || FONTSIZE_HASH == attrHash && "fontsize".equals(attrName) || FONTNAME_HASH == attrHash && "fontname".equals(attrName) || FONTSTYLE_HASH == attrHash && "fontstyle".equals(attrName)) {
                        if (this.lastTextUpdate >= thisUpdate) break;
                        this.updateText();
                        break;
                    }
                    if (STYLE_HASH == attrHash && "style".equals(attrName)) {
                        if (this.lastStyleUpdate >= thisUpdate) break;
                        this.updateStyle();
                        break;
                    }
                    if (COLOR_HASH == attrHash && "color".equals(attrName) || FONTCOLOR_HASH == attrHash && "fontcolor".equals(attrName)) {
                        if (this.lastDecorationUpdate >= thisUpdate) break;
                        this.updateDecoration();
                        break;
                    }
                    if (IMAGE_HASH == attrHash && "image".equals(attrName)) {
                        if (this.lastImageUpdate >= thisUpdate) break;
                        this.updateImage();
                        break;
                    }
                    throw new InternalError("update called for \"" + this.element.getName() + "\" with an unmonitored attribute: " + attrName);
                }
                case 2: {
                    if (POS_HASH == attrHash && "pos".equals(attrName)) {
                        if (this.lastShapeUpdate >= thisUpdate) break;
                        this.updateShape();
                        break;
                    }
                    if (LABEL_HASH == attrHash && "label".equals(attrName) || LP_HASH == attrHash && "lp".equals(attrName) || HEADLABEL_HASH == attrHash && "headlabel".equals(attrName) || HEADLP_HASH == attrHash && "head_lp".equals(attrName) || TAILLABEL_HASH == attrHash && "taillabel".equals(attrName) || TAILLP_HASH == attrHash && "tail_lp".equals(attrName) || FONTSIZE_HASH == attrHash && "fontsize".equals(attrName) || FONTNAME_HASH == attrHash && "fontname".equals(attrName) || FONTSTYLE_HASH == attrHash && "fontstyle".equals(attrName)) {
                        if (this.lastTextUpdate >= thisUpdate) break;
                        this.updateText();
                        break;
                    }
                    if (STYLE_HASH == attrHash && "style".equals(attrName)) {
                        if (this.lastStyleUpdate >= thisUpdate) break;
                        this.updateStyle();
                        break;
                    }
                    if (COLOR_HASH == attrHash && "color".equals(attrName) || DIR_HASH == attrHash && "dir".equals(attrName) || FONTCOLOR_HASH == attrHash && "fontcolor".equals(attrName)) {
                        if (this.lastDecorationUpdate >= thisUpdate) break;
                        this.updateDecoration();
                        break;
                    }
                    if (IMAGE_HASH == attrHash && "image".equals(attrName)) {
                        if (this.lastImageUpdate >= thisUpdate) break;
                        this.updateImage();
                        break;
                    }
                    throw new InternalError("update called for \"" + this.element.getName() + "\" with an unmonitored attribute: " + attrName);
                }
                case 4: {
                    if (LABEL_HASH == attrHash && "label".equals(attrName) || LP_HASH == attrHash && "lp".equals(attrName) || FONTSIZE_HASH == attrHash && "fontsize".equals(attrName) || FONTNAME_HASH == attrHash && "fontname".equals(attrName) || FONTSTYLE_HASH == attrHash && "fontstyle".equals(attrName)) {
                        if (this.lastTextUpdate >= thisUpdate) break;
                        this.updateText();
                        break;
                    }
                    if (STYLE_HASH == attrHash && "style".equals(attrName)) {
                        if (this.lastStyleUpdate >= thisUpdate) break;
                        this.updateStyle();
                        break;
                    }
                    if (COLOR_HASH == attrHash && "color".equals(attrName) || FONTCOLOR_HASH == attrHash && "fontcolor".equals(attrName)) {
                        if (this.lastDecorationUpdate >= thisUpdate) break;
                        this.updateDecoration();
                        break;
                    }
                    if (IMAGE_HASH == attrHash && "image".equals(attrName)) {
                        if (this.lastImageUpdate >= thisUpdate) break;
                        this.updateImage();
                        break;
                    }
                    if (MINBOX_HASH == attrHash && "minbox".equals(attrName) || MINSIZE_HASH == attrHash && "minsize".equals(attrName)) {
                        this.bbox = null;
                        break;
                    }
                    throw new InternalError("update called for \"" + this.element.getName() + "\" with an unmonitored attribute: " + attrName);
                }
            }
        } else {
            throw new InternalError("update called for shape of element \"" + this.element.getName() + "\" without proper format");
        }
        this.element.release();
    }

    void draw(Graphics2D g2d) {
        if (this.shape instanceof CustomRenderer) {
            ((CustomRenderer)((Object)this.shape)).draw(g2d);
        } else {
            g2d.draw(this);
        }
    }

    void fill(Graphics2D g2d) {
        if (this.shape instanceof CustomRenderer) {
            ((CustomRenderer)((Object)this.shape)).fill(g2d);
        } else {
            g2d.fill(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawImage(Graphics2D g2d) {
        if (Grappa.waitForImages && this.imageLoading) {
            GrappaNexus grappaNexus = this;
            synchronized (grappaNexus) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        if (this.image != null) {
            if (this.shape instanceof CustomRenderer) {
                ((CustomRenderer)((Object)this.shape)).drawImage(g2d);
            } else {
                Rectangle sbox = this.shape.getBounds();
                Shape clip = g2d.getClip();
                g2d.clip(this.shape);
                g2d.drawImage(this.image, sbox.x, sbox.y, sbox.width, sbox.height, null);
                g2d.setClip(clip);
            }
        }
    }

    static {
        if (Grappa.toolkit == null) {
            try {
                Grappa.toolkit = Toolkit.getDefaultToolkit();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

