/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.EXDROutputStream;
import com.parctechnologies.eclipse.EclipseException;
import com.parctechnologies.eclipse.RemoteEclipse;
import com.parctechnologies.eclipse.visualisation.VisClient;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class RemoteVisClient
extends VisClient {
    private static final int MIN_CL_ARGS = 2;
    private RemoteEclipse eclipse;

    public RemoteVisClient(RemoteEclipse remoteEclipse) throws IOException, EclipseException {
        super(remoteEclipse.registerMultitask(null));
        this.eclipse = remoteEclipse;
        EXDROutputStream eXDROutputStream = new EXDROutputStream((OutputStream)System.out);
        try {
            eXDROutputStream.write((Object)this.clientName);
            eXDROutputStream.flush();
        }
        catch (IOException iOException) {
            super.recover_ioe(iOException);
        }
    }

    public static void main(String[] stringArray) {
        RemoteVisClient.checkargs(stringArray);
        RemoteEclipse remoteEclipse = null;
        try {
            remoteEclipse = new RemoteEclipse(InetAddress.getByName(stringArray[0]), Integer.parseInt(stringArray[1]));
        }
        catch (IOException iOException) {
            System.err.println("Unable to connect to ECLiPSe: " + iOException + " raised.");
            System.exit(1);
        }
        try {
            RemoteVisClient remoteVisClient = new RemoteVisClient(remoteEclipse);
            try {
                remoteEclipse.resume();
            }
            catch (IOException iOException) {
                remoteVisClient.recover_ioe(iOException);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void usage_message() {
        System.err.println("Usage:");
        System.err.println("        java RemoteVisClient <host> <port>");
    }

    private static void checkargs(String[] stringArray) {
        InetAddress inetAddress = null;
        int n = 0;
        if (stringArray.length < 2) {
            RemoteVisClient.usage_message();
            System.exit(1);
        }
        try {
            inetAddress = InetAddress.getByName(stringArray[0]);
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Can't reach host " + stringArray[0] + ".");
            System.exit(1);
        }
        try {
            n = Integer.parseInt(stringArray[1]);
            if (n <= 0) {
                System.err.println("Invalid port number " + stringArray[1] + ".");
                System.exit(1);
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Invalid port number " + stringArray[1] + ".");
            System.exit(1);
        }
    }

    @Override
    protected void exitError() {
        super.exitError();
        try {
            this.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(1);
    }

    @Override
    protected void exitNormal() {
        super.exitNormal();
        try {
            this.disconnect();
        }
        catch (IOException iOException) {
            this.recover_ioe(iOException);
        }
        System.exit(0);
    }

    void disconnect() throws IOException {
        if (this.stateModel.getEclipseHasControl()) {
            this.eclipse.unilateralDisconnect();
        } else {
            this.eclipse.disconnect();
        }
    }
}

