/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.Atom;
import com.parctechnologies.eclipse.CompoundTerm;
import com.parctechnologies.eclipse.EclipseConnection;
import com.parctechnologies.eclipse.EclipseException;
import com.parctechnologies.eclipse.EclipseMultitaskConnection;
import com.parctechnologies.eclipse.visualisation.BatchGoal;
import com.parctechnologies.eclipse.visualisation.DebuggingSupport;
import com.parctechnologies.eclipse.visualisation.VisClient;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.Timer;

public class VisClientStateModel {
    public static final int NO_CURRENT_EVENT = 0;
    public static final int SETTING_VIEWER_POLICY = 1;
    public static final int COLLECTING_PRE_EVENT_GOALS = 2;
    public static final int EXECUTING_PRE_EVENT_GOALS = 3;
    public static final int DISTRIBUTING_PRE_EVENT_GOAL_RESULTS = 4;
    public static final int SETTING_BREAKPOINT = 5;
    public static final int HELD_ON_EVENT = 6;
    public static final int EVENT_IS_FINISHED = 7;
    private boolean eclipseHasControl;
    private boolean canPerformRPC;
    private boolean autoResume = false;
    private boolean interrupt = false;
    private boolean terminate = false;
    private boolean recordScenario = true;
    private boolean allScenarioCommandsExecuted;
    private boolean viewerBuildingPolicySelected = false;
    private Atom visClientName;
    private VisClient visClient;
    private BoundedRangeModel delayModel;
    private int currentState;
    EclipseMultitaskConnection eclipse;
    private String eclipseLibDir;
    private Action resumeAction;
    private Action interruptAction;
    private Action autoResumeAction;
    private AutoResumeTimer autoResumeTimer;
    private PropertyChangeSupport propertyChangeSupport;
    private List multitaskRunnableList;

    public VisClientStateModel(EclipseMultitaskConnection eclipseMultitaskConnection, Atom atom, VisClient visClient) {
        this.eclipse = eclipseMultitaskConnection;
        this.visClientName = atom;
        this.visClient = visClient;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.setCurrentState(0);
        this.setEclipseHasControl(true);
        this.setCanPerformRPC(false);
        this.resumeAction = new ResumeAction();
        this.autoResumeAction = new AutoResumeAction();
        this.interruptAction = new InterruptAction();
        this.delayModel = new DefaultBoundedRangeModel(1000, 1, 0, 5000);
        this.multitaskRunnableList = new LinkedList();
    }

    public synchronized void setAllScenarioCommandsExecuted(boolean bl) {
        this.allScenarioCommandsExecuted = bl;
        this.notifyAll();
    }

    public Atom getVisClientName() {
        return this.visClientName;
    }

    public VisClient getVisClient() {
        return this.visClient;
    }

    public BoundedRangeModel getDelayModel() {
        return this.delayModel;
    }

    synchronized void setCurrentState(int n) {
        if (this.currentState != n) {
            int n2 = this.currentState;
            this.currentState = n;
            this.propertyChangeSupport.firePropertyChange("currentVisClientState", new Integer(n2), new Integer(this.currentState));
            if (this.getAutoResume() && !this.getInterrupt() && this.currentState == 6) {
                this.startAutoResumeTimer();
            }
            if (this.getAutoResume() && this.currentState == 0) {
                this.stopAutoResumeTimer();
            }
        }
        this.notifyAll();
    }

    private void startAutoResumeTimer() {
        this.autoResumeTimer = new AutoResumeTimer(this.delayModel.getValue(), this.autoResumeAction);
        this.autoResumeTimer.start();
    }

    private void stopAutoResumeTimer() {
        if (this.autoResumeTimer != null) {
            this.autoResumeTimer.stop();
            this.autoResumeTimer = null;
        }
    }

    synchronized void setEclipseHasControl(boolean bl) {
        if (this.eclipseHasControl != bl) {
            boolean bl2 = this.eclipseHasControl;
            this.eclipseHasControl = bl;
            this.propertyChangeSupport.firePropertyChange("eclipseHasControl", new Boolean(bl2), new Boolean(bl));
        }
    }

    synchronized void setCanPerformRPC(boolean bl) {
        if (this.canPerformRPC != bl) {
            boolean bl2 = this.canPerformRPC;
            this.canPerformRPC = bl;
            this.propertyChangeSupport.firePropertyChange("canPerformRPC", new Boolean(bl2), new Boolean(bl));
        }
    }

    public synchronized void setAutoResume(boolean bl) {
        if (this.autoResume != bl) {
            boolean bl2 = this.autoResume;
            this.autoResume = bl;
            this.propertyChangeSupport.firePropertyChange("autoResume", new Boolean(bl2), new Boolean(bl));
            if (!bl && this.autoResumeTimer != null && this.autoResumeTimer.isRunning()) {
                this.stopAutoResumeTimer();
            }
        }
    }

    public synchronized boolean getRecordScenario() {
        return this.recordScenario;
    }

    public synchronized void setRecordScenario(boolean bl) {
        if (this.recordScenario != bl) {
            boolean bl2 = this.recordScenario;
            this.recordScenario = bl;
            this.propertyChangeSupport.firePropertyChange("recordScenario", new Boolean(bl2), new Boolean(bl));
        }
    }

    public synchronized boolean getViewerBuildingPolicySelected() {
        return this.viewerBuildingPolicySelected;
    }

    public synchronized void setViewerBuildingPolicySelected(boolean bl) {
        this.viewerBuildingPolicySelected = bl;
    }

    public synchronized int getCurrentState() {
        return this.currentState;
    }

    public synchronized boolean getEclipseHasControl() {
        return this.eclipseHasControl;
    }

    public synchronized boolean getCanPerformRPC() {
        return this.canPerformRPC;
    }

    public synchronized boolean getAutoResume() {
        return this.autoResume;
    }

    public void setInterrupt(boolean bl) {
        this.interrupt = bl;
    }

    public boolean getInterrupt() {
        return this.interrupt;
    }

    public synchronized void setTerminate(boolean bl) {
        this.terminate = bl;
        if (bl && this.getEclipseHasControl()) {
            this.visClient.exitNormal();
        }
        this.notifyAll();
    }

    public synchronized boolean getTerminate() {
        return this.terminate;
    }

    void resume() {
        this.getResumeAction().setEnabled(false);
        this.setInterrupt(false);
        this.visClient.endMultitaskPhase();
    }

    public Action getResumeAction() {
        return this.resumeAction;
    }

    public Action getInterruptAction() {
        return this.interruptAction;
    }

    PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    CompoundTerm executeMultitaskGoal(CompoundTerm compoundTerm) throws IOException, EclipseException {
        CompoundTerm compoundTerm2 = this.eclipse.rpc(compoundTerm);
        return compoundTerm2;
    }

    public List executeMultitaskBatchGoal(BatchGoal batchGoal) throws IOException, EclipseException {
        List list = batchGoal.execute((EclipseConnection)this.eclipse);
        return list;
    }

    public void setEclipseLibDir(String string) {
        this.eclipseLibDir = string;
    }

    public String getEclipseLibDir() {
        return this.eclipseLibDir;
    }

    private class AutoResumeTimer
    extends Timer {
        AutoResumeTimer(int n, Action action) {
            super(n, action);
            this.setRepeats(false);
            this.setInitialDelay(n);
        }
    }

    private class InterruptAction
    extends AbstractAction
    implements PropertyChangeListener {
        InterruptAction() {
            super("Interrupt");
            this.setEnabled(true);
            VisClientStateModel.this.propertyChangeSupport.addPropertyChangeListener("currentVisClientState", this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            int n = (Integer)propertyChangeEvent.getNewValue();
            if (n == 0) {
                this.setEnabled(true);
                return;
            }
            DebuggingSupport.logMessage(this, "interrupt action newState=" + n + " getAutoResume()=" + VisClientStateModel.this.getAutoResume());
            if (!VisClientStateModel.this.getAutoResume() && n == 6) {
                this.setEnabled(false);
                return;
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.setEnabled(false);
            if (VisClientStateModel.this.getAutoResume() && VisClientStateModel.this.autoResumeTimer != null && VisClientStateModel.this.autoResumeTimer.isRunning()) {
                VisClientStateModel.this.stopAutoResumeTimer();
            }
            VisClientStateModel.this.setInterrupt(true);
        }
    }

    private class AutoResumeAction
    extends ResumeAction {
        private AutoResumeAction() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            if (VisClientStateModel.this.currentState != 6) {
                this.setEnabled(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!VisClientStateModel.this.getInterrupt() && VisClientStateModel.this.currentState == 6) {
                super.actionPerformed(actionEvent);
            }
        }
    }

    private class ResumeAction
    extends AbstractAction
    implements PropertyChangeListener {
        static final String normalName = "Resume";
        static final String multitaskName = "Continue";

        ResumeAction() {
            super(normalName);
            this.setEnabled(false);
            VisClientStateModel.this.propertyChangeSupport.addPropertyChangeListener("canPerformRPC", this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isEnabled()) {
                VisClientStateModel.this.resume();
            }
        }
    }

    private class RecordAction
    extends AbstractAction {
        RecordAction() {
            super("Record");
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            VisClientStateModel.this.setRecordScenario(!VisClientStateModel.this.getRecordScenario());
        }
    }
}

