/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.CompoundTerm;
import com.parctechnologies.eclipse.visualisation.ContractEvent;
import com.parctechnologies.eclipse.visualisation.CreateEvent;
import com.parctechnologies.eclipse.visualisation.DestroyEvent;
import com.parctechnologies.eclipse.visualisation.ExpandEvent;
import com.parctechnologies.eclipse.visualisation.UpdateEvent;
import com.parctechnologies.eclipse.visualisation.VisException;
import java.io.Serializable;
import java.util.Map;

public abstract class VisEvent
implements Serializable {
    private String viewableName;

    static VisEvent eventFromCompoundTerm(CompoundTerm compoundTerm) throws VisException {
        if (compoundTerm.functor().equals("viewable_create")) {
            return CreateEvent.parseFromCompoundTerm(compoundTerm);
        }
        if (compoundTerm.functor().equals("viewable_destroy")) {
            return DestroyEvent.parseFromCompoundTerm(compoundTerm);
        }
        if (compoundTerm.functor().equals("viewable_expand")) {
            return ExpandEvent.parseFromCompoundTerm(compoundTerm);
        }
        if (compoundTerm.functor().equals("viewable_contract")) {
            return ContractEvent.parseFromCompoundTerm(compoundTerm);
        }
        if (compoundTerm.functor().equals("update")) {
            return UpdateEvent.parseFromCompoundTerm(compoundTerm);
        }
        throw new VisException("Could not parse VisEvent from " + compoundTerm);
    }

    public String getViewableName() {
        return this.viewableName;
    }

    protected void setViewableName(String string) {
        this.viewableName = string;
    }

    public boolean unifies(VisEvent visEvent, Map map) {
        return this.getClass() == visEvent.getClass();
    }

    public abstract String getDescription();
}

