/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import att.grappa.Element;
import att.grappa.GrappaSize;
import att.grappa.Node;
import com.parctechnologies.eclipse.visualisation.CreateEvent;
import com.parctechnologies.eclipse.visualisation.GraphViewer;
import com.parctechnologies.eclipse.visualisation.SymRef;
import com.parctechnologies.eclipse.visualisation.TickBar;
import com.parctechnologies.eclipse.visualisation.Viewable;
import com.parctechnologies.eclipse.visualisation.ViewableType;
import com.parctechnologies.eclipse.visualisation.Viewer;
import com.parctechnologies.eclipse.visualisation.ViewerSetPropertyCommand;
import com.parctechnologies.eclipse.visualisation.ViewerSetXScaleCommand;
import com.parctechnologies.eclipse.visualisation.ViewletArray;
import com.parctechnologies.eclipse.visualisation.ViewletData;
import com.parctechnologies.eclipse.visualisation.ViewletDataStore;
import com.parctechnologies.eclipse.visualisation.ViewletDataStoreListener;
import com.parctechnologies.eclipse.visualisation.ViewletFactory;
import com.parctechnologies.eclipse.visualisation.ViewletRange;
import com.parctechnologies.eclipse.visualisation.ViewletType;
import com.parctechnologies.eclipse.visualisation.VisClientStateModel;
import com.parctechnologies.eclipse.visualisation.viewers.GanttTaskViewletType;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;

public class GanttViewer
extends GraphViewer {
    TickBar tickBar;
    double xScale;
    TickBar yTickBar;
    static final double INITIAL_XSCALE = 5.0;
    StoreListener storeListener;
    static final Color transparentColor = new Color(0.0f, 0.0f, 1.0f, 0.2f);
    static final Color solidColor = new Color(0.0f, 0.0f, 1.0f);

    public GanttViewer(ViewletType viewletType, VisClientStateModel visClientStateModel, Viewable viewable) {
        super(viewletType, visClientStateModel, viewable, 1);
        this.moveable = false;
    }

    @Override
    protected void prepareForCreate(CreateEvent createEvent) {
        this.viewletDataStore = new ViewletArray(createEvent.getViewableSize(), ((ViewableType.ArrayType)createEvent.getViewableType()).getFixityList(), this.getViewable(), (ViewletFactory)((Object)this.viewletType));
        this.viewletDataStore.setSymRef(new SymRef(this.viewletDataStore, this.getSymRef(), "store"));
        this.storeListener = new StoreListener();
        this.viewletDataStore.addViewletDataStoreListener(this.storeListener);
    }

    @Override
    protected void initialiseMenu() {
        this.addMenuAndPopupMenuItem("View", null);
        this.addMenuAndPopupMenuItem("View", new GraphViewer.GrappaAntiAliasToggleAction(this));
        this.addMenuAndPopupMenuItem("Graph", new GraphViewer.SetBackgroundAction(this, this, false));
        this.addMenuAndPopupMenuItem("Graph", new GraphViewer.SetBackgroundAction(this, this, true));
        this.addMenuAndPopupMenuItem("Gantt", new SetTaskFillAction(this, "Hollow", null));
        this.addMenuAndPopupMenuItem("Gantt", new SetTaskFillAction(this, "Transparent", transparentColor));
        this.addMenuAndPopupMenuItem("Gantt", new SetTaskFillAction(this, "Solid", solidColor));
    }

    @Override
    protected int getMenuMnemonic(String string) {
        if ("Gantt".equals(string)) {
            return 84;
        }
        return super.getMenuMnemonic(string);
    }

    @Override
    public Collection getViewerPopupMenuCollection() {
        Collection collection = super.getViewerPopupMenuCollection();
        collection.add(this.getPopupMenu("Gantt"));
        return collection;
    }

    @Override
    protected void initialiseGraph() {
        this.graph = new GraphViewer.SteadyGraph(this.getViewable().getNameString(), true, false, 100.0);
        this.initialiseGantt();
    }

    @Override
    protected void initialiseComponent() {
        super.initialiseComponent();
        GrappaSize grappaSize = (GrappaSize)this.graph.getAttributeValue("margin");
        double d = 0.0;
        if (grappaSize != null) {
            d = 72.0 * grappaSize.width;
        }
        this.tickBar = new TickBar((JComponent)this.graphPanel, false, 10, 2, 5.0, d);
        this.yTickBar = new TickBar((JComponent)this.graphPanel, true, 1, 1, 40.0, d);
        TickBarMouseListener tickBarMouseListener = new TickBarMouseListener();
        this.tickBar.addMouseListener(tickBarMouseListener);
        this.tickBar.addMouseMotionListener(tickBarMouseListener);
        this.scrollPane.setColumnHeaderView(this.tickBar);
        this.scrollPane.setRowHeaderView(this.yTickBar);
        this.setXScalePrivate(new Double(5.0));
    }

    @Override
    protected Element getElement(List list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(list);
        arrayList.set(0, new Integer(-1));
        Node node = this.graph.findNodeByName(arrayList.toString());
        if (node == null) {
            node = this.graph.findEdgeByName(arrayList.toString());
        }
        return node;
    }

    protected void initialiseGantt() {
        HashMap hashMap = new HashMap();
        int n = (Integer)this.viewletDataStore.getSize().get(0);
        int n2 = (Integer)this.viewletDataStore.getSize().get(1);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(2);
        arrayList.add(new Integer(1));
        arrayList.add(new Integer(1));
        for (int i = 1; i < n2 + 1; ++i) {
            Integer n3 = new Integer(i);
            arrayList.set(0, new Integer(-1));
            arrayList.set(1, n3);
            ViewletData viewletData = null;
            Node node = this.insertNode(this.viewletDataStore, arrayList, viewletData, this.viewletType);
            node.getGrappaNexus().boundText = false;
            node.setAttribute("label", (Object)this.getLocationName(2, i));
        }
    }

    @Override
    void customizeViewlets() {
        int n = (Integer)this.viewletDataStore.getSize().get(0);
        int n2 = (Integer)this.viewletDataStore.getSize().get(1);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(2);
        arrayList.add(new Integer(1));
        arrayList.add(new Integer(1));
        for (int i = 1; i < n + 1; ++i) {
            Integer n3 = new Integer(i);
            arrayList.set(0, n3);
            arrayList.set(1, new Integer(1));
            Element element = this.getElement(arrayList);
            this.elementToViewletType(arrayList).customizeElement(this.viewletDataStore, arrayList, element);
        }
    }

    @Override
    public void zoomToLevel(float f) {
        super.zoomToLevel(f);
        this.tickBar.zoomToLevel(f);
        this.yTickBar.zoomToLevel(f);
    }

    public void setXScale(double d) {
        new ViewerSetXScaleCommand((Viewer)this, d).issue();
    }

    public void setXScalePrivate(Object object) {
        this.xScale = (Double)object;
        ((GanttTaskViewletType)this.viewletType).setXScale(this.xScale);
        this.tickBar.setScale(this.xScale);
        this.storeListener.rangeUpdated(this.viewletDataStore, this.viewletDataStore.getEntireViewletRange());
        this.graph.resetBoundingBox();
    }

    @Override
    public String getToolTip(List list) {
        int n = (Integer)list.get(1);
        String string = this.getLocationName(2, n);
        return "task " + string;
    }

    public void setTaskFillColorPrivate(Object object) {
        ((GanttTaskViewletType)this.viewletType).setFillColor((Color)object);
        this.storeListener.rangeUpdated(this.viewletDataStore, this.viewletDataStore.getEntireViewletRange());
    }

    public static class GanttViewerSetTaskFillCommand
    extends ViewerSetPropertyCommand {
        Color color;

        public GanttViewerSetTaskFillCommand(Viewer viewer, Color color) {
            super(viewer, "taskFillColor");
            this.color = color;
        }

        @Override
        Object getNewValue() {
            return this.color;
        }
    }

    class SetTaskFillAction
    extends AbstractAction {
        private GanttViewer viewer;
        private Color color;

        SetTaskFillAction(GanttViewer ganttViewer2, String string, Color color) {
            super("Set fill color to " + string);
            this.viewer = ganttViewer2;
            this.color = color;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new GanttViewerSetTaskFillCommand((Viewer)this.viewer, this.color).issue();
        }
    }

    protected class StoreListener
    implements ViewletDataStoreListener {
        @Override
        public void rangeUpdated(ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
            Iterator iterator = viewletRange.iterator();
            while (iterator.hasNext()) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>((List)iterator.next());
                arrayList.set(0, new Integer(-1));
                Element element = GanttViewer.this.getElement(arrayList);
                ViewletType viewletType = GanttViewer.this.elementToViewletType(arrayList);
                viewletType.customizeElement(viewletDataStore, arrayList, element);
            }
            GanttViewer.this.graph.repaint();
        }
    }

    class TickBarMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        int initialX;
        double initialXScale;

        TickBarMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.initialX = mouseEvent.getX() - (int)GanttViewer.this.tickBar.displayMargin;
            this.initialXScale = GanttViewer.this.xScale;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX() - (int)GanttViewer.this.tickBar.displayMargin;
            GanttViewer.this.tickBar.setScalingRight(n > this.initialX);
            GanttViewer.this.tickBar.setScale(this.initialXScale * (double)n / (double)this.initialX);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            int n = mouseEvent.getX() - (int)GanttViewer.this.tickBar.displayMargin;
            GanttViewer.this.setXScale(this.initialXScale * (double)n / (double)this.initialX);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

