/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse;

import com.parctechnologies.eclipse.AsyncEclipseQueue;
import com.parctechnologies.eclipse.Atom;
import com.parctechnologies.eclipse.CompoundTerm;
import com.parctechnologies.eclipse.CompoundTermImpl;
import com.parctechnologies.eclipse.EXDRInputStream;
import com.parctechnologies.eclipse.EclipseConnection;
import com.parctechnologies.eclipse.EclipseConnectionImpl;
import com.parctechnologies.eclipse.EclipseException;
import com.parctechnologies.eclipse.EclipseMultitaskConnection;
import com.parctechnologies.eclipse.FromEclipseQueue;
import com.parctechnologies.eclipse.MultitaskListener;
import com.parctechnologies.eclipse.QueueListener;
import com.parctechnologies.eclipse.ToEclipseQueue;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class EclipseMultitaskConnectionImpl
implements EclipseMultitaskConnection {
    static final String STATE_EXCEPTION_MESSAGE = "Attempt to confirm/terminate multitasking phase whilst not in multitasking phase.";
    protected static final Atom peerConfirmMultitaskGoal = new Atom("peer_multitask_confirm");
    protected static final Atom peerTerminateMultitaskGoal = new Atom("peer_multitask_terminate");
    static final String START_MULTITASK_MESSAGE = "start_multitask";
    static final String END_MULTITASK_MESSAGE = "end_multitask";
    static final String INTERACT_MULTITASK_MESSAGE = "interact";
    static final int MULTITASK_RPC_TIMEOUT = 10000;
    EclipseConnectionImpl eclipse;
    FromEclipseQueue multitaskQueue;
    String multitaskPhase;
    Thread multitaskThread;
    MultitaskGoalQueue multitaskGoalQueue;
    List multitaskListenerList;

    EclipseMultitaskConnectionImpl(EclipseConnectionImpl eclipseConnectionImpl, FromEclipseQueue fromEclipseQueue) throws IOException {
        this.eclipse = eclipseConnectionImpl;
        this.multitaskQueue = fromEclipseQueue;
        this.multitaskGoalQueue = new MultitaskGoalQueue();
        this.multitaskPhase = null;
        this.multitaskListenerList = new LinkedList();
        this.multitaskThread = null;
        fromEclipseQueue.setListener(new MultitaskQL());
    }

    @Override
    public CompoundTerm rpc(String string) throws EclipseException, IOException {
        if (this.multitaskPhase == null || Thread.currentThread() == this.multitaskThread) {
            return this.eclipse.rpc(string);
        }
        this.eclipse.testTerminated();
        return this.multitaskGoalQueue.execute(string);
    }

    @Override
    public CompoundTerm rpc(CompoundTerm compoundTerm) throws EclipseException, IOException {
        if (this.multitaskPhase == null || Thread.currentThread() == this.multitaskThread) {
            return this.eclipse.rpc(compoundTerm);
        }
        this.eclipse.testTerminated();
        return this.multitaskGoalQueue.execute(compoundTerm);
    }

    @Override
    public FromEclipseQueue getFromEclipseQueue(String string) throws EclipseException, IOException {
        return this.eclipse.getFromEclipseQueue(string);
    }

    @Override
    public ToEclipseQueue getToEclipseQueue(String string) throws EclipseException, IOException {
        return this.eclipse.getToEclipseQueue(string);
    }

    @Override
    public AsyncEclipseQueue getAsyncEclipseQueue(String string) throws EclipseException, IOException {
        return this.eclipse.getAsyncEclipseQueue(string);
    }

    @Override
    public void compile(File file) throws EclipseException, IOException {
        this.rpc(new CompoundTermImpl("compile", this.getPath(file)));
    }

    @Override
    public String getPath(File file) throws EclipseException, IOException {
        CompoundTermImpl compoundTermImpl = new CompoundTermImpl("os_file_name", null, file.getAbsolutePath());
        return (String)this.rpc(compoundTermImpl).arg(1);
    }

    @Override
    public CompoundTerm rpc(String string, Object object) throws EclipseException, IOException {
        return this.rpc(new CompoundTermImpl(string, object));
    }

    @Override
    public CompoundTerm rpc(String string, Object object, Object object2) throws EclipseException, IOException {
        return this.rpc(new CompoundTermImpl(string, object, object2));
    }

    @Override
    public CompoundTerm rpc(String string, Object object, Object object2, Object object3) throws EclipseException, IOException {
        return this.rpc(new CompoundTermImpl(string, object, object2, object3));
    }

    @Override
    public CompoundTerm rpc(String string, Object object, Object object2, Object object3, Object object4) throws EclipseException, IOException {
        return this.rpc(new CompoundTermImpl(string, object, object2, object3, object4));
    }

    @Override
    public CompoundTerm rpc(String string, Object object, Object object2, Object object3, Object object4, Object object5) throws EclipseException, IOException {
        return this.rpc(new CompoundTermImpl(string, object, object2, object3, object4, object5));
    }

    @Override
    public CompoundTerm rpc(String string, Object[] objectArray) throws EclipseException, IOException {
        return this.rpc(new CompoundTermImpl(string, objectArray));
    }

    @Override
    public CompoundTerm rpc(Object[] objectArray) throws EclipseException, IOException {
        return this.rpc(new CompoundTermImpl(objectArray));
    }

    @Override
    public Atom getPeerName() {
        return this.eclipse.getPeerName();
    }

    @Override
    public EclipseMultitaskConnection registerMultitask(MultitaskListener multitaskListener) throws EclipseException, IOException {
        this.eclipse.testTerminated();
        if (multitaskListener != null) {
            this.multitaskListenerList.add(multitaskListener);
        }
        return this;
    }

    void setMultitaskPhase(String string) {
        this.multitaskPhase = string;
    }

    void processMultitaskTimeSlice() {
        this.multitaskGoalQueue.process(this.eclipse);
    }

    public EclipseConnection getEclipseConnection() {
        return this.eclipse;
    }

    protected String getMultitaskPhase() throws EclipseException, IOException {
        this.eclipse.testTerminated();
        this.multitaskGoalQueue.testProtocolException();
        return this.multitaskPhase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void multitaskConfirm() throws EclipseException, IOException, IllegalStateException {
        EclipseMultitaskConnectionImpl eclipseMultitaskConnectionImpl = this;
        synchronized (eclipseMultitaskConnectionImpl) {
            if (this.multitaskPhase == null) {
                throw new IllegalStateException(STATE_EXCEPTION_MESSAGE);
            }
        }
        this.rpc(peerConfirmMultitaskGoal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void multitaskTerminate() throws EclipseException, IOException, IllegalStateException {
        EclipseMultitaskConnectionImpl eclipseMultitaskConnectionImpl = this;
        synchronized (eclipseMultitaskConnectionImpl) {
            if (this.multitaskPhase == null) {
                throw new IllegalStateException(STATE_EXCEPTION_MESSAGE);
            }
        }
        this.rpc(peerTerminateMultitaskGoal);
    }

    private class MultitaskQL
    implements QueueListener {
        protected CompoundTerm eventTerm;
        EXDRInputStream eis = null;

        private MultitaskQL() {
        }

        @Override
        public void dataAvailable(Object object) {
            if (this.eis == null) {
                FromEclipseQueue fromEclipseQueue = (FromEclipseQueue)object;
                this.eis = new EXDRInputStream(fromEclipseQueue);
            }
            try {
                this.eventTerm = (CompoundTerm)this.eis.readTerm();
                this.processEvent();
            }
            catch (EclipseException eclipseException) {
                EclipseMultitaskConnectionImpl.this.multitaskGoalQueue.setProtocolException(eclipseException);
            }
            catch (IOException iOException) {
                EclipseMultitaskConnectionImpl.this.multitaskGoalQueue.setProtocolException(iOException);
            }
        }

        void processEvent() throws EclipseException, IOException {
            String string = this.eventTerm.functor();
            if (EclipseMultitaskConnectionImpl.START_MULTITASK_MESSAGE.equals(string)) {
                Object object = this.eventTerm.arg(1);
                if (object instanceof String) {
                    EclipseMultitaskConnectionImpl.this.setMultitaskPhase((String)object);
                } else if (object instanceof CompoundTerm) {
                    EclipseMultitaskConnectionImpl.this.setMultitaskPhase(((CompoundTerm)object).functor());
                } else {
                    throw new IOException("Multitask protocol error.  Unexpected multitasking phase type:" + object);
                }
                EclipseMultitaskConnectionImpl.this.multitaskThread = Thread.currentThread();
                for (MultitaskListener multitaskListener : EclipseMultitaskConnectionImpl.this.multitaskListenerList) {
                    multitaskListener.starting(EclipseMultitaskConnectionImpl.this, EclipseMultitaskConnectionImpl.this.getMultitaskPhase());
                }
                EclipseMultitaskConnectionImpl.this.processMultitaskTimeSlice();
            } else if (EclipseMultitaskConnectionImpl.END_MULTITASK_MESSAGE.equals(string)) {
                for (MultitaskListener multitaskListener : EclipseMultitaskConnectionImpl.this.multitaskListenerList) {
                    multitaskListener.ending(EclipseMultitaskConnectionImpl.this, EclipseMultitaskConnectionImpl.this.getMultitaskPhase());
                }
                EclipseMultitaskConnectionImpl.this.processMultitaskTimeSlice();
                EclipseMultitaskConnectionImpl.this.multitaskThread = null;
                EclipseMultitaskConnectionImpl.this.setMultitaskPhase(null);
            } else if (EclipseMultitaskConnectionImpl.INTERACT_MULTITASK_MESSAGE.equals(string)) {
                EclipseMultitaskConnectionImpl.this.processMultitaskTimeSlice();
            }
        }

        @Override
        public void dataRequest(Object object) {
        }
    }

    private static class MultitaskGoal {
        private Object goal;
        private CompoundTerm result;
        private Exception exception;

        private MultitaskGoal(Object object) {
            this.goal = object;
        }
    }

    private static class MultitaskGoalQueue {
        private List pendingGoals = new LinkedList();
        Exception multitaskProtocolException;

        private MultitaskGoalQueue() {
        }

        synchronized void setProtocolException(Exception exception) {
            if (this.multitaskProtocolException != null) {
                this.multitaskProtocolException = exception;
            }
        }

        synchronized void testProtocolException() throws EclipseException, IOException {
            if (this.multitaskProtocolException != null) {
                if (this.multitaskProtocolException instanceof EclipseException) {
                    throw (EclipseException)this.multitaskProtocolException;
                }
                if (this.multitaskProtocolException instanceof IOException) {
                    throw (IOException)this.multitaskProtocolException;
                }
                throw new IOException("Multitask protocol error:" + this.multitaskProtocolException.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompoundTerm execute(Object object) throws IOException, EclipseException {
            MultitaskGoal multitaskGoal = new MultitaskGoal(object);
            Object object2 = this;
            synchronized (object2) {
                this.pendingGoals.add(multitaskGoal);
            }
            object2 = multitaskGoal;
            synchronized (object2) {
                while (multitaskGoal.result == null && multitaskGoal.exception == null) {
                    try {
                        multitaskGoal.wait(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.testProtocolException();
                }
            }
            if (multitaskGoal.exception != null) {
                if (multitaskGoal.exception instanceof IOException) {
                    throw (IOException)multitaskGoal.exception.fillInStackTrace();
                }
                if (multitaskGoal.exception instanceof EclipseException) {
                    throw (EclipseException)multitaskGoal.exception.fillInStackTrace();
                }
                throw new EclipseException(multitaskGoal.exception.getMessage());
            }
            return multitaskGoal.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(EclipseConnection eclipseConnection) {
            Iterator iterator;
            Object object = this;
            synchronized (object) {
                if (this.pendingGoals.isEmpty()) {
                    return;
                }
                iterator = this.pendingGoals.iterator();
                this.pendingGoals = new LinkedList();
            }
            while (iterator.hasNext()) {
                block13: {
                    object = (MultitaskGoal)iterator.next();
                    try {
                        if (((MultitaskGoal)object).goal instanceof CompoundTerm) {
                            ((MultitaskGoal)object).result = eclipseConnection.rpc((CompoundTerm)((MultitaskGoal)object).goal);
                            break block13;
                        }
                        if (((MultitaskGoal)object).goal instanceof String) {
                            ((MultitaskGoal)object).result = eclipseConnection.rpc((String)((MultitaskGoal)object).goal);
                            break block13;
                        }
                        throw new EclipseException("Unknown object type (" + ((MultitaskGoal)object).goal + ") for rpc.");
                    }
                    catch (IOException iOException) {
                        ((MultitaskGoal)object).exception = iOException;
                    }
                    catch (EclipseException eclipseException) {
                        ((MultitaskGoal)object).exception = eclipseException;
                    }
                }
                Object object2 = object;
                synchronized (object2) {
                    object.notifyAll();
                }
            }
        }
    }
}

