/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse;

import com.parctechnologies.eclipse.EclipseConnectionImpl;
import com.parctechnologies.eclipse.QueueListener;
import java.io.IOException;
import java.io.InputStream;

public class FromEclipseQueue
extends InputStream {
    private int id;
    private QueueListener listener = null;
    private String name;
    private EclipseConnectionImpl eclipse;
    private boolean isClosed = false;
    private boolean systemQueue = false;

    FromEclipseQueue(int n, String string, EclipseConnectionImpl eclipseConnectionImpl) {
        this.eclipse = eclipseConnectionImpl;
        this.id = n;
        this.name = string;
    }

    int getID() {
        return this.id;
    }

    boolean isSystemQueue() {
        return this.systemQueue;
    }

    void setSystemQueue(boolean bl) {
        this.systemQueue = bl;
    }

    @Override
    public int available() throws IOException {
        this.testClosed();
        return this.eclipse.availableOnStream(this.id);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.testClosed();
        int n3 = this.eclipse.readFromStream(this.id, n, n2, byArray);
        return n3;
    }

    @Override
    public int read() throws IOException {
        this.testClosed();
        return this.eclipse.readByteFromStream(this.id);
    }

    void notifyAvailable() {
        if (this.listener != null) {
            this.listener.dataAvailable(this);
        }
    }

    public void setListener(QueueListener queueListener) throws IOException {
        this.testClosed();
        this.listener = queueListener;
    }

    public void removeListener() throws IOException {
        this.testClosed();
        this.listener = null;
    }

    @Override
    public void close() throws IOException {
        this.testClosed();
        this.close_cleanup();
        this.eclipse.closeFromEclipseStreamEclipseSide(this.id);
        this.eclipse.closeFromEclipseStreamJavaSide(this.id);
    }

    void close_cleanup() {
        try {
            this.removeListener();
        }
        catch (IOException iOException) {
            System.err.println("Error: removal of listener threw an IOException.");
            System.err.flush();
        }
        this.isClosed = true;
    }

    private void testClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("Operation not possible: stream closed.");
        }
    }
}

