/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.visualisation.Command;
import com.parctechnologies.eclipse.visualisation.ImmediateCommand;
import com.parctechnologies.eclipse.visualisation.Scenario;
import com.parctechnologies.eclipse.visualisation.VisEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class ScenarioIterator {
    private Scenario scenario;
    private int index;
    private Map map;

    public ScenarioIterator(Scenario scenario) {
        this.scenario = scenario;
        this.index = 0;
        this.map = new HashMap();
    }

    protected Scenario.EventCommandList getEventCommandList() {
        return (Scenario.EventCommandList)this.scenario.getEventList().get(this.index);
    }

    protected Collection getCommandList(int n) {
        Scenario.EventCommandList eventCommandList = this.getEventCommandList();
        return eventCommandList.getCommandList(n);
    }

    public boolean matches(VisEvent visEvent) {
        VisEvent visEvent2 = this.peekEvent();
        if (visEvent2 == null) {
            return false;
        }
        return visEvent.unifies(visEvent2, this.map);
    }

    public VisEvent peekEvent() {
        if (this.index >= this.scenario.getEventList().size()) {
            return null;
        }
        Scenario.EventCommandList eventCommandList = (Scenario.EventCommandList)this.scenario.getEventList().get(this.index);
        return eventCommandList.getVisEvent();
    }

    public void play(int n) {
        for (Command command : this.getCommandList(n)) {
            if (command instanceof ImmediateCommand) {
                command.issue();
                continue;
            }
            SwingUtilities.invokeLater(new IssueLater(command));
        }
        if (n == 0) {
            ++this.index;
        }
    }

    public String toString() {
        return "ScenarioIterator index=" + this.index + " scenario = " + this.scenario;
    }

    public static class IssueLater
    implements Runnable {
        private Command command;

        public IssueLater(Command command) {
            this.command = command;
        }

        @Override
        public void run() {
            this.command.issue();
        }
    }
}

