/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.Element;
import att.grappa.Grappa;
import att.grappa.Node;
import att.grappa.Subgraph;
import java.io.PrintWriter;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Edge
extends Element {
    public static final String defaultNamePrefix = "E";
    private Node headNode;
    private String headPortId = null;
    private Node tailNode;
    private String tailPortId = null;
    private String key = null;
    int direction = 0;
    static String[] EdgeAttributesOfInterest = new String[]{"pos", "dir", "lp", "headlabel", "head_lp", "taillabel", "tail_lp", "style"};

    public Edge(Subgraph subg, Node tail, Node head) {
        this(subg, tail, null, head, null, null, null);
    }

    public Edge(Subgraph subg, Node tail, String tailPort, Node head, String headPort) {
        this(subg, tail, tailPort, head, headPort, null, null);
    }

    public Edge(Subgraph subg, Node tail, String tailPort, Node head, String headPort, String key) throws RuntimeException {
        this(subg, tail, tailPort, head, headPort, key, null);
    }

    public Edge(Subgraph subg, Node tail, Node head, String name) throws RuntimeException {
        this(subg, tail, null, head, null, null, name);
    }

    public Edge(Subgraph subg, Node tail, String tailPort, Node head, String headPort, String key, String name) throws RuntimeException {
        super(2, subg);
        boolean directed = subg.getGraph().isDirected();
        this.direction = directed ? 2 : 0;
        if (subg.getGraph().isStrict()) {
            if (tail == head) {
                throw new RuntimeException("cannot create self-looping edge in a strict graph (" + tail.getName() + (directed ? "->" : "--") + head.getName() + ")");
            }
            java.util.Iterator<Edge> enm = Edge.findEdgesByEnds(tail, head);
            if (enm.hasNext()) {
                if (!directed) {
                    throw new RuntimeException("cannot create multiple edges between the same nodes in a strict graph");
                }
                Edge tmpedge = null;
                while (enm.hasNext()) {
                    tmpedge = enm.next();
                    if (tmpedge.getHead() != head || tmpedge.getTail() != tail) continue;
                    throw new RuntimeException("cannot create multiple edges between the same nodes in the same direction in a strict directed graph");
                }
            }
        }
        if (!directed && tail.getId() > head.getId()) {
            Node tmpNode = tail;
            tail = head;
            head = tmpNode;
            String tmpPort = tailPort;
            tailPort = headPort;
            headPort = tmpPort;
        }
        this.tailNode = tail;
        if (tailPort != null) {
            this.tailPortId = new String(tailPort);
        }
        this.headNode = head;
        if (headPort != null) {
            this.headPortId = new String(headPort);
        }
        if (name != null) {
            if (subg.getGraph().findEdgeByName(name) != null) {
                throw new RuntimeException("cannot create edge with duplicate name '" + name + "' (" + this.tailNode.getName() + " -> " + this.headNode.getName() + ")");
            }
            this.name = name;
            subg.addEdge(this);
            if (key == null) {
                key = name;
            }
        } else {
            this.setName();
        }
        this.key = key == null ? (headPort != null && tailPort != null ? tailPort + "::" + headPort : (headPort != null ? "::" + headPort : (tailPort != null ? tailPort + "::" : name))) : key;
        if (this.key != null && Edge.findEdgeByKey(this.tailNode, this.headNode, this.key) != null) {
            subg.removeEdge(this.name);
            throw new RuntimeException("cannot create duplicate edge (" + this.tailNode.getName() + (directed ? "->" : "--") + this.headNode.getName() + ") with key '" + this.key + "'");
        }
        this.tailNode.addEdge(this, false);
        this.headNode.addEdge(this, true);
        this.edgeAttrsOfInterest();
    }

    private void edgeAttrsOfInterest() {
        this.attrOfInterest(EdgeAttributesOfInterest);
    }

    public static Edge findEdgeByKey(Node tail, Node head, String key) {
        if (tail == null || head == null || key == null) {
            return null;
        }
        return tail.findOutEdgeByKey(head, key);
    }

    @Override
    public boolean isEdge() {
        return true;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    void setName() {
        String oldName = this.name;
        do {
            this.name = defaultNamePrefix + this.getId() + "_" + System.currentTimeMillis();
        } while (this.getGraph().findEdgeByName(this.name) != null);
        if (oldName != null) {
            this.getSubgraph().removeEdge(oldName);
        }
        this.getSubgraph().addEdge(this);
        this.canonName = null;
    }

    public String getKey() {
        return this.key;
    }

    public Node getHead() {
        return this.headNode;
    }

    public String getHeadPortId() {
        return this.headPortId;
    }

    public Node getTail() {
        return this.tailNode;
    }

    public String getTailPortId() {
        return this.tailPortId;
    }

    @Override
    public String toString() {
        if (this.canonName == null) {
            String tail = null;
            String head = null;
            tail = this.tailPortId == null ? this.tailNode.toString() : this.tailNode.toString() + ":" + Edge.canonString(this.tailPortId);
            head = this.headPortId == null ? this.headNode.toString() : this.headNode.toString() + ":" + Edge.canonString(this.headPortId);
            this.canonName = this.getGraph().isDirected() ? tail + " -> " + head : tail + " -- " + head;
        }
        return this.canonName;
    }

    public void printEdge(PrintWriter out) {
        this.printElement(out);
    }

    public boolean goesForward() {
        return this.direction != 1;
    }

    public boolean goesReverse() {
        return this.direction != 2;
    }

    public static int attributeType(String attrname) {
        int convtype = -1;
        if (attrname != null) {
            int hashCode = attrname.hashCode();
            if (hashCode == POS_HASH && attrname.equals("pos")) {
                convtype = 8;
            } else if (hashCode == MINLEN_HASH && attrname.equals("minlen")) {
                convtype = 7;
            } else if (hashCode == DIR_HASH && attrname.equals("dir")) {
                convtype = 3;
            } else if (hashCode == WEIGHT_HASH && attrname.equals("weight")) {
                convtype = 4;
            } else if (hashCode == HEADLABEL_HASH && attrname.equals("headlabel")) {
                convtype = 12;
            } else if (hashCode == HEADLP_HASH && attrname.equals("head_lp")) {
                convtype = 9;
            } else if (hashCode == TAILLABEL_HASH && attrname.equals("taillabel")) {
                convtype = 12;
            } else if (hashCode == TAILLP_HASH && attrname.equals("tail_lp")) {
                convtype = 9;
            } else {
                return Element.attributeType(attrname);
            }
        }
        return convtype;
    }

    public static java.util.Iterator<Edge> findEdgesByEnds(Node node1, Node node2) {
        if (node1 == null) {
            return Grappa.emptyEdgeIterator.iterator();
        }
        return new Iterator(node1, node2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Iterator
    implements java.util.Iterator<Edge> {
        Node node1 = null;
        Node node2 = null;
        Edge next = null;
        java.util.Iterator<Edge> outEdges = null;
        java.util.Iterator<Edge> inEdges = null;

        Iterator(Node node1, Node node2) {
            this.node1 = node1;
            this.node2 = node2;
            if (node1 != null) {
                this.outEdges = node1.outEdgeElements();
                this.inEdges = node1.inEdgeElements();
                this.next = this.next();
            }
        }

        @Override
        public Edge next() {
            Edge tmpEdge = null;
            if (this.outEdges != null) {
                while (this.outEdges.hasNext()) {
                    tmpEdge = this.outEdges.next();
                    if (this.node2 != null && tmpEdge.getHead() != this.node2) continue;
                    return tmpEdge;
                }
                this.outEdges = null;
            }
            if (this.inEdges != null) {
                while (this.inEdges.hasNext()) {
                    tmpEdge = this.inEdges.next();
                    if (this.node2 != null && tmpEdge.getTail() != this.node2) continue;
                    return tmpEdge;
                }
                this.inEdges = null;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        public Object nextElement() {
            if (this.next == null) {
                throw new NoSuchElementException("Node$Enumerator");
            }
            Edge edge = this.next;
            this.next = this.next();
            return edge;
        }

        @Override
        public void remove() {
        }
    }
}

