/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.Grappa;
import att.grappa.GrappaConstants;
import att.grappa.GrappaPoint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class GrappaLine
implements GrappaConstants,
Cloneable,
Shape {
    public static final double arrowLength = 10.0;
    public static final double arrowWidth = 5.0;
    public static final int NONE_ARROW_EDGE = 0;
    public static final int HEAD_ARROW_EDGE = 1;
    public static final int TAIL_ARROW_EDGE = 2;
    public static final int BOTH_ARROW_EDGE = 3;
    private GeneralPath path = null;
    private GeneralPath testpath = null;
    private int arrow = 0;
    private GrappaPoint[] gpts = null;
    private int windingRule = Grappa.windingRule;

    public GrappaLine(GrappaPoint[] pts, int type) {
        this.updateLine(pts, type);
    }

    public GrappaLine(String curve) {
        this.updateLine(curve);
    }

    public GrappaPoint[] getGrappaPoints() {
        return this.gpts;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof GrappaLine)) {
            return false;
        }
        GrappaLine cmp = (GrappaLine)obj;
        if (cmp == this) {
            return true;
        }
        if (cmp.getArrowType() != this.arrow) {
            return false;
        }
        return cmp.gpts.length == this.gpts.length && this.gpts.equals(cmp.gpts);
    }

    public int getArrowType() {
        return this.arrow;
    }

    public int getWindingRule() {
        return this.windingRule;
    }

    public boolean startsNear(Point2D pt) {
        return this.gpts[0].distance(pt) < this.gpts[this.gpts.length - 1].distance(pt);
    }

    public String toAttributeString() {
        return this.toFormattedString("%p");
    }

    public String toFormattedString(String pointFormat) {
        int ps = 0;
        int pe = this.gpts.length - 1;
        boolean spacer = false;
        StringBuilder buf = new StringBuilder();
        if ((this.arrow & 1) != 0) {
            buf.append("s,");
            buf.append(this.gpts[ps++].toFormattedString(pointFormat));
            spacer = true;
        }
        if ((this.arrow & 2) != 0) {
            if (spacer) {
                buf.append(" e,");
            } else {
                buf.append("e,");
                spacer = true;
            }
            buf.append(this.gpts[pe--].toFormattedString(pointFormat));
        }
        while (ps <= pe) {
            if (spacer) {
                buf.append(' ');
            } else {
                spacer = true;
            }
            buf.append(this.gpts[ps++].toFormattedString(pointFormat));
        }
        return buf.toString();
    }

    public String toString() {
        int ps = 0;
        int pe = this.gpts.length - 1;
        boolean spacer = false;
        StringBuilder buf = new StringBuilder();
        if ((this.arrow & 1) != 0) {
            buf.append("s,");
            buf.append(this.gpts[ps].x);
            buf.append(',');
            buf.append(this.gpts[ps++].y);
            spacer = true;
        }
        if ((this.arrow & 2) != 0) {
            if (spacer) {
                buf.append(" e,");
            } else {
                buf.append("e,");
                spacer = true;
            }
            buf.append(this.gpts[pe].x);
            buf.append(',');
            buf.append(this.gpts[pe--].y);
        }
        while (ps <= pe) {
            if (spacer) {
                buf.append(" ");
            } else {
                spacer = true;
            }
            buf.append(this.gpts[ps].x);
            buf.append(',');
            buf.append(this.gpts[ps++].y);
        }
        return buf.toString();
    }

    public boolean changeArrowType(int new_type) {
        boolean changed = false;
        if (this.arrow != new_type && (new_type & 0xFFFFFFFC) == 0) {
            changed = true;
            this.updateLine(this.gpts, new_type);
        }
        return changed;
    }

    private void addArrow(GeneralPath path, GeneralPath testpath, GrappaPoint tip, GrappaPoint shaft, double length, double width) {
        double theta = Math.atan2(tip.y - shaft.y, tip.x - shaft.x);
        double half_width = width / 2.0;
        float sinTheta = (float)Math.sin(theta);
        float cosTheta = (float)Math.cos(theta);
        float x = (float)(tip.x - (length * (double)cosTheta - half_width * (double)sinTheta));
        float y = (float)(tip.y - (length * (double)sinTheta + half_width * (double)cosTheta));
        path.lineTo(x, y);
        testpath.lineTo(x, y);
        x = (float)(tip.x - (length * (double)cosTheta + half_width * (double)sinTheta));
        y = (float)(tip.y - (length * (double)sinTheta - half_width * (double)cosTheta));
        path.lineTo(x, y);
        testpath.lineTo(x, y);
        x = (float)tip.x;
        y = (float)tip.y;
        path.lineTo(x, y);
        testpath.lineTo(x, y);
    }

    private void updateLine(String curve) {
        int k;
        int i;
        int type = 0;
        int len = curve.length();
        int pts = 1;
        boolean wasSpace = true;
        GrappaPoint[] grpts = null;
        int j = len;
        block5: for (i = 0; i < len; ++i) {
            switch (curve.charAt(i)) {
                case 's': {
                    wasSpace = false;
                    ++type;
                    continue block5;
                }
                case 'e': {
                    wasSpace = false;
                    type += 2;
                    continue block5;
                }
                case ' ': {
                    if (wasSpace) continue block5;
                    if (j == len) {
                        j = i;
                    }
                    ++pts;
                    wasSpace = true;
                    continue block5;
                }
                default: {
                    wasSpace = false;
                }
            }
        }
        if (wasSpace) {
            --pts;
        }
        if (pts < 2 || type > 3) {
            throw new IllegalArgumentException("bad curve specifier string (" + curve + ")");
        }
        grpts = new GrappaPoint[pts];
        for (i = 0; i < len && curve.charAt(i) == ' '; ++i) {
        }
        pts = 0;
        if (curve.charAt(i) == 's') {
            grpts[pts++] = new GrappaPoint(curve.substring(i + 2, j));
            for (i = ++j; i < len && curve.charAt(i) == ' '; ++i) {
            }
            k = j;
            j = len;
            while (k < j) {
                if (curve.charAt(k) == ' ') {
                    j = k;
                    break;
                }
                ++k;
            }
        }
        if (curve.charAt(i) == 'e') {
            grpts[grpts.length - 1] = new GrappaPoint(curve.substring(i + 2, j));
            for (i = ++j; i < len && curve.charAt(i) == ' '; ++i) {
            }
            k = j;
            j = len;
            while (k < j) {
                if (curve.charAt(k) == ' ') {
                    j = k;
                    break;
                }
                ++k;
            }
        }
        if (curve.charAt(i) == 's') {
            grpts[pts++] = new GrappaPoint(curve.substring(i + 2, j));
            for (i = ++j; i < len && curve.charAt(i) == ' '; ++i) {
            }
            k = j;
            j = len;
            while (k < j) {
                if (curve.charAt(k) == ' ') {
                    j = k;
                    break;
                }
                ++k;
            }
        }
        block13: while (i < len) {
            grpts[pts++] = new GrappaPoint(curve.substring(i, j));
            for (i = ++j; i < len && curve.charAt(i) == ' '; ++i) {
            }
            k = j;
            j = len;
            while (k < j) {
                if (curve.charAt(k) == ' ') {
                    j = k;
                    continue block13;
                }
                ++k;
            }
        }
        this.updateLine(grpts, type);
    }

    private void updateLine(GrappaPoint[] grpts, int type) {
        float y3;
        float x3;
        float y2;
        float x2;
        int pts = 0;
        int xpts = 0;
        float z = -2.0f;
        if ((type & 1) != 0) {
            xpts += 3;
        }
        if ((type & 2) != 0) {
            xpts += 3;
        }
        GeneralPath grpath = new GeneralPath(this.windingRule, grpts.length + xpts + grpts.length - 1);
        GeneralPath grtestpath = new GeneralPath(this.windingRule, grpts.length + xpts + grpts.length - 1);
        if (grpts.length < 2) {
            throw new IllegalArgumentException("need at least two supplied points");
        }
        float x = (float)grpts[pts].x;
        float y = (float)grpts[pts++].y;
        grpath.moveTo(x, y);
        grtestpath.moveTo(x + z, y + z);
        if ((type & 1) != 0) {
            grtestpath.moveTo(x + z, y + z);
            this.addArrow(grpath, grtestpath, grpts[pts - 1], grpts[pts], 10.0, 5.0);
            x = (float)grpts[pts].x;
            y = (float)grpts[pts++].y;
            grpath.lineTo(x, y);
            grtestpath.lineTo(x - z, y - z);
        } else {
            grtestpath.lineTo(x - z, y - z);
        }
        boolean lastWasLine = false;
        while (pts < grpts.length) {
            lastWasLine = false;
            if (pts + 3 <= grpts.length) {
                x = (float)grpts[pts].x;
                y = (float)grpts[pts++].y;
                x2 = (float)grpts[pts].x;
                y2 = (float)grpts[pts++].y;
                x3 = (float)grpts[pts].x;
                y3 = (float)grpts[pts++].y;
                grpath.curveTo(x, y, x2, y2, x3, y3);
                grtestpath.curveTo(x - z, y - z, x2 - z, y2 - z, x3 - z, y3 - z);
                continue;
            }
            lastWasLine = true;
            x = (float)grpts[pts].x;
            y = (float)grpts[pts++].y;
            grpath.lineTo(x, y);
            grtestpath.lineTo(x - z, y - z);
        }
        if ((type & 2) != 0) {
            this.addArrow(grpath, grtestpath, grpts[pts - 1], grpts[pts - 2], 10.0, 5.0);
        }
        --pts;
        while (pts > 0) {
            if (!lastWasLine && pts - 3 >= 0) {
                x = (float)grpts[--pts].x;
                y = (float)grpts[pts].y;
                x2 = (float)grpts[--pts].x;
                y2 = (float)grpts[pts].y;
                x3 = (float)grpts[--pts].x;
                y3 = (float)grpts[pts].y;
                grpath.curveTo(x, y, x2, y2, x3, y3);
                grtestpath.curveTo(x + z, y + z, x2 + z, y2 + z, x3 + z, y3 + z);
                continue;
            }
            lastWasLine = false;
            x = (float)grpts[--pts].x;
            y = (float)grpts[pts].y;
            grpath.lineTo(x, y);
            grtestpath.lineTo(x + z, y + z);
        }
        this.gpts = grpts;
        this.path = grpath;
        this.testpath = grtestpath;
        this.arrow = type;
    }

    public Object clone() {
        try {
            GrappaLine copy = (GrappaLine)super.clone();
            copy.path = (GeneralPath)this.path.clone();
            if (this.gpts != null) {
                copy.gpts = (GrappaPoint[])this.gpts.clone();
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public final boolean contains(double x, double y) {
        return this.testpath.contains(x, y);
    }

    public final boolean contains(double x, double y, double width, double height) {
        return this.testpath.contains(x, y, width, height);
    }

    public final boolean contains(Point2D p) {
        return this.testpath.contains(p);
    }

    public final boolean contains(Rectangle2D r) {
        return this.testpath.contains(r);
    }

    public final Rectangle getBounds() {
        return this.path.getBounds2D().getBounds();
    }

    public final Rectangle2D getBounds2D() {
        return this.path.getBounds2D();
    }

    public final PathIterator getPathIterator() {
        return this.path.getPathIterator(null);
    }

    public final PathIterator getPathIterator(AffineTransform at) {
        return this.path.getPathIterator(at);
    }

    public final PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new FlatteningPathIterator(this.path.getPathIterator(at), flatness);
    }

    public final boolean intersects(double x, double y, double width, double height) {
        return this.testpath.intersects(x, y, width, height);
    }

    public final boolean intersects(Rectangle2D r) {
        return this.testpath.intersects(r);
    }
}

