/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.visualisation.Command;
import com.parctechnologies.eclipse.visualisation.CreateEvent;
import com.parctechnologies.eclipse.visualisation.DestroyEvent;
import com.parctechnologies.eclipse.visualisation.PolicySelectedCommand;
import com.parctechnologies.eclipse.visualisation.Scenario;
import com.parctechnologies.eclipse.visualisation.ScenarioIterator;
import com.parctechnologies.eclipse.visualisation.SymRefCommand;
import com.parctechnologies.eclipse.visualisation.VisClientStateModel;
import com.parctechnologies.eclipse.visualisation.VisEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class ScenarioManager {
    private HashMap scenarioMap = new HashMap();
    private HashMap iteratorMap = new HashMap();
    private static VisClientStateModel stateModel;
    private static ScenarioManager instance;
    private File defaultScenarioDirectory;

    public static synchronized ScenarioManager getInstance() {
        if (instance == null) {
            instance = new ScenarioManager();
        }
        return instance;
    }

    public static void initialise(VisClientStateModel visClientStateModel) {
        stateModel = visClientStateModel;
    }

    private ScenarioManager() {
    }

    public VisClientStateModel getVisClientStateModel() {
        return stateModel;
    }

    public void registerScenario(Scenario scenario) {
        this.scenarioMap.put(scenario.getViewableName(), scenario);
    }

    public Collection getScenarioForName(String string) {
        Scenario scenario = null;
        if (this.scenarioMap.containsKey(string)) {
            scenario = (Scenario)this.scenarioMap.get(string);
        } else {
            scenario = new Scenario(string);
            this.registerScenario(scenario);
        }
        LinkedList<Scenario> linkedList = new LinkedList<Scenario>();
        linkedList.add(scenario);
        return linkedList;
    }

    public Scenario getExactScenarioForName(Object object) {
        if (this.scenarioMap.containsKey(object)) {
            return (Scenario)this.scenarioMap.get(object);
        }
        return null;
    }

    public Scenario getMatchingScenarioForPlayback(Object object) {
        if (this.scenarioMap.containsKey(object)) {
            Scenario scenario = (Scenario)this.scenarioMap.get(object);
            return scenario;
        }
        return null;
    }

    public void registerIteratorForPlayback(Scenario scenario, Object object) {
        this.iteratorMap.put(object, scenario.iterator());
    }

    public void clearIteratorForPlayback(Object object) {
        this.iteratorMap.remove(object);
    }

    public ScenarioIterator getPlayingIteratorForName(Object object) {
        if (this.iteratorMap.containsKey(object)) {
            ScenarioIterator scenarioIterator = (ScenarioIterator)this.iteratorMap.get(object);
            return scenarioIterator;
        }
        return null;
    }

    public void saveScenarioToDisk() {
        Collection collection = this.selectScenarios();
        if (collection != null) {
            this.saveScenarios(collection);
        }
    }

    Collection selectScenarios() {
        LinkedList<Scenario> linkedList = null;
        Scenario[] scenarioArray = new Scenario[this.scenarioMap.size()];
        Object[] objectArray = new Object[this.scenarioMap.size()];
        JCheckBox[] jCheckBoxArray = new JCheckBox[this.scenarioMap.size()];
        int n = 0;
        if (objectArray.length == 0) {
            JOptionPane.showMessageDialog(null, "There are no currently no scenarios in memory.");
            return null;
        }
        for (Object k : this.scenarioMap.keySet()) {
            Scenario scenario = (Scenario)this.scenarioMap.get(k);
            objectArray[n] = k.toString();
            scenarioArray[n] = scenario;
            jCheckBoxArray[n] = new JCheckBox(k.toString());
            jCheckBoxArray[n].setSelected(false);
            ++n;
        }
        int n2 = JOptionPane.showConfirmDialog(null, jCheckBoxArray, "Select the scenarios to save", 2, 1);
        if (n2 == 2) {
            return null;
        }
        for (n = 0; n < jCheckBoxArray.length; ++n) {
            if (!jCheckBoxArray[n].isSelected()) continue;
            if (linkedList == null) {
                linkedList = new LinkedList<Scenario>();
            }
            linkedList.add(scenarioArray[n]);
        }
        return linkedList;
    }

    void saveScenarios(Collection collection) {
        int n;
        Object object = "";
        if (collection.size() == 1) {
            object = ((Scenario)collection.iterator().next()).getViewableName();
        }
        ScenarioFileChooser scenarioFileChooser = new ScenarioFileChooser(object);
        if (this.defaultScenarioDirectory != null) {
            scenarioFileChooser.setCurrentDirectory(this.defaultScenarioDirectory);
        }
        if ((n = scenarioFileChooser.showSaveDialog(null)) == 0) {
            File file = scenarioFileChooser.getSelectedFile();
            if (!file.toString().endsWith(".scenario") && !file.toString().endsWith(".SCENARIO")) {
                file = new File(file.toString() + ".scenario");
            }
            if (!file.exists() || 0 == JOptionPane.showConfirmDialog(null, "File already exists\nReplace " + file + "?", "File exists", 0)) {
                try {
                    this.saveScenariosToFile(file, collection);
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(null, "File \n" + file + "\n exception occured during save\n" + iOException, "Error in Visualisation Client", 0);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    JOptionPane.showMessageDialog(null, "File \n" + file + "\n exception occured during save\n" + classNotFoundException, "Error in Visualisation Client", 0);
                }
            } else {
                JOptionPane.showMessageDialog(null, "File \n" + file + "\nwas not saved", "Warning", 0);
            }
        }
        this.defaultScenarioDirectory = scenarioFileChooser.getCurrentDirectory();
    }

    private void saveScenariosToFile(File file, Collection collection) throws IOException, ClassNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(collection);
        fileOutputStream.close();
    }

    public void loadScenarioForPlayback() {
        Collection collection = this.loadScenarios("");
        if (collection != null && collection.size() > 0) {
            String[] stringArray = new String[collection.size() + 1];
            stringArray[0] = "Successfully loaded scenarios for viewables : ";
            int n = 1;
            for (Scenario scenario : collection) {
                this.registerScenario(scenario);
                stringArray[n] = scenario.getViewableName();
                ++n;
            }
            JOptionPane.showMessageDialog(null, stringArray);
        }
    }

    public Collection loadScenarios(Object object) {
        ScenarioFileChooser scenarioFileChooser = new ScenarioFileChooser(object);
        if (this.defaultScenarioDirectory != null) {
            scenarioFileChooser.setCurrentDirectory(this.defaultScenarioDirectory);
        }
        int n = scenarioFileChooser.showOpenDialog(null);
        Collection collection = null;
        if (n == 0) {
            File file = scenarioFileChooser.getSelectedFile();
            if (file.exists()) {
                try {
                    collection = this.loadScenariosFromFile(file);
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(null, "File \n" + file + "\n exception occured during load\n" + iOException, "Error in Visualisation Client", 0);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    JOptionPane.showMessageDialog(null, "File \n" + file + "\n exception occured during load\n" + classNotFoundException, "Error in Visualisation Client", 0);
                }
            } else {
                JOptionPane.showMessageDialog(null, "File \n" + file + "\ndoes not exist", "Error in Visualisation Client", 0);
            }
        }
        this.defaultScenarioDirectory = scenarioFileChooser.getCurrentDirectory();
        return collection;
    }

    private Collection loadScenariosFromFile(File file) throws IOException, ClassNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(file);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        ArrayList<Object> arrayList = null;
        Object object = objectInputStream.readObject();
        if (object instanceof Scenario) {
            arrayList = new ArrayList<Object>(1);
            arrayList.add(object);
        } else {
            arrayList = (ArrayList<Object>)object;
        }
        fileInputStream.close();
        return arrayList;
    }

    public void selectPlaybackScenario(String string) {
        Scenario scenario = this.getMatchingScenarioForPlayback(string);
        boolean bl = false;
        if (scenario != null) {
            int n = JOptionPane.showConfirmDialog(null, "Reinstate saved visualisation preferences for viewable " + string + "?", "Visualisation preferences", 0);
            boolean bl2 = bl = n == 0;
        }
        if (bl) {
            ScenarioManager.getInstance().registerIteratorForPlayback(scenario, string);
        } else {
            ScenarioManager.getInstance().clearIteratorForPlayback(string);
        }
    }

    public void processEvent(VisEvent visEvent) {
        Object object;
        if (stateModel.getRecordScenario() && stateModel.getCurrentState() == 1) {
            if (visEvent instanceof CreateEvent) {
                this.registerScenario(new Scenario(visEvent.getViewableName()));
            }
            if ((object = this.getExactScenarioForName(visEvent.getViewableName())) != null) {
                ((Scenario)object).add(visEvent, stateModel.getCurrentState());
            }
        }
        if ((object = this.getPlayingIteratorForName(visEvent.getViewableName())) != null && ((ScenarioIterator)object).matches(visEvent)) {
            ((ScenarioIterator)object).play(stateModel.getCurrentState());
        }
        if (visEvent instanceof DestroyEvent && stateModel.getCurrentState() == 0) {
            this.iteratorMap.remove(visEvent.getViewableName());
        }
    }

    public void processCommand(Command command) {
        if (stateModel.getRecordScenario()) {
            Scenario scenario;
            String string = null;
            if (command instanceof SymRefCommand) {
                string = ((SymRefCommand)command).getSymRef().getRoot().toString();
                string = string.substring(1);
            } else if (command instanceof PolicySelectedCommand) {
                string = ((PolicySelectedCommand)command).getViewableName();
            }
            if (string != null && (scenario = this.getExactScenarioForName(string)) != null) {
                scenario.add(command, stateModel.getCurrentState());
            }
        }
    }

    private static class ScenarioFileChooser
    extends JFileChooser
    implements PropertyChangeListener {
        Object viewableName;

        ScenarioFileChooser(Object object) {
            this.viewableName = object;
            this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
            this.setFileSelectionMode(0);
            this.setFileFilter(new ScenarioFileFilter(object));
            this.addPropertyChangeListener("directoryChanged", this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.setSelectedFile(null);
        }
    }

    private static class ScenarioFileFilter
    extends FileFilter {
        Object viewableName;

        public ScenarioFileFilter(Object object) {
            this.viewableName = object;
        }

        @Override
        public String getDescription() {
            return "Visualisation Scenario";
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.toString().endsWith(".scenario") || file.toString().endsWith(".SCENARIO");
        }
    }
}

