/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.visualisation.DebuggingSupport;
import com.parctechnologies.eclipse.visualisation.SpreadSheetModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class SpreadSheet
extends JTable {
    protected Component tableRowHeader;

    public SpreadSheet(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
    }

    @Override
    protected void configureEnclosingScrollPane() {
        Container container;
        super.configureEnclosingScrollPane();
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            Component component = this.getTableRowHeader();
            jScrollPane.setRowHeaderView(component);
            jScrollPane.getRowHeader().setPreferredSize(component.getPreferredSize());
        }
    }

    protected Component getTableRowHeader() {
        if (this.tableRowHeader == null) {
            RowHeaderModel rowHeaderModel = new RowHeaderModel();
            JTable jTable = new JTable(rowHeaderModel);
            this.getModel().addTableModelListener(rowHeaderModel);
            jTable.setIntercellSpacing(new Dimension(0, 0));
            jTable.setAutoResizeMode(0);
            jTable.setCellSelectionEnabled(false);
            jTable.setOpaque(false);
            TableColumn tableColumn = jTable.getColumn("row");
            RowHeaderCellRenderer rowHeaderCellRenderer = new RowHeaderCellRenderer();
            tableColumn.setCellRenderer(rowHeaderCellRenderer);
            this.tableRowHeader = jTable;
        }
        return this.tableRowHeader;
    }

    @Override
    public void setRowHeight(int n) {
        DebuggingSupport.logMessage(this, "setRowHeight for height=" + n);
        ((JTable)this.getTableRowHeader()).setRowHeight(n);
        super.setRowHeight(n);
    }

    public void setColumnWidth(int n) {
        DebuggingSupport.logMessage(this, "setColumnWidth for width=" + n);
        int n2 = this.getColumnCount();
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i = 0; i < n2; ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth(n);
        }
    }

    @Override
    public void setRowHeight(int n, int n2) {
    }

    @Override
    public int getRowHeight(int n) {
        int n2 = super.getRowHeight();
        return n2;
    }

    @Override
    public int getRowHeight() {
        return this.getRowHeight(0);
    }

    public void fitWidth() {
        int n = this.getParent().getWidth();
        int n2 = this.getColumnCount();
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i = 0; i < n2; ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((i + 1) * n / n2 - i * n / n2);
        }
    }

    public void fitHeight() {
        int n = this.getParent().getHeight();
        int n2 = this.getRowCount();
        this.setRowHeight(Math.max(3, n / n2));
    }

    protected class RowHeaderCellRenderer
    extends DefaultTableCellRenderer {
        protected Border border;

        public RowHeaderCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (this.border == null) {
                this.border = BorderFactory.createBevelBorder(0);
            }
            ((JLabel)component).setBorder(this.border);
            ((JLabel)component).setOpaque(false);
            return component;
        }
    }

    protected class RowHeaderModel
    extends AbstractTableModel
    implements TableModelListener {
        protected RowHeaderModel() {
        }

        @Override
        public int getRowCount() {
            return SpreadSheet.this.getModel().getRowCount();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int n) {
            return "row";
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return ((SpreadSheetModel)SpreadSheet.this.getModel()).getRowName(n);
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            block3: {
                block2: {
                    if (tableModelEvent.getType() == 1) break block2;
                    if (tableModelEvent.getType() != -1) break block3;
                }
                this.fireTableChanged(new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), -1, tableModelEvent.getType()));
            }
        }
    }
}

