/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse;

import java.io.File;
import java.util.Properties;

public class EclipseEngineOptions {
    private String defaultModule;
    private String eclipseDir;
    private int localSize;
    private int globalSize;
    private boolean useQueues = false;
    private String[] commandLineOptions = null;
    private String _peerName = "host";
    static final int MEGABYTE = 0x100000;

    public EclipseEngineOptions(File file) {
        this.setEclipseDir(file);
        this.getOptionsFromProperties(System.getProperties());
    }

    public EclipseEngineOptions() {
        this(System.getProperties());
    }

    public EclipseEngineOptions(Properties properties) {
        this.getOptionsFromProperties(properties);
    }

    private void getOptionsFromProperties(Properties properties) {
        if (this.eclipseDir == null) {
            this.getEclipseDirFromProperties(properties);
        }
        this.getDefaultModuleFromProperties(properties);
        this.getPeerNameFromProperties(properties);
        this.getGlobalSizeFromProperties(properties);
        this.getLocalSizeFromProperties(properties);
        this.getUseQueuesFromProperties(properties);
    }

    private void getEclipseDirFromProperties(Properties properties) {
        if (!properties.containsKey("eclipse.directory")) {
            throw new IllegalArgumentException("Missing eclipse.directory property");
        }
        this.setEclipseDir(new File(properties.getProperty("eclipse.directory")));
    }

    private void getDefaultModuleFromProperties(Properties properties) {
        if (properties.containsKey("eclipse.default-module")) {
            this.setDefaultModule(properties.getProperty("eclipse.default-module"));
        }
    }

    private void getPeerNameFromProperties(Properties properties) {
        if (properties.containsKey("eclipse.peer-name")) {
            this.setPeerName(properties.getProperty("eclipse.peer-name"));
        }
    }

    private void getGlobalSizeFromProperties(Properties properties) {
        if (properties.containsKey("eclipse.global-size")) {
            try {
                this.setGlobalSize(Integer.parseInt(properties.getProperty("eclipse.global-size")));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Property eclipse.global-size not an integer");
            }
        }
    }

    private void getLocalSizeFromProperties(Properties properties) {
        if (properties.containsKey("eclipse.local-size")) {
            try {
                this.setLocalSize(Integer.parseInt(properties.getProperty("eclipse.local-size")));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Property eclipse.local-size not an integer");
            }
        }
    }

    private void getUseQueuesFromProperties(Properties properties) {
        if (properties.containsKey("eclipse.use-queues")) {
            if (properties.getProperty("eclipse.use-queues").equalsIgnoreCase("true")) {
                this.setUseQueues(true);
                return;
            }
            if (properties.getProperty("eclipse.use-queues").equalsIgnoreCase("false")) {
                this.setUseQueues(false);
                return;
            }
            throw new IllegalArgumentException("Property eclipse.use-queues not a boolean");
        }
    }

    String getDefaultModule() {
        return this.defaultModule;
    }

    String[] getCommandLineOptions() {
        return this.commandLineOptions;
    }

    String getEclipseDir() {
        return this.eclipseDir;
    }

    int getLocalSize() {
        return this.localSize;
    }

    int getGlobalSize() {
        return this.globalSize;
    }

    public void setDefaultModule(String string) {
        this.defaultModule = string;
    }

    public void setPeerName(String string) {
        this._peerName = string;
    }

    String getPeerName() {
        return this._peerName;
    }

    public void setEclipseDir(File file) {
        this.eclipseDir = file.getAbsolutePath();
    }

    public void setLocalSize(int n) {
        this.localSize = n;
    }

    public void setGlobalSize(int n) {
        this.globalSize = n;
    }

    public void setUseQueues(boolean bl) {
        this.useQueues = bl;
    }

    void setCommandLineOptions(String[] stringArray) {
        this.commandLineOptions = stringArray;
    }

    boolean isUsingQueues() {
        return this.useQueues;
    }
}

