/*
 * Decompiled with CFR 0.152.
 */
package ie.ucc.cccc.viz;

import ie.ucc.cccc.viz.Colors;
import ie.ucc.cccc.viz.CumulativeProfile;
import ie.ucc.cccc.viz.FullDomain;
import ie.ucc.cccc.viz.Tuple;
import ie.ucc.cccc.viz.VisualContext;
import ie.ucc.cccc.viz.VisualState;
import ie.ucc.cccc.viz.VisualizerItemChart;
import java.io.PrintWriter;

public class VisualizerCumulativeGantt
extends VisualizerItemChart {
    public VisualizerCumulativeGantt(VisualContext visualContext) {
        super(visualContext);
    }

    @Override
    void draw(PrintWriter printWriter, VisualState visualState) {
        Tuple[] tupleArray = visualState.argumentTupleArray("tasks");
        FullDomain fullDomain = visualState.argumentDomain("limit");
        FullDomain fullDomain2 = visualState.argumentDomain("end");
        int n = tupleArray.length;
        this.setHeight(n - 1);
        if (fullDomain2 == null) {
            this.setWidth(this.computeLastEnd(tupleArray));
        } else {
            this.setWidth(Math.max(this.computeLastEnd(tupleArray), fullDomain2.getMax()));
        }
        this.standardGrid(printWriter);
        for (int i = 1; i < n; ++i) {
            this.drawTask(printWriter, tupleArray[i], i);
        }
        int[] nArray = CumulativeProfile.computeProfile(tupleArray, this.width());
        for (int i = 0; i < this.width(); ++i) {
            if (nArray[i] != fullDomain.getMax()) continue;
            this.openRectSVG(printWriter, this.posX(i), this.topY(), 1.0, this.height(), Colors.FULL_COLOR, 0.2);
        }
        this.drawEnd(printWriter, fullDomain2);
    }

    public int computeLastEnd(Tuple[] tupleArray) {
        int n = 0;
        for (int i = 1; i < tupleArray.length; ++i) {
            int n2 = tupleArray[i].getField("start").getMax();
            int n3 = tupleArray[i].getField("dur").getMax();
            n = Math.max(n, n2 + n3);
        }
        return n;
    }

    public void drawTask(PrintWriter printWriter, Tuple tuple, int n) {
        int n2 = tuple.getField("start").getMin();
        int n3 = tuple.getField("start").getMax();
        int n4 = tuple.getField("dur").getMax();
        int n5 = tuple.getField("dur").getMax();
        this.rectSVG(printWriter, this.posX(n2), this.posY(n), n3 + n5 - n2, 1.0, Colors.UNASSIGNED_COLOR);
        this.hollowRectSVG(printWriter, this.posX(n2), this.posY(n), n4, 1.0, Colors.BORDER_COLOR, 0.2);
        this.hollowRectSVG(printWriter, this.posX(n2), this.posY(n), n5, 1.0, Colors.BORDER_COLOR, 0.1);
        this.hollowRectSVG(printWriter, this.posX(n3), this.posY(n), n4, 1.0, Colors.BORDER_COLOR, 0.2);
        this.hollowRectSVG(printWriter, this.posX(n3), this.posY(n), n5, 1.0, Colors.BORDER_COLOR, 0.1);
        if (n2 + n4 > n3) {
            double d = n2 + n4 - n3;
            this.rectSVG(printWriter, this.posX(n3), this.posY(n), d, 1.0, Colors.ASSIGN_COLOR);
        }
    }
}

