/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import att.grappa.Element;
import att.grappa.GrappaSize;
import att.grappa.Node;
import com.parctechnologies.eclipse.visualisation.BooleanPropertyModel;
import com.parctechnologies.eclipse.visualisation.CreateEvent;
import com.parctechnologies.eclipse.visualisation.ExpandEvent;
import com.parctechnologies.eclipse.visualisation.GraphViewer;
import com.parctechnologies.eclipse.visualisation.SymRef;
import com.parctechnologies.eclipse.visualisation.TickBar;
import com.parctechnologies.eclipse.visualisation.Viewable;
import com.parctechnologies.eclipse.visualisation.ViewableType;
import com.parctechnologies.eclipse.visualisation.Viewer;
import com.parctechnologies.eclipse.visualisation.ViewerSetBooleanPropertyCommand;
import com.parctechnologies.eclipse.visualisation.ViewerSetXScaleCommand;
import com.parctechnologies.eclipse.visualisation.ViewletArray;
import com.parctechnologies.eclipse.visualisation.ViewletData;
import com.parctechnologies.eclipse.visualisation.ViewletDataStore;
import com.parctechnologies.eclipse.visualisation.ViewletDataStoreListener;
import com.parctechnologies.eclipse.visualisation.ViewletFactory;
import com.parctechnologies.eclipse.visualisation.ViewletRange;
import com.parctechnologies.eclipse.visualisation.ViewletType;
import com.parctechnologies.eclipse.visualisation.VisClientStateModel;
import com.parctechnologies.eclipse.visualisation.VisEvent;
import com.parctechnologies.eclipse.visualisation.viewers.BoundsViewletType;
import com.parctechnologies.eclipse.visualisation.viewers.ChartBarViewletType;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;

public class Chart2DViewer
extends GraphViewer {
    TickBar xTickBar;
    TickBar yTickBar;
    double xScale;
    double yScale;
    boolean scaleToFitHeight;
    double minimumX;
    double minimumY;
    double maximumX;
    double maximumY;
    Collection viewletTypeCollection;
    static final double INITIAL_XSCALE = 10.0;
    static final double INITIAL_YSCALE = 5.0;
    StoreListener storeListener;
    static final Color transparentColor = new Color(0.0f, 0.0f, 1.0f, 0.2f);
    static final Color solidColor = new Color(0.0f, 0.0f, 1.0f);

    public Chart2DViewer(Collection collection, VisClientStateModel visClientStateModel, Viewable viewable) {
        super((ViewletType)collection.iterator().next(), visClientStateModel, viewable, 1);
        this.viewletTypeCollection = collection;
        this.moveable = false;
        this.minimumX = 0.0;
        this.minimumY = 0.0;
        this.maximumX = 1.0;
        this.maximumY = 1.0;
        this.scaleToFitHeight = false;
    }

    @Override
    protected void prepareForCreate(CreateEvent createEvent) {
        this.viewletDataStore = new ViewletArray(createEvent.getViewableSize(), ((ViewableType.ArrayType)createEvent.getViewableType()).getFixityList(), this.getViewable(), (ViewletFactory)((Object)this.viewletType));
        this.viewletDataStore.setSymRef(new SymRef(this.viewletDataStore, this.getSymRef(), "store"));
        this.storeListener = new StoreListener();
        this.viewletDataStore.addViewletDataStoreListener(this.storeListener);
    }

    @Override
    protected void initialiseMenu() {
        this.addMenuAndPopupMenuItem("View", null);
        this.addMenuAndPopupMenuItem("View", new GraphViewer.GrappaAntiAliasToggleAction(this));
        this.addMenuAndPopupMenuItem("Graph", new GraphViewer.SetBackgroundAction(this, this, false));
        this.addMenuAndPopupMenuItem("Graph", new GraphViewer.SetBackgroundAction(this, this, true));
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Scale to fit height");
        jCheckBoxMenuItem.setModel(new BooleanPropertyModel("scaleToFitHeight", this, this.getPropertyChangeSupport()));
        this.setScaleToFitHeightPrivate(true);
        this.addMenuAndPopupMenuItem("View", null);
        this.addMenuAndPopupMenuItem("View", jCheckBoxMenuItem);
    }

    @Override
    protected int getMenuMnemonic(String string) {
        if ("Chart".equals(string)) {
            return 67;
        }
        return super.getMenuMnemonic(string);
    }

    @Override
    public Collection getViewerPopupMenuCollection() {
        Collection collection = super.getViewerPopupMenuCollection();
        collection.add(this.getPopupMenu("Chart"));
        return collection;
    }

    @Override
    protected void initialiseGraph() {
        this.graph = new GraphViewer.SteadyGraph(this.getViewable().getNameString(), true, false, 100.0);
        this.initialiseChart();
    }

    @Override
    protected void initialiseComponent() {
        super.initialiseComponent();
        GrappaSize grappaSize = (GrappaSize)this.graph.getAttributeValue("margin");
        double d = 0.0;
        if (grappaSize != null) {
            d = 72.0 * grappaSize.width;
        }
        this.xTickBar = new TickBar((JComponent)this.graphPanel, false, 10, 1, 10.0, d);
        this.yTickBar = new TickBar((JComponent)this.graphPanel, true, 10, 1, 5.0, d);
        TickBarMouseListener tickBarMouseListener = new TickBarMouseListener();
        this.xTickBar.addMouseListener(tickBarMouseListener);
        this.xTickBar.addMouseMotionListener(tickBarMouseListener);
        this.scrollPane.setColumnHeaderView(this.xTickBar);
        this.scrollPane.setRowHeaderView(this.yTickBar);
        this.setXScalePrivate(new Double(10.0));
        this.setYScalePrivate(new Double(5.0));
    }

    @Override
    public void startEvent(VisEvent visEvent, List list) {
        if (visEvent instanceof ExpandEvent) {
            super.startEvent(visEvent, list);
            this.addNewNodes(this.getExpandingElementIndices());
            this.storeListener.rangeUpdated(this.viewletDataStore, this.viewletDataStore.getEntireViewletRange());
            this.graph.resetBoundingBox();
            this.graph.repaint();
            return;
        }
        super.startEvent(visEvent, list);
    }

    String makeLabel(List list) {
        StringBuffer stringBuffer = new StringBuffer(this.getLocationName(1, (Integer)list.get(0)));
        for (int i = 1; i < list.size(); ++i) {
            stringBuffer.append(',');
            stringBuffer.append(this.getLocationName(i + 1, (Integer)list.get(i)));
        }
        return stringBuffer.toString();
    }

    void addNewNodes(ViewletRange viewletRange) {
        for (List list : viewletRange) {
            ViewletData viewletData = null;
            Node node = this.insertNode(this.viewletDataStore, list, viewletData, this.viewletType);
            node.getGrappaNexus().boundText = false;
        }
    }

    protected void initialiseChart() {
        this.addNewNodes(this.viewletDataStore.getEntireViewletRange());
    }

    @Override
    public String getToolTip(List list) {
        return this.makeLabel(list) + ":" + this.viewletDataStore.getViewletDataAt(list).toString();
    }

    @Override
    void customizeViewlets() {
        int n = (Integer)this.viewletDataStore.getSize().get(0);
        int n2 = (Integer)this.viewletDataStore.getSize().get(1);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(2);
        arrayList.add(new Integer(1));
        arrayList.add(new Integer(1));
        for (int i = 1; i < n + 1; ++i) {
            Integer n3 = new Integer(i);
            arrayList.set(0, n3);
            arrayList.set(1, new Integer(1));
            Element element = this.getElement(arrayList);
            this.elementToViewletType(arrayList).customizeElement(this.viewletDataStore, arrayList, element);
        }
    }

    @Override
    public void zoomToLevel(float f) {
        super.zoomToLevel(f);
        this.xTickBar.zoomToLevel(f);
        this.yTickBar.zoomToLevel(f);
    }

    @Override
    public void zoomInByRatio(float f) {
        super.zoomInByRatio(f);
        this.xTickBar.zoomInByRatio(f);
        this.yTickBar.zoomInByRatio(f);
    }

    public void setXScale(double d) {
        new ViewerSetXScaleCommand((Viewer)this, d).issue();
    }

    public void setXScalePrivate(Object object) {
        this.xScale = (Double)object;
        ((ChartBarViewletType)this.viewletType).setXScale(this.xScale);
        this.xTickBar.setScale(this.xScale);
        this.storeListener.rangeUpdated(this.viewletDataStore, this.viewletDataStore.getEntireViewletRange());
        this.graph.resetBoundingBox();
    }

    public void setYScalePrivate(Object object) {
        this.yScale = (Double)object;
        ((ChartBarViewletType)this.viewletType).setYScale(this.yScale);
        this.yTickBar.setScale(this.yScale);
        this.storeListener.rangeUpdated(this.viewletDataStore, this.viewletDataStore.getEntireViewletRange());
        this.graph.resetBoundingBox();
    }

    protected void reScaleY() {
        double d = this.scrollPane.getViewport().getExtentSize().getHeight() - 100.0;
        double d2 = this.maximumY - this.minimumY;
        this.setYScalePrivate(new Double(d / d2));
    }

    public boolean getScaleToFitHeight() {
        return this.scaleToFitHeight;
    }

    public void setScaleToFitHeight(boolean bl) {
        new ViewerSetBooleanPropertyCommand(this, "scaleToFitHeight", bl).issue();
    }

    public void setScaleToFitHeightPrivate(boolean bl) {
        boolean bl2 = this.scaleToFitHeight;
        this.scaleToFitHeight = bl;
        this.getPropertyChangeSupport().firePropertyChange("scaleToFitHeight", bl2, bl);
    }

    protected class StoreListener
    implements ViewletDataStoreListener {
        @Override
        public void rangeUpdated(ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
            Iterator iterator = viewletRange.iterator();
            while (iterator.hasNext()) {
                ArrayList arrayList = new ArrayList((List)iterator.next());
                Element element = Chart2DViewer.this.getElement(arrayList);
                ViewletType viewletType = Chart2DViewer.this.elementToViewletType(arrayList);
                if (viewletType instanceof BoundsViewletType && Chart2DViewer.this.scaleToFitHeight) {
                    BoundsViewletType boundsViewletType = (BoundsViewletType)viewletType;
                    double d = boundsViewletType.getMin(viewletDataStore, arrayList);
                    double d2 = boundsViewletType.getMax(viewletDataStore, arrayList);
                    boolean bl = false;
                    if (d < Chart2DViewer.this.minimumY) {
                        Chart2DViewer.this.minimumY = d;
                        bl = true;
                    }
                    if (d2 > Chart2DViewer.this.maximumY) {
                        Chart2DViewer.this.maximumY = d2;
                        bl = true;
                    }
                    if (bl) {
                        Chart2DViewer.this.reScaleY();
                    }
                }
                viewletType.customizeElement(viewletDataStore, arrayList, element);
            }
            Chart2DViewer.this.graph.repaint();
        }
    }

    class TickBarMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        int initialX;
        double initialXScale;

        TickBarMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.initialX = mouseEvent.getX() - (int)(Chart2DViewer.this.xTickBar.displayMargin * (double)Chart2DViewer.this.xTickBar.zoomLevel);
            this.initialXScale = Chart2DViewer.this.xScale;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX() - (int)(Chart2DViewer.this.xTickBar.displayMargin * (double)Chart2DViewer.this.xTickBar.zoomLevel);
            Chart2DViewer.this.xTickBar.setScalingRight(n > this.initialX);
            Chart2DViewer.this.xTickBar.setScale(this.initialXScale * (double)n / (double)this.initialX);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            int n = mouseEvent.getX() - (int)(Chart2DViewer.this.xTickBar.displayMargin * (double)Chart2DViewer.this.xTickBar.zoomLevel);
            Chart2DViewer.this.setXScale(this.initialXScale * (double)n / (double)this.initialX);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

