/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import java.awt.Color;
import java.util.HashMap;

public abstract class GrappaColor {
    private static HashMap<String, Color> colorTable = new HashMap(660, 10.0f);
    private static HashMap<Color, String> colorLookUp = new HashMap(660, 10.0f);
    public static final Color defaultForeground;
    public static final Color defaultBackground;
    public static final Color defaultXOR;
    public static final Color defaultFontcolor;
    public static final Color defaultColor;

    public static void addColor(String name, Color color) throws IllegalArgumentException {
        if (name == null || color == null) {
            throw new IllegalArgumentException("supplied name or color is null");
        }
        String canonName = GrappaColor.canonColor(name, null);
        if (canonName == null) {
            throw new IllegalArgumentException("supplied name does not contain alphabetics (" + name + ")");
        }
        GrappaColor.doAddColor(canonName, color);
    }

    private static void doAddColor(String name, Color color, boolean override) {
        colorTable.put(name, color);
        if (override || colorLookUp.get(color) == null) {
            colorLookUp.put(color, name);
        }
    }

    private static void doAddColor(String name, Color color) {
        GrappaColor.doAddColor(name, color, true);
    }

    private static String canonColor(String name, float[] hsb) {
        if (hsb != null) {
            hsb[2] = -1.0f;
            hsb[1] = -1.0f;
            hsb[0] = -1.0f;
        }
        if (name == null) {
            return null;
        }
        char[] array = name.toCharArray();
        int len = 0;
        int commas = 0;
        int[] commaSpots = new int[3];
        int dots = 0;
        boolean allDigits = true;
        for (int i = 0; i < array.length; ++i) {
            if (Character.isUpperCase(array[i])) {
                array[len++] = Character.toLowerCase(array[i]);
                allDigits = false;
                continue;
            }
            if (Character.isLowerCase(array[i])) {
                array[len++] = array[i];
                allDigits = false;
                continue;
            }
            if (Character.isDigit(array[i])) {
                array[len++] = array[i];
                continue;
            }
            if (array[i] == ',') {
                if (commas < 2) {
                    commaSpots[commas] = i;
                }
                ++commas;
                array[len++] = array[i];
                continue;
            }
            if (array[i] != '.') continue;
            ++dots;
            array[len++] = array[i];
        }
        if (hsb != null && allDigits && commas == 2 && dots <= 3) {
            commaSpots[2] = array.length;
            int prev = 0;
            try {
                for (int i = 0; i < 3; ++i) {
                    hsb[i] = Float.valueOf(name.substring(prev, commaSpots[i])).floatValue();
                    prev = commaSpots[i] + 1;
                }
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            return new String(array, 0, len);
        }
        if (len == 0 || allDigits) {
            return null;
        }
        if (commas > 0 || dots > 0) {
            int l = len;
            len = 0;
            for (int i = 0; i < l; ++i) {
                if (array[i] == '.' || array[i] == ',') continue;
                array[len++] = array[i];
            }
        }
        return new String(array, 0, len);
    }

    public static Color getColor(String name, Color color) {
        if (color == null) {
            color = defaultColor;
        }
        if (name == null) {
            return color;
        }
        float[] hsb = new float[3];
        String canonName = GrappaColor.canonColor(name, hsb);
        Color retColor = colorTable.get(canonName);
        if (retColor == null) {
            if (hsb[0] < 0.0f) {
                retColor = color;
            } else {
                retColor = Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
                if (retColor == null) {
                    retColor = color;
                } else {
                    GrappaColor.doAddColor(canonName, retColor);
                }
            }
        }
        return retColor;
    }

    public static String getColorName(Color color) {
        if (color == null) {
            return null;
        }
        String name = colorLookUp.get(color);
        if (name == null) {
            float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            name = hsb[0] + "," + hsb[1] + "," + hsb[2];
        }
        return name;
    }

    static {
        GrappaColor.doAddColor("aliceblue", new Color(240, 248, 255));
        GrappaColor.doAddColor("antiquewhite", new Color(250, 235, 215));
        GrappaColor.doAddColor("antiquewhite1", new Color(255, 239, 219), false);
        GrappaColor.doAddColor("antiquewhite2", new Color(238, 223, 204), false);
        GrappaColor.doAddColor("antiquewhite3", new Color(205, 192, 176), false);
        GrappaColor.doAddColor("antiquewhite4", new Color(139, 131, 120), false);
        GrappaColor.doAddColor("aquamarine", new Color(127, 255, 212));
        GrappaColor.doAddColor("aquamarine1", new Color(127, 255, 212), false);
        GrappaColor.doAddColor("aquamarine2", new Color(118, 238, 198), false);
        GrappaColor.doAddColor("aquamarine3", new Color(102, 205, 170), false);
        GrappaColor.doAddColor("aquamarine4", new Color(69, 139, 116), false);
        GrappaColor.doAddColor("azure", new Color(240, 255, 255));
        GrappaColor.doAddColor("azure1", new Color(240, 255, 255), false);
        GrappaColor.doAddColor("azure2", new Color(224, 238, 238), false);
        GrappaColor.doAddColor("azure3", new Color(193, 205, 205), false);
        GrappaColor.doAddColor("azure4", new Color(131, 139, 139), false);
        GrappaColor.doAddColor("beige", new Color(245, 245, 220));
        GrappaColor.doAddColor("bisque", new Color(255, 228, 196));
        GrappaColor.doAddColor("bisque1", new Color(255, 228, 196), false);
        GrappaColor.doAddColor("bisque2", new Color(238, 213, 183), false);
        GrappaColor.doAddColor("bisque3", new Color(205, 183, 158), false);
        GrappaColor.doAddColor("bisque4", new Color(139, 125, 107), false);
        GrappaColor.doAddColor("black", new Color(0, 0, 0));
        GrappaColor.doAddColor("blanchedalmond", new Color(255, 235, 205));
        GrappaColor.doAddColor("blue", new Color(0, 0, 255));
        GrappaColor.doAddColor("blue1", new Color(0, 0, 255), false);
        GrappaColor.doAddColor("blue2", new Color(0, 0, 238), false);
        GrappaColor.doAddColor("blue3", new Color(0, 0, 205), false);
        GrappaColor.doAddColor("blue4", new Color(0, 0, 139), false);
        GrappaColor.doAddColor("blueviolet", new Color(138, 43, 226));
        GrappaColor.doAddColor("brown", new Color(165, 42, 42));
        GrappaColor.doAddColor("brown1", new Color(255, 64, 64), false);
        GrappaColor.doAddColor("brown2", new Color(238, 59, 59), false);
        GrappaColor.doAddColor("brown3", new Color(205, 51, 51), false);
        GrappaColor.doAddColor("brown4", new Color(139, 35, 35), false);
        GrappaColor.doAddColor("burlywood", new Color(222, 184, 135));
        GrappaColor.doAddColor("burlywood1", new Color(255, 211, 155), false);
        GrappaColor.doAddColor("burlywood2", new Color(238, 197, 145), false);
        GrappaColor.doAddColor("burlywood3", new Color(205, 170, 125), false);
        GrappaColor.doAddColor("burlywood4", new Color(139, 115, 85), false);
        GrappaColor.doAddColor("cadetblue", new Color(95, 158, 160));
        GrappaColor.doAddColor("cadetblue1", new Color(152, 245, 255), false);
        GrappaColor.doAddColor("cadetblue2", new Color(142, 229, 238), false);
        GrappaColor.doAddColor("cadetblue3", new Color(122, 197, 205), false);
        GrappaColor.doAddColor("cadetblue4", new Color(83, 134, 139), false);
        GrappaColor.doAddColor("chartreuse", new Color(127, 255, 0));
        GrappaColor.doAddColor("chartreuse1", new Color(127, 255, 0), false);
        GrappaColor.doAddColor("chartreuse2", new Color(118, 238, 0), false);
        GrappaColor.doAddColor("chartreuse3", new Color(102, 205, 0), false);
        GrappaColor.doAddColor("chartreuse4", new Color(69, 139, 0), false);
        GrappaColor.doAddColor("chocolate", new Color(210, 105, 30));
        GrappaColor.doAddColor("chocolate1", new Color(255, 127, 36), false);
        GrappaColor.doAddColor("chocolate2", new Color(238, 118, 33), false);
        GrappaColor.doAddColor("chocolate3", new Color(205, 102, 29), false);
        GrappaColor.doAddColor("chocolate4", new Color(139, 69, 19), false);
        GrappaColor.doAddColor("coral", new Color(255, 127, 80));
        GrappaColor.doAddColor("coral1", new Color(255, 114, 86), false);
        GrappaColor.doAddColor("coral2", new Color(238, 106, 80), false);
        GrappaColor.doAddColor("coral3", new Color(205, 91, 69), false);
        GrappaColor.doAddColor("coral4", new Color(139, 62, 47), false);
        GrappaColor.doAddColor("cornflowerblue", new Color(100, 149, 237));
        GrappaColor.doAddColor("cornsilk", new Color(255, 248, 220));
        GrappaColor.doAddColor("cornsilk1", new Color(255, 248, 220), false);
        GrappaColor.doAddColor("cornsilk2", new Color(238, 232, 205), false);
        GrappaColor.doAddColor("cornsilk3", new Color(205, 200, 177), false);
        GrappaColor.doAddColor("cornsilk4", new Color(139, 136, 120), false);
        GrappaColor.doAddColor("crimson", new Color(220, 20, 60));
        GrappaColor.doAddColor("cyan", new Color(0, 255, 255));
        GrappaColor.doAddColor("cyan1", new Color(0, 255, 255), false);
        GrappaColor.doAddColor("cyan2", new Color(0, 238, 238), false);
        GrappaColor.doAddColor("cyan3", new Color(0, 205, 205), false);
        GrappaColor.doAddColor("cyan4", new Color(0, 139, 139), false);
        GrappaColor.doAddColor("darkblue", new Color(0, 0, 139));
        GrappaColor.doAddColor("darkcyan", new Color(0, 139, 139));
        GrappaColor.doAddColor("darkgoldenrod", new Color(184, 134, 11));
        GrappaColor.doAddColor("darkgoldenrod1", new Color(255, 185, 15), false);
        GrappaColor.doAddColor("darkgoldenrod2", new Color(238, 173, 14), false);
        GrappaColor.doAddColor("darkgoldenrod3", new Color(205, 149, 12), false);
        GrappaColor.doAddColor("darkgoldenrod4", new Color(139, 101, 8), false);
        GrappaColor.doAddColor("darkgray", new Color(169, 169, 169));
        GrappaColor.doAddColor("darkgreen", new Color(0, 100, 0));
        GrappaColor.doAddColor("darkgrey", new Color(169, 169, 169), false);
        GrappaColor.doAddColor("darkkhaki", new Color(189, 183, 107));
        GrappaColor.doAddColor("darkmagenta", new Color(139, 0, 139));
        GrappaColor.doAddColor("darkolivegreen", new Color(85, 107, 47));
        GrappaColor.doAddColor("darkolivegreen1", new Color(202, 255, 112), false);
        GrappaColor.doAddColor("darkolivegreen2", new Color(188, 238, 104), false);
        GrappaColor.doAddColor("darkolivegreen3", new Color(162, 205, 90), false);
        GrappaColor.doAddColor("darkolivegreen4", new Color(110, 139, 61), false);
        GrappaColor.doAddColor("darkorange", new Color(255, 140, 0));
        GrappaColor.doAddColor("darkorange1", new Color(255, 127, 0), false);
        GrappaColor.doAddColor("darkorange2", new Color(238, 118, 0), false);
        GrappaColor.doAddColor("darkorange3", new Color(205, 102, 0), false);
        GrappaColor.doAddColor("darkorange4", new Color(139, 69, 0), false);
        GrappaColor.doAddColor("darkorchid", new Color(153, 50, 204));
        GrappaColor.doAddColor("darkorchid1", new Color(191, 62, 255), false);
        GrappaColor.doAddColor("darkorchid2", new Color(178, 58, 238), false);
        GrappaColor.doAddColor("darkorchid3", new Color(154, 50, 205), false);
        GrappaColor.doAddColor("darkorchid4", new Color(104, 34, 139), false);
        GrappaColor.doAddColor("darkred", new Color(139, 0, 0));
        GrappaColor.doAddColor("darksalmon", new Color(233, 150, 122));
        GrappaColor.doAddColor("darkseagreen", new Color(143, 188, 143));
        GrappaColor.doAddColor("darkseagreen1", new Color(193, 255, 193), false);
        GrappaColor.doAddColor("darkseagreen2", new Color(180, 238, 180), false);
        GrappaColor.doAddColor("darkseagreen3", new Color(155, 205, 155), false);
        GrappaColor.doAddColor("darkseagreen4", new Color(105, 139, 105), false);
        GrappaColor.doAddColor("darkslateblue", new Color(72, 61, 139));
        GrappaColor.doAddColor("darkslategray", new Color(47, 79, 79));
        GrappaColor.doAddColor("darkslategray1", new Color(151, 255, 255), false);
        GrappaColor.doAddColor("darkslategray2", new Color(141, 238, 238), false);
        GrappaColor.doAddColor("darkslategray3", new Color(121, 205, 205), false);
        GrappaColor.doAddColor("darkslategray4", new Color(82, 139, 139), false);
        GrappaColor.doAddColor("darkslategrey", new Color(47, 79, 79), false);
        GrappaColor.doAddColor("darkturquoise", new Color(0, 206, 209));
        GrappaColor.doAddColor("darkviolet", new Color(148, 0, 211));
        GrappaColor.doAddColor("deeppink", new Color(255, 20, 147));
        GrappaColor.doAddColor("deeppink1", new Color(255, 20, 147), false);
        GrappaColor.doAddColor("deeppink2", new Color(238, 18, 137), false);
        GrappaColor.doAddColor("deeppink3", new Color(205, 16, 118), false);
        GrappaColor.doAddColor("deeppink4", new Color(139, 10, 80), false);
        GrappaColor.doAddColor("deepskyblue", new Color(0, 191, 255));
        GrappaColor.doAddColor("deepskyblue1", new Color(0, 191, 255), false);
        GrappaColor.doAddColor("deepskyblue2", new Color(0, 178, 238), false);
        GrappaColor.doAddColor("deepskyblue3", new Color(0, 154, 205), false);
        GrappaColor.doAddColor("deepskyblue4", new Color(0, 104, 139), false);
        GrappaColor.doAddColor("dimgray", new Color(105, 105, 105));
        GrappaColor.doAddColor("dimgrey", new Color(105, 105, 105), false);
        GrappaColor.doAddColor("dodgerblue", new Color(30, 144, 255));
        GrappaColor.doAddColor("dodgerblue1", new Color(30, 144, 255), false);
        GrappaColor.doAddColor("dodgerblue2", new Color(28, 134, 238), false);
        GrappaColor.doAddColor("dodgerblue3", new Color(24, 116, 205), false);
        GrappaColor.doAddColor("dodgerblue4", new Color(16, 78, 139), false);
        GrappaColor.doAddColor("firebrick", new Color(178, 34, 34));
        GrappaColor.doAddColor("firebrick1", new Color(255, 48, 48), false);
        GrappaColor.doAddColor("firebrick2", new Color(238, 44, 44), false);
        GrappaColor.doAddColor("firebrick3", new Color(205, 38, 38), false);
        GrappaColor.doAddColor("firebrick4", new Color(139, 26, 26), false);
        GrappaColor.doAddColor("floralwhite", new Color(255, 250, 240));
        GrappaColor.doAddColor("forestgreen", new Color(34, 139, 34));
        GrappaColor.doAddColor("gainsboro", new Color(220, 220, 220));
        GrappaColor.doAddColor("ghostwhite", new Color(248, 248, 255));
        GrappaColor.doAddColor("gold", new Color(255, 215, 0));
        GrappaColor.doAddColor("gold1", new Color(255, 215, 0), false);
        GrappaColor.doAddColor("gold2", new Color(238, 201, 0), false);
        GrappaColor.doAddColor("gold3", new Color(205, 173, 0), false);
        GrappaColor.doAddColor("gold4", new Color(139, 117, 0), false);
        GrappaColor.doAddColor("goldenrod", new Color(218, 165, 32));
        GrappaColor.doAddColor("goldenrod1", new Color(255, 193, 37), false);
        GrappaColor.doAddColor("goldenrod2", new Color(238, 180, 34), false);
        GrappaColor.doAddColor("goldenrod3", new Color(205, 155, 29), false);
        GrappaColor.doAddColor("goldenrod4", new Color(139, 105, 20), false);
        GrappaColor.doAddColor("green", new Color(0, 255, 0));
        GrappaColor.doAddColor("green1", new Color(0, 255, 0), false);
        GrappaColor.doAddColor("green2", new Color(0, 238, 0), false);
        GrappaColor.doAddColor("green3", new Color(0, 205, 0), false);
        GrappaColor.doAddColor("green4", new Color(0, 139, 0), false);
        GrappaColor.doAddColor("greenyellow", new Color(173, 255, 47));
        GrappaColor.doAddColor("gray", new Color(190, 190, 190));
        GrappaColor.doAddColor("grey", new Color(190, 190, 190), false);
        GrappaColor.doAddColor("gray0", new Color(0, 0, 0), false);
        GrappaColor.doAddColor("grey0", new Color(0, 0, 0), false);
        GrappaColor.doAddColor("gray1", new Color(3, 3, 3), false);
        GrappaColor.doAddColor("grey1", new Color(3, 3, 3), false);
        GrappaColor.doAddColor("gray2", new Color(5, 5, 5), false);
        GrappaColor.doAddColor("grey2", new Color(5, 5, 5), false);
        GrappaColor.doAddColor("gray3", new Color(8, 8, 8), false);
        GrappaColor.doAddColor("grey3", new Color(8, 8, 8), false);
        GrappaColor.doAddColor("gray4", new Color(10, 10, 10), false);
        GrappaColor.doAddColor("grey4", new Color(10, 10, 10), false);
        GrappaColor.doAddColor("gray5", new Color(13, 13, 13), false);
        GrappaColor.doAddColor("grey5", new Color(13, 13, 13), false);
        GrappaColor.doAddColor("gray6", new Color(15, 15, 15), false);
        GrappaColor.doAddColor("grey6", new Color(15, 15, 15), false);
        GrappaColor.doAddColor("gray7", new Color(18, 18, 18), false);
        GrappaColor.doAddColor("grey7", new Color(18, 18, 18), false);
        GrappaColor.doAddColor("gray8", new Color(20, 20, 20), false);
        GrappaColor.doAddColor("grey8", new Color(20, 20, 20), false);
        GrappaColor.doAddColor("gray9", new Color(23, 23, 23), false);
        GrappaColor.doAddColor("grey9", new Color(23, 23, 23), false);
        GrappaColor.doAddColor("gray10", new Color(26, 26, 26), false);
        GrappaColor.doAddColor("grey10", new Color(26, 26, 26), false);
        GrappaColor.doAddColor("gray11", new Color(28, 28, 28), false);
        GrappaColor.doAddColor("grey11", new Color(28, 28, 28), false);
        GrappaColor.doAddColor("gray12", new Color(31, 31, 31), false);
        GrappaColor.doAddColor("grey12", new Color(31, 31, 31), false);
        GrappaColor.doAddColor("gray13", new Color(33, 33, 33), false);
        GrappaColor.doAddColor("grey13", new Color(33, 33, 33), false);
        GrappaColor.doAddColor("gray14", new Color(36, 36, 36), false);
        GrappaColor.doAddColor("grey14", new Color(36, 36, 36), false);
        GrappaColor.doAddColor("gray15", new Color(38, 38, 38), false);
        GrappaColor.doAddColor("grey15", new Color(38, 38, 38), false);
        GrappaColor.doAddColor("gray16", new Color(41, 41, 41), false);
        GrappaColor.doAddColor("grey16", new Color(41, 41, 41), false);
        GrappaColor.doAddColor("gray17", new Color(43, 43, 43), false);
        GrappaColor.doAddColor("grey17", new Color(43, 43, 43), false);
        GrappaColor.doAddColor("gray18", new Color(46, 46, 46), false);
        GrappaColor.doAddColor("grey18", new Color(46, 46, 46), false);
        GrappaColor.doAddColor("gray19", new Color(48, 48, 48), false);
        GrappaColor.doAddColor("grey19", new Color(48, 48, 48), false);
        GrappaColor.doAddColor("gray20", new Color(51, 51, 51), false);
        GrappaColor.doAddColor("grey20", new Color(51, 51, 51), false);
        GrappaColor.doAddColor("gray21", new Color(54, 54, 54), false);
        GrappaColor.doAddColor("grey21", new Color(54, 54, 54), false);
        GrappaColor.doAddColor("gray22", new Color(56, 56, 56), false);
        GrappaColor.doAddColor("grey22", new Color(56, 56, 56), false);
        GrappaColor.doAddColor("gray23", new Color(59, 59, 59), false);
        GrappaColor.doAddColor("grey23", new Color(59, 59, 59), false);
        GrappaColor.doAddColor("gray24", new Color(61, 61, 61), false);
        GrappaColor.doAddColor("grey24", new Color(61, 61, 61), false);
        GrappaColor.doAddColor("gray25", new Color(64, 64, 64), false);
        GrappaColor.doAddColor("grey25", new Color(64, 64, 64), false);
        GrappaColor.doAddColor("gray26", new Color(66, 66, 66), false);
        GrappaColor.doAddColor("grey26", new Color(66, 66, 66), false);
        GrappaColor.doAddColor("gray27", new Color(69, 69, 69), false);
        GrappaColor.doAddColor("grey27", new Color(69, 69, 69), false);
        GrappaColor.doAddColor("gray28", new Color(71, 71, 71), false);
        GrappaColor.doAddColor("grey28", new Color(71, 71, 71), false);
        GrappaColor.doAddColor("gray29", new Color(74, 74, 74), false);
        GrappaColor.doAddColor("grey29", new Color(74, 74, 74), false);
        GrappaColor.doAddColor("gray30", new Color(77, 77, 77), false);
        GrappaColor.doAddColor("grey30", new Color(77, 77, 77), false);
        GrappaColor.doAddColor("gray31", new Color(79, 79, 79), false);
        GrappaColor.doAddColor("grey31", new Color(79, 79, 79), false);
        GrappaColor.doAddColor("gray32", new Color(82, 82, 82), false);
        GrappaColor.doAddColor("grey32", new Color(82, 82, 82), false);
        GrappaColor.doAddColor("gray33", new Color(84, 84, 84), false);
        GrappaColor.doAddColor("grey33", new Color(84, 84, 84), false);
        GrappaColor.doAddColor("gray34", new Color(87, 87, 87), false);
        GrappaColor.doAddColor("grey34", new Color(87, 87, 87), false);
        GrappaColor.doAddColor("gray35", new Color(89, 89, 89), false);
        GrappaColor.doAddColor("grey35", new Color(89, 89, 89), false);
        GrappaColor.doAddColor("gray36", new Color(92, 92, 92), false);
        GrappaColor.doAddColor("grey36", new Color(92, 92, 92), false);
        GrappaColor.doAddColor("gray37", new Color(94, 94, 94), false);
        GrappaColor.doAddColor("grey37", new Color(94, 94, 94), false);
        GrappaColor.doAddColor("gray38", new Color(97, 97, 97), false);
        GrappaColor.doAddColor("grey38", new Color(97, 97, 97), false);
        GrappaColor.doAddColor("gray39", new Color(99, 99, 99), false);
        GrappaColor.doAddColor("grey39", new Color(99, 99, 99), false);
        GrappaColor.doAddColor("gray40", new Color(102, 102, 102), false);
        GrappaColor.doAddColor("grey40", new Color(102, 102, 102), false);
        GrappaColor.doAddColor("gray41", new Color(105, 105, 105), false);
        GrappaColor.doAddColor("grey41", new Color(105, 105, 105), false);
        GrappaColor.doAddColor("gray42", new Color(107, 107, 107), false);
        GrappaColor.doAddColor("grey42", new Color(107, 107, 107), false);
        GrappaColor.doAddColor("gray43", new Color(110, 110, 110), false);
        GrappaColor.doAddColor("grey43", new Color(110, 110, 110), false);
        GrappaColor.doAddColor("gray44", new Color(112, 112, 112), false);
        GrappaColor.doAddColor("grey44", new Color(112, 112, 112), false);
        GrappaColor.doAddColor("gray45", new Color(115, 115, 115), false);
        GrappaColor.doAddColor("grey45", new Color(115, 115, 115), false);
        GrappaColor.doAddColor("gray46", new Color(117, 117, 117), false);
        GrappaColor.doAddColor("grey46", new Color(117, 117, 117), false);
        GrappaColor.doAddColor("gray47", new Color(120, 120, 120), false);
        GrappaColor.doAddColor("grey47", new Color(120, 120, 120), false);
        GrappaColor.doAddColor("gray48", new Color(122, 122, 122), false);
        GrappaColor.doAddColor("grey48", new Color(122, 122, 122), false);
        GrappaColor.doAddColor("gray49", new Color(125, 125, 125), false);
        GrappaColor.doAddColor("grey49", new Color(125, 125, 125), false);
        GrappaColor.doAddColor("gray50", new Color(127, 127, 127), false);
        GrappaColor.doAddColor("grey50", new Color(127, 127, 127), false);
        GrappaColor.doAddColor("gray51", new Color(130, 130, 130), false);
        GrappaColor.doAddColor("grey51", new Color(130, 130, 130), false);
        GrappaColor.doAddColor("gray52", new Color(133, 133, 133), false);
        GrappaColor.doAddColor("grey52", new Color(133, 133, 133), false);
        GrappaColor.doAddColor("gray53", new Color(135, 135, 135), false);
        GrappaColor.doAddColor("grey53", new Color(135, 135, 135), false);
        GrappaColor.doAddColor("gray54", new Color(138, 138, 138), false);
        GrappaColor.doAddColor("grey54", new Color(138, 138, 138), false);
        GrappaColor.doAddColor("gray55", new Color(140, 140, 140), false);
        GrappaColor.doAddColor("grey55", new Color(140, 140, 140), false);
        GrappaColor.doAddColor("gray56", new Color(143, 143, 143), false);
        GrappaColor.doAddColor("grey56", new Color(143, 143, 143), false);
        GrappaColor.doAddColor("gray57", new Color(145, 145, 145), false);
        GrappaColor.doAddColor("grey57", new Color(145, 145, 145), false);
        GrappaColor.doAddColor("gray58", new Color(148, 148, 148), false);
        GrappaColor.doAddColor("grey58", new Color(148, 148, 148), false);
        GrappaColor.doAddColor("gray59", new Color(150, 150, 150), false);
        GrappaColor.doAddColor("grey59", new Color(150, 150, 150), false);
        GrappaColor.doAddColor("gray60", new Color(153, 153, 153), false);
        GrappaColor.doAddColor("grey60", new Color(153, 153, 153), false);
        GrappaColor.doAddColor("gray61", new Color(156, 156, 156), false);
        GrappaColor.doAddColor("grey61", new Color(156, 156, 156), false);
        GrappaColor.doAddColor("gray62", new Color(158, 158, 158), false);
        GrappaColor.doAddColor("grey62", new Color(158, 158, 158), false);
        GrappaColor.doAddColor("gray63", new Color(161, 161, 161), false);
        GrappaColor.doAddColor("grey63", new Color(161, 161, 161), false);
        GrappaColor.doAddColor("gray64", new Color(163, 163, 163), false);
        GrappaColor.doAddColor("grey64", new Color(163, 163, 163), false);
        GrappaColor.doAddColor("gray65", new Color(166, 166, 166), false);
        GrappaColor.doAddColor("grey65", new Color(166, 166, 166), false);
        GrappaColor.doAddColor("gray66", new Color(168, 168, 168), false);
        GrappaColor.doAddColor("grey66", new Color(168, 168, 168), false);
        GrappaColor.doAddColor("gray67", new Color(171, 171, 171), false);
        GrappaColor.doAddColor("grey67", new Color(171, 171, 171), false);
        GrappaColor.doAddColor("gray68", new Color(173, 173, 173), false);
        GrappaColor.doAddColor("grey68", new Color(173, 173, 173), false);
        GrappaColor.doAddColor("gray69", new Color(176, 176, 176), false);
        GrappaColor.doAddColor("grey69", new Color(176, 176, 176), false);
        GrappaColor.doAddColor("gray70", new Color(179, 179, 179), false);
        GrappaColor.doAddColor("grey70", new Color(179, 179, 179), false);
        GrappaColor.doAddColor("gray71", new Color(181, 181, 181), false);
        GrappaColor.doAddColor("grey71", new Color(181, 181, 181), false);
        GrappaColor.doAddColor("gray72", new Color(184, 184, 184), false);
        GrappaColor.doAddColor("grey72", new Color(184, 184, 184), false);
        GrappaColor.doAddColor("gray73", new Color(186, 186, 186), false);
        GrappaColor.doAddColor("grey73", new Color(186, 186, 186), false);
        GrappaColor.doAddColor("gray74", new Color(189, 189, 189), false);
        GrappaColor.doAddColor("grey74", new Color(189, 189, 189), false);
        GrappaColor.doAddColor("gray75", new Color(191, 191, 191), false);
        GrappaColor.doAddColor("grey75", new Color(191, 191, 191), false);
        GrappaColor.doAddColor("gray76", new Color(194, 194, 194), false);
        GrappaColor.doAddColor("grey76", new Color(194, 194, 194), false);
        GrappaColor.doAddColor("gray77", new Color(196, 196, 196), false);
        GrappaColor.doAddColor("grey77", new Color(196, 196, 196), false);
        GrappaColor.doAddColor("gray78", new Color(199, 199, 199), false);
        GrappaColor.doAddColor("grey78", new Color(199, 199, 199), false);
        GrappaColor.doAddColor("gray79", new Color(201, 201, 201), false);
        GrappaColor.doAddColor("grey79", new Color(201, 201, 201), false);
        GrappaColor.doAddColor("gray80", new Color(204, 204, 204), false);
        GrappaColor.doAddColor("grey80", new Color(204, 204, 204), false);
        GrappaColor.doAddColor("gray81", new Color(207, 207, 207), false);
        GrappaColor.doAddColor("grey81", new Color(207, 207, 207), false);
        GrappaColor.doAddColor("gray82", new Color(209, 209, 209), false);
        GrappaColor.doAddColor("grey82", new Color(209, 209, 209), false);
        GrappaColor.doAddColor("gray83", new Color(212, 212, 212), false);
        GrappaColor.doAddColor("grey83", new Color(212, 212, 212), false);
        GrappaColor.doAddColor("gray84", new Color(214, 214, 214), false);
        GrappaColor.doAddColor("grey84", new Color(214, 214, 214), false);
        GrappaColor.doAddColor("gray85", new Color(217, 217, 217), false);
        GrappaColor.doAddColor("grey85", new Color(217, 217, 217), false);
        GrappaColor.doAddColor("gray86", new Color(219, 219, 219), false);
        GrappaColor.doAddColor("grey86", new Color(219, 219, 219), false);
        GrappaColor.doAddColor("gray87", new Color(222, 222, 222), false);
        GrappaColor.doAddColor("grey87", new Color(222, 222, 222), false);
        GrappaColor.doAddColor("gray88", new Color(224, 224, 224), false);
        GrappaColor.doAddColor("grey88", new Color(224, 224, 224), false);
        GrappaColor.doAddColor("gray89", new Color(227, 227, 227), false);
        GrappaColor.doAddColor("grey89", new Color(227, 227, 227), false);
        GrappaColor.doAddColor("gray90", new Color(229, 229, 229), false);
        GrappaColor.doAddColor("grey90", new Color(229, 229, 229), false);
        GrappaColor.doAddColor("gray91", new Color(232, 232, 232), false);
        GrappaColor.doAddColor("grey91", new Color(232, 232, 232), false);
        GrappaColor.doAddColor("gray92", new Color(235, 235, 235), false);
        GrappaColor.doAddColor("grey92", new Color(235, 235, 235), false);
        GrappaColor.doAddColor("gray93", new Color(237, 237, 237), false);
        GrappaColor.doAddColor("grey93", new Color(237, 237, 237), false);
        GrappaColor.doAddColor("gray94", new Color(240, 240, 240), false);
        GrappaColor.doAddColor("grey94", new Color(240, 240, 240), false);
        GrappaColor.doAddColor("gray95", new Color(242, 242, 242), false);
        GrappaColor.doAddColor("grey95", new Color(242, 242, 242), false);
        GrappaColor.doAddColor("gray96", new Color(245, 245, 245), false);
        GrappaColor.doAddColor("grey96", new Color(245, 245, 245), false);
        GrappaColor.doAddColor("gray97", new Color(247, 247, 247), false);
        GrappaColor.doAddColor("grey97", new Color(247, 247, 247), false);
        GrappaColor.doAddColor("gray98", new Color(250, 250, 250), false);
        GrappaColor.doAddColor("grey98", new Color(250, 250, 250), false);
        GrappaColor.doAddColor("gray99", new Color(252, 252, 252), false);
        GrappaColor.doAddColor("grey99", new Color(252, 252, 252), false);
        GrappaColor.doAddColor("gray100", new Color(255, 255, 255), false);
        GrappaColor.doAddColor("grey100", new Color(255, 255, 255), false);
        GrappaColor.doAddColor("honeydew", new Color(240, 255, 240));
        GrappaColor.doAddColor("honeydew1", new Color(240, 255, 240), false);
        GrappaColor.doAddColor("honeydew2", new Color(224, 238, 224), false);
        GrappaColor.doAddColor("honeydew3", new Color(193, 205, 193), false);
        GrappaColor.doAddColor("honeydew4", new Color(131, 139, 131), false);
        GrappaColor.doAddColor("hotpink", new Color(255, 105, 180));
        GrappaColor.doAddColor("hotpink1", new Color(255, 110, 180), false);
        GrappaColor.doAddColor("hotpink2", new Color(238, 106, 167), false);
        GrappaColor.doAddColor("hotpink3", new Color(205, 96, 144), false);
        GrappaColor.doAddColor("hotpink4", new Color(139, 58, 98), false);
        GrappaColor.doAddColor("indianred", new Color(205, 92, 92));
        GrappaColor.doAddColor("indianred1", new Color(255, 106, 106), false);
        GrappaColor.doAddColor("indianred2", new Color(238, 99, 99), false);
        GrappaColor.doAddColor("indianred3", new Color(205, 85, 85), false);
        GrappaColor.doAddColor("indianred4", new Color(139, 58, 58), false);
        GrappaColor.doAddColor("indigo", new Color(75, 0, 130));
        GrappaColor.doAddColor("ivory", new Color(255, 255, 240));
        GrappaColor.doAddColor("ivory1", new Color(255, 255, 240), false);
        GrappaColor.doAddColor("ivory2", new Color(238, 238, 224), false);
        GrappaColor.doAddColor("ivory3", new Color(205, 205, 193), false);
        GrappaColor.doAddColor("ivory4", new Color(139, 139, 131), false);
        GrappaColor.doAddColor("khaki", new Color(240, 230, 140));
        GrappaColor.doAddColor("khaki1", new Color(255, 246, 143), false);
        GrappaColor.doAddColor("khaki2", new Color(238, 230, 133), false);
        GrappaColor.doAddColor("khaki3", new Color(205, 198, 115), false);
        GrappaColor.doAddColor("khaki4", new Color(139, 134, 78), false);
        GrappaColor.doAddColor("lavender", new Color(230, 230, 250));
        GrappaColor.doAddColor("lavenderblush", new Color(255, 240, 245));
        GrappaColor.doAddColor("lavenderblush1", new Color(255, 240, 245), false);
        GrappaColor.doAddColor("lavenderblush2", new Color(238, 224, 229), false);
        GrappaColor.doAddColor("lavenderblush3", new Color(205, 193, 197), false);
        GrappaColor.doAddColor("lavenderblush4", new Color(139, 131, 134), false);
        GrappaColor.doAddColor("lawngreen", new Color(124, 252, 0));
        GrappaColor.doAddColor("lemonchiffon", new Color(255, 250, 205));
        GrappaColor.doAddColor("lemonchiffon1", new Color(255, 250, 205), false);
        GrappaColor.doAddColor("lemonchiffon2", new Color(238, 233, 191), false);
        GrappaColor.doAddColor("lemonchiffon3", new Color(205, 201, 165), false);
        GrappaColor.doAddColor("lemonchiffon4", new Color(139, 137, 112), false);
        GrappaColor.doAddColor("lightblue", new Color(173, 216, 230));
        GrappaColor.doAddColor("lightblue1", new Color(191, 239, 255), false);
        GrappaColor.doAddColor("lightblue2", new Color(178, 223, 238), false);
        GrappaColor.doAddColor("lightblue3", new Color(154, 192, 205), false);
        GrappaColor.doAddColor("lightblue4", new Color(104, 131, 139), false);
        GrappaColor.doAddColor("lightcoral", new Color(240, 128, 128));
        GrappaColor.doAddColor("lightcyan", new Color(224, 255, 255));
        GrappaColor.doAddColor("lightcyan1", new Color(224, 255, 255), false);
        GrappaColor.doAddColor("lightcyan2", new Color(209, 238, 238), false);
        GrappaColor.doAddColor("lightcyan3", new Color(180, 205, 205), false);
        GrappaColor.doAddColor("lightcyan4", new Color(122, 139, 139), false);
        GrappaColor.doAddColor("lightgoldenrod", new Color(238, 221, 130));
        GrappaColor.doAddColor("lightgoldenrod1", new Color(255, 236, 139), false);
        GrappaColor.doAddColor("lightgoldenrod2", new Color(238, 220, 130), false);
        GrappaColor.doAddColor("lightgoldenrod3", new Color(205, 190, 112), false);
        GrappaColor.doAddColor("lightgoldenrod4", new Color(139, 129, 76), false);
        GrappaColor.doAddColor("lightgoldenrodyellow", new Color(250, 250, 210));
        GrappaColor.doAddColor("lightgray", new Color(211, 211, 211));
        GrappaColor.doAddColor("lightgreen", new Color(144, 238, 144));
        GrappaColor.doAddColor("lightgrey", new Color(211, 211, 211), false);
        GrappaColor.doAddColor("lightpink", new Color(255, 182, 193));
        GrappaColor.doAddColor("lightpink1", new Color(255, 174, 185), false);
        GrappaColor.doAddColor("lightpink2", new Color(238, 162, 173), false);
        GrappaColor.doAddColor("lightpink3", new Color(205, 140, 149), false);
        GrappaColor.doAddColor("lightpink4", new Color(139, 95, 101), false);
        GrappaColor.doAddColor("lightsalmon", new Color(255, 160, 122));
        GrappaColor.doAddColor("lightsalmon1", new Color(255, 160, 122), false);
        GrappaColor.doAddColor("lightsalmon2", new Color(238, 149, 114), false);
        GrappaColor.doAddColor("lightsalmon3", new Color(205, 129, 98), false);
        GrappaColor.doAddColor("lightsalmon4", new Color(139, 87, 66), false);
        GrappaColor.doAddColor("lightseagreen", new Color(32, 178, 170));
        GrappaColor.doAddColor("lightskyblue", new Color(135, 206, 250));
        GrappaColor.doAddColor("lightskyblue1", new Color(176, 226, 255), false);
        GrappaColor.doAddColor("lightskyblue2", new Color(164, 211, 238), false);
        GrappaColor.doAddColor("lightskyblue3", new Color(141, 182, 205), false);
        GrappaColor.doAddColor("lightskyblue4", new Color(96, 123, 139), false);
        GrappaColor.doAddColor("lightslateblue", new Color(132, 112, 255));
        GrappaColor.doAddColor("lightslategray", new Color(119, 136, 153));
        GrappaColor.doAddColor("lightslategrey", new Color(119, 136, 153), false);
        GrappaColor.doAddColor("lightsteelblue", new Color(176, 196, 222));
        GrappaColor.doAddColor("lightsteelblue1", new Color(202, 225, 255), false);
        GrappaColor.doAddColor("lightsteelblue2", new Color(188, 210, 238), false);
        GrappaColor.doAddColor("lightsteelblue3", new Color(162, 181, 205), false);
        GrappaColor.doAddColor("lightsteelblue4", new Color(110, 123, 139), false);
        GrappaColor.doAddColor("lightyellow", new Color(255, 255, 224));
        GrappaColor.doAddColor("lightyellow1", new Color(255, 255, 224), false);
        GrappaColor.doAddColor("lightyellow2", new Color(238, 238, 209), false);
        GrappaColor.doAddColor("lightyellow3", new Color(205, 205, 180), false);
        GrappaColor.doAddColor("lightyellow4", new Color(139, 139, 122), false);
        GrappaColor.doAddColor("limegreen", new Color(50, 205, 50));
        GrappaColor.doAddColor("linen", new Color(250, 240, 230));
        GrappaColor.doAddColor("magenta", new Color(255, 0, 255));
        GrappaColor.doAddColor("magenta1", new Color(255, 0, 255), false);
        GrappaColor.doAddColor("magenta2", new Color(238, 0, 238), false);
        GrappaColor.doAddColor("magenta3", new Color(205, 0, 205), false);
        GrappaColor.doAddColor("magenta4", new Color(139, 0, 139), false);
        GrappaColor.doAddColor("maroon", new Color(176, 48, 96));
        GrappaColor.doAddColor("maroon1", new Color(255, 52, 179), false);
        GrappaColor.doAddColor("maroon2", new Color(238, 48, 167), false);
        GrappaColor.doAddColor("maroon3", new Color(205, 41, 144), false);
        GrappaColor.doAddColor("maroon4", new Color(139, 28, 98), false);
        GrappaColor.doAddColor("mediumaquamarine", new Color(102, 205, 170));
        GrappaColor.doAddColor("mediumblue", new Color(0, 0, 205));
        GrappaColor.doAddColor("mediumorchid", new Color(186, 85, 211));
        GrappaColor.doAddColor("mediumorchid1", new Color(224, 102, 255), false);
        GrappaColor.doAddColor("mediumorchid2", new Color(209, 95, 238), false);
        GrappaColor.doAddColor("mediumorchid3", new Color(180, 82, 205), false);
        GrappaColor.doAddColor("mediumorchid4", new Color(122, 55, 139), false);
        GrappaColor.doAddColor("mediumpurple", new Color(147, 112, 219));
        GrappaColor.doAddColor("mediumpurple1", new Color(171, 130, 255), false);
        GrappaColor.doAddColor("mediumpurple2", new Color(159, 121, 238), false);
        GrappaColor.doAddColor("mediumpurple3", new Color(137, 104, 205), false);
        GrappaColor.doAddColor("mediumpurple4", new Color(93, 71, 139), false);
        GrappaColor.doAddColor("mediumseagreen", new Color(60, 179, 113));
        GrappaColor.doAddColor("mediumslateblue", new Color(123, 104, 238));
        GrappaColor.doAddColor("mediumspringgreen", new Color(0, 250, 154));
        GrappaColor.doAddColor("mediumturquoise", new Color(72, 209, 204));
        GrappaColor.doAddColor("mediumvioletred", new Color(199, 21, 133));
        GrappaColor.doAddColor("midnightblue", new Color(25, 25, 112));
        GrappaColor.doAddColor("mintcream", new Color(245, 255, 250));
        GrappaColor.doAddColor("mistyrose", new Color(255, 228, 225));
        GrappaColor.doAddColor("mistyrose1", new Color(255, 228, 225), false);
        GrappaColor.doAddColor("mistyrose2", new Color(238, 213, 210), false);
        GrappaColor.doAddColor("mistyrose3", new Color(205, 183, 181), false);
        GrappaColor.doAddColor("mistyrose4", new Color(139, 125, 123), false);
        GrappaColor.doAddColor("moccasin", new Color(255, 228, 181));
        GrappaColor.doAddColor("navajowhite", new Color(255, 222, 173));
        GrappaColor.doAddColor("navajowhite1", new Color(255, 222, 173), false);
        GrappaColor.doAddColor("navajowhite2", new Color(238, 207, 161), false);
        GrappaColor.doAddColor("navajowhite3", new Color(205, 179, 139), false);
        GrappaColor.doAddColor("navajowhite4", new Color(139, 121, 94), false);
        GrappaColor.doAddColor("navy", new Color(0, 0, 128));
        GrappaColor.doAddColor("navyblue", new Color(0, 0, 128), false);
        GrappaColor.doAddColor("oldlace", new Color(253, 245, 230));
        GrappaColor.doAddColor("olivedrab", new Color(107, 142, 35));
        GrappaColor.doAddColor("olivedrab1", new Color(192, 255, 62), false);
        GrappaColor.doAddColor("olivedrab2", new Color(179, 238, 58), false);
        GrappaColor.doAddColor("olivedrab3", new Color(154, 205, 50), false);
        GrappaColor.doAddColor("olivedrab4", new Color(105, 139, 34), false);
        GrappaColor.doAddColor("orange", new Color(255, 165, 0));
        GrappaColor.doAddColor("orange1", new Color(255, 165, 0), false);
        GrappaColor.doAddColor("orange2", new Color(238, 154, 0), false);
        GrappaColor.doAddColor("orange3", new Color(205, 133, 0), false);
        GrappaColor.doAddColor("orange4", new Color(139, 90, 0), false);
        GrappaColor.doAddColor("orangered", new Color(255, 69, 0));
        GrappaColor.doAddColor("orangered1", new Color(255, 69, 0), false);
        GrappaColor.doAddColor("orangered2", new Color(238, 64, 0), false);
        GrappaColor.doAddColor("orangered3", new Color(205, 55, 0), false);
        GrappaColor.doAddColor("orangered4", new Color(139, 37, 0), false);
        GrappaColor.doAddColor("orchid", new Color(218, 112, 214));
        GrappaColor.doAddColor("orchid1", new Color(255, 131, 250), false);
        GrappaColor.doAddColor("orchid2", new Color(238, 122, 233), false);
        GrappaColor.doAddColor("orchid3", new Color(205, 105, 201), false);
        GrappaColor.doAddColor("orchid4", new Color(139, 71, 137), false);
        GrappaColor.doAddColor("palegoldenrod", new Color(238, 232, 170));
        GrappaColor.doAddColor("palegreen", new Color(152, 251, 152));
        GrappaColor.doAddColor("palegreen1", new Color(154, 255, 154), false);
        GrappaColor.doAddColor("palegreen2", new Color(144, 238, 144), false);
        GrappaColor.doAddColor("palegreen3", new Color(124, 205, 124), false);
        GrappaColor.doAddColor("palegreen4", new Color(84, 139, 84), false);
        GrappaColor.doAddColor("paleturquoise", new Color(175, 238, 238));
        GrappaColor.doAddColor("paleturquoise1", new Color(187, 255, 255), false);
        GrappaColor.doAddColor("paleturquoise2", new Color(174, 238, 238), false);
        GrappaColor.doAddColor("paleturquoise3", new Color(150, 205, 205), false);
        GrappaColor.doAddColor("paleturquoise4", new Color(102, 139, 139), false);
        GrappaColor.doAddColor("palevioletred", new Color(219, 112, 147));
        GrappaColor.doAddColor("palevioletred1", new Color(255, 130, 171), false);
        GrappaColor.doAddColor("palevioletred2", new Color(238, 121, 159), false);
        GrappaColor.doAddColor("palevioletred3", new Color(205, 104, 137), false);
        GrappaColor.doAddColor("palevioletred4", new Color(139, 71, 93), false);
        GrappaColor.doAddColor("papayawhip", new Color(255, 239, 213));
        GrappaColor.doAddColor("peachpuff", new Color(255, 218, 185));
        GrappaColor.doAddColor("peachpuff1", new Color(255, 218, 185), false);
        GrappaColor.doAddColor("peachpuff2", new Color(238, 203, 173), false);
        GrappaColor.doAddColor("peachpuff3", new Color(205, 175, 149), false);
        GrappaColor.doAddColor("peachpuff4", new Color(139, 119, 101), false);
        GrappaColor.doAddColor("peru", new Color(205, 133, 63));
        GrappaColor.doAddColor("pink", new Color(255, 192, 203));
        GrappaColor.doAddColor("pink1", new Color(255, 181, 197), false);
        GrappaColor.doAddColor("pink2", new Color(238, 169, 184), false);
        GrappaColor.doAddColor("pink3", new Color(205, 145, 158), false);
        GrappaColor.doAddColor("pink4", new Color(139, 99, 108), false);
        GrappaColor.doAddColor("plum", new Color(221, 160, 221));
        GrappaColor.doAddColor("plum1", new Color(255, 187, 255), false);
        GrappaColor.doAddColor("plum2", new Color(238, 174, 238), false);
        GrappaColor.doAddColor("plum3", new Color(205, 150, 205), false);
        GrappaColor.doAddColor("plum4", new Color(139, 102, 139), false);
        GrappaColor.doAddColor("powderblue", new Color(176, 224, 230));
        GrappaColor.doAddColor("purple", new Color(160, 32, 240));
        GrappaColor.doAddColor("purple1", new Color(155, 48, 255), false);
        GrappaColor.doAddColor("purple2", new Color(145, 44, 238), false);
        GrappaColor.doAddColor("purple3", new Color(125, 38, 205), false);
        GrappaColor.doAddColor("purple4", new Color(85, 26, 139), false);
        GrappaColor.doAddColor("red", new Color(255, 0, 0));
        GrappaColor.doAddColor("red1", new Color(255, 0, 0), false);
        GrappaColor.doAddColor("red2", new Color(238, 0, 0), false);
        GrappaColor.doAddColor("red3", new Color(205, 0, 0), false);
        GrappaColor.doAddColor("red4", new Color(139, 0, 0), false);
        GrappaColor.doAddColor("rosybrown", new Color(188, 143, 143));
        GrappaColor.doAddColor("rosybrown1", new Color(255, 193, 193), false);
        GrappaColor.doAddColor("rosybrown2", new Color(238, 180, 180), false);
        GrappaColor.doAddColor("rosybrown3", new Color(205, 155, 155), false);
        GrappaColor.doAddColor("rosybrown4", new Color(139, 105, 105), false);
        GrappaColor.doAddColor("royalblue", new Color(65, 105, 225));
        GrappaColor.doAddColor("royalblue1", new Color(72, 118, 255), false);
        GrappaColor.doAddColor("royalblue2", new Color(67, 110, 238), false);
        GrappaColor.doAddColor("royalblue3", new Color(58, 95, 205), false);
        GrappaColor.doAddColor("royalblue4", new Color(39, 64, 139), false);
        GrappaColor.doAddColor("saddlebrown", new Color(139, 69, 19));
        GrappaColor.doAddColor("salmon", new Color(250, 128, 114));
        GrappaColor.doAddColor("salmon1", new Color(255, 140, 105), false);
        GrappaColor.doAddColor("salmon2", new Color(238, 130, 98), false);
        GrappaColor.doAddColor("salmon3", new Color(205, 112, 84), false);
        GrappaColor.doAddColor("salmon4", new Color(139, 76, 57), false);
        GrappaColor.doAddColor("sandybrown", new Color(244, 164, 96));
        GrappaColor.doAddColor("seagreen", new Color(46, 139, 87));
        GrappaColor.doAddColor("seagreen1", new Color(84, 255, 159), false);
        GrappaColor.doAddColor("seagreen2", new Color(78, 238, 148), false);
        GrappaColor.doAddColor("seagreen3", new Color(67, 205, 128), false);
        GrappaColor.doAddColor("seagreen4", new Color(46, 139, 87), false);
        GrappaColor.doAddColor("seashell", new Color(255, 245, 238));
        GrappaColor.doAddColor("seashell1", new Color(255, 245, 238), false);
        GrappaColor.doAddColor("seashell2", new Color(238, 229, 222), false);
        GrappaColor.doAddColor("seashell3", new Color(205, 197, 191), false);
        GrappaColor.doAddColor("seashell4", new Color(139, 134, 130), false);
        GrappaColor.doAddColor("sgiindigo2", new Color(33, 136, 104), false);
        GrappaColor.doAddColor("sienna", new Color(160, 82, 45));
        GrappaColor.doAddColor("sienna1", new Color(255, 130, 71), false);
        GrappaColor.doAddColor("sienna2", new Color(238, 121, 66), false);
        GrappaColor.doAddColor("sienna3", new Color(205, 104, 57), false);
        GrappaColor.doAddColor("sienna4", new Color(139, 71, 38), false);
        GrappaColor.doAddColor("skyblue", new Color(135, 206, 235));
        GrappaColor.doAddColor("skyblue1", new Color(135, 206, 255), false);
        GrappaColor.doAddColor("skyblue2", new Color(126, 192, 238), false);
        GrappaColor.doAddColor("skyblue3", new Color(108, 166, 205), false);
        GrappaColor.doAddColor("skyblue4", new Color(74, 112, 139), false);
        GrappaColor.doAddColor("slateblue", new Color(106, 90, 205));
        GrappaColor.doAddColor("slateblue1", new Color(131, 111, 255), false);
        GrappaColor.doAddColor("slateblue2", new Color(122, 103, 238), false);
        GrappaColor.doAddColor("slateblue3", new Color(105, 89, 205), false);
        GrappaColor.doAddColor("slateblue4", new Color(71, 60, 139), false);
        GrappaColor.doAddColor("slategray", new Color(112, 128, 144));
        GrappaColor.doAddColor("slategray1", new Color(198, 226, 255), false);
        GrappaColor.doAddColor("slategray2", new Color(185, 211, 238), false);
        GrappaColor.doAddColor("slategray3", new Color(159, 182, 205), false);
        GrappaColor.doAddColor("slategray4", new Color(108, 123, 139), false);
        GrappaColor.doAddColor("slategrey", new Color(112, 128, 144), false);
        GrappaColor.doAddColor("snow", new Color(255, 250, 250));
        GrappaColor.doAddColor("snow1", new Color(255, 250, 250), false);
        GrappaColor.doAddColor("snow2", new Color(238, 233, 233), false);
        GrappaColor.doAddColor("snow3", new Color(205, 201, 201), false);
        GrappaColor.doAddColor("snow4", new Color(139, 137, 137), false);
        GrappaColor.doAddColor("springgreen", new Color(0, 255, 127));
        GrappaColor.doAddColor("springgreen1", new Color(0, 255, 127), false);
        GrappaColor.doAddColor("springgreen2", new Color(0, 238, 118), false);
        GrappaColor.doAddColor("springgreen3", new Color(0, 205, 102), false);
        GrappaColor.doAddColor("springgreen4", new Color(0, 139, 69), false);
        GrappaColor.doAddColor("steelblue", new Color(70, 130, 180));
        GrappaColor.doAddColor("steelblue1", new Color(99, 184, 255), false);
        GrappaColor.doAddColor("steelblue2", new Color(92, 172, 238), false);
        GrappaColor.doAddColor("steelblue3", new Color(79, 148, 205), false);
        GrappaColor.doAddColor("steelblue4", new Color(54, 100, 139), false);
        GrappaColor.doAddColor("tan", new Color(210, 180, 140));
        GrappaColor.doAddColor("tan1", new Color(255, 165, 79), false);
        GrappaColor.doAddColor("tan2", new Color(238, 154, 73), false);
        GrappaColor.doAddColor("tan3", new Color(205, 133, 63), false);
        GrappaColor.doAddColor("tan4", new Color(139, 90, 43), false);
        GrappaColor.doAddColor("thistle", new Color(216, 191, 216));
        GrappaColor.doAddColor("thistle1", new Color(255, 225, 255), false);
        GrappaColor.doAddColor("thistle2", new Color(238, 210, 238), false);
        GrappaColor.doAddColor("thistle3", new Color(205, 181, 205), false);
        GrappaColor.doAddColor("thistle4", new Color(139, 123, 139), false);
        GrappaColor.doAddColor("tomato", new Color(255, 99, 71));
        GrappaColor.doAddColor("tomato1", new Color(255, 99, 71), false);
        GrappaColor.doAddColor("tomato2", new Color(238, 92, 66), false);
        GrappaColor.doAddColor("tomato3", new Color(205, 79, 57), false);
        GrappaColor.doAddColor("tomato4", new Color(139, 54, 38), false);
        GrappaColor.doAddColor("turquoise", new Color(64, 224, 208));
        GrappaColor.doAddColor("turquoise1", new Color(0, 245, 255), false);
        GrappaColor.doAddColor("turquoise2", new Color(0, 229, 238), false);
        GrappaColor.doAddColor("turquoise3", new Color(0, 197, 205), false);
        GrappaColor.doAddColor("turquoise4", new Color(0, 134, 139), false);
        GrappaColor.doAddColor("violet", new Color(238, 130, 238));
        GrappaColor.doAddColor("violetred", new Color(208, 32, 144));
        GrappaColor.doAddColor("violetred1", new Color(255, 62, 150), false);
        GrappaColor.doAddColor("violetred2", new Color(238, 58, 140), false);
        GrappaColor.doAddColor("violetred3", new Color(205, 50, 120), false);
        GrappaColor.doAddColor("violetred4", new Color(139, 34, 82), false);
        GrappaColor.doAddColor("wheat", new Color(245, 222, 179));
        GrappaColor.doAddColor("wheat1", new Color(255, 231, 186), false);
        GrappaColor.doAddColor("wheat2", new Color(238, 216, 174), false);
        GrappaColor.doAddColor("wheat3", new Color(205, 186, 150), false);
        GrappaColor.doAddColor("wheat4", new Color(139, 126, 102), false);
        GrappaColor.doAddColor("white", new Color(255, 255, 255));
        GrappaColor.doAddColor("whitesmoke", new Color(245, 245, 245));
        GrappaColor.doAddColor("yellow", new Color(255, 255, 0));
        GrappaColor.doAddColor("yellow1", new Color(255, 255, 0), false);
        GrappaColor.doAddColor("yellow2", new Color(238, 238, 0), false);
        GrappaColor.doAddColor("yellow3", new Color(205, 205, 0), false);
        GrappaColor.doAddColor("yellow4", new Color(139, 139, 0), false);
        GrappaColor.doAddColor("yellowgreen", new Color(154, 205, 50));
        defaultForeground = GrappaColor.getColor("black", null);
        defaultBackground = GrappaColor.getColor("white", null);
        defaultXOR = GrappaColor.getColor("light gray", null);
        defaultFontcolor = GrappaColor.getColor("black", null);
        defaultColor = GrappaColor.getColor("black", null);
    }
}

