/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.Attribute;
import att.grappa.Edge;
import att.grappa.Element;
import att.grappa.Graph;
import att.grappa.GraphIterator;
import att.grappa.Grappa;
import att.grappa.GrappaBox;
import att.grappa.GrappaPoint;
import att.grappa.GrappaSize;
import att.grappa.Node;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Subgraph
extends Element
implements Comparator {
    public static final String defaultNamePrefix = "G";
    private HashMap<String, Node> nodedict = null;
    private HashMap<String, Edge> edgedict = null;
    private HashMap<String, Subgraph> graphdict = null;
    private boolean nodeLabels = true;
    private boolean edgeLabels = true;
    private boolean subgLabels = true;
    private HashMap<String, Attribute> nodeAttributes = null;
    private HashMap<String, Attribute> edgeAttributes = null;
    private boolean cluster = false;
    public Object currentSelection = null;
    static String[] SubgraphAttributesOfInterest = new String[]{"minbox", "minsize", "label", "lp", "style"};
    private double PATCHEDGE = 2.0;
    private double PATCHEDGE2 = 2.0 * this.PATCHEDGE;
    private Element[] sgPatches = null;
    private Element[] elPatches = null;
    private GrappaBox patch = null;
    static Node[] EMPTY_NODE_ARRAY = new Node[0];
    static Edge[] EMPTY_EDGE_ARRAY = new Edge[0];
    static Subgraph[] EMPTY_SUBGRAPH_ARRAY = new Subgraph[0];

    Subgraph() {
        this.cluster = true;
        this.subgraphAttrsOfInterest();
    }

    public Subgraph(Subgraph subg, String name) {
        super(4, subg);
        this.setName(name);
        java.util.Iterator<Attribute> enm = subg.getNodeAttributePairs();
        while (enm.hasNext()) {
            this.setNodeAttribute(enm.next());
        }
        enm = subg.getEdgeAttributePairs();
        while (enm.hasNext()) {
            this.setEdgeAttribute(enm.next());
        }
        enm = subg.getLocalAttributePairs();
        while (enm.hasNext()) {
            this.setAttribute(enm.next());
        }
        this.subgraphAttrsOfInterest();
    }

    public Subgraph(Subgraph subg) {
        this(subg, (String)null);
    }

    private void subgraphAttrsOfInterest() {
        this.attrOfInterest(SubgraphAttributesOfInterest);
    }

    @Override
    public boolean isSubgraph() {
        return true;
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    void setName() {
        String oldName = this.name;
        do {
            this.name = defaultNamePrefix + this.getId() + "_" + System.currentTimeMillis();
        } while (this.getGraph().findSubgraphByName(this.name) != null);
        if (this.getSubgraph() != null) {
            if (oldName != null) {
                this.getSubgraph().removeSubgraph(oldName);
            }
            this.getSubgraph().addSubgraph(this);
        }
        this.canonName = null;
    }

    public void setName(String newName) throws IllegalArgumentException {
        if (newName == null) {
            this.setName();
            return;
        }
        String oldName = this.name;
        if (oldName != null && oldName.equals(newName)) {
            return;
        }
        if (this.getGraph().findSubgraphByName(newName) != null) {
            throw new IllegalArgumentException("graph name (" + newName + ") is not unique");
        }
        this.name = newName;
        if (this.name.startsWith("cluster")) {
            this.cluster = true;
        }
        if (this.getSubgraph() != null) {
            if (oldName != null) {
                this.getSubgraph().removeSubgraph(oldName);
            }
            this.getSubgraph().addSubgraph(this);
        }
        this.canonName = null;
    }

    public boolean isCluster() {
        return this.cluster;
    }

    public boolean isRoot() {
        return this == this.getGraph();
    }

    public Attribute getNodeAttribute(String key) {
        if (this.nodeAttributes == null) {
            return null;
        }
        return this.nodeAttributes.get(key);
    }

    public Object getNodeAttributeValue(String key) {
        if (this.nodeAttributes == null) {
            return null;
        }
        Attribute attr = this.nodeAttributes.get(key);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public java.util.Iterator<String> getNodeAttributeKeys() {
        if (this.nodeAttributes == null) {
            return Grappa.emptyStringIterator.iterator();
        }
        return this.nodeAttributes.keySet().iterator();
    }

    public java.util.Iterator<Attribute> getNodeAttributePairs() {
        if (this.nodeAttributes == null) {
            return Grappa.emptyAttributeIterator.iterator();
        }
        return this.nodeAttributes.values().iterator();
    }

    public Object setNodeAttribute(Attribute attr) {
        Subgraph sg;
        Attribute prntAttr;
        if (attr == null) {
            return null;
        }
        if (this.nodeAttributes == null) {
            this.nodeAttributes = new HashMap();
        }
        Attribute attribute = prntAttr = (sg = this.getSubgraph()) == null ? null : sg.getNodeAttribute(attr.getName());
        if (attr != prntAttr) {
            return this.setNodeAttribute(attr.getName(), attr.getStringValue());
        }
        Object oldValue = null;
        Attribute newAttr = null;
        Attribute crntAttr = this.getNodeAttribute(attr.getName());
        if (attr == crntAttr) {
            return attr.getValue();
        }
        if (crntAttr == null) {
            if (attr.getValue() == null) {
                return null;
            }
            crntAttr = attr;
            this.nodeAttributes.put(attr.getName(), crntAttr);
        } else {
            oldValue = crntAttr.getValue();
            crntAttr.setChanged();
            this.nodeAttributes.put(attr.getName(), attr);
            newAttr = attr;
        }
        if (crntAttr.hasChanged()) {
            crntAttr.notifyListeners(new Object[]{newAttr, new Long(System.currentTimeMillis())});
        }
        return oldValue;
    }

    public Object setNodeAttribute(String name, Object value) {
        if (this.nodeAttributes == null) {
            this.nodeAttributes = new HashMap();
        }
        if (name == null) {
            throw new IllegalArgumentException("cannot set an attribute using a null name");
        }
        Subgraph sg = this.getSubgraph();
        Attribute prntAttr = sg == null ? null : sg.getNodeAttribute(name);
        Object oldValue = null;
        Attribute crntAttr = this.getNodeAttribute(name);
        if (crntAttr == null || crntAttr == prntAttr) {
            if (value == null) {
                return null;
            }
            crntAttr = new Attribute(1, name, value);
            this.nodeAttributes.put(name, crntAttr);
        } else {
            oldValue = crntAttr.getValue();
            if (value == null) {
                if (prntAttr == null) {
                    this.removeNodeAttribute(name);
                    return oldValue;
                }
                return this.setNodeAttribute(prntAttr);
            }
            crntAttr.setValue(value);
        }
        if (crntAttr.hasChanged()) {
            crntAttr.notifyListeners(new Long(System.currentTimeMillis()));
        }
        return oldValue;
    }

    private void removeNodeAttribute(String name) {
        if (name == null || this.nodeAttributes == null) {
            return;
        }
        Attribute attr = this.nodeAttributes.remove(name);
        if (attr == null) {
            return;
        }
        attr.setValue("");
        if (attr.hasChanged()) {
            attr.notifyListeners(new Long(System.currentTimeMillis()));
        }
        attr.removeListeners();
    }

    public Object setEdgeAttribute(Attribute attr) {
        Subgraph sg;
        Attribute prntAttr;
        if (attr == null) {
            return null;
        }
        if (this.edgeAttributes == null) {
            this.edgeAttributes = new HashMap();
        }
        Attribute attribute = prntAttr = (sg = this.getSubgraph()) == null ? null : sg.getEdgeAttribute(attr.getName());
        if (attr != prntAttr) {
            return this.setEdgeAttribute(attr.getName(), attr.getStringValue());
        }
        Object oldValue = null;
        Attribute newAttr = null;
        Attribute crntAttr = this.getEdgeAttribute(attr.getName());
        if (attr == crntAttr) {
            return attr.getValue();
        }
        if (crntAttr == null) {
            if (attr.getValue() == null) {
                return null;
            }
            crntAttr = attr;
            this.edgeAttributes.put(attr.getName(), crntAttr);
        } else {
            oldValue = crntAttr.getValue();
            crntAttr.setChanged();
            this.edgeAttributes.put(attr.getName(), attr);
            newAttr = attr;
        }
        if (crntAttr.hasChanged()) {
            crntAttr.notifyListeners(new Object[]{newAttr, new Long(System.currentTimeMillis())});
        }
        return oldValue;
    }

    public Object setEdgeAttribute(String name, Object value) {
        if (this.edgeAttributes == null) {
            this.edgeAttributes = new HashMap();
        }
        if (name == null) {
            throw new IllegalArgumentException("cannot set an attribute using a null name");
        }
        Subgraph sg = this.getSubgraph();
        Attribute prntAttr = sg == null ? null : sg.getEdgeAttribute(name);
        Object oldValue = null;
        Attribute crntAttr = this.getEdgeAttribute(name);
        if (crntAttr == null || crntAttr == prntAttr) {
            if (value == null) {
                return null;
            }
            crntAttr = new Attribute(2, name, value);
            this.edgeAttributes.put(name, crntAttr);
        } else {
            oldValue = crntAttr.getValue();
            if (value == null) {
                if (prntAttr == null) {
                    this.removeEdgeAttribute(name);
                    return oldValue;
                }
                return this.setEdgeAttribute(prntAttr);
            }
            crntAttr.setValue(value);
        }
        if (crntAttr.hasChanged()) {
            crntAttr.notifyListeners(new Long(System.currentTimeMillis()));
        }
        return oldValue;
    }

    private void removeEdgeAttribute(String name) {
        if (name == null || this.edgeAttributes == null) {
            return;
        }
        Attribute attr = this.edgeAttributes.remove(name);
        if (attr == null) {
            return;
        }
        attr.setValue("");
        if (attr.hasChanged()) {
            attr.notifyListeners(new Long(System.currentTimeMillis()));
        }
        attr.removeListeners();
    }

    @Override
    public Object setAttribute(Attribute attr) {
        Subgraph sg;
        Attribute prntAttr;
        if (attr == null) {
            return null;
        }
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        Attribute attribute = prntAttr = (sg = this.getSubgraph()) == null ? null : sg.getLocalAttribute(attr.getName());
        if (attr != prntAttr) {
            return this.setAttribute(attr.getName(), attr.getStringValue());
        }
        Object oldValue = null;
        Attribute newAttr = null;
        Attribute crntAttr = this.getLocalAttribute(attr.getName());
        if (attr == crntAttr) {
            return attr.getValue();
        }
        if (crntAttr == null) {
            if (attr.getValue() == null) {
                return null;
            }
            crntAttr = attr;
            this.attributes.put(attr.getName(), crntAttr);
        } else {
            oldValue = crntAttr.getValue();
            crntAttr.setChanged();
            this.attributes.put(attr.getName(), attr);
            newAttr = attr;
        }
        if (crntAttr.hasChanged()) {
            crntAttr.notifyListeners(new Object[]{newAttr, new Long(System.currentTimeMillis())});
        }
        return oldValue;
    }

    @Override
    public Object setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        if (name == null) {
            throw new IllegalArgumentException("cannot set an attribute using a null name");
        }
        Subgraph sg = this.getSubgraph();
        Attribute prntAttr = sg == null ? null : sg.getLocalAttribute(name);
        Object oldValue = null;
        Attribute crntAttr = this.getLocalAttribute(name);
        if (crntAttr == null || crntAttr == prntAttr) {
            if (value == null) {
                return null;
            }
            if (value instanceof String && ((String)value).trim().length() == 0 && Attribute.attributeType(this.getType(), name) != 12) {
                return null;
            }
            crntAttr = new Attribute(4, name, value);
            this.attributes.put(name, crntAttr);
            if (this.grappaNexus != null && this.isOfInterest(name)) {
                crntAttr.addListener(this.grappaNexus);
            }
        } else {
            oldValue = crntAttr.getValue();
            if (value == null) {
                if (prntAttr == null) {
                    super.setAttribute(name, null);
                    return oldValue;
                }
                return this.setAttribute(prntAttr);
            }
            if (value instanceof String && ((String)value).trim().length() == 0 && Attribute.attributeType(this.getType(), name) != 12) {
                if (prntAttr == null) {
                    super.setAttribute(name, null);
                    return oldValue;
                }
                return this.setAttribute(prntAttr);
            }
            crntAttr.setValue(value);
        }
        if (crntAttr.hasChanged()) {
            crntAttr.notifyListeners(new Long(System.currentTimeMillis()));
        }
        return oldValue;
    }

    public Attribute getEdgeAttribute(String key) {
        if (this.edgeAttributes == null) {
            return null;
        }
        return this.edgeAttributes.get(key);
    }

    public Object getEdgeAttributeValue(String key) {
        if (this.edgeAttributes == null) {
            return null;
        }
        Attribute attr = this.edgeAttributes.get(key);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public java.util.Iterator<String> getEdgeAttributeKeys() {
        if (this.edgeAttributes == null) {
            return Grappa.emptyStringIterator.iterator();
        }
        return this.edgeAttributes.keySet().iterator();
    }

    public java.util.Iterator<Attribute> getEdgeAttributePairs() {
        if (this.edgeAttributes == null) {
            return Grappa.emptyAttributeIterator.iterator();
        }
        return this.edgeAttributes.values().iterator();
    }

    public Rectangle2D getBoundingBox() {
        Rectangle2D bbox = null;
        if (this.grappaNexus == null || (bbox = this.grappaNexus.bbox) == null) {
            GrappaBox minBox;
            if (this.grappaNexus == null) {
                this.buildShape();
            }
            bbox = null;
            Element elem = null;
            GraphIterator enm = this.elements();
            block4: while (enm.hasNext()) {
                elem = enm.nextGraphElement();
                if (elem == this) continue;
                switch (elem.getType()) {
                    case 1: 
                    case 2: {
                        elem.buildShape();
                        if (bbox == null) {
                            bbox = elem.grappaNexus.getBounds2D();
                            continue block4;
                        }
                        bbox.add(elem.grappaNexus.getBounds2D());
                        continue block4;
                    }
                    case 4: {
                        if (bbox == null) {
                            bbox = ((Subgraph)elem).getBoundingBox();
                            continue block4;
                        }
                        bbox.add(((Subgraph)elem).getBoundingBox());
                        continue block4;
                    }
                }
                throw new InternalError("unknown type (" + elem.getType() + ")");
            }
            GrappaSize minSize = (GrappaSize)this.getAttributeValue("minsize");
            if (minSize != null) {
                if (bbox == null) {
                    bbox = new Rectangle2D.Double(0.0, 0.0, minSize.getWidth(), minSize.getHeight());
                } else {
                    bbox.add(new Rectangle2D.Double(bbox.getCenterX() - minSize.getWidth() / 2.0, bbox.getCenterY() - minSize.getHeight() / 2.0, minSize.getWidth(), minSize.getHeight()));
                }
            }
            if ((minBox = (GrappaBox)this.getThisAttributeValue("minbox")) != null) {
                if (bbox == null) {
                    bbox = new Rectangle2D.Double(minBox.x, minBox.y, minBox.width, minBox.height);
                } else {
                    bbox.add(new Rectangle2D.Double(minBox.x, minBox.y, minBox.width, minBox.height));
                }
            }
            if ((minBox = (GrappaBox)this.getThisAttributeValue("bb")) != null) {
                if (bbox == null) {
                    bbox = new Rectangle2D.Double(minBox.x, minBox.y, minBox.width, minBox.height);
                } else {
                    bbox.add(new Rectangle2D.Double(minBox.x, minBox.y, minBox.width, minBox.height));
                }
            }
            if (bbox == null) {
                bbox = new Rectangle2D.Double();
            }
            bbox.add(bbox.getX() + bbox.getWidth() + 1.0, bbox.getY() + bbox.getHeight() + 1.0);
            this.grappaNexus.bbox = bbox;
            if (Grappa.provideBBoxAttribute) {
                this.setAttribute("bb", new GrappaBox(bbox));
            }
            this.grappaNexus.updateShape();
        }
        return (Rectangle2D)bbox.clone();
    }

    public Rectangle2D resetBoundingBox() {
        Element elem = null;
        GraphIterator enm = this.elements(4);
        while (enm.hasNext()) {
            elem = enm.nextGraphElement();
            elem.grappaNexus.bbox = null;
            elem.setAttribute("bb", null);
        }
        return this.getBoundingBox();
    }

    public void printSubgraph(PrintWriter out) {
        java.util.Iterator<Element> elems;
        Graph graph = this.getGraph();
        String indent = new String(graph.getIndent());
        if (Grappa.printVisibleOnly && (!this.visible || this.grappaNexus.style.invis)) {
            return;
        }
        if (this.getSubgraph() == null) {
            out.println(indent + (graph.isStrict() ? "strict " : "") + (graph.isDirected() ? "digraph" : "graph") + " " + graph.toString() + " {");
        } else if (this.getName().startsWith("_anonymous_")) {
            out.println(indent + "{");
        } else {
            out.println(indent + "subgraph " + this.toString() + " {");
        }
        graph.incrementIndent();
        this.printDflt(out, 4);
        this.printDflt(out, 1);
        this.printDflt(out, 2);
        if (this.graphdict != null && !this.graphdict.isEmpty()) {
            elems = this.graphdict.values().iterator();
            while (elems.hasNext()) {
                ((Subgraph)elems.next()).printSubgraph(out);
            }
        }
        if (this.nodedict != null && !this.nodedict.isEmpty()) {
            elems = this.nodedict.values().iterator();
            while (elems.hasNext()) {
                ((Node)elems.next()).printNode(out);
            }
        }
        if (this.edgedict != null && !this.edgedict.isEmpty()) {
            elems = this.edgedict.values().iterator();
            while (elems.hasNext()) {
                ((Edge)elems.next()).printEdge(out);
            }
        }
        graph.decrementIndent();
        out.println(indent + "}");
    }

    private void printDflt(PrintWriter out, int type) {
        String indent = new String(this.getGraph().getIndent());
        HashMap<String, Attribute> attr = null;
        String label = null;
        switch (type) {
            case 4: {
                attr = this.attributes;
                label = "graph";
                break;
            }
            case 1: {
                attr = this.nodeAttributes;
                label = "node";
                break;
            }
            case 2: {
                attr = this.edgeAttributes;
                label = "edge";
            }
        }
        if (attr == null || attr.isEmpty()) {
            this.getGraph().printError("no " + label + " atrtibutes for " + this.getName());
            return;
        }
        this.getGraph().incrementIndent();
        this.printDfltAttr(out, attr, type, indent + label + " [", indent + "];");
        this.getGraph().decrementIndent();
    }

    private void printDfltAttr(PrintWriter out, HashMap<String, Attribute> dfltAttr, int type, String prefix, String suffix) {
        String indent = new String(this.getGraph().getIndent());
        int nbr = 0;
        java.util.Iterator<Attribute> attrs = dfltAttr.values().iterator();
        Subgraph sg = this.getSubgraph();
        HashMap printlist = null;
        if (type == 4 && (Grappa.usePrintList || usePrintList)) {
            printlist = (HashMap)this.getAttributeValue("printlist");
        }
        while (attrs.hasNext()) {
            Attribute attr = attrs.next();
            if (attr == null) continue;
            String key = attr.getName();
            if (printlist != null && printlist.get(key) == null) continue;
            String value = attr.getStringValue();
            if (!Grappa.elementPrintAllAttributes && !Grappa.elementPrintDefaultAttributes && !this.printAllAttributes && !this.printDefaultAttributes && attr.equalsValue(this.getParentDefault(type, key))) continue;
            if (++nbr == 1) {
                out.println(prefix);
                out.print(indent + key + " = " + Subgraph.canonString(value));
                continue;
            }
            out.println(",");
            out.print(indent + key + " = " + Subgraph.canonString(value));
        }
        if (nbr > 0) {
            out.println();
            out.println(suffix);
            out.println();
        }
    }

    public static int attributeType(String attrname) {
        int convtype = -1;
        if (attrname != null) {
            int hashCode = attrname.hashCode();
            if (hashCode == MARGIN_HASH && attrname.equals("margin")) {
                convtype = 11;
            } else if (hashCode == MCLIMIT_HASH && attrname.equals("mclimit")) {
                convtype = 4;
            } else if (hashCode == MINBOX_HASH && attrname.equals("minbox")) {
                convtype = 1;
            } else if (hashCode == NODESEP_HASH && attrname.equals("nodesep")) {
                convtype = 4;
            } else if (hashCode == MINSIZE_HASH && attrname.equals("minsize")) {
                convtype = 11;
            } else if (hashCode == NODESEP_HASH && attrname.equals("nodesep")) {
                convtype = 4;
            } else if (hashCode == RANKSEP_HASH && attrname.equals("ranksep")) {
                convtype = 4;
            } else if (hashCode == SIZE_HASH && attrname.equals("size")) {
                convtype = 11;
            } else {
                return Element.attributeType(attrname);
            }
        }
        return convtype;
    }

    private Attribute getParentDefault(int type, String key) {
        Attribute attr = null;
        switch (type) {
            case 4: {
                Subgraph subg;
                for (subg = this.getSubgraph(); subg != null && (attr = subg.getLocalAttribute(key)) == null; subg = subg.getSubgraph()) {
                }
                if (attr == null) {
                    this.getGraph();
                    attr = Graph.getGlobalAttribute(4, key);
                }
                return attr;
            }
            case 1: {
                Subgraph subg;
                while (subg != null && (attr = subg.getNodeAttribute(key)) == null) {
                    subg = subg.getSubgraph();
                }
                if (attr == null) {
                    this.getGraph();
                    attr = Graph.getGlobalAttribute(1, key);
                }
                return attr;
            }
            case 2: {
                Subgraph subg;
                while (subg != null && (attr = subg.getEdgeAttribute(key)) == null) {
                    subg = subg.getSubgraph();
                }
                if (attr == null) {
                    this.getGraph();
                    attr = Graph.getGlobalAttribute(2, key);
                }
                return attr;
            }
        }
        return null;
    }

    private Element findElementByName(int type, String name) {
        if (name == null) {
            return null;
        }
        return this.findElementInSubgraphByName(type, name);
    }

    private Element findElementInSubgraphByName(int type, String name) {
        Element elem = null;
        switch (type) {
            case 1: {
                if (this.nodedict == null) break;
                elem = this.nodedict.get(name);
                break;
            }
            case 2: {
                if (this.edgedict == null) break;
                elem = this.edgedict.get(name);
                break;
            }
            case 4: {
                if (this.graphdict == null) break;
                elem = this.graphdict.get(name);
            }
        }
        if (elem != null || this.graphdict == null) {
            return elem;
        }
        java.util.Iterator<Subgraph> enm = this.graphdict.values().iterator();
        while (enm.hasNext()) {
            elem = enm.next().findElementInSubgraphByName(type, name);
            if (elem == null) continue;
            return elem;
        }
        return elem;
    }

    public Node findNodeByName(String nodeName) {
        return (Node)this.findElementByName(1, nodeName);
    }

    public Edge findEdgeByName(String edgeName) {
        return (Edge)this.findElementByName(2, edgeName);
    }

    public Subgraph findSubgraphByName(String graphName) {
        return (Subgraph)this.findElementByName(4, graphName);
    }

    public Element createElement(int type, Object[] info, Attribute[] attrs) {
        Element elem = null;
        switch (type) {
            case 1: {
                String nodeName = null;
                if (info != null && info.length >= 1) {
                    nodeName = (String)info[0];
                }
                Node node = new Node(this, nodeName);
                if (attrs != null) {
                    for (int i = 0; i < attrs.length; ++i) {
                        node.setAttribute(attrs[i]);
                    }
                }
                elem = node;
                break;
            }
            case 2: {
                if (info == null || info.length < 3) {
                    throw new IllegalArgumentException("insufficient info supplied for edge creation");
                }
                Node head = (Node)info[0];
                String headPort = (String)info[1];
                Node tail = (Node)info[2];
                String tailPort = null;
                String key = null;
                if (info.length > 3) {
                    tailPort = (String)info[3];
                    if (info.length > 4) {
                        key = (String)info[4];
                    }
                }
                Edge edge = new Edge(this, tail, tailPort, head, headPort, key);
                if (attrs != null) {
                    for (int i = 0; i < attrs.length; ++i) {
                        edge.setAttribute(attrs[i]);
                    }
                }
                elem = edge;
                break;
            }
            case 4: {
                String subgName = null;
                if (info != null && info.length >= 1) {
                    subgName = (String)info[0];
                }
                Subgraph newSubg = new Subgraph(this, subgName);
                if (attrs != null) {
                    for (int i = 0; i < attrs.length; ++i) {
                        newSubg.setAttribute(attrs[i]);
                    }
                }
                elem = newSubg;
                break;
            }
            default: {
                return null;
            }
        }
        return elem;
    }

    public void addNode(Node newNode) {
        if (newNode == null) {
            return;
        }
        if (this.nodedict == null) {
            this.nodedict = new HashMap();
        }
        this.nodedict.put(newNode.getName(), newNode);
    }

    public Node removeNode(String nodeName) {
        if (this.nodedict == null) {
            return null;
        }
        return this.nodedict.remove(nodeName);
    }

    public void addEdge(Edge newEdge) {
        if (newEdge == null) {
            return;
        }
        if (this.edgedict == null) {
            this.edgedict = new HashMap();
        }
        this.edgedict.put(newEdge.getName(), newEdge);
    }

    public Edge removeEdge(String edgeName) {
        if (this.edgedict == null) {
            return null;
        }
        return this.edgedict.remove(edgeName);
    }

    public void addSubgraph(Subgraph newGraph) {
        if (newGraph == null) {
            return;
        }
        if (this.graphdict == null) {
            this.graphdict = new HashMap();
        }
        this.graphdict.put(newGraph.getName(), newGraph);
    }

    public Subgraph removeSubgraph(String graphName) {
        if (this.graphdict == null) {
            return null;
        }
        return this.graphdict.remove(graphName);
    }

    public boolean setShowSubgraphLabels(boolean value) {
        boolean oldValue = this.subgLabels;
        this.subgLabels = value;
        return oldValue;
    }

    public boolean setShowNodeLabels(boolean value) {
        boolean oldValue = this.nodeLabels;
        this.nodeLabels = value;
        return oldValue;
    }

    public boolean setShowEdgeLabels(boolean value) {
        boolean oldValue = this.edgeLabels;
        this.edgeLabels = value;
        return oldValue;
    }

    public boolean getShowSubgraphLabels() {
        return this.subgLabels;
    }

    public boolean getShowNodeLabels() {
        return this.nodeLabels;
    }

    public boolean getShowEdgeLabels() {
        return this.edgeLabels;
    }

    public boolean isLR() {
        Attribute attr = this.getAttribute("rankdir");
        if (attr == null) {
            return false;
        }
        String value = attr.getStringValue();
        if (value == null) {
            return false;
        }
        return value.equals("LR");
    }

    public void addTypeTag(int type, String tag) {
        if (tag == null || tag.indexOf(44) >= 0) {
            throw new RuntimeException("tag value null or contains a comma (" + tag + ")");
        }
        Attribute attr = null;
        switch (type) {
            case 1: {
                attr = this.getNodeAttribute("tag");
                break;
            }
            case 2: {
                attr = this.getEdgeAttribute("tag");
                break;
            }
            case 4: {
                attr = this.getLocalAttribute("tag");
            }
        }
        if (attr == null) {
            attr = new Attribute(type, "tag", new HashMap());
            this.setAttribute(attr);
            switch (type) {
                case 1: {
                    this.setNodeAttribute(attr);
                    break;
                }
                case 2: {
                    this.setEdgeAttribute(attr);
                    break;
                }
                case 4: {
                    this.setAttribute(attr);
                }
            }
        }
        HashMap tags = (HashMap)attr.getValue();
        tags.put(tag, tag);
    }

    public boolean hasTypeTag(int type, String tag) {
        Attribute attr = null;
        switch (type) {
            case 1: {
                attr = this.getNodeAttribute("tag");
                break;
            }
            case 2: {
                attr = this.getEdgeAttribute("tag");
                break;
            }
            case 4: {
                attr = this.getLocalAttribute("tag");
            }
        }
        if (attr == null) {
            return false;
        }
        HashMap tags = (HashMap)attr.getValue();
        if (tags == null || tags.size() == 0) {
            return false;
        }
        return tags.containsKey(tag);
    }

    public boolean hasTypeTags(int type) {
        Attribute attr = null;
        switch (type) {
            case 1: {
                attr = this.getNodeAttribute("tag");
                break;
            }
            case 2: {
                attr = this.getEdgeAttribute("tag");
                break;
            }
            case 4: {
                attr = this.getLocalAttribute("tag");
            }
        }
        if (attr == null) {
            return false;
        }
        HashMap tags = (HashMap)attr.getValue();
        return tags != null && tags.size() != 0;
    }

    public void removeTypeTags(int type) {
        Attribute attr = null;
        switch (type) {
            case 1: {
                attr = this.getNodeAttribute("tag");
                break;
            }
            case 2: {
                attr = this.getEdgeAttribute("tag");
                break;
            }
            case 4: {
                attr = this.getLocalAttribute("tag");
            }
        }
        if (attr == null) {
            return;
        }
        HashMap tags = (HashMap)attr.getValue();
        if (tags == null || tags.size() == 0) {
            return;
        }
        tags.clear();
    }

    public void removeTypeTag(int type, String tag) {
        Attribute attr = null;
        switch (type) {
            case 1: {
                attr = this.getNodeAttribute("tag");
                break;
            }
            case 2: {
                attr = this.getEdgeAttribute("tag");
                break;
            }
            case 4: {
                attr = this.getLocalAttribute("tag");
            }
        }
        if (attr == null) {
            return;
        }
        HashMap tags = (HashMap)attr.getValue();
        if (tags == null || tags.size() == 0) {
            return;
        }
        tags.remove(tag);
    }

    public int countOfLocalElements(int types) {
        int count = 0;
        if ((types & 1) != 0 && this.nodedict != null) {
            count += this.nodedict.size();
        }
        if ((types & 2) != 0 && this.edgedict != null) {
            count += this.edgedict.size();
        }
        if ((types & 4) != 0 && this.graphdict != null) {
            count += this.graphdict.size();
        }
        return count;
    }

    public int countOfElements(int types) {
        int count = 0;
        if ((types & 1) != 0 && this.nodedict != null) {
            count += this.nodedict.size();
        }
        if ((types & 2) != 0 && this.edgedict != null) {
            count += this.edgedict.size();
        }
        if (this.graphdict != null) {
            if ((types & 4) != 0) {
                count += this.graphdict.size();
            }
            java.util.Iterator<Subgraph> enm = this.graphdict.values().iterator();
            while (enm.hasNext()) {
                count += enm.next().countOfElements(types);
            }
        }
        return count;
    }

    public void removeEmptySubgraphs() {
        if (!(this.graphdict != null && this.graphdict.size() != 0 || this.nodedict != null && this.nodedict.size() != 0 || this.edgedict != null && this.edgedict.size() != 0)) {
            this.delete();
            return;
        }
        if (this.graphdict != null) {
            java.util.Iterator<Subgraph> enm = this.graphdict.values().iterator();
            while (enm.hasNext()) {
                enm.next().removeEmptySubgraphs();
            }
        }
    }

    public boolean hasEmptySubgraphs() {
        if (!(this.graphdict != null && this.graphdict.size() != 0 || this.nodedict != null && this.nodedict.size() != 0 || this.edgedict != null && this.edgedict.size() != 0)) {
            return true;
        }
        if (this.graphdict != null) {
            java.util.Iterator<Subgraph> enm = this.graphdict.values().iterator();
            while (enm.hasNext()) {
                if (!enm.next().hasEmptySubgraphs()) continue;
                return true;
            }
        }
        return false;
    }

    public void clearPatchWork() {
        this.prepPatchWork(null, -1);
    }

    public void patchWork(Rectangle2D.Double r, boolean square, int mode) {
        this.preparePatchWork(mode);
        this.computePatchWork(r instanceof GrappaBox ? r : new GrappaBox(r), square);
        if (mode == 0) {
            GraphIterator enm = this.elements(4);
            while (enm.hasNext()) {
                Attribute attr;
                Subgraph sg = (Subgraph)enm.next();
                if (sg == this || (attr = sg.getAttribute("style")) == null) continue;
                String style = attr.getStringValue();
                sg.setAttribute("style", style != null && style.length() > 0 ? style + ",filled(false)" : null);
            }
        } else {
            float sgtot = this.countOfElements(4) - 2;
            float nbr = 0.0f;
            GraphIterator enm = this.elements(4);
            while (enm.hasNext()) {
                Subgraph sg = (Subgraph)enm.next();
                if (sg == this) continue;
                float f = nbr;
                nbr = f + 1.0f;
                sg.setAttribute("color", Color.getHSBColor((float)(0.05 + 0.9 * (double)(f / sgtot)), 1.0f, 1.0f));
                Attribute attr = sg.getAttribute("style");
                if (attr == null) {
                    sg.setAttribute("style", "filled");
                    continue;
                }
                String style = attr.getStringValue();
                sg.setAttribute("style", style == null || style.length() == 0 ? "filled" : style + ",filled");
            }
        }
    }

    public double preparePatchWork(int mode) {
        double total = this.prepPatchWork("patch", mode);
        if (mode == 0) {
            this.combPatchWork();
            if (this.elPatches != null) {
                Arrays.sort(this.elPatches, 0, this.elPatches.length, this);
            }
        }
        return total;
    }

    Element[] getPatches() {
        return this.elPatches;
    }

    private void combPatchWork() {
        Element[] patches = this.elPatches;
        Element[] sgpat = this.sgPatches;
        if (sgpat != null && sgpat.length > 0) {
            for (int i = 0; i < sgpat.length; ++i) {
                Subgraph sg = (Subgraph)sgpat[i];
                sg.combPatchWork();
                Element[] elpat = sg.getPatches();
                if (elpat == null || elpat.length <= 0) continue;
                if (patches == null || patches.length == 0) {
                    patches = elpat;
                    continue;
                }
                Element[] tmparr = new Element[patches.length + elpat.length];
                System.arraycopy(patches, 0, tmparr, 0, patches.length);
                System.arraycopy(elpat, 0, tmparr, patches.length, elpat.length);
                patches = tmparr;
            }
        }
        this.sgPatches = null;
        this.elPatches = patches;
    }

    private double prepPatchWork(String attrname, int mode) {
        int n;
        double total = 0.0;
        HashMap<String, Element> dict = this.graphdict;
        this.sgPatches = null;
        if (dict != null && dict.size() > 0) {
            if (attrname != null) {
                this.sgPatches = new Element[dict.size()];
            }
            n = 0;
            for (Subgraph subgraph : dict.values()) {
                total += subgraph.prepPatchWork(attrname, mode);
                if (attrname == null) continue;
                this.sgPatches[n++] = subgraph;
            }
        }
        dict = this.nodedict;
        this.elPatches = null;
        if (attrname != null && dict != null && dict.size() > 0) {
            int m = 0;
            n = 0;
            if (mode <= 0) {
                this.elPatches = new Element[dict.size()];
            } else if (this.sgPatches == null) {
                this.elPatches = new Element[dict.size()];
            } else {
                n = this.sgPatches.length;
                this.elPatches = new Element[n + dict.size()];
                System.arraycopy(this.sgPatches, 0, this.elPatches, 0, n);
                this.sgPatches = null;
            }
            for (Element el : dict.values()) {
                Object obj = el.getAttributeValue(attrname);
                if (obj != null) {
                    if (obj instanceof Number) {
                        el.setPatchSize(((Number)obj).doubleValue());
                        total += el.getPatchSize();
                        this.elPatches[n++] = el;
                        continue;
                    }
                    ++m;
                    continue;
                }
                ++m;
            }
            if (m > 0) {
                if (n == m) {
                    this.elPatches = null;
                } else {
                    Element[] tmparr = new Element[n - m];
                    System.arraycopy(this.elPatches, 0, tmparr, 0, tmparr.length);
                    this.elPatches = tmparr;
                }
            }
        }
        if (mode != 0) {
            if (this.sgPatches != null) {
                Arrays.sort(this.sgPatches, 0, this.sgPatches.length, this);
            }
            if (this.elPatches != null) {
                Arrays.sort(this.elPatches, 0, this.elPatches.length, this);
            }
        }
        this.setPatchSize(total);
        return total;
    }

    double aspect(Rectangle2D.Double r) {
        return r.getWidth() == 0.0 ? 1.0 : r.getHeight() / r.getWidth();
    }

    double score(double wd, double ht) {
        return ht <= this.PATCHEDGE2 || wd <= this.PATCHEDGE2 ? Double.MAX_VALUE : (ht > wd ? (wd == 0.0 ? (ht == 0.0 ? 1.0 : Double.MAX_VALUE) : ht / wd) : (ht == 0.0 ? (wd == 0.0 ? 1.0 : Double.MAX_VALUE) : wd / ht));
    }

    public void computePatchWork(Rectangle2D.Double r, boolean square) {
        if (square) {
            this.compSqPatchWork(r, true);
        } else {
            this.compStdPatchWork(r, true);
        }
    }

    private void compSqPatchWork(Rectangle2D.Double r, boolean top) {
        Rectangle2D.Double p;
        double nxt;
        double next;
        double prv;
        double nscore;
        double tfrac;
        double tot;
        double tsz;
        int j;
        double pscore;
        double frac;
        double psz;
        double sz;
        Element el;
        int i;
        this.setPatch(r);
        this.setAttribute("minsize", new GrappaSize(r.getWidth(), r.getHeight() + (double)(!top ? 1 : 0)));
        double dir = this.aspect(r);
        double total = this.getPatchSize();
        GrappaBox box = top ? new GrappaBox(r) : new GrappaBox(r.getX() + this.PATCHEDGE, r.getY() + this.PATCHEDGE, r.getWidth() - this.PATCHEDGE2, r.getHeight() - this.PATCHEDGE2);
        double previous = dir > 1.0 ? box.getY() : box.getX();
        if (this.sgPatches != null) {
            i = 0;
            while (i < this.sgPatches.length) {
                el = this.sgPatches[i];
                sz = el.getPatchSize();
                if (i + 1 < this.sgPatches.length) {
                    block40: {
                        psz = 0.0;
                        frac = sz / total;
                        pscore = dir > 1.0 ? this.score(box.getWidth(), frac * box.getHeight()) : this.score(frac * box.getWidth(), box.getHeight());
                        j = i + 1;
                        while (true) {
                            tsz = this.sgPatches[j].getPatchSize();
                            tot = psz + sz + tsz;
                            tfrac = tot / total;
                            nscore = dir > 1.0 ? this.score(box.getWidth() * sz / tot, tfrac * box.getHeight()) : this.score(tfrac * box.getWidth(), box.getHeight() * sz / tot);
                            if (!(nscore <= pscore)) break;
                            pscore = dir > 1.0 ? this.score(box.getWidth() * tsz / tot, tfrac * box.getHeight()) : this.score(tfrac * box.getWidth(), box.getHeight() * tsz / tot);
                            psz += sz;
                            sz = tsz;
                            tsz = 0.0;
                            if (++j < this.sgPatches.length) {
                                continue;
                            }
                            break block40;
                            break;
                        }
                        tsz = 0.0;
                    }
                    tot = psz + sz + tsz;
                    frac = tot / total;
                    if (dir > 1.0) {
                        prv = box.getX();
                        next = frac * box.getHeight();
                    } else {
                        prv = box.getY();
                        next = frac * box.getWidth();
                    }
                    while (i < j) {
                        el = this.sgPatches[i];
                        if (dir > 1.0) {
                            nxt = box.getWidth() * el.getPatchSize() / tot;
                            p = new GrappaBox(prv, previous, nxt, next);
                        } else {
                            nxt = box.getHeight() * el.getPatchSize() / tot;
                            p = new GrappaBox(previous, prv, next, nxt);
                        }
                        ((Subgraph)el).compSqPatchWork(p, false);
                        prv += nxt;
                        ++i;
                    }
                } else {
                    frac = sz / total;
                    if (dir > 1.0) {
                        next = frac * box.getHeight();
                        p = new GrappaBox(box.getX(), previous, box.getWidth(), next);
                    } else {
                        next = frac * box.getWidth();
                        p = new GrappaBox(previous, box.getY(), next, box.getHeight());
                    }
                    ((Subgraph)el).compSqPatchWork(p, false);
                    ++i;
                }
                previous += next;
            }
        }
        if (this.elPatches != null) {
            i = 0;
            while (i < this.elPatches.length) {
                String style;
                Attribute attr;
                el = this.elPatches[i];
                sz = el.getPatchSize();
                if (i + 1 < this.elPatches.length) {
                    block41: {
                        psz = 0.0;
                        frac = sz / total;
                        pscore = dir > 1.0 ? this.score(box.getWidth(), frac * box.getHeight()) : this.score(frac * box.getWidth(), box.getHeight());
                        j = i + 1;
                        while (true) {
                            tsz = this.elPatches[j].getPatchSize();
                            tot = psz + sz + tsz;
                            tfrac = tot / total;
                            nscore = dir > 1.0 ? this.score(box.getWidth() * sz / tot, tfrac * box.getHeight()) : this.score(tfrac * box.getWidth(), box.getHeight() * sz / tot);
                            if (!(nscore <= pscore)) break;
                            pscore = dir > 1.0 ? this.score(box.getWidth() * tsz / tot, tfrac * box.getHeight()) : this.score(tfrac * box.getWidth(), box.getHeight() * tsz / tot);
                            psz += sz;
                            sz = tsz;
                            tsz = 0.0;
                            if (++j < this.elPatches.length) {
                                continue;
                            }
                            break block41;
                            break;
                        }
                        tsz = 0.0;
                    }
                    tot = psz + sz + tsz;
                    frac = tot / total;
                    if (dir > 1.0) {
                        prv = box.getX();
                        next = frac * box.getHeight();
                    } else {
                        prv = box.getY();
                        next = frac * box.getWidth();
                    }
                    while (i < j) {
                        el = this.elPatches[i];
                        if (el instanceof Node) {
                            if (dir > 1.0) {
                                nxt = box.getWidth() * el.getPatchSize() / tot;
                                el.setPatch(prv, previous, nxt, next);
                            } else {
                                nxt = box.getHeight() * el.getPatchSize() / tot;
                                el.setPatch(previous, prv, next, nxt);
                            }
                            p = el.getPatch();
                            el.setAttribute("pos", new GrappaPoint(p.getCenterX(), -p.getCenterY()));
                            el.setAttribute("width", new Double(p.getWidth() / 72.0));
                            el.setAttribute("height", new Double(p.getHeight() / 72.0));
                            if (el.getLocalAttribute("color") == null) {
                                el.setAttribute("color", "white");
                            }
                            if ((attr = el.getAttribute("style")) == null) {
                                el.setAttribute("style", "filled,lineColor(black)");
                            } else {
                                style = attr.getStringValue();
                                el.setAttribute("style", style == null || style.length() == 0 ? "filled,lineColor(black)" : style + ",filled,lineColor(black)");
                            }
                        } else {
                            if (dir > 1.0) {
                                nxt = box.getWidth() * el.getPatchSize() / tot;
                                p = new GrappaBox(prv, previous, nxt, next);
                            } else {
                                nxt = box.getHeight() * el.getPatchSize() / tot;
                                p = new GrappaBox(previous, prv, next, nxt);
                            }
                            ((Subgraph)el).compSqPatchWork(p, false);
                        }
                        prv += nxt;
                        ++i;
                    }
                } else {
                    frac = sz / total;
                    if (el instanceof Node) {
                        if (dir > 1.0) {
                            next = frac * box.getHeight();
                            el.setPatch(box.getX(), previous, box.getWidth(), next);
                        } else {
                            next = frac * box.getWidth();
                            el.setPatch(previous, box.getY(), next, box.getHeight());
                        }
                        p = el.getPatch();
                        el.setAttribute("pos", new GrappaPoint(p.getCenterX(), -p.getCenterY()));
                        el.setAttribute("width", new Double(p.getWidth() / 72.0));
                        el.setAttribute("height", new Double(p.getHeight() / 72.0));
                        if (el.getLocalAttribute("color") == null) {
                            el.setAttribute("color", "white");
                        }
                        if ((attr = el.getAttribute("style")) == null) {
                            el.setAttribute("style", "filled,lineColor(black)");
                        } else {
                            style = attr.getStringValue();
                            el.setAttribute("style", style == null || style.length() == 0 ? "filled,lineColor(black)" : style + ",filled,lineColor(black)");
                        }
                    } else {
                        if (dir > 1.0) {
                            next = frac * box.getHeight();
                            p = new GrappaBox(box.getX(), previous, box.getWidth(), next);
                        } else {
                            next = frac * box.getWidth();
                            p = new GrappaBox(previous, box.getY(), next, box.getHeight());
                        }
                        ((Subgraph)el).compSqPatchWork(p, false);
                    }
                    ++i;
                }
                previous += next;
            }
        }
    }

    private void compStdPatchWork(Rectangle2D.Double r, boolean top) {
        double next;
        double frac;
        double sz;
        Element el;
        int i;
        this.setPatch(r);
        this.setAttribute("minsize", new GrappaSize(r.getWidth(), r.getHeight() + (double)(!top ? 1 : 0)));
        double dir = this.aspect(r);
        double total = this.getPatchSize();
        GrappaBox box = top ? new GrappaBox(r) : new GrappaBox(r.getX() + this.PATCHEDGE, r.getY() + this.PATCHEDGE, r.getWidth() - this.PATCHEDGE2, r.getHeight() - this.PATCHEDGE2);
        double previous = dir > 1.0 ? box.getY() : box.getX();
        if (this.sgPatches != null) {
            for (i = 0; i < this.sgPatches.length; ++i) {
                el = this.sgPatches[i];
                sz = el.getPatchSize();
                frac = sz / total;
                if (dir > 1.0) {
                    next = frac * box.getHeight();
                    ((Subgraph)el).compStdPatchWork(new GrappaBox(box.getX(), previous, box.getWidth(), next), false);
                } else {
                    next = frac * box.getWidth();
                    ((Subgraph)el).compStdPatchWork(new GrappaBox(previous, box.getY(), next, box.getHeight()), false);
                }
                previous += next;
            }
        }
        if (this.elPatches != null) {
            for (i = 0; i < this.elPatches.length; ++i) {
                el = this.elPatches[i];
                sz = el.getPatchSize();
                frac = sz / total;
                if (el instanceof Node) {
                    Attribute attr;
                    if (dir > 1.0) {
                        next = frac * box.getHeight();
                        el.setPatch(box.getX(), previous, box.getWidth(), next);
                    } else {
                        next = frac * box.getWidth();
                        el.setPatch(previous, box.getY(), next, box.getHeight());
                    }
                    Rectangle2D.Double p = el.getPatch();
                    el.setAttribute("pos", new GrappaPoint(p.getCenterX(), -p.getCenterY()));
                    el.setAttribute("width", new Double(p.getWidth() / 72.0));
                    el.setAttribute("height", new Double(p.getHeight() / 72.0));
                    if (el.getLocalAttribute("color") == null) {
                        el.setAttribute("color", "white");
                    }
                    if ((attr = el.getAttribute("style")) == null) {
                        el.setAttribute("style", "filled,lineColor(black)");
                    } else {
                        String style = attr.getStringValue();
                        el.setAttribute("style", style == null || style.length() == 0 ? "filled,lineColor(black)" : style + ",filled,lineColor(black)");
                    }
                } else if (dir > 1.0) {
                    next = frac * box.getHeight();
                    ((Subgraph)el).compStdPatchWork(new GrappaBox(box.getX(), previous, box.getWidth(), next), false);
                } else {
                    next = frac * box.getWidth();
                    ((Subgraph)el).compStdPatchWork(new GrappaBox(previous, box.getY(), next, box.getHeight()), false);
                }
                previous += next;
            }
        }
    }

    public int compare(Object o1, Object o2) {
        if (o1 instanceof Element) {
            if (o2 instanceof Element) {
                double diff = ((Element)o2).getPatchSize() - ((Element)o1).getPatchSize();
                return diff < 0.0 ? -1 : (diff > 0.0 ? 1 : 0);
            }
            return 0;
        }
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        return false;
    }

    public java.util.Iterator<Node> nodeElements() {
        if (this.nodedict == null) {
            return Grappa.emptyNodeIterator.iterator();
        }
        return this.nodedict.values().iterator();
    }

    public Node[] nodeElementsAsArray() {
        if (this.nodedict == null) {
            return Grappa.emptyNodeIterator.toArray(EMPTY_NODE_ARRAY);
        }
        return this.nodedict.values().toArray(EMPTY_NODE_ARRAY);
    }

    public java.util.Iterator<Edge> edgeElements() {
        if (this.edgedict == null) {
            return Grappa.emptyEdgeIterator.iterator();
        }
        return this.edgedict.values().iterator();
    }

    public Edge[] edgeElementsAsArray() {
        if (this.edgedict == null) {
            return Grappa.emptyEdgeIterator.toArray(EMPTY_EDGE_ARRAY);
        }
        return this.edgedict.values().toArray(EMPTY_EDGE_ARRAY);
    }

    public java.util.Iterator<Subgraph> subgraphElements() {
        if (this.graphdict == null) {
            return Grappa.emptySubgraphIterator.iterator();
        }
        return this.graphdict.values().iterator();
    }

    public Subgraph[] subgraphElementsAsArray() {
        if (this.graphdict == null) {
            return Grappa.emptySubgraphIterator.toArray(EMPTY_SUBGRAPH_ARRAY);
        }
        return this.graphdict.values().toArray(EMPTY_SUBGRAPH_ARRAY);
    }

    public GraphIterator elements(int types) {
        return new Iterator(types);
    }

    public GraphIterator elements() {
        return new Iterator(7);
    }

    public List<Element> listOfElements(int types) {
        java.util.Iterator<Element> elems;
        ArrayList<Element> retVec = new ArrayList<Element>();
        int count = 0;
        if ((types & 1) != 0 && this.nodedict != null) {
            elems = null;
            retVec.ensureCapacity(count += this.nodedict.size());
            elems = this.nodedict.values().iterator();
            while (elems.hasNext()) {
                retVec.add(elems.next());
            }
        }
        if ((types & 2) != 0 && this.edgedict != null) {
            elems = null;
            retVec.ensureCapacity(count += this.edgedict.size());
            elems = this.edgedict.values().iterator();
            while (elems.hasNext()) {
                retVec.add(elems.next());
            }
        }
        if (this.graphdict != null) {
            elems = null;
            if ((types & 4) != 0) {
                retVec.ensureCapacity(count += this.graphdict.size());
            }
            elems = this.graphdict.values().iterator();
            while (elems.hasNext()) {
                ((Subgraph)elems.next()).recurseListOfElements(types, retVec, count);
            }
        }
        return retVec;
    }

    void recurseListOfElements(int types, ArrayList<Element> retVec, int count) {
        java.util.Iterator<Element> elems;
        if ((types & 4) != 0) {
            retVec.add(this);
        }
        if ((types & 1) != 0 && this.nodedict != null) {
            elems = null;
            retVec.ensureCapacity(count += this.nodedict.size());
            elems = this.nodedict.values().iterator();
            while (elems.hasNext()) {
                retVec.add(elems.next());
            }
        }
        if ((types & 2) != 0 && this.edgedict != null) {
            elems = null;
            retVec.ensureCapacity(count += this.edgedict.size());
            elems = this.edgedict.values().iterator();
            while (elems.hasNext()) {
                retVec.add(elems.next());
            }
        }
        if (this.graphdict != null) {
            elems = null;
            if ((types & 4) != 0) {
                retVec.ensureCapacity(count += this.graphdict.size());
            }
            elems = this.graphdict.values().iterator();
            while (elems.hasNext()) {
                ((Subgraph)elems.next()).recurseListOfElements(types, retVec, count);
            }
        }
    }

    class Iterator
    implements GraphIterator {
        private Subgraph root = null;
        private int types = 0;
        private java.util.Iterator enm = null;
        private GraphIterator subEnum = null;
        private Element elem = null;
        private int dictType = 0;

        Iterator(int t) {
            this.root = Subgraph.this;
            this.types = t;
            this.elem = (this.types & 4) != 0 ? this.root : null;
            this.enm = Subgraph.this.subgraphElements();
            if (this.enm.hasNext()) {
                this.dictType = 4;
                while (this.enm.hasNext()) {
                    Subgraph subgraph2 = (Subgraph)this.enm.next();
                    subgraph2.getClass();
                    this.subEnum = subgraph2.new Iterator(this.types);
                    if (!this.subEnum.hasNext()) continue;
                    if (this.elem == null) {
                        this.elem = (Element)this.subEnum.next();
                    }
                    break;
                }
            } else {
                this.dictType = 0;
                this.enm = null;
                this.subEnum = null;
            }
            if (this.enm == null) {
                if ((this.types & 1) != 0 && (this.enm = Subgraph.this.nodeElements()).hasNext()) {
                    this.dictType = 1;
                    if (this.elem == null) {
                        this.elem = (Element)this.enm.next();
                    }
                } else if ((this.types & 2) != 0 && (this.enm = Subgraph.this.edgeElements()).hasNext()) {
                    this.dictType = 2;
                    if (this.elem == null) {
                        this.elem = (Element)this.enm.next();
                    }
                } else {
                    this.enm = null;
                }
            }
        }

        public boolean hasNext() {
            return this.elem != null;
        }

        public Object next() {
            if (this.elem == null) {
                throw new NoSuchElementException("Subgraph$Enumerator");
            }
            Element el = this.elem;
            if (this.subEnum != null && this.subEnum.hasNext()) {
                this.elem = (Element)this.subEnum.next();
            } else if (this.enm != null && this.enm.hasNext()) {
                do {
                    this.elem = (Element)this.enm.next();
                    if (!this.elem.isSubgraph()) break;
                    Subgraph subgraph = (Subgraph)this.elem;
                    subgraph.getClass();
                    this.subEnum = subgraph.new Iterator(this.getIterationTypes());
                    if (this.subEnum.hasNext()) {
                        this.elem = (Element)this.subEnum.next();
                        break;
                    }
                    this.elem = null;
                } while (this.enm.hasNext());
            } else {
                this.elem = null;
            }
            if (this.elem == null && this.dictType != 0) {
                if (this.dictType == 4) {
                    if ((this.getIterationTypes() & 1) != 0 && (this.enm = Subgraph.this.nodeElements()).hasNext()) {
                        this.dictType = 1;
                        this.elem = (Element)this.enm.next();
                    } else if ((this.getIterationTypes() & 2) != 0 && (this.enm = Subgraph.this.edgeElements()).hasNext()) {
                        this.dictType = 2;
                        this.elem = (Element)this.enm.next();
                    } else {
                        this.dictType = 0;
                        this.enm = null;
                    }
                } else if (this.dictType == 1) {
                    if ((this.getIterationTypes() & 2) != 0 && (this.enm = Subgraph.this.edgeElements()).hasNext()) {
                        this.dictType = 2;
                        this.elem = (Element)this.enm.next();
                    } else {
                        this.dictType = 0;
                        this.enm = null;
                    }
                } else {
                    this.dictType = 0;
                    this.enm = null;
                }
            }
            return el;
        }

        public Element nextGraphElement() {
            return (Element)this.next();
        }

        public Subgraph getSubgraphRoot() {
            return this.root;
        }

        public int getIterationTypes() {
            return this.types;
        }

        public void remove() {
        }
    }
}

