/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.visualisation.Zoomable;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterGraphics;
import javax.swing.JComponent;
import javax.swing.Scrollable;

public class TickBar
extends JComponent
implements ComponentListener,
Scrollable,
Zoomable,
Printable {
    final int HEIGHT = 20;
    int WIDTH = 20;
    final int PRINTER_GAP = 10;
    boolean vertical;
    int initialMajorTickSpace;
    int initialMinorTickSpace;
    int majorTickSpace;
    int minorTickSpace;
    double initialScale;
    double scale;
    double displayMargin;
    float zoomLevel;
    JComponent panel;
    Cursor leftScalingCursor;
    Cursor rightScalingCursor;

    public TickBar(JComponent jComponent, boolean bl, int n, int n2, double d, double d2) {
        this.vertical = bl;
        this.initialMajorTickSpace = n;
        this.initialMinorTickSpace = n2;
        this.majorTickSpace = n;
        this.minorTickSpace = n2;
        this.initialScale = d;
        this.scale = d;
        this.displayMargin = d2;
        this.zoomLevel = 1.0f;
        this.panel = jComponent;
        this.leftScalingCursor = Cursor.getPredefinedCursor(10);
        this.rightScalingCursor = Cursor.getPredefinedCursor(11);
        this.setScalingRight(true);
        jComponent.addComponentListener(this);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Rectangle rectangle = graphics.getClipRect();
        if (graphics instanceof PrinterGraphics) {
            this.paintTicks(graphics, 0);
        } else {
            graphics.setColor(Color.white);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.paintTicks(graphics, (int)this.displayMargin);
        }
    }

    void paintTicks(Graphics graphics, int n) {
        int n2 = this.getBounds().width;
        int n3 = this.getBounds().height;
        graphics.setColor(Color.black);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (this.vertical) {
            double d;
            boolean bl = false;
            for (d = 0.0; d <= (double)n3; d += (double)this.majorTickSpace) {
                String string = "" + d;
                int n4 = n3 - ((int)((float)n * this.zoomLevel) + (int)(d * this.scale * (double)this.zoomLevel));
                Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
                if (rectangle2D.getWidth() > (double)this.WIDTH) {
                    this.WIDTH = (int)rectangle2D.getWidth();
                    bl = true;
                }
                graphics.drawString(string, 0, n4 + (int)(rectangle2D.getHeight() / 2.0));
                graphics.drawLine(n2 / 2, n4, n2 - 1, n4);
            }
            for (d = 0.0; d <= (double)n3; d += (double)this.minorTickSpace) {
                int n5 = n3 - ((int)((float)n * this.zoomLevel) + (int)(d * this.scale * (double)this.zoomLevel));
                graphics.drawLine(n2 * 3 / 4, n5, n2 - 1, n5);
            }
            if (bl) {
                this.invalidate();
            }
        } else {
            double d;
            for (d = 0.0; d <= (double)n2; d += (double)this.majorTickSpace) {
                String string = "" + d;
                int n6 = (int)((float)n * this.zoomLevel) + (int)(d * this.scale * (double)this.zoomLevel);
                Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
                graphics.drawString(string, n6 - (int)(rectangle2D.getWidth() / 2.0), (int)rectangle2D.getHeight());
                graphics.drawLine(n6, n3 / 2, n6, n3 - 1);
            }
            for (d = 0.0; d <= (double)n2; d += (double)this.minorTickSpace) {
                int n7 = (int)((float)n * this.zoomLevel) + (int)(d * this.scale * (double)this.zoomLevel);
                graphics.drawLine(n7, n3 * 3 / 4, n7, n3 - 1);
            }
        }
    }

    public void setScalingRight(boolean bl) {
        if (bl) {
            this.setCursor(this.rightScalingCursor);
        } else {
            this.setCursor(this.leftScalingCursor);
        }
    }

    public void setScale(double d) {
        this.scale = d;
        double d2 = this.initialScale / d;
        if (d2 >= 2.0) {
            int n = (int)Math.round(Math.floor(d2));
            this.majorTickSpace = n * this.initialMajorTickSpace;
            this.minorTickSpace = n * this.initialMinorTickSpace;
        } else if (d2 <= 1.0) {
            this.majorTickSpace = this.initialMajorTickSpace;
            this.minorTickSpace = this.initialMinorTickSpace;
        }
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.vertical) {
            return new Dimension(this.WIDTH, this.panel.getPreferredSize().height);
        }
        return new Dimension(this.panel.getPreferredSize().width, 20);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return this.majorTickSpace;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 1;
    }

    @Override
    public void setNormalSize(Dimension dimension) {
    }

    @Override
    public Dimension getNormalSize() {
        return this.getPreferredSize();
    }

    @Override
    public void zoomToLevel(float f) {
        this.zoomLevel = f;
        this.invalidate();
    }

    public void zoomInByRatio(float f) {
        this.zoomLevel *= f;
        this.invalidate();
    }

    @Override
    public float getZoomLevel() {
        return this.zoomLevel;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= 1) {
            return 1;
        }
        ((Graphics2D)graphics).translate(0, 0);
        this.paintComponent(graphics);
        return 0;
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.setSize(componentEvent.getComponent().getSize());
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }
}

