/*
 * Decompiled with CFR 0.152.
 */
package ie.ucc.cccc.viz;

import ie.ucc.cccc.viz.Tool;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class Box {
    private static int scaleSVG = 100;
    private int x;
    private int y;
    private int width;
    private int height;

    public String toString() {
        return "<Box X" + this.x + " Y " + this.y + " Width " + this.width + " Height " + this.height + ">";
    }

    public Box(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void expandBox(Box box) {
        int n = Math.min(this.x, box.x);
        int n2 = Math.min(this.y, box.y);
        int n3 = Math.max(this.x + this.width, box.x + box.width);
        int n4 = Math.max(this.y + this.height, box.y + box.height);
        this.width = n3 - n;
        this.height = n4 - n2;
        this.x = n;
        this.y = n2;
    }

    public PrintWriter svgPrefix(Tool tool, String string) {
        try {
            File file = new File(tool.getDirectory(), string);
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
            printWriter.println("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\"");
            printWriter.println(" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">");
            printWriter.println("<svg");
            printWriter.println("   xmlns:svg=\"http://www.w3.org/2000/svg\"");
            printWriter.println("   xmlns=\"http://www.w3.org/2000/svg\"");
            printWriter.println("   version=\"1.1\"");
            printWriter.println("   width=\"" + tool.getWidth() + "px\"");
            printWriter.println("   height=\"" + tool.getHeight() + "px\"");
            int n = this.width;
            int n2 = this.height;
            printWriter.println("   viewBox=\"" + scaleSVG * this.x + " " + scaleSVG * this.y + " " + scaleSVG * n + " " + scaleSVG * n2 + "\">");
            return printWriter;
        }
        catch (IOException iOException) {
            System.out.println("no luck");
            return null;
        }
    }

    public void svgPostfix(PrintWriter printWriter) {
        printWriter.println("</svg>");
        printWriter.close();
    }
}

