/*
 * Decompiled with CFR 0.152.
 */
package ie.ucc.cccc.viz;

import ie.ucc.cccc.viz.Box;
import ie.ucc.cccc.viz.Colors;
import ie.ucc.cccc.viz.Extent;
import ie.ucc.cccc.viz.Node;
import ie.ucc.cccc.viz.NodeType;
import ie.ucc.cccc.viz.Pair;
import ie.ucc.cccc.viz.Tool;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;

public class Layout {
    private Node node;
    private double x;
    private int y;
    private LinkedList<Layout> children;
    private Extent extent;
    public ArrayList<Pair> test;

    private Layout(Node node, double d, int n, LinkedList<Layout> linkedList, Extent extent) {
        this.node = node;
        this.x = d;
        this.y = n;
        this.children = linkedList;
        this.extent = extent;
    }

    public static Layout layoutNode(Node node, boolean bl, int n, int n2) {
        if (node.getChildren().size() == 0 || node.getId() >= n) {
            double d = 0.0;
            int n3 = n2;
            return new Layout(node, d, n3, new LinkedList<Layout>(), new Extent(d, d));
        }
        if (bl && node.isAllFailedBelow() && node.getLastDecendent() < n) {
            double d = 0.0;
            int n4 = n2;
            Extent extent = new Extent(d, d);
            extent.add(d, d);
            return new Layout(node, d, n4, new LinkedList<Layout>(), extent);
        }
        LinkedList<Layout> linkedList = new LinkedList<Layout>();
        ListIterator<Node> listIterator = node.getChildren().listIterator();
        Extent extent = new Extent();
        while (listIterator.hasNext()) {
            Node node2 = listIterator.next();
            if (node2.getId() > n) continue;
            Layout layout = Layout.layoutNode(node2, bl, n, n2 + 1);
            double d = layout.getExtent().getRight();
            extent = extent.addExtent(layout.extent);
            layout.moveTree(layout.getExtent().getRight() - d);
            linkedList.add(layout);
        }
        double d = (extent.getLeft() + extent.getRight()) / 2.0;
        int n5 = n2;
        extent.addFirst(d, d);
        return new Layout(node, d, n5, linkedList, extent);
    }

    private Extent getExtent() {
        return this.extent;
    }

    public Box getBox() {
        Box box = new Box((int)this.x - 1, this.y - 1, 2, 2);
        ListIterator listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            box.expandBox(((Layout)listIterator.next()).getBox());
        }
        return box;
    }

    private void moveTree(double d) {
        this.x += d;
        ListIterator listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            Layout layout = (Layout)listIterator.next();
            layout.moveTree(d);
        }
    }

    public void draw(Tool tool, Box box, boolean bl, int n, String string) {
        PrintWriter printWriter = box.svgPrefix(tool, string);
        this.lineDraw(printWriter);
        this.nodeDraw(printWriter, n);
        box.svgPostfix(printWriter);
    }

    private void lineDraw(PrintWriter printWriter) {
        ListIterator listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            NodeType nodeType;
            Layout layout = (Layout)listIterator.next();
            layout.lineDraw(printWriter);
            printWriter.println("<!-- from " + this.node.getId() + " to " + layout.node.getId() + " -->");
            Colors colors = Colors.LINK_COLOR;
            if (layout.node.getSize() == 1) {
                colors = Colors.FIXED_LINK_COLOR;
            }
            if ((nodeType = layout.node.getType()) == NodeType.TRYC || nodeType == NodeType.FAILC || nodeType == NodeType.SUCCC) {
                this.lineChoiceSVG(printWriter, this.x, this.y, layout.x, layout.y, layout.node.getChoice(), colors);
                continue;
            }
            this.lineValueSVG(printWriter, this.x, this.y, layout.x, layout.y, layout.node.getValue(), colors);
        }
    }

    private void nodeDraw(PrintWriter printWriter, int n) {
        if (this.children.size() == 0) {
            NodeType nodeType;
            double d = 0.1;
            if (this.node.getId() == n) {
                d = 0.15;
            }
            if ((nodeType = this.node.getType()) == NodeType.FAIL || nodeType == NodeType.FAILC) {
                this.circleSVG(printWriter, this.x, this.y, d, Colors.FAILED_NODE_COLOR);
            } else if (nodeType == NodeType.SUCC || nodeType == NodeType.SUCCC) {
                this.circleSVG(printWriter, this.x, this.y, d, Colors.SUCC_NODE_COLOR);
            } else if (this.node.getId() == n) {
                this.circleSVG(printWriter, this.x, this.y, d, Colors.LAST_NODE_COLOR);
            } else if (this.node.getTotalFailures() == 0) {
                this.circleSVG(printWriter, this.x, this.y, d, Colors.UNEXPLORED_NODE_TEXT_COLOR);
            } else if (this.node.isAllFailedBelow() && this.node.getLastDecendent() < n) {
                this.triangleSVG(printWriter, this.x, this.y, Colors.FAILED_NODE_COLOR, this.node.getTotalDecendent(), this.node.getTotalFailures());
            }
            this.invariantDraw(printWriter, this.x, this.y, this.node);
        } else {
            ListIterator listIterator = this.children.listIterator();
            while (listIterator.hasNext()) {
                Layout layout = (Layout)listIterator.next();
                layout.nodeDraw(printWriter, n);
                this.textSVG(printWriter, this.x, this.y, layout.node.getName(), Colors.UNEXPLORED_NODE_TEXT_COLOR);
                if (layout.node.getSize() >= 0) {
                    this.textSVG(printWriter, this.x + 0.4, (double)this.y, 0.2, layout.node.getSize(), Colors.NODE_INFO_TEXT_COLOR);
                }
                this.invariantDraw(printWriter, this.x, this.y, this.node);
            }
        }
    }

    public void invariantDraw(PrintWriter printWriter, double d, double d2, Node node) {
        switch (node.getInvariantType()) {
            case TRUE: {
                break;
            }
            case MISSING_PROPAGATION: {
                this.drawCross(printWriter, d, d2, Colors.MISSING_PROPAGATION_COLOR);
                break;
            }
            case INCONSISTENT: {
                this.drawCross(printWriter, d, d2, Colors.INCONSISTENT_COLOR);
                break;
            }
            case INTERESTING: {
                this.drawCross(printWriter, d, d2, Colors.INTERESTING_COLOR);
                break;
            }
            case FALSE: {
                this.drawCross(printWriter, d, d2, Colors.FALSE_COLOR);
                break;
            }
            default: {
                System.out.println("Wrong invariant type");
            }
        }
    }

    public void drawCross(PrintWriter printWriter, double d, double d2, Colors colors) {
        double d3 = 0.2;
        this.wideLineSVG(printWriter, d - d3, d2 - d3, d + d3, d2 + d3, colors);
        this.wideLineSVG(printWriter, d - d3, d2 + d3, d + d3, d2 - d3, colors);
    }

    protected void wideLineSVG(PrintWriter printWriter, double d, double d2, double d3, double d4, Colors colors) {
        printWriter.println("<line x1=\"" + d * 100.0 + "\" y1=\"" + d2 * 100.0 + "\" x2=\"" + d3 * 100.0 + "\" y2=\"" + d4 * 100.0 + "\" style=\"stroke:" + String.valueOf((Object)colors) + ";stroke-width:5;\"/>");
    }

    protected void lineSVG(PrintWriter printWriter, double d, int n, double d2, int n2) {
        printWriter.println("<line x1=\"" + d * 100.0 + "\" y1=\"" + n * 100 + "\" x2=\"" + d2 * 100.0 + "\" y2=\"" + n2 * 100 + "\" style=\"stroke:" + String.valueOf((Object)Colors.LINK_COLOR) + ";stroke-width:2;\"/>");
    }

    protected void lineValueSVG(PrintWriter printWriter, double d, int n, double d2, int n2, int n3, Colors colors) {
        printWriter.println("<line x1=\"" + d * 100.0 + "\" y1=\"" + n * 100 + "\" x2=\"" + d2 * 100.0 + "\" y2=\"" + n2 * 100 + "\" style=\"stroke:" + String.valueOf((Object)colors) + ";stroke-width:2;\"/>");
        double d3 = (d + d2) / 2.0 + 0.05;
        double d4 = (double)(n + n2) / 2.0 + 0.15;
        printWriter.println("<text x=\"" + d3 * 100.0 + "\" y=\"" + d4 * 100.0 + "\" style=\"stroke:none;fill:" + String.valueOf((Object)Colors.VALUE_TEXT_COLOR) + ";font-family:Arial,sans-serif;font-size:30px;text-anchor:start;\">");
        printWriter.println(n3);
        printWriter.println("</text>");
    }

    protected void lineChoiceSVG(PrintWriter printWriter, double d, int n, double d2, int n2, String string, Colors colors) {
        printWriter.println("<line x1=\"" + d * 100.0 + "\" y1=\"" + n * 100 + "\" x2=\"" + d2 * 100.0 + "\" y2=\"" + n2 * 100 + "\" style=\"stroke:" + String.valueOf((Object)colors) + ";stroke-width:2;\"/>");
        double d3 = (d + d2) / 2.0 + 0.05;
        double d4 = (double)(n + n2) / 2.0 + 0.15;
        printWriter.println("<text x=\"" + d3 * 100.0 + "\" y=\"" + d4 * 100.0 + "\" style=\"stroke:none;fill:" + String.valueOf((Object)Colors.VALUE_TEXT_COLOR) + ";font-family:Arial,sans-serif;font-size:20px;text-anchor:start;\">");
        printWriter.println(string);
        printWriter.println("</text>");
    }

    protected void textSVG(PrintWriter printWriter, double d, int n, int n2, Colors colors) {
        this.textSVG(printWriter, d, n, Integer.toString(n2), colors);
    }

    protected void textSVG(PrintWriter printWriter, double d, int n, String string, Colors colors) {
        printWriter.println("<text x=\"" + 100.0 * d + "\" y=\"" + (100 * n + 20) + "\" style=\"stroke:none;fill:" + String.valueOf((Object)colors) + ";font-family:Arial,sans-serif;font-size:40px;text-anchor:middle;\">");
        printWriter.println(string);
        printWriter.println("</text>");
    }

    protected void textSVG(PrintWriter printWriter, double d, double d2, double d3, int n, Colors colors) {
        this.textSVG(printWriter, d, d2, d3, Integer.toString(n), colors);
    }

    protected void textSVG(PrintWriter printWriter, double d, double d2, double d3, String string, Colors colors) {
        printWriter.println("<text x=\"" + 100.0 * d + "\" y=\"" + 100.0 * d2 + "\" style=\"stroke:none;fill:" + String.valueOf((Object)colors) + ";font-family:Arial,sans-serif;font-size:" + d3 * 100.0 + "px;text-anchor:middle;\">");
        printWriter.println(string);
        printWriter.println("</text>");
    }

    protected void circleSVG(PrintWriter printWriter, double d, double d2, double d3, Colors colors) {
        printWriter.println("<circle cx=\"" + 100.0 * d + "\" cy=\"" + 100.0 * d2 + "\" r=\"" + d3 * 100.0 + "\" style=\"stroke:" + String.valueOf((Object)Colors.NODE_BORDER_COLOR) + ";stroke-width:1;fill:" + String.valueOf((Object)colors) + ";\"/>");
    }

    private void triangleSVG(PrintWriter printWriter, double d, int n, Colors colors, int n2, int n3) {
        printWriter.println("<polygon style=\"fill:" + String.valueOf((Object)colors) + ";stroke-width:1;stroke:" + String.valueOf((Object)Colors.NODE_BORDER_COLOR) + ";\" points=\"" + d * 100.0 + "," + n * 100 + "," + (d * 100.0 + 50.0) + "," + (n * 100 + 50) + "," + (d * 100.0 - 50.0) + "," + (n * 100 + 50) + "\" />");
        this.textSVG(printWriter, d, (double)n + 0.45, 0.3, n2, Colors.NODE_INFO_TEXT_COLOR);
        this.textSVG(printWriter, d, (double)n + 0.8, 0.3, n3, Colors.NODE_INFO_TEXT_COLOR);
    }
}

