/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.plugin;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.activemq.broker.region.virtual.FilteredDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.schema.core.DtoAuthenticationUser;
import org.apache.activemq.schema.core.DtoFilteredDestination;
import org.apache.activemq.schema.core.DtoQueue;
import org.apache.activemq.schema.core.DtoSslContext;
import org.apache.activemq.schema.core.DtoTopic;
import org.apache.activemq.security.AuthenticationUser;
import org.apache.activemq.spring.SpringSslContext;

public class JAXBUtils {
    public static Method findSetter(Object instance, String elementName) {
        String setter = "set" + elementName;
        for (Method m : instance.getClass().getMethods()) {
            if (!setter.equals(m.getName())) continue;
            return m;
        }
        return null;
    }

    public static void ensureAccessible(Method m) {
        if (!(Modifier.isPublic(m.getModifiers()) && Modifier.isPublic(m.getDeclaringClass().getModifiers()) || m.isAccessible())) {
            m.setAccessible(true);
        }
    }

    public static Object inferTargetObject(Object elementContent) {
        if (DtoTopic.class.isAssignableFrom(elementContent.getClass())) {
            return new ActiveMQTopic();
        }
        if (DtoQueue.class.isAssignableFrom(elementContent.getClass())) {
            return new ActiveMQQueue();
        }
        if (DtoAuthenticationUser.class.isAssignableFrom(elementContent.getClass())) {
            return new AuthenticationUser();
        }
        if (DtoFilteredDestination.class.isAssignableFrom(elementContent.getClass())) {
            return new FilteredDestination();
        }
        if (DtoSslContext.class.isAssignableFrom(elementContent.getClass())) {
            return new SpringSslContext();
        }
        return new Object();
    }

    public static Object matchType(List<Object> parameterValues, Class<?> aClass) {
        Object result = parameterValues;
        if (Set.class.isAssignableFrom(aClass)) {
            result = new HashSet<Object>(parameterValues);
        } else if (!Collection.class.isAssignableFrom(aClass)) {
            result = parameterValues.get(0);
        }
        return result;
    }
}

