/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.tcp;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.AxisFault;
import org.apache.axis2.transport.base.AbstractTransportListenerEx;
import org.apache.axis2.transport.tcp.TCPEndpoint;
import org.apache.axis2.transport.tcp.TCPServer;

public class TCPTransportListener
extends AbstractTransportListenerEx<TCPEndpoint> {
    private Map<TCPEndpoint, TCPServer> serverTable = new ConcurrentHashMap<TCPEndpoint, TCPServer>();

    protected void doInit() throws AxisFault {
    }

    protected TCPEndpoint createEndpoint() {
        return new TCPEndpoint();
    }

    protected void startEndpoint(TCPEndpoint endpoint) throws AxisFault {
        try {
            TCPServer server = new TCPServer(endpoint, this.workerPool);
            server.startServer();
            this.serverTable.put(endpoint, server);
        }
        catch (IOException e) {
            this.handleException("Error while starting the TCP endpoint", e);
        }
    }

    protected void stopEndpoint(TCPEndpoint endpoint) {
        try {
            TCPServer server = this.serverTable.get((Object)endpoint);
            if (server != null) {
                server.stopServer();
            }
        }
        catch (IOException e) {
            this.log.error((Object)"Error while stopping the TCP endpoint", (Throwable)e);
        }
        finally {
            this.serverTable.remove((Object)endpoint);
        }
    }
}

