/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.axis2.kernel.OutTransportInfo;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.axis2.transport.jms.AxisJMSException;
import org.apache.axis2.transport.jms.JMSConnectionFactory;
import org.apache.axis2.transport.jms.JMSMessageSender;
import org.apache.axis2.transport.jms.JMSUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSOutTransportInfo
implements OutTransportInfo {
    private static final Log log = LogFactory.getLog(JMSOutTransportInfo.class);
    private Context context;
    private ConnectionFactory connectionFactory = null;
    private JMSConnectionFactory jmsConnectionFactory = null;
    private Destination destination = null;
    private String destinationType = "generic";
    private Destination replyDestination = null;
    private String replyDestinationName = null;
    private String replyDestinationType = "generic";
    private Hashtable<String, String> properties = null;
    private String targetEPR = null;
    private String contentTypeProperty;

    JMSOutTransportInfo(JMSConnectionFactory jmsConnectionFactory, Destination dest, String contentTypeProperty) {
        this.jmsConnectionFactory = jmsConnectionFactory;
        this.destination = dest;
        this.destinationType = dest instanceof Topic ? "topic" : "queue";
        this.contentTypeProperty = contentTypeProperty;
    }

    JMSOutTransportInfo(String targetEPR) {
        this.targetEPR = targetEPR;
        if (!targetEPR.startsWith("jms:/")) {
            this.handleException("Invalid prefix for a JMS EPR : " + targetEPR);
        } else {
            String replyDestinationType;
            this.properties = BaseUtils.getEPRProperties((String)targetEPR);
            String destinationType = this.properties.get("transport.jms.DestinationType");
            if (destinationType != null) {
                this.setDestinationType(destinationType);
            }
            if ((replyDestinationType = this.properties.get("transport.jms.ReplyDestinationType")) != null) {
                this.setReplyDestinationType(replyDestinationType);
            }
            this.replyDestinationName = this.properties.get("transport.jms.ReplyDestination");
            this.contentTypeProperty = this.properties.get("transport.jms.ContentTypeProperty");
            try {
                this.context = new InitialContext(this.properties);
            }
            catch (NamingException e) {
                this.handleException("Could not get an initial context using " + this.properties, e);
            }
            this.destination = this.getDestination(this.context, targetEPR);
            this.replyDestination = this.getReplyDestination(this.context, targetEPR);
        }
    }

    public void loadConnectionFactoryFromProperies() {
        if (this.properties != null) {
            this.connectionFactory = this.getConnectionFactory(this.context, this.properties);
        }
    }

    private ConnectionFactory getConnectionFactory(Context context, Hashtable<String, String> props) {
        try {
            String conFacJndiName = props.get("transport.jms.ConnectionFactoryJNDIName");
            if (conFacJndiName != null) {
                return JMSUtils.lookup(context, ConnectionFactory.class, conFacJndiName);
            }
            this.handleException("Connection Factory JNDI name cannot be determined");
        }
        catch (NamingException e) {
            this.handleException("Failed to look up connection factory from JNDI", e);
        }
        return null;
    }

    private Destination getDestination(Context context, String url) {
        String destinationName = JMSUtils.getDestination(url);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Lookup the JMS destination " + destinationName + " of type " + this.destinationType + " extracted from the URL " + url));
        }
        try {
            return JMSUtils.lookupDestination(context, destinationName, this.destinationType);
        }
        catch (NamingException e) {
            this.handleException("Couldn't locate the JMS destination " + destinationName + " of type " + this.destinationType + " extracted from the URL " + url, e);
            return null;
        }
    }

    private Destination getReplyDestination(Context context, String url) {
        String replyDestinationName = this.properties.get("transport.jms.ReplyDestination");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Lookup the JMS destination " + replyDestinationName + " of type " + this.replyDestinationType + " extracted from the URL " + url));
        }
        try {
            return JMSUtils.lookupDestination(context, replyDestinationName, this.replyDestinationType);
        }
        catch (NamingException e) {
            this.handleException("Couldn't locate the JMS destination " + replyDestinationName + " of type " + this.replyDestinationType + " extracted from the URL " + url, e);
            return null;
        }
    }

    public Destination getReplyDestination(String replyDest) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Lookup the JMS destination " + replyDest + " of type " + this.replyDestinationType));
        }
        try {
            return JMSUtils.lookupDestination(this.jmsConnectionFactory.getContext(), replyDest, this.replyDestinationType);
        }
        catch (NamingException e) {
            this.handleException("Couldn't locate the JMS destination " + replyDest + " of type " + this.replyDestinationType, e);
            return null;
        }
    }

    private void handleException(String s) {
        log.error((Object)s);
        throw new AxisJMSException(s);
    }

    private void handleException(String s, Exception e) {
        log.error((Object)s, (Throwable)e);
        throw new AxisJMSException(s, e);
    }

    public Destination getDestination() {
        return this.destination;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public JMSConnectionFactory getJmsConnectionFactory() {
        return this.jmsConnectionFactory;
    }

    public void setContentType(String contentType) {
    }

    public Hashtable<String, String> getProperties() {
        return this.properties;
    }

    public String getTargetEPR() {
        return this.targetEPR;
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(String destinationType) {
        if (destinationType != null) {
            this.destinationType = destinationType;
        }
    }

    public Destination getReplyDestination() {
        return this.replyDestination;
    }

    public void setReplyDestination(Destination replyDestination) {
        this.replyDestination = replyDestination;
    }

    public String getReplyDestinationType() {
        return this.replyDestinationType;
    }

    public void setReplyDestinationType(String replyDestinationType) {
        this.replyDestinationType = replyDestinationType;
    }

    public String getReplyDestinationName() {
        return this.replyDestinationName;
    }

    public void setReplyDestinationName(String replyDestinationName) {
        this.replyDestinationName = replyDestinationName;
    }

    public String getContentTypeProperty() {
        return this.contentTypeProperty;
    }

    public void setContentTypeProperty(String contentTypeProperty) {
        this.contentTypeProperty = contentTypeProperty;
    }

    public JMSMessageSender createJMSSender() throws JMSException {
        this.loadConnectionFactoryFromProperies();
        String user = this.properties != null ? this.properties.get("transport.jms.UserName") : null;
        String pass = this.properties != null ? this.properties.get("transport.jms.Password") : null;
        QueueConnectionFactory qConFac = null;
        TopicConnectionFactory tConFac = null;
        int destType = -1;
        if ("queue".equals(this.destinationType)) {
            destType = 1;
            qConFac = (QueueConnectionFactory)this.connectionFactory;
        } else if ("topic".equals(this.destinationType)) {
            destType = 2;
            tConFac = (TopicConnectionFactory)this.connectionFactory;
        } else {
            destType = 1;
            qConFac = (QueueConnectionFactory)this.connectionFactory;
        }
        QueueConnection connection = null;
        if (user != null && pass != null) {
            if (qConFac != null) {
                connection = qConFac.createQueueConnection(user, pass);
            } else if (tConFac != null) {
                connection = tConFac.createTopicConnection(user, pass);
            }
        } else if (qConFac != null) {
            connection = qConFac.createQueueConnection();
        } else if (tConFac != null) {
            connection = tConFac.createTopicConnection();
        }
        if (connection == null) {
            connection = this.jmsConnectionFactory != null ? this.jmsConnectionFactory.getConnection() : null;
        }
        QueueSession session = null;
        QueueSender producer = null;
        if (connection != null) {
            if (destType == 1) {
                session = connection.createQueueSession(false, 1);
                producer = session.createSender((Queue)this.destination);
            } else {
                session = ((TopicConnection)connection).createTopicSession(false, 1);
                producer = ((TopicSession)session).createPublisher((Topic)this.destination);
            }
        }
        return new JMSMessageSender((Connection)connection, (Session)session, (MessageProducer)producer, this.destination, this.jmsConnectionFactory == null ? 0 : this.jmsConnectionFactory.getCacheLevel(), false, destType == -1 ? null : (destType == 1 ? Boolean.TRUE : Boolean.FALSE));
    }
}

