/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.parser;

import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import org.openjdk.tools.javac.parser.JavaTokenizer;
import org.openjdk.tools.javac.parser.Lexer;
import org.openjdk.tools.javac.parser.ScannerFactory;
import org.openjdk.tools.javac.parser.Tokens;
import org.openjdk.tools.javac.util.Position;

public class Scanner
implements Lexer {
    private Tokens tokens;
    private Tokens.Token token;
    private Tokens.Token prevToken;
    private List<Tokens.Token> savedTokens = new ArrayList<Tokens.Token>();
    private JavaTokenizer tokenizer;

    protected Scanner(ScannerFactory scannerFactory, CharBuffer charBuffer) {
        this(scannerFactory, new JavaTokenizer(scannerFactory, charBuffer));
    }

    protected Scanner(ScannerFactory scannerFactory, char[] cArray, int n) {
        this(scannerFactory, new JavaTokenizer(scannerFactory, cArray, n));
    }

    protected Scanner(ScannerFactory scannerFactory, JavaTokenizer javaTokenizer) {
        this.tokenizer = javaTokenizer;
        this.tokens = scannerFactory.tokens;
        this.token = this.prevToken = Tokens.DUMMY;
    }

    @Override
    public Tokens.Token token() {
        return this.token(0);
    }

    @Override
    public Tokens.Token token(int n) {
        if (n == 0) {
            return this.token;
        }
        this.ensureLookahead(n);
        return this.savedTokens.get(n - 1);
    }

    private void ensureLookahead(int n) {
        for (int i = this.savedTokens.size(); i < n; ++i) {
            this.savedTokens.add(this.tokenizer.readToken());
        }
    }

    @Override
    public Tokens.Token prevToken() {
        return this.prevToken;
    }

    @Override
    public void nextToken() {
        this.prevToken = this.token;
        this.token = !this.savedTokens.isEmpty() ? this.savedTokens.remove(0) : this.tokenizer.readToken();
    }

    @Override
    public Tokens.Token split() {
        Tokens.Token[] tokenArray = this.token.split(this.tokens);
        this.prevToken = tokenArray[0];
        this.token = tokenArray[1];
        return this.token;
    }

    @Override
    public Position.LineMap getLineMap() {
        return this.tokenizer.getLineMap();
    }

    @Override
    public int errPos() {
        return this.tokenizer.errPos();
    }

    @Override
    public void errPos(int n) {
        this.tokenizer.errPos(n);
    }
}

