/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import java.io.Writer;
import org.jibx.runtime.ICharacterEscaper;

public class UTF8Escaper
implements ICharacterEscaper {
    private static final UTF8Escaper s_instance = new UTF8Escaper();

    private UTF8Escaper() {
    }

    @Override
    public void writeAttribute(String text, Writer writer) throws IOException {
        int chr;
        int mark = 0;
        for (int i = 0; i < text.length(); i += Character.charCount(chr)) {
            chr = text.codePointAt(i);
            if (chr == 34) {
                writer.write(text, mark, i - mark);
                mark = i + 1;
                writer.write("&quot;");
                continue;
            }
            if (chr == 38) {
                writer.write(text, mark, i - mark);
                mark = i + 1;
                writer.write("&amp;");
                continue;
            }
            if (chr == 60) {
                writer.write(text, mark, i - mark);
                mark = i + 1;
                writer.write("&lt;");
                continue;
            }
            if (chr == 62 && i > 2 && text.charAt(i - 1) == ']' && text.charAt(i - 2) == ']') {
                writer.write(text, mark, i - mark - 2);
                mark = i + 1;
                writer.write("]]&gt;");
                continue;
            }
            if (!(chr < 32 ? chr != 9 && chr != 10 && chr != 13 : chr > 55295 && (chr < 57344 || chr == 65534 || chr == 65535 || chr > 0x10FFFF))) continue;
            throw new IOException("Illegal character code 0x" + Integer.toHexString(chr) + " in attribute value text");
        }
        writer.write(text, mark, text.length() - mark);
    }

    @Override
    public void writeContent(String text, Writer writer) throws IOException {
        int chr;
        int mark = 0;
        for (int i = 0; i < text.length(); i += Character.charCount(chr)) {
            chr = text.codePointAt(i);
            if (chr == 38) {
                writer.write(text, mark, i - mark);
                mark = i + 1;
                writer.write("&amp;");
                continue;
            }
            if (chr == 60) {
                writer.write(text, mark, i - mark);
                mark = i + 1;
                writer.write("&lt;");
                continue;
            }
            if (chr == 62 && i > 2 && text.charAt(i - 1) == ']' && text.charAt(i - 2) == ']') {
                writer.write(text, mark, i - mark - 2);
                mark = i + 1;
                writer.write("]]&gt;");
                continue;
            }
            if (!(chr < 32 ? chr != 9 && chr != 10 && chr != 13 : chr > 55295 && (chr < 57344 || chr == 65534 || chr == 65535 || chr > 0x10FFFF))) continue;
            throw new IOException("Illegal character code 0x" + Integer.toHexString(chr) + " in content text");
        }
        writer.write(text, mark, text.length() - mark);
    }

    @Override
    public void writeCData(String text, Writer writer) throws IOException {
        int chr;
        writer.write("<![CDATA[");
        for (int i = 0; i < text.length(); i += Character.charCount(chr)) {
            chr = text.codePointAt(i);
            if (chr == 62 && i > 2 && text.charAt(i - 1) == ']' && text.charAt(i - 2) == ']') {
                throw new IOException("Sequence \"]]>\" is not allowed within CDATA section text");
            }
            if (!(chr < 32 ? chr != 9 && chr != 10 && chr != 13 : chr > 55295 && (chr < 57344 || chr == 65534 || chr == 65535))) continue;
            throw new IOException("Illegal character code 0x" + Integer.toHexString(chr) + " in CDATA section");
        }
        writer.write(text);
        writer.write("]]>");
    }

    public static ICharacterEscaper getInstance() {
        return s_instance;
    }
}

